/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __VReference__
#define __VReference__

#include <qlist.h>
#include <qstring.h>
#include <qdatetime.h>

class TemplateView;

class VReference
{
	public:
		VReference();
		virtual ~VReference();	
			
		virtual QString name()=0;
		virtual QString type()=0;
		virtual QString path()=0;
		virtual QString url()=0;
		virtual QString serverPath()=0;
		virtual QString binding()=0;
		
		// associated views
		TemplateView *getView();
		void setView(TemplateView *);
		void autoDeleteViews(bool);
		
		TemplateView *getIconView();
		void setIconView(TemplateView *);
		void autoDeleteIconViews(bool);
		
		QList<TemplateView> altViews();
		bool addView(TemplateView *);
		bool removeView(TemplateView *);
		
		QList<TemplateView> altIconViews();
		bool addIconView(TemplateView *);
		bool removeIconView(TemplateView *);
		
		// references
		QList<void> altReferences();
		bool addReference(void *);
		bool removeReference(void *);

		void updateViews(TemplateView *initiator=0);
	protected:
		TemplateView *mainView, *mainIconView;
		QList<TemplateView> iconViews, views;
		QList<void> references;
		bool autoDelViews, autoDelIconViews;
		
};

#endif
