#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <imap4wizardbase.h>

IMAP4WizardBase::IMAP4WizardBase( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QWizard( parent, name, modal, fl )
{
    if ( !name )
      setName( "IMAP4WizardBase" );
    resize( 433, 308 );
    QFont f( font() );
    f.setPointSize( 10 );
    setFont( f );
    setCaption( tr( "Create a new IMAP4 account"  ) );

    userInfo = new QWidget( this, "userInfo" );
    userInfoLayout = new QGridLayout( userInfo );
    userInfoLayout->setSpacing( 6 );
    userInfoLayout->setMargin( 11 );

    nameEdit = new QLineEdit( userInfo, "nameEdit" );

    userInfoLayout->addWidget( nameEdit, 1, 1 );

    emailEdit = new QLineEdit( userInfo, "emailEdit" );
    emailEdit->setMinimumSize( QSize( 0, 0 ) );
    emailEdit->setMaximumSize( QSize( 32767, 32767 ) );
    emailEdit->setEnabled( TRUE );

    userInfoLayout->addWidget( emailEdit, 2, 1 );

    replyEdit = new QLineEdit( userInfo, "replyEdit" );

    userInfoLayout->addWidget( replyEdit, 3, 1 );

    TextLabel16 = new QLabel( userInfo, "TextLabel16" );
    TextLabel16->setText( tr( "Your e-mail address"  ) );

    userInfoLayout->addWidget( TextLabel16, 2, 0 );

    TextLabel17 = new QLabel( userInfo, "TextLabel17" );
    TextLabel17->setText( tr( "Your \"Reply-to\" address (if different)"  ) );

    userInfoLayout->addWidget( TextLabel17, 3, 0 );

    TextLabel15 = new QLabel( userInfo, "TextLabel15" );
    TextLabel15->setText( tr( "Your name:"  ) );

    userInfoLayout->addWidget( TextLabel15, 1, 0 );

    TextLabel1 = new QLabel( userInfo, "TextLabel1" );
    TextLabel1->setText( tr( "<b>Account name:</b>"  ) );

    userInfoLayout->addWidget( TextLabel1, 0, 0 );

    accountNameEdit = new QLineEdit( userInfo, "accountNameEdit" );

    userInfoLayout->addWidget( accountNameEdit, 0, 1 );
    addPage( userInfo, tr( "User information" ) );

    imap4Widget = new QWidget( this, "IMAP4" );
    imap4Layout = new QGridLayout( imap4Widget );
    imap4Layout->setSpacing( 6 );
    imap4Layout->setMargin( 11 );

    TextLabel18 = new QLabel( imap4Widget, "TextLabel18" );
    TextLabel18->setText( tr( "IMAP4 server:"  ) );

    imap4Layout->addWidget( TextLabel18, 0, 0 );

    TextLabel19 = new QLabel( imap4Widget, "TextLabel19" );
    TextLabel19->setText( tr( "Port:"  ) );

    imap4Layout->addWidget( TextLabel19, 0, 3 );

    portEdit = new QLineEdit( imap4Widget, "portEdit" );
    portEdit->setMinimumSize( QSize( 40, 0 ) );
    portEdit->setMaximumSize( QSize( 40, 32767 ) );
    portEdit->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, portEdit->sizePolicy().hasHeightForWidth() ) );
    portEdit->setText( tr( "143"  ) );

    imap4Layout->addWidget( portEdit, 0, 4 );

    imap4Edit = new QLineEdit( imap4Widget, "popEdit" );

    imap4Layout->addMultiCellWidget( imap4Edit, 0, 0, 1, 2 );

    userEdit = new QLineEdit( imap4Widget, "userEdit" );
    userEdit->setMaximumSize( QSize( 130, 22 ) );
    userEdit->setMinimumSize( QSize( 130, 0 ) );

    imap4Layout->addWidget( userEdit, 1, 1 );

    TextLabel20 = new QLabel( imap4Widget, "TextLabel20" );
    TextLabel20->setText( tr( "User name:"  ) );

    imap4Layout->addWidget( TextLabel20, 1, 0 );

    passEdit = new QLineEdit( imap4Widget, "passEdit" );
    passEdit->setMinimumSize( QSize( 130, 0 ) );
    passEdit->setMaximumSize( QSize( 130, 32767 ) );
    passEdit->setEnabled( TRUE );
    passEdit->setEchoMode( QLineEdit::Password );

    imap4Layout->addWidget( passEdit, 2, 1 );

    TextLabel21 = new QLabel( imap4Widget, "TextLabel21" );
    TextLabel21->setText( tr( "Password:"  ) );

    imap4Layout->addWidget( TextLabel21, 2, 0 );

    passCheck = new QCheckBox( imap4Widget, "passCheck" );
    passCheck->setText( tr( "Remember password"  ) );
    passCheck->setChecked( TRUE );

    imap4Layout->addMultiCellWidget( passCheck, 3, 3, 0, 1 );

    syncCheck = new QCheckBox( imap4Widget, "syncCheck" );
    syncCheck->setText( tr( "Sync with server on delete"  ) );

    imap4Layout->addMultiCellWidget( syncCheck, 5, 5, 0, 1 );

    sortCheck = new QCheckBox( imap4Widget, "sortCheck" );
    sortCheck->setText( tr( "Sort messages before downloading"  ) );

    imap4Layout->addMultiCellWidget( sortCheck, 6, 6, 0, 1 );

    leaveCheck = new QCheckBox( imap4Widget, "leaveCheck" );
    leaveCheck->setText( tr( "Leave messages on server"  ) );
    leaveCheck->setChecked( TRUE );

    imap4Layout->addMultiCellWidget( leaveCheck, 4, 4, 0, 1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    imap4Layout->addMultiCell( spacer, 3, 3, 2, 4 );
    addPage( imap4Widget, tr( "IMAP server information" ) );

    SMTP = new QWidget( this, "SMTP" );
    SMTPLayout = new QGridLayout( SMTP );
    SMTPLayout->setSpacing( 6 );
    SMTPLayout->setMargin( 11 );

    TextLabel22 = new QLabel( SMTP, "TextLabel22" );
    TextLabel22->setText( tr( "SMTP server:"  ) );

    SMTPLayout->addWidget( TextLabel22, 0, 0 );

    smtpPortEdit = new QLineEdit( SMTP, "smtpPortEdit" );
    smtpPortEdit->setMinimumSize( QSize( 40, 0 ) );
    smtpPortEdit->setMaximumSize( QSize( 40, 32767 ) );
    smtpPortEdit->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, smtpPortEdit->sizePolicy().hasHeightForWidth() ) );
    smtpPortEdit->setText( tr( "25"  ) );

    SMTPLayout->addWidget( smtpPortEdit, 0, 3 );

    smtpEdit = new QLineEdit( SMTP, "smtpEdit" );

    SMTPLayout->addWidget( smtpEdit, 0, 1 );

    TextLabel23 = new QLabel( SMTP, "TextLabel23" );
    TextLabel23->setText( tr( "Port:"  ) );

    SMTPLayout->addWidget( TextLabel23, 0, 2 );
    addPage( SMTP, tr( "SMTP server information" ) );

    // signals and slots connections
    connect( nameEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( nameChanged(const QString &) ) );
    connect( emailEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( emailChanged(const QString &) ) );
    connect( replyEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( replyChanged(const QString &) ) );
    connect( imap4Edit, SIGNAL( textChanged(const QString&) ), this, SLOT( imap4Changed(const QString &) ) );
    connect( portEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( imap4PortChanged(const QString &) ) );
    connect( userEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( userChanged(const QString &) ) );
    connect( passEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( passChanged(const QString &) ) );
    connect( passCheck, SIGNAL( clicked() ), this, SLOT( passClicked() ) );
    connect( leaveCheck, SIGNAL( clicked() ), this, SLOT( leaveClicked() ) );
    connect( smtpEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( smtpChanged(const QString &) ) );
    connect( smtpPortEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( smtpPortChanged(const QString &) ) );
    connect( syncCheck, SIGNAL( clicked() ), this, SLOT( syncClicked() ) );
    connect( sortCheck, SIGNAL( clicked() ), this, SLOT( sortClicked() ) );
    connect( accountNameEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( accountNameChanged(const QString &) ) );

    // tab order
    setTabOrder( nameEdit, emailEdit );
    setTabOrder( emailEdit, replyEdit );
    setTabOrder( replyEdit, imap4Edit );
    setTabOrder( imap4Edit, portEdit );
    setTabOrder( portEdit, userEdit );
    setTabOrder( userEdit, passEdit );
    setTabOrder( passEdit, passCheck );
    setTabOrder( passCheck, leaveCheck );
    setTabOrder( leaveCheck, smtpEdit );
    setTabOrder( smtpEdit, smtpPortEdit );
}

/*
 *  Destroys the object and frees any allocated resources
 */
IMAP4WizardBase::~IMAP4WizardBase()
{
    // no need to delete child widgets, Qt does it all for us
}

void IMAP4WizardBase::accountNameChanged(const QString &)
{
    qWarning( "IMAP4WizardBase::accountNameChanged(const QString &): Not implemented yet!" );
}

void IMAP4WizardBase::emailChanged(const QString &)
{
    qWarning( "IMAP4WizardBase::emailChanged(const QString &): Not implemented yet!" );
}

void IMAP4WizardBase::leaveClicked()
{
    qWarning( "IMAP4WizardBase::leaveClicked(): Not implemented yet!" );
}

void IMAP4WizardBase::nameChanged(const QString &)
{
    qWarning( "IMAP4WizardBase::nameChanged(const QString &): Not implemented yet!" );
}

void IMAP4WizardBase::passChanged(const QString &)
{
    qWarning( "IMAP4WizardBase::passChanged(const QString &): Not implemented yet!" );
}

void IMAP4WizardBase::passClicked()
{
    qWarning( "IMAP4WizardBase::passClicked(): Not implemented yet!" );
}

void IMAP4WizardBase::imap4Changed(const QString &)
{
    qWarning( "IMAP4WizardBase::imap4Changed(const QString &): Not implemented yet!" );
}

void IMAP4WizardBase::imap4PortChanged(const QString &)
{
    qWarning( "IMAP4WizardBase::imap4PortChanged(const QString &): Not implemented yet!" );
}

void IMAP4WizardBase::replyChanged(const QString &)
{
    qWarning( "IMAP4WizardBase::replyChanged(const QString &): Not implemented yet!" );
}

void IMAP4WizardBase::smtpChanged(const QString &)
{
    qWarning( "IMAP4WizardBase::smtpChanged(const QString &): Not implemented yet!" );
}

void IMAP4WizardBase::smtpPortChanged(const QString &)
{
    qWarning( "IMAP4WizardBase::smtpPortChanged(const QString &): Not implemented yet!" );
}

void IMAP4WizardBase::sortClicked()
{
    qWarning( "IMAP4WizardBase::sortClicked(): Not implemented yet!" );
}

void IMAP4WizardBase::syncClicked()
{
    qWarning( "IMAP4WizardBase::syncClicked(): Not implemented yet!" );
}

void IMAP4WizardBase::userChanged(const QString &)
{
    qWarning( "IMAP4WizardBase::userChanged(const QString &): Not implemented yet!" );
}



