/* 
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-23 13:29:49 +0200 by michael johnston
   
   Application Controller

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _ULPASTEBOARD_
#define _ULPASTEBOARD_

#include <AppKit/AppKit.h>

/**
Userland objects use ULPasteboard to exchange model objects between
themselves. It is like NSPasteboard except customised to the
specific requirements of the program.
\note Update to handle both single and mulitple selection

\ingroup interface
*/

@interface ULPasteboard: NSObject
{
	id pasteboardOwner;
	int changeCount;
}
+ (id) appPasteboard;
/**
An array of the available model object types or
nil if no objects are available.
*/
- (NSArray*) availableTypes;
/**
Scans the the specified types in \e anArray
for one that is present returning the first
match or nil if no match is found.
*/
- (NSString*) availableTypeFromArray: (NSArray*) anArray;
/**
Returns the first available object of type \e type
*/
- (id) objectForType: (NSString*) type;
/**
Returns an array containing the objects of type \e type
that are available
*/
- (NSArray*) objectsForType: (NSString*) type;
/**
Returns the number of objects of type \e type that are 
available
*/
- (int) countOfObjectsForType: (NSString*) type;
/**
Sets the owner of the pasteboard
*/
- (void) setPasteboardOwner: (id) object;
/**
Change count is incremented by one every time a new
owner takes control of the pasteboard
*/
- (int) changeCount;
@end

#endif
