/* 
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-23 13:29:49 +0200 by michael johnston
   
   Application Controller

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
 
#ifndef _PCAPPPROJ_APPCONTROLLER_H
#define _PCAPPPROJ_APPCONTROLLER_H

#include <AppKit/AppKit.h>
#include "ULFramework/ULModelController.h"
#include "ULOptionsViewController.h"
#include "ULSystemViewController.h"
#include "ULAnalyser.h"
#include "ULPreferences.h"
#include "ULStatusTable.h"
#include "ULDatabaseBrowser.h"
#include "ULTemplateViewController.h"
#include "ULPasteboard.h"

/**
ViewController is the main view controller class. It creates and contains the 
ULModelController instance and facilitates the transfer of information from
this to the other view-controller classes. It controls the 'Adun Status' window
and is responisble for displaying general information from the model aswell as spawning
simulations.

\todo Improve logging formating
\todo Implement proper deallocing of program on exit.
\todo All objects should be displayable i.e. should respond to the "display" command.
\ingroup interface
*/

@interface ViewController : NSObject
{
	id modelController;	//<! The ULModelController instance
	id processManager;
	id optionsViewController;	//!< The ULOptionsViewController instance
	id systemViewController;	//!< The ULSystemViewController instance
	id analyser;
	id templateController;
	id databaseBrowser;
	id preferencesPanel;
	id optionsField;
	id systemField;
	id statusTable;
	id selectHostButton;	//<! The popup button containing the host list
	id createSimulationWindow; 	//<! The window for selecting a host
	id host;		//<! The selected host
	id statusWindow;
	id logOutput;
	id splashScreen;
	id splashScreenImageView;
	id activeDelegate;
	id objectActions;
	id simulationCommands;
	id appPasteboard;
	//temporary
	id systems;
	id options;
	NSMutableDictionary* allowedActions;
}

+ (void)initialize;

- (id)init;
- (void)dealloc;
- (void)awakeFromNib;
- (void)applicationDidFinishLaunching:(NSNotification *)aNotif;
- (BOOL)applicationShouldTerminate:(id)sender;
- (void)applicationWillTerminate:(NSNotification *)aNotif;
- (BOOL)application:(NSApplication *)application openFile:(NSString *)fileName;
- (void)showPrefPanel:(id)sender;
- (void) newSystem: (id) sender;
- (void) newOptions: (id) sender;
- (void) logString: (NSString*) string newline: (BOOL) newline;
- (void) logString: (NSString*) string newline: (BOOL) newline forProcess: (ULProcess*) process;
- (id) metadataController;
- (void) startAdunServer;
- (void) openAnalyser: (id) sender;

@end

@interface ViewController (SimulationCreation)
- (void) createProcess: (id) sender;
- (void) closeCreateSimulationWindow: (id) sender;
- (void) createNewSimulation: (id) sender;
- (void) load: (id) sender;
@end

#endif
