/* 
   Project: UL

   Copyright (C) 2006 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2006-06-01 10:15:49 +0200 by michael johnston
   
   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include <AppKit/AppKit.h>
#include "ULTemplateViewController.h"

/**
Delegate and data source for the interactions table
*/
@interface InteractionsTableDelegate: NSObject
@end

@implementation ULTemplateViewController

- (id) init
{
	if(self = [super init])
	{
		if([NSBundle loadNibNamed: @"Template" owner: self] == NO)
		{
			NSWarnLog(@"Problem loading interface");
			return nil;
		}

		interactionsTableDelegate = [InteractionsTableDelegate new];
	}	

	return self;
}

- (void) dealloc
{
	[interactionsTableDelegate release];
	[super dealloc];
}

- (void) awakeFromNib
{
	id columns, column, item;
	NSEnumerator* columnEnum;

	[interactionsTable setDataSource: interactionsTableDelegate];
	columns = [interactionsTable tableColumns];
	columnEnum = [columns objectEnumerator];
	while(column = [columnEnum nextObject])
	{
		if([[column dataCell] isKindOfClass: [NSButtonCell class]])
		{
			[(NSButtonCell*)[column dataCell] setButtonType: NSRadioButton];
			[(NSButtonCell*)[column dataCell] setImagePosition: NSImageOnly];
			[(NSButtonCell*)[column dataCell] setTitle: nil];
		}
	}

	[tabView selectTabViewItemWithIdentifier: @"Components"];
	item = [tabView selectedTabViewItem];
	[tabView removeTabViewItem: item];
	[tabView insertTabViewItem: item atIndex: 0];
}

- (void) open: (id) sender
{
	[templateWindow makeKeyAndOrderFront: self];
}

- (void) create: (id)sender
{
  /* insert your code here */
}


- (void) cancel: (id)sender
{
  /* insert your code here */
}

@end

@implementation InteractionsTableDelegate

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	return 4;
}

- (id)tableView:(NSTableView *)aTableView
	 objectValueForTableColumn:(NSTableColumn *)aTableColumn 
	row:(int)rowIndex
{

	return [NSNumber numberWithInt: NSOnState];
}

@end

