/* Copyright 2003  Alexander V. Diemand

    This file is part of MolTalk.

    MolTalk is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MolTalk is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MolTalk; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

/* vim: set filetype=objc: */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "privateChain.oh"
#include "Chain.oh"
#include "Coordinates.oh"
#include "Structure.oh"


@implementation Chain (Private)


-(void)setStructure:(Structure*)p_strx	//@nodoc
{
	strx = p_strx;
}


-(void)setCode:(char)p_code	//@nodoc
{
	code = p_code;
}


-(void)setSource:(NSString*)p_src	//@nodoc
{
	RETAIN(p_src);
	if (source)
	{
		RELEASE(source);
	}
	source = p_src;
}


-(void)setCompound:(NSString*)p_cmpnd	//@nodoc
{
	RETAIN(p_cmpnd);
	if (compound)
	{
		RELEASE(compound);
	}
	compound = p_cmpnd;
}


-(void)setECCode:(NSString*)p_ecc	//@nodoc
{
	RETAIN(p_ecc);
	if (eccode)
	{
		RELEASE(eccode);
	}
	eccode = p_ecc;
}


-(void)setSeqres:(NSString*)p_seqres	//@nodoc
{
	RETAIN(p_seqres);
	if (seqres)
	{
		RELEASE(seqres);
	}
	seqres = p_seqres;
}


-(void)enterHashAtom:(Coordinates*)atm for:(Residue*)res
{
	double x,y,z;
	NSNumber *hashvalue;

	x = [atm x]; y = [atm y]; z = [atm z];
	hashvalue = [self mkCoordinatesHashX:x Y:y Z:z];
	[self enterHashValue:hashvalue for:res];

	hashvalue = [self mkCoordinatesHashX:(x+hash_value_offset) Y:(y+hash_value_offset) Z:(z+hash_value_offset)];
	[self enterHashValue:hashvalue for:res];
	hashvalue = [self mkCoordinatesHashX:(x-hash_value_offset) Y:(y+hash_value_offset) Z:(z+hash_value_offset)];
	[self enterHashValue:hashvalue for:res];
	hashvalue = [self mkCoordinatesHashX:(x-hash_value_offset) Y:(y-hash_value_offset) Z:(z+hash_value_offset)];
	[self enterHashValue:hashvalue for:res];
	hashvalue = [self mkCoordinatesHashX:(x-hash_value_offset) Y:(y-hash_value_offset) Z:(z-hash_value_offset)];
	[self enterHashValue:hashvalue for:res];
	hashvalue = [self mkCoordinatesHashX:(x+hash_value_offset) Y:(y-hash_value_offset) Z:(z+hash_value_offset)];
	[self enterHashValue:hashvalue for:res];
	hashvalue = [self mkCoordinatesHashX:(x+hash_value_offset) Y:(y-hash_value_offset) Z:(z-hash_value_offset)];
	[self enterHashValue:hashvalue for:res];
	hashvalue = [self mkCoordinatesHashX:(x+hash_value_offset) Y:(y+hash_value_offset) Z:(z-hash_value_offset)];
	[self enterHashValue:hashvalue for:res];
	hashvalue = [self mkCoordinatesHashX:(x-hash_value_offset) Y:(y+hash_value_offset) Z:(z-hash_value_offset)];
	[self enterHashValue:hashvalue for:res];
}


-(void)enterHashValue:(NSNumber*)hashvalue for:(Residue*)res
{
	NSMutableArray *t_arr;
	t_arr = [residuehash objectForKey: hashvalue];
	if (!t_arr)
	{
		t_arr = [NSMutableArray new];
		[residuehash setObject: t_arr forKey: hashvalue];
	}
	if (! [t_arr containsObject: res])
	{
		[t_arr addObject: res];
	}
}





@end

