/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
/** \file **/
#ifndef ADUN_NONBONDED
#define ADUN_NONBONDED

#include "Base/AdLinkedList.h"
#include "Base/InterTable.h"
#include "AdunKernel/AdDataSources.h"
#include "AdunKernel/AdunEnvironment.h"
#include "AdunKernel/AdunSystemComponent.h"
#include "AdunKernel/AdunDefinitions.h"
#include "AdunKernel/AdunNonBondedListHandler.h"

/**
**/

/*!
\ingroup Inter
AdNonbonded manages a set of pairwise nonbonded interactions of a system.
In Adun NonBonded interaction lists are linked lists of ListElement structs (see LinkedList.h) so you have to wrap them in an 
NSValue object to pass them around. 
*/


@interface AdNonBondedTopology: AdSystemComponent
{	
	ListElement* in_p;
	AdMatrix *coordinates;
	InterTable* parameters;
	NSArray* interactions;
	NSArray* interactionTypes;
	NSDictionary* interactionDict;
	id listHandler;
}

@end

#endif

