/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
/** \file **/
#ifndef ADUN_DYNAMICS
#define ADUN_DYNAMICS

#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#include "AdunKernel/AdDelegation.h"
#include "AdunKernel/AdUpdating.h"
#include "AdunKernel/AdDataSources.h"
#include "AdunKernel/AdunDefinitions.h"
#include "AdunKernel/AdunIOManager.h"
#include "AdunKernel/AdunMemoryManager.h"
#include "AdunKernel/AdunSystemComponent.h"

/**
**/

/*!
\ingroup Inter
AdDynamics is the Framework object for dynamical information on a collection of
particles i.e. coordinates, velocities and accelerations
\note Changing the value of TargetTemperature or Seed in Environment will only
affect the object (through key value observing) when reloadData is next called and then only if the dataSource
delegate doesnt provide velocity information.
\todo When unarchiving AdDynamics currently assumes it was created with an environment and registered with it.
Change so it recreates itself in exactly the same way as it was encoded.
*/

@interface AdDynamics: AdSystemComponent <AdMemento>
{
	BOOL memento;
	BOOL ownsVelocities;
	BOOL ownsAccelerations;
	int seed;
	int numberOfAtoms;
	double mass;
	double targetTemperature;
	double* centreOfMass;
	AdMatrix* coordinates;
	AdMatrix* velocities;
	AdMatrix* accelerations;
	NSArray* atomTypes;
	NSString* currentCaptureMethod;
	id memoryManager;
}


//translating coordinates
- (void) moveCentreOfMassToOrigin;
- (void) centerOnPoint: (double*) point;
- (void) centerOnAtom: (int) atom;
- (void) zeroAccelerations;
- (int) numberOfAtoms;
- (NSArray*) atomTypes;
- (NSArray*) atomMasses;
- (NSValue*) coordinates;
- (NSValue*) velocities;
- (NSValue*) accelerations;	
- (double) mass;
- (double*) centreOfMass;
- (int) seed;
- (void) setSeed: (int) aNumber;
- (double) targetTemperature;
- (void) setTargetTemperature: (double) aNumber;
@end

#endif

