/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-23 11:06:55 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _NEWTONIAN_SIMULATOR_
#define _NEWTONIAN_SIMULATOR_

#include <math.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#include "AdunKernel/AdunDefinitions.h"
#include "AdunKernel/AdunKernel.h"

/**
NewtonianSimulator performs simulations of a system
based on newtonian dynamics. The integration algorithm used is velocity verlet.
The Berendsen thermostat is used implicitly.

\todo Factor out the thermostat portions of the algorithm if possible. This
will allow NewtonianSimulator to use a wide variety of different thermostats
e.g. Nose-Hoover, constant pressure berendsen etc. These object would
act as delegates and be sent a message before each step of velocity-verlet
algorithm allowing it to take action. (Obviously the termostat must be adapted
to velocity verlet)

\ingroup Cinter
**/

@interface NewtonianSimulator: AdSimulator
{
	double coupling_fac;
	double time_p_coup;
}

/**
Set the coupling factor to be used for the Berendsen
thermostat. N.B. The value must be in femtoseconds.
*/
- (void) setCouplingFactor: (double) value;
/**
The current value of the berendsen thermostat coupling factor
in femtoseconds
*/
- (double) couplingFactor;
@end
#endif
