/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-23 11:06:55 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
/** \file **/
#ifndef ENZYMIX_FORCE_FIELD
#define ENZYMIX_FORCE_FIELD

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdbool.h>
#include "Base/AdVector.h"
#include "Base/InterTable.h"
#include "Base/AdLinkedList.h"
#include "Base/AdForceFieldFunctions.h"
#include "AdunKernel/AdunKernel.h"
#include "PureNonBondedCalculator.h"
#include "SCAAS.h"

/** 
Force field object for the enzymix force field with SCAAS
\ingroup Cinter
\note add notifications
\note add observations
**/


@interface EnzymixForceField: AdForceField
{	
	int no_of_atoms;
	BOOL harmonicBond;
	BOOL harmonicAngle;
	BOOL fourierTorsion;
	BOOL improperTorsion;
	BOOL nonbonded;
	BOOL longRange;
	double bnd_pot;
	double ang_pot;
	double tor_pot;
	double itor_pot;
	double vdw_pot;
	double est_pot;
	double total_energy;
	InterTable *bonds;
	InterTable *angles;
	InterTable *torsions;
	InterTable *improperTorsions;
	AdMatrix* coordinateMatrix;
	AdMatrix* accelerationMatrix;
	ListElement* nonbnd_p;
	ListElement* longRangeInteractions;
	id system;
	id nonbondedCalculator;  
	id longRangeNonbondedCalculator;
	id systemKeywords;
	id coreTerms;		//the core terms of the force field
	id availableTerms;	//the core terms that the current system provides information for
	id state;		//the current state of the simulator
	id customTerms;
	id bondedInteractions;
	id nonbondedInteractionTypes;
}
- (id) availableTerms;
@end

#endif

