Given /^a target source named "(.*)" with:$/ do |src_name, content|
  write_file(src_name, content + "\n")
end

Given /^expected messages of "(.*)" are:$/ do |src_name, mesg_table|
  write_file("#{src_name}.expected", mesg_table.hashes.map { |row|
    "#{row[:mesg]} #{row[:line]} #{row[:column]}" }.join("\n"))
end

When /^I successfully run `(.*)` on noarch$/ do |abbrev_cmd|
  write_file("noarch_traits.yml", NOARCH_TRAITS)
  write_file("empty_pinit.h", "\n")
  write_file("empty_cinit.h", "\n")
  run_simple(unescape(abbrev_cmd + " -t noarch_traits.yml"))
end

Then /^the output should match with \/(.*)\/$/ do |pattern|
  all_output.should =~ /#{pattern}/
end

Then /^the output should not match with \/(.*)\/$/ do |pattern|
  all_output.should_not =~ /#{pattern}/
end

Then /^the output should match with expected messages of "(.*)"$/ do |src_name|
  prep_for_fs_check do
    expected = File.read("#{src_name}.expected").each_line.map { |line|
      fields = line.chomp.split(" ")
      /#{fields[1]}:#{fields[2]}:.*:#{fields[0]}/
    }
    all_output.each_line.zip(expected).each do |line, pattern|
      line.should =~ pattern
    end
  end
end

Then /^the output should exactly match with:$/ do |mesg_table|
  all_output.each_line.zip(mesg_table.hashes).each do |line, row|
    if row
      line.should =~ /#{row[:line]}:#{row[:column]}:.*:#{row[:mesg]}/
    else
      line.should =~ /::.*:/
    end
  end
end
