separate (T_Declarations)
procedure Test_Anonymous_Subtype is            -- nested_procedure, local_procedure
   subtype Int is Integer range 1 .. 10;       -- subtype
   subtype IntOK is Integer;                   -- subtype, unconstrained_subtype
   subtype Ws is Wide_String (1 .. 200);       -- subtype, anonymous_subtype_declaration
   subtype WsOK is Wide_String (Int);          -- subtype
   I : constant Int range 1 .. 5 := 3;         -- constant, anonymous_subtype_declaration
   IOK : constant Int := 3;                    -- constant
   V1 : Wide_String (1 .. 200);                -- variable, constrained_array_variable, array, uninitialized_variable, anonymous_subtype_declaration (x2)
   V2 : Wide_String (Natural range 1 .. 200);  -- variable, constrained_array_variable, array, uninitialized_variable, anonymous_subtype_declaration (x2)
   V3 : Wide_String (V2'Range);                -- variable, constrained_array_variable, array, uninitialized_variable, anonymous_subtype_declaration (x2)
   V4  : Wide_String (Int);                    -- variable, constrained_array_variable, array, uninitialized_variable, anonymous_subtype_declaration
   VOK : WS;                                   -- variable, constrained_array_variable, array, uninitialized_variable
   type T is access Integer range 1 .. 10;     -- access_type, anonymous_subtype_declaration
   type Int2 is new Integer range 1..10;       -- derived_type, anonymous_subtype_declaration
   type Rec (D : Integer) is                   -- ordinary_record_type, record_type, discriminant
      record
         C : Integer range 0 .. 100;           -- uninitialized_record_field, anonymous_subtype_declaration
      end record;
   type Acc_Rec is access Rec;                 -- access_type
   Acc : Acc_Rec;                              -- variable, uninitialized_variable

   J : Integer;                                -- variable, uninitialized_variable
begin
   for I in Natural range 1 .. 10 loop         -- anonymous_subtype_for
      null;
   end loop;
   for I in 1 .. 10 loop                       -- anonymous_subtype_for
      null;
   end loop;
   for I in Int loop
      null;
   end loop;

   case J is
      when Int =>
         null;
      when 11 .. 20 =>                         -- anonymous_subtype_case
         null;
      when Integer range 21 .. 30 =>           -- anonymous_subtype_case
         null;
      when others =>
         null;
   end case;

   V1 (1..10) := (others => 'a');              -- anonymous_subtype_indexing
   V1 (Int)   := (others => 'a');              --
   V2 (Natural range 1..10) := (1..10 => 'a'); -- anonymous_subtype_indexing (x2)

   Acc := new Rec (2);                         -- anonymous_subtype_allocator
end Test_Anonymous_Subtype;
