#!/bin/sh

SPAN=32

grep -q off-line /proc/acpi/ac_adapter/*/state
if [ $? = 0 ]
   then
   INTERFACE="dc_brightness"
else
   INTERFACE="ac_brightness"
fi

BRIGHTNESS=$(( `cat /proc/acpi/pcc/$INTERFACE` + 0 ))
MAXBRIGHT=$(( `cat /proc/acpi/pcc/"$INTERFACE"_max` - $SPAN))
MINBRIGHT=$(( `cat /proc/acpi/pcc/"$INTERFACE"_min` + $SPAN))

if [ "x$1" = "xdown" ]; then
   if [ $BRIGHTNESS -gt $MINBRIGHT ]; then
      BRIGHTNESS=$(( $BRIGHTNESS - $SPAN ))
   else
      BRIGHTNESS=$(( $MINBRIGHT - $SPAN ))
   fi
   echo $BRIGHTNESS > /proc/acpi/pcc/$INTERFACE
elif [ "x$1" = "xup" ]; then
   if [ $BRIGHTNESS -lt $MAXBRIGHT ]; then
      BRIGHTNESS=$(( $BRIGHTNESS + $SPAN ))
   else
      BRIGHTNESS=$(( $MAXBRIGHT + $SPAN ))
   fi
   echo $BRIGHTNESS > /proc/acpi/pcc/$INTERFACE
else
   echo >&2 Unknown argument $1
fi
