/**
 * @file ORB_Task.cpp
 *
 * $Id: ORB_Task.cpp 76591 2007-01-25 18:17:52Z elliott_c $
 *
 * @author Carlos O'Ryan <coryan@atdesk.com>
 *
 */
#include "ORB_Task.h"
#include "tao/Environment.h"

ACE_RCSID(Bug_1270_Regression, ORB_Task, "$Id: ORB_Task.cpp 76591 2007-01-25 18:17:52Z elliott_c $")

ORB_Task::ORB_Task (CORBA::ORB_ptr orb)
  : orb_ (CORBA::ORB::_duplicate (orb))
{
}

int
ORB_Task::svc (void)
{
  try
    {
      this->orb_->run ();
    }
  catch (const CORBA::Exception& )
    {
    }
  return 0;
}
