/* -*- C++ -*- */

//=============================================================================
/**
 *  @file PortableServer.h
 *
 *  PortableServer.h,v 1.11 2005/07/04 12:05:28 jwillemsen Exp
 *
 *  @author Carlos O'Ryan <coryan@uci.edu>
 */
//=============================================================================

#ifndef TAO_PORTABLESERVER_H
#define TAO_PORTABLESERVER_H

#include /**/ "ace/pre.h"

#include "portableserver_export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

class TAO_PortableServer_Export TAO_POA_Initializer
{
public:
  /// Used to force the initialization of the ORB code.
  static int init (void);
};

static int
TAO_Requires_POA_Initializer = TAO_POA_Initializer::init ();

#define TAO_PORTABLESERVER_SAFE_INCLUDE
#include "PortableServerC.h"
#undef TAO_PORTABLESERVER_SAFE_INCLUDE
#include "POAManagerC.h"
#include "PortableServer_Functions.h"
#include "PortableServer_WFunctions.h"

#include /**/ "ace/post.h"

#endif /* TAO_PORTABLESERVER_H */
