// -*- C++ -*-

//=============================================================================
/**
 *  @file   Collocation_Proxy_Broker.h
 *
 *  Collocation_Proxy_Broker.h,v 1.6 2005/06/15 17:54:33 jwillemsen Exp
 *
 *
 *  @author Balachandran Natarajan <bala@dre.vanderbilt.edu>
 */
//=============================================================================

#ifndef TAO_COLLOCATION_PROXY_BROKER_H
#define TAO_COLLOCATION_PROXY_BROKER_H

#include /**/ "ace/pre.h"

#include "tao/TAO_Export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "ace/CORBA_macros.h"
#include "ace/os_include/os_stddef.h"
#include "tao/Collocation_Strategy.h"


template<typename T> class TAO_Pseudo_Var_T;
template <typename T, typename T_var> class TAO_Pseudo_Out_T;

namespace CORBA
{
  class Object;
  typedef Object *Object_ptr;
  typedef TAO_Pseudo_Var_T<Object> Object_var;
  typedef TAO_Pseudo_Out_T<Object, Object_var> Object_out;
  class Environment;
}

namespace TAO
{
  class Argument;

  /**
   * @class Collocation_Proxy_Broker
   */
  class TAO_Export Collocation_Proxy_Broker
  {

  public:

    virtual ~Collocation_Proxy_Broker (void);

    virtual Collocation_Strategy get_strategy (CORBA::Object_ptr obj
                                               ACE_ENV_ARG_DECL) = 0;

    virtual void dispatch (CORBA::Object_ptr obj,
                           CORBA::Object_out forward_obj,
                           Argument ** args,
                           int num_args,
                           const char * op,
                           size_t op_len,
                           Collocation_Strategy strategy
                           ACE_ENV_ARG_DECL) = 0;
  };
}

#include /**/ "ace/post.h"

#endif /*TAO_COLLOCATION_PROXY_BROKER_H */
