
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: mouse.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#ifdef HAVE_MOUSE

#include "aca.h"

#include <stdlib.h>
#include <unistd.h>        /* select(); */
#include <sys/time.h>      /* timeval   */
#include <sys/types.h>     /* socket()  */
#include <sys/stat.h>
#include <fcntl.h>
#include <gpm.h>

#include "mouse.h"

#define SELECT_TIME	86400		/* orig. gpm setting */

#define GET(win) ((win) ? wgetch(win) : getch())

   int		mouse_fd= 1;
   Gpm_Connect	conn;

   int mouse_handler(Gpm_Event *event, void *data)
   {
      Gpm_DrawPointer(event->x, event->y, mouse_fd);
   
      if (event->type & GPM_DOWN) {
         aca.mouse_x = event->x-1;
         aca.mouse_y = event->y-1;
         if      (event->buttons & GPM_B_LEFT)	
            return K_MOUSE_L;
         else if (event->buttons & GPM_B_MIDDLE)	
            return K_MOUSE_M;
         else 					
            return K_MOUSE_R;
      }
      return K_MOUSE_NOT;		
   }

   int init_mouse()
   {
      if (mouse_fd)
         mouse_fd = open(ttyname(0), O_RDWR); 
   
      conn.eventMask=~0;
      conn.defaultMask=0;
      conn.maxMod=~0;
      conn.minMod=0;
   
      if (Gpm_Open(&conn, 0) == -1) 
         aca.mouse = FALSE;
      else
         aca.mouse = TRUE;			
   
      gpm_handler = mouse_handler;
      atexit((void *) Gpm_Close);
      return(RE_OK);
   }

   int aca_Gpm_Wgetch(WINDOW *win)
   {
      fd_set selSet;
      int max, flag, result;
      int fd=STDIN_FILENO;
      static Gpm_Event ev;
   
      if (!gpm_flag || gpm_fd==-1) 
         return GET(win);
      if (gpm_morekeys) 
         return (*gpm_handler)(&ev,gpm_data);
      gpm_hflag=0;
   
      max = (gpm_fd>fd) ? gpm_fd : fd;
   
   /*...................................................................*/
      if (gpm_fd>=0)                                            /* linux */
         while(1) {
            if (gpm_visiblepointer) GPM_DRAWPOINTER(&ev);
         
            if (!win->_notimeout && win->_delay >= 0) {
               FD_ZERO(&selSet);
               FD_SET(fd,&selSet);
               FD_SET(gpm_fd,&selSet);
            
            /* Count to microseconds 
               - curses timer (_delay) is in milliseconds */
               
               gpm_timeout.tv_sec  = 10;
               gpm_timeout.tv_usec = win->_delay * 1000;		
               flag=select(max+1,&selSet,(fd_set *)NULL,(fd_set *)NULL,&gpm_timeout);

               if (FD_ISSET(fd,&selSet))
                  return GET(win);
            
               if (!flag)
                  return ERR;
            } else {
               do {
                  FD_ZERO(&selSet);
                  FD_SET(fd,&selSet);
                  FD_SET(gpm_fd,&selSet);
                  gpm_timeout.tv_sec=SELECT_TIME;
                  flag=select(max+1,&selSet,(fd_set *)NULL,(fd_set *)NULL,&gpm_timeout);
               } while (!flag);
            
               if (FD_ISSET(fd,&selSet))
                  return GET(win);
            
               if (flag==-1)
                  continue;
            } 
         
            if (Gpm_GetEvent(&ev) && gpm_handler
            && (result=(*gpm_handler)(&ev,gpm_data)))
            {
               gpm_hflag=1;
               return result;
            }
         }
      else
      /*...................................................................*/
         if (gpm_fd==-2)                                           /* xterm */
         {
         #define DELAY_MS 100
            static struct timeval to={0,DELAY_MS*1000};
            static fd_set selSet;
            static int prevchar=EOF;
            extern int gpm_convert_event(char *data, Gpm_Event *event);
            int c; char mdata[4];
         
            if ((c=prevchar)!=EOF)  /* if ungetc() didn't suffice... */
            {
               prevchar=EOF;
               return c;
            }
         
            while(1)
            {
               do 
               {
                  FD_ZERO(&selSet); FD_SET(fd,&selSet);
                  gpm_timeout.tv_sec=SELECT_TIME;
                  flag=select(fd+1,&selSet,(fd_set *)NULL,(fd_set *)NULL,&gpm_timeout);
               }
               while (!flag);
            
               if ((c=GET(win))!=0x1b) 
                  return c;
            
            /* escape: go on */
               FD_ZERO(&selSet); FD_SET(fd,&selSet); to.tv_usec=DELAY_MS*1000;
               if ((flag=select(fd+1,&selSet,(fd_set *)NULL,(fd_set *)NULL,&to))==0)
                  return c;
               if ((c=GET(win))!='[')
               {ungetc(c,stdin); 
                  return 0x1B;}
            
            /* '[': go on */
               FD_ZERO(&selSet); FD_SET(fd,&selSet); to.tv_usec=DELAY_MS*1000;
               if ((flag=select(fd+1,&selSet,(fd_set *)NULL,(fd_set *)NULL,&to))==0)
               {ungetc(c,stdin); 
                  return 0x1B;}
               if ((c=GET(win))!='M')
               {ungetc(c,stdin);prevchar='['; 
                  return 0x1B;}
            
            /* now, it surely is a mouse event */
            
               for (c=0;c<3;c++) mdata[c]=GET(win);
               gpm_convert_event(mdata,&ev);
            
               if (gpm_handler && (result=(*gpm_handler)(&ev,gpm_data)))
               {
                  gpm_hflag=1;
                  return result;
               }
            } /* while(1) */
         }
      return 0;
   }

#endif /* HAVE_MOUSE */