//$Id: canvas_interf.cc,v 1.12 1998/08/06 21:08:39 aml Exp $

#include "sheet.hh"
#include "canvas.hh"

extern Tk_Item *lastItemCreated;
struct canvas *global_canvas_info;


void newCanvas(Canvas *c, Tcl_Interp *interp,char *canvas,int width,int height) {
  register Interp *iPtr = (Interp *) interp;
  int i;

  c->x_origin = 0;
  c->y_origin = 0;
  c->cmdPtr = NULL;

  c->col_origin = new int[width+1];
  for(i=0; i<width+1; i++) {
      c->col_origin[i] = i*DEFCELLWIDTH;
  }
  c->row_origin = new int[height+1];
  for(i=0; i<height+1; i++) {
      c->row_origin[i] = i*DEFCELLHEIGHT;
  }
  

  c->argv[0] = canvas;
  c->argv[1] = "create";
  c->argv[2] = "text";

  c->argv[3] = (char*)malloc(10); /* X coordinate */
  c->argv[4] = (char*)malloc(10); /* Y coordinate */

  c->argv[5] = (char*)malloc(10);
  strcpy(c->argv[5],"-text");

  c->argv[7] = (char*)malloc(10);
  strcpy(c->argv[7],"-anchor");

  c->argv[9] = (char*)malloc(10);
  strcpy(c->argv[9],"-font");
  
  


}


void deleteCanvas(Canvas *c) {
  free(c->argv[3]);
  free(c->argv[4]);
  free(c->argv[5]);

  free(c->argv[7]);
  free(c->argv[9]);

  c->cmdPtr = NULL;
}

void Sheet::scroll_to(int x, int y, int actualize_origin) {
    int nx,ny;
    char cmd[80];

    nx = x-canvas_info->x_origin;
    if (nx != 0) {
        sprintf(cmd,"%s xview scroll %d units",canvas,nx);
        if (Tcl_Eval(interp,cmd) != TCL_OK)
            internal_error();
        sprintf(cmd,"%s xview scroll %d units",col_labels,nx);
        if (Tcl_Eval(interp,cmd) != TCL_OK)
            internal_error();

        sprintf(cmd,"%s set %f %f",hscroll,
                (float)x/canvas_info->col_origin[max_col],
                ((float)x+canvas_info->width)/canvas_info->col_origin[max_col]);
        if (Tcl_Eval(interp,cmd) != TCL_OK)
            internal_error();

        if (actualize_origin)
            canvas_info->x_origin = x;
    }

    ny = y-canvas_info->y_origin;
    if (ny != 0) {
        sprintf(cmd,"%s yview scroll %d units",canvas,ny);
        if (Tcl_Eval(interp,cmd) != TCL_OK)
            internal_error();
        sprintf(cmd,"%s yview scroll %d units",row_labels,ny);
        if (Tcl_Eval(interp,cmd) != TCL_OK)
            internal_error();

        sprintf(cmd,"%s set %f %f",vscroll,
                (float)y/canvas_info->row_origin[max_row],
                ((float)y+canvas_info->height)/canvas_info->row_origin[max_row]);
        if (Tcl_Eval(interp,cmd) != TCL_OK)
            internal_error();

        if (actualize_origin)
            canvas_info->y_origin = y;
    }
}

Tk_Item *
Sheet::draw_text(char *text, int x, int y, int anchor,int col, int row,char *font) {
  size_t length;
  int c, result;
  int argc;
  Tk_Item *itemPtr;

  register Interp *iPtr = (Interp *) interp;

/*  Tcl_FreeResult((Tcl_Interp *) iPtr);
  iPtr->result = iPtr->resultSpace;
  iPtr->resultSpace[0] = 0;
  result = TCL_OK;*/







  sprintf(canvas_info->argv[3],"%d",col);
  sprintf(canvas_info->argv[4],"%d",row);

  canvas_info->argv[6] = text;

  
  if (anchor == WEST) 
    canvas_info->argv[8] = "w";
  else if (anchor == EAST) 
    canvas_info->argv[8] = "e";
  else
    canvas_info->argv[8] = "c";

  canvas_info->argv[10] = font;
  
  argc = 11;

  
  CanvasWidgetCmd(canvas_info->cmdPtr->clientData,interp,
                  argc,canvas_info->argv);
  
  
  return(lastItemCreated);

  /*


  TkCanvas *canvasPtr = (TkCanvas *) canvas_info->cmdPtr->clientData;
                                           
  typePtr = matchPtr;
  itemPtr = (Tk_Item *) ckalloc((unsigned) typePtr->itemSize);
  itemPtr->id = canvasPtr->nextId;
  canvasPtr->nextId++;
  itemPtr->tagPtr = itemPtr->staticTagSpace;
  itemPtr->tagSpace = TK_TAG_SPACE;
  itemPtr->numTags = 0;
  itemPtr->typePtr = typePtr;

  c = 't';
  length = strlen(canvas_info->argv[2]);
  for (typePtr = typeList; typePtr != NULL; typePtr = typePtr->nextPtr) {
    if ((c == typePtr->name[0])
        && (strncmp(canvas_info->argv[2], typePtr->name, length) == 0)) {
      if (matchPtr != NULL) {
      badType:
        Tcl_AppendResult(interp,
                         "unknown or ambiguous item type \"",
                         canvas_info->argv[2], "\"", (char *) NULL);
        goto error;
      }
      matchPtr = typePtr;
    }
  }

  

  if ((*typePtr->createProc)(interp, (Tk_Canvas) canvasPtr,
                             itemPtr, argc-3, canvas_info->argv+3) != TCL_OK) {
    ckfree((char *) itemPtr);
    goto error;
  }
  itemPtr->nextPtr = NULL;
  canvasPtr->hotPtr = itemPtr;
  canvasPtr->hotPrevPtr = canvasPtr->lastItemPtr;
  if (canvasPtr->lastItemPtr == NULL) {
    canvasPtr->firstItemPtr = itemPtr;
  } else {
    canvasPtr->lastItemPtr->nextPtr = itemPtr;
  }
  canvasPtr->lastItemPtr = itemPtr;
  Xxl_CanvasEventuallyRedraw((Tk_Canvas) canvasPtr,
                             itemPtr->x1, itemPtr->y1, 
                             itemPtr->x2, itemPtr->y2);
  canvasPtr->flags |= REPICK_NEEDED; */
  /*  sprintf(interp->result, "%d", itemPtr->id);*/

}
/*
$Log: canvas_interf.cc,v $
Revision 1.12  1998/08/06 21:08:39  aml
Released alpha version of Abacus.

Revision 1.11  1996/11/22 16:29:17  aml
First cut at transforming canvas into a true cell widget.
Text, lines and rectangles are now relative to row and colunm numbers.
It still has a bug with wrong estimation of column widths.

// Revision 1.10  1996/10/09  13:55:07  aml
// First cut of full print.
//
Revision 1.9  1996/09/17 15:16:21  aml
Fixed problems with copying of cells with non-default formats.
Created printing formats, alignment formats.
Format toolbar now reflects format of active cell.

Revision 1.8  1996/09/16 18:42:23  aml
Some performance problems addressed by reducing tag use.
Several performance problems remain when heavy use is made
of borders and shading in large spreadsheets.

// Revision 1.7  1996/08/26  12:08:52  aml
// Fixed problem with several sheets. Each canvas now has its own
// canvas info.
// Fixed scroll up and down. Implemented max_row and max_col.
// Fairly stable version.
//
// Revision 1.6  1996/08/24  10:16:07  aml
// Scroll almost fixed. We are missing scroll steps.
// Several sheets work again, but need to be fixed right.
//
// Revision 1.5  1996/08/23  16:11:20  aml
// Several changes in handling the Canvas class.
//
// Revision 1.4  1996/04/27  11:12:40  aml
// Inserted check and delete button.
// Font selection widget created.
// Fixed bug canvas_information destructor.
//
Revision 1.3  1996/04/21 13:28:10  aml
Sped up scroll functions, caching keys presses.
First cut at handling overflowing cells.
Overflow into ajoining filled cells not solved.

// Revision 1.2  1996/04/19  10:46:40  aml
// First cut at speeding up canvas critical functions.
// CanvasWidgetCommand is now called directly from draw_sheet.
// Fixed bug in reading values from datafiles. Also works
// for Suns now.
// Created canvas directory, replacing builtin command canvas.
//
Revision 1.1  1996/04/18 09:31:28  aml
Initial revision
*/


