#
# This function receives a canvas and reads a global var named lst
# in order to execute each element of that list by pressing the key
# Return.
#

proc EvaluateScriptList {c} {

    global lst
    global ended
    global demo

    set tmp [bind $c <Key-Return>]
    set tmp2 [bind $c <Key-Escape>]
    set tmp3 [bind $c <Key-space>]
    set ended false

    bind $c <Key-Return> { 
	global lst
	global ended
	if { [llength $lst]>0 } {		    
	    eval [lindex $lst 0];
	    set lst [lrange $lst 1 [llength $lst]];
	} else {
	    if { [llength $lst]==1 } {		    
		eval [lindex $lst 0];
		set lst {}
	    }
	    set ended true
	}
    }

    bind $c <Key-Escape> {
	set ended true
    }

    bind $c <Key-space> {}
    
    tkwait variable ended
    
    bind $c <Key-Return> $tmp
    bind $c <Key-Escape> $tmp2
    bind $c <Key-space> $tmp3
    
}

#
# Each element of the following list "slides" contains the information that
# should be used by abacus-presentation.tcl to present each slide.
#

set slides { 
    {Presentation slide1 picture xxl.gif "Projecto ABACUS 1997/1998" "Instituto Superior Tecnico"}

    {
	Presentation slide0 text { 
	    {"\tMotivao\n" l left}
	    {"\tPlataforma GNU/Linux no tem folhas de clculo com qualidade." \
		 m left}
	    {"\tExistentes tm funcionalidade limitada.\n" m left}
	    {"\tPlataforma interessante\n" l left}
	    {"\tLinux" m left}
	    {"\tXWindows\n" m left}
	    {"\tPromoo de tecnologias e mtodos recentes\n" l left}
	    {"\tPromover Tcl/Tk." m left}
	    {"\tDesenvolvimento apoiado pela comunidade GNU/Linux." m left}
	} "Introduo"
    } 
    {
	Presentation slide1 text {
	    {"\tDiviso em dois subsistemas principais:\n" l left}
	    {"\tTcl/Tk:" m left}
	    {"\tInterface utilizador." s left}
	    {"\tProcessamento \"leve\".\n" s left}
	    {"\tC/C++:" m left}
	    {"\tRotinas de clculo." s left}
	    {"\tInterface com SO." s left}
	    {"\tProcessamento \"pesado\"." s left}
	} "Introduo" "Viso geral arquitectura"
    }
    {
	Presentation slide2 text {
	    {"\tEvoluo do prottipo inicial:" l left}
	    {"\tUpgrade para verses mais recentes bibliotecas." m left}
	    {"\tReviso funcionalidade j existente." m left}
	    {"\tImplementao funcionalidade bsica.\n" m left}
	    {"\tVerso alfa:" l left}
	    {"\tImplementao verso bsica de ideias futuras." m left}
	    {"\tDistruibuio pela Internet do cdigo fonte.\n" m left}
	    {"\tMelhoramento verso incial:" l left}
	    {"\tFuncionalidades avanadas." m left}
	    {"\tResposta a feedback dos utilizadores.\n" m left}
	    {"\tSegunda verso" l left}
	    {"\t..." m left}
	} "Introduo" "Fases desenvolvimento"
    }
    {
	Presentation slide3 text {
	    {"\tLinux\n" l left}
	    {"\tFerramentas GNU\n" l left}
	    {"\tXWindows\n" l left}
	    {"\tTcl/Tk\n" l left}
	} "Introduo" "Ambiente de trabalho"
    }
    {
	Presentation slide4 text {
	    {"\tComputao Grfica:" l left}
	    {"\tInterface." m left}
	    {"\tProgramao usando sistema de janelas.\n" m left}
	    {"\tInterfaces Homem-Mquina:" l left}
	    {"\tFacilidade de utilizao.\n" m left}
	    {"\tProgramao com Objectos:" l left}
	    {"\tHierarquias de objectos - desenho." m left}
	    {"\tImplementao em C++.\n" m left}
	    {"\tEngenharia da Programao:" l left}
	    {"\tMetodologia de desenvolvimento/engenharia adoptada." m left}
	    {"\tProduo de documentao (tambm para esta apresentao!).\n" m left}
	    {"\t..." l left}
	} "Introduo" "Conceitos Utilizados"
    }
    {
	Presentation slide5 text {
	    {"\tQuando surgiu software \"livre\"?" l left}
	    {"\tNo incio:" m left}
	    {"\tProgramadores na \"pr-histria\" trocavam programas...\n" s left}
	    {"\t... e actualmente?" l left}
	    {"\tComunidade \"Internetiana\"." m left}
	    {"\tDentro das prprias firmas que vendem software!\n" m left}
	    {"\tSer nica maneira de obter qualidade real?" l left}
	    {"\tProgramas comerciais tm bugs..." m left}
	    {"\tSoluo perfeita no existe..." m left}
	} "Conceitos Bsicos" "GNU, Linux - \"software livre\""
    }
    {
	Presentation slide6 text {
	    {"\tMas, paga-se?" l left}
	    {"\tTalvez sim, talvez no.\n" m left}
	    {"\tE ento a minha liberdade?" l left}
	    {"\tEstudar como o programa funciona atravs do cdigo." m left}
	    {"\tLiberdade de poder dar o programa ao vizinho sem quebrar a lei." m left}
	    {"\tMelhorar o programa e distribuir para o pblico...\n" m left}
	    {"\t...Benefico para a comunidade!\n" l left}
	} "Conceitos Bsicos" "GNU, Linux - \"software livre\""
    }
    {
	Presentation slide7 text {
	    {"\tHistria\n" l left}
	    {"\tGNU" m left}
	    {"\tIncio em 1985." s left}
	    {"\tComea com o Emacs, gcc, linker, debugger...no comea mal." s left}
	    {"\tGNU Manifesto - Stallman apela  comunidade.\n" s left}
	    {"\tLinux" m left}
	    {"\tIncio em 1991." s left}
	    {"\tEvoluo do Minix." s left}
	    {"\tActualmente 7 milhes utilizadores.\n" s left}
	    {"\tEm comum...Internet\n" l left}
	} "Conceitos Bsicos" "GNU, Linux - \"software livre\""
    }
    {
	Presentation slide8 text {
	    {"\tComo surge?\n" l left}
	    {"\tEm Berkeley, Ousterhout precisava de intergrar ferramentas diferentes." m left}
	    {"\tMas cada ferramenta tinha uma linguagem diferente!\n" m left}
	    {"\tCaracteristcas da ferramenta a usar para fazer integrao:" m left}
	    {"\tLinguagem interpretada." s left}
	    {"\tEstruturas de controlo genricas - fazer a \"ponte\" entre aplicaes diferentes." s left}
	    {"\tProcedimentos.\n" s left}
	    {"\tObjectivos:" m left}
	    {"\tExtensvel: Cada aplicao deve adicionar componentes novas fcil e naturalmente." s left}
	    {"\tLinguagem simples e genrica - no restringir \"clientela\"." s left}
	    {"\tObjectivo principal no  \"fazer\" mas \"colar\".\n" s left}
	    {"\tNasce o Tcl (Tool Command Language)." m left}
	} "Conceitos Bsicos" "Tcl e Tk"
    }
    {
	Presentation slide9 text {
	    {"\tEm 88 surge necessidade de criar GUI especfico:\n" l left}
	    {"\tCada vez mais populares." m left}
	    {"\tTempo de desenvolvimento cada vez mais longo." m left}
	    {"\tNecessidade de implementao rpida." m left}
	    {"\tReaproveitamento de componentes j realizadas vital." m left}
	    {"\tAgregar componentes desenvolvidas por equipas pequenas para sistemas grandes.\n" m left}
	    {"\tO que usar para integrar estes componentes...Tcl!\n" m left}
	    {"\tO que falta? Componentes de GUI para Tcl...\n" m left}
	    {"\tNasce o Tk!\n" l left}
	    {"\tExtenso do Tcl para construir interfaces grficas com utilizador." m left}
	} "Conceitos Bsicos" "Tcl e Tk"
    }
    {
	Presentation slide10 text {
	    {"\tSucesso do Tk?" l left}
	    {"\tSimples e poderoso." m left}
	    {"\tOutros Toolkits (Motif, etc) muito complexos." m left}
	    {"\tTempo de desenvolvimento rpido.\n" m left}
	    {"\tSucesso do Tcl?" l left}
	    {"\tCapacidade de integrao." m left}
	    {"\tToda a gente quer usar scripts nas suas aplicaes..." m left}
	    {"\t...ningum tem tempo para desenvolver linguagem..." m left}
	    {"\t...adoptam Tcl.\n" m left}
	    {"\tPresente:" l left}
	    {"\tAmbiente multi-plataforma - suporte para Win e Mac." m left}
	    {"\tProteco - SafeTcl." m left}
	    {"\tCompilador Bytecodes - \"moda\" em linguagens interpretadas." m left}
	    {"\tIntegrao com Java." m left}
	    {"\t..." m left}
	} "Conceitos Bsicos" "Tcl e Tk"
    }

    {Presentation slide11 picture modelo_em_espiral.gif "Metodologia de Engenharia de Software" "Modelo em Espiral"}

    {Presentation slide12 picture arquitectura_do_abacus.gif "Arquitectura do Abacus" "Apresentacao dos varios subsistemas"}

    {Presentation slide13 picture display.gif "Interface com o Utilizador" "O display"}

    {Presentation slide14 picture globalstate1.gif "Interface com o Utilizador" "Maquina de estados"}

    {Presentation slide15 picture globalstate2.gif "Interface com o Utilizador" "Maquina de estados"}

    {Presentation slide16 picture globalstate3.gif "Interface com o Utilizador" "Maquina de estados"}

    {Presentation slide17 picture estrutura_de_dados.gif "Interface Tcl" "Estrutura de Dados base de extensao do Tcl"}

    {Presentation slide18 text "" "Tarefa - Graficos"}

    {Presentation slide19 picture estados_graficos.gif "Tarefa - Graficos" "Diagramas de estados de Interaccao com o Utilizador"}
    
    {
	source "[xxl_library]/globalvars.tcl"
	set demo "Playing"
	set lst {
	    { 
		CellSet $activeSheet 1 0 "Demo de Graficos ->Introducao de dados"
		for {set i 2} {$i<12} {incr i} {CellSet $activeSheet 2 $i $i} 
		set currentRange { 2 2 2 11 }
	    }
	    { 
		CellSet $activeSheet 1 0 "Demo de Graficos ->Seleccao de dados"
		highlightCurrentRange [canvasFromSheet $activeSheet] 
	    }
	    
	    {
		CellSet $activeSheet 1 0 "Demo de Graficos -> Pie graph"
		set cnt [SetGraphParams $activeSheet 1 2 2 2 12 191.0 168.0 22.0 13.0 9 0] 
		doDrawGraph $activeSheet $cnt
	    }
	    
	    {
		CellSet $activeSheet 1 0 "Demo de Graficos -> Seleccao de um grafico"
		controlSquares [canvasFromSheet $activeSheet] \
		    [expr [ColOrigin $activeSheet 9]+22.0] \
		    [expr [RowOrigin $activeSheet 0]+13.0] \
		    [expr [ColOrigin $activeSheet 9]+22.0+191.0] \
		    [expr [RowOrigin $activeSheet 0]+13.0+168.0]
	    }
	    
	    {
		CellSet $activeSheet 1 0 "Demo de Graficos -> Resize"
		
		[canvasFromSheet $activeSheet] delete graphrect
		[canvasFromSheet $activeSheet] delete graph_$cnt
		
		set tmpCol [CellCol $activeSheet 250]
		set tmpRow [CellRow $activeSheet 20]
		set tmpX   [expr 250-[ColOrigin $activeSheet [CellCol $activeSheet 250]]]
		set tmpY   [expr 20-[RowOrigin $activeSheet [CellRow $activeSheet 20]]]
		set tmpWidth [expr abs([expr 250-[expr [ColOrigin $activeSheet 9] \
						      +22.0+191.0]])]
		set tmpHeight [expr abs([expr 20-[expr [RowOrigin $activeSheet 0] \
						      +13.0+168.0]])] 
		
		ChangeGraphParams $activeSheet $cnt \
		    $tmpWidth $tmpHeight $tmpX $tmpY $tmpCol $tmpRow 
		
		doDrawGraph $activeSheet $cnt
		
		controlSquares [canvasFromSheet $activeSheet] \
		    [expr [ColOrigin $activeSheet $tmpCol]+$tmpX] \
		    [expr [RowOrigin $activeSheet $tmpRow]+$tmpY] \
		    [expr [ColOrigin $activeSheet $tmpCol]+$tmpX+$tmpWidth] \
		    [expr [RowOrigin $activeSheet $tmpRow]+$tmpY+$tmpHeight]
		
	    }
	    
	    {
		CellSet $activeSheet 1 0 "Demo de Graficos -> Mover"
		[canvasFromSheet $activeSheet] move graphrect -20 100
		[canvasFromSheet $activeSheet] move graph_$cnt -20 100
	    }
	    
	    {
		CellSet $activeSheet 1 0 "Demo de Graficos -> Apagar"
		set graphSelected $cnt
		[canvasFromSheet $activeSheet] delete graphrect
		delGraph
	    }
	    
	    { 
		CellSet $activeSheet 1 0 "Demo de Graficos ->Introducao de mais dados"
		
		CellSet $activeSheet 1 2 "A"
		CellSet $activeSheet 1 3 "B"
		CellSet $activeSheet 1 4 "C"
		CellSet $activeSheet 1 5 "D"
		CellSet $activeSheet 1 6 "E"
		CellSet $activeSheet 1 7 "F"
		CellSet $activeSheet 1 8 "G"
		CellSet $activeSheet 1 9 "H"
		CellSet $activeSheet 1 10 "I"
		CellSet $activeSheet 1 11 "J"
		
		set temporaria 3
		for {set i 2} {$i<12} {incr i} {
		    if {$temporaria==3} {set temporaria 5} else {set temporaria 3}
		    CellSet $activeSheet 3 $i $temporaria
		} 
		set currentRange { 1 2 3 11 }
	    }
	    { 
		CellSet $activeSheet 1 0 "Demo de Graficos ->Nova Seleccao"
		highlightCurrentRange [canvasFromSheet $activeSheet] 
	    }
	    {
		CellSet $activeSheet 1 0 "Demo de Graficos ->Voila! Toda a variedade Disponivel!"
		
		set cnt [SetGraphParams $activeSheet 1 2 2 2 12 191.0 168.0 22.0 13.0 9 0] 
		doDrawGraph $activeSheet $cnt
		
		set cnt [SetGraphParams $activeSheet 2 1 2 3 11 200.0 157.0 31.0 4.0 0 8] 
		doDrawGraph $activeSheet $cnt
		
		set cnt [SetGraphParams $activeSheet 3 1 2 3 11 211.0 170.0 42.0 7.0 6 0] 
		doDrawGraph $activeSheet $cnt

		set cnt [SetGraphParams $activeSheet 4 1 2 3 11 212.0 167.0 23.0 8.0 3 1] 
		doDrawGraph $activeSheet $cnt
		
		set cnt [SetGraphParams $activeSheet 5 1 2 3 11 264.0 158.0 26.0 18.0 3 9] 
		doDrawGraph $activeSheet $cnt
		
		set cnt [SetGraphParams $activeSheet 6 1 2 3 11 269.0 156.0 21.0 13.0 7 9] 
		doDrawGraph $activeSheet $cnt

		
	    }	    
	    
	    {
		UndoRedo $activeSheet 0
		UndoRedo $activeSheet 0
		UndoRedo $activeSheet 0
		UndoRedo $activeSheet 0
		UndoRedo $activeSheet 0
		UndoRedo $activeSheet 0
		CellSet $activeSheet 1 0 "Demo de Graficos ->Undo do desenho dos graficos"
		unhighlightCurrentRange [canvasFromSheet $activeSheet]	
	    }
	}

	EvaluateScriptList .slideshow

	set demo "Not Loaded"
    }
    
    {Presentation slide21 text "" "Tarefa - Sort" "(Em seguida Demo)"}
    
    {
	set demo "Playing"

	set lst {
	    
	    {
		CellSet $activeSheet 1 0 "Demo de Sort ->Seleccao dos dados a ordenar"
		set currentRange { 1 2 3 11 }
		highlightCurrentRange [canvasFromSheet $activeSheet] 
	    }
	    
	    {
		CellSet $activeSheet 1 0 "Demo de Sort ->Sort descendente da primeira coluna"
		SortCells $activeSheet [lindex $currentRange 0] [lindex $currentRange 1] \
		    [lindex $currentRange 2] [lindex $currentRange 3] 0 0 0
		unhighlightCurrentRange [canvasFromSheet $activeSheet]	
	    }
	}
	
	EvaluateScriptList .slideshow
	set demo "Not Loaded"
    }

    {Presentation slide21 text "" "Tarefa - Formulas" "(Em seguida Demo)"}
    
    {
	set demo "Playing"

	set lst {
	    
	    {
		CellSet $activeSheet 1 0 " "

		CellSet $activeSheet 1 2 "1"
		CellSet $activeSheet 1 3 "2"
		CellSet $activeSheet 1 4 "3"
		CellSet $activeSheet 1 5 "4"
		CellSet $activeSheet 1 6 "5"
		CellSet $activeSheet 1 7 "6"
		CellSet $activeSheet 1 8 "7"
		CellSet $activeSheet 1 9 "8"
		CellSet $activeSheet 1 10 "9"
		CellSet $activeSheet 1 11 "10"

		CellSet $activeSheet 2 2 "-1"
		CellSet $activeSheet 2 3 "2"
		CellSet $activeSheet 2 4 "3"
		CellSet $activeSheet 2 5 "4"
		CellSet $activeSheet 2 6 "5"
		CellSet $activeSheet 2 7 "6"
		CellSet $activeSheet 2 8 "7"
		CellSet $activeSheet 2 9 "8"
		CellSet $activeSheet 2 10 "9"
		CellSet $activeSheet 2 11 "10"

		set currentRange { 1 2 2 11}
		highlightCurrentRange [canvasFromSheet $activeSheet] 

	    }

	    {
		CellSet $activeSheet 5 4 "'=@SUM(B3:C12)"
		CellSet $activeSheet 8 4 "=@SUM(B3:C12)"

		CellSet $activeSheet 8 5 "=@ABS(\$B\$4)"
		CellSet $activeSheet 5 5 "'=@ABS(\$B\$4)"

		CellSet $activeSheet 8 6 "=@ATAN(B3)"
		CellSet $activeSheet 5 6 "'=@ATAN(B3)"

		CellSet $activeSheet 8 7 "=@SQRT(B5)"
		CellSet $activeSheet 5 7 "'=@SQRT(B5)"

		CellSet $activeSheet 8 8 "=@SQRT(@SUM(B3:C12)*4)"
		CellSet $activeSheet 5 8 "'=@SQRT(@SUM(B3:C12)*4)"

		CellSet $activeSheet 8 9 "=@SUM(B3:C12)"
		CellSet $activeSheet 5 9 "'=@SUM(B3:C12)"

		CellSet $activeSheet 8 10 "=@SIN(3.14)+13+@COS(3.14)"
		CellSet $activeSheet 5 10 "'=@SIN(3.14)+13+@COS(3.14)"
	    }
	    
	    {

		CellSet $activeSheet 1 2 " "
		CellSet $activeSheet 1 3 " "
		CellSet $activeSheet 1 4 " "
		CellSet $activeSheet 1 5 " "
		CellSet $activeSheet 1 6 " "
		CellSet $activeSheet 1 7 " "
		CellSet $activeSheet 1 8 " "
		CellSet $activeSheet 1 9 " "
		CellSet $activeSheet 1 10 " "
		CellSet $activeSheet 1 11 " "

		CellSet $activeSheet 2 2 " "
		CellSet $activeSheet 2 3 " "
		CellSet $activeSheet 2 4 " "
		CellSet $activeSheet 2 5 " "
		CellSet $activeSheet 2 6 " "
		CellSet $activeSheet 2 7 " "
		CellSet $activeSheet 2 8 " "
		CellSet $activeSheet 2 9 " "
		CellSet $activeSheet 2 10 " "
		CellSet $activeSheet 2 11 " "

		CellSet $activeSheet 5 4 " "
		CellSet $activeSheet 8 4 " "
		CellSet $activeSheet 8 5 " "
		CellSet $activeSheet 5 5 " "
		CellSet $activeSheet 8 6 " "
		CellSet $activeSheet 5 6 " "
		CellSet $activeSheet 8 7 " "
		CellSet $activeSheet 5 7 " "
		CellSet $activeSheet 8 8 " "
		CellSet $activeSheet 5 8 " "
		CellSet $activeSheet 8 9 " "
		CellSet $activeSheet 5 9 " "
		CellSet $activeSheet 8 10 " "
		CellSet $activeSheet 5 10 " "

	    }
	    
	}
	
	EvaluateScriptList .slideshow
	set demo "Not Loaded"
    }

    {Presentation slide23 text "" "Tarefa - Formatos" "Grande leque de opcoes (Demo em Seguida)"}
    
    {
	set demo "Playing"

	set lst {
	    
	    {
		ToggleDisplayBorders $activeSheet ;
		toggleCellBordersDisplay
		
		set currentRange ""
		
		set count 0
		set jump 0
		set last 0

# foreach fontitalic  $fontItalics 
		
		foreach fontname {0 1 2 3} {
		    foreach fontsize {0 1 2 3 4 5} {
			foreach fontitalic {0 1 2} {
			    foreach fontbold {0 1} {
				
				set x [expr [expr int([expr $count / 30])]+$jump]
				set y [expr [expr $count% 30] +1]
				
				CellSet $activeSheet $x $y "$fontname $fontsize $fontitalic $fontbold"
				SetFont $activeSheet $fontname $fontsize $fontitalic $fontbold $x $y 1
				
				set count [expr $count +2]
				
				if {$last < $x} {
				    set jump [expr $jump +2]
				    set last [expr $x +2] } 
				
			    }
			}
		    }
		}

		set temp 1
		
		CellSet $activeSheet 0 0 $temp
		
		for {set i 2} {$i<=3} {incr i} {
		    for {set j 2} {$i<=11} {incr i} {
			CellSet $activeSheet $i $j " "
		    }
		}
	    }
	    
	    {

		SetBorders example  5 7 7 7  0 3
		SetBorders example  5 7 7 7  3 3
		SetBorders example  7 7 2 7  3 3 
		SetBorders example  7 5 7 7  3 3
		SetBorders example  7 3 7 7  6 3 
		SetAlignment example 2  0 11
		SetAlignment example 3  0 13
		SetFill example 50 6 11
		SetFill example 90 9 9
		SetFill example 20 6 13
		SetFill example 80 3 11
		SetFill example 90 3 13
		SetBorders example  7 7 7 3  9 5 
		SetBorders example  7 7 7 2  9 15 
		SetBorders example  7 7 3 7  9 3 
		SetBorders example  7 7 5 7  9 3 
		SetBorders example  1 7 7 7  3 15 
		SetBorders example  7 7 1 7  3 15 
		SetBorders example  7 1 7 7  3 15 
		SetBorders example  7 7 7 1  3 15 
		SetFill example 60 3 6
		SetFill example 60 10 2
		SetBorders example  7 5 7 7  6 1 
		SetBorders example  5 7 7 7  6 1 
		SetBorders example  7 7 7 5  6 1 
		SetBorders example  7 7 5 7  6 1 
		SetBorders example  7 3 7 7  0 10 
		SetBorders example  7 3 7 7  1 10 
		SetBorders example  7 3 7 7  2 10 
		SetBorders example  7 3 7 7  3 10
	    }

	    {
		set count 0
		set jump 0
		set last 0
		
		for {set i 0} {$i< 90} {incr i} {
		    
		    set x [expr [expr int([expr $count / 30])]+$jump]
		    set y [expr [expr $count% 30] +1]
		    
		    CellSet $activeSheet $x $y " "
		    set count [expr $count +2]
		    
		    if {$last < $x} {
			set jump [expr $jump +2]
			set last [expr $x +2] } 
		}
	    }

	    {
		ToggleDisplayBorders $activeSheet ;
		toggleCellBordersDisplay
	    }
	}
	
	
	EvaluateScriptList .slideshow

	CellSet $activeSheet 1 1 " "

	set demo "Not Loaded"
    }
    
    {
	Presentation slide25 text {
	    {"Vantagens:" l left}
	    {"O utilizador e livre de incorporar novas funcionalidades." m left}
	    {"Usa-se comandos internos Tcl, com as vantagens ja descritas." m left}
	    {"Usa-se a extensao de comandos novas para manipular a folha." m left}
	    {"E facil de usar e rapido de escrever uma script" m left}
	    {"\tEsta script tem 200 linhas!!!(com Motif nem pensar!)" s left}

	} "Tarefa - Macros" "Esta mesma Apresentacao e' um script a correr no Abacus!!!"}

    {Presentation slide26 picture Undo_objectos.gif "Tarefa Undo/Redo" "Esquema dos objectos"}

    {Presentation slide27 picture undo_funcionamento.gif "Tarefa Undo/Redo" "Exemplo de Funcionamento"}
    {
	set demo "Playing"

	set lst {
	    
	    {
		CellSet $activeSheet 1 0 "Demo de Undo/Redo ->insercao de dados"
		CellSet $activeSheet 2 2 "Primeiro"
	    }
	    {
		CellSet $activeSheet 2 3 "Segundo"
	    }
	    {
		CellSet $activeSheet 2 4 "Terceiro"
	    }
	    {
		CellSet $activeSheet 2 5 "Quarto"
	    }
	    
	    {
		UndoRedo $activeSheet 0
	    }
	    {
		UndoRedo $activeSheet 1
	    }
	    {
		UndoRedo $activeSheet 0
	    }
	    {
		UndoRedo $activeSheet 0
	    }
	    
	    {
		CellSet $activeSheet 2 6 "Novo"
	    }

	    {
		UndoRedo $activeSheet 0
	    }

	    {
		UndoRedo $activeSheet 0
	    }

	    {
		CellSet $activeSheet 1 0 " "
		CellSet $activeSheet 2 2 " "
		CellSet $activeSheet 2 3 " "
		CellSet $activeSheet 2 4 " "
		CellSet $activeSheet 2 5 " "
		CellSet $activeSheet 2 6 " "
	    }
	}
	
	EvaluateScriptList .slideshow
	set demo "Not Loaded"
    }
    
    
    {Presentation slide29 text "" "Tarefa - sistema de Help"}

    {Presentation slide30 picture demo-help.gif "Tarefa -  sistema de Help"}
    
    {Presentation slide31 text "" "Projecto ABACUS 1997/1998" "Fim de apresentacao"}
    
}

