/* $XFree86: xc/programs/Xserver/hw/xfree86/ivtvhw/ivtvhw.h,v 1.11 2001/10/01 13:44:12 eich Exp $ */

#ifndef _FBDEVHW_H_
#define _FBDEVHW_H_
#include "xf86str.h"
#include "colormapst.h"
#include <asm/ioctl.h>
#undef __STRICT_ANSI__
#include <inttypes.h>
#include <linux/ivtv.h>

#define FBDEVHW_PACKED_PIXELS		0	/* Packed Pixels        */
#define FBDEVHW_PLANES			1	/* Non interleaved planes */
#define FBDEVHW_INTERLEAVED_PLANES	2	/* Interleaved planes   */
#define FBDEVHW_TEXT			3	/* Text/attributes      */
#define FBDEVHW_VGA_PLANES		4	/* EGA/VGA planes       */
#include <linux/fb.h>
typedef struct {
	/* framebuffer device: filename (/dev/fb*), handle, more */
	char *device;
	int fd;
	char *yuvDevName;
	int fd_yuv;
	unsigned int fbmem_len;
	unsigned int fboff;
	char *mmio;
	unsigned int mmio_len;

	/* current hardware state */
	struct fb_fix_screeninfo fix;
	struct fb_var_screeninfo var;

	/* saved video mode */
	struct fb_var_screeninfo saved_var;

	/* buildin video mode */
	DisplayModeRec buildin;

} ivtvHWRec, *ivtvHWPtr;
extern int ivtvHWPrivateIndex;

#define FBDEVHWPTRLVAL(p) (p)->privates[ivtvHWPrivateIndex].ptr
#define FBDEVHWPTR(p) ((ivtvHWPtr)(FBDEVHWPTRLVAL(p)))

Bool IVTVDGAInit(ScreenPtr pScreen);

#define PCI_HAUPAGGE_VENDOR_ID       0x4444

Bool ivtvHWGetRec(ScrnInfoPtr pScrn);
void ivtvHWFreeRec(ScrnInfoPtr pScrn);

Bool ivtvHWProbe(pciVideoPtr pPci, char *device, char **namep);
Bool ivtvHWInit(ScrnInfoPtr pScrn, pciVideoPtr pPci, char *device);

char *ivtvHWGetName(ScrnInfoPtr pScrn);
int ivtvHWGetDepth(ScrnInfoPtr pScrn, int *fbbpp);
int ivtvHWGetLineLength(ScrnInfoPtr pScrn);
int ivtvHWGetType(ScrnInfoPtr pScrn);
int ivtvHWGetVidmem(ScrnInfoPtr pScrn);

/*void* ivtvHWMapVidmem(ScrnInfoPtr pScrn);*/
int ivtvHWLinearOffset(ScrnInfoPtr pScrn);

void ivtvHWSetVideoModes(ScrnInfoPtr pScrn);
DisplayModePtr ivtvHWGetBuildinMode(ScrnInfoPtr pScrn);
void ivtvHWUseBuildinMode(ScrnInfoPtr pScrn);
Bool ivtvHWModeInit(ScrnInfoPtr pScrn, DisplayModePtr mode);
void ivtvHWSave(ScrnInfoPtr pScrn);
void ivtvHWRestore(ScrnInfoPtr pScrn);

void ivtvHWLoadPalette(ScrnInfoPtr pScrn, int numColors, int *indices,
		       LOCO * colors, VisualPtr pVisual);

int ivtvHWValidMode(int scrnIndex, DisplayModePtr mode, Bool verbose,
		    int flags);
Bool ivtvHWSwitchMode(int scrnIndex, DisplayModePtr mode, int flags);
void ivtvHWAdjustFrame(int scrnIndex, int x, int y, int flags);
Bool ivtvHWEnterVT(int scrnIndex, int flags);
void ivtvHWLeaveVT(int scrnIndex, int flags);
void ivtvHWDPMSSet(ScrnInfoPtr pScrn, int mode, int flags);

Bool ivtvHWSaveScreen(ScreenPtr pScreen, int mode);
Bool ivtvHWSendDMA(ScrnInfoPtr pScrn, void *ptr, int x1, int x2, int y1,
		   int y2);

#endif
