/*
   Copyright (C) 2007 Will Franklin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

#ifndef _MM_REPLY
#define _MM_REPLY

#include "matchmaker.h"

//static void MM_ReplyToLock( void *srv, const char *reply )
static void MM_ReplyToSetup( void *srv, const char *reply )
{
	mm_server_t *server = ( mm_server_t* )srv;
	//int i;

	if( !server->match )
		return;

	// someone has left since while we were waiting for gameservers reply
	if( MM_ClientCount( server->match ) != server->match->maxclients )
	{
		MM_SendMsgToClients( qfalse, server->match, "status waiting for players" );
		server->match = 0;
		return;
	}

	// choose another server to try
	if( !Q_stricmp( reply, "nomm" ) || !Q_stricmp( reply, "failed" ) )
	{
		MM_DeleteServerFromList( server->ip );
		MM_FindAndLockServer( server->match );
		return;
	}

	// unknown reply
	if( Q_stricmp( reply, "success" ) )
		return;

#ifdef OLD_GAMESERVER_CHECKING
	for( i = 0; i < server->match->maxclients; i++ )
	{
		if( !server->match->clients[i] )
			continue;

		server->match->clients[i]->serverping = 0;
	}

	MM_SendMsgToClients( server->match, "status pinging gameserver" );

	// ask clients to ping gameserver, to see if its suitable
	MM_SendMsgToClients( server->match, "pingserver %s", server->ip );
#endif

	MM_SendMsgToClients( qtrue, server->match, "start %s %s", server->ip, server->pass );
	MM_FreeMatch( server->match );
	MM_DeleteServerFromList( server->ip );
}


#ifdef OLD_GAMESERVER_CHECKING
static void MM_ReplyToUnlock( void *srv, const char *reply )
{
	mm_server_t *server = ( mm_server_t* )srv;
	if( !server->match )
		return;

	if( MM_ClientCount( server->match ) != server->match->maxclients )
		return;

	// server should only be able to return success for this command
	if( Q_stricmp( reply, "success" ) )
		return;

	MM_SendMsgToClients( server->match, "start %s", server->ip );
	MM_FreeMatch( server->match );
	MM_DeleteServerFromList( server->ip );
}
#endif

#endif
