package org.apache.turbine.services.intake.model;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and 
 *    "Apache Turbine" must not be used to endorse or promote products 
 *    derived from this software without prior written permission. For 
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without 
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// JDK classes
import java.util.*;
import java.beans.*;

import org.apache.regexp.RESyntaxException;

// Turbine classes
import org.apache.turbine.om.*;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.services.intake.xmlmodel.*;
import org.apache.turbine.services.intake.*;


/**
 * Base class for Intake generated input processing classes.
 *
 * @author <a href="mailto:jmcnally@collab.net>John McNally</a>
 * @version $Id: StringField.java,v 1.4 2001/04/06 22:56:27 jmcnally Exp $
 */
public class StringField extends Field
{    
    public StringField(XmlField field, Group group)
        throws Exception
    {
        super(field, group);
    }

    /**
     * Compares request data with constraints and sets the valid flag.
     */
    protected void doValidate(ParameterParser pp)
    {
        if ( isMultiValued ) 
        {
            String[] ss = pp.getStrings(getKey());
            String[] sval = new String[ss.length];
            for (int i=0; i<ss.length; i++) 
            {
                sval[i] = checkString(ss[i]);
            }
            iv.setTestValue(sval);
        }
        else 
        {
            iv.setTestValue(checkString(pp.getString(getKey())));
        }
    }

    /**
     * Set the value of required.
     * @param v  Value to assign to required.
     */
    public void setRequired(boolean  v, String message) 
    {
        this.required = v;
        if (v && (!set_flag || ((String)iv.getTestValue()).length() == 0) ) 
        {
            valid_flag=false;
            this.message = message;
        }
    }
    
    /**
     * Compares request data with constraints and sets the valid flag.
     */
    private String checkString(String val)
    {
        boolean b;
        if ( maxLength > 0 )
        {
            b = val.length() > maxLength; 
            if ( maxLengthForce  && b )
            {
                val = val.substring(0, maxLength);
            }
            else 
            {
                valid_flag &= !b;
            }
            if (maxLengthMessage  != null && b)
            {
                message = maxLengthMessage;
            }
        }
        return val;
    }

}








