/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.xml.XMLWatchdog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DOMConfigurator
extends BasicConfigurator
implements Configurator {
    static final String CONFIGURATION_TAG = "configuration";
    static final String RENDERER_TAG = "renderer";
    static final String APPENDER_TAG = "appender";
    static final String APPENDER_REF_TAG = "appender-ref";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String PRIORITY_TAG = "priority";
    static final String FILTER_TAG = "filter";
    static final String ERROR_HANDLER_TAG = "errorHandler";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String SCFO_ATTR = "disableOverride";
    static final String CONFIG_DEBUG_ATTR = "configDebug";
    static final String RENDERING_CLASS_ATTR = "renderingClass";
    static final String RENDERED_CLASS_ATTR = "renderedClass";
    static final String EMPTY_STR = "";
    static final Class[] ONE_STRING_PARAM = new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = DOMConfigurator.class$("java.lang.String"))};
    static final String dbfKey = "javax.xml.parsers.DocumentBuilderFactory";
    Hashtable appenderBag = new Hashtable();
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Lorg$apache$log4j$spi$ErrorHandler;
    private static /* synthetic */ Class class$Lorg$apache$log4j$spi$Filter;
    private static /* synthetic */ Class class$Lorg$apache$log4j$xml$DOMConfigurator;

    protected Appender findAppenderByReference(Element element) {
        String string = element.getAttribute(REF_ATTR);
        Appender appender = (Appender)this.appenderBag.get(string);
        if (appender != null) {
            return appender;
        }
        Document document = element.getOwnerDocument();
        Element element2 = null;
        NodeList nodeList = document.getElementsByTagName(APPENDER_TAG);
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem(NAME_ATTR);
            if (string.equals(node2.getNodeValue())) {
                element2 = (Element)node;
                break;
            }
            ++n;
        }
        if (element2 == null) {
            LogLog.error("No appender named [" + string + "] could be found.");
            return null;
        }
        appender = this.parseAppender(element2);
        this.appenderBag.put(string, appender);
        return appender;
    }

    protected Appender parseAppender(Element element) {
        String string = element.getAttribute(CLASS_ATTR);
        LogLog.debug("Class name: [" + string + "]");
        try {
            Object obj = Class.forName(string).newInstance();
            Appender appender = (Appender)obj;
            appender.setName(element.getAttribute(NAME_ATTR));
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    if (element2.getTagName().equals(PARAM_TAG)) {
                        if (appender instanceof OptionHandler) {
                            this.parseParameters(element2, (OptionHandler)((Object)appender));
                        }
                    } else if (element2.getTagName().equals(LAYOUT_TAG)) {
                        appender.setLayout(this.parseLayout(element2));
                    } else if (element2.getTagName().equals(FILTER_TAG)) {
                        this.parseFilters(element2, appender);
                    } else if (element2.getTagName().equals(ERROR_HANDLER_TAG)) {
                        this.parseErrorHandler(element2, appender);
                    } else if (element2.getTagName().equals(APPENDER_REF_TAG)) {
                        String string2 = element2.getAttribute(REF_ATTR);
                        if (appender instanceof AppenderAttachable) {
                            AppenderAttachable appenderAttachable = (AppenderAttachable)((Object)appender);
                            LogLog.debug("Attaching appender named [" + string2 + "] to appender named [" + appender.getName() + "].");
                            appenderAttachable.addAppender(this.findAppenderByReference(element2));
                        } else {
                            LogLog.error("Requesting attachment of appender named [" + string2 + "] to appender named [" + appender.getName() + "] which does not implement org.apache.log4j.spi.AppenderAttachable.");
                        }
                    }
                }
                ++n2;
            }
            if (appender instanceof OptionHandler) {
                ((OptionHandler)((Object)appender)).activateOptions();
            }
            return appender;
        }
        catch (Exception exception) {
            LogLog.error("Could not create an Appender. Reported error follows.", exception);
            return null;
        }
    }

    protected void parseErrorHandler(Element element, Appender appender) {
        ErrorHandler errorHandler = (ErrorHandler)OptionConverter.instantiateByClassName(element.getAttribute(CLASS_ATTR), class$Lorg$apache$log4j$spi$ErrorHandler != null ? class$Lorg$apache$log4j$spi$ErrorHandler : (class$Lorg$apache$log4j$spi$ErrorHandler = DOMConfigurator.class$("org.apache.log4j.spi.ErrorHandler")), null);
        if (errorHandler != null) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2;
                String string;
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1 && (string = (element2 = (Element)node).getTagName()).equals(PARAM_TAG)) {
                    this.parseParameters(element2, errorHandler);
                }
                ++n2;
            }
            appender.setErrorHandler(errorHandler);
        }
    }

    protected void parseParameters(Element element, OptionHandler optionHandler) {
        String string = element.getAttribute(NAME_ATTR);
        String string2 = element.getAttribute(VALUE_ATTR);
        LogLog.debug("Handling parameter \"" + string + "=" + string2 + "\"");
        if (optionHandler instanceof OptionHandler && string2 != null) {
            optionHandler.setOption(string, OptionConverter.convertSpecialChars(string2));
        }
    }

    protected void parseFilters(Element element, Appender appender) {
        String string = element.getAttribute(CLASS_ATTR);
        Filter filter = (Filter)OptionConverter.instantiateByClassName(string, class$Lorg$apache$log4j$spi$Filter != null ? class$Lorg$apache$log4j$spi$Filter : (class$Lorg$apache$log4j$spi$Filter = DOMConfigurator.class$("org.apache.log4j.spi.Filter")), null);
        if (filter != null) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2;
                String string2;
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1 && (string2 = (element2 = (Element)node).getTagName()).equals(PARAM_TAG)) {
                    this.parseParameters(element2, filter);
                }
                ++n2;
            }
            appender.addFilter(filter);
        }
    }

    protected void parseCategory(Element element, Hierarchy hierarchy) {
        Object object;
        Category category;
        String string = element.getAttribute(NAME_ATTR);
        String string2 = element.getAttribute(CLASS_ATTR);
        if (EMPTY_STR.equals(string2)) {
            LogLog.debug("Retreiving an instance of org.apache.log4j.Category.");
            category = hierarchy.getInstance(string);
        } else {
            LogLog.debug("Desired category sub-class: [" + string2 + "]");
            try {
                object = Class.forName(string2);
                Method method = ((Class)object).getMethod("getInstance", ONE_STRING_PARAM);
                category = (Category)method.invoke(null, string);
            }
            catch (Exception exception) {
                LogLog.error("Could not retrieve category [" + string + "]. Reported error follows.", exception);
                return;
            }
        }
        object = category;
        synchronized (object) {
            category.setAdditivity(OptionConverter.toBoolean(element.getAttribute(ADDITIVITY_ATTR), true));
            this.parseChildrenOfCategoryElement(element, category, false);
        }
    }

    protected void parseRoot(Element element, Hierarchy hierarchy) {
        Category category;
        Category category2 = category = hierarchy.getRoot();
        synchronized (category2) {
            this.parseChildrenOfCategoryElement(element, category, true);
        }
    }

    protected void parseChildrenOfCategoryElement(Element element, Category category, boolean bl) {
        category.removeAllAppenders();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Object object;
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals(APPENDER_REF_TAG)) {
                    object = (Element)node;
                    Appender appender = this.findAppenderByReference((Element)object);
                    String string2 = object.getAttribute(REF_ATTR);
                    if (appender != null) {
                        LogLog.debug("Adding appender named [" + string2 + "] to category [" + category.getName() + "].");
                    } else {
                        LogLog.debug("Appender named [" + string2 + "] not found.");
                    }
                    category.addAppender(appender);
                } else if (string.equals(PRIORITY_TAG)) {
                    this.parsePriority(element2, category, bl);
                } else if (string.equals(PARAM_TAG) && category instanceof OptionHandler) {
                    object = (OptionHandler)((Object)category);
                    this.parseParameters(element2, (OptionHandler)object);
                    object.activateOptions();
                }
            }
            ++n2;
        }
    }

    protected Layout parseLayout(Element element) {
        String string = element.getAttribute(CLASS_ATTR);
        LogLog.debug("Parsing layout of class: \"" + string + "\"");
        try {
            Object obj = Class.forName(string).newInstance();
            Layout layout = (Layout)obj;
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2;
                String string2;
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1 && (string2 = (element2 = (Element)node).getTagName()).equals(PARAM_TAG)) {
                    this.parseParameters(element2, layout);
                }
                ++n2;
            }
            layout.activateOptions();
            return layout;
        }
        catch (Exception exception) {
            LogLog.error("Could not create the Layout. Reported error follows.", exception);
            return null;
        }
    }

    protected void parserRenderer(Element element) {
        String string = element.getAttribute(RENDERING_CLASS_ATTR);
        String string2 = element.getAttribute(RENDERED_CLASS_ATTR);
        this.addRenderer(string2, string);
    }

    protected void parsePriority(Element element, Category category, boolean bl) {
        String string = category.getName();
        if (bl) {
            string = ROOT_TAG;
        }
        String string2 = element.getAttribute(VALUE_ATTR);
        LogLog.debug("Priority value for " + string + " is  [" + string2 + "].");
        if ("inherited".equals(string2)) {
            if (bl) {
                LogLog.error("Root priority cannot be inherited. Ignoring directive.");
            } else {
                category.setPriority(null);
            }
        } else {
            String string3 = element.getAttribute(CLASS_ATTR);
            if (EMPTY_STR.equals(string3)) {
                category.setPriority(Priority.toPriority(string2));
            } else {
                LogLog.debug("Desired Priority sub-class: [" + string3 + "]");
                try {
                    Class<?> clazz = Class.forName(string3);
                    Method method = clazz.getMethod("toPriority", ONE_STRING_PARAM);
                    Priority priority = (Priority)method.invoke(null, string2);
                    category.setPriority(priority);
                }
                catch (Exception exception) {
                    LogLog.error("Could not create priority [" + string2 + "]. Reported error follows.", exception);
                    return;
                }
            }
        }
        LogLog.debug(string + " priority set to " + category.getPriority());
    }

    public static void configure(Element element) {
        DOMConfigurator dOMConfigurator = new DOMConfigurator();
        dOMConfigurator.parse(element, Category.getDefaultHierarchy());
    }

    public static void configureAndWatch(String string) {
        DOMConfigurator.configureAndWatch(string, 60000L);
    }

    public static void configureAndWatch(String string, long l) {
        XMLWatchdog xMLWatchdog = new XMLWatchdog(string);
        xMLWatchdog.setDelay(l);
        xMLWatchdog.start();
    }

    public void doConfigure(String string, Hierarchy hierarchy) {
        try {
            this.doConfigure(new FileInputStream(string), hierarchy);
        }
        catch (IOException iOException) {
            LogLog.error("Could not open [" + string + "].", iOException);
        }
    }

    public void doConfigure(URL uRL, Hierarchy hierarchy) {
        try {
            this.doConfigure(uRL.openStream(), hierarchy);
        }
        catch (IOException iOException) {
            LogLog.error("Could not open [" + uRL + "].", iOException);
        }
    }

    public void doConfigure(InputStream inputStream, Hierarchy hierarchy) throws FactoryConfigurationError {
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            LogLog.debug("System property is :" + System.getProperty(dbfKey));
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            LogLog.debug("Standard DocumentBuilderFactory search succeded.");
            LogLog.debug("DocumentBuilderFactory is: " + documentBuilderFactory.getClass().getName());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            Exception exception = factoryConfigurationError.getException();
            LogLog.debug("Could not instantiate a DocumentBuilderFactory.", exception);
            throw factoryConfigurationError;
        }
        try {
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(inputStream);
            URL uRL = (class$Lorg$apache$log4j$xml$DOMConfigurator != null ? class$Lorg$apache$log4j$xml$DOMConfigurator : (class$Lorg$apache$log4j$xml$DOMConfigurator = DOMConfigurator.class$("org.apache.log4j.xml.DOMConfigurator"))).getResource("log4j.dtd");
            if (uRL == null) {
                LogLog.error("Could not find log4j.dtd.");
            } else {
                LogLog.debug("URL to log4j.dtd is [" + uRL.toString() + "].");
                inputSource.setSystemId(uRL.toString());
            }
            Document document = documentBuilder.parse(inputSource);
            this.parse(document.getDocumentElement(), hierarchy);
        }
        catch (Exception exception) {
            LogLog.error("Could not parse input stream [" + inputStream + "].", exception);
        }
    }

    public static void configure(String string) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(string, Category.getDefaultHierarchy());
    }

    protected void parse(Element element, Hierarchy hierarchy) {
        if (!element.getTagName().equals(CONFIGURATION_TAG)) {
            LogLog.error("DOM element is not a <configuration> element");
            return;
        }
        String string = element.getAttribute(CONFIG_DEBUG_ATTR);
        LogLog.debug("configDebug attribute= \"" + string + "\".");
        if (!string.equals(EMPTY_STR) && !string.equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string, true));
        } else {
            LogLog.debug("Ignoring configDebug attribute.");
        }
        String string2 = element.getAttribute(SCFO_ATTR);
        LogLog.debug("Disable override=\"" + string2 + "\".");
        if (!string2.equals(EMPTY_STR) && !string2.equals("null")) {
            BasicConfigurator.overrideAsNeeded(string2);
        } else {
            LogLog.debug("Ignoring disableOverride attribute.");
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string3 = element2.getTagName();
                if (string3.equals(CATEGORY)) {
                    this.parseCategory(element2, hierarchy);
                } else if (string3.equals(ROOT_TAG)) {
                    this.parseRoot(element2, hierarchy);
                } else if (string3.equals(RENDERER_TAG)) {
                    this.parserRenderer(element2);
                }
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

