#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "../src/object.h"

#define PI 3.14159265358979

int main()
{
	FILE *in, *out;
	char line[1000];
	int n;
	double x, y, z;
	struct object obj;

	int rah, ram, decd, decm, i;
        double decs, ra, ras, dec;

	float sizelist[2000];

	in=fopen("../raw/pn_catalog.dat", "r");
	out=fopen("pn_catalog.cat", "w");
	for(n=0;;n++)
	{
		fgets(line, 999, in);
		if(feof(in)) break;

		line[34] = 0;
		if(line[44] <= ' ') line[44] = '0';
		sscanf(line+12, "%d %d %lf %d %d %lf", &rah, &ram, &ras, 
			&decd, &decm, &decs);
			
		ra  = (double)rah + (double)ram/60.0 + ras/3600.0;
                dec = fabs(decd) + (double)decm/60.0 + decs/3600.0;
		if(line[23] == '-') dec = -dec;

		ra = -ra*PI/12.0;
		dec = dec*PI/180.0;

		x = cos(ra)*cos(dec);
		y = sin(ra)*cos(dec);
		z = sin(dec);

		obj.x = (long)(x*(double)(1<<30));
                obj.y = (long)(y*(double)(1<<30));
                obj.z = (long)(z*(double)(1<<30));
		obj.type=228;
                obj.icon = 0;
		if(ra == 0.0 && dec == 0.0) obj.mask = 0x8F;
                else obj.mask = 0x0F;
                obj.mag = 0;

		fwrite(&obj, 1, sizeof(obj), out);
	}
	fclose(in);

	in = fopen("../raw/pn_diam.dat", "r");
	if(in == 0)
	{
		printf("Can't find diam file!\n");
		return 0;
	}
	for(i = 0; i < n; i++)
	{
		fgets(line, 999, in);
                if(feof(in))
		{
			printf("File sizes don't match!\n");
			return 0;
		}
		line[19] = 0;
		sizelist[i] = atof(line+13)/60.0;
	}
	fclose(in);

	fwrite(sizelist, n, sizeof(float), out);
	fclose(out);
	printf("%d planetary nebulae loaded\n", n);

	return 0;
}
