/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include "iconlist.h"
#include "picture.h"
#include "object.h"
#include "errors.h"

int loadpointicons(struct iconlist *il, FILE *in, int slotnum, int num)
{
	char line[1000];
	int r, g, b;
	int i, j;

	il->rgb_r[slotnum] = g_new(unsigned char, num);
	il->rgb_g[slotnum] = g_new(unsigned char, num);
	il->rgb_b[slotnum] = g_new(unsigned char, num);
	il->numicons[slotnum] = num;
	for(j = 0; j < num;)
	{
		fgets(line, 999, in);
		if(feof(in)) return SHORT_FILE;
		for(i = 0; line[i] != 0; i++)
			if(line[i] == '#' || line[i] < ' ') line[i] = 0;
		if(line[0] == 0) continue;
		if(sscanf(line, "%d%d%d", &r, &g, &b) != 3) return BAD_RGB;
		il->rgb_r[slotnum][j] = r;
		il->rgb_g[slotnum][j] = g;
		il->rgb_b[slotnum][j] = b;
		j++;
	}
	return SUCCESS;
}

int loadpictureicons(struct iconlist *il, FILE *in, int slotnum, int num)
{
        int i, j;
        char line[1000];
	gchar *fullfilename;

        il->icon[slotnum-64] = g_new(struct picture, num);
        il->numicons[slotnum] = num;

        for(j = 0; j < num;)
        {
                fgets(line, 999, in);
                if(feof(in)) return SHORT_FILE;
                for(i = 0; line[i] != 0; i++)
                        if(line[i] == '#' || line[i] < ' ') line[i] = 0;
                if(line[0] == 0) continue;
		
		fullfilename = g_strconcat(PREFIXDIR, "/share/stars/pic/", line, 0);
                if(loadpicture(&(il->icon[slotnum-64][j]), fullfilename) != 1)
                {
                        fprintf(stderr, "WARNING: Icon not loaded: %s\n", fullfilename);
                        il->icon[slotnum-64][j].w = 1;
                        il->icon[slotnum-64][j].h = 1;
                        il->icon[slotnum-64][j].hotx = 0;
                        il->icon[slotnum-64][j].hoty = 0;
                        il->icon[slotnum-64][j].data = g_new(unsigned char, 3);
                        il->icon[slotnum-64][j].data[0] = 0;
                        il->icon[slotnum-64][j].data[1] = 0;
                        il->icon[slotnum-64][j].data[2] = 0;
                }
		g_free(fullfilename);
                j++;
        }

        return SUCCESS;
}

int loadlineicons(struct iconlist *il, FILE *in, int slotnum, int num)
{
	char line[1000];
	int r, g, b;
	int i, j;
	float t;

	il->line_r[slotnum-192] = g_new(unsigned char, num);
	il->line_g[slotnum-192] = g_new(unsigned char, num);
	il->line_b[slotnum-192] = g_new(unsigned char, num);
	il->line_thick[slotnum-192] = g_new(float, num);
	il->numicons[slotnum] = num;
	for(j = 0; j < num;)
	{
		fgets(line, 999, in);
		if(feof(in)) return SHORT_FILE;
		for(i = 0; line[i] != 0; i++)
			if(line[i] == '#' || line[i] < ' ') line[i] = 0;
		if(line[0] == 0) continue;
		if(sscanf(line, "%d%d%d%f", &r, &g, &b, &t) != 4) 
			return BAD_RGB;
		il->line_r[slotnum-192][j] = r;
		il->line_g[slotnum-192][j] = g;
		il->line_b[slotnum-192][j] = b;
		il->line_thick[slotnum-192][j] = t;
		j++;
	}
	return SUCCESS;
}

int loadfuncicons(struct iconlist *il, FILE *in, int slotnum, int num)
{
	char line[1000], name[30];
	int r, g, b;
	int i, j;

	plugindata *pd;

	il->func_r[slotnum-224] = g_new(unsigned char, num);
	il->func_g[slotnum-224] = g_new(unsigned char, num);
	il->func_b[slotnum-224] = g_new(unsigned char, num);
	il->drawfuncs[slotnum-224] = g_new(plugindrawfunc, num);
	il->printfuncs[slotnum-224] = g_new(pluginprintfunc, num);
	for(j = 0; j < num;)
	{
		fgets(line, 999, in);
		if(feof(in)) return SHORT_FILE;
		for(i = 0; line[i] != 0; i++)
			if(line[i] == '#' || line[i] < ' ') line[i] = 0;
		if(line[0] == 0) continue;
		if(sscanf(line, "%d %d %d %s", &r, &g, &b, name) != 4)
			return BAD_RGB;
		il->func_r[slotnum-224][j] = r;
		il->func_g[slotnum-224][j] = g;
		il->func_b[slotnum-224][j] = b;
		pd = getplugindata(name);
		il->drawfuncs[slotnum-224][j] = pd->drawfunc;
		il->printfuncs[slotnum-224][j] = pd->printfunc;
		j++;
	}
	return SUCCESS;
}

struct iconlist *newiconlist(const char *iconlistfile)
{
	FILE *in;
	struct iconlist *il;
	char line[1000], class[100];
	int num, slotnum;
	int i;
	int error;

	in = fopen(iconlistfile, "r");
	if(in == 0) return 0;
	il = g_new(struct iconlist, 1);

	for(i = 0; i < 64; i++) il->rgb_r[i] = 0;
	for(i = 0; i < 64; i++) il->rgb_g[i] = 0;
	for(i = 0; i < 64; i++) il->rgb_b[i] = 0;
	for(i = 0; i < 128; i++) il->icon[i] = 0;
	for(i = 0; i < 32; i++) il->line_r[i] = 0;
	for(i = 0; i < 32; i++) il->line_g[i] = 0;
	for(i = 0; i < 32; i++) il->line_b[i] = 0;
	for(i = 0; i < 32; i++) il->line_thick[i] = 0;
	for(i = 0; i < 256; i++) il->name[i] = 0;
	for(i = 0; i < 256; i++) il->numicons[i] = 0;

	for(;;)
	{
		fgets(line, 999, in);
		if(feof(in)) break;
		for(i = 0; line[i] != 0; i++)
		{
			if(line[i] == '#' || line[i] < ' ') line[i] = 0;
			if(line[i] == 0) break;
		}
		if(line[0] == 0) continue;

		if(sscanf(line, "%d %d %s", &slotnum, &num, class) != 3)
		{
			fprintf(stderr, "newiconlist: error in file %s", 
				iconlistfile);
			destroyiconlist(il);
			return 0;
		}

		il->name[slotnum] = g_strdup(class);
		il->classindex[slotnum] = getclassheader(class);
/*
		if(il->classindex[slotnum] == 0)
		{
			fprintf(stderr, 
				"Warning: Class %s without extension defs\n",
				class);
		}
*/
		if(slotnum >= 0 && slotnum < 64) 
			error = loadpointicons(il, in, slotnum, num);
		else if(slotnum >= 64 && slotnum < 192) 
			error = loadpictureicons(il, in, slotnum, num);
		else if(slotnum >= 192 && slotnum < 224) 
			error = loadlineicons(il, in, slotnum, num);
		else if(slotnum >= 224 && slotnum < 255)
			error = loadfuncicons(il, in, slotnum, num);
		else error = BAD_SLOT_NUM;
		if(error < 0) 
		{
			fprintf(stderr, "newiconlist: errorcode %d "
				"reading file %s\n", error, iconlistfile);
			destroyiconlist(il);
			return 0;
		}
	}
	fclose(in);

	return il;
}

void destroyiconlist(struct iconlist *il)
{
	int i, j;

	if(il == 0)
	{
		fprintf(stderr, "destroyiconlist: warning - attempting to "
			"destroy a null iconlist\n");
		return;
	}

	for(i = 0; i < 64; i++)
	{
		g_free(il->rgb_r[i]);
		g_free(il->rgb_g[i]);
		g_free(il->rgb_b[i]);
	}
	for(i = 0; i < 128; i++) if(il->icon[i] != 0) 
	{
		for(j = 0; j < il->numicons[i+64]; j++)
			g_free(il->icon[i][j].data);
		g_free(il->icon[i]);
	}
	for(i = 0; i < 32; i++) 
	{
		g_free(il->line_r[i]);
		g_free(il->line_g[i]);
		g_free(il->line_b[i]);
		g_free(il->line_thick[i]);
	}
	for(i = 0; i < 256; i++) g_free(il->name[i]);

	free(il);
}
