/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of SableCC.                             *
 * See the file "LICENSE" for copyright information and the  *
 * terms and conditions for copying, distribution and        *
 * modification of SableCC.                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package org.sablecc.sablecc.node;

import org.sablecc.sablecc.analysis.Analysis;
import org.sablecc.sablecc.Switchable;

public abstract class Node implements Switchable
{
    private static int nextId =0;

    private final int id = nextId++;
    private Node parent;

    public int getId()
    {
        return id;
    }

    public Node getParent()
    {
        return parent;
    }

    void setParent(Node parent)
    {
        this.parent = parent;
    }

    abstract void removeChild(Node child);

    public Object getIn(Analysis analysis)
    {
        return analysis.getIn(this);
    }

    public void setIn(Analysis analysis, Object in)
    {
        analysis.setIn(this, in);
    }

    public Object getOut(Analysis analysis)
    {
        return analysis.getOut(this);
    }

    public void setOut(Analysis analysis, Object out)
    {
        analysis.setOut(this, out);
    }
}

