// ============================================================================
// Rocks'n'Diamonds - McDuffin Strikes Back!
// ----------------------------------------------------------------------------
// (c) 1995-2014 by Artsoft Entertainment
//     		    Holger Schemel
//		    info@artsoft.org
//		    https://www.artsoft.org/
// ----------------------------------------------------------------------------
// conf_gfx.c
// ============================================================================

#include "libgame/libgame.h"
#include "main.h"


// List values that are not defined in the configuration file are set to
// reliable default values. If that value is GFX_ARG_UNDEFINED, it will
// be dynamically determined, using some of the other list values.

struct ConfigTypeInfo image_config_suffix[] =
{
  { ".x",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".y",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".xpos",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".ypos",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".width",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".height",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".vertical",			"false",	TYPE_BOOLEAN	},
  { ".offset",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".xoffset",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".yoffset",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".2nd_movement_tile",		"false",	TYPE_BOOLEAN	},
  { ".2nd_vertical",			ARG_UNDEFINED,	TYPE_BOOLEAN	},
  { ".2nd_offset",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".2nd_xoffset",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".2nd_yoffset",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".2nd_swap_tiles",			ARG_UNDEFINED,	TYPE_BOOLEAN	},
  { ".frames",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".frames_per_line",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".start_frame",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".delay",				"1",		TYPE_INTEGER	},
  { ".anim_mode",			ARG_UNDEFINED,	TYPE_STRING	},
  { ".global_sync",			"false",	TYPE_BOOLEAN	},
  { ".crumbled_like",			ARG_UNDEFINED,	TYPE_ELEMENT	},
  { ".diggable_like",			ARG_UNDEFINED,	TYPE_ELEMENT	},
  { ".border_size",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".step_offset",			"4",		TYPE_INTEGER	},
  { ".step_xoffset",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".step_yoffset",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".step_delay",			"1",		TYPE_INTEGER	},
  { ".direction",			ARG_UNDEFINED,	TYPE_STRING	},
  { ".position",			ARG_UNDEFINED,	TYPE_STRING	},
  { ".draw_xoffset",			"0",		TYPE_INTEGER	},
  { ".draw_yoffset",			"0",		TYPE_INTEGER	},
  { ".draw_masked",			ARG_UNDEFINED,	TYPE_BOOLEAN	},
  { ".draw_order",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".init_delay_fixed",		ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".init_delay_random",		ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".init_delay_action",		ARG_UNDEFINED,	TYPE_STRING	},
  { ".anim_delay_fixed",		ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".anim_delay_random",		ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".anim_delay_action",		ARG_UNDEFINED,	TYPE_STRING	},
  { ".post_delay_fixed",		ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".post_delay_random",		ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".post_delay_action",		ARG_UNDEFINED,	TYPE_STRING	},
  { ".init_event",			ARG_UNDEFINED,	TYPE_STRING	},
  { ".init_event_action",		ARG_UNDEFINED,	TYPE_STRING	},
  { ".anim_event",			ARG_UNDEFINED,	TYPE_STRING	},
  { ".anim_event_action",		ARG_UNDEFINED,	TYPE_STRING	},
  { ".name",				ARG_UNDEFINED,	TYPE_STRING	},
  { ".scale_up_factor",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".tile_size",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".clone_from",			ARG_UNDEFINED,	TYPE_GRAPHIC	},
  { ".fade_mode",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".fade_delay",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".post_delay",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".auto_delay",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".auto_delay_unit",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".align",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".valign",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".sort_priority",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".class",				ARG_UNDEFINED,	TYPE_STRING	},
  { ".style",				ARG_UNDEFINED,	TYPE_STRING	},
  { ".active_xoffset",			"0",		TYPE_INTEGER	},
  { ".active_yoffset",			"0",		TYPE_INTEGER	},
  { ".pressed_xoffset",			"0",		TYPE_INTEGER	},
  { ".pressed_yoffset",			"0",		TYPE_INTEGER	},

  { NULL,				NULL,		0		}
};

struct ConfigInfo image_config[] =
{
  // ==========================================================================
  // image definitions for game elements (for in-game and editor graphics)
  // ==========================================================================

  // images for Boulder Dash style elements and actions

  { "bd_wall",					"RocksDC.png"		},
  { "bd_wall.xpos",				"12"			},
  { "bd_wall.ypos",				"9"			},
  { "bd_wall.frames",				"1"			},
  { "bd_wall.EDITOR",				"RocksDC.png"		},
  { "bd_wall.EDITOR.xpos",			"14"			},
  { "bd_wall.EDITOR.ypos",			"13"			},

  { "bd_rock",					"RocksDC.png"		},
  { "bd_rock.xpos",				"12"			},
  { "bd_rock.ypos",				"10"			},
  { "bd_rock.frames",				"1"			},
  { "bd_rock.EDITOR",				"RocksDC.png"		},
  { "bd_rock.EDITOR.xpos",			"14"			},
  { "bd_rock.EDITOR.ypos",			"14"			},
  { "bd_rock.moving.left",			"RocksDC.png"		},
  { "bd_rock.moving.left.xpos",			"12"			},
  { "bd_rock.moving.left.ypos",			"10"			},
  { "bd_rock.moving.left.frames",		"4"			},
  { "bd_rock.moving.left.delay",		"2"			},
  { "bd_rock.moving.left.anim_mode",		"reverse"		},
  { "bd_rock.moving.right",			"RocksDC.png"		},
  { "bd_rock.moving.right.xpos",		"12"			},
  { "bd_rock.moving.right.ypos",		"10"			},
  { "bd_rock.moving.right.frames",		"4"			},
  { "bd_rock.moving.right.start_frame",		"1"			},
  { "bd_rock.moving.right.delay",		"2"			},
  { "bd_rock.pushing.left",			"RocksDC.png"		},
  { "bd_rock.pushing.left.xpos",		"12"			},
  { "bd_rock.pushing.left.ypos",		"10"			},
  { "bd_rock.pushing.left.frames",		"4"			},
  { "bd_rock.pushing.left.delay",		"2"			},
  { "bd_rock.pushing.left.anim_mode",		"reverse"		},
  { "bd_rock.pushing.right",			"RocksDC.png"		},
  { "bd_rock.pushing.right.xpos",		"12"			},
  { "bd_rock.pushing.right.ypos",		"10"			},
  { "bd_rock.pushing.right.frames",		"4"			},
  { "bd_rock.pushing.right.start_frame",	"1"			},
  { "bd_rock.pushing.right.delay",		"2"			},

  { "bd_diamond",				"RocksElements.png"	},
  { "bd_diamond.xpos",				"0"			},
  { "bd_diamond.ypos",				"10"			},
  { "bd_diamond.frames",			"4"			},
  { "bd_diamond.delay",				"4"			},
  { "bd_diamond.anim_mode",			"reverse"		},
  { "bd_diamond.moving",			"RocksElements.png"	},
  { "bd_diamond.moving.xpos",			"3"			},
  { "bd_diamond.moving.ypos",			"10"			},
  { "bd_diamond.moving.frames",			"2"			},
  { "bd_diamond.moving.delay",			"4"			},
  { "bd_diamond.falling",			"RocksElements.png"	},
  { "bd_diamond.falling.xpos",			"3"			},
  { "bd_diamond.falling.ypos",			"10"			},
  { "bd_diamond.falling.frames",		"2"			},
  { "bd_diamond.falling.delay",			"4"			},

  { "bd_magic_wall",				"RocksElements.png"	},
  { "bd_magic_wall.xpos",			"12"			},
  { "bd_magic_wall.ypos",			"10"			},
  { "bd_magic_wall.frames",			"1"			},
  { "bd_magic_wall.active",			"RocksElements.png"	},
  { "bd_magic_wall.active.xpos",		"12"			},
  { "bd_magic_wall.active.ypos",		"10"			},
  { "bd_magic_wall.active.frames",		"4"			},
  { "bd_magic_wall.active.anim_mode",		"reverse"		},
  { "bd_magic_wall.active.delay",		"4"			},
  { "bd_magic_wall.active.global_sync",		"true"			},
  { "bd_magic_wall.filling",			"RocksElements.png"	},
  { "bd_magic_wall.filling.xpos",		"12"			},
  { "bd_magic_wall.filling.ypos",		"10"			},
  { "bd_magic_wall.filling.frames",		"4"			},
  { "bd_magic_wall.filling.anim_mode",		"reverse"		},
  { "bd_magic_wall.filling.delay",		"4"			},
  { "bd_magic_wall.filling.global_sync",	"true"			},
  { "bd_magic_wall_full",			"RocksElements.png"	},
  { "bd_magic_wall_full.xpos",			"12"			},
  { "bd_magic_wall_full.ypos",			"10"			},
  { "bd_magic_wall_full.frames",		"4"			},
  { "bd_magic_wall_full.anim_mode",		"reverse"		},
  { "bd_magic_wall_full.delay",			"4"			},
  { "bd_magic_wall_full.global_sync",		"true"			},
  { "bd_magic_wall.emptying",			"RocksElements.png"	},
  { "bd_magic_wall.emptying.xpos",		"12"			},
  { "bd_magic_wall.emptying.ypos",		"10"			},
  { "bd_magic_wall.emptying.frames",		"4"			},
  { "bd_magic_wall.emptying.anim_mode",		"reverse"		},
  { "bd_magic_wall.emptying.delay",		"4"			},
  { "bd_magic_wall.emptying.global_sync",	"true"			},
  { "bd_magic_wall_dead",			"RocksElements.png"	},
  { "bd_magic_wall_dead.xpos",			"12"			},
  { "bd_magic_wall_dead.ypos",			"10"			},
  { "bd_magic_wall_dead.frames",		"1"			},

  { "bd_amoeba",				"RocksElements.png"	},
  { "bd_amoeba.xpos",				"8"			},
  { "bd_amoeba.ypos",				"6"			},
  { "bd_amoeba.frames",				"4"			},
  { "bd_amoeba.delay",				"1000000"		},
  { "bd_amoeba.anim_mode",			"random"		},
  { "bd_amoeba.EDITOR",				"RocksElements.png"	},
  { "bd_amoeba.EDITOR.xpos",			"8"			},
  { "bd_amoeba.EDITOR.ypos",			"7"			},

  { "bd_butterfly",				"RocksElements.png"	},
  { "bd_butterfly.xpos",			"4"			},
  { "bd_butterfly.ypos",			"12"			},
  { "bd_butterfly.frames",			"2"			},
  { "bd_butterfly.anim_mode",			"pingpong"		},
  { "bd_butterfly.delay",			"4"			},
  { "bd_butterfly.global_sync",			"true"			},
  { "bd_butterfly.right",			"RocksElements.png"	},
  { "bd_butterfly.right.xpos",			"4"			},
  { "bd_butterfly.right.ypos",			"12"			},
  { "bd_butterfly.right.frames",		"2"			},
  { "bd_butterfly.right.anim_mode",		"pingpong"		},
  { "bd_butterfly.right.delay",			"4"			},
  { "bd_butterfly.right.global_sync",		"true"			},
  { "bd_butterfly.right.EDITOR",		"RocksElements.png"	},
  { "bd_butterfly.right.EDITOR.xpos",		"8"			},
  { "bd_butterfly.right.EDITOR.ypos",		"12"			},
  { "bd_butterfly.up",				"RocksElements.png"	},
  { "bd_butterfly.up.xpos",			"4"			},
  { "bd_butterfly.up.ypos",			"12"			},
  { "bd_butterfly.up.frames",			"2"			},
  { "bd_butterfly.up.anim_mode",		"pingpong"		},
  { "bd_butterfly.up.delay",			"4"			},
  { "bd_butterfly.up.global_sync",		"true"			},
  { "bd_butterfly.up.EDITOR",			"RocksElements.png"	},
  { "bd_butterfly.up.EDITOR.xpos",		"9"			},
  { "bd_butterfly.up.EDITOR.ypos",		"12"			},
  { "bd_butterfly.left",			"RocksElements.png"	},
  { "bd_butterfly.left.xpos",			"4"			},
  { "bd_butterfly.left.ypos",			"12"			},
  { "bd_butterfly.left.frames",			"2"			},
  { "bd_butterfly.left.anim_mode",		"pingpong"		},
  { "bd_butterfly.left.delay",			"4"			},
  { "bd_butterfly.left.global_sync",		"true"			},
  { "bd_butterfly.left.EDITOR",			"RocksElements.png"	},
  { "bd_butterfly.left.EDITOR.xpos",		"10"			},
  { "bd_butterfly.left.EDITOR.ypos",		"12"			},
  { "bd_butterfly.down",			"RocksElements.png"	},
  { "bd_butterfly.down.xpos",			"4"			},
  { "bd_butterfly.down.ypos",			"12"			},
  { "bd_butterfly.down.frames",			"2"			},
  { "bd_butterfly.down.anim_mode",		"pingpong"		},
  { "bd_butterfly.down.delay",			"4"			},
  { "bd_butterfly.down.global_sync",		"true"			},
  { "bd_butterfly.down.EDITOR",			"RocksElements.png"	},
  { "bd_butterfly.down.EDITOR.xpos",		"11"			},
  { "bd_butterfly.down.EDITOR.ypos",		"12"			},

  { "bd_firefly",				"RocksElements.png"	},
  { "bd_firefly.xpos",				"6"			},
  { "bd_firefly.ypos",				"12"			},
  { "bd_firefly.frames",			"2"			},
  { "bd_firefly.anim_mode",			"pingpong"		},
  { "bd_firefly.delay",				"4"			},
  { "bd_firefly.global_sync",			"true"			},
  { "bd_firefly.right",				"RocksElements.png"	},
  { "bd_firefly.right.xpos",			"6"			},
  { "bd_firefly.right.ypos",			"12"			},
  { "bd_firefly.right.frames",			"2"			},
  { "bd_firefly.right.anim_mode",		"pingpong"		},
  { "bd_firefly.right.delay",			"4"			},
  { "bd_firefly.right.global_sync",		"true"			},
  { "bd_firefly.right.EDITOR",			"RocksElements.png"	},
  { "bd_firefly.right.EDITOR.xpos",		"12"			},
  { "bd_firefly.right.EDITOR.ypos",		"12"			},
  { "bd_firefly.up",				"RocksElements.png"	},
  { "bd_firefly.up.xpos",			"6"			},
  { "bd_firefly.up.ypos",			"12"			},
  { "bd_firefly.up.frames",			"2"			},
  { "bd_firefly.up.anim_mode",			"pingpong"		},
  { "bd_firefly.up.delay",			"4"			},
  { "bd_firefly.up.global_sync",		"true"			},
  { "bd_firefly.up.EDITOR",			"RocksElements.png"	},
  { "bd_firefly.up.EDITOR.xpos",		"13"			},
  { "bd_firefly.up.EDITOR.ypos",		"12"			},
  { "bd_firefly.left",				"RocksElements.png"	},
  { "bd_firefly.left.xpos",			"6"			},
  { "bd_firefly.left.ypos",			"12"			},
  { "bd_firefly.left.frames",			"2"			},
  { "bd_firefly.left.anim_mode",		"pingpong"		},
  { "bd_firefly.left.delay",			"4"			},
  { "bd_firefly.left.global_sync",		"true"			},
  { "bd_firefly.left.EDITOR",			"RocksElements.png"	},
  { "bd_firefly.left.EDITOR.xpos",		"14"			},
  { "bd_firefly.left.EDITOR.ypos",		"12"			},
  { "bd_firefly.down",				"RocksElements.png"	},
  { "bd_firefly.down.xpos",			"6"			},
  { "bd_firefly.down.ypos",			"12"			},
  { "bd_firefly.down.frames",			"2"			},
  { "bd_firefly.down.anim_mode",		"pingpong"		},
  { "bd_firefly.down.delay",			"4"			},
  { "bd_firefly.down.global_sync",		"true"			},
  { "bd_firefly.down.EDITOR",			"RocksElements.png"	},
  { "bd_firefly.down.EDITOR.xpos",		"15"			},
  { "bd_firefly.down.EDITOR.ypos",		"12"			},

  // images for Supaplex style elements and actions

  { "[sp_default].exploding",			"RocksSP.png"		},
  { "[sp_default].exploding.xpos",		"8"			},
  { "[sp_default].exploding.ypos",		"3"			},
  { "[sp_default].exploding.frames",		"8"			},
  { "[sp_default].exploding.delay",		"4"			},
  { "[sp_default].exploding.anim_mode",		"linear"		},

  { "sp_zonk",					"RocksSP.png"		},
  { "sp_zonk.xpos",				"1"			},
  { "sp_zonk.ypos",				"0"			},
  { "sp_zonk.frames",				"1"			},
  { "sp_zonk.moving.left",			"RocksSP.png"		},
  { "sp_zonk.moving.left.xpos",			"0"			},
  { "sp_zonk.moving.left.ypos",			"6"			},
  { "sp_zonk.moving.left.frames",		"4"			},
  { "sp_zonk.moving.left.delay",		"1"			},
  { "sp_zonk.moving.left.anim_mode",		"reverse"		},
  { "sp_zonk.moving.right",			"RocksSP.png"		},
  { "sp_zonk.moving.right.xpos",		"0"			},
  { "sp_zonk.moving.right.ypos",		"6"			},
  { "sp_zonk.moving.right.frames",		"4"			},
  { "sp_zonk.moving.right.start_frame",		"1"			},
  { "sp_zonk.moving.right.delay",		"1"			},
  { "sp_zonk.pushing.left",			"RocksSP.png"		},
  { "sp_zonk.pushing.left.xpos",		"0"			},
  { "sp_zonk.pushing.left.ypos",		"6"			},
  { "sp_zonk.pushing.left.frames",		"4"			},
  { "sp_zonk.pushing.left.delay",		"1"			},
  { "sp_zonk.pushing.left.anim_mode",		"reverse"		},
  { "sp_zonk.pushing.right",			"RocksSP.png"		},
  { "sp_zonk.pushing.right.xpos",		"0"			},
  { "sp_zonk.pushing.right.ypos",		"6"			},
  { "sp_zonk.pushing.right.frames",		"4"			},
  { "sp_zonk.pushing.right.start_frame",	"1"			},
  { "sp_zonk.pushing.right.delay",		"1"			},

  { "sp_base",					"RocksSP.png"		},
  { "sp_base.xpos",				"2"			},
  { "sp_base.ypos",				"0"			},
  { "sp_base.frames",				"1"			},
  { "sp_base.digging",				"RocksSP.png"		},
  { "sp_base.digging.xpos",			"2"			},
  { "sp_base.digging.ypos",			"0"			},
  { "sp_base.digging.frames",			"1"			},
  { "sp_base.digging.anim_mode",		"opaque_player"		},
  { "sp_base.snapping",				"RocksSP.png"		},
  { "sp_base.snapping.xpos",			"8"			},
  { "sp_base.snapping.ypos",			"2"			},
  { "sp_base.snapping.frames",			"7"			},
  { "sp_base.snapping.anim_mode",		"linear"		},

  { "sp_murphy",				"RocksSP.png"		},
  { "sp_murphy.xpos",				"3"			},
  { "sp_murphy.ypos",				"0"			},
  { "sp_murphy.frames",				"1"			},
  { "sp_murphy.moving.left",			"RocksSP.png"		},
  { "sp_murphy.moving.left.xpos",		"8"			},
  { "sp_murphy.moving.left.ypos",		"0"			},
  { "sp_murphy.moving.left.frames",		"3"			},
  { "sp_murphy.moving.left.anim_mode",		"pingpong"		},
  { "sp_murphy.moving.left.delay",		"2"			},
  { "sp_murphy.moving.left.start_frame",	"1"			},
  { "sp_murphy.moving.right",			"RocksSP.png"		},
  { "sp_murphy.moving.right.xpos",		"11"			},
  { "sp_murphy.moving.right.ypos",		"0"			},
  { "sp_murphy.moving.right.frames",		"3"			},
  { "sp_murphy.moving.right.anim_mode",		"pingpong"		},
  { "sp_murphy.moving.right.delay",		"2"			},
  { "sp_murphy.moving.right.start_frame",	"1"			},
  { "sp_murphy.digging.left",			"RocksSP.png"		},
  { "sp_murphy.digging.left.xpos",		"8"			},
  { "sp_murphy.digging.left.ypos",		"0"			},
  { "sp_murphy.digging.left.frames",		"3"			},
  { "sp_murphy.digging.left.anim_mode",		"pingpong"		},
  { "sp_murphy.digging.left.delay",		"2"			},
  { "sp_murphy.digging.left.start_frame",	"1"			},
  { "sp_murphy.digging.right",			"RocksSP.png"		},
  { "sp_murphy.digging.right.xpos",		"11"			},
  { "sp_murphy.digging.right.ypos",		"0"			},
  { "sp_murphy.digging.right.frames",		"3"			},
  { "sp_murphy.digging.right.anim_mode",	"pingpong"		},
  { "sp_murphy.digging.right.delay",		"2"			},
  { "sp_murphy.digging.right.start_frame",	"1"			},
  { "sp_murphy.collecting.left",		"RocksSP.png"		},
  { "sp_murphy.collecting.left.xpos",		"8"			},
  { "sp_murphy.collecting.left.ypos",		"0"			},
  { "sp_murphy.collecting.left.frames",		"3"			},
  { "sp_murphy.collecting.left.anim_mode",	"pingpong"		},
  { "sp_murphy.collecting.left.delay",		"2"			},
  { "sp_murphy.collecting.left.start_frame",	"1"			},
  { "sp_murphy.collecting.right",		"RocksSP.png"		},
  { "sp_murphy.collecting.right.xpos",		"11"			},
  { "sp_murphy.collecting.right.ypos",		"0"			},
  { "sp_murphy.collecting.right.frames",	"3"			},
  { "sp_murphy.collecting.right.anim_mode",	"pingpong"		},
  { "sp_murphy.collecting.right.delay",		"2"			},
  { "sp_murphy.collecting.right.start_frame",	"1"			},
  { "sp_murphy.pushing.left",			"RocksSP.png"		},
  { "sp_murphy.pushing.left.xpos",		"11"			},
  { "sp_murphy.pushing.left.ypos",		"1"			},
  { "sp_murphy.pushing.left.frames",		"1"			},
  { "sp_murphy.pushing.right",			"RocksSP.png"		},
  { "sp_murphy.pushing.right.xpos",		"10"			},
  { "sp_murphy.pushing.right.ypos",		"1"			},
  { "sp_murphy.pushing.right.frames",		"1"			},
  { "sp_murphy.snapping.left",			"RocksSP.png"		},
  { "sp_murphy.snapping.left.xpos",		"9"			},
  { "sp_murphy.snapping.left.ypos",		"1"			},
  { "sp_murphy.snapping.left.frames",		"1"			},
  { "sp_murphy.snapping.right",			"RocksSP.png"		},
  { "sp_murphy.snapping.right.xpos",		"8"			},
  { "sp_murphy.snapping.right.ypos",		"1"			},
  { "sp_murphy.snapping.right.frames",		"1"			},
  { "sp_murphy.snapping.up",			"RocksSP.png"		},
  { "sp_murphy.snapping.up.xpos",		"14"			},
  { "sp_murphy.snapping.up.ypos",		"0"			},
  { "sp_murphy.snapping.up.frames",		"1"			},
  { "sp_murphy.snapping.down",			"RocksSP.png"		},
  { "sp_murphy.snapping.down.xpos",		"15"			},
  { "sp_murphy.snapping.down.ypos",		"0"			},
  { "sp_murphy.snapping.down.frames",		"1"			},
  { "sp_murphy.boring",				"RocksSP.png"		},
  { "sp_murphy.boring.xpos",			"11"			},
  { "sp_murphy.boring.ypos",			"12"			},
  { "sp_murphy.boring.frames",			"1"			},
  { "sp_murphy.boring[1]",			"RocksSP.png"		},
  { "sp_murphy.boring[1].xpos",			"0"			},
  { "sp_murphy.boring[1].ypos",			"12"			},
  { "sp_murphy.boring[1].frames",		"12"			},
  { "sp_murphy.boring[1].delay",		"10"			},
  { "sp_murphy.boring[1].anim_mode",		"linear"		},
  { "sp_murphy.boring[1].anim_delay_fixed",	"120"			},
  { "sp_murphy.boring[1].anim_delay_random",	"0"			},
  { "sp_murphy.boring[1].post_delay_fixed",	"500"			},
  { "sp_murphy.boring[1].post_delay_random",	"500"			},
  { "sp_murphy.sleeping.left",			"RocksSP.png"		},
  { "sp_murphy.sleeping.left.xpos",		"4"			},
  { "sp_murphy.sleeping.left.ypos",		"9"			},
  { "sp_murphy.sleeping.left.frames",		"3"			},
  { "sp_murphy.sleeping.left.delay",		"100"			},
  { "sp_murphy.sleeping.left.anim_mode",	"linear,reverse"	},
  { "sp_murphy.sleeping.right",			"RocksSP.png"		},
  { "sp_murphy.sleeping.right.xpos",		"13"			},
  { "sp_murphy.sleeping.right.ypos",		"12"			},
  { "sp_murphy.sleeping.right.frames",		"3"			},
  { "sp_murphy.sleeping.right.delay",		"100"			},
  { "sp_murphy.sleeping.right.anim_mode",	"linear"		},
  { "sp_murphy.dropping",			"RocksSP.png"		},
  { "sp_murphy.dropping.xpos",			"11"			},
  { "sp_murphy.dropping.ypos",			"12"			},
  { "sp_murphy.dropping.frames",		"1"			},
  { "sp_murphy.shrinking",			"RocksSP.png"		},
  { "sp_murphy.shrinking.xpos",			"8"			},
  { "sp_murphy.shrinking.ypos",			"14"			},
  { "sp_murphy.shrinking.frames",		"8"			},
  { "sp_murphy.shrinking.delay",		"4"			},
  { "sp_murphy.shrinking.anim_mode",		"linear"		},

  { "sp_murphy_clone",				"RocksSP.png"		},
  { "sp_murphy_clone.xpos",			"3"			},
  { "sp_murphy_clone.ypos",			"0"			},
  { "sp_murphy_clone.frames",			"1"			},

  { "sp_infotron",				"RocksSP.png"		},
  { "sp_infotron.xpos",				"4"			},
  { "sp_infotron.ypos",				"0"			},
  { "sp_infotron.frames",			"1"			},
  { "sp_infotron.EDITOR",			"RocksSP.png"		},
  { "sp_infotron.EDITOR.xpos",			"8"			},
  { "sp_infotron.EDITOR.ypos",			"11"			},
  { "sp_infotron.moving.left",			"RocksSP.png"		},
  { "sp_infotron.moving.left.xpos",		"8"			},
  { "sp_infotron.moving.left.ypos",		"13"			},
  { "sp_infotron.moving.left.frames",		"8"			},
  { "sp_infotron.moving.right",			"RocksSP.png"		},
  { "sp_infotron.moving.right.xpos",		"8"			},
  { "sp_infotron.moving.right.ypos",		"13"			},
  { "sp_infotron.moving.right.frames",		"8"			},
  { "sp_infotron.moving.right.start_frame",	"6"			},
  { "sp_infotron.moving.right.anim_mode",	"reverse"		},
  { "sp_infotron.collecting",			"RocksSP.png"		},
  { "sp_infotron.collecting.xpos",		"8"			},
  { "sp_infotron.collecting.ypos",		"7"			},
  { "sp_infotron.collecting.frames",		"8"			},
  { "sp_infotron.collecting.anim_mode",		"linear"		},

  { "sp_chip_single",				"RocksSP.png"		},
  { "sp_chip_single.xpos",			"5"			},
  { "sp_chip_single.ypos",			"0"			},
  { "sp_chip_single.frames",			"1"			},
  { "sp_chip_left",				"RocksSP.png"		},
  { "sp_chip_left.xpos",			"2"			},
  { "sp_chip_left.ypos",			"3"			},
  { "sp_chip_left.frames",			"1"			},
  { "sp_chip_right",				"RocksSP.png"		},
  { "sp_chip_right.xpos",			"3"			},
  { "sp_chip_right.ypos",			"3"			},
  { "sp_chip_right.frames",			"1"			},
  { "sp_chip_top",				"RocksSP.png"		},
  { "sp_chip_top.xpos",				"6"			},
  { "sp_chip_top.ypos",				"4"			},
  { "sp_chip_top.frames",			"1"			},
  { "sp_chip_bottom",				"RocksSP.png"		},
  { "sp_chip_bottom.xpos",			"7"			},
  { "sp_chip_bottom.ypos",			"4"			},
  { "sp_chip_bottom.frames",			"1"			},

  { "sp_hardware_gray",				"RocksSP.png"		},
  { "sp_hardware_gray.xpos",			"6"			},
  { "sp_hardware_gray.ypos",			"0"			},
  { "sp_hardware_gray.frames",			"1"			},
  { "sp_hardware_green",			"RocksSP.png"		},
  { "sp_hardware_green.xpos",			"5"			},
  { "sp_hardware_green.ypos",			"3"			},
  { "sp_hardware_green.frames",			"1"			},
  { "sp_hardware_blue",				"RocksSP.png"		},
  { "sp_hardware_blue.xpos",			"6"			},
  { "sp_hardware_blue.ypos",			"3"			},
  { "sp_hardware_blue.frames",			"1"			},
  { "sp_hardware_red",				"RocksSP.png"		},
  { "sp_hardware_red.xpos",			"7"			},
  { "sp_hardware_red.ypos",			"3"			},
  { "sp_hardware_red.frames",			"1"			},
  { "sp_hardware_yellow",			"RocksSP.png"		},
  { "sp_hardware_yellow.xpos",			"0"			},
  { "sp_hardware_yellow.ypos",			"4"			},
  { "sp_hardware_yellow.frames",		"1"			},

  { "sp_exit_closed",				"RocksSP.png"		},
  { "sp_exit_closed.xpos",			"7"			},
  { "sp_exit_closed.ypos",			"0"			},
  { "sp_exit_closed.frames",			"1"			},
  { "sp_exit.opening",				"RocksSP.png"		},
  { "sp_exit.opening.xpos",			"7"			},
  { "sp_exit.opening.ypos",			"0"			},
  { "sp_exit.opening.frames",			"1"			},
  { "sp_exit_open",				"RocksSP.png"		},
  { "sp_exit_open.xpos",			"7"			},
  { "sp_exit_open.ypos",			"0"			},
  { "sp_exit_open.frames",			"1"			},
  { "sp_exit.closing",				"RocksSP.png"		},
  { "sp_exit.closing.xpos",			"7"			},
  { "sp_exit.closing.ypos",			"0"			},
  { "sp_exit.closing.frames",			"1"			},

  { "sp_disk_orange",				"RocksSP.png"		},
  { "sp_disk_orange.xpos",			"0"			},
  { "sp_disk_orange.ypos",			"1"			},
  { "sp_disk_orange.frames",			"1"			},

  { "sp_disk_yellow",				"RocksSP.png"		},
  { "sp_disk_yellow.xpos",			"2"			},
  { "sp_disk_yellow.ypos",			"2"			},
  { "sp_disk_yellow.frames",			"1"			},

  { "sp_disk_red",				"RocksSP.png"		},
  { "sp_disk_red.xpos",				"4"			},
  { "sp_disk_red.ypos",				"2"			},
  { "sp_disk_red.frames",			"1"			},
  { "sp_disk_red.collecting",			"RocksSP.png"		},
  { "sp_disk_red.collecting.xpos",		"9"			},
  { "sp_disk_red.collecting.ypos",		"5"			},
  { "sp_disk_red.collecting.frames",		"7"			},
  { "sp_disk_red.collecting.anim_mode",		"linear"		},
  { "sp_disk_red.active",			"RocksSP.png"		},
  { "sp_disk_red.active.xpos",			"4"			},
  { "sp_disk_red.active.ypos",			"2"			},
  { "sp_disk_red.active.frames",		"1"			},

  { "sp_port_right",				"RocksSP.png"		},
  { "sp_port_right.xpos",			"1"			},
  { "sp_port_right.ypos",			"1"			},
  { "sp_port_right.frames",			"1"			},
  { "sp_port_down",				"RocksSP.png"		},
  { "sp_port_down.xpos",			"2"			},
  { "sp_port_down.ypos",			"1"			},
  { "sp_port_down.frames",			"1"			},
  { "sp_port_left",				"RocksSP.png"		},
  { "sp_port_left.xpos",			"3"			},
  { "sp_port_left.ypos",			"1"			},
  { "sp_port_left.frames",			"1"			},
  { "sp_port_up",				"RocksSP.png"		},
  { "sp_port_up.xpos",				"4"			},
  { "sp_port_up.ypos",				"1"			},
  { "sp_port_up.frames",			"1"			},
  { "sp_port_horizontal",			"RocksSP.png"		},
  { "sp_port_horizontal.xpos",			"6"			},
  { "sp_port_horizontal.ypos",			"2"			},
  { "sp_port_horizontal.frames",		"1"			},
  { "sp_port_vertical",				"RocksSP.png"		},
  { "sp_port_vertical.xpos",			"5"			},
  { "sp_port_vertical.ypos",			"2"			},
  { "sp_port_vertical.frames",			"1"			},
  { "sp_port_any",				"RocksSP.png"		},
  { "sp_port_any.xpos",				"7"			},
  { "sp_port_any.ypos",				"2"			},
  { "sp_port_any.frames",			"1"			},
  { "sp_gravity_port_right",			"RocksSP.png"		},
  { "sp_gravity_port_right.xpos",		"1"			},
  { "sp_gravity_port_right.ypos",		"1"			},
  { "sp_gravity_port_right.frames",		"1"			},
  { "sp_gravity_port_right.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_port_right.EDITOR.xpos",	"0"			},
  { "sp_gravity_port_right.EDITOR.ypos",	"14"			},
  { "sp_gravity_port_down",			"RocksSP.png"		},
  { "sp_gravity_port_down.xpos",		"2"			},
  { "sp_gravity_port_down.ypos",		"1"			},
  { "sp_gravity_port_down.frames",		"1"			},
  { "sp_gravity_port_down.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_port_down.EDITOR.xpos",		"1"			},
  { "sp_gravity_port_down.EDITOR.ypos",		"14"			},
  { "sp_gravity_port_left",			"RocksSP.png"		},
  { "sp_gravity_port_left.xpos",		"3"			},
  { "sp_gravity_port_left.ypos",		"1"			},
  { "sp_gravity_port_left.frames",		"1"			},
  { "sp_gravity_port_left.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_port_left.EDITOR.xpos",		"2"			},
  { "sp_gravity_port_left.EDITOR.ypos",		"14"			},
  { "sp_gravity_port_up",			"RocksSP.png"		},
  { "sp_gravity_port_up.xpos",			"4"			},
  { "sp_gravity_port_up.ypos",			"1"			},
  { "sp_gravity_port_up.frames",		"1"			},
  { "sp_gravity_port_up.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_port_up.EDITOR.xpos",		"3"			},
  { "sp_gravity_port_up.EDITOR.ypos",		"14"			},
  { "sp_gravity_on_port_right",			"RocksSP.png"		},
  { "sp_gravity_on_port_right.xpos",		"1"			},
  { "sp_gravity_on_port_right.ypos",		"1"			},
  { "sp_gravity_on_port_right.frames",		"1"			},
  { "sp_gravity_on_port_right.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_on_port_right.EDITOR.xpos",	"0"			},
  { "sp_gravity_on_port_right.EDITOR.ypos",	"13"			},
  { "sp_gravity_on_port_down",			"RocksSP.png"		},
  { "sp_gravity_on_port_down.xpos",		"2"			},
  { "sp_gravity_on_port_down.ypos",		"1"			},
  { "sp_gravity_on_port_down.frames",		"1"			},
  { "sp_gravity_on_port_down.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_on_port_down.EDITOR.xpos",	"1"			},
  { "sp_gravity_on_port_down.EDITOR.ypos",	"13"			},
  { "sp_gravity_on_port_left",			"RocksSP.png"		},
  { "sp_gravity_on_port_left.xpos",		"3"			},
  { "sp_gravity_on_port_left.ypos",		"1"			},
  { "sp_gravity_on_port_left.frames",		"1"			},
  { "sp_gravity_on_port_left.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_on_port_left.EDITOR.xpos",	"2"			},
  { "sp_gravity_on_port_left.EDITOR.ypos",	"13"			},
  { "sp_gravity_on_port_up",			"RocksSP.png"		},
  { "sp_gravity_on_port_up.xpos",		"4"			},
  { "sp_gravity_on_port_up.ypos",		"1"			},
  { "sp_gravity_on_port_up.frames",		"1"			},
  { "sp_gravity_on_port_up.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_on_port_up.EDITOR.xpos",	"3"			},
  { "sp_gravity_on_port_up.EDITOR.ypos",	"13"			},
  { "sp_gravity_off_port_right",		"RocksSP.png"		},
  { "sp_gravity_off_port_right.xpos",		"1"			},
  { "sp_gravity_off_port_right.ypos",		"1"			},
  { "sp_gravity_off_port_right.frames",		"1"			},
  { "sp_gravity_off_port_right.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_off_port_right.EDITOR.xpos",	"4"			},
  { "sp_gravity_off_port_right.EDITOR.ypos",	"13"			},
  { "sp_gravity_off_port_down",			"RocksSP.png"		},
  { "sp_gravity_off_port_down.xpos",		"2"			},
  { "sp_gravity_off_port_down.ypos",		"1"			},
  { "sp_gravity_off_port_down.frames",		"1"			},
  { "sp_gravity_off_port_down.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_off_port_down.EDITOR.xpos",	"5"			},
  { "sp_gravity_off_port_down.EDITOR.ypos",	"13"			},
  { "sp_gravity_off_port_left",			"RocksSP.png"		},
  { "sp_gravity_off_port_left.xpos",		"3"			},
  { "sp_gravity_off_port_left.ypos",		"1"			},
  { "sp_gravity_off_port_left.frames",		"1"			},
  { "sp_gravity_off_port_left.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_off_port_left.EDITOR.xpos",	"6"			},
  { "sp_gravity_off_port_left.EDITOR.ypos",	"13"			},
  { "sp_gravity_off_port_up",			"RocksSP.png"		},
  { "sp_gravity_off_port_up.xpos",		"4"			},
  { "sp_gravity_off_port_up.ypos",		"1"			},
  { "sp_gravity_off_port_up.frames",		"1"			},
  { "sp_gravity_off_port_up.EDITOR",		"RocksSP.png"		},
  { "sp_gravity_off_port_up.EDITOR.xpos",	"7"			},
  { "sp_gravity_off_port_up.EDITOR.ypos",	"13"			},

  { "sp_sniksnak",				"RocksSP.png"		},
  { "sp_sniksnak.xpos",				"1"			},
  { "sp_sniksnak.ypos",				"2"			},
  { "sp_sniksnak.frames",			"1"			},
  { "sp_sniksnak.left",				"RocksSP.png"		},
  { "sp_sniksnak.left.xpos",			"8"			},
  { "sp_sniksnak.left.ypos",			"8"			},
  { "sp_sniksnak.left.frames",			"4"			},
  { "sp_sniksnak.left.anim_mode",		"pingpong2"		},
  { "sp_sniksnak.right",			"RocksSP.png"		},
  { "sp_sniksnak.right.xpos",			"12"			},
  { "sp_sniksnak.right.ypos",			"8"			},
  { "sp_sniksnak.right.frames",			"4"			},
  { "sp_sniksnak.right.anim_mode",		"pingpong2"		},
  { "sp_sniksnak.up",				"RocksSP.png"		},
  { "sp_sniksnak.up.xpos",			"8"			},
  { "sp_sniksnak.up.ypos",			"9"			},
  { "sp_sniksnak.up.frames",			"4"			},
  { "sp_sniksnak.up.anim_mode",			"pingpong2"		},
  { "sp_sniksnak.down",				"RocksSP.png"		},
  { "sp_sniksnak.down.xpos",			"12"			},
  { "sp_sniksnak.down.ypos",			"9"			},
  { "sp_sniksnak.down.frames",			"4"			},
  { "sp_sniksnak.down.anim_mode",		"pingpong2"		},
  { "sp_sniksnak.turning_from_left.up",		"RocksSP.png"		},
  { "sp_sniksnak.turning_from_left.up.xpos",	"12"			},
  { "sp_sniksnak.turning_from_left.up.ypos",	"6"			},
  { "sp_sniksnak.turning_from_left.up.frames",	"2"			},
  { "sp_sniksnak.turning_from_left.up.delay",	"4"			},
  { "sp_sniksnak.turning_from_left.up.offset",	"1408"			},
  { "sp_sniksnak.turning_from_left.up.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_left.down",	"RocksSP.png"		},
  { "sp_sniksnak.turning_from_left.down.xpos",	"13"			},
  { "sp_sniksnak.turning_from_left.down.ypos",	"6"			},
  { "sp_sniksnak.turning_from_left.down.frames","2"			},
  { "sp_sniksnak.turning_from_left.down.delay",	"4"			},
  { "sp_sniksnak.turning_from_left.down.offset","1504"			},
  { "sp_sniksnak.turning_from_left.down.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_right.up",	"RocksSP.png"		},
  { "sp_sniksnak.turning_from_right.up.xpos",	"15"			},
  { "sp_sniksnak.turning_from_right.up.ypos",	"6"			},
  { "sp_sniksnak.turning_from_right.up.frames",	"2"			},
  { "sp_sniksnak.turning_from_right.up.delay",	"4"			},
  { "sp_sniksnak.turning_from_right.up.offset",	"1312"			},
  { "sp_sniksnak.turning_from_right.up.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_right.down",	"RocksSP.png"		},
  { "sp_sniksnak.turning_from_right.down.xpos",	"14"			},
  { "sp_sniksnak.turning_from_right.down.ypos",	"6"			},
  { "sp_sniksnak.turning_from_right.down.frames","2"			},
  { "sp_sniksnak.turning_from_right.down.delay","4"			},
  { "sp_sniksnak.turning_from_right.down.offset","1472"			},
  { "sp_sniksnak.turning_from_right.down.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_up.left",		"RocksSP.png"		},
  { "sp_sniksnak.turning_from_up.left.xpos",	"12"			},
  { "sp_sniksnak.turning_from_up.left.ypos",	"6"			},
  { "sp_sniksnak.turning_from_up.left.frames",	"2"			},
  { "sp_sniksnak.turning_from_up.left.delay",	"4"			},
  { "sp_sniksnak.turning_from_up.left.offset",	"896"			},
  { "sp_sniksnak.turning_from_up.left.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_up.right",	"RocksSP.png"		},
  { "sp_sniksnak.turning_from_up.right.xpos",	"15"			},
  { "sp_sniksnak.turning_from_up.right.ypos",	"6"			},
  { "sp_sniksnak.turning_from_up.right.frames",	"2"			},
  { "sp_sniksnak.turning_from_up.right.delay",	"4"			},
  { "sp_sniksnak.turning_from_up.right.offset",	"928"			},
  { "sp_sniksnak.turning_from_up.right.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_down.left",	"RocksSP.png"		},
  { "sp_sniksnak.turning_from_down.left.xpos",	"13"			},
  { "sp_sniksnak.turning_from_down.left.ypos",	"6"			},
  { "sp_sniksnak.turning_from_down.left.frames","2"			},
  { "sp_sniksnak.turning_from_down.left.delay",	"4"			},
  { "sp_sniksnak.turning_from_down.left.offset","864"			},
  { "sp_sniksnak.turning_from_down.left.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_down.right",	"RocksSP.png"		},
  { "sp_sniksnak.turning_from_down.right.xpos",	"14"			},
  { "sp_sniksnak.turning_from_down.right.ypos",	"6"			},
  { "sp_sniksnak.turning_from_down.right.frames","2"			},
  { "sp_sniksnak.turning_from_down.right.delay","4"			},
  { "sp_sniksnak.turning_from_down.right.offset","960"			},
  { "sp_sniksnak.turning_from_down.right.anim_mode","linear"		},

  { "sp_electron",				"RocksSP.png"		},
  { "sp_electron.xpos",				"8"			},
  { "sp_electron.ypos",				"10"			},
  { "sp_electron.frames",			"8"			},
  { "sp_electron.delay",			"4"			},
  { "sp_electron.global_sync",			"true"			},
  { "sp_electron.EDITOR",			"RocksSP.png"		},
  { "sp_electron.EDITOR.xpos",			"10"			},
  { "sp_electron.EDITOR.ypos",			"11"			},
  { "sp_electron.exploding",			"RocksSP.png"		},
  { "sp_electron.exploding.xpos",		"8"			},
  { "sp_electron.exploding.ypos",		"4"			},
  { "sp_electron.exploding.frames",		"8"			},
  { "sp_electron.exploding.delay",		"4"			},
  { "sp_electron.exploding.anim_mode",		"linear"		},

  { "sp_terminal",				"RocksSP.png"		},
  { "sp_terminal.xpos",				"0"			},
  { "sp_terminal.ypos",				"10"			},
  { "sp_terminal.frames",			"7"			},
  { "sp_terminal.delay",			"12"			},
  { "sp_terminal.EDITOR",			"RocksSP.png"		},
  { "sp_terminal.EDITOR.xpos",			"9"			},
  { "sp_terminal.EDITOR.ypos",			"11"			},
  { "sp_terminal.active",			"RocksSP.png"		},
  { "sp_terminal.active.xpos",			"0"			},
  { "sp_terminal.active.ypos",			"11"			},
  { "sp_terminal.active.frames",		"7"			},
  { "sp_terminal.active.delay",			"4"			},

  { "sp_buggy_base",				"RocksSP.png"		},
  { "sp_buggy_base.xpos",			"1"			},
  { "sp_buggy_base.ypos",			"3"			},
  { "sp_buggy_base.frames",			"1"			},
  { "sp_buggy_base.EDITOR",			"RocksSP.png"		},
  { "sp_buggy_base.EDITOR.xpos",		"9"			},
  { "sp_buggy_base.EDITOR.ypos",		"6"			},
  { "sp_buggy_base.activating",			"RocksSP.png"		},
  { "sp_buggy_base.activating.xpos",		"15"			},
  { "sp_buggy_base.activating.ypos",		"2"			},
  { "sp_buggy_base.activating.frames",		"1"			},
  { "sp_buggy_base.active",			"RocksSP.png"		},
  { "sp_buggy_base.active.xpos",		"8"			},
  { "sp_buggy_base.active.ypos",		"6"			},
  { "sp_buggy_base.active.frames",		"4"			},
  { "sp_buggy_base.active.delay",		"4"			},
  { "sp_buggy_base.active.anim_mode",		"pingpong"		},

  { "sp_hardware_base_1",			"RocksSP.png"		},
  { "sp_hardware_base_1.xpos",			"4"			},
  { "sp_hardware_base_1.ypos",			"3"			},
  { "sp_hardware_base_1.frames",		"1"			},
  { "sp_hardware_base_2",			"RocksSP.png"		},
  { "sp_hardware_base_2.xpos",			"1"			},
  { "sp_hardware_base_2.ypos",			"4"			},
  { "sp_hardware_base_2.frames",		"1"			},
  { "sp_hardware_base_3",			"RocksSP.png"		},
  { "sp_hardware_base_3.xpos",			"2"			},
  { "sp_hardware_base_3.ypos",			"4"			},
  { "sp_hardware_base_3.frames",		"1"			},
  { "sp_hardware_base_4",			"RocksSP.png"		},
  { "sp_hardware_base_4.xpos",			"3"			},
  { "sp_hardware_base_4.ypos",			"4"			},
  { "sp_hardware_base_4.frames",		"1"			},
  { "sp_hardware_base_5",			"RocksSP.png"		},
  { "sp_hardware_base_5.xpos",			"4"			},
  { "sp_hardware_base_5.ypos",			"4"			},
  { "sp_hardware_base_5.frames",		"1"			},
  { "sp_hardware_base_6",			"RocksSP.png"		},
  { "sp_hardware_base_6.xpos",			"5"			},
  { "sp_hardware_base_6.ypos",			"4"			},
  { "sp_hardware_base_6.frames",		"1"			},

  // images for Sokoban style elements and actions

  { "sokoban_object",				"RocksElements.png"	},
  { "sokoban_object.xpos",			"9"			},
  { "sokoban_object.ypos",			"7"			},
  { "sokoban_object.frames",			"1"			},

  { "sokoban_field_empty",			"RocksElements.png"	},
  { "sokoban_field_empty.xpos",			"10"			},
  { "sokoban_field_empty.ypos",			"7"			},
  { "sokoban_field_empty.frames",		"1"			},

  { "sokoban_field_full",			"RocksElements.png"	},
  { "sokoban_field_full.xpos",			"11"			},
  { "sokoban_field_full.ypos",			"7"			},
  { "sokoban_field_full.frames",		"1"			},

  { "sokoban_field_player",			"RocksHeroes.png"	},
  { "sokoban_field_player.xpos",		"0"			},
  { "sokoban_field_player.ypos",		"15"			},
  { "sokoban_field_player.frames",		"1"			},

  // images for Emerald Mine style elements and actions

  { "empty_space",				"RocksSP.png"		},
  { "empty_space.xpos",				"0"			},
  { "empty_space.ypos",				"0"			},
  { "empty_space.frames",			"1"			},

  { "sand",					"RocksElements.png"	},
  { "sand.xpos",				"0"			},
  { "sand.ypos",				"0"			},
  { "sand.frames",				"1"			},
  { "sand.CRUMBLED",				"RocksElements.png"	},
  { "sand.CRUMBLED.xpos",			"1"			},
  { "sand.CRUMBLED.ypos",			"0"			},
  { "sand.CRUMBLED.frames",			"1"			},
  { "sand.digging.left",			"RocksMore.png"		},
  { "sand.digging.left.xpos",			"6"			},
  { "sand.digging.left.ypos",			"3"			},
  { "sand.digging.left.frames",			"3"			},
  { "sand.digging.left.delay",			"2"			},
  { "sand.digging.left.anim_mode",		"linear"		},
  { "sand.digging.right",			"RocksMore.png"		},
  { "sand.digging.right.xpos",			"9"			},
  { "sand.digging.right.ypos",			"3"			},
  { "sand.digging.right.frames",		"3"			},
  { "sand.digging.right.delay",			"2"			},
  { "sand.digging.right.anim_mode",		"linear"		},
  { "sand.digging.up",				"RocksMore.png"		},
  { "sand.digging.up.xpos",			"0"			},
  { "sand.digging.up.ypos",			"3"			},
  { "sand.digging.up.frames",			"3"			},
  { "sand.digging.up.delay",			"2"			},
  { "sand.digging.up.anim_mode",		"linear"		},
  { "sand.digging.down",			"RocksMore.png"		},
  { "sand.digging.down.xpos",			"3"			},
  { "sand.digging.down.ypos",			"3"			},
  { "sand.digging.down.frames",			"3"			},
  { "sand.digging.down.delay",			"2"			},
  { "sand.digging.down.anim_mode",		"linear"		},
  { "sand.digging.left.CRUMBLED",		"RocksMore.png"		},
  { "sand.digging.left.CRUMBLED.xpos",		"6"			},
  { "sand.digging.left.CRUMBLED.ypos",		"0"			},
  { "sand.digging.left.CRUMBLED.frames",	"3"			},
  { "sand.digging.left.CRUMBLED.delay",		"2"			},
  { "sand.digging.left.CRUMBLED.anim_mode",	"linear"		},
  { "sand.digging.right.CRUMBLED",		"RocksMore.png"		},
  { "sand.digging.right.CRUMBLED.xpos",		"9"			},
  { "sand.digging.right.CRUMBLED.ypos",		"0"			},
  { "sand.digging.right.CRUMBLED.frames",	"3"			},
  { "sand.digging.right.CRUMBLED.delay",	"2"			},
  { "sand.digging.right.CRUMBLED.anim_mode",	"linear"		},
  { "sand.digging.up.CRUMBLED",			"RocksMore.png"		},
  { "sand.digging.up.CRUMBLED.xpos",		"0"			},
  { "sand.digging.up.CRUMBLED.ypos",		"0"			},
  { "sand.digging.up.CRUMBLED.frames",		"3"			},
  { "sand.digging.up.CRUMBLED.delay",		"2"			},
  { "sand.digging.up.CRUMBLED.anim_mode",	"linear"		},
  { "sand.digging.down.CRUMBLED",		"RocksMore.png"		},
  { "sand.digging.down.CRUMBLED.xpos",		"3"			},
  { "sand.digging.down.CRUMBLED.ypos",		"0"			},
  { "sand.digging.down.CRUMBLED.frames",	"3"			},
  { "sand.digging.down.CRUMBLED.delay",		"2"			},
  { "sand.digging.down.CRUMBLED.anim_mode",	"linear"		},

  { "wall",					"RocksElements.png"	},
  { "wall.xpos",				"5"			},
  { "wall.ypos",				"0"			},
  { "wall.frames",				"1"			},

  { "wall_slippery",				"RocksElements.png"	},
  { "wall_slippery.xpos",			"6"			},
  { "wall_slippery.ypos",			"0"			},
  { "wall_slippery.frames",			"1"			},

  { "steelwall",				"RocksElements.png"	},
  { "steelwall.xpos",				"4"			},
  { "steelwall.ypos",				"0"			},
  { "steelwall.frames",				"1"			},

  { "rock",					"RocksElements.png"	},
  { "rock.xpos",				"12"			},
  { "rock.ypos",				"0"			},
  { "rock.frames",				"1"			},
  { "rock.moving.left",				"RocksElements.png"	},
  { "rock.moving.left.xpos",			"12"			},
  { "rock.moving.left.ypos",			"0"			},
  { "rock.moving.left.frames",			"4"			},
  { "rock.moving.left.delay",			"2"			},
  { "rock.moving.left.anim_mode",		"reverse"		},
  { "rock.moving.right",			"RocksElements.png"	},
  { "rock.moving.right.xpos",			"12"			},
  { "rock.moving.right.ypos",			"0"			},
  { "rock.moving.right.frames",			"4"			},
  { "rock.moving.right.start_frame",		"1"			},
  { "rock.moving.right.delay",			"2"			},
  { "rock.pushing.left",			"RocksElements.png"	},
  { "rock.pushing.left.xpos",			"12"			},
  { "rock.pushing.left.ypos",			"0"			},
  { "rock.pushing.left.frames",			"4"			},
  { "rock.pushing.left.delay",			"2"			},
  { "rock.pushing.left.anim_mode",		"reverse"		},
  { "rock.pushing.right",			"RocksElements.png"	},
  { "rock.pushing.right.xpos",			"12"			},
  { "rock.pushing.right.ypos",			"0"			},
  { "rock.pushing.right.frames",		"4"			},
  { "rock.pushing.right.start_frame",		"1"			},
  { "rock.pushing.right.delay",			"2"			},

  { "emerald",					"RocksElements.png"	},
  { "emerald.xpos",				"8"			},
  { "emerald.ypos",				"0"			},
  { "emerald.frames",				"1"			},
  { "emerald.moving",				"RocksElements.png"	},
  { "emerald.moving.xpos",			"8"			},
  { "emerald.moving.ypos",			"0"			},
  { "emerald.moving.frames",			"2"			},
  { "emerald.moving.delay",			"4"			},
  { "emerald.falling",				"RocksElements.png"	},
  { "emerald.falling.xpos",			"8"			},
  { "emerald.falling.ypos",			"0"			},
  { "emerald.falling.frames",			"2"			},
  { "emerald.falling.delay",			"4"			},
  { "emerald.collecting",			"RocksMore.png"		},
  { "emerald.collecting.xpos",			"3"			},
  { "emerald.collecting.ypos",			"2"			},
  { "emerald.collecting.frames",		"3"			},
  { "emerald.collecting.delay",			"2"			},
  { "emerald.collecting.anim_mode",		"linear"		},

  { "diamond",					"RocksElements.png"	},
  { "diamond.xpos",				"10"			},
  { "diamond.ypos",				"0"			},
  { "diamond.frames",				"1"			},
  { "diamond.moving",				"RocksElements.png"	},
  { "diamond.moving.xpos",			"10"			},
  { "diamond.moving.ypos",			"0"			},
  { "diamond.moving.frames",			"2"			},
  { "diamond.moving.delay",			"4"			},
  { "diamond.falling",				"RocksElements.png"	},
  { "diamond.falling.xpos",			"10"			},
  { "diamond.falling.ypos",			"0"			},
  { "diamond.falling.frames",			"2"			},
  { "diamond.falling.delay",			"4"			},
  { "diamond.collecting",			"RocksMore.png"		},
  { "diamond.collecting.xpos",			"7"			},
  { "diamond.collecting.ypos",			"2"			},
  { "diamond.collecting.frames",		"3"			},
  { "diamond.collecting.delay",			"2"			},
  { "diamond.collecting.anim_mode",		"linear"		},

  { "bomb",					"RocksElements.png"	},
  { "bomb.xpos",				"11"			},
  { "bomb.ypos",				"1"			},
  { "bomb.frames",				"1"			},

  { "nut",					"RocksElements.png"	},
  { "nut.xpos",					"12"			},
  { "nut.ypos",					"1"			},
  { "nut.frames",				"1"			},
  { "nut.breaking",				"RocksElements.png"	},
  { "nut.breaking.xpos",			"13"			},
  { "nut.breaking.ypos",			"1"			},
  { "nut.breaking.frames",			"3"			},
  { "nut.breaking.delay",			"2"			},
  { "nut.breaking.anim_mode",			"linear"		},

  { "dynamite",					"RocksElements.png"	},
  { "dynamite.xpos",				"0"			},
  { "dynamite.ypos",				"3"			},
  { "dynamite.frames",				"1"			},
  { "dynamite.active",				"RocksElements.png"	},
  { "dynamite.active.xpos",			"1"			},
  { "dynamite.active.ypos",			"3"			},
  { "dynamite.active.frames",			"7"			},
  { "dynamite.active.delay",			"12"			},
  { "dynamite.active.anim_mode",		"linear"		},

  { "em_dynamite",				"RocksEMC.png"		},
  { "em_dynamite.xpos",				"0"			},
  { "em_dynamite.ypos",				"15"			},
  { "em_dynamite.frames",			"1"			},
  { "em_dynamite.active",			"RocksEMC.png"		},
  { "em_dynamite.active.xpos",			"1"			},
  { "em_dynamite.active.ypos",			"15"			},
  { "em_dynamite.active.frames",		"4"			},
  { "em_dynamite.active.delay",			"8"			},
  { "em_dynamite.active.anim_mode",		"linear"		},
  { "em_dynamite.active.EDITOR",		"RocksEMC.png"		},
  { "em_dynamite.active.EDITOR.xpos",		"2"			},
  { "em_dynamite.active.EDITOR.ypos",		"15"			},

  { "wall_emerald",				"RocksElements.png"	},
  { "wall_emerald.xpos",			"4"			},
  { "wall_emerald.ypos",			"8"			},
  { "wall_emerald.frames",			"1"			},

  { "wall_diamond",				"RocksElements.png"	},
  { "wall_diamond.xpos",			"5"			},
  { "wall_diamond.ypos",			"8"			},
  { "wall_diamond.frames",			"1"			},

  { "bug",					"RocksElements.png"	},
  { "bug.xpos",					"8"			},
  { "bug.ypos",					"4"			},
  { "bug.frames",				"4"			},
  { "bug.delay",				"8"			},
  { "bug.right",				"RocksElements.png"	},
  { "bug.right.xpos",				"8"			},
  { "bug.right.ypos",				"4"			},
  { "bug.right.frames",				"1"			},
  { "bug.up",					"RocksElements.png"	},
  { "bug.up.xpos",				"9"			},
  { "bug.up.ypos",				"4"			},
  { "bug.up.frames",				"1"			},
  { "bug.left",					"RocksElements.png"	},
  { "bug.left.xpos",				"10"			},
  { "bug.left.ypos",				"4"			},
  { "bug.left.frames",				"1"			},
  { "bug.down",					"RocksElements.png"	},
  { "bug.down.xpos",				"11"			},
  { "bug.down.ypos",				"4"			},
  { "bug.down.frames",				"1"			},
  { "bug.moving.right",				"RocksElements.png"	},
  { "bug.moving.right.xpos",			"8"			},
  { "bug.moving.right.ypos",			"4"			},
  { "bug.moving.right.frames",			"2"			},
  { "bug.moving.right.delay",			"4"			},
  { "bug.moving.right.offset",			"128"			},
  { "bug.moving.up",				"RocksElements.png"	},
  { "bug.moving.up.xpos",			"9"			},
  { "bug.moving.up.ypos",			"4"			},
  { "bug.moving.up.frames",			"2"			},
  { "bug.moving.up.delay",			"4"			},
  { "bug.moving.up.offset",			"128"			},
  { "bug.moving.left",				"RocksElements.png"	},
  { "bug.moving.left.xpos",			"10"			},
  { "bug.moving.left.ypos",			"4"			},
  { "bug.moving.left.frames",			"2"			},
  { "bug.moving.left.delay",			"4"			},
  { "bug.moving.left.offset",			"128"			},
  { "bug.moving.down",				"RocksElements.png"	},
  { "bug.moving.down.xpos",			"11"			},
  { "bug.moving.down.ypos",			"4"			},
  { "bug.moving.down.frames",			"2"			},
  { "bug.moving.down.delay",			"4"			},
  { "bug.moving.down.offset",			"128"			},
  { "bug.turning_from_right.up",		"RocksMore.png"		},
  { "bug.turning_from_right.up.xpos",		"0"			},
  { "bug.turning_from_right.up.ypos",		"6"			},
  { "bug.turning_from_right.up.frames",		"4"			},
  { "bug.turning_from_right.up.delay",		"2"			},
  { "bug.turning_from_right.up.anim_mode",	"linear,reverse"	},
  { "bug.turning_from_up.left",			"RocksMore.png"		},
  { "bug.turning_from_up.left.xpos",		"12"			},
  { "bug.turning_from_up.left.ypos",		"6"			},
  { "bug.turning_from_up.left.frames",		"4"			},
  { "bug.turning_from_up.left.delay",		"2"			},
  { "bug.turning_from_up.left.anim_mode",	"linear,reverse"	},
  { "bug.turning_from_left.down",		"RocksMore.png"		},
  { "bug.turning_from_left.down.xpos",		"8"			},
  { "bug.turning_from_left.down.ypos",		"6"			},
  { "bug.turning_from_left.down.frames",	"4"			},
  { "bug.turning_from_left.down.delay",		"2"			},
  { "bug.turning_from_left.down.anim_mode",	"linear,reverse"	},
  { "bug.turning_from_down.right",		"RocksMore.png"		},
  { "bug.turning_from_down.right.xpos",		"4"			},
  { "bug.turning_from_down.right.ypos",		"6"			},
  { "bug.turning_from_down.right.frames",	"4"			},
  { "bug.turning_from_down.right.delay",	"2"			},
  { "bug.turning_from_down.right.anim_mode",	"linear,reverse"	},
  { "bug.turning_from_right.down",		"RocksMore.png"		},
  { "bug.turning_from_right.down.xpos",		"5"			},
  { "bug.turning_from_right.down.ypos",		"6"			},
  { "bug.turning_from_right.down.frames",	"4"			},
  { "bug.turning_from_right.down.delay",	"2"			},
  { "bug.turning_from_right.down.anim_mode",	"linear"		},
  { "bug.turning_from_up.right",		"RocksMore.png"		},
  { "bug.turning_from_up.right.xpos",		"1"			},
  { "bug.turning_from_up.right.ypos",		"6"			},
  { "bug.turning_from_up.right.frames",		"4"			},
  { "bug.turning_from_up.right.delay",		"2"			},
  { "bug.turning_from_up.right.anim_mode",	"linear"		},
  { "bug.turning_from_left.up",			"RocksMore.png"		},
  { "bug.turning_from_left.up.xpos",		"13"			},
  { "bug.turning_from_left.up.ypos",		"6"			},
  { "bug.turning_from_left.up.frames",		"4"			},
  { "bug.turning_from_left.up.delay",		"2"			},
  { "bug.turning_from_left.up.anim_mode",	"linear"		},
  { "bug.turning_from_down.left",		"RocksMore.png"		},
  { "bug.turning_from_down.left.xpos",		"9"			},
  { "bug.turning_from_down.left.ypos",		"6"			},
  { "bug.turning_from_down.left.frames",	"4"			},
  { "bug.turning_from_down.left.delay",		"2"			},
  { "bug.turning_from_down.left.anim_mode",	"linear"		},

  { "spaceship",				"RocksElements.png"	},
  { "spaceship.xpos",				"8"			},
  { "spaceship.ypos",				"3"			},
  { "spaceship.frames",				"4"			},
  { "spaceship.delay",				"8"			},
  { "spaceship.right",				"RocksElements.png"	},
  { "spaceship.right.xpos",			"8"			},
  { "spaceship.right.ypos",			"3"			},
  { "spaceship.right.frames",			"1"			},
  { "spaceship.up",				"RocksElements.png"	},
  { "spaceship.up.xpos",			"9"			},
  { "spaceship.up.ypos",			"3"			},
  { "spaceship.up.frames",			"1"			},
  { "spaceship.left",				"RocksElements.png"	},
  { "spaceship.left.xpos",			"10"			},
  { "spaceship.left.ypos",			"3"			},
  { "spaceship.left.frames",			"1"			},
  { "spaceship.down",				"RocksElements.png"	},
  { "spaceship.down.xpos",			"11"			},
  { "spaceship.down.ypos",			"3"			},
  { "spaceship.down.frames",			"1"			},
  { "spaceship.moving.right",			"RocksElements.png"	},
  { "spaceship.moving.right.xpos",		"8"			},
  { "spaceship.moving.right.ypos",		"3"			},
  { "spaceship.moving.right.frames",		"2"			},
  { "spaceship.moving.right.delay",		"4"			},
  { "spaceship.moving.right.offset",		"128"			},
  { "spaceship.moving.up",			"RocksElements.png"	},
  { "spaceship.moving.up.xpos",			"9"			},
  { "spaceship.moving.up.ypos",			"3"			},
  { "spaceship.moving.up.frames",		"2"			},
  { "spaceship.moving.up.delay",		"4"			},
  { "spaceship.moving.up.offset",		"128"			},
  { "spaceship.moving.left",			"RocksElements.png"	},
  { "spaceship.moving.left.xpos",		"10"			},
  { "spaceship.moving.left.ypos",		"3"			},
  { "spaceship.moving.left.frames",		"2"			},
  { "spaceship.moving.left.delay",		"4"			},
  { "spaceship.moving.left.offset",		"128"			},
  { "spaceship.moving.down",			"RocksElements.png"	},
  { "spaceship.moving.down.xpos",		"11"			},
  { "spaceship.moving.down.ypos",		"3"			},
  { "spaceship.moving.down.frames",		"2"			},
  { "spaceship.moving.down.delay",		"4"			},
  { "spaceship.moving.down.offset",		"128"			},
  { "spaceship.turning_from_right.up",		"RocksMore.png"		},
  { "spaceship.turning_from_right.up.xpos",	"0"			},
  { "spaceship.turning_from_right.up.ypos",	"5"			},
  { "spaceship.turning_from_right.up.frames",	"4"			},
  { "spaceship.turning_from_right.up.delay",	"2"			},
  { "spaceship.turning_from_right.up.anim_mode","linear,reverse"	},
  { "spaceship.turning_from_up.left",		"RocksMore.png"		},
  { "spaceship.turning_from_up.left.xpos",	"12"			},
  { "spaceship.turning_from_up.left.ypos",	"5"			},
  { "spaceship.turning_from_up.left.frames",	"4"			},
  { "spaceship.turning_from_up.left.delay",	"2"			},
  { "spaceship.turning_from_up.left.anim_mode",	"linear,reverse"	},
  { "spaceship.turning_from_left.down",		"RocksMore.png"		},
  { "spaceship.turning_from_left.down.xpos",	"8"			},
  { "spaceship.turning_from_left.down.ypos",	"5"			},
  { "spaceship.turning_from_left.down.frames",	"4"			},
  { "spaceship.turning_from_left.down.delay",	"2"			},
  { "spaceship.turning_from_left.down.anim_mode","linear,reverse"	},
  { "spaceship.turning_from_down.right",	"RocksMore.png"		},
  { "spaceship.turning_from_down.right.xpos",	"4"			},
  { "spaceship.turning_from_down.right.ypos",	"5"			},
  { "spaceship.turning_from_down.right.frames",	"4"			},
  { "spaceship.turning_from_down.right.delay",	"2"			},
  { "spaceship.turning_from_down.right.anim_mode","linear,reverse"	},
  { "spaceship.turning_from_right.down",	"RocksMore.png"		},
  { "spaceship.turning_from_right.down.xpos",	"5"			},
  { "spaceship.turning_from_right.down.ypos",	"5"			},
  { "spaceship.turning_from_right.down.frames",	"4"			},
  { "spaceship.turning_from_right.down.delay",	"2"			},
  { "spaceship.turning_from_right.down.anim_mode","linear"		},
  { "spaceship.turning_from_up.right",		"RocksMore.png"		},
  { "spaceship.turning_from_up.right.xpos",	"1"			},
  { "spaceship.turning_from_up.right.ypos",	"5"			},
  { "spaceship.turning_from_up.right.frames",	"4"			},
  { "spaceship.turning_from_up.right.delay",	"2"			},
  { "spaceship.turning_from_up.right.anim_mode","linear"		},
  { "spaceship.turning_from_left.up",		"RocksMore.png"		},
  { "spaceship.turning_from_left.up.xpos",	"13"			},
  { "spaceship.turning_from_left.up.ypos",	"5"			},
  { "spaceship.turning_from_left.up.frames",	"4"			},
  { "spaceship.turning_from_left.up.delay",	"2"			},
  { "spaceship.turning_from_left.up.anim_mode",	"linear"		},
  { "spaceship.turning_from_down.left",		"RocksMore.png"		},
  { "spaceship.turning_from_down.left.xpos",	"9"			},
  { "spaceship.turning_from_down.left.ypos",	"5"			},
  { "spaceship.turning_from_down.left.frames",	"4"			},
  { "spaceship.turning_from_down.left.delay",	"2"			},
  { "spaceship.turning_from_down.left.anim_mode","linear"		},

  { "yamyam",					"RocksElements.png"	},
  { "yamyam.xpos",				"0"			},
  { "yamyam.ypos",				"5"			},
  { "yamyam.frames",				"4"			},
  { "yamyam.anim_mode",				"pingpong2"		},
  { "yamyam.left",				"RocksElements.png"	},
  { "yamyam.left.xpos",				"0"			},
  { "yamyam.left.ypos",				"5"			},
  { "yamyam.left.frames",			"4"			},
  { "yamyam.left.anim_mode",			"pingpong2"		},
  { "yamyam.left.EDITOR",			"RocksEMC.png"		},
  { "yamyam.left.EDITOR.xpos",			"7"			},
  { "yamyam.left.EDITOR.ypos",			"15"			},
  { "yamyam.right",				"RocksElements.png"	},
  { "yamyam.right.xpos",			"0"			},
  { "yamyam.right.ypos",			"5"			},
  { "yamyam.right.frames",			"4"			},
  { "yamyam.right.anim_mode",			"pingpong2"		},
  { "yamyam.right.EDITOR",			"RocksEMC.png"		},
  { "yamyam.right.EDITOR.xpos",			"8"			},
  { "yamyam.right.EDITOR.ypos",			"15"			},
  { "yamyam.up",				"RocksElements.png"	},
  { "yamyam.up.xpos",				"0"			},
  { "yamyam.up.ypos",				"5"			},
  { "yamyam.up.frames",				"4"			},
  { "yamyam.up.anim_mode",			"pingpong2"		},
  { "yamyam.up.EDITOR",				"RocksEMC.png"		},
  { "yamyam.up.EDITOR.xpos",			"5"			},
  { "yamyam.up.EDITOR.ypos",			"15"			},
  { "yamyam.down",				"RocksElements.png"	},
  { "yamyam.down.xpos",				"0"			},
  { "yamyam.down.ypos",				"5"			},
  { "yamyam.down.frames",			"4"			},
  { "yamyam.down.anim_mode",			"pingpong2"		},
  { "yamyam.down.EDITOR",			"RocksEMC.png"		},
  { "yamyam.down.EDITOR.xpos",			"6"			},
  { "yamyam.down.EDITOR.ypos",			"15"			},
  { "yamyam.moving",				"RocksElements.png"	},
  { "yamyam.moving.xpos",			"0"			},
  { "yamyam.moving.ypos",			"5"			},
  { "yamyam.moving.frames",			"1"			},

  { "robot",					"RocksElements.png"	},
  { "robot.xpos",				"4"			},
  { "robot.ypos",				"5"			},
  { "robot.frames",				"4"			},
  { "robot.anim_mode",				"pingpong2"		},
  { "robot.moving",				"RocksElements.png"	},
  { "robot.moving.xpos",			"4"			},
  { "robot.moving.ypos",			"5"			},
  { "robot.moving.frames",			"1"			},

  { "robot_wheel",				"RocksElements.png"	},
  { "robot_wheel.xpos",				"0"			},
  { "robot_wheel.ypos",				"6"			},
  { "robot_wheel.frames",			"1"			},
  { "robot_wheel.active",			"RocksElements.png"	},
  { "robot_wheel.active.xpos",			"0"			},
  { "robot_wheel.active.ypos",			"6"			},
  { "robot_wheel.active.frames",		"4"			},

  { "magic_wall",				"RocksElements.png"	},
  { "magic_wall.xpos",				"0"			},
  { "magic_wall.ypos",				"8"			},
  { "magic_wall.frames",			"1"			},
  { "magic_wall.active",			"RocksElements.png"	},
  { "magic_wall.active.xpos",			"0"			},
  { "magic_wall.active.ypos",			"8"			},
  { "magic_wall.active.frames",			"4"			},
  { "magic_wall.active.anim_mode",		"reverse"		},
  { "magic_wall.active.delay",			"4"			},
  { "magic_wall.active.global_sync",		"true"			},
  { "magic_wall.filling",			"RocksElements.png"	},
  { "magic_wall.filling.xpos",			"0"			},
  { "magic_wall.filling.ypos",			"8"			},
  { "magic_wall.filling.frames",		"4"			},
  { "magic_wall.filling.anim_mode",		"reverse"		},
  { "magic_wall.filling.delay",			"4"			},
  { "magic_wall.filling.global_sync",		"true"			},
  { "magic_wall_full",				"RocksElements.png"	},
  { "magic_wall_full.xpos",			"0"			},
  { "magic_wall_full.ypos",			"8"			},
  { "magic_wall_full.frames",			"4"			},
  { "magic_wall_full.anim_mode",		"reverse"		},
  { "magic_wall_full.delay",			"4"			},
  { "magic_wall_full.global_sync",		"true"			},
  { "magic_wall.emptying",			"RocksElements.png"	},
  { "magic_wall.emptying.xpos",			"0"			},
  { "magic_wall.emptying.ypos",			"8"			},
  { "magic_wall.emptying.frames",		"4"			},
  { "magic_wall.emptying.anim_mode",		"reverse"		},
  { "magic_wall.emptying.delay",		"4"			},
  { "magic_wall.emptying.global_sync",		"true"			},
  { "magic_wall_dead",				"RocksElements.png"	},
  { "magic_wall_dead.xpos",			"0"			},
  { "magic_wall_dead.ypos",			"8"			},
  { "magic_wall_dead.frames",			"1"			},

  { "dc_magic_wall",				"RocksDC2.png"		},
  { "dc_magic_wall.xpos",			"0"			},
  { "dc_magic_wall.ypos",			"3"			},
  { "dc_magic_wall.frames",			"1"			},
  { "dc_magic_wall.active",			"RocksDC2.png"		},
  { "dc_magic_wall.active.xpos",		"0"			},
  { "dc_magic_wall.active.ypos",		"3"			},
  { "dc_magic_wall.active.frames",		"4"			},
  { "dc_magic_wall.active.anim_mode",		"reverse"		},
  { "dc_magic_wall.active.delay",		"4"			},
  { "dc_magic_wall.active.global_sync",		"true"			},
  { "dc_magic_wall.filling",			"RocksDC2.png"		},
  { "dc_magic_wall.filling.xpos",		"0"			},
  { "dc_magic_wall.filling.ypos",		"3"			},
  { "dc_magic_wall.filling.frames",		"4"			},
  { "dc_magic_wall.filling.anim_mode",		"reverse"		},
  { "dc_magic_wall.filling.delay",		"4"			},
  { "dc_magic_wall.filling.global_sync",	"true"			},
  { "dc_magic_wall_full",			"RocksDC2.png"		},
  { "dc_magic_wall_full.xpos",			"0"			},
  { "dc_magic_wall_full.ypos",			"3"			},
  { "dc_magic_wall_full.frames",		"4"			},
  { "dc_magic_wall_full.anim_mode",		"reverse"		},
  { "dc_magic_wall_full.delay",			"4"			},
  { "dc_magic_wall_full.global_sync",		"true"			},
  { "dc_magic_wall.emptying",			"RocksDC2.png"		},
  { "dc_magic_wall.emptying.xpos",		"0"			},
  { "dc_magic_wall.emptying.ypos",		"3"			},
  { "dc_magic_wall.emptying.frames",		"4"			},
  { "dc_magic_wall.emptying.anim_mode",		"reverse"		},
  { "dc_magic_wall.emptying.delay",		"4"			},
  { "dc_magic_wall.emptying.global_sync",	"true"			},
  { "dc_magic_wall_dead",			"RocksDC2.png"		},
  { "dc_magic_wall_dead.xpos",			"0"			},
  { "dc_magic_wall_dead.ypos",			"3"			},
  { "dc_magic_wall_dead.frames",		"1"			},

  { "quicksand_empty",				"RocksElements.png"	},
  { "quicksand_empty.xpos",			"2"			},
  { "quicksand_empty.ypos",			"0"			},
  { "quicksand_empty.frames",			"1"			},
  { "quicksand.filling",			"RocksElements.png"	},
  { "quicksand.filling.xpos",			"3"			},
  { "quicksand.filling.ypos",			"0"			},
  { "quicksand.filling.frames",			"1"			},
  { "quicksand_full",				"RocksElements.png"	},
  { "quicksand_full.xpos",			"3"			},
  { "quicksand_full.ypos",			"0"			},
  { "quicksand_full.frames",			"1"			},
  { "quicksand_full.EDITOR",			"RocksElements.png"	},
  { "quicksand_full.EDITOR.xpos",		"3"			},
  { "quicksand_full.EDITOR.ypos",		"14"			},
  { "quicksand.emptying",			"RocksElements.png"	},
  { "quicksand.emptying.xpos",			"3"			},
  { "quicksand.emptying.ypos",			"0"			},
  { "quicksand.emptying.frames",		"1"			},

  { "quicksand_fast_empty",			"RocksDC2.png"		},
  { "quicksand_fast_empty.xpos",		"4"			},
  { "quicksand_fast_empty.ypos",		"3"			},
  { "quicksand_fast_empty.frames",		"1"			},
  { "quicksand_fast.filling",			"RocksDC2.png"		},
  { "quicksand_fast.filling.xpos",		"4"			},
  { "quicksand_fast.filling.ypos",		"3"			},
  { "quicksand_fast.filling.frames",		"1"			},
  { "quicksand_fast_full",			"RocksDC2.png"		},
  { "quicksand_fast_full.xpos",			"4"			},
  { "quicksand_fast_full.ypos",			"3"			},
  { "quicksand_fast_full.frames",		"1"			},
  { "quicksand_fast_full.EDITOR",		"RocksDC2.png"		},
  { "quicksand_fast_full.EDITOR.xpos",		"5"			},
  { "quicksand_fast_full.EDITOR.ypos",		"3"			},
  { "quicksand_fast.emptying",			"RocksDC2.png"		},
  { "quicksand_fast.emptying.xpos",		"4"			},
  { "quicksand_fast.emptying.ypos",		"3"			},
  { "quicksand_fast.emptying.frames",		"1"			},

  { "acid_pool_topleft",			"RocksElements.png"	},
  { "acid_pool_topleft.xpos",			"0"			},
  { "acid_pool_topleft.ypos",			"1"			},
  { "acid_pool_topleft.frames",			"1"			},
  { "acid_pool_topright",			"RocksElements.png"	},
  { "acid_pool_topright.xpos",			"2"			},
  { "acid_pool_topright.ypos",			"1"			},
  { "acid_pool_topright.frames",		"1"			},
  { "acid_pool_bottomleft",			"RocksElements.png"	},
  { "acid_pool_bottomleft.xpos",		"0"			},
  { "acid_pool_bottomleft.ypos",		"2"			},
  { "acid_pool_bottomleft.frames",		"1"			},
  { "acid_pool_bottom",				"RocksElements.png"	},
  { "acid_pool_bottom.xpos",			"1"			},
  { "acid_pool_bottom.ypos",			"2"			},
  { "acid_pool_bottom.frames",			"1"			},
  { "acid_pool_bottomright",			"RocksElements.png"	},
  { "acid_pool_bottomright.xpos",		"2"			},
  { "acid_pool_bottomright.ypos",		"2"			},
  { "acid_pool_bottomright.frames",		"1"			},

  { "acid",					"RocksElements.png"	},
  { "acid.xpos",				"12"			},
  { "acid.ypos",				"7"			},
  { "acid.frames",				"4"			},
  { "acid.delay",				"10"			},
  { "acid.global_sync",				"true"			},

  { "acid_splash_left",				"RocksHeroes.png"	},
  { "acid_splash_left.xpos",			"8"			},
  { "acid_splash_left.ypos",			"10"			},
  { "acid_splash_left.frames",			"4"			},
  { "acid_splash_left.delay",			"2"			},
  { "acid_splash_left.anim_mode",		"linear"		},
  { "acid_splash_right",			"RocksHeroes.png"	},
  { "acid_splash_right.xpos",			"12"			},
  { "acid_splash_right.ypos",			"10"			},
  { "acid_splash_right.frames",			"4"			},
  { "acid_splash_right.delay",			"2"			},
  { "acid_splash_right.anim_mode",		"linear"		},

  { "amoeba_drop",				"RocksElements.png"	},
  { "amoeba_drop.xpos",				"5"			},
  { "amoeba_drop.ypos",				"6"			},
  { "amoeba_drop.frames",			"1"			},
  { "amoeba.growing",				"RocksElements.png"	},
  { "amoeba.growing.xpos",			"5"			},
  { "amoeba.growing.ypos",			"6"			},
  { "amoeba.growing.frames",			"3"			},
  { "amoeba.growing.delay",			"2"			},
  { "amoeba.growing.anim_mode",			"linear"		},
  { "amoeba.shrinking",				"RocksElements.png"	},
  { "amoeba.shrinking.xpos",			"5"			},
  { "amoeba.shrinking.ypos",			"6"			},
  { "amoeba.shrinking.frames",			"3"			},
  { "amoeba.shrinking.delay",			"2"			},
  { "amoeba.shrinking.anim_mode",		"linear,reverse"	},
  { "amoeba_wet",				"RocksElements.png"	},
  { "amoeba_wet.xpos",				"8"			},
  { "amoeba_wet.ypos",				"6"			},
  { "amoeba_wet.frames",			"4"			},
  { "amoeba_wet.delay",				"1000000"		},
  { "amoeba_wet.anim_mode",			"random"		},
  { "amoeba_wet.EDITOR",			"RocksElements.png"	},
  { "amoeba_wet.EDITOR.xpos",			"4"			},
  { "amoeba_wet.EDITOR.ypos",			"6"			},
  { "amoeba.dropping",				"RocksElements.png"	},
  { "amoeba.dropping.xpos",			"8"			},
  { "amoeba.dropping.ypos",			"6"			},
  { "amoeba.dropping.frames",			"4"			},
  { "amoeba.dropping.delay",			"1000000"		},
  { "amoeba.dropping.anim_mode",		"random"		},
  { "amoeba_dry",				"RocksElements.png"	},
  { "amoeba_dry.xpos",				"8"			},
  { "amoeba_dry.ypos",				"6"			},
  { "amoeba_dry.frames",			"4"			},
  { "amoeba_dry.delay",				"1000000"		},
  { "amoeba_dry.anim_mode",			"random"		},
  { "amoeba_full",				"RocksElements.png"	},
  { "amoeba_full.xpos",				"8"			},
  { "amoeba_full.ypos",				"6"			},
  { "amoeba_full.frames",			"4"			},
  { "amoeba_full.delay",			"1000000"		},
  { "amoeba_full.anim_mode",			"random"		},
  { "amoeba_full.EDITOR",			"RocksElements.png"	},
  { "amoeba_full.EDITOR.xpos",			"8"			},
  { "amoeba_full.EDITOR.ypos",			"7"			},
  { "amoeba_dead",				"RocksElements.png"	},
  { "amoeba_dead.xpos",				"12"			},
  { "amoeba_dead.ypos",				"6"			},
  { "amoeba_dead.frames",			"4"			},
  { "amoeba_dead.delay",			"1000000"		},
  { "amoeba_dead.anim_mode",			"random"		},
  { "amoeba_dead.EDITOR",			"RocksElements.png"	},
  { "amoeba_dead.EDITOR.xpos",			"12"			},
  { "amoeba_dead.EDITOR.ypos",			"6"			},

  { "em_key_1",					"RocksSP.png"		},
  { "em_key_1.xpos",				"4"			},
  { "em_key_1.ypos",				"6"			},
  { "em_key_1.frames",				"1"			},
  { "em_key_2",					"RocksSP.png"		},
  { "em_key_2.xpos",				"5"			},
  { "em_key_2.ypos",				"6"			},
  { "em_key_2.frames",				"1"			},
  { "em_key_3",					"RocksSP.png"		},
  { "em_key_3.xpos",				"6"			},
  { "em_key_3.ypos",				"6"			},
  { "em_key_3.frames",				"1"			},
  { "em_key_4",					"RocksSP.png"		},
  { "em_key_4.xpos",				"7"			},
  { "em_key_4.ypos",				"6"			},
  { "em_key_4.frames",				"1"			},

  { "dc_key_white",				"RocksSP.png"		},
  { "dc_key_white.xpos",			"13"			},
  { "dc_key_white.ypos",			"1"			},
  { "dc_key_white.frames",			"1"			},

  { "em_gate_1",				"RocksSP.png"		},
  { "em_gate_1.xpos",				"0"			},
  { "em_gate_1.ypos",				"7"			},
  { "em_gate_1.frames",				"1"			},
  { "em_gate_2",				"RocksSP.png"		},
  { "em_gate_2.xpos",				"1"			},
  { "em_gate_2.ypos",				"7"			},
  { "em_gate_2.frames",				"1"			},
  { "em_gate_3",				"RocksSP.png"		},
  { "em_gate_3.xpos",				"2"			},
  { "em_gate_3.ypos",				"7"			},
  { "em_gate_3.frames",				"1"			},
  { "em_gate_4",				"RocksSP.png"		},
  { "em_gate_4.xpos",				"3"			},
  { "em_gate_4.ypos",				"7"			},
  { "em_gate_4.frames",				"1"			},

  { "dc_gate_white",				"RocksSP.png"		},
  { "dc_gate_white.xpos",			"14"			},
  { "dc_gate_white.ypos",			"1"			},
  { "dc_gate_white.frames",			"1"			},

  { "em_gate_1_gray",				"RocksSP.png"		},
  { "em_gate_1_gray.xpos",			"4"			},
  { "em_gate_1_gray.ypos",			"7"			},
  { "em_gate_1_gray.frames",			"1"			},
  { "em_gate_1_gray.EDITOR",			"RocksSP.png"		},
  { "em_gate_1_gray.EDITOR.xpos",		"12"			},
  { "em_gate_1_gray.EDITOR.ypos",		"11"			},
  { "em_gate_1_gray.active",			"RocksSP.png"		},
  { "em_gate_1_gray.active.xpos",		"0"			},
  { "em_gate_1_gray.active.ypos",		"7"			},
  { "em_gate_1_gray.active.frames",		"1"			},
  { "em_gate_2_gray",				"RocksSP.png"		},
  { "em_gate_2_gray.xpos",			"5"			},
  { "em_gate_2_gray.ypos",			"7"			},
  { "em_gate_2_gray.frames",			"1"			},
  { "em_gate_2_gray.EDITOR",			"RocksSP.png"		},
  { "em_gate_2_gray.EDITOR.xpos",		"13"			},
  { "em_gate_2_gray.EDITOR.ypos",		"11"			},
  { "em_gate_2_gray.active",			"RocksSP.png"		},
  { "em_gate_2_gray.active.xpos",		"1"			},
  { "em_gate_2_gray.active.ypos",		"7"			},
  { "em_gate_2_gray.active.frames",		"1"			},
  { "em_gate_3_gray",				"RocksSP.png"		},
  { "em_gate_3_gray.xpos",			"6"			},
  { "em_gate_3_gray.ypos",			"7"			},
  { "em_gate_3_gray.frames",			"1"			},
  { "em_gate_3_gray.EDITOR",			"RocksSP.png"		},
  { "em_gate_3_gray.EDITOR.xpos",		"14"			},
  { "em_gate_3_gray.EDITOR.ypos",		"11"			},
  { "em_gate_3_gray.active",			"RocksSP.png"		},
  { "em_gate_3_gray.active.xpos",		"2"			},
  { "em_gate_3_gray.active.ypos",		"7"			},
  { "em_gate_3_gray.active.frames",		"1"			},
  { "em_gate_4_gray",				"RocksSP.png"		},
  { "em_gate_4_gray.xpos",			"7"			},
  { "em_gate_4_gray.ypos",			"7"			},
  { "em_gate_4_gray.frames",			"1"			},
  { "em_gate_4_gray.EDITOR",			"RocksSP.png"		},
  { "em_gate_4_gray.EDITOR.xpos",		"15"			},
  { "em_gate_4_gray.EDITOR.ypos",		"11"			},
  { "em_gate_4_gray.active",			"RocksSP.png"		},
  { "em_gate_4_gray.active.xpos",		"3"			},
  { "em_gate_4_gray.active.ypos",		"7"			},
  { "em_gate_4_gray.active.frames",		"1"			},

  { "dc_gate_white_gray",			"RocksSP.png"		},
  { "dc_gate_white_gray.xpos",			"7"			},
  { "dc_gate_white_gray.ypos",			"7"			},
  { "dc_gate_white_gray.frames",		"1"			},
  { "dc_gate_white_gray.EDITOR",		"RocksSP.png"		},
  { "dc_gate_white_gray.EDITOR.xpos",		"15"			},
  { "dc_gate_white_gray.EDITOR.ypos",		"1"			},
  { "dc_gate_white_gray.active",		"RocksSP.png"		},
  { "dc_gate_white_gray.active.xpos",		"14"			},
  { "dc_gate_white_gray.active.ypos",		"1"			},
  { "dc_gate_white_gray.active.frames",		"1"			},

  { "dc_gate_fake_gray",			"RocksSP.png"		},
  { "dc_gate_fake_gray.xpos",			"7"			},
  { "dc_gate_fake_gray.ypos",			"7"			},
  { "dc_gate_fake_gray.frames",			"1"			},

  { "exit_closed",				"RocksElements.png"	},
  { "exit_closed.xpos",				"0"			},
  { "exit_closed.ypos",				"11"			},
  { "exit_closed.frames",			"1"			},
  { "exit.opening",				"RocksElements.png"	},
  { "exit.opening.xpos",			"0"			},
  { "exit.opening.ypos",			"11"			},
  { "exit.opening.frames",			"5"			},
  { "exit.opening.delay",			"6"			},
  { "exit.opening.anim_mode",			"linear"		},
  { "exit_open",				"RocksElements.png"	},
  { "exit_open.xpos",				"4"			},
  { "exit_open.ypos",				"11"			},
  { "exit_open.frames",				"4"			},
  { "exit_open.delay",				"4"			},
  { "exit_open.anim_mode",			"pingpong"		},
  { "exit.closing",				"RocksElements.png"	},
  { "exit.closing.xpos",			"0"			},
  { "exit.closing.ypos",			"11"			},
  { "exit.closing.frames",			"5"			},
  { "exit.closing.delay",			"6"			},
  { "exit.closing.anim_mode",			"linear,reverse"	},

  { "steel_exit_closed",			"RocksDC2.png"	},
  { "steel_exit_closed.xpos",			"8"			},
  { "steel_exit_closed.ypos",			"0"			},
  { "steel_exit_closed.frames",			"1"			},
  { "steel_exit.opening",			"RocksDC2.png"	},
  { "steel_exit.opening.xpos",			"8"			},
  { "steel_exit.opening.ypos",			"0"			},
  { "steel_exit.opening.frames",		"5"			},
  { "steel_exit.opening.delay",			"6"			},
  { "steel_exit.opening.anim_mode",		"linear"		},
  { "steel_exit_open",				"RocksDC2.png"	},
  { "steel_exit_open.xpos",			"12"			},
  { "steel_exit_open.ypos",			"0"			},
  { "steel_exit_open.frames",			"4"			},
  { "steel_exit_open.delay",			"4"			},
  { "steel_exit_open.anim_mode",		"pingpong"		},
  { "steel_exit.closing",			"RocksDC2.png"	},
  { "steel_exit.closing.xpos",			"8"			},
  { "steel_exit.closing.ypos",			"0"			},
  { "steel_exit.closing.frames",		"5"			},
  { "steel_exit.closing.delay",			"6"			},
  { "steel_exit.closing.anim_mode",		"linear,reverse"	},

  { "em_exit_closed",				"RocksDC2.png"	},
  { "em_exit_closed.xpos",			"0"			},
  { "em_exit_closed.ypos",			"4"			},
  { "em_exit_closed.frames",			"1"			},
  { "em_exit.opening",				"RocksDC2.png"	},
  { "em_exit.opening.xpos",			"0"			},
  { "em_exit.opening.ypos",			"4"			},
  { "em_exit.opening.frames",			"5"			},
  { "em_exit.opening.delay",			"6"			},
  { "em_exit.opening.anim_mode",		"linear"		},
  { "em_exit_open",				"RocksDC2.png"	},
  { "em_exit_open.xpos",			"4"			},
  { "em_exit_open.ypos",			"4"			},
  { "em_exit_open.frames",			"4"			},
  { "em_exit_open.delay",			"4"			},
  { "em_exit_open.anim_mode",			"pingpong"		},
  { "em_exit.closing",				"RocksDC2.png"	},
  { "em_exit.closing.xpos",			"0"			},
  { "em_exit.closing.ypos",			"6"			},
  { "em_exit.closing.frames",			"5"			},
  { "em_exit.closing.delay",			"6"			},
  { "em_exit.closing.anim_mode",		"linear"		},

  { "em_steel_exit_closed",			"RocksDC2.png"	},
  { "em_steel_exit_closed.xpos",		"0"			},
  { "em_steel_exit_closed.ypos",		"5"			},
  { "em_steel_exit_closed.frames",		"1"			},
  { "em_steel_exit.opening",			"RocksDC2.png"	},
  { "em_steel_exit.opening.xpos",		"0"			},
  { "em_steel_exit.opening.ypos",		"5"			},
  { "em_steel_exit.opening.frames",		"5"			},
  { "em_steel_exit.opening.delay",		"6"			},
  { "em_steel_exit.opening.anim_mode",		"linear"		},
  { "em_steel_exit_open",			"RocksDC2.png"	},
  { "em_steel_exit_open.xpos",			"4"			},
  { "em_steel_exit_open.ypos",			"5"			},
  { "em_steel_exit_open.frames",		"4"			},
  { "em_steel_exit_open.delay",			"4"			},
  { "em_steel_exit_open.anim_mode",		"pingpong"		},
  { "em_steel_exit.closing",			"RocksDC2.png"	},
  { "em_steel_exit.closing.xpos",		"0"			},
  { "em_steel_exit.closing.ypos",		"7"			},
  { "em_steel_exit.closing.frames",		"5"			},
  { "em_steel_exit.closing.delay",		"6"			},
  { "em_steel_exit.closing.anim_mode",		"linear"		},

  // images for Emerald Mine Club style elements and actions

  { "balloon",					"RocksDC.png"		},
  { "balloon.xpos",				"12"			},
  { "balloon.ypos",				"7"			},
  { "balloon.frames",				"1"			},
  { "balloon.moving",				"RocksDC.png"		},
  { "balloon.moving.xpos",			"12"			},
  { "balloon.moving.ypos",			"7"			},
  { "balloon.moving.frames",			"4"			},
  { "balloon.moving.anim_mode",			"pingpong"		},
  { "balloon.moving.delay",			"2"			},
  { "balloon.pushing",				"RocksDC.png"		},
  { "balloon.pushing.xpos",			"12"			},
  { "balloon.pushing.ypos",			"7"			},
  { "balloon.pushing.frames",			"4"			},
  { "balloon.pushing.anim_mode",		"pingpong"		},
  { "balloon.pushing.delay",			"2"			},
  { "balloon_switch_left",			"RocksDC.png"		},
  { "balloon_switch_left.xpos",			"8"			},
  { "balloon_switch_left.ypos",			"7"			},
  { "balloon_switch_left.frames",		"1"			},
  { "balloon_switch_right",			"RocksDC.png"		},
  { "balloon_switch_right.xpos",		"9"			},
  { "balloon_switch_right.ypos",		"7"			},
  { "balloon_switch_right.frames",		"1"			},
  { "balloon_switch_up",			"RocksDC.png"		},
  { "balloon_switch_up.xpos",			"10"			},
  { "balloon_switch_up.ypos",			"7"			},
  { "balloon_switch_up.frames",			"1"			},
  { "balloon_switch_down",			"RocksDC.png"		},
  { "balloon_switch_down.xpos",			"11"			},
  { "balloon_switch_down.ypos",			"7"			},
  { "balloon_switch_down.frames",		"1"			},
  { "balloon_switch_any",			"RocksDC.png"		},
  { "balloon_switch_any.xpos",			"15"			},
  { "balloon_switch_any.ypos",			"0"			},
  { "balloon_switch_any.frames",		"1"			},
  { "balloon_switch_none",			"RocksDC.png"		},
  { "balloon_switch_none.xpos",			"13"			},
  { "balloon_switch_none.ypos",			"5"			},
  { "balloon_switch_none.frames",		"1"			},

  { "spring",					"RocksDC.png"		},
  { "spring.xpos",				"8"			},
  { "spring.ypos",				"13"			},
  { "spring.frames",				"1"			},

  { "spring.left",				UNDEFINED_FILENAME	},
  { "spring.left.clone_from",			"spring"		},
  { "spring.right",				UNDEFINED_FILENAME	},
  { "spring.right.clone_from",			"spring"		},

  { "emc_steelwall_1",				"RocksDC.png"		},
  { "emc_steelwall_1.xpos",			"14"			},
  { "emc_steelwall_1.ypos",			"0"			},
  { "emc_steelwall_1.frames",			"1"			},
  { "emc_steelwall_2",				"RocksEMC.png"		},
  { "emc_steelwall_2.xpos",			"9"			},
  { "emc_steelwall_2.ypos",			"8"			},
  { "emc_steelwall_2.frames",			"1"			},
  { "emc_steelwall_3",				"RocksEMC.png"		},
  { "emc_steelwall_3.xpos",			"9"			},
  { "emc_steelwall_3.ypos",			"9"			},
  { "emc_steelwall_3.frames",			"1"			},
  { "emc_steelwall_4",				"RocksEMC.png"		},
  { "emc_steelwall_4.xpos",			"9"			},
  { "emc_steelwall_4.ypos",			"10"			},
  { "emc_steelwall_4.frames",			"1"			},

  { "emc_wall_1",				"RocksDC.png"		},
  { "emc_wall_1.xpos",				"13"			},
  { "emc_wall_1.ypos",				"6"			},
  { "emc_wall_1.frames",			"1"			},
  { "emc_wall_2",				"RocksDC.png"		},
  { "emc_wall_2.xpos",				"14"			},
  { "emc_wall_2.ypos",				"6"			},
  { "emc_wall_2.frames",			"1"			},
  { "emc_wall_3",				"RocksDC.png"		},
  { "emc_wall_3.xpos",				"15"			},
  { "emc_wall_3.ypos",				"6"			},
  { "emc_wall_3.frames",			"1"			},
  { "emc_wall_4",				"RocksDC.png"		},
  { "emc_wall_4.xpos",				"14"			},
  { "emc_wall_4.ypos",				"1"			},
  { "emc_wall_4.frames",			"1"			},
  { "emc_wall_5",				"RocksDC.png"		},
  { "emc_wall_5.xpos",				"15"			},
  { "emc_wall_5.ypos",				"1"			},
  { "emc_wall_5.frames",			"1"			},
  { "emc_wall_6",				"RocksDC.png"		},
  { "emc_wall_6.xpos",				"14"			},
  { "emc_wall_6.ypos",				"2"			},
  { "emc_wall_6.frames",			"1"			},
  { "emc_wall_7",				"RocksDC.png"		},
  { "emc_wall_7.xpos",				"15"			},
  { "emc_wall_7.ypos",				"2"			},
  { "emc_wall_7.frames",			"1"			},
  { "emc_wall_8",				"RocksEMC.png"		},
  { "emc_wall_8.xpos",				"8"			},
  { "emc_wall_8.ypos",				"7"			},
  { "emc_wall_8.frames",			"1"			},

  // images for Diamond Caves style elements and actions

  { "invisible_steelwall",			"RocksSP.png"		},
  { "invisible_steelwall.xpos",			"3"			},
  { "invisible_steelwall.ypos",			"5"			},
  { "invisible_steelwall.frames",		"1"			},
  { "invisible_steelwall.EDITOR",		"RocksSP.png"		},
  { "invisible_steelwall.EDITOR.xpos",		"1"			},
  { "invisible_steelwall.EDITOR.ypos",		"5"			},
  { "invisible_steelwall.active",		"RocksSP.png"		},
  { "invisible_steelwall.active.xpos",		"1"			},
  { "invisible_steelwall.active.ypos",		"5"			},
  { "invisible_steelwall.active.frames",	"1"			},

  { "invisible_wall",				"RocksSP.png"		},
  { "invisible_wall.xpos",			"7"			},
  { "invisible_wall.ypos",			"5"			},
  { "invisible_wall.frames",			"1"			},
  { "invisible_wall.EDITOR",			"RocksSP.png"		},
  { "invisible_wall.EDITOR.xpos",		"5"			},
  { "invisible_wall.EDITOR.ypos",		"5"			},
  { "invisible_wall.active",			"RocksSP.png"		},
  { "invisible_wall.active.xpos",		"5"			},
  { "invisible_wall.active.ypos",		"5"			},
  { "invisible_wall.active.frames",		"1"			},

  { "invisible_sand",				"RocksSP.png"		},
  { "invisible_sand.xpos",			"0"			},
  { "invisible_sand.ypos",			"0"			},
  { "invisible_sand.frames",			"1"			},
  { "invisible_sand.EDITOR",			"RocksEMC.png"		},
  { "invisible_sand.EDITOR.xpos",		"2"			},
  { "invisible_sand.EDITOR.ypos",		"4"			},
  { "invisible_sand.active",			"RocksEMC.png"		},
  { "invisible_sand.active.xpos",		"2"			},
  { "invisible_sand.active.ypos",		"4"			},
  { "invisible_sand.active.frames",		"1"			},
  { "invisible_sand.active.CRUMBLED",		"RocksEMC.png"		},
  { "invisible_sand.active.CRUMBLED.xpos",	"3"			},
  { "invisible_sand.active.CRUMBLED.ypos",	"4"			},
  { "invisible_sand.active.CRUMBLED.frames",	"1"			},
  { "invisible_sand.active.digging.left",	"RocksEMC.png"		},
  { "invisible_sand.active.digging.left.xpos",	"6"			},
  { "invisible_sand.active.digging.left.ypos",	"2"			},
  { "invisible_sand.active.digging.left.frames","3"			},
  { "invisible_sand.active.digging.left.delay",	"2"			},
  { "invisible_sand.active.digging.left.anim_mode","linear"		},
  { "invisible_sand.active.digging.right",	"RocksEMC.png"		},
  { "invisible_sand.active.digging.right.xpos",	"9"			},
  { "invisible_sand.active.digging.right.ypos",	"2"			},
  { "invisible_sand.active.digging.right.frames","3"			},
  { "invisible_sand.active.digging.right.delay","2"			},
  { "invisible_sand.active.digging.right.anim_mode","linear"		},
  { "invisible_sand.active.digging.up",		"RocksEMC.png"		},
  { "invisible_sand.active.digging.up.xpos",	"0"			},
  { "invisible_sand.active.digging.up.ypos",	"2"			},
  { "invisible_sand.active.digging.up.frames",	"3"			},
  { "invisible_sand.active.digging.up.delay",	"2"			},
  { "invisible_sand.active.digging.up.anim_mode","linear"		},
  { "invisible_sand.active.digging.down",	"RocksEMC.png"		},
  { "invisible_sand.active.digging.down.xpos",	"3"			},
  { "invisible_sand.active.digging.down.ypos",	"2"			},
  { "invisible_sand.active.digging.down.frames","3"			},
  { "invisible_sand.active.digging.down.delay",	"2"			},
  { "invisible_sand.active.digging.down.anim_mode","linear"		},
  { "invisible_sand.active.digging.left.CRUMBLED",	"RocksEMC.png"	},
  { "invisible_sand.active.digging.left.CRUMBLED.xpos",	"6"		},
  { "invisible_sand.active.digging.left.CRUMBLED.ypos",	"3"		},
  { "invisible_sand.active.digging.left.CRUMBLED.frames","3"		},
  { "invisible_sand.active.digging.left.CRUMBLED.delay","2"		},
  { "invisible_sand.active.digging.left.CRUMBLED.anim_mode","linear"	},
  { "invisible_sand.active.digging.right.CRUMBLED",	"RocksEMC.png"	},
  { "invisible_sand.active.digging.right.CRUMBLED.xpos","9"		},
  { "invisible_sand.active.digging.right.CRUMBLED.ypos","3"		},
  { "invisible_sand.active.digging.right.CRUMBLED.frames","3"		},
  { "invisible_sand.active.digging.right.CRUMBLED.delay","2"		},
  { "invisible_sand.active.digging.right.CRUMBLED.anim_mode","linear"	},
  { "invisible_sand.active.digging.up.CRUMBLED",	"RocksEMC.png"	},
  { "invisible_sand.active.digging.up.CRUMBLED.xpos",	"0"		},
  { "invisible_sand.active.digging.up.CRUMBLED.ypos",	"3"		},
  { "invisible_sand.active.digging.up.CRUMBLED.frames",	"3"		},
  { "invisible_sand.active.digging.up.CRUMBLED.delay",	"2"		},
  { "invisible_sand.active.digging.up.CRUMBLED.anim_mode","linear"	},
  { "invisible_sand.active.digging.down.CRUMBLED",	"RocksEMC.png"	},
  { "invisible_sand.active.digging.down.CRUMBLED.xpos",	"3"		},
  { "invisible_sand.active.digging.down.CRUMBLED.ypos",	"3"		},
  { "invisible_sand.active.digging.down.CRUMBLED.frames","3"		},
  { "invisible_sand.active.digging.down.CRUMBLED.delay","2"		},
  { "invisible_sand.active.digging.down.CRUMBLED.anim_mode","linear"	},

  { "conveyor_belt_1_middle",			"RocksDC.png"		},
  { "conveyor_belt_1_middle.xpos",		"0"			},
  { "conveyor_belt_1_middle.ypos",		"0"			},
  { "conveyor_belt_1_middle.frames",		"1"			},
  { "conveyor_belt_1_middle.active",		"RocksDC.png"		},
  { "conveyor_belt_1_middle.active.xpos",	"0"			},
  { "conveyor_belt_1_middle.active.ypos",	"0"			},
  { "conveyor_belt_1_middle.active.frames",	"8"			},
  { "conveyor_belt_1_middle.active.delay",	"2"			},
  { "conveyor_belt_1_left",			"RocksDC.png"		},
  { "conveyor_belt_1_left.xpos",		"0"			},
  { "conveyor_belt_1_left.ypos",		"1"			},
  { "conveyor_belt_1_left.frames",		"1"			},
  { "conveyor_belt_1_left.active",		"RocksDC.png"		},
  { "conveyor_belt_1_left.active.xpos",		"0"			},
  { "conveyor_belt_1_left.active.ypos",		"1"			},
  { "conveyor_belt_1_left.active.frames",	"8"			},
  { "conveyor_belt_1_left.active.delay",	"2"			},
  { "conveyor_belt_1_right",			"RocksDC.png"		},
  { "conveyor_belt_1_right.xpos",		"0"			},
  { "conveyor_belt_1_right.ypos",		"2"			},
  { "conveyor_belt_1_right.frames",		"1"			},
  { "conveyor_belt_1_right.active",		"RocksDC.png"		},
  { "conveyor_belt_1_right.active.xpos",	"0"			},
  { "conveyor_belt_1_right.active.ypos",	"2"			},
  { "conveyor_belt_1_right.active.frames",	"8"			},
  { "conveyor_belt_1_right.active.delay",	"2"			},
  { "conveyor_belt_1_switch_left",		"RocksDC.png"		},
  { "conveyor_belt_1_switch_left.xpos",		"0"			},
  { "conveyor_belt_1_switch_left.ypos",		"12"			},
  { "conveyor_belt_1_switch_left.frames",	"1"			},
  { "conveyor_belt_1_switch_middle",		"RocksDC.png"		},
  { "conveyor_belt_1_switch_middle.xpos",	"0"			},
  { "conveyor_belt_1_switch_middle.ypos",	"13"			},
  { "conveyor_belt_1_switch_middle.frames",	"1"			},
  { "conveyor_belt_1_switch_right",		"RocksDC.png"		},
  { "conveyor_belt_1_switch_right.xpos",	"0"			},
  { "conveyor_belt_1_switch_right.ypos",	"14"			},
  { "conveyor_belt_1_switch_right.frames",	"1"			},

  { "conveyor_belt_2_middle",			"RocksDC.png"		},
  { "conveyor_belt_2_middle.xpos",		"0"			},
  { "conveyor_belt_2_middle.ypos",		"3"			},
  { "conveyor_belt_2_middle.frames",		"1"			},
  { "conveyor_belt_2_middle.active",		"RocksDC.png"		},
  { "conveyor_belt_2_middle.active.xpos",	"0"			},
  { "conveyor_belt_2_middle.active.ypos",	"3"			},
  { "conveyor_belt_2_middle.active.frames",	"8"			},
  { "conveyor_belt_2_middle.active.delay",	"2"			},
  { "conveyor_belt_2_left",			"RocksDC.png"		},
  { "conveyor_belt_2_left.xpos",		"0"			},
  { "conveyor_belt_2_left.ypos",		"4"			},
  { "conveyor_belt_2_left.frames",		"1"			},
  { "conveyor_belt_2_left.active",		"RocksDC.png"		},
  { "conveyor_belt_2_left.active.xpos",		"0"			},
  { "conveyor_belt_2_left.active.ypos",		"4"			},
  { "conveyor_belt_2_left.active.frames",	"8"			},
  { "conveyor_belt_2_left.active.delay",	"2"			},
  { "conveyor_belt_2_right",			"RocksDC.png"		},
  { "conveyor_belt_2_right.xpos",		"0"			},
  { "conveyor_belt_2_right.ypos",		"5"			},
  { "conveyor_belt_2_right.frames",		"1"			},
  { "conveyor_belt_2_right.active",		"RocksDC.png"		},
  { "conveyor_belt_2_right.active.xpos",	"0"			},
  { "conveyor_belt_2_right.active.ypos",	"5"			},
  { "conveyor_belt_2_right.active.frames",	"8"			},
  { "conveyor_belt_2_right.active.delay",	"2"			},
  { "conveyor_belt_2_switch_left",		"RocksDC.png"		},
  { "conveyor_belt_2_switch_left.xpos",		"1"			},
  { "conveyor_belt_2_switch_left.ypos",		"12"			},
  { "conveyor_belt_2_switch_left.frames",	"1"			},
  { "conveyor_belt_2_switch_middle",		"RocksDC.png"		},
  { "conveyor_belt_2_switch_middle.xpos",	"1"			},
  { "conveyor_belt_2_switch_middle.ypos",	"13"			},
  { "conveyor_belt_2_switch_middle.frames",	"1"			},
  { "conveyor_belt_2_switch_right",		"RocksDC.png"		},
  { "conveyor_belt_2_switch_right.xpos",	"1"			},
  { "conveyor_belt_2_switch_right.ypos",	"14"			},
  { "conveyor_belt_2_switch_right.frames",	"1"			},

  { "conveyor_belt_3_middle",			"RocksDC.png"		},
  { "conveyor_belt_3_middle.xpos",		"0"			},
  { "conveyor_belt_3_middle.ypos",		"6"			},
  { "conveyor_belt_3_middle.frames",		"1"			},
  { "conveyor_belt_3_middle.active",		"RocksDC.png"		},
  { "conveyor_belt_3_middle.active.xpos",	"0"			},
  { "conveyor_belt_3_middle.active.ypos",	"6"			},
  { "conveyor_belt_3_middle.active.frames",	"8"			},
  { "conveyor_belt_3_middle.active.delay",	"2"			},
  { "conveyor_belt_3_left",			"RocksDC.png"		},
  { "conveyor_belt_3_left.xpos",		"0"			},
  { "conveyor_belt_3_left.ypos",		"7"			},
  { "conveyor_belt_3_left.frames",		"1"			},
  { "conveyor_belt_3_left.active",		"RocksDC.png"		},
  { "conveyor_belt_3_left.active.xpos",		"0"			},
  { "conveyor_belt_3_left.active.ypos",		"7"			},
  { "conveyor_belt_3_left.active.frames",	"8"			},
  { "conveyor_belt_3_left.active.delay",	"2"			},
  { "conveyor_belt_3_right",			"RocksDC.png"		},
  { "conveyor_belt_3_right.xpos",		"0"			},
  { "conveyor_belt_3_right.ypos",		"8"			},
  { "conveyor_belt_3_right.frames",		"1"			},
  { "conveyor_belt_3_right.active",		"RocksDC.png"		},
  { "conveyor_belt_3_right.active.xpos",	"0"			},
  { "conveyor_belt_3_right.active.ypos",	"8"			},
  { "conveyor_belt_3_right.active.frames",	"8"			},
  { "conveyor_belt_3_right.active.delay",	"2"			},
  { "conveyor_belt_3_switch_left",		"RocksDC.png"		},
  { "conveyor_belt_3_switch_left.xpos",		"2"			},
  { "conveyor_belt_3_switch_left.ypos",		"12"			},
  { "conveyor_belt_3_switch_left.frames",	"1"			},
  { "conveyor_belt_3_switch_middle",		"RocksDC.png"		},
  { "conveyor_belt_3_switch_middle.xpos",	"2"			},
  { "conveyor_belt_3_switch_middle.ypos",	"13"			},
  { "conveyor_belt_3_switch_middle.frames",	"1"			},
  { "conveyor_belt_3_switch_right",		"RocksDC.png"		},
  { "conveyor_belt_3_switch_right.xpos",	"2"			},
  { "conveyor_belt_3_switch_right.ypos",	"14"			},
  { "conveyor_belt_3_switch_right.frames",	"1"			},

  { "conveyor_belt_4_middle",			"RocksDC.png"		},
  { "conveyor_belt_4_middle.xpos",		"0"			},
  { "conveyor_belt_4_middle.ypos",		"9"			},
  { "conveyor_belt_4_middle.frames",		"1"			},
  { "conveyor_belt_4_middle.active",		"RocksDC.png"		},
  { "conveyor_belt_4_middle.active.xpos",	"0"			},
  { "conveyor_belt_4_middle.active.ypos",	"9"			},
  { "conveyor_belt_4_middle.active.frames",	"8"			},
  { "conveyor_belt_4_middle.active.delay",	"2"			},
  { "conveyor_belt_4_left",			"RocksDC.png"		},
  { "conveyor_belt_4_left.xpos",		"0"			},
  { "conveyor_belt_4_left.ypos",		"10"			},
  { "conveyor_belt_4_left.frames",		"1"			},
  { "conveyor_belt_4_left.active",		"RocksDC.png"		},
  { "conveyor_belt_4_left.active.xpos",		"0"			},
  { "conveyor_belt_4_left.active.ypos",		"10"			},
  { "conveyor_belt_4_left.active.frames",	"8"			},
  { "conveyor_belt_4_left.active.delay",	"2"			},
  { "conveyor_belt_4_right",			"RocksDC.png"		},
  { "conveyor_belt_4_right.xpos",		"0"			},
  { "conveyor_belt_4_right.ypos",		"11"			},
  { "conveyor_belt_4_right.frames",		"1"			},
  { "conveyor_belt_4_right.active",		"RocksDC.png"		},
  { "conveyor_belt_4_right.active.xpos",	"0"			},
  { "conveyor_belt_4_right.active.ypos",	"11"			},
  { "conveyor_belt_4_right.active.frames",	"8"			},
  { "conveyor_belt_4_right.active.delay",	"2"			},
  { "conveyor_belt_4_switch_left",		"RocksDC.png"		},
  { "conveyor_belt_4_switch_left.xpos",		"3"			},
  { "conveyor_belt_4_switch_left.ypos",		"12"			},
  { "conveyor_belt_4_switch_left.frames",	"1"			},
  { "conveyor_belt_4_switch_middle",		"RocksDC.png"		},
  { "conveyor_belt_4_switch_middle.xpos",	"3"			},
  { "conveyor_belt_4_switch_middle.ypos",	"13"			},
  { "conveyor_belt_4_switch_middle.frames",	"1"			},
  { "conveyor_belt_4_switch_right",		"RocksDC.png"		},
  { "conveyor_belt_4_switch_right.xpos",	"3"			},
  { "conveyor_belt_4_switch_right.ypos",	"14"			},
  { "conveyor_belt_4_switch_right.frames",	"1"			},

  { "switchgate_switch_up",			"RocksDC.png"		},
  { "switchgate_switch_up.xpos",		"4"			},
  { "switchgate_switch_up.ypos",		"12"			},
  { "switchgate_switch_up.frames",		"1"			},
  { "switchgate_switch_down",			"RocksDC.png"		},
  { "switchgate_switch_down.xpos",		"5"			},
  { "switchgate_switch_down.ypos",		"12"			},
  { "switchgate_switch_down.frames",		"1"			},

  { "dc_switchgate_switch_up",			"RocksDC2.png"		},
  { "dc_switchgate_switch_up.xpos",		"10"			},
  { "dc_switchgate_switch_up.ypos",		"1"			},
  { "dc_switchgate_switch_up.frames",		"1"			},
  { "dc_switchgate_switch_down",		"RocksDC2.png"		},
  { "dc_switchgate_switch_down.xpos",		"11"			},
  { "dc_switchgate_switch_down.ypos",		"1"			},
  { "dc_switchgate_switch_down.frames",		"1"			},

  { "light_switch",				"RocksDC.png"		},
  { "light_switch.xpos",			"6"			},
  { "light_switch.ypos",			"12"			},
  { "light_switch.frames",			"1"			},
  { "light_switch.active",			"RocksDC.png"		},
  { "light_switch.active.xpos",			"7"			},
  { "light_switch.active.ypos",			"12"			},
  { "light_switch.active.frames",		"1"			},

  { "timegate_switch",				"RocksDC.png"		},
  { "timegate_switch.xpos",			"0"			},
  { "timegate_switch.ypos",			"15"			},
  { "timegate_switch.frames",			"1"			},
  { "timegate_switch.active",			"RocksDC.png"		},
  { "timegate_switch.active.xpos",		"0"			},
  { "timegate_switch.active.ypos",		"15"			},
  { "timegate_switch.active.frames",		"4"			},

  { "dc_timegate_switch",			"RocksDC2.png"		},
  { "dc_timegate_switch.xpos",			"12"			},
  { "dc_timegate_switch.ypos",			"1"			},
  { "dc_timegate_switch.frames",		"1"			},
  { "dc_timegate_switch.active",		"RocksDC2.png"		},
  { "dc_timegate_switch.active.xpos",		"12"			},
  { "dc_timegate_switch.active.ypos",		"1"			},
  { "dc_timegate_switch.active.frames",		"4"			},

  { "envelope_1",				"RocksMore.png"		},
  { "envelope_1.xpos",				"0"			},
  { "envelope_1.ypos",				"4"			},
  { "envelope_1.frames",			"1"			},
  { "envelope_1.collecting",			"RocksMore.png"		},
  { "envelope_1.collecting.xpos",		"5"			},
  { "envelope_1.collecting.ypos",		"4"			},
  { "envelope_1.collecting.frames",		"3"			},
  { "envelope_1.collecting.delay",		"2"			},
  { "envelope_1.collecting.anim_mode",		"linear"		},
  { "envelope_2",				"RocksMore.png"		},
  { "envelope_2.xpos",				"1"			},
  { "envelope_2.ypos",				"4"			},
  { "envelope_2.frames",			"1"			},
  { "envelope_2.collecting",			"RocksMore.png"		},
  { "envelope_2.collecting.xpos",		"5"			},
  { "envelope_2.collecting.ypos",		"4"			},
  { "envelope_2.collecting.frames",		"3"			},
  { "envelope_2.collecting.delay",		"2"			},
  { "envelope_2.collecting.anim_mode",		"linear"		},
  { "envelope_3",				"RocksMore.png"		},
  { "envelope_3.xpos",				"2"			},
  { "envelope_3.ypos",				"4"			},
  { "envelope_3.frames",			"1"			},
  { "envelope_3.collecting",			"RocksMore.png"		},
  { "envelope_3.collecting.xpos",		"5"			},
  { "envelope_3.collecting.ypos",		"4"			},
  { "envelope_3.collecting.frames",		"3"			},
  { "envelope_3.collecting.delay",		"2"			},
  { "envelope_3.collecting.anim_mode",		"linear"		},
  { "envelope_4",				"RocksMore.png"		},
  { "envelope_4.xpos",				"3"			},
  { "envelope_4.ypos",				"4"			},
  { "envelope_4.frames",			"1"			},
  { "envelope_4.collecting",			"RocksMore.png"		},
  { "envelope_4.collecting.xpos",		"5"			},
  { "envelope_4.collecting.ypos",		"4"			},
  { "envelope_4.collecting.frames",		"3"			},
  { "envelope_4.collecting.delay",		"2"			},
  { "envelope_4.collecting.anim_mode",		"linear"		},

  { "sign_radioactivity",			"RocksDC.png"		},
  { "sign_radioactivity.xpos",			"4"			},
  { "sign_radioactivity.ypos",			"13"			},
  { "sign_radioactivity.frames",		"1"			},

  { "sign_give_way",				"RocksDC.png"		},
  { "sign_give_way.xpos",			"5"			},
  { "sign_give_way.ypos",			"13"			},
  { "sign_give_way.frames",			"1"			},

  { "sign_no_entry",				"RocksDC.png"		},
  { "sign_no_entry.xpos",			"6"			},
  { "sign_no_entry.ypos",			"13"			},
  { "sign_no_entry.frames",			"1"			},

  { "sign_emergency_exit",			"RocksDC.png"		},
  { "sign_emergency_exit.xpos",			"7"			},
  { "sign_emergency_exit.ypos",			"13"			},
  { "sign_emergency_exit.frames",		"1"			},

  { "sign_yin_yang",				"RocksDC.png"		},
  { "sign_yin_yang.xpos",			"4"			},
  { "sign_yin_yang.ypos",			"14"			},
  { "sign_yin_yang.frames",			"1"			},

  { "sign_exclamation",				"RocksDC.png"		},
  { "sign_exclamation.xpos",			"5"			},
  { "sign_exclamation.ypos",			"14"			},
  { "sign_exclamation.frames",			"1"			},

  { "sign_stop",				"RocksDC.png"		},
  { "sign_stop.xpos",				"6"			},
  { "sign_stop.ypos",				"14"			},
  { "sign_stop.frames",				"1"			},

  { "sign_parking",				"RocksDC.png"		},
  { "sign_parking.xpos",			"6"			},
  { "sign_parking.ypos",			"15"			},
  { "sign_parking.frames",			"1"			},

  { "sign_wheelchair",				"RocksDC.png"		},
  { "sign_wheelchair.xpos",			"7"			},
  { "sign_wheelchair.ypos",			"15"			},
  { "sign_wheelchair.frames",			"1"			},

  { "sign_entry_forbidden",			"RocksDC.png"		},
  { "sign_entry_forbidden.xpos",		"12"			},
  { "sign_entry_forbidden.ypos",		"15"			},
  { "sign_entry_forbidden.frames",		"1"			},

  { "sperms",					"RocksDC2.png"		},
  { "sperms.xpos",				"11"			},
  { "sperms.ypos",				"3"			},
  { "sperms.frames",				"1"			},

  { "bullet",					"RocksDC2.png"		},
  { "bullet.xpos",				"12"			},
  { "bullet.ypos",				"3"			},
  { "bullet.frames",				"1"			},

  { "heart",					"RocksDC2.png"		},
  { "heart.xpos",				"13"			},
  { "heart.ypos",				"3"			},
  { "heart.frames",				"1"			},

  { "cross",					"RocksDC2.png"		},
  { "cross.xpos",				"14"			},
  { "cross.ypos",				"3"			},
  { "cross.frames",				"1"			},

  { "frankie",					"RocksDC2.png"		},
  { "frankie.xpos",				"15"			},
  { "frankie.ypos",				"3"			},
  { "frankie.frames",				"1"			},

  { "sign_sperms",				"RocksDC2.png"		},
  { "sign_sperms.xpos",				"11"			},
  { "sign_sperms.ypos",				"2"			},
  { "sign_sperms.frames",			"1"			},

  { "sign_bullet",				"RocksDC2.png"		},
  { "sign_bullet.xpos",				"12"			},
  { "sign_bullet.ypos",				"2"			},
  { "sign_bullet.frames",			"1"			},

  { "sign_heart",				"RocksDC2.png"		},
  { "sign_heart.xpos",				"13"			},
  { "sign_heart.ypos",				"2"			},
  { "sign_heart.frames",			"1"			},

  { "sign_cross",				"RocksDC2.png"		},
  { "sign_cross.xpos",				"14"			},
  { "sign_cross.ypos",				"2"			},
  { "sign_cross.frames",			"1"			},

  { "sign_frankie",				"RocksDC2.png"		},
  { "sign_frankie.xpos",			"15"			},
  { "sign_frankie.ypos",			"2"			},
  { "sign_frankie.frames",			"1"			},

  { "landmine",					"RocksDC.png"		},
  { "landmine.xpos",				"7"			},
  { "landmine.ypos",				"14"			},
  { "landmine.frames",				"1"			},
  { "landmine.crumbled_like",			"sand"			},

  { "dc_landmine",				"RocksDC.png"		},
  { "dc_landmine.xpos",				"14"			},
  { "dc_landmine.ypos",				"5"			},
  { "dc_landmine.frames",			"1"			},
  { "dc_landmine.crumbled_like",		"sand"			},

  { "steelwall_slippery",			"RocksDC.png"		},
  { "steelwall_slippery.xpos",			"5"			},
  { "steelwall_slippery.ypos",			"15"			},
  { "steelwall_slippery.frames",		"1"			},

  { "extra_time",				"RocksDC.png"		},
  { "extra_time.xpos",				"8"			},
  { "extra_time.ypos",				"0"			},
  { "extra_time.frames",			"6"			},
  { "extra_time.delay",				"4"			},

  { "shield_normal",				"RocksDC.png"		},
  { "shield_normal.xpos",			"8"			},
  { "shield_normal.ypos",			"2"			},
  { "shield_normal.frames",			"6"			},
  { "shield_normal.delay",			"4"			},
  { "shield_normal.active",			"RocksHeroes.png"	},
  { "shield_normal.active.xpos",		"1"			},
  { "shield_normal.active.ypos",		"13"			},
  { "shield_normal.active.frames",		"3"			},
  { "shield_normal.active.delay",		"8"			},
  { "shield_normal.active.anim_mode",		"pingpong"		},

  { "shield_deadly",				"RocksDC.png"		},
  { "shield_deadly.xpos",			"8"			},
  { "shield_deadly.ypos",			"1"			},
  { "shield_deadly.frames",			"6"			},
  { "shield_deadly.delay",			"4"			},
  { "shield_deadly.active",			"RocksHeroes.png"	},
  { "shield_deadly.active.xpos",		"5"			},
  { "shield_deadly.active.ypos",		"13"			},
  { "shield_deadly.active.frames",		"3"			},
  { "shield_deadly.active.delay",		"8"			},
  { "shield_deadly.active.anim_mode",		"pingpong"		},

  { "switchgate_closed",			"RocksDC.png"		},
  { "switchgate_closed.xpos",			"8"			},
  { "switchgate_closed.ypos",			"5"			},
  { "switchgate_closed.frames",			"1"			},
  { "switchgate.opening",			"RocksDC.png"		},
  { "switchgate.opening.xpos",			"8"			},
  { "switchgate.opening.ypos",			"5"			},
  { "switchgate.opening.frames",		"5"			},
  { "switchgate.opening.delay",			"6"			},
  { "switchgate_open",				"RocksDC.png"		},
  { "switchgate_open.xpos",			"12"			},
  { "switchgate_open.ypos",			"5"			},
  { "switchgate_open.frames",			"1"			},
  { "switchgate.closing",			"RocksDC.png"		},
  { "switchgate.closing.xpos",			"8"			},
  { "switchgate.closing.ypos",			"5"			},
  { "switchgate.closing.frames",		"5"			},
  { "switchgate.closing.delay",			"6"			},
  { "switchgate.closing.anim_mode",		"reverse"		},

  { "timegate_closed",				"RocksDC.png"		},
  { "timegate_closed.xpos",			"8"			},
  { "timegate_closed.ypos",			"6"			},
  { "timegate_closed.frames",			"1"			},
  { "timegate.opening",				"RocksDC.png"		},
  { "timegate.opening.xpos",			"8"			},
  { "timegate.opening.ypos",			"6"			},
  { "timegate.opening.frames",			"5"			},
  { "timegate.opening.delay",			"6"			},
  { "timegate_open",				"RocksDC.png"		},
  { "timegate_open.xpos",			"12"			},
  { "timegate_open.ypos",			"6"			},
  { "timegate_open.frames",			"1"			},
  { "timegate.closing",				"RocksDC.png"		},
  { "timegate.closing.xpos",			"8"			},
  { "timegate.closing.ypos",			"6"			},
  { "timegate.closing.frames",			"5"			},
  { "timegate.closing.delay",			"6"			},
  { "timegate.closing.anim_mode",		"reverse"		},

  { "pearl",					"RocksDC.png"		},
  { "pearl.xpos",				"8"			},
  { "pearl.ypos",				"11"			},
  { "pearl.frames",				"1"			},
  { "pearl.breaking",				"RocksDC.png"		},
  { "pearl.breaking.xpos",			"8"			},
  { "pearl.breaking.ypos",			"12"			},
  { "pearl.breaking.frames",			"4"			},
  { "pearl.breaking.delay",			"2"			},
  { "pearl.breaking.anim_mode",			"linear"		},

  { "crystal",					"RocksDC.png"		},
  { "crystal.xpos",				"9"			},
  { "crystal.ypos",				"11"			},
  { "crystal.frames",				"1"			},

  { "wall_pearl",				"RocksDC.png"		},
  { "wall_pearl.xpos",				"10"			},
  { "wall_pearl.ypos",				"11"			},
  { "wall_pearl.frames",			"1"			},

  { "wall_crystal",				"RocksDC.png"		},
  { "wall_crystal.xpos",			"11"			},
  { "wall_crystal.ypos",			"11"			},
  { "wall_crystal.frames",			"1"			},

  { "dc_steelwall_1_left",			"RocksDC2.png"		},
  { "dc_steelwall_1_left.xpos",			"5"			},
  { "dc_steelwall_1_left.ypos",			"1"			},
  { "dc_steelwall_1_left.frames",		"1"			},
  { "dc_steelwall_1_right",			"RocksDC2.png"		},
  { "dc_steelwall_1_right.xpos",		"3"			},
  { "dc_steelwall_1_right.ypos",		"1"			},
  { "dc_steelwall_1_right.frames",		"1"			},
  { "dc_steelwall_1_top",			"RocksDC2.png"		},
  { "dc_steelwall_1_top.xpos",			"4"			},
  { "dc_steelwall_1_top.ypos",			"2"			},
  { "dc_steelwall_1_top.frames",		"1"			},
  { "dc_steelwall_1_bottom",			"RocksDC2.png"		},
  { "dc_steelwall_1_bottom.xpos",		"4"			},
  { "dc_steelwall_1_bottom.ypos",		"0"			},
  { "dc_steelwall_1_bottom.frames",		"1"			},
  { "dc_steelwall_1_horizontal",		"RocksDC2.png"		},
  { "dc_steelwall_1_horizontal.xpos",		"1"			},
  { "dc_steelwall_1_horizontal.ypos",		"0"			},
  { "dc_steelwall_1_horizontal.frames",		"1"			},
  { "dc_steelwall_1_vertical",			"RocksDC2.png"		},
  { "dc_steelwall_1_vertical.xpos",		"0"			},
  { "dc_steelwall_1_vertical.ypos",		"1"			},
  { "dc_steelwall_1_vertical.frames",		"1"			},
  { "dc_steelwall_1_topleft",			"RocksDC2.png"		},
  { "dc_steelwall_1_topleft.xpos",		"0"			},
  { "dc_steelwall_1_topleft.ypos",		"0"			},
  { "dc_steelwall_1_topleft.frames",		"1"			},
  { "dc_steelwall_1_topright",			"RocksDC2.png"		},
  { "dc_steelwall_1_topright.xpos",		"2"			},
  { "dc_steelwall_1_topright.ypos",		"0"			},
  { "dc_steelwall_1_topright.frames",		"1"			},
  { "dc_steelwall_1_bottomleft",		"RocksDC2.png"		},
  { "dc_steelwall_1_bottomleft.xpos",		"0"			},
  { "dc_steelwall_1_bottomleft.ypos",		"2"			},
  { "dc_steelwall_1_bottomleft.frames",		"1"			},
  { "dc_steelwall_1_bottomright",		"RocksDC2.png"		},
  { "dc_steelwall_1_bottomright.xpos",		"2"			},
  { "dc_steelwall_1_bottomright.ypos",		"2"			},
  { "dc_steelwall_1_bottomright.frames",	"1"			},
  { "dc_steelwall_1_topleft_2",			"RocksDC2.png"		},
  { "dc_steelwall_1_topleft_2.xpos",		"5"			},
  { "dc_steelwall_1_topleft_2.ypos",		"2"			},
  { "dc_steelwall_1_topleft_2.frames",		"1"			},
  { "dc_steelwall_1_topright_2",		"RocksDC2.png"		},
  { "dc_steelwall_1_topright_2.xpos",		"3"			},
  { "dc_steelwall_1_topright_2.ypos",		"2"			},
  { "dc_steelwall_1_topright_2.frames",		"1"			},
  { "dc_steelwall_1_bottomleft_2",		"RocksDC2.png"		},
  { "dc_steelwall_1_bottomleft_2.xpos",		"5"			},
  { "dc_steelwall_1_bottomleft_2.ypos",		"0"			},
  { "dc_steelwall_1_bottomleft_2.frames",	"1"			},
  { "dc_steelwall_1_bottomright_2",		"RocksDC2.png"		},
  { "dc_steelwall_1_bottomright_2.xpos",	"3"			},
  { "dc_steelwall_1_bottomright_2.ypos",	"0"			},
  { "dc_steelwall_1_bottomright_2.frames",	"1"			},

  { "dc_steelwall_2_left",			"RocksDC2.png"		},
  { "dc_steelwall_2_left.xpos",			"6"			},
  { "dc_steelwall_2_left.ypos",			"1"			},
  { "dc_steelwall_2_left.frames",		"1"			},
  { "dc_steelwall_2_right",			"RocksDC2.png"		},
  { "dc_steelwall_2_right.xpos",		"9"			},
  { "dc_steelwall_2_right.ypos",		"1"			},
  { "dc_steelwall_2_right.frames",		"1"			},
  { "dc_steelwall_2_top",			"RocksDC2.png"		},
  { "dc_steelwall_2_top.xpos",			"7"			},
  { "dc_steelwall_2_top.ypos",			"0"			},
  { "dc_steelwall_2_top.frames",		"1"			},
  { "dc_steelwall_2_bottom",			"RocksDC2.png"		},
  { "dc_steelwall_2_bottom.xpos",		"7"			},
  { "dc_steelwall_2_bottom.ypos",		"3"			},
  { "dc_steelwall_2_bottom.frames",		"1"			},
  { "dc_steelwall_2_horizontal",		"RocksDC2.png"		},
  { "dc_steelwall_2_horizontal.xpos",		"8"			},
  { "dc_steelwall_2_horizontal.ypos",		"1"			},
  { "dc_steelwall_2_horizontal.frames",		"1"			},
  { "dc_steelwall_2_vertical",			"RocksDC2.png"		},
  { "dc_steelwall_2_vertical.xpos",		"7"			},
  { "dc_steelwall_2_vertical.ypos",		"2"			},
  { "dc_steelwall_2_vertical.frames",		"1"			},
  { "dc_steelwall_2_middle",			"RocksDC2.png"		},
  { "dc_steelwall_2_middle.xpos",		"7"			},
  { "dc_steelwall_2_middle.ypos",		"1"			},
  { "dc_steelwall_2_middle.frames",		"1"			},
  { "dc_steelwall_2_single",			"RocksDC2.png"		},
  { "dc_steelwall_2_single.xpos",		"6"			},
  { "dc_steelwall_2_single.ypos",		"0"			},
  { "dc_steelwall_2_single.frames",		"1"			},

  // images for DX Boulderdash style elements and actions

  { "tube_right_down",				"RocksDC.png"		},
  { "tube_right_down.xpos",			"9"			},
  { "tube_right_down.ypos",			"13"			},
  { "tube_right_down.frames",			"1"			},

  { "tube_horizontal_down",			"RocksDC.png"		},
  { "tube_horizontal_down.xpos",		"10"			},
  { "tube_horizontal_down.ypos",		"13"			},
  { "tube_horizontal_down.frames",		"1"			},

  { "tube_left_down",				"RocksDC.png"		},
  { "tube_left_down.xpos",			"11"			},
  { "tube_left_down.ypos",			"13"			},
  { "tube_left_down.frames",			"1"			},

  { "tube_horizontal",				"RocksDC.png"		},
  { "tube_horizontal.xpos",			"8"			},
  { "tube_horizontal.ypos",			"14"			},
  { "tube_horizontal.frames",			"1"			},

  { "tube_vertical_right",			"RocksDC.png"		},
  { "tube_vertical_right.xpos",			"9"			},
  { "tube_vertical_right.ypos",			"14"			},
  { "tube_vertical_right.frames",		"1"			},

  { "tube_any",					"RocksDC.png"		},
  { "tube_any.xpos",				"10"			},
  { "tube_any.ypos",				"14"			},
  { "tube_any.frames",				"1"			},

  { "tube_vertical_left",			"RocksDC.png"		},
  { "tube_vertical_left.xpos",			"11"			},
  { "tube_vertical_left.ypos",			"14"			},
  { "tube_vertical_left.frames",		"1"			},

  { "tube_vertical",				"RocksDC.png"		},
  { "tube_vertical.xpos",			"8"			},
  { "tube_vertical.ypos",			"15"			},
  { "tube_vertical.frames",			"1"			},

  { "tube_right_up",				"RocksDC.png"		},
  { "tube_right_up.xpos",			"9"			},
  { "tube_right_up.ypos",			"15"			},
  { "tube_right_up.frames",			"1"			},

  { "tube_horizontal_up",			"RocksDC.png"		},
  { "tube_horizontal_up.xpos",			"10"			},
  { "tube_horizontal_up.ypos",			"15"			},
  { "tube_horizontal_up.frames",		"1"			},

  { "tube_left_up",				"RocksDC.png"		},
  { "tube_left_up.xpos",			"11"			},
  { "tube_left_up.ypos",			"15"			},
  { "tube_left_up.frames",			"1"			},

  { "trap",					"RocksDC.png"		},
  { "trap.xpos",				"12"			},
  { "trap.ypos",				"8"			},
  { "trap.frames",				"1"			},
  { "trap.crumbled_like",			"sand"			},
  { "trap.diggable_like",			"sand"			},
  { "trap.active",				"RocksDC.png"		},
  { "trap.active.xpos",				"12"			},
  { "trap.active.ypos",				"8"			},
  { "trap.active.frames",			"4"			},
  { "trap.active.delay",			"4"			},
  { "trap.active.anim_mode",			"pingpong2"		},
  { "trap.active.crumbled_like",		"sand"			},

  { "dx_supabomb",				"RocksDC.png"		},
  { "dx_supabomb.xpos",				"15"			},
  { "dx_supabomb.ypos",				"9"			},
  { "dx_supabomb.frames",			"1"			},

  // images for Rocks'n'Diamonds style elements and actions

  { "key_1",					"RocksElements.png"	},
  { "key_1.xpos",				"4"			},
  { "key_1.ypos",				"1"			},
  { "key_1.frames",				"1"			},
  { "key_2",					"RocksElements.png"	},
  { "key_2.xpos",				"5"			},
  { "key_2.ypos",				"1"			},
  { "key_2.frames",				"1"			},
  { "key_3",					"RocksElements.png"	},
  { "key_3.xpos",				"6"			},
  { "key_3.ypos",				"1"			},
  { "key_3.frames",				"1"			},
  { "key_4",					"RocksElements.png"	},
  { "key_4.xpos",				"7"			},
  { "key_4.ypos",				"1"			},
  { "key_4.frames",				"1"			},

  { "gate_1",					"RocksElements.png"	},
  { "gate_1.xpos",				"4"			},
  { "gate_1.ypos",				"2"			},
  { "gate_1.frames",				"1"			},
  { "gate_2",					"RocksElements.png"	},
  { "gate_2.xpos",				"5"			},
  { "gate_2.ypos",				"2"			},
  { "gate_2.frames",				"1"			},
  { "gate_3",					"RocksElements.png"	},
  { "gate_3.xpos",				"6"			},
  { "gate_3.ypos",				"2"			},
  { "gate_3.frames",				"1"			},
  { "gate_4",					"RocksElements.png"	},
  { "gate_4.xpos",				"7"			},
  { "gate_4.ypos",				"2"			},
  { "gate_4.frames",				"1"			},
  { "gate_1_gray",				"RocksElements.png"	},
  { "gate_1_gray.xpos",				"8"			},
  { "gate_1_gray.ypos",				"2"			},
  { "gate_1_gray.frames",			"1"			},
  { "gate_1_gray.EDITOR",			"RocksElements.png"	},
  { "gate_1_gray.EDITOR.xpos",			"8"			},
  { "gate_1_gray.EDITOR.ypos",			"14"			},
  { "gate_1_gray.active",			"RocksElements.png"	},
  { "gate_1_gray.active.xpos",			"4"			},
  { "gate_1_gray.active.ypos",			"2"			},
  { "gate_1_gray.active.frames",		"1"			},
  { "gate_2_gray",				"RocksElements.png"	},
  { "gate_2_gray.xpos",				"9"			},
  { "gate_2_gray.ypos",				"2"			},
  { "gate_2_gray.frames",			"1"			},
  { "gate_2_gray.EDITOR",			"RocksElements.png"	},
  { "gate_2_gray.EDITOR.xpos",			"9"			},
  { "gate_2_gray.EDITOR.ypos",			"14"			},
  { "gate_2_gray.active",			"RocksElements.png"	},
  { "gate_2_gray.active.xpos",			"5"			},
  { "gate_2_gray.active.ypos",			"2"			},
  { "gate_2_gray.active.frames",		"1"			},
  { "gate_3_gray",				"RocksElements.png"	},
  { "gate_3_gray.xpos",				"10"			},
  { "gate_3_gray.ypos",				"2"			},
  { "gate_3_gray.frames",			"1"			},
  { "gate_3_gray.EDITOR",			"RocksElements.png"	},
  { "gate_3_gray.EDITOR.xpos",			"10"			},
  { "gate_3_gray.EDITOR.ypos",			"14"			},
  { "gate_3_gray.active",			"RocksElements.png"	},
  { "gate_3_gray.active.xpos",			"6"			},
  { "gate_3_gray.active.ypos",			"2"			},
  { "gate_3_gray.active.frames",		"1"			},
  { "gate_4_gray",				"RocksElements.png"	},
  { "gate_4_gray.xpos",				"11"			},
  { "gate_4_gray.ypos",				"2"			},
  { "gate_4_gray.frames",			"1"			},
  { "gate_4_gray.EDITOR",			"RocksElements.png"	},
  { "gate_4_gray.EDITOR.xpos",			"11"			},
  { "gate_4_gray.EDITOR.ypos",			"14"			},
  { "gate_4_gray.active",			"RocksElements.png"	},
  { "gate_4_gray.active.xpos",			"7"			},
  { "gate_4_gray.active.ypos",			"2"			},
  { "gate_4_gray.active.frames",		"1"			},

  { "game_of_life",				"RocksElements.png"	},
  { "game_of_life.xpos",			"8"			},
  { "game_of_life.ypos",			"1"			},
  { "game_of_life.frames",			"1"			},

  { "biomaze",					"RocksElements.png"	},
  { "biomaze.xpos",				"9"			},
  { "biomaze.ypos",				"1"			},
  { "biomaze.frames",				"1"			},

  { "pacman",					"RocksElements.png"	},
  { "pacman.xpos",				"8"			},
  { "pacman.ypos",				"5"			},
  { "pacman.frames",				"1"			},
  { "pacman.right",				"RocksElements.png"	},
  { "pacman.right.xpos",			"8"			},
  { "pacman.right.ypos",			"5"			},
  { "pacman.right.frames",			"2"			},
  { "pacman.right.delay",			"4"			},
  { "pacman.right.offset",			"128"			},
  { "pacman.up",				"RocksElements.png"	},
  { "pacman.up.xpos",				"9"			},
  { "pacman.up.ypos",				"5"			},
  { "pacman.up.frames",				"2"			},
  { "pacman.up.delay",				"4"			},
  { "pacman.up.offset",				"128"			},
  { "pacman.left",				"RocksElements.png"	},
  { "pacman.left.xpos",				"10"			},
  { "pacman.left.ypos",				"5"			},
  { "pacman.left.frames",			"2"			},
  { "pacman.left.delay",			"4"			},
  { "pacman.left.offset",			"128"			},
  { "pacman.down",				"RocksElements.png"	},
  { "pacman.down.xpos",				"11"			},
  { "pacman.down.ypos",				"5"			},
  { "pacman.down.frames",			"2"			},
  { "pacman.down.delay",			"4"			},
  { "pacman.down.offset",			"128"			},
  { "pacman.turning_from_right",		"RocksElements.png"	},
  { "pacman.turning_from_right.xpos",		"12"			},
  { "pacman.turning_from_right.ypos",		"5"			},
  { "pacman.turning_from_right.frames",		"1"			},
  { "pacman.turning_from_up",			"RocksElements.png"	},
  { "pacman.turning_from_up.xpos",		"13"			},
  { "pacman.turning_from_up.ypos",		"5"			},
  { "pacman.turning_from_up.frames",		"1"			},
  { "pacman.turning_from_left",			"RocksElements.png"	},
  { "pacman.turning_from_left.xpos",		"14"			},
  { "pacman.turning_from_left.ypos",		"5"			},
  { "pacman.turning_from_left.frames",		"1"			},
  { "pacman.turning_from_down",			"RocksElements.png"	},
  { "pacman.turning_from_down.xpos",		"15"			},
  { "pacman.turning_from_down.ypos",		"5"			},
  { "pacman.turning_from_down.frames",		"1"			},

  { "lamp",					"RocksElements.png"	},
  { "lamp.xpos",				"0"			},
  { "lamp.ypos",				"7"			},
  { "lamp.frames",				"1"			},
  { "lamp.active",				"RocksElements.png"	},
  { "lamp.active.xpos",				"1"			},
  { "lamp.active.ypos",				"7"			},
  { "lamp.active.frames",			"1"			},

  { "time_orb_full",				"RocksElements.png"	},
  { "time_orb_full.xpos",			"2"			},
  { "time_orb_full.ypos",			"7"			},
  { "time_orb_full.frames",			"1"			},
  { "time_orb_empty",				"RocksElements.png"	},
  { "time_orb_empty.xpos",			"3"			},
  { "time_orb_empty.ypos",			"7"			},
  { "time_orb_empty.frames",			"1"			},

  { "emerald_yellow",				"RocksElements.png"	},
  { "emerald_yellow.xpos",			"10"			},
  { "emerald_yellow.ypos",			"8"			},
  { "emerald_yellow.frames",			"1"			},
  { "emerald_yellow.moving",			"RocksElements.png"	},
  { "emerald_yellow.moving.xpos",		"10"			},
  { "emerald_yellow.moving.ypos",		"8"			},
  { "emerald_yellow.moving.frames",		"2"			},
  { "emerald_yellow.moving.delay",		"4"			},
  { "emerald_yellow.falling",			"RocksElements.png"	},
  { "emerald_yellow.falling.xpos",		"10"			},
  { "emerald_yellow.falling.ypos",		"8"			},
  { "emerald_yellow.falling.frames",		"2"			},
  { "emerald_yellow.falling.delay",		"4"			},
  { "emerald_red",				"RocksElements.png"	},
  { "emerald_red.xpos",				"8"			},
  { "emerald_red.ypos",				"9"			},
  { "emerald_red.frames",			"1"			},
  { "emerald_red.moving",			"RocksElements.png"	},
  { "emerald_red.moving.xpos",			"8"			},
  { "emerald_red.moving.ypos",			"9"			},
  { "emerald_red.moving.frames",		"2"			},
  { "emerald_red.moving.delay",			"4"			},
  { "emerald_red.falling",			"RocksElements.png"	},
  { "emerald_red.falling.xpos",			"8"			},
  { "emerald_red.falling.ypos",			"9"			},
  { "emerald_red.falling.frames",		"2"			},
  { "emerald_red.falling.delay",		"4"			},
  { "emerald_purple",				"RocksElements.png"	},
  { "emerald_purple.xpos",			"10"			},
  { "emerald_purple.ypos",			"9"			},
  { "emerald_purple.frames",			"1"			},
  { "emerald_purple.moving",			"RocksElements.png"	},
  { "emerald_purple.moving.xpos",		"10"			},
  { "emerald_purple.moving.ypos",		"9"			},
  { "emerald_purple.moving.frames",		"2"			},
  { "emerald_purple.moving.delay",		"4"			},
  { "emerald_purple.falling",			"RocksElements.png"	},
  { "emerald_purple.falling.xpos",		"10"			},
  { "emerald_purple.falling.ypos",		"9"			},
  { "emerald_purple.falling.frames",		"2"			},
  { "emerald_purple.falling.delay",		"4"			},

  { "wall_emerald_yellow",			"RocksElements.png"	},
  { "wall_emerald_yellow.xpos",			"8"			},
  { "wall_emerald_yellow.ypos",			"8"			},
  { "wall_emerald_yellow.frames",		"1"			},
  { "wall_emerald_red",				"RocksElements.png"	},
  { "wall_emerald_red.xpos",			"6"			},
  { "wall_emerald_red.ypos",			"8"			},
  { "wall_emerald_red.frames",			"1"			},
  { "wall_emerald_purple",			"RocksElements.png"	},
  { "wall_emerald_purple.xpos",			"7"			},
  { "wall_emerald_purple.ypos",			"8"			},
  { "wall_emerald_purple.frames",		"1"			},
  { "wall_bd_diamond",				"RocksElements.png"	},
  { "wall_bd_diamond.xpos",			"9"			},
  { "wall_bd_diamond.ypos",			"8"			},
  { "wall_bd_diamond.frames",			"1"			},

  { "expandable_wall",				"RocksElements.png"	},
  { "expandable_wall.xpos",			"11"			},
  { "expandable_wall.ypos",			"10"			},
  { "expandable_wall.frames",			"1"			},
  { "expandable_wall_horizontal",		"RocksElements.png"	},
  { "expandable_wall_horizontal.xpos",		"5"			},
  { "expandable_wall_horizontal.ypos",		"9"			},
  { "expandable_wall_horizontal.frames",	"1"			},
  { "expandable_wall_horizontal.EDITOR",	"RocksElements.png"	},
  { "expandable_wall_horizontal.EDITOR.xpos",	"13"			},
  { "expandable_wall_horizontal.EDITOR.ypos",	"13"			},
  { "expandable_wall_vertical",			"RocksElements.png"	},
  { "expandable_wall_vertical.xpos",		"6"			},
  { "expandable_wall_vertical.ypos",		"9"			},
  { "expandable_wall_vertical.frames",		"1"			},
  { "expandable_wall_vertical.EDITOR",		"RocksElements.png"	},
  { "expandable_wall_vertical.EDITOR.xpos",	"14"			},
  { "expandable_wall_vertical.EDITOR.ypos",	"13"			},
  { "expandable_wall_any",			"RocksElements.png"	},
  { "expandable_wall_any.xpos",			"4"			},
  { "expandable_wall_any.ypos",			"9"			},
  { "expandable_wall_any.frames",		"1"			},
  { "expandable_wall_any.EDITOR",		"RocksElements.png"	},
  { "expandable_wall_any.EDITOR.xpos",		"12"			},
  { "expandable_wall_any.EDITOR.ypos",		"13"			},

  { "expandable_steelwall_horizontal",		"RocksDC2.png"		},
  { "expandable_steelwall_horizontal.xpos",	"6"			},
  { "expandable_steelwall_horizontal.ypos",	"2"			},
  { "expandable_steelwall_horizontal.frames",	"1"			},
  { "expandable_steelwall_horizontal.EDITOR",	"RocksDC2.png"		},
  { "expandable_steelwall_horizontal.EDITOR.xpos","9"			},
  { "expandable_steelwall_horizontal.EDITOR.ypos","2"			},
  { "expandable_steelwall_vertical",		"RocksDC2.png"		},
  { "expandable_steelwall_vertical.xpos",	"6"			},
  { "expandable_steelwall_vertical.ypos",	"2"			},
  { "expandable_steelwall_vertical.frames",	"1"			},
  { "expandable_steelwall_vertical.EDITOR",	"RocksDC2.png"		},
  { "expandable_steelwall_vertical.EDITOR.xpos","10"			},
  { "expandable_steelwall_vertical.EDITOR.ypos","2"			},
  { "expandable_steelwall_any",			"RocksDC2.png"		},
  { "expandable_steelwall_any.xpos",		"6"			},
  { "expandable_steelwall_any.ypos",		"2"			},
  { "expandable_steelwall_any.frames",		"1"			},
  { "expandable_steelwall_any.EDITOR",		"RocksDC2.png"		},
  { "expandable_steelwall_any.EDITOR.xpos",	"8"			},
  { "expandable_steelwall_any.EDITOR.ypos",	"2"			},

  { "bd_expandable_wall",			"RocksElements.png"	},
  { "bd_expandable_wall.xpos",			"5"			},
  { "bd_expandable_wall.ypos",			"9"			},
  { "bd_expandable_wall.frames",		"1"			},
  { "bd_expandable_wall.EDITOR",		"RocksDC.png"		},
  { "bd_expandable_wall.EDITOR.xpos",		"15"			},
  { "bd_expandable_wall.EDITOR.ypos",		"15"			},

  { "expandable_wall.growing.left",		"RocksElements.png"	},
  { "expandable_wall.growing.left.xpos",	"8"			},
  { "expandable_wall.growing.left.ypos",	"10"			},
  { "expandable_wall.growing.left.frames",	"3"			},
  { "expandable_wall.growing.left.delay",	"6"			},
  { "expandable_wall.growing.left.anim_mode",	"linear"		},
  { "expandable_wall.growing.right",		"RocksElements.png"	},
  { "expandable_wall.growing.right.xpos",	"5"			},
  { "expandable_wall.growing.right.ypos",	"10"			},
  { "expandable_wall.growing.right.frames",	"3"			},
  { "expandable_wall.growing.right.delay",	"6"			},
  { "expandable_wall.growing.right.anim_mode",	"linear"		},
  { "expandable_wall.growing.up",		"RocksHeroes.png"	},
  { "expandable_wall.growing.up.xpos",		"3"			},
  { "expandable_wall.growing.up.ypos",		"12"			},
  { "expandable_wall.growing.up.frames",	"3"			},
  { "expandable_wall.growing.up.delay",		"6"			},
  { "expandable_wall.growing.up.anim_mode",	"linear"		},
  { "expandable_wall.growing.down",		"RocksHeroes.png"	},
  { "expandable_wall.growing.down.xpos",	"0"			},
  { "expandable_wall.growing.down.ypos",	"12"			},
  { "expandable_wall.growing.down.frames",	"3"			},
  { "expandable_wall.growing.down.delay",	"6"			},
  { "expandable_wall.growing.down.anim_mode",	"linear"		},

  { "expandable_steelwall.growing.left",	"RocksDC2.png"		},
  { "expandable_steelwall.growing.left.xpos",	"8"			},
  { "expandable_steelwall.growing.left.ypos",	"4"			},
  { "expandable_steelwall.growing.left.frames",	"4"			},
  { "expandable_steelwall.growing.left.delay",	"4"			},
  { "expandable_steelwall.growing.left.anim_mode","linear"		},
  { "expandable_steelwall.growing.right",	"RocksDC2.png"		},
  { "expandable_steelwall.growing.right.xpos",	"12"			},
  { "expandable_steelwall.growing.right.ypos",	"4"			},
  { "expandable_steelwall.growing.right.frames","4"			},
  { "expandable_steelwall.growing.right.delay",	"4"			},
  { "expandable_steelwall.growing.right.anim_mode","linear"		},
  { "expandable_steelwall.growing.up",		"RocksDC2.png"		},
  { "expandable_steelwall.growing.up.xpos",	"8"			},
  { "expandable_steelwall.growing.up.ypos",	"5"			},
  { "expandable_steelwall.growing.up.frames",	"4"			},
  { "expandable_steelwall.growing.up.delay",	"4"			},
  { "expandable_steelwall.growing.up.anim_mode","linear"		},
  { "expandable_steelwall.growing.down",	"RocksDC2.png"		},
  { "expandable_steelwall.growing.down.xpos",	"12"			},
  { "expandable_steelwall.growing.down.ypos",	"5"			},
  { "expandable_steelwall.growing.down.frames",	"4"			},
  { "expandable_steelwall.growing.down.delay",	"4"			},
  { "expandable_steelwall.growing.down.anim_mode","linear"		},

  { "black_orb",				"RocksElements.png"	},
  { "black_orb.xpos",				"13"			},
  { "black_orb.ypos",				"9"			},
  { "black_orb.frames",				"1"			},

  { "speed_pill",				"RocksElements.png"	},
  { "speed_pill.xpos",				"14"			},
  { "speed_pill.ypos",				"9"			},
  { "speed_pill.frames",			"1"			},

  { "dark_yamyam",				"RocksElements.png"	},
  { "dark_yamyam.xpos",				"8"			},
  { "dark_yamyam.ypos",				"11"			},
  { "dark_yamyam.frames",			"4"			},
  { "dark_yamyam.anim_mode",			"pingpong2"		},

  { "dynabomb",					"RocksElements.png"	},
  { "dynabomb.xpos",				"12"			},
  { "dynabomb.ypos",				"11"			},
  { "dynabomb.frames",				"1"			},
  { "dynabomb.active",				"RocksElements.png"	},
  { "dynabomb.active.xpos",			"12"			},
  { "dynabomb.active.ypos",			"11"			},
  { "dynabomb.active.frames",			"4"			},
  { "dynabomb.active.delay",			"6"			},
  { "dynabomb.active.anim_mode",		"pingpong"		},
  { "dynabomb_player_1",			"RocksElements.png"	},
  { "dynabomb_player_1.xpos",			"12"			},
  { "dynabomb_player_1.ypos",			"11"			},
  { "dynabomb_player_1.frames",			"1"			},
  { "dynabomb_player_1.active",			"RocksElements.png"	},
  { "dynabomb_player_1.active.xpos",		"12"			},
  { "dynabomb_player_1.active.ypos",		"11"			},
  { "dynabomb_player_1.active.frames",		"4"			},
  { "dynabomb_player_1.active.delay",		"6"			},
  { "dynabomb_player_1.active.anim_mode",	"pingpong"		},
  { "dynabomb_player_2",			"RocksElements.png"	},
  { "dynabomb_player_2.xpos",			"12"			},
  { "dynabomb_player_2.ypos",			"11"			},
  { "dynabomb_player_2.frames",			"1"			},
  { "dynabomb_player_2.active",			"RocksElements.png"	},
  { "dynabomb_player_2.active.xpos",		"12"			},
  { "dynabomb_player_2.active.ypos",		"11"			},
  { "dynabomb_player_2.active.frames",		"4"			},
  { "dynabomb_player_2.active.delay",		"6"			},
  { "dynabomb_player_2.active.anim_mode",	"pingpong"		},
  { "dynabomb_player_3",			"RocksElements.png"	},
  { "dynabomb_player_3.xpos",			"12"			},
  { "dynabomb_player_3.ypos",			"11"			},
  { "dynabomb_player_3.frames",			"1"			},
  { "dynabomb_player_3.active",			"RocksElements.png"	},
  { "dynabomb_player_3.active.xpos",		"12"			},
  { "dynabomb_player_3.active.ypos",		"11"			},
  { "dynabomb_player_3.active.frames",		"4"			},
  { "dynabomb_player_3.active.delay",		"6"			},
  { "dynabomb_player_3.active.anim_mode",	"pingpong"		},
  { "dynabomb_player_4",			"RocksElements.png"	},
  { "dynabomb_player_4.xpos",			"12"			},
  { "dynabomb_player_4.ypos",			"11"			},
  { "dynabomb_player_4.frames",			"1"			},
  { "dynabomb_player_4.active",			"RocksElements.png"	},
  { "dynabomb_player_4.active.xpos",		"12"			},
  { "dynabomb_player_4.active.ypos",		"11"			},
  { "dynabomb_player_4.active.frames",		"4"			},
  { "dynabomb_player_4.active.delay",		"6"			},
  { "dynabomb_player_4.active.anim_mode",	"pingpong"		},
  { "dynabomb_increase_number",			"RocksElements.png"	},
  { "dynabomb_increase_number.xpos",		"12"			},
  { "dynabomb_increase_number.ypos",		"11"			},
  { "dynabomb_increase_number.frames",		"1"			},
  { "dynabomb_increase_size",			"RocksElements.png"	},
  { "dynabomb_increase_size.xpos",		"15"			},
  { "dynabomb_increase_size.ypos",		"11"			},
  { "dynabomb_increase_size.frames",		"1"			},
  { "dynabomb_increase_power",			"RocksElements.png"	},
  { "dynabomb_increase_power.xpos",		"12"			},
  { "dynabomb_increase_power.ypos",		"9"			},
  { "dynabomb_increase_power.frames",		"1"			},

  { "pig",					"RocksHeroes.png"	},
  { "pig.xpos",					"8"			},
  { "pig.ypos",					"0"			},
  { "pig.frames",				"1"			},
  { "pig.down",					"RocksHeroes.png"	},
  { "pig.down.xpos",				"8"			},
  { "pig.down.ypos",				"0"			},
  { "pig.down.frames",				"1"			},
  { "pig.up",					"RocksHeroes.png"	},
  { "pig.up.xpos",				"12"			},
  { "pig.up.ypos",				"0"			},
  { "pig.up.frames",				"1"			},
  { "pig.left",					"RocksHeroes.png"	},
  { "pig.left.xpos",				"8"			},
  { "pig.left.ypos",				"1"			},
  { "pig.left.frames",				"1"			},
  { "pig.right",				"RocksHeroes.png"	},
  { "pig.right.xpos",				"12"			},
  { "pig.right.ypos",				"1"			},
  { "pig.right.frames",				"1"			},
  { "pig.moving.down",				"RocksHeroes.png"	},
  { "pig.moving.down.xpos",			"8"			},
  { "pig.moving.down.ypos",			"0"			},
  { "pig.moving.down.frames",			"4"			},
  { "pig.moving.down.delay",			"2"			},
  { "pig.moving.up",				"RocksHeroes.png"	},
  { "pig.moving.up.xpos",			"12"			},
  { "pig.moving.up.ypos",			"0"			},
  { "pig.moving.up.frames",			"4"			},
  { "pig.moving.up.delay",			"2"			},
  { "pig.moving.left",				"RocksHeroes.png"	},
  { "pig.moving.left.xpos",			"8"			},
  { "pig.moving.left.ypos",			"1"			},
  { "pig.moving.left.frames",			"4"			},
  { "pig.moving.left.delay",			"2"			},
  { "pig.moving.right",				"RocksHeroes.png"	},
  { "pig.moving.right.xpos",			"12"			},
  { "pig.moving.right.ypos",			"1"			},
  { "pig.moving.right.frames",			"4"			},
  { "pig.moving.right.delay",			"2"			},
  { "pig.digging.down",				"RocksHeroes.png"	},
  { "pig.digging.down.xpos",			"8"			},
  { "pig.digging.down.ypos",			"0"			},
  { "pig.digging.down.frames",			"4"			},
  { "pig.digging.down.delay",			"2"			},
  { "pig.digging.up",				"RocksHeroes.png"	},
  { "pig.digging.up.xpos",			"12"			},
  { "pig.digging.up.ypos",			"0"			},
  { "pig.digging.up.frames",			"4"			},
  { "pig.digging.up.delay",			"2"			},
  { "pig.digging.left",				"RocksHeroes.png"	},
  { "pig.digging.left.xpos",			"8"			},
  { "pig.digging.left.ypos",			"1"			},
  { "pig.digging.left.frames",			"4"			},
  { "pig.digging.left.delay",			"2"			},
  { "pig.digging.right",			"RocksHeroes.png"	},
  { "pig.digging.right.xpos",			"12"			},
  { "pig.digging.right.ypos",			"1"			},
  { "pig.digging.right.frames",			"4"			},
  { "pig.digging.right.delay",			"2"			},

  { "dragon",					"RocksHeroes.png"	},
  { "dragon.xpos",				"8"			},
  { "dragon.ypos",				"2"			},
  { "dragon.frames",				"1"			},
  { "dragon.down",				"RocksHeroes.png"	},
  { "dragon.down.xpos",				"8"			},
  { "dragon.down.ypos",				"2"			},
  { "dragon.down.frames",			"1"			},
  { "dragon.up",				"RocksHeroes.png"	},
  { "dragon.up.xpos",				"12"			},
  { "dragon.up.ypos",				"2"			},
  { "dragon.up.frames",				"1"			},
  { "dragon.left",				"RocksHeroes.png"	},
  { "dragon.left.xpos",				"8"			},
  { "dragon.left.ypos",				"3"			},
  { "dragon.left.frames",			"1"			},
  { "dragon.right",				"RocksHeroes.png"	},
  { "dragon.right.xpos",			"12"			},
  { "dragon.right.ypos",			"3"			},
  { "dragon.right.frames",			"1"			},
  { "dragon.moving.down",			"RocksHeroes.png"	},
  { "dragon.moving.down.xpos",			"8"			},
  { "dragon.moving.down.ypos",			"2"			},
  { "dragon.moving.down.frames",		"4"			},
  { "dragon.moving.down.delay",			"2"			},
  { "dragon.moving.up",				"RocksHeroes.png"	},
  { "dragon.moving.up.xpos",			"12"			},
  { "dragon.moving.up.ypos",			"2"			},
  { "dragon.moving.up.frames",			"4"			},
  { "dragon.moving.up.delay",			"2"			},
  { "dragon.moving.left",			"RocksHeroes.png"	},
  { "dragon.moving.left.xpos",			"8"			},
  { "dragon.moving.left.ypos",			"3"			},
  { "dragon.moving.left.frames",		"4"			},
  { "dragon.moving.left.delay",			"2"			},
  { "dragon.moving.right",			"RocksHeroes.png"	},
  { "dragon.moving.right.xpos",			"12"			},
  { "dragon.moving.right.ypos",			"3"			},
  { "dragon.moving.right.frames",		"4"			},
  { "dragon.moving.right.delay",		"2"			},
  { "dragon.attacking.down",			"RocksHeroes.png"	},
  { "dragon.attacking.down.xpos",		"8"			},
  { "dragon.attacking.down.ypos",		"2"			},
  { "dragon.attacking.down.frames",		"1"			},
  { "dragon.attacking.up",			"RocksHeroes.png"	},
  { "dragon.attacking.up.xpos",			"12"			},
  { "dragon.attacking.up.ypos",			"2"			},
  { "dragon.attacking.up.frames",		"1"			},
  { "dragon.attacking.left",			"RocksHeroes.png"	},
  { "dragon.attacking.left.xpos",		"8"			},
  { "dragon.attacking.left.ypos",		"3"			},
  { "dragon.attacking.left.frames",		"1"			},
  { "dragon.attacking.right",			"RocksHeroes.png"	},
  { "dragon.attacking.right.xpos",		"12"			},
  { "dragon.attacking.right.ypos",		"3"			},
  { "dragon.attacking.right.frames",		"1"			},

  { "mole",					"RocksHeroes.png"	},
  { "mole.xpos",				"8"			},
  { "mole.ypos",				"4"			},
  { "mole.frames",				"1"			},
  { "mole.down",				"RocksHeroes.png"	},
  { "mole.down.xpos",				"8"			},
  { "mole.down.ypos",				"4"			},
  { "mole.down.frames",				"1"			},
  { "mole.up",					"RocksHeroes.png"	},
  { "mole.up.xpos",				"12"			},
  { "mole.up.ypos",				"4"			},
  { "mole.up.frames",				"1"			},
  { "mole.left",				"RocksHeroes.png"	},
  { "mole.left.xpos",				"8"			},
  { "mole.left.ypos",				"5"			},
  { "mole.left.frames",				"1"			},
  { "mole.right",				"RocksHeroes.png"	},
  { "mole.right.xpos",				"12"			},
  { "mole.right.ypos",				"5"			},
  { "mole.right.frames",			"1"			},
  { "mole.moving.down",				"RocksHeroes.png"	},
  { "mole.moving.down.xpos",			"8"			},
  { "mole.moving.down.ypos",			"4"			},
  { "mole.moving.down.frames",			"4"			},
  { "mole.moving.down.delay",			"2"			},
  { "mole.moving.up",				"RocksHeroes.png"	},
  { "mole.moving.up.xpos",			"12"			},
  { "mole.moving.up.ypos",			"4"			},
  { "mole.moving.up.frames",			"4"			},
  { "mole.moving.up.delay",			"2"			},
  { "mole.moving.left",				"RocksHeroes.png"	},
  { "mole.moving.left.xpos",			"8"			},
  { "mole.moving.left.ypos",			"5"			},
  { "mole.moving.left.frames",			"4"			},
  { "mole.moving.left.delay",			"2"			},
  { "mole.moving.right",			"RocksHeroes.png"	},
  { "mole.moving.right.xpos",			"12"			},
  { "mole.moving.right.ypos",			"5"			},
  { "mole.moving.right.frames",			"4"			},
  { "mole.moving.right.delay",			"2"			},
  { "mole.digging.down",			"RocksHeroes.png"	},
  { "mole.digging.down.xpos",			"8"			},
  { "mole.digging.down.ypos",			"4"			},
  { "mole.digging.down.frames",			"4"			},
  { "mole.digging.down.delay",			"2"			},
  { "mole.digging.up",				"RocksHeroes.png"	},
  { "mole.digging.up.xpos",			"12"			},
  { "mole.digging.up.ypos",			"4"			},
  { "mole.digging.up.frames",			"4"			},
  { "mole.digging.up.delay",			"2"			},
  { "mole.digging.left",			"RocksHeroes.png"	},
  { "mole.digging.left.xpos",			"8"			},
  { "mole.digging.left.ypos",			"5"			},
  { "mole.digging.left.frames",			"4"			},
  { "mole.digging.left.delay",			"2"			},
  { "mole.digging.right",			"RocksHeroes.png"	},
  { "mole.digging.right.xpos",			"12"			},
  { "mole.digging.right.ypos",			"5"			},
  { "mole.digging.right.frames",		"4"			},
  { "mole.digging.right.delay",			"2"			},

  { "penguin",					"RocksHeroes.png"	},
  { "penguin.xpos",				"8"			},
  { "penguin.ypos",				"6"			},
  { "penguin.frames",				"1"			},
  { "penguin.down",				"RocksHeroes.png"	},
  { "penguin.down.xpos",			"8"			},
  { "penguin.down.ypos",			"6"			},
  { "penguin.down.frames",			"1"			},
  { "penguin.up",				"RocksHeroes.png"	},
  { "penguin.up.xpos",				"12"			},
  { "penguin.up.ypos",				"6"			},
  { "penguin.up.frames",			"1"			},
  { "penguin.left",				"RocksHeroes.png"	},
  { "penguin.left.xpos",			"8"			},
  { "penguin.left.ypos",			"7"			},
  { "penguin.left.frames",			"1"			},
  { "penguin.right",				"RocksHeroes.png"	},
  { "penguin.right.xpos",			"12"			},
  { "penguin.right.ypos",			"7"			},
  { "penguin.right.frames",			"1"			},
  { "penguin.moving.down",			"RocksHeroes.png"	},
  { "penguin.moving.down.xpos",			"8"			},
  { "penguin.moving.down.ypos",			"6"			},
  { "penguin.moving.down.frames",		"4"			},
  { "penguin.moving.down.delay",		"2"			},
  { "penguin.moving.up",			"RocksHeroes.png"	},
  { "penguin.moving.up.xpos",			"12"			},
  { "penguin.moving.up.ypos",			"6"			},
  { "penguin.moving.up.frames",			"4"			},
  { "penguin.moving.up.delay",			"2"			},
  { "penguin.moving.left",			"RocksHeroes.png"	},
  { "penguin.moving.left.xpos",			"8"			},
  { "penguin.moving.left.ypos",			"7"			},
  { "penguin.moving.left.frames",		"4"			},
  { "penguin.moving.left.delay",		"2"			},
  { "penguin.moving.right",			"RocksHeroes.png"	},
  { "penguin.moving.right.xpos",		"12"			},
  { "penguin.moving.right.ypos",		"7"			},
  { "penguin.moving.right.frames",		"4"			},
  { "penguin.moving.right.delay",		"2"			},

  { "satellite",				"RocksHeroes.png"	},
  { "satellite.xpos",				"8"			},
  { "satellite.ypos",				"9"			},
  { "satellite.frames",				"8"			},
  { "satellite.delay",				"2"			},
  { "satellite.global_sync",			"true"			},

  { "flames_1_left",				"RocksHeroes.png"	},
  { "flames_1_left.xpos",			"8"			},
  { "flames_1_left.ypos",			"12"			},
  { "flames_1_left.frames",			"2"			},
  { "flames_1_left.offset",			"96"			},
  { "flames_2_left",				"RocksHeroes.png"	},
  { "flames_2_left.xpos",			"9"			},
  { "flames_2_left.ypos",			"12"			},
  { "flames_2_left.frames",			"2"			},
  { "flames_2_left.offset",			"96"			},
  { "flames_3_left",				"RocksHeroes.png"	},
  { "flames_3_left.xpos",			"10"			},
  { "flames_3_left.ypos",			"12"			},
  { "flames_3_left.frames",			"2"			},
  { "flames_3_left.offset",			"96"			},

  { "flames_1_right",				"RocksHeroes.png"	},
  { "flames_1_right.xpos",			"8"			},
  { "flames_1_right.ypos",			"13"			},
  { "flames_1_right.frames",			"2"			},
  { "flames_1_right.offset",			"96"			},
  { "flames_2_right",				"RocksHeroes.png"	},
  { "flames_2_right.xpos",			"9"			},
  { "flames_2_right.ypos",			"13"			},
  { "flames_2_right.frames",			"2"			},
  { "flames_2_right.offset",			"96"			},
  { "flames_3_right",				"RocksHeroes.png"	},
  { "flames_3_right.xpos",			"10"			},
  { "flames_3_right.ypos",			"13"			},
  { "flames_3_right.frames",			"2"			},
  { "flames_3_right.offset",			"96"			},

  { "flames_1_up",				"RocksHeroes.png"	},
  { "flames_1_up.xpos",				"8"			},
  { "flames_1_up.ypos",				"14"			},
  { "flames_1_up.frames",			"2"			},
  { "flames_1_up.offset",			"96"			},
  { "flames_2_up",				"RocksHeroes.png"	},
  { "flames_2_up.xpos",				"9"			},
  { "flames_2_up.ypos",				"14"			},
  { "flames_2_up.frames",			"2"			},
  { "flames_2_up.offset",			"96"			},
  { "flames_3_up",				"RocksHeroes.png"	},
  { "flames_3_up.xpos",				"10"			},
  { "flames_3_up.ypos",				"14"			},
  { "flames_3_up.frames",			"2"			},
  { "flames_3_up.offset",			"96"			},

  { "flames_1_down",				"RocksHeroes.png"	},
  { "flames_1_down.xpos",			"8"			},
  { "flames_1_down.ypos",			"15"			},
  { "flames_1_down.frames",			"2"			},
  { "flames_1_down.offset",			"96"			},
  { "flames_2_down",				"RocksHeroes.png"	},
  { "flames_2_down.xpos",			"9"			},
  { "flames_2_down.ypos",			"15"			},
  { "flames_2_down.frames",			"2"			},
  { "flames_2_down.offset",			"96"			},
  { "flames_3_down",				"RocksHeroes.png"	},
  { "flames_3_down.xpos",			"10"			},
  { "flames_3_down.ypos",			"15"			},
  { "flames_3_down.frames",			"2"			},
  { "flames_3_down.offset",			"96"			},

  { "stoneblock",				"RocksElements.png"	},
  { "stoneblock.xpos",				"10"			},
  { "stoneblock.ypos",				"1"			},
  { "stoneblock.frames",			"1"			},

  // images for other elements and actions

  { "player_1",					"RocksHeroes.png"	},
  { "player_1.xpos",				"0"			},
  { "player_1.ypos",				"0"			},
  { "player_1.frames",				"1"			},
  { "player_1.down",				"RocksHeroes.png"	},
  { "player_1.down.xpos",			"0"			},
  { "player_1.down.ypos",			"0"			},
  { "player_1.down.frames",			"1"			},
  { "player_1.up",				"RocksHeroes.png"	},
  { "player_1.up.xpos",				"4"			},
  { "player_1.up.ypos",				"0"			},
  { "player_1.up.frames",			"1"			},
  { "player_1.left",				"RocksHeroes.png"	},
  { "player_1.left.xpos",			"0"			},
  { "player_1.left.ypos",			"1"			},
  { "player_1.left.frames",			"1"			},
  { "player_1.right",				"RocksHeroes.png"	},
  { "player_1.right.xpos",			"4"			},
  { "player_1.right.ypos",			"1"			},
  { "player_1.right.frames",			"1"			},
  { "player_1.moving.down",			"RocksHeroes.png"	},
  { "player_1.moving.down.xpos",		"0"			},
  { "player_1.moving.down.ypos",		"0"			},
  { "player_1.moving.down.frames",		"4"			},
  { "player_1.moving.down.start_frame",		"1"			},
  { "player_1.moving.down.delay",		"4"			},
  { "player_1.moving.up",			"RocksHeroes.png"	},
  { "player_1.moving.up.xpos",			"4"			},
  { "player_1.moving.up.ypos",			"0"			},
  { "player_1.moving.up.frames",		"4"			},
  { "player_1.moving.up.start_frame",		"1"			},
  { "player_1.moving.up.delay",			"4"			},
  { "player_1.moving.left",			"RocksHeroes.png"	},
  { "player_1.moving.left.xpos",		"0"			},
  { "player_1.moving.left.ypos",		"1"			},
  { "player_1.moving.left.frames",		"4"			},
  { "player_1.moving.left.start_frame",		"1"			},
  { "player_1.moving.left.delay",		"4"			},
  { "player_1.moving.right",			"RocksHeroes.png"	},
  { "player_1.moving.right.xpos",		"4"			},
  { "player_1.moving.right.ypos",		"1"			},
  { "player_1.moving.right.frames",		"4"			},
  { "player_1.moving.right.start_frame",	"1"			},
  { "player_1.moving.right.delay",		"4"			},
  { "player_1.digging.down",			"RocksHeroes.png"	},
  { "player_1.digging.down.xpos",		"0"			},
  { "player_1.digging.down.ypos",		"0"			},
  { "player_1.digging.down.frames",		"4"			},
  { "player_1.digging.down.start_frame",	"1"			},
  { "player_1.digging.down.delay",		"4"			},
  { "player_1.digging.up",			"RocksHeroes.png"	},
  { "player_1.digging.up.xpos",			"4"			},
  { "player_1.digging.up.ypos",			"0"			},
  { "player_1.digging.up.frames",		"4"			},
  { "player_1.digging.up.start_frame",		"1"			},
  { "player_1.digging.up.delay",		"4"			},
  { "player_1.digging.left",			"RocksHeroes.png"	},
  { "player_1.digging.left.xpos",		"0"			},
  { "player_1.digging.left.ypos",		"1"			},
  { "player_1.digging.left.frames",		"4"			},
  { "player_1.digging.left.start_frame",	"1"			},
  { "player_1.digging.left.delay",		"4"			},
  { "player_1.digging.right",			"RocksHeroes.png"	},
  { "player_1.digging.right.xpos",		"4"			},
  { "player_1.digging.right.ypos",		"1"			},
  { "player_1.digging.right.frames",		"4"			},
  { "player_1.digging.right.start_frame",	"1"			},
  { "player_1.digging.right.delay",		"4"			},
  { "player_1.collecting.down",			"RocksHeroes.png"	},
  { "player_1.collecting.down.xpos",		"0"			},
  { "player_1.collecting.down.ypos",		"0"			},
  { "player_1.collecting.down.frames",		"4"			},
  { "player_1.collecting.down.start_frame",	"1"			},
  { "player_1.collecting.down.delay",		"4"			},
  { "player_1.collecting.up",			"RocksHeroes.png"	},
  { "player_1.collecting.up.xpos",		"4"			},
  { "player_1.collecting.up.ypos",		"0"			},
  { "player_1.collecting.up.frames",		"4"			},
  { "player_1.collecting.up.start_frame",	"1"			},
  { "player_1.collecting.up.delay",		"4"			},
  { "player_1.collecting.left",			"RocksHeroes.png"	},
  { "player_1.collecting.left.xpos",		"0"			},
  { "player_1.collecting.left.ypos",		"1"			},
  { "player_1.collecting.left.frames",		"4"			},
  { "player_1.collecting.left.start_frame",	"1"			},
  { "player_1.collecting.left.delay",		"4"			},
  { "player_1.collecting.right",		"RocksHeroes.png"	},
  { "player_1.collecting.right.xpos",		"4"			},
  { "player_1.collecting.right.ypos",		"1"			},
  { "player_1.collecting.right.frames",		"4"			},
  { "player_1.collecting.right.start_frame",	"1"			},
  { "player_1.collecting.right.delay",		"4"			},
  { "player_1.pushing.down",			"RocksHeroes.png"	},
  { "player_1.pushing.down.xpos",		"0"			},
  { "player_1.pushing.down.ypos",		"0"			},
  { "player_1.pushing.down.frames",		"4"			},
  { "player_1.pushing.down.delay",		"4"			},
  { "player_1.pushing.up",			"RocksHeroes.png"	},
  { "player_1.pushing.up.xpos",			"4"			},
  { "player_1.pushing.up.ypos",			"0"			},
  { "player_1.pushing.up.frames",		"4"			},
  { "player_1.pushing.up.delay",		"4"			},
  { "player_1.pushing.left",			"RocksHeroes.png"	},
  { "player_1.pushing.left.xpos",		"4"			},
  { "player_1.pushing.left.ypos",		"2"			},
  { "player_1.pushing.left.frames",		"4"			},
  { "player_1.pushing.left.delay",		"4"			},
  { "player_1.pushing.right",			"RocksHeroes.png"	},
  { "player_1.pushing.right.xpos",		"0"			},
  { "player_1.pushing.right.ypos",		"2"			},
  { "player_1.pushing.right.frames",		"4"			},
  { "player_1.pushing.right.delay",		"4"			},
  { "player_1.snapping.down",			"RocksHeroes.png"	},
  { "player_1.snapping.down.xpos",		"0"			},
  { "player_1.snapping.down.ypos",		"0"			},
  { "player_1.snapping.down.frames",		"1"			},
  { "player_1.snapping.up",			"RocksHeroes.png"	},
  { "player_1.snapping.up.xpos",		"4"			},
  { "player_1.snapping.up.ypos",		"0"			},
  { "player_1.snapping.up.frames",		"1"			},
  { "player_1.snapping.left",			"RocksHeroes.png"	},
  { "player_1.snapping.left.xpos",		"0"			},
  { "player_1.snapping.left.ypos",		"1"			},
  { "player_1.snapping.left.frames",		"1"			},
  { "player_1.snapping.right",			"RocksHeroes.png"	},
  { "player_1.snapping.right.xpos",		"4"			},
  { "player_1.snapping.right.ypos",		"1"			},
  { "player_1.snapping.right.frames",		"1"			},

  { "player_2",					"RocksHeroes.png"	},
  { "player_2.xpos",				"0"			},
  { "player_2.ypos",				"3"			},
  { "player_2.frames",				"1"			},
  { "player_2.down",				"RocksHeroes.png"	},
  { "player_2.down.xpos",			"0"			},
  { "player_2.down.ypos",			"3"			},
  { "player_2.down.frames",			"1"			},
  { "player_2.up",				"RocksHeroes.png"	},
  { "player_2.up.xpos",				"4"			},
  { "player_2.up.ypos",				"3"			},
  { "player_2.up.frames",			"1"			},
  { "player_2.left",				"RocksHeroes.png"	},
  { "player_2.left.xpos",			"0"			},
  { "player_2.left.ypos",			"4"			},
  { "player_2.left.frames",			"1"			},
  { "player_2.right",				"RocksHeroes.png"	},
  { "player_2.right.xpos",			"4"			},
  { "player_2.right.ypos",			"4"			},
  { "player_2.right.frames",			"1"			},
  { "player_2.moving.down",			"RocksHeroes.png"	},
  { "player_2.moving.down.xpos",		"0"			},
  { "player_2.moving.down.ypos",		"3"			},
  { "player_2.moving.down.frames",		"4"			},
  { "player_2.moving.down.start_frame",		"1"			},
  { "player_2.moving.down.delay",		"4"			},
  { "player_2.moving.up",			"RocksHeroes.png"	},
  { "player_2.moving.up.xpos",			"4"			},
  { "player_2.moving.up.ypos",			"3"			},
  { "player_2.moving.up.frames",		"4"			},
  { "player_2.moving.up.start_frame",		"1"			},
  { "player_2.moving.up.delay",			"4"			},
  { "player_2.moving.left",			"RocksHeroes.png"	},
  { "player_2.moving.left.xpos",		"0"			},
  { "player_2.moving.left.ypos",		"4"			},
  { "player_2.moving.left.frames",		"4"			},
  { "player_2.moving.left.start_frame",		"1"			},
  { "player_2.moving.left.delay",		"4"			},
  { "player_2.moving.right",			"RocksHeroes.png"	},
  { "player_2.moving.right.xpos",		"4"			},
  { "player_2.moving.right.ypos",		"4"			},
  { "player_2.moving.right.frames",		"4"			},
  { "player_2.moving.right.start_frame",	"1"			},
  { "player_2.moving.right.delay",		"4"			},
  { "player_2.digging.down",			"RocksHeroes.png"	},
  { "player_2.digging.down.xpos",		"0"			},
  { "player_2.digging.down.ypos",		"3"			},
  { "player_2.digging.down.frames",		"4"			},
  { "player_2.digging.down.start_frame",	"1"			},
  { "player_2.digging.down.delay",		"4"			},
  { "player_2.digging.up",			"RocksHeroes.png"	},
  { "player_2.digging.up.xpos",			"4"			},
  { "player_2.digging.up.ypos",			"3"			},
  { "player_2.digging.up.frames",		"4"			},
  { "player_2.digging.up.start_frame",		"1"			},
  { "player_2.digging.up.delay",		"4"			},
  { "player_2.digging.left",			"RocksHeroes.png"	},
  { "player_2.digging.left.xpos",		"0"			},
  { "player_2.digging.left.ypos",		"4"			},
  { "player_2.digging.left.frames",		"4"			},
  { "player_2.digging.left.start_frame",	"1"			},
  { "player_2.digging.left.delay",		"4"			},
  { "player_2.digging.right",			"RocksHeroes.png"	},
  { "player_2.digging.right.xpos",		"4"			},
  { "player_2.digging.right.ypos",		"4"			},
  { "player_2.digging.right.frames",		"4"			},
  { "player_2.digging.right.start_frame",	"1"			},
  { "player_2.digging.right.delay",		"4"			},
  { "player_2.collecting.down",			"RocksHeroes.png"	},
  { "player_2.collecting.down.xpos",		"0"			},
  { "player_2.collecting.down.ypos",		"3"			},
  { "player_2.collecting.down.frames",		"4"			},
  { "player_2.collecting.down.start_frame",	"1"			},
  { "player_2.collecting.down.delay",		"4"			},
  { "player_2.collecting.up",			"RocksHeroes.png"	},
  { "player_2.collecting.up.xpos",		"4"			},
  { "player_2.collecting.up.ypos",		"3"			},
  { "player_2.collecting.up.frames",		"4"			},
  { "player_2.collecting.up.start_frame",	"1"			},
  { "player_2.collecting.up.delay",		"4"			},
  { "player_2.collecting.left",			"RocksHeroes.png"	},
  { "player_2.collecting.left.xpos",		"0"			},
  { "player_2.collecting.left.ypos",		"4"			},
  { "player_2.collecting.left.frames",		"4"			},
  { "player_2.collecting.left.start_frame",	"1"			},
  { "player_2.collecting.left.delay",		"4"			},
  { "player_2.collecting.right",		"RocksHeroes.png"	},
  { "player_2.collecting.right.xpos",		"4"			},
  { "player_2.collecting.right.ypos",		"4"			},
  { "player_2.collecting.right.frames",		"4"			},
  { "player_2.collecting.right.start_frame",	"1"			},
  { "player_2.collecting.right.delay",		"4"			},
  { "player_2.pushing.down",			"RocksHeroes.png"	},
  { "player_2.pushing.down.xpos",		"0"			},
  { "player_2.pushing.down.ypos",		"3"			},
  { "player_2.pushing.down.frames",		"4"			},
  { "player_2.pushing.down.delay",		"4"			},
  { "player_2.pushing.up",			"RocksHeroes.png"	},
  { "player_2.pushing.up.xpos",			"4"			},
  { "player_2.pushing.up.ypos",			"3"			},
  { "player_2.pushing.up.frames",		"4"			},
  { "player_2.pushing.up.delay",		"4"			},
  { "player_2.pushing.left",			"RocksHeroes.png"	},
  { "player_2.pushing.left.xpos",		"4"			},
  { "player_2.pushing.left.ypos",		"5"			},
  { "player_2.pushing.left.frames",		"4"			},
  { "player_2.pushing.left.delay",		"4"			},
  { "player_2.pushing.right",			"RocksHeroes.png"	},
  { "player_2.pushing.right.xpos",		"0"			},
  { "player_2.pushing.right.ypos",		"5"			},
  { "player_2.pushing.right.frames",		"4"			},
  { "player_2.pushing.right.delay",		"4"			},
  { "player_2.snapping.down",			"RocksHeroes.png"	},
  { "player_2.snapping.down.xpos",		"0"			},
  { "player_2.snapping.down.ypos",		"3"			},
  { "player_2.snapping.down.frames",		"1"			},
  { "player_2.snapping.up",			"RocksHeroes.png"	},
  { "player_2.snapping.up.xpos",		"4"			},
  { "player_2.snapping.up.ypos",		"3"			},
  { "player_2.snapping.up.frames",		"1"			},
  { "player_2.snapping.left",			"RocksHeroes.png"	},
  { "player_2.snapping.left.xpos",		"0"			},
  { "player_2.snapping.left.ypos",		"4"			},
  { "player_2.snapping.left.frames",		"1"			},
  { "player_2.snapping.right",			"RocksHeroes.png"	},
  { "player_2.snapping.right.xpos",		"4"			},
  { "player_2.snapping.right.ypos",		"4"			},
  { "player_2.snapping.right.frames",		"1"			},

  { "player_3",					"RocksHeroes.png"	},
  { "player_3.xpos",				"0"			},
  { "player_3.ypos",				"6"			},
  { "player_3.frames",				"1"			},
  { "player_3.down",				"RocksHeroes.png"	},
  { "player_3.down.xpos",			"0"			},
  { "player_3.down.ypos",			"6"			},
  { "player_3.down.frames",			"1"			},
  { "player_3.up",				"RocksHeroes.png"	},
  { "player_3.up.xpos",				"4"			},
  { "player_3.up.ypos",				"6"			},
  { "player_3.up.frames",			"1"			},
  { "player_3.left",				"RocksHeroes.png"	},
  { "player_3.left.xpos",			"0"			},
  { "player_3.left.ypos",			"7"			},
  { "player_3.left.frames",			"1"			},
  { "player_3.right",				"RocksHeroes.png"	},
  { "player_3.right.xpos",			"4"			},
  { "player_3.right.ypos",			"7"			},
  { "player_3.right.frames",			"1"			},
  { "player_3.moving.down",			"RocksHeroes.png"	},
  { "player_3.moving.down.xpos",		"0"			},
  { "player_3.moving.down.ypos",		"6"			},
  { "player_3.moving.down.frames",		"4"			},
  { "player_3.moving.down.start_frame",		"1"			},
  { "player_3.moving.down.delay",		"4"			},
  { "player_3.moving.up",			"RocksHeroes.png"	},
  { "player_3.moving.up.xpos",			"4"			},
  { "player_3.moving.up.ypos",			"6"			},
  { "player_3.moving.up.frames",		"4"			},
  { "player_3.moving.up.start_frame",		"1"			},
  { "player_3.moving.up.delay",			"4"			},
  { "player_3.moving.left",			"RocksHeroes.png"	},
  { "player_3.moving.left.xpos",		"0"			},
  { "player_3.moving.left.ypos",		"7"			},
  { "player_3.moving.left.frames",		"4"			},
  { "player_3.moving.left.start_frame",		"1"			},
  { "player_3.moving.left.delay",		"4"			},
  { "player_3.moving.right",			"RocksHeroes.png"	},
  { "player_3.moving.right.xpos",		"4"			},
  { "player_3.moving.right.ypos",		"7"			},
  { "player_3.moving.right.frames",		"4"			},
  { "player_3.moving.right.start_frame",	"1"			},
  { "player_3.moving.right.delay",		"4"			},
  { "player_3.digging.down",			"RocksHeroes.png"	},
  { "player_3.digging.down.xpos",		"0"			},
  { "player_3.digging.down.ypos",		"6"			},
  { "player_3.digging.down.frames",		"4"			},
  { "player_3.digging.down.start_frame",	"1"			},
  { "player_3.digging.down.delay",		"4"			},
  { "player_3.digging.up",			"RocksHeroes.png"	},
  { "player_3.digging.up.xpos",			"4"			},
  { "player_3.digging.up.ypos",			"6"			},
  { "player_3.digging.up.frames",		"4"			},
  { "player_3.digging.up.start_frame",		"1"			},
  { "player_3.digging.up.delay",		"4"			},
  { "player_3.digging.left",			"RocksHeroes.png"	},
  { "player_3.digging.left.xpos",		"0"			},
  { "player_3.digging.left.ypos",		"7"			},
  { "player_3.digging.left.frames",		"4"			},
  { "player_3.digging.left.start_frame",	"1"			},
  { "player_3.digging.left.delay",		"4"			},
  { "player_3.digging.right",			"RocksHeroes.png"	},
  { "player_3.digging.right.xpos",		"4"			},
  { "player_3.digging.right.ypos",		"7"			},
  { "player_3.digging.right.frames",		"4"			},
  { "player_3.digging.right.start_frame",	"1"			},
  { "player_3.digging.right.delay",		"4"			},
  { "player_3.collecting.down",			"RocksHeroes.png"	},
  { "player_3.collecting.down.xpos",		"0"			},
  { "player_3.collecting.down.ypos",		"6"			},
  { "player_3.collecting.down.frames",		"4"			},
  { "player_3.collecting.down.start_frame",	"1"			},
  { "player_3.collecting.down.delay",		"4"			},
  { "player_3.collecting.up",			"RocksHeroes.png"	},
  { "player_3.collecting.up.xpos",		"4"			},
  { "player_3.collecting.up.ypos",		"6"			},
  { "player_3.collecting.up.frames",		"4"			},
  { "player_3.collecting.up.start_frame",	"1"			},
  { "player_3.collecting.up.delay",		"4"			},
  { "player_3.collecting.left",			"RocksHeroes.png"	},
  { "player_3.collecting.left.xpos",		"0"			},
  { "player_3.collecting.left.ypos",		"7"			},
  { "player_3.collecting.left.frames",		"4"			},
  { "player_3.collecting.left.start_frame",	"1"			},
  { "player_3.collecting.left.delay",		"4"			},
  { "player_3.collecting.right",		"RocksHeroes.png"	},
  { "player_3.collecting.right.xpos",		"4"			},
  { "player_3.collecting.right.ypos",		"7"			},
  { "player_3.collecting.right.frames",		"4"			},
  { "player_3.collecting.right.start_frame",	"1"			},
  { "player_3.collecting.right.delay",		"4"			},
  { "player_3.pushing.down",			"RocksHeroes.png"	},
  { "player_3.pushing.down.xpos",		"0"			},
  { "player_3.pushing.down.ypos",		"6"			},
  { "player_3.pushing.down.frames",		"4"			},
  { "player_3.pushing.down.delay",		"4"			},
  { "player_3.pushing.up",			"RocksHeroes.png"	},
  { "player_3.pushing.up.xpos",			"4"			},
  { "player_3.pushing.up.ypos",			"6"			},
  { "player_3.pushing.up.frames",		"4"			},
  { "player_3.pushing.up.delay",		"4"			},
  { "player_3.pushing.left",			"RocksHeroes.png"	},
  { "player_3.pushing.left.xpos",		"4"			},
  { "player_3.pushing.left.ypos",		"8"			},
  { "player_3.pushing.left.frames",		"4"			},
  { "player_3.pushing.left.delay",		"4"			},
  { "player_3.pushing.right",			"RocksHeroes.png"	},
  { "player_3.pushing.right.xpos",		"0"			},
  { "player_3.pushing.right.ypos",		"8"			},
  { "player_3.pushing.right.frames",		"4"			},
  { "player_3.pushing.right.delay",		"4"			},
  { "player_3.snapping.down",			"RocksHeroes.png"	},
  { "player_3.snapping.down.xpos",		"0"			},
  { "player_3.snapping.down.ypos",		"6"			},
  { "player_3.snapping.down.frames",		"1"			},
  { "player_3.snapping.up",			"RocksHeroes.png"	},
  { "player_3.snapping.up.xpos",		"4"			},
  { "player_3.snapping.up.ypos",		"6"			},
  { "player_3.snapping.up.frames",		"1"			},
  { "player_3.snapping.left",			"RocksHeroes.png"	},
  { "player_3.snapping.left.xpos",		"0"			},
  { "player_3.snapping.left.ypos",		"7"			},
  { "player_3.snapping.left.frames",		"1"			},
  { "player_3.snapping.right",			"RocksHeroes.png"	},
  { "player_3.snapping.right.xpos",		"4"			},
  { "player_3.snapping.right.ypos",		"7"			},
  { "player_3.snapping.right.frames",		"1"			},

  { "player_4",					"RocksHeroes.png"	},
  { "player_4.xpos",				"0"			},
  { "player_4.ypos",				"9"			},
  { "player_4.frames",				"1"			},
  { "player_4.down",				"RocksHeroes.png"	},
  { "player_4.down.xpos",			"0"			},
  { "player_4.down.ypos",			"9"			},
  { "player_4.down.frames",			"1"			},
  { "player_4.up",				"RocksHeroes.png"	},
  { "player_4.up.xpos",				"4"			},
  { "player_4.up.ypos",				"9"			},
  { "player_4.up.frames",			"1"			},
  { "player_4.left",				"RocksHeroes.png"	},
  { "player_4.left.xpos",			"0"			},
  { "player_4.left.ypos",			"10"			},
  { "player_4.left.frames",			"1"			},
  { "player_4.right",				"RocksHeroes.png"	},
  { "player_4.right.xpos",			"4"			},
  { "player_4.right.ypos",			"10"			},
  { "player_4.right.frames",			"1"			},
  { "player_4.moving.down",			"RocksHeroes.png"	},
  { "player_4.moving.down.xpos",		"0"			},
  { "player_4.moving.down.ypos",		"9"			},
  { "player_4.moving.down.frames",		"4"			},
  { "player_4.moving.down.start_frame",		"1"			},
  { "player_4.moving.down.delay",		"4"			},
  { "player_4.moving.up",			"RocksHeroes.png"	},
  { "player_4.moving.up.xpos",			"4"			},
  { "player_4.moving.up.ypos",			"9"			},
  { "player_4.moving.up.frames",		"4"			},
  { "player_4.moving.up.start_frame",		"1"			},
  { "player_4.moving.up.delay",			"4"			},
  { "player_4.moving.left",			"RocksHeroes.png"	},
  { "player_4.moving.left.xpos",		"0"			},
  { "player_4.moving.left.ypos",		"10"			},
  { "player_4.moving.left.frames",		"4"			},
  { "player_4.moving.left.start_frame",		"1"			},
  { "player_4.moving.left.delay",		"4"			},
  { "player_4.moving.right",			"RocksHeroes.png"	},
  { "player_4.moving.right.xpos",		"4"			},
  { "player_4.moving.right.ypos",		"10"			},
  { "player_4.moving.right.frames",		"4"			},
  { "player_4.moving.right.start_frame",	"1"			},
  { "player_4.moving.right.delay",		"4"			},
  { "player_4.digging.down",			"RocksHeroes.png"	},
  { "player_4.digging.down.xpos",		"0"			},
  { "player_4.digging.down.ypos",		"9"			},
  { "player_4.digging.down.frames",		"4"			},
  { "player_4.digging.down.start_frame",	"1"			},
  { "player_4.digging.down.delay",		"4"			},
  { "player_4.digging.up",			"RocksHeroes.png"	},
  { "player_4.digging.up.xpos",			"4"			},
  { "player_4.digging.up.ypos",			"9"			},
  { "player_4.digging.up.frames",		"4"			},
  { "player_4.digging.up.start_frame",		"1"			},
  { "player_4.digging.up.delay",		"4"			},
  { "player_4.digging.left",			"RocksHeroes.png"	},
  { "player_4.digging.left.xpos",		"0"			},
  { "player_4.digging.left.ypos",		"10"			},
  { "player_4.digging.left.frames",		"4"			},
  { "player_4.digging.left.start_frame",	"1"			},
  { "player_4.digging.left.delay",		"4"			},
  { "player_4.digging.right",			"RocksHeroes.png"	},
  { "player_4.digging.right.xpos",		"4"			},
  { "player_4.digging.right.ypos",		"10"			},
  { "player_4.digging.right.frames",		"4"			},
  { "player_4.digging.right.start_frame",	"1"			},
  { "player_4.digging.right.delay",		"4"			},
  { "player_4.collecting.down",			"RocksHeroes.png"	},
  { "player_4.collecting.down.xpos",		"0"			},
  { "player_4.collecting.down.ypos",		"9"			},
  { "player_4.collecting.down.frames",		"4"			},
  { "player_4.collecting.down.start_frame",	"1"			},
  { "player_4.collecting.down.delay",		"4"			},
  { "player_4.collecting.up",			"RocksHeroes.png"	},
  { "player_4.collecting.up.xpos",		"4"			},
  { "player_4.collecting.up.ypos",		"9"			},
  { "player_4.collecting.up.frames",		"4"			},
  { "player_4.collecting.up.start_frame",	"1"			},
  { "player_4.collecting.up.delay",		"4"			},
  { "player_4.collecting.left",			"RocksHeroes.png"	},
  { "player_4.collecting.left.xpos",		"0"			},
  { "player_4.collecting.left.ypos",		"10"			},
  { "player_4.collecting.left.frames",		"4"			},
  { "player_4.collecting.left.start_frame",	"1"			},
  { "player_4.collecting.left.delay",		"4"			},
  { "player_4.collecting.right",		"RocksHeroes.png"	},
  { "player_4.collecting.right.xpos",		"4"			},
  { "player_4.collecting.right.ypos",		"10"			},
  { "player_4.collecting.right.frames",		"4"			},
  { "player_4.collecting.right.start_frame",	"1"			},
  { "player_4.collecting.right.delay",		"4"			},
  { "player_4.pushing.down",			"RocksHeroes.png"	},
  { "player_4.pushing.down.xpos",		"0"			},
  { "player_4.pushing.down.ypos",		"9"			},
  { "player_4.pushing.down.frames",		"4"			},
  { "player_4.pushing.down.delay",		"4"			},
  { "player_4.pushing.up",			"RocksHeroes.png"	},
  { "player_4.pushing.up.xpos",			"4"			},
  { "player_4.pushing.up.ypos",			"9"			},
  { "player_4.pushing.up.frames",		"4"			},
  { "player_4.pushing.up.delay",		"4"			},
  { "player_4.pushing.left",			"RocksHeroes.png"	},
  { "player_4.pushing.left.xpos",		"4"			},
  { "player_4.pushing.left.ypos",		"11"			},
  { "player_4.pushing.left.frames",		"4"			},
  { "player_4.pushing.left.delay",		"4"			},
  { "player_4.pushing.right",			"RocksHeroes.png"	},
  { "player_4.pushing.right.xpos",		"0"			},
  { "player_4.pushing.right.ypos",		"11"			},
  { "player_4.pushing.right.frames",		"4"			},
  { "player_4.pushing.right.delay",		"4"			},
  { "player_4.snapping.down",			"RocksHeroes.png"	},
  { "player_4.snapping.down.xpos",		"0"			},
  { "player_4.snapping.down.ypos",		"9"			},
  { "player_4.snapping.down.frames",		"1"			},
  { "player_4.snapping.up",			"RocksHeroes.png"	},
  { "player_4.snapping.up.xpos",		"4"			},
  { "player_4.snapping.up.ypos",		"9"			},
  { "player_4.snapping.up.frames",		"1"			},
  { "player_4.snapping.left",			"RocksHeroes.png"	},
  { "player_4.snapping.left.xpos",		"0"			},
  { "player_4.snapping.left.ypos",		"10"			},
  { "player_4.snapping.left.frames",		"1"			},
  { "player_4.snapping.right",			"RocksHeroes.png"	},
  { "player_4.snapping.right.xpos",		"4"			},
  { "player_4.snapping.right.ypos",		"10"			},
  { "player_4.snapping.right.frames",		"1"			},

  { "[default].exploding",			"RocksElements.png"	},
  { "[default].exploding.xpos",			"0"			},
  { "[default].exploding.ypos",			"4"			},
  { "[default].exploding.frames",		"8"			},
  { "[default].exploding.delay",		"2"			},
  { "[default].exploding.anim_mode",		"linear"		},

  { "twinkle_blue",				"RocksHeroes.png"	},
  { "twinkle_blue.xpos",			"9"			},
  { "twinkle_blue.ypos",			"11"			},
  { "twinkle_blue.frames",			"3"			},
  { "twinkle_blue.delay",			"2"			},
  { "twinkle_blue.anim_mode",			"pingpong"		},
  { "twinkle_blue.global_sync",			"false"			},
  { "twinkle_white",				"RocksHeroes.png"	},
  { "twinkle_white.xpos",			"13"			},
  { "twinkle_white.ypos",			"11"			},
  { "twinkle_white.frames",			"3"			},
  { "twinkle_white.delay",			"2"			},
  { "twinkle_white.anim_mode",			"pingpong"		},
  { "twinkle_white.global_sync",		"false"			},

  { "steelwall_topleft",			"RocksElements.png"	},
  { "steelwall_topleft.xpos",			"4"			},
  { "steelwall_topleft.ypos",			"0"			},
  { "steelwall_topleft.frames",			"1"			},
  { "steelwall_topright",			"RocksElements.png"	},
  { "steelwall_topright.xpos",			"4"			},
  { "steelwall_topright.ypos",			"0"			},
  { "steelwall_topright.frames",		"1"			},
  { "steelwall_bottomleft",			"RocksElements.png"	},
  { "steelwall_bottomleft.xpos",		"4"			},
  { "steelwall_bottomleft.ypos",		"0"			},
  { "steelwall_bottomleft.frames",		"1"			},
  { "steelwall_bottomright",			"RocksElements.png"	},
  { "steelwall_bottomright.xpos",		"4"			},
  { "steelwall_bottomright.ypos",		"0"			},
  { "steelwall_bottomright.frames",		"1"			},
  { "steelwall_horizontal",			"RocksElements.png"	},
  { "steelwall_horizontal.xpos",		"4"			},
  { "steelwall_horizontal.ypos",		"0"			},
  { "steelwall_horizontal.frames",		"1"			},
  { "steelwall_vertical",			"RocksElements.png"	},
  { "steelwall_vertical.xpos",			"4"			},
  { "steelwall_vertical.ypos",			"0"			},
  { "steelwall_vertical.frames",		"1"			},

  { "steelwall_topleft.EDITOR",			"RocksElements.png"	},
  { "steelwall_topleft.EDITOR.xpos",		"0"			},
  { "steelwall_topleft.EDITOR.ypos",		"13"			},
  { "steelwall_topright.EDITOR",		"RocksElements.png"	},
  { "steelwall_topright.EDITOR.xpos",		"1"			},
  { "steelwall_topright.EDITOR.ypos",		"13"			},
  { "steelwall_bottomleft.EDITOR",		"RocksElements.png"	},
  { "steelwall_bottomleft.EDITOR.xpos",		"2"			},
  { "steelwall_bottomleft.EDITOR.ypos",		"13"			},
  { "steelwall_bottomright.EDITOR",		"RocksElements.png"	},
  { "steelwall_bottomright.EDITOR.xpos",	"3"			},
  { "steelwall_bottomright.EDITOR.ypos",	"13"			},
  { "steelwall_horizontal.EDITOR",		"RocksElements.png"	},
  { "steelwall_horizontal.EDITOR.xpos",		"4"			},
  { "steelwall_horizontal.EDITOR.ypos",		"13"			},
  { "steelwall_vertical.EDITOR",		"RocksElements.png"	},
  { "steelwall_vertical.EDITOR.xpos",		"5"			},
  { "steelwall_vertical.EDITOR.ypos",		"13"			},

  { "invisible_steelwall_topleft",		"RocksSP.png"		},
  { "invisible_steelwall_topleft.xpos",		"0"			},
  { "invisible_steelwall_topleft.ypos",		"0"			},
  { "invisible_steelwall_topleft.frames",	"1"			},
  { "invisible_steelwall_topright",		"RocksSP.png"		},
  { "invisible_steelwall_topright.xpos",	"0"			},
  { "invisible_steelwall_topright.ypos",	"0"			},
  { "invisible_steelwall_topright.frames",	"1"			},
  { "invisible_steelwall_bottomleft",		"RocksSP.png"		},
  { "invisible_steelwall_bottomleft.xpos",	"0"			},
  { "invisible_steelwall_bottomleft.ypos",	"0"			},
  { "invisible_steelwall_bottomleft.frames",	"1"			},
  { "invisible_steelwall_bottomright",		"RocksSP.png"		},
  { "invisible_steelwall_bottomright.xpos",	"0"			},
  { "invisible_steelwall_bottomright.ypos",	"0"			},
  { "invisible_steelwall_bottomright.frames",	"1"			},
  { "invisible_steelwall_horizontal",		"RocksSP.png"		},
  { "invisible_steelwall_horizontal.xpos",	"0"			},
  { "invisible_steelwall_horizontal.ypos",	"0"			},
  { "invisible_steelwall_horizontal.frames",	"1"			},
  { "invisible_steelwall_vertical",		"RocksSP.png"		},
  { "invisible_steelwall_vertical.xpos",	"0"			},
  { "invisible_steelwall_vertical.ypos",	"0"			},
  { "invisible_steelwall_vertical.frames",	"1"			},

  { "invisible_steelwall_topleft.EDITOR",	"RocksElements.png"	},
  { "invisible_steelwall_topleft.EDITOR.xpos",	"6"			},
  { "invisible_steelwall_topleft.EDITOR.ypos",	"13"			},
  { "invisible_steelwall_topright.EDITOR",	"RocksElements.png"	},
  { "invisible_steelwall_topright.EDITOR.xpos",	"7"			},
  { "invisible_steelwall_topright.EDITOR.ypos",	"13"			},
  { "invisible_steelwall_bottomleft.EDITOR",	"RocksElements.png"	},
  { "invisible_steelwall_bottomleft.EDITOR.xpos","8"			},
  { "invisible_steelwall_bottomleft.EDITOR.ypos","13"			},
  { "invisible_steelwall_bottomright.EDITOR",	"RocksElements.png"	},
  { "invisible_steelwall_bottomright.EDITOR.xpos","9"			},
  { "invisible_steelwall_bottomright.EDITOR.ypos","13"			},
  { "invisible_steelwall_horizontal.EDITOR",	"RocksElements.png"	},
  { "invisible_steelwall_horizontal.EDITOR.xpos","10"			},
  { "invisible_steelwall_horizontal.EDITOR.ypos","13"			},
  { "invisible_steelwall_vertical.EDITOR",	"RocksElements.png"	},
  { "invisible_steelwall_vertical.EDITOR.xpos",	"11"			},
  { "invisible_steelwall_vertical.EDITOR.ypos",	"13"			},

  { "arrow_left",				"RocksDC.png"		},
  { "arrow_left.xpos",				"8"			},
  { "arrow_left.ypos",				"8"			},
  { "arrow_left.frames",			"1"			},
  { "arrow_right",				"RocksDC.png"		},
  { "arrow_right.xpos",				"9"			},
  { "arrow_right.ypos",				"8"			},
  { "arrow_right.frames",			"1"			},
  { "arrow_up",					"RocksDC.png"		},
  { "arrow_up.xpos",				"10"			},
  { "arrow_up.ypos",				"8"			},
  { "arrow_up.frames",				"1"			},
  { "arrow_down",				"RocksDC.png"		},
  { "arrow_down.xpos",				"11"			},
  { "arrow_down.ypos",				"8"			},
  { "arrow_down.frames",			"1"			},

  { "unknown",					"RocksFontEM.png"	},
  { "unknown.xpos",				"15"			},
  { "unknown.ypos",				"1"			},
  { "unknown.frames",				"1"			},

  { "trigger_element",				"RocksDC.png"		},
  { "trigger_element.xpos",			"15"			},
  { "trigger_element.ypos",			"14"			},
  { "trigger_element.frames",			"1"			},

  { "trigger_player",				"RocksDC.png"		},
  { "trigger_player.xpos",			"15"			},
  { "trigger_player.ypos",			"13"			},
  { "trigger_player.frames",			"1"			},

  { "trigger_ce_value",				"RocksDC.png"		},
  { "trigger_ce_value.xpos",			"15"			},
  { "trigger_ce_value.ypos",			"11"			},
  { "trigger_ce_value.frames",			"1"			},

  { "trigger_ce_score",				"RocksDC.png"		},
  { "trigger_ce_score.xpos",			"15"			},
  { "trigger_ce_score.ypos",			"12"			},
  { "trigger_ce_score.frames",			"1"			},

  { "current_ce_value",				"RocksDC.png"		},
  { "current_ce_value.xpos",			"14"			},
  { "current_ce_value.ypos",			"11"			},
  { "current_ce_value.frames",			"1"			},

  { "current_ce_score",				"RocksDC.png"		},
  { "current_ce_score.xpos",			"14"			},
  { "current_ce_score.ypos",			"12"			},
  { "current_ce_score.frames",			"1"			},

  { "prev_ce_1",				"RocksMore.png"		},
  { "prev_ce_1.xpos",				"0"			},
  { "prev_ce_1.ypos",				"7"			},
  { "prev_ce_1.frames",				"1"			},

  { "prev_ce_2",				"RocksMore.png"		},
  { "prev_ce_2.xpos",				"1"			},
  { "prev_ce_2.ypos",				"7"			},
  { "prev_ce_2.frames",				"1"			},

  { "prev_ce_3",				"RocksMore.png"		},
  { "prev_ce_3.xpos",				"2"			},
  { "prev_ce_3.ypos",				"7"			},
  { "prev_ce_3.frames",				"1"			},

  { "prev_ce_4",				"RocksMore.png"		},
  { "prev_ce_4.xpos",				"3"			},
  { "prev_ce_4.ypos",				"7"			},
  { "prev_ce_4.frames",				"1"			},

  { "prev_ce_5",				"RocksMore.png"		},
  { "prev_ce_5.xpos",				"4"			},
  { "prev_ce_5.ypos",				"7"			},
  { "prev_ce_5.frames",				"1"			},

  { "prev_ce_6",				"RocksMore.png"		},
  { "prev_ce_6.xpos",				"5"			},
  { "prev_ce_6.ypos",				"7"			},
  { "prev_ce_6.frames",				"1"			},

  { "prev_ce_7",				"RocksMore.png"		},
  { "prev_ce_7.xpos",				"6"			},
  { "prev_ce_7.ypos",				"7"			},
  { "prev_ce_7.frames",				"1"			},

  { "prev_ce_8",				"RocksMore.png"		},
  { "prev_ce_8.xpos",				"7"			},
  { "prev_ce_8.ypos",				"7"			},
  { "prev_ce_8.frames",				"1"			},

  { "next_ce_1",				"RocksMore.png"		},
  { "next_ce_1.xpos",				"0"			},
  { "next_ce_1.ypos",				"8"			},
  { "next_ce_1.frames",				"1"			},

  { "next_ce_2",				"RocksMore.png"		},
  { "next_ce_2.xpos",				"1"			},
  { "next_ce_2.ypos",				"8"			},
  { "next_ce_2.frames",				"1"			},

  { "next_ce_3",				"RocksMore.png"		},
  { "next_ce_3.xpos",				"2"			},
  { "next_ce_3.ypos",				"8"			},
  { "next_ce_3.frames",				"1"			},

  { "next_ce_4",				"RocksMore.png"		},
  { "next_ce_4.xpos",				"3"			},
  { "next_ce_4.ypos",				"8"			},
  { "next_ce_4.frames",				"1"			},

  { "next_ce_5",				"RocksMore.png"		},
  { "next_ce_5.xpos",				"4"			},
  { "next_ce_5.ypos",				"8"			},
  { "next_ce_5.frames",				"1"			},

  { "next_ce_6",				"RocksMore.png"		},
  { "next_ce_6.xpos",				"5"			},
  { "next_ce_6.ypos",				"8"			},
  { "next_ce_6.frames",				"1"			},

  { "next_ce_7",				"RocksMore.png"		},
  { "next_ce_7.xpos",				"6"			},
  { "next_ce_7.ypos",				"8"			},
  { "next_ce_7.frames",				"1"			},

  { "next_ce_8",				"RocksMore.png"		},
  { "next_ce_8.xpos",				"7"			},
  { "next_ce_8.ypos",				"8"			},
  { "next_ce_8.frames",				"1"			},

  { "self",					"RocksMore.png"		},
  { "self.xpos",				"8"			},
  { "self.ypos",				"7"			},
  { "self.frames",				"1"			},

  { "any_element",				"RocksMore.png"		},
  { "any_element.xpos",				"9"			},
  { "any_element.ypos",				"7"			},
  { "any_element.frames",			"1"			},

  { "emc_key_5",				"RocksEMC.png"		},
  { "emc_key_5.xpos",				"0"			},
  { "emc_key_5.ypos",				"5"			},
  { "emc_key_5.frames",				"1"			},
  { "emc_key_6",				"RocksEMC.png"		},
  { "emc_key_6.xpos",				"1"			},
  { "emc_key_6.ypos",				"5"			},
  { "emc_key_6.frames",				"1"			},
  { "emc_key_7",				"RocksEMC.png"		},
  { "emc_key_7.xpos",				"2"			},
  { "emc_key_7.ypos",				"5"			},
  { "emc_key_7.frames",				"1"			},
  { "emc_key_8",				"RocksEMC.png"		},
  { "emc_key_8.xpos",				"3"			},
  { "emc_key_8.ypos",				"5"			},
  { "emc_key_8.frames",				"1"			},

  { "emc_gate_5",				"RocksEMC.png"		},
  { "emc_gate_5.xpos",				"0"			},
  { "emc_gate_5.ypos",				"6"			},
  { "emc_gate_5.frames",			"1"			},
  { "emc_gate_6",				"RocksEMC.png"		},
  { "emc_gate_6.xpos",				"1"			},
  { "emc_gate_6.ypos",				"6"			},
  { "emc_gate_6.frames",			"1"			},
  { "emc_gate_7",				"RocksEMC.png"		},
  { "emc_gate_7.xpos",				"2"			},
  { "emc_gate_7.ypos",				"6"			},
  { "emc_gate_7.frames",			"1"			},
  { "emc_gate_8",				"RocksEMC.png"		},
  { "emc_gate_8.xpos",				"3"			},
  { "emc_gate_8.ypos",				"6"			},
  { "emc_gate_8.frames",			"1"			},
  { "emc_gate_5_gray",				"RocksEMC.png"		},
  { "emc_gate_5_gray.xpos",			"4"			},
  { "emc_gate_5_gray.ypos",			"7"			},
  { "emc_gate_5_gray.frames",			"1"			},
  { "emc_gate_5_gray.EDITOR",			"RocksEMC.png"		},
  { "emc_gate_5_gray.EDITOR.xpos",		"0"			},
  { "emc_gate_5_gray.EDITOR.ypos",		"7"			},
  { "emc_gate_5_gray.active",			"RocksEMC.png"		},
  { "emc_gate_5_gray.active.xpos",		"0"			},
  { "emc_gate_5_gray.active.ypos",		"6"			},
  { "emc_gate_5_gray.active.frames",		"1"			},
  { "emc_gate_6_gray",				"RocksEMC.png"		},
  { "emc_gate_6_gray.xpos",			"4"			},
  { "emc_gate_6_gray.ypos",			"7"			},
  { "emc_gate_6_gray.frames",			"1"			},
  { "emc_gate_6_gray.EDITOR",			"RocksEMC.png"		},
  { "emc_gate_6_gray.EDITOR.xpos",		"1"			},
  { "emc_gate_6_gray.EDITOR.ypos",		"7"			},
  { "emc_gate_6_gray.active",			"RocksEMC.png"		},
  { "emc_gate_6_gray.active.xpos",		"1"			},
  { "emc_gate_6_gray.active.ypos",		"6"			},
  { "emc_gate_6_gray.active.frames",		"1"			},
  { "emc_gate_7_gray",				"RocksEMC.png"		},
  { "emc_gate_7_gray.xpos",			"4"			},
  { "emc_gate_7_gray.ypos",			"7"			},
  { "emc_gate_7_gray.frames",			"1"			},
  { "emc_gate_7_gray.EDITOR",			"RocksEMC.png"		},
  { "emc_gate_7_gray.EDITOR.xpos",		"2"			},
  { "emc_gate_7_gray.EDITOR.ypos",		"7"			},
  { "emc_gate_7_gray.active",			"RocksEMC.png"		},
  { "emc_gate_7_gray.active.xpos",		"2"			},
  { "emc_gate_7_gray.active.ypos",		"6"			},
  { "emc_gate_7_gray.active.frames",		"1"			},
  { "emc_gate_8_gray",				"RocksEMC.png"		},
  { "emc_gate_8_gray.xpos",			"4"			},
  { "emc_gate_8_gray.ypos",			"7"			},
  { "emc_gate_8_gray.frames",			"1"			},
  { "emc_gate_8_gray.EDITOR",			"RocksEMC.png"		},
  { "emc_gate_8_gray.EDITOR.xpos",		"3"			},
  { "emc_gate_8_gray.EDITOR.ypos",		"7"			},
  { "emc_gate_8_gray.active",			"RocksEMC.png"		},
  { "emc_gate_8_gray.active.xpos",		"3"			},
  { "emc_gate_8_gray.active.ypos",		"6"			},
  { "emc_gate_8_gray.active.frames",		"1"			},

  { "emc_android",				"RocksEMC.png"		},
  { "emc_android.xpos",				"0"			},
  { "emc_android.ypos",				"8"			},
  { "emc_android.frames",			"8"			},
  { "emc_android.delay",			"2"			},

  { "emc_android.shrinking.upleft",		"RocksEMC.png"		},
  { "emc_android.shrinking.upleft.xpos",	"1"			},
  { "emc_android.shrinking.upleft.ypos",	"11"			},
  { "emc_android.shrinking.upleft.frames",	"8"			},
  { "emc_android.shrinking.upleft.anim_mode",	"linear"		},

  { "emc_android.growing.downright",		"RocksEMC.png"		},
  { "emc_android.growing.downright.xpos",	"0"			},
  { "emc_android.growing.downright.ypos",	"11"			},
  { "emc_android.growing.downright.frames",	"8"			},
  { "emc_android.growing.downright.anim_mode",	"linear,reverse"	},

  { "emc_android.shrinking.downleft",		"RocksEMC.png"		},
  { "emc_android.shrinking.downleft.xpos",	"1"			},
  { "emc_android.shrinking.downleft.ypos",	"12"			},
  { "emc_android.shrinking.downleft.frames",	"8"			},
  { "emc_android.shrinking.downleft.anim_mode",	"linear"		},

  { "emc_android.growing.upright",		"RocksEMC.png"		},
  { "emc_android.growing.upright.xpos",		"0"			},
  { "emc_android.growing.upright.ypos",		"12"			},
  { "emc_android.growing.upright.frames",	"8"			},
  { "emc_android.growing.upright.anim_mode",	"linear,reverse"	},

  { "emc_android.shrinking.upright",		"RocksEMC.png"		},
  { "emc_android.shrinking.upright.xpos",	"1"			},
  { "emc_android.shrinking.upright.ypos",	"13"			},
  { "emc_android.shrinking.upright.frames",	"8"			},
  { "emc_android.shrinking.upright.anim_mode",	"linear"		},

  { "emc_android.growing.downleft",		"RocksEMC.png"		},
  { "emc_android.growing.downleft.xpos",	"0"			},
  { "emc_android.growing.downleft.ypos",	"13"			},
  { "emc_android.growing.downleft.frames",	"8"			},
  { "emc_android.growing.downleft.anim_mode",	"linear,reverse"	},

  { "emc_android.shrinking.downright",		"RocksEMC.png"		},
  { "emc_android.shrinking.downright.xpos",	"1"			},
  { "emc_android.shrinking.downright.ypos",	"14"			},
  { "emc_android.shrinking.downright.frames",	"8"			},
  { "emc_android.shrinking.downright.anim_mode","linear"		},

  { "emc_android.growing.upleft",		"RocksEMC.png"		},
  { "emc_android.growing.upleft.xpos",		"0"			},
  { "emc_android.growing.upleft.ypos",		"14"			},
  { "emc_android.growing.upleft.frames",	"8"			},
  { "emc_android.growing.upleft.anim_mode",	"linear,reverse"	},

  { "emc_grass",				"RocksEMC.png"		},
  { "emc_grass.xpos",				"0"			},
  { "emc_grass.ypos",				"4"			},
  { "emc_grass.frames",				"1"			},
  { "emc_grass.CRUMBLED",			"RocksEMC.png"		},
  { "emc_grass.CRUMBLED.xpos",			"1"			},
  { "emc_grass.CRUMBLED.ypos",			"4"			},
  { "emc_grass.CRUMBLED.frames",		"1"			},
  { "emc_grass.digging.left",			"RocksEMC.png"		},
  { "emc_grass.digging.left.xpos",		"6"			},
  { "emc_grass.digging.left.ypos",		"0"			},
  { "emc_grass.digging.left.frames",		"3"			},
  { "emc_grass.digging.left.delay",		"2"			},
  { "emc_grass.digging.left.anim_mode",		"linear"		},
  { "emc_grass.digging.right",			"RocksEMC.png"		},
  { "emc_grass.digging.right.xpos",		"9"			},
  { "emc_grass.digging.right.ypos",		"0"			},
  { "emc_grass.digging.right.frames",		"3"			},
  { "emc_grass.digging.right.delay",		"2"			},
  { "emc_grass.digging.right.anim_mode",	"linear"		},
  { "emc_grass.digging.up",			"RocksEMC.png"		},
  { "emc_grass.digging.up.xpos",		"0"			},
  { "emc_grass.digging.up.ypos",		"0"			},
  { "emc_grass.digging.up.frames",		"3"			},
  { "emc_grass.digging.up.delay",		"2"			},
  { "emc_grass.digging.up.anim_mode",		"linear"		},
  { "emc_grass.digging.down",			"RocksEMC.png"		},
  { "emc_grass.digging.down.xpos",		"3"			},
  { "emc_grass.digging.down.ypos",		"0"			},
  { "emc_grass.digging.down.frames",		"3"			},
  { "emc_grass.digging.down.delay",		"2"			},
  { "emc_grass.digging.down.anim_mode",		"linear"		},
  { "emc_grass.digging.left.CRUMBLED",		"RocksEMC.png"		},
  { "emc_grass.digging.left.CRUMBLED.xpos",	"6"			},
  { "emc_grass.digging.left.CRUMBLED.ypos",	"1"			},
  { "emc_grass.digging.left.CRUMBLED.frames",	"3"			},
  { "emc_grass.digging.left.CRUMBLED.delay",	"2"			},
  { "emc_grass.digging.left.CRUMBLED.anim_mode","linear"		},
  { "emc_grass.digging.right.CRUMBLED",		"RocksEMC.png"		},
  { "emc_grass.digging.right.CRUMBLED.xpos",	"9"			},
  { "emc_grass.digging.right.CRUMBLED.ypos",	"1"			},
  { "emc_grass.digging.right.CRUMBLED.frames",	"3"			},
  { "emc_grass.digging.right.CRUMBLED.delay",	"2"			},
  { "emc_grass.digging.right.CRUMBLED.anim_mode","linear"		},
  { "emc_grass.digging.up.CRUMBLED",		"RocksEMC.png"		},
  { "emc_grass.digging.up.CRUMBLED.xpos",	"0"			},
  { "emc_grass.digging.up.CRUMBLED.ypos",	"1"			},
  { "emc_grass.digging.up.CRUMBLED.frames",	"3"			},
  { "emc_grass.digging.up.CRUMBLED.delay",	"2"			},
  { "emc_grass.digging.up.CRUMBLED.anim_mode",	"linear"		},
  { "emc_grass.digging.down.CRUMBLED",		"RocksEMC.png"		},
  { "emc_grass.digging.down.CRUMBLED.xpos",	"3"			},
  { "emc_grass.digging.down.CRUMBLED.ypos",	"1"			},
  { "emc_grass.digging.down.CRUMBLED.frames",	"3"			},
  { "emc_grass.digging.down.CRUMBLED.delay",	"2"			},
  { "emc_grass.digging.down.CRUMBLED.anim_mode","linear"		},

  { "emc_magic_ball",				"RocksEMC.png"		},
  { "emc_magic_ball.xpos",			"0"			},
  { "emc_magic_ball.ypos",			"9"			},
  { "emc_magic_ball.frames",			"1"			},
  { "emc_magic_ball.active",			"RocksEMC.png"		},
  { "emc_magic_ball.active.xpos",		"0"			},
  { "emc_magic_ball.active.ypos",		"9"			},
  { "emc_magic_ball.active.frames",		"16"			},
  { "emc_magic_ball.active.frames_per_line",	"8"			},
  { "emc_magic_ball.dropping",			"RocksElements.png"	},
  { "emc_magic_ball.dropping.xpos",		"0"			},
  { "emc_magic_ball.dropping.ypos",		"4"			},
  { "emc_magic_ball.dropping.frames",		"8"			},
  { "emc_magic_ball.dropping.anim_mode",	"linear"		},

  { "emc_magic_ball_switch",			"RocksEMC.png"		},
  { "emc_magic_ball_switch.xpos",		"8"			},
  { "emc_magic_ball_switch.ypos",		"10"			},
  { "emc_magic_ball_switch.frames",		"1"			},
  { "emc_magic_ball_switch.active",		"RocksEMC.png"		},
  { "emc_magic_ball_switch.active.xpos",	"8"			},
  { "emc_magic_ball_switch.active.ypos",	"9"			},
  { "emc_magic_ball_switch.active.frames",	"1"			},

  { "emc_spring_bumper",			"RocksEMC.png"		},
  { "emc_spring_bumper.xpos",			"8"			},
  { "emc_spring_bumper.ypos",			"4"			},
  { "emc_spring_bumper.frames",			"1"			},

  { "emc_spring_bumper.active",			"RocksEMC.png"		},
  { "emc_spring_bumper.active.xpos",		"8"			},
  { "emc_spring_bumper.active.ypos",		"4"			},
  { "emc_spring_bumper.active.frames",		"4"			},
  { "emc_spring_bumper.active.anim_mode",	"pingpong2"		},

  { "emc_plant",				"RocksEMC.png"		},
  { "emc_plant.xpos",				"4"			},
  { "emc_plant.ypos",				"4"			},
  { "emc_plant.frames",				"1"			},
  { "emc_plant.CRUMBLED",			"RocksEMC.png"		},
  { "emc_plant.CRUMBLED.xpos",			"5"			},
  { "emc_plant.CRUMBLED.ypos",			"4"			},
  { "emc_plant.CRUMBLED.frames",		"1"			},

  { "emc_lenses",				"RocksEMC.png"		},
  { "emc_lenses.xpos",				"6"			},
  { "emc_lenses.ypos",				"4"			},
  { "emc_lenses.frames",			"1"			},

  { "emc_magnifier",				"RocksEMC.png"		},
  { "emc_magnifier.xpos",			"7"			},
  { "emc_magnifier.ypos",			"4"			},
  { "emc_magnifier.frames",			"1"			},

  { "emc_wall_9",				"RocksEMC.png"		},
  { "emc_wall_9.xpos",				"10"			},
  { "emc_wall_9.ypos",				"5"			},
  { "emc_wall_9.frames",			"1"			},
  { "emc_wall_10",				"RocksEMC.png"		},
  { "emc_wall_10.xpos",				"10"			},
  { "emc_wall_10.ypos",				"6"			},
  { "emc_wall_10.frames",			"1"			},
  { "emc_wall_11",				"RocksEMC.png"		},
  { "emc_wall_11.xpos",				"11"			},
  { "emc_wall_11.ypos",				"5"			},
  { "emc_wall_11.frames",			"1"			},
  { "emc_wall_12",				"RocksEMC.png"		},
  { "emc_wall_12.xpos",				"11"			},
  { "emc_wall_12.ypos",				"6"			},
  { "emc_wall_12.frames",			"1"			},
  { "emc_wall_13",				"RocksEMC.png"		},
  { "emc_wall_13.xpos",				"10"			},
  { "emc_wall_13.ypos",				"7"			},
  { "emc_wall_13.frames",			"1"			},
  { "emc_wall_14",				"RocksEMC.png"		},
  { "emc_wall_14.xpos",				"10"			},
  { "emc_wall_14.ypos",				"8"			},
  { "emc_wall_14.frames",			"1"			},
  { "emc_wall_15",				"RocksEMC.png"		},
  { "emc_wall_15.xpos",				"10"			},
  { "emc_wall_15.ypos",				"9"			},
  { "emc_wall_15.frames",			"1"			},
  { "emc_wall_16",				"RocksEMC.png"		},
  { "emc_wall_16.xpos",				"10"			},
  { "emc_wall_16.ypos",				"10"			},
  { "emc_wall_16.frames",			"1"			},

  { "emc_wall_slippery_1",			"RocksEMC.png"		},
  { "emc_wall_slippery_1.xpos",			"11"			},
  { "emc_wall_slippery_1.ypos",			"7"			},
  { "emc_wall_slippery_1.frames",		"1"			},
  { "emc_wall_slippery_2",			"RocksEMC.png"		},
  { "emc_wall_slippery_2.xpos",			"11"			},
  { "emc_wall_slippery_2.ypos",			"8"			},
  { "emc_wall_slippery_2.frames",		"1"			},
  { "emc_wall_slippery_3",			"RocksEMC.png"		},
  { "emc_wall_slippery_3.xpos",			"11"			},
  { "emc_wall_slippery_3.ypos",			"9"			},
  { "emc_wall_slippery_3.frames",		"1"			},
  { "emc_wall_slippery_4",			"RocksEMC.png"		},
  { "emc_wall_slippery_4.xpos",			"11"			},
  { "emc_wall_slippery_4.ypos",			"10"			},
  { "emc_wall_slippery_4.frames",		"1"			},

  { "emc_fake_grass",				"RocksEMC.png"		},
  { "emc_fake_grass.xpos",			"0"			},
  { "emc_fake_grass.ypos",			"4"			},
  { "emc_fake_grass.frames",			"1"			},
  { "emc_fake_grass.CRUMBLED",			"RocksEMC.png"		},
  { "emc_fake_grass.CRUMBLED.xpos",		"1"			},
  { "emc_fake_grass.CRUMBLED.ypos",		"4"			},
  { "emc_fake_grass.CRUMBLED.frames",		"1"			},
  { "emc_fake_grass.active",			"RocksEMC.png"		},
  { "emc_fake_grass.active.xpos",		"2"			},
  { "emc_fake_grass.active.ypos",		"4"			},
  { "emc_fake_grass.active.frames",		"1"			},
  { "emc_fake_grass.active.CRUMBLED",		"RocksEMC.png"		},
  { "emc_fake_grass.active.CRUMBLED.xpos",	"3"			},
  { "emc_fake_grass.active.CRUMBLED.ypos",	"4"			},
  { "emc_fake_grass.active.CRUMBLED.frames",	"1"			},
  { "emc_fake_grass.EDITOR",			"RocksEMC.png"		},
  { "emc_fake_grass.EDITOR.xpos",		"2"			},
  { "emc_fake_grass.EDITOR.ypos",		"4"			},
  { "emc_fake_grass.EDITOR.frames",		"1"			},

  { "emc_fake_acid",				"RocksElements.png"	},
  { "emc_fake_acid.xpos",			"12"			},
  { "emc_fake_acid.ypos",			"7"			},
  { "emc_fake_acid.frames",			"4"			},
  { "emc_fake_acid.delay",			"10"			},
  { "emc_fake_acid.global_sync",		"true"			},

  { "emc_dripper",				"RocksSP.png"		},
  { "emc_dripper.xpos",				"0"			},
  { "emc_dripper.ypos",				"0"			},
  { "emc_dripper.frames",			"1"			},
  { "emc_dripper.EDITOR",			"RocksEMC.png"		},
  { "emc_dripper.EDITOR.xpos",			"8"			},
  { "emc_dripper.EDITOR.ypos",			"8"			},
  { "emc_dripper.active",			"RocksEMC.png"		},
  { "emc_dripper.active.xpos",			"8"			},
  { "emc_dripper.active.ypos",			"8"			},
  { "emc_dripper.active.frames",		"1"			},

  { "mm_mcduffin",				"RocksMM.png"		},
  { "mm_mcduffin.xpos",				"4"			},
  { "mm_mcduffin.ypos",				"1"			},
  { "mm_mcduffin.frames",			"4"			},
  { "mm_mcduffin.delay",			"8"			},
  { "mm_mcduffin.right",			"RocksMM.png"		},
  { "mm_mcduffin.right.xpos",			"4"			},
  { "mm_mcduffin.right.ypos",			"1"			},
  { "mm_mcduffin.right.frames",			"1"			},
  { "mm_mcduffin.up",				"RocksMM.png"		},
  { "mm_mcduffin.up.xpos",			"5"			},
  { "mm_mcduffin.up.ypos",			"1"			},
  { "mm_mcduffin.up.frames",			"1"			},
  { "mm_mcduffin.left",				"RocksMM.png"		},
  { "mm_mcduffin.left.xpos",			"6"			},
  { "mm_mcduffin.left.ypos",			"1"			},
  { "mm_mcduffin.left.frames",			"1"			},
  { "mm_mcduffin.down",				"RocksMM.png"		},
  { "mm_mcduffin.down.xpos",			"7"			},
  { "mm_mcduffin.down.ypos",			"1"			},
  { "mm_mcduffin.down.frames",			"1"			},

  { "mm_exit_closed",				"RocksMM.png"		},
  { "mm_exit_closed.xpos",			"8"			},
  { "mm_exit_closed.ypos",			"1"			},
  { "mm_exit_closed.frames",			"1"			},
  { "mm_exit.opening",				"RocksMM.png"		},
  { "mm_exit.opening.xpos",			"8"			},
  { "mm_exit.opening.ypos",			"1"			},
  { "mm_exit.opening.frames",			"4"			},
  { "mm_exit.opening.delay",			"6"			},
  { "mm_exit.opening.anim_mode",		"linear"		},
  { "mm_exit_open",				"RocksMM.png"		},
  { "mm_exit_open.xpos",			"11"			},
  { "mm_exit_open.ypos",			"1"			},
  { "mm_exit_open.frames",			"1"			},
  { "mm_exit.closing",				"RocksMM.png"		},
  { "mm_exit.closing.xpos",			"8"			},
  { "mm_exit.closing.ypos",			"1"			},
  { "mm_exit.closing.frames",			"4"			},
  { "mm_exit.closing.delay",			"6"			},
  { "mm_exit.closing.anim_mode",		"linear,reverse"	},

  { "mm_mirror_1",				"RocksMM.png"		},
  { "mm_mirror_1.xpos",				"0"			},
  { "mm_mirror_1.ypos",				"0"			},
  { "mm_mirror_1.frames",			"1"			},
  { "mm_mirror_2",				"RocksMM.png"		},
  { "mm_mirror_2.xpos",				"1"			},
  { "mm_mirror_2.ypos",				"0"			},
  { "mm_mirror_2.frames",			"1"			},
  { "mm_mirror_3",				"RocksMM.png"		},
  { "mm_mirror_3.xpos",				"2"			},
  { "mm_mirror_3.ypos",				"0"			},
  { "mm_mirror_3.frames",			"1"			},
  { "mm_mirror_4",				"RocksMM.png"		},
  { "mm_mirror_4.xpos",				"3"			},
  { "mm_mirror_4.ypos",				"0"			},
  { "mm_mirror_4.frames",			"1"			},
  { "mm_mirror_5",				"RocksMM.png"		},
  { "mm_mirror_5.xpos",				"4"			},
  { "mm_mirror_5.ypos",				"0"			},
  { "mm_mirror_5.frames",			"1"			},
  { "mm_mirror_6",				"RocksMM.png"		},
  { "mm_mirror_6.xpos",				"5"			},
  { "mm_mirror_6.ypos",				"0"			},
  { "mm_mirror_6.frames",			"1"			},
  { "mm_mirror_7",				"RocksMM.png"		},
  { "mm_mirror_7.xpos",				"6"			},
  { "mm_mirror_7.ypos",				"0"			},
  { "mm_mirror_7.frames",			"1"			},
  { "mm_mirror_8",				"RocksMM.png"		},
  { "mm_mirror_8.xpos",				"7"			},
  { "mm_mirror_8.ypos",				"0"			},
  { "mm_mirror_8.frames",			"1"			},
  { "mm_mirror_9",				"RocksMM.png"		},
  { "mm_mirror_9.xpos",				"8"			},
  { "mm_mirror_9.ypos",				"0"			},
  { "mm_mirror_9.frames",			"1"			},
  { "mm_mirror_10",				"RocksMM.png"		},
  { "mm_mirror_10.xpos",			"9"			},
  { "mm_mirror_10.ypos",			"0"			},
  { "mm_mirror_10.frames",			"1"			},
  { "mm_mirror_11",				"RocksMM.png"		},
  { "mm_mirror_11.xpos",			"10"			},
  { "mm_mirror_11.ypos",			"0"			},
  { "mm_mirror_11.frames",			"1"			},
  { "mm_mirror_12",				"RocksMM.png"		},
  { "mm_mirror_12.xpos",			"11"			},
  { "mm_mirror_12.ypos",			"0"			},
  { "mm_mirror_12.frames",			"1"			},
  { "mm_mirror_13",				"RocksMM.png"		},
  { "mm_mirror_13.xpos",			"12"			},
  { "mm_mirror_13.ypos",			"0"			},
  { "mm_mirror_13.frames",			"1"			},
  { "mm_mirror_14",				"RocksMM.png"		},
  { "mm_mirror_14.xpos",			"13"			},
  { "mm_mirror_14.ypos",			"0"			},
  { "mm_mirror_14.frames",			"1"			},
  { "mm_mirror_15",				"RocksMM.png"		},
  { "mm_mirror_15.xpos",			"14"			},
  { "mm_mirror_15.ypos",			"0"			},
  { "mm_mirror_15.frames",			"1"			},
  { "mm_mirror_16",				"RocksMM.png"		},
  { "mm_mirror_16.xpos",			"15"			},
  { "mm_mirror_16.ypos",			"0"			},
  { "mm_mirror_16.frames",			"1"			},

  { "mm_mirror_fixed_1",			"RocksMM.png"		},
  { "mm_mirror_fixed_1.xpos",			"4"			},
  { "mm_mirror_fixed_1.ypos",			"6"			},
  { "mm_mirror_fixed_1.frames",			"1"			},
  { "mm_mirror_fixed_2",			"RocksMM.png"		},
  { "mm_mirror_fixed_2.xpos",			"5"			},
  { "mm_mirror_fixed_2.ypos",			"6"			},
  { "mm_mirror_fixed_2.frames",			"1"			},
  { "mm_mirror_fixed_3",			"RocksMM.png"		},
  { "mm_mirror_fixed_3.xpos",			"6"			},
  { "mm_mirror_fixed_3.ypos",			"6"			},
  { "mm_mirror_fixed_3.frames",			"1"			},
  { "mm_mirror_fixed_4",			"RocksMM.png"		},
  { "mm_mirror_fixed_4.xpos",			"7"			},
  { "mm_mirror_fixed_4.ypos",			"6"			},
  { "mm_mirror_fixed_4.frames",			"1"			},

  { "mm_steel_grid_fixed_1",			"RocksMM.png"		},
  { "mm_steel_grid_fixed_1.xpos",		"0"			},
  { "mm_steel_grid_fixed_1.ypos",		"1"			},
  { "mm_steel_grid_fixed_1.frames",		"1"			},
  { "mm_steel_grid_fixed_2",			"RocksMM.png"		},
  { "mm_steel_grid_fixed_2.xpos",		"1"			},
  { "mm_steel_grid_fixed_2.ypos",		"1"			},
  { "mm_steel_grid_fixed_2.frames",		"1"			},
  { "mm_steel_grid_fixed_3",			"RocksMM.png"		},
  { "mm_steel_grid_fixed_3.xpos",		"2"			},
  { "mm_steel_grid_fixed_3.ypos",		"1"			},
  { "mm_steel_grid_fixed_3.frames",		"1"			},
  { "mm_steel_grid_fixed_4",			"RocksMM.png"		},
  { "mm_steel_grid_fixed_4.xpos",		"3"			},
  { "mm_steel_grid_fixed_4.ypos",		"1"			},
  { "mm_steel_grid_fixed_4.frames",		"1"			},

  { "mm_wooden_grid_fixed_1",			"RocksMM.png"		},
  { "mm_wooden_grid_fixed_1.xpos",		"12"			},
  { "mm_wooden_grid_fixed_1.ypos",		"6"			},
  { "mm_wooden_grid_fixed_1.frames",		"1"			},
  { "mm_wooden_grid_fixed_2",			"RocksMM.png"		},
  { "mm_wooden_grid_fixed_2.xpos",		"13"			},
  { "mm_wooden_grid_fixed_2.ypos",		"6"			},
  { "mm_wooden_grid_fixed_2.frames",		"1"			},
  { "mm_wooden_grid_fixed_3",			"RocksMM.png"		},
  { "mm_wooden_grid_fixed_3.xpos",		"14"			},
  { "mm_wooden_grid_fixed_3.ypos",		"6"			},
  { "mm_wooden_grid_fixed_3.frames",		"1"			},
  { "mm_wooden_grid_fixed_4",			"RocksMM.png"		},
  { "mm_wooden_grid_fixed_4.xpos",		"15"			},
  { "mm_wooden_grid_fixed_4.ypos",		"6"			},
  { "mm_wooden_grid_fixed_4.frames",		"1"			},

  { "mm_polarizer_1",				"RocksMM.png"		},
  { "mm_polarizer_1.xpos",			"0"			},
  { "mm_polarizer_1.ypos",			"5"			},
  { "mm_polarizer_1.frames",			"1"			},
  { "mm_polarizer_2",				"RocksMM.png"		},
  { "mm_polarizer_2.xpos",			"1"			},
  { "mm_polarizer_2.ypos",			"5"			},
  { "mm_polarizer_2.frames",			"1"			},
  { "mm_polarizer_3",				"RocksMM.png"		},
  { "mm_polarizer_3.xpos",			"2"			},
  { "mm_polarizer_3.ypos",			"5"			},
  { "mm_polarizer_3.frames",			"1"			},
  { "mm_polarizer_4",				"RocksMM.png"		},
  { "mm_polarizer_4.xpos",			"3"			},
  { "mm_polarizer_4.ypos",			"5"			},
  { "mm_polarizer_4.frames",			"1"			},
  { "mm_polarizer_5",				"RocksMM.png"		},
  { "mm_polarizer_5.xpos",			"4"			},
  { "mm_polarizer_5.ypos",			"5"			},
  { "mm_polarizer_5.frames",			"1"			},
  { "mm_polarizer_6",				"RocksMM.png"		},
  { "mm_polarizer_6.xpos",			"5"			},
  { "mm_polarizer_6.ypos",			"5"			},
  { "mm_polarizer_6.frames",			"1"			},
  { "mm_polarizer_7",				"RocksMM.png"		},
  { "mm_polarizer_7.xpos",			"6"			},
  { "mm_polarizer_7.ypos",			"5"			},
  { "mm_polarizer_7.frames",			"1"			},
  { "mm_polarizer_8",				"RocksMM.png"		},
  { "mm_polarizer_8.xpos",			"7"			},
  { "mm_polarizer_8.ypos",			"5"			},
  { "mm_polarizer_8.frames",			"1"			},
  { "mm_polarizer_9",				"RocksMM.png"		},
  { "mm_polarizer_9.xpos",			"8"			},
  { "mm_polarizer_9.ypos",			"5"			},
  { "mm_polarizer_9.frames",			"1"			},
  { "mm_polarizer_10",				"RocksMM.png"		},
  { "mm_polarizer_10.xpos",			"9"			},
  { "mm_polarizer_10.ypos",			"5"			},
  { "mm_polarizer_10.frames",			"1"			},
  { "mm_polarizer_11",				"RocksMM.png"		},
  { "mm_polarizer_11.xpos",			"10"			},
  { "mm_polarizer_11.ypos",			"5"			},
  { "mm_polarizer_11.frames",			"1"			},
  { "mm_polarizer_12",				"RocksMM.png"		},
  { "mm_polarizer_12.xpos",			"11"			},
  { "mm_polarizer_12.ypos",			"5"			},
  { "mm_polarizer_12.frames",			"1"			},
  { "mm_polarizer_13",				"RocksMM.png"		},
  { "mm_polarizer_13.xpos",			"12"			},
  { "mm_polarizer_13.ypos",			"5"			},
  { "mm_polarizer_13.frames",			"1"			},
  { "mm_polarizer_14",				"RocksMM.png"		},
  { "mm_polarizer_14.xpos",			"13"			},
  { "mm_polarizer_14.ypos",			"5"			},
  { "mm_polarizer_14.frames",			"1"			},
  { "mm_polarizer_15",				"RocksMM.png"		},
  { "mm_polarizer_15.xpos",			"14"			},
  { "mm_polarizer_15.ypos",			"5"			},
  { "mm_polarizer_15.frames",			"1"			},
  { "mm_polarizer_16",				"RocksMM.png"		},
  { "mm_polarizer_16.xpos",			"15"			},
  { "mm_polarizer_16.ypos",			"5"			},
  { "mm_polarizer_16.frames",			"1"			},

  { "mm_polarizer_cross_1",			"RocksMM.png"		},
  { "mm_polarizer_cross_1.xpos",		"0"			},
  { "mm_polarizer_cross_1.ypos",		"6"			},
  { "mm_polarizer_cross_1.frames",		"1"			},
  { "mm_polarizer_cross_2",			"RocksMM.png"		},
  { "mm_polarizer_cross_2.xpos",		"1"			},
  { "mm_polarizer_cross_2.ypos",		"6"			},
  { "mm_polarizer_cross_2.frames",		"1"			},
  { "mm_polarizer_cross_3",			"RocksMM.png"		},
  { "mm_polarizer_cross_3.xpos",		"2"			},
  { "mm_polarizer_cross_3.ypos",		"6"			},
  { "mm_polarizer_cross_3.frames",		"1"			},
  { "mm_polarizer_cross_4",			"RocksMM.png"		},
  { "mm_polarizer_cross_4.xpos",		"3"			},
  { "mm_polarizer_cross_4.ypos",		"6"			},
  { "mm_polarizer_cross_4.frames",		"1"			},

  { "mm_teleporter_1",				"RocksMM.png"		},
  { "mm_teleporter_1.xpos",			"0"			},
  { "mm_teleporter_1.ypos",			"3"			},
  { "mm_teleporter_1.frames",			"1"			},
  { "mm_teleporter_2",				"RocksMM.png"		},
  { "mm_teleporter_2.xpos",			"1"			},
  { "mm_teleporter_2.ypos",			"3"			},
  { "mm_teleporter_2.frames",			"1"			},
  { "mm_teleporter_3",				"RocksMM.png"		},
  { "mm_teleporter_3.xpos",			"2"			},
  { "mm_teleporter_3.ypos",			"3"			},
  { "mm_teleporter_3.frames",			"1"			},
  { "mm_teleporter_4",				"RocksMM.png"		},
  { "mm_teleporter_4.xpos",			"3"			},
  { "mm_teleporter_4.ypos",			"3"			},
  { "mm_teleporter_4.frames",			"1"			},
  { "mm_teleporter_5",				"RocksMM.png"		},
  { "mm_teleporter_5.xpos",			"4"			},
  { "mm_teleporter_5.ypos",			"3"			},
  { "mm_teleporter_5.frames",			"1"			},
  { "mm_teleporter_6",				"RocksMM.png"		},
  { "mm_teleporter_6.xpos",			"5"			},
  { "mm_teleporter_6.ypos",			"3"			},
  { "mm_teleporter_6.frames",			"1"			},
  { "mm_teleporter_7",				"RocksMM.png"		},
  { "mm_teleporter_7.xpos",			"6"			},
  { "mm_teleporter_7.ypos",			"3"			},
  { "mm_teleporter_7.frames",			"1"			},
  { "mm_teleporter_8",				"RocksMM.png"		},
  { "mm_teleporter_8.xpos",			"7"			},
  { "mm_teleporter_8.ypos",			"3"			},
  { "mm_teleporter_8.frames",			"1"			},
  { "mm_teleporter_9",				"RocksMM.png"		},
  { "mm_teleporter_9.xpos",			"8"			},
  { "mm_teleporter_9.ypos",			"3"			},
  { "mm_teleporter_9.frames",			"1"			},
  { "mm_teleporter_10",				"RocksMM.png"		},
  { "mm_teleporter_10.xpos",			"9"			},
  { "mm_teleporter_10.ypos",			"3"			},
  { "mm_teleporter_10.frames",			"1"			},
  { "mm_teleporter_11",				"RocksMM.png"		},
  { "mm_teleporter_11.xpos",			"10"			},
  { "mm_teleporter_11.ypos",			"3"			},
  { "mm_teleporter_11.frames",			"1"			},
  { "mm_teleporter_12",				"RocksMM.png"		},
  { "mm_teleporter_12.xpos",			"11"			},
  { "mm_teleporter_12.ypos",			"3"			},
  { "mm_teleporter_12.frames",			"1"			},
  { "mm_teleporter_13",				"RocksMM.png"		},
  { "mm_teleporter_13.xpos",			"12"			},
  { "mm_teleporter_13.ypos",			"3"			},
  { "mm_teleporter_13.frames",			"1"			},
  { "mm_teleporter_14",				"RocksMM.png"		},
  { "mm_teleporter_14.xpos",			"13"			},
  { "mm_teleporter_14.ypos",			"3"			},
  { "mm_teleporter_14.frames",			"1"			},
  { "mm_teleporter_15",				"RocksMM.png"		},
  { "mm_teleporter_15.xpos",			"14"			},
  { "mm_teleporter_15.ypos",			"3"			},
  { "mm_teleporter_15.frames",			"1"			},
  { "mm_teleporter_16",				"RocksMM.png"		},
  { "mm_teleporter_16.xpos",			"15"			},
  { "mm_teleporter_16.ypos",			"3"			},
  { "mm_teleporter_16.frames",			"1"			},

  { "mm_teleporter_red_1",			"RocksDF.png"		},
  { "mm_teleporter_red_1.xpos",			"0"			},
  { "mm_teleporter_red_1.ypos",			"4"			},
  { "mm_teleporter_red_1.frames",		"1"			},
  { "mm_teleporter_red_2",			"RocksDF.png"		},
  { "mm_teleporter_red_2.xpos",			"1"			},
  { "mm_teleporter_red_2.ypos",			"4"			},
  { "mm_teleporter_red_2.frames",		"1"			},
  { "mm_teleporter_red_3",			"RocksDF.png"		},
  { "mm_teleporter_red_3.xpos",			"2"			},
  { "mm_teleporter_red_3.ypos",			"4"			},
  { "mm_teleporter_red_3.frames",		"1"			},
  { "mm_teleporter_red_4",			"RocksDF.png"		},
  { "mm_teleporter_red_4.xpos",			"3"			},
  { "mm_teleporter_red_4.ypos",			"4"			},
  { "mm_teleporter_red_4.frames",		"1"			},
  { "mm_teleporter_red_5",			"RocksDF.png"		},
  { "mm_teleporter_red_5.xpos",			"4"			},
  { "mm_teleporter_red_5.ypos",			"4"			},
  { "mm_teleporter_red_5.frames",		"1"			},
  { "mm_teleporter_red_6",			"RocksDF.png"		},
  { "mm_teleporter_red_6.xpos",			"5"			},
  { "mm_teleporter_red_6.ypos",			"4"			},
  { "mm_teleporter_red_6.frames",		"1"			},
  { "mm_teleporter_red_7",			"RocksDF.png"		},
  { "mm_teleporter_red_7.xpos",			"6"			},
  { "mm_teleporter_red_7.ypos",			"4"			},
  { "mm_teleporter_red_7.frames",		"1"			},
  { "mm_teleporter_red_8",			"RocksDF.png"		},
  { "mm_teleporter_red_8.xpos",			"7"			},
  { "mm_teleporter_red_8.ypos",			"4"			},
  { "mm_teleporter_red_8.frames",		"1"			},
  { "mm_teleporter_red_9",			"RocksDF.png"		},
  { "mm_teleporter_red_9.xpos",			"8"			},
  { "mm_teleporter_red_9.ypos",			"4"			},
  { "mm_teleporter_red_9.frames",		"1"			},
  { "mm_teleporter_red_10",			"RocksDF.png"		},
  { "mm_teleporter_red_10.xpos",		"9"			},
  { "mm_teleporter_red_10.ypos",		"4"			},
  { "mm_teleporter_red_10.frames",		"1"			},
  { "mm_teleporter_red_11",			"RocksDF.png"		},
  { "mm_teleporter_red_11.xpos",		"10"			},
  { "mm_teleporter_red_11.ypos",		"4"			},
  { "mm_teleporter_red_11.frames",		"1"			},
  { "mm_teleporter_red_12",			"RocksDF.png"		},
  { "mm_teleporter_red_12.xpos",		"11"			},
  { "mm_teleporter_red_12.ypos",		"4"			},
  { "mm_teleporter_red_12.frames",		"1"			},
  { "mm_teleporter_red_13",			"RocksDF.png"		},
  { "mm_teleporter_red_13.xpos",		"12"			},
  { "mm_teleporter_red_13.ypos",		"4"			},
  { "mm_teleporter_red_13.frames",		"1"			},
  { "mm_teleporter_red_14",			"RocksDF.png"		},
  { "mm_teleporter_red_14.xpos",		"13"			},
  { "mm_teleporter_red_14.ypos",		"4"			},
  { "mm_teleporter_red_14.frames",		"1"			},
  { "mm_teleporter_red_15",			"RocksDF.png"		},
  { "mm_teleporter_red_15.xpos",		"14"			},
  { "mm_teleporter_red_15.ypos",		"4"			},
  { "mm_teleporter_red_15.frames",		"1"			},
  { "mm_teleporter_red_16",			"RocksDF.png"		},
  { "mm_teleporter_red_16.xpos",		"15"			},
  { "mm_teleporter_red_16.ypos",		"4"			},
  { "mm_teleporter_red_16.frames",		"1"			},

  { "mm_teleporter_yellow_1",			"RocksDF.png"		},
  { "mm_teleporter_yellow_1.xpos",		"0"			},
  { "mm_teleporter_yellow_1.ypos",		"5"			},
  { "mm_teleporter_yellow_1.frames",		"1"			},
  { "mm_teleporter_yellow_2",			"RocksDF.png"		},
  { "mm_teleporter_yellow_2.xpos",		"1"			},
  { "mm_teleporter_yellow_2.ypos",		"5"			},
  { "mm_teleporter_yellow_2.frames",		"1"			},
  { "mm_teleporter_yellow_3",			"RocksDF.png"		},
  { "mm_teleporter_yellow_3.xpos",		"2"			},
  { "mm_teleporter_yellow_3.ypos",		"5"			},
  { "mm_teleporter_yellow_3.frames",		"1"			},
  { "mm_teleporter_yellow_4",			"RocksDF.png"		},
  { "mm_teleporter_yellow_4.xpos",		"3"			},
  { "mm_teleporter_yellow_4.ypos",		"5"			},
  { "mm_teleporter_yellow_4.frames",		"1"			},
  { "mm_teleporter_yellow_5",			"RocksDF.png"		},
  { "mm_teleporter_yellow_5.xpos",		"4"			},
  { "mm_teleporter_yellow_5.ypos",		"5"			},
  { "mm_teleporter_yellow_5.frames",		"1"			},
  { "mm_teleporter_yellow_6",			"RocksDF.png"		},
  { "mm_teleporter_yellow_6.xpos",		"5"			},
  { "mm_teleporter_yellow_6.ypos",		"5"			},
  { "mm_teleporter_yellow_6.frames",		"1"			},
  { "mm_teleporter_yellow_7",			"RocksDF.png"		},
  { "mm_teleporter_yellow_7.xpos",		"6"			},
  { "mm_teleporter_yellow_7.ypos",		"5"			},
  { "mm_teleporter_yellow_7.frames",		"1"			},
  { "mm_teleporter_yellow_8",			"RocksDF.png"		},
  { "mm_teleporter_yellow_8.xpos",		"7"			},
  { "mm_teleporter_yellow_8.ypos",		"5"			},
  { "mm_teleporter_yellow_8.frames",		"1"			},
  { "mm_teleporter_yellow_9",			"RocksDF.png"		},
  { "mm_teleporter_yellow_9.xpos",		"8"			},
  { "mm_teleporter_yellow_9.ypos",		"5"			},
  { "mm_teleporter_yellow_9.frames",		"1"			},
  { "mm_teleporter_yellow_10",			"RocksDF.png"		},
  { "mm_teleporter_yellow_10.xpos",		"9"			},
  { "mm_teleporter_yellow_10.ypos",		"5"			},
  { "mm_teleporter_yellow_10.frames",		"1"			},
  { "mm_teleporter_yellow_11",			"RocksDF.png"		},
  { "mm_teleporter_yellow_11.xpos",		"10"			},
  { "mm_teleporter_yellow_11.ypos",		"5"			},
  { "mm_teleporter_yellow_11.frames",		"1"			},
  { "mm_teleporter_yellow_12",			"RocksDF.png"		},
  { "mm_teleporter_yellow_12.xpos",		"11"			},
  { "mm_teleporter_yellow_12.ypos",		"5"			},
  { "mm_teleporter_yellow_12.frames",		"1"			},
  { "mm_teleporter_yellow_13",			"RocksDF.png"		},
  { "mm_teleporter_yellow_13.xpos",		"12"			},
  { "mm_teleporter_yellow_13.ypos",		"5"			},
  { "mm_teleporter_yellow_13.frames",		"1"			},
  { "mm_teleporter_yellow_14",			"RocksDF.png"		},
  { "mm_teleporter_yellow_14.xpos",		"13"			},
  { "mm_teleporter_yellow_14.ypos",		"5"			},
  { "mm_teleporter_yellow_14.frames",		"1"			},
  { "mm_teleporter_yellow_15",			"RocksDF.png"		},
  { "mm_teleporter_yellow_15.xpos",		"14"			},
  { "mm_teleporter_yellow_15.ypos",		"5"			},
  { "mm_teleporter_yellow_15.frames",		"1"			},
  { "mm_teleporter_yellow_16",			"RocksDF.png"		},
  { "mm_teleporter_yellow_16.xpos",		"15"			},
  { "mm_teleporter_yellow_16.ypos",		"5"			},
  { "mm_teleporter_yellow_16.frames",		"1"			},

  { "mm_teleporter_green_1",			"RocksDF.png"		},
  { "mm_teleporter_green_1.xpos",		"0"			},
  { "mm_teleporter_green_1.ypos",		"6"			},
  { "mm_teleporter_green_1.frames",		"1"			},
  { "mm_teleporter_green_2",			"RocksDF.png"		},
  { "mm_teleporter_green_2.xpos",		"1"			},
  { "mm_teleporter_green_2.ypos",		"6"			},
  { "mm_teleporter_green_2.frames",		"1"			},
  { "mm_teleporter_green_3",			"RocksDF.png"		},
  { "mm_teleporter_green_3.xpos",		"2"			},
  { "mm_teleporter_green_3.ypos",		"6"			},
  { "mm_teleporter_green_3.frames",		"1"			},
  { "mm_teleporter_green_4",			"RocksDF.png"		},
  { "mm_teleporter_green_4.xpos",		"3"			},
  { "mm_teleporter_green_4.ypos",		"6"			},
  { "mm_teleporter_green_4.frames",		"1"			},
  { "mm_teleporter_green_5",			"RocksDF.png"		},
  { "mm_teleporter_green_5.xpos",		"4"			},
  { "mm_teleporter_green_5.ypos",		"6"			},
  { "mm_teleporter_green_5.frames",		"1"			},
  { "mm_teleporter_green_6",			"RocksDF.png"		},
  { "mm_teleporter_green_6.xpos",		"5"			},
  { "mm_teleporter_green_6.ypos",		"6"			},
  { "mm_teleporter_green_6.frames",		"1"			},
  { "mm_teleporter_green_7",			"RocksDF.png"		},
  { "mm_teleporter_green_7.xpos",		"6"			},
  { "mm_teleporter_green_7.ypos",		"6"			},
  { "mm_teleporter_green_7.frames",		"1"			},
  { "mm_teleporter_green_8",			"RocksDF.png"		},
  { "mm_teleporter_green_8.xpos",		"7"			},
  { "mm_teleporter_green_8.ypos",		"6"			},
  { "mm_teleporter_green_8.frames",		"1"			},
  { "mm_teleporter_green_9",			"RocksDF.png"		},
  { "mm_teleporter_green_9.xpos",		"8"			},
  { "mm_teleporter_green_9.ypos",		"6"			},
  { "mm_teleporter_green_9.frames",		"1"			},
  { "mm_teleporter_green_10",			"RocksDF.png"		},
  { "mm_teleporter_green_10.xpos",		"9"			},
  { "mm_teleporter_green_10.ypos",		"6"			},
  { "mm_teleporter_green_10.frames",		"1"			},
  { "mm_teleporter_green_11",			"RocksDF.png"		},
  { "mm_teleporter_green_11.xpos",		"10"			},
  { "mm_teleporter_green_11.ypos",		"6"			},
  { "mm_teleporter_green_11.frames",		"1"			},
  { "mm_teleporter_green_12",			"RocksDF.png"		},
  { "mm_teleporter_green_12.xpos",		"11"			},
  { "mm_teleporter_green_12.ypos",		"6"			},
  { "mm_teleporter_green_12.frames",		"1"			},
  { "mm_teleporter_green_13",			"RocksDF.png"		},
  { "mm_teleporter_green_13.xpos",		"12"			},
  { "mm_teleporter_green_13.ypos",		"6"			},
  { "mm_teleporter_green_13.frames",		"1"			},
  { "mm_teleporter_green_14",			"RocksDF.png"		},
  { "mm_teleporter_green_14.xpos",		"13"			},
  { "mm_teleporter_green_14.ypos",		"6"			},
  { "mm_teleporter_green_14.frames",		"1"			},
  { "mm_teleporter_green_15",			"RocksDF.png"		},
  { "mm_teleporter_green_15.xpos",		"14"			},
  { "mm_teleporter_green_15.ypos",		"6"			},
  { "mm_teleporter_green_15.frames",		"1"			},
  { "mm_teleporter_green_16",			"RocksDF.png"		},
  { "mm_teleporter_green_16.xpos",		"15"			},
  { "mm_teleporter_green_16.ypos",		"6"			},
  { "mm_teleporter_green_16.frames",		"1"			},

  { "mm_teleporter_blue_1",			"RocksDF.png"		},
  { "mm_teleporter_blue_1.xpos",		"0"			},
  { "mm_teleporter_blue_1.ypos",		"7"			},
  { "mm_teleporter_blue_1.frames",		"1"			},
  { "mm_teleporter_blue_2",			"RocksDF.png"		},
  { "mm_teleporter_blue_2.xpos",		"1"			},
  { "mm_teleporter_blue_2.ypos",		"7"			},
  { "mm_teleporter_blue_2.frames",		"1"			},
  { "mm_teleporter_blue_3",			"RocksDF.png"		},
  { "mm_teleporter_blue_3.xpos",		"2"			},
  { "mm_teleporter_blue_3.ypos",		"7"			},
  { "mm_teleporter_blue_3.frames",		"1"			},
  { "mm_teleporter_blue_4",			"RocksDF.png"		},
  { "mm_teleporter_blue_4.xpos",		"3"			},
  { "mm_teleporter_blue_4.ypos",		"7"			},
  { "mm_teleporter_blue_4.frames",		"1"			},
  { "mm_teleporter_blue_5",			"RocksDF.png"		},
  { "mm_teleporter_blue_5.xpos",		"4"			},
  { "mm_teleporter_blue_5.ypos",		"7"			},
  { "mm_teleporter_blue_5.frames",		"1"			},
  { "mm_teleporter_blue_6",			"RocksDF.png"		},
  { "mm_teleporter_blue_6.xpos",		"5"			},
  { "mm_teleporter_blue_6.ypos",		"7"			},
  { "mm_teleporter_blue_6.frames",		"1"			},
  { "mm_teleporter_blue_7",			"RocksDF.png"		},
  { "mm_teleporter_blue_7.xpos",		"6"			},
  { "mm_teleporter_blue_7.ypos",		"7"			},
  { "mm_teleporter_blue_7.frames",		"1"			},
  { "mm_teleporter_blue_8",			"RocksDF.png"		},
  { "mm_teleporter_blue_8.xpos",		"7"			},
  { "mm_teleporter_blue_8.ypos",		"7"			},
  { "mm_teleporter_blue_8.frames",		"1"			},
  { "mm_teleporter_blue_9",			"RocksDF.png"		},
  { "mm_teleporter_blue_9.xpos",		"8"			},
  { "mm_teleporter_blue_9.ypos",		"7"			},
  { "mm_teleporter_blue_9.frames",		"1"			},
  { "mm_teleporter_blue_10",			"RocksDF.png"		},
  { "mm_teleporter_blue_10.xpos",		"9"			},
  { "mm_teleporter_blue_10.ypos",		"7"			},
  { "mm_teleporter_blue_10.frames",		"1"			},
  { "mm_teleporter_blue_11",			"RocksDF.png"		},
  { "mm_teleporter_blue_11.xpos",		"10"			},
  { "mm_teleporter_blue_11.ypos",		"7"			},
  { "mm_teleporter_blue_11.frames",		"1"			},
  { "mm_teleporter_blue_12",			"RocksDF.png"		},
  { "mm_teleporter_blue_12.xpos",		"11"			},
  { "mm_teleporter_blue_12.ypos",		"7"			},
  { "mm_teleporter_blue_12.frames",		"1"			},
  { "mm_teleporter_blue_13",			"RocksDF.png"		},
  { "mm_teleporter_blue_13.xpos",		"12"			},
  { "mm_teleporter_blue_13.ypos",		"7"			},
  { "mm_teleporter_blue_13.frames",		"1"			},
  { "mm_teleporter_blue_14",			"RocksDF.png"		},
  { "mm_teleporter_blue_14.xpos",		"13"			},
  { "mm_teleporter_blue_14.ypos",		"7"			},
  { "mm_teleporter_blue_14.frames",		"1"			},
  { "mm_teleporter_blue_15",			"RocksDF.png"		},
  { "mm_teleporter_blue_15.xpos",		"14"			},
  { "mm_teleporter_blue_15.ypos",		"7"			},
  { "mm_teleporter_blue_15.frames",		"1"			},
  { "mm_teleporter_blue_16",			"RocksDF.png"		},
  { "mm_teleporter_blue_16.xpos",		"15"			},
  { "mm_teleporter_blue_16.ypos",		"7"			},
  { "mm_teleporter_blue_16.frames",		"1"			},

  { "mm_kettle",				"RocksMM.png"		},
  { "mm_kettle.xpos",				"12"			},
  { "mm_kettle.ypos",				"1"			},
  { "mm_kettle.frames",				"1"			},
  { "mm_kettle.exploding",			"RocksMM.png"		},
  { "mm_kettle.exploding.xpos",			"13"			},
  { "mm_kettle.exploding.ypos",			"1"			},
  { "mm_kettle.exploding.frames",		"3"			},
  { "mm_kettle.exploding.delay",		"4"			},
  { "mm_kettle.exploding.anim_mode",		"linear"		},

  { "mm_bomb",					"RocksMM.png"		},
  { "mm_bomb.xpos",				"5"			},
  { "mm_bomb.ypos",				"2"			},
  { "mm_bomb.frames",				"1"			},

  { "mm_prism",					"RocksMM.png"		},
  { "mm_prism.xpos",				"0"			},
  { "mm_prism.ypos",				"2"			},
  { "mm_prism.frames",				"1"			},

  { "mm_fuse",					"RocksMM.png"		},
  { "mm_fuse.xpos",				"7"			},
  { "mm_fuse.ypos",				"2"			},
  { "mm_fuse.frames",				"1"			},
  { "mm_fuse.active",				"RocksMM.png"		},
  { "mm_fuse.active.xpos",			"6"			},
  { "mm_fuse.active.ypos",			"2"			},
  { "mm_fuse.active.frames",			"1"			},

  { "mm_steel_lock",				"RocksMM.png"		},
  { "mm_steel_lock.xpos",			"8"			},
  { "mm_steel_lock.ypos",			"2"			},
  { "mm_steel_lock.frames",			"1"			},

  { "mm_wooden_lock",				"RocksMM.png"		},
  { "mm_wooden_lock.xpos",			"9"			},
  { "mm_wooden_lock.ypos",			"6"			},
  { "mm_wooden_lock.frames",			"1"			},

  { "mm_steel_block",				"RocksMM.png"		},
  { "mm_steel_block.xpos",			"8"			},
  { "mm_steel_block.ypos",			"6"			},
  { "mm_steel_block.frames",			"1"			},

  { "mm_wooden_block",				"RocksMM.png"		},
  { "mm_wooden_block.xpos",			"4"			},
  { "mm_wooden_block.ypos",			"2"			},
  { "mm_wooden_block.frames",			"1"			},

  { "mm_key",					"RocksMM.png"		},
  { "mm_key.xpos",				"9"			},
  { "mm_key.ypos",				"2"			},
  { "mm_key.frames",				"1"			},

  { "mm_lightbulb",				"RocksMM.png"		},
  { "mm_lightbulb.xpos",			"10"			},
  { "mm_lightbulb.ypos",			"2"			},
  { "mm_lightbulb.frames",			"1"			},
  { "mm_lightbulb.active",			"RocksMM.png"		},
  { "mm_lightbulb.active.xpos",			"11"			},
  { "mm_lightbulb.active.ypos",			"2"			},
  { "mm_lightbulb.active.frames",		"1"			},

  { "mm_lightball",				"RocksMM.png"		},
  { "mm_lightball.xpos",			"12"			},
  { "mm_lightball.ypos",			"2"			},
  { "mm_lightball.frames",			"3"			},
  { "mm_lightball.delay",			"1000000"		},
  { "mm_lightball.anim_mode",			"random"		},
  { "mm_lightball_red",				"RocksMM.png"		},
  { "mm_lightball_red.xpos",			"12"			},
  { "mm_lightball_red.ypos",			"2"			},
  { "mm_lightball_red.frames",			"1"			},
  { "mm_lightball_blue",			"RocksMM.png"		},
  { "mm_lightball_blue.xpos",			"13"			},
  { "mm_lightball_blue.ypos",			"2"			},
  { "mm_lightball_blue.frames",			"1"			},
  { "mm_lightball_yellow",			"RocksMM.png"		},
  { "mm_lightball_yellow.xpos",			"14"			},
  { "mm_lightball_yellow.ypos",			"2"			},
  { "mm_lightball_yellow.frames",		"1"			},

  { "mm_gray_ball",				"RocksMM.png"		},
  { "mm_gray_ball.xpos",			"15"			},
  { "mm_gray_ball.ypos",			"2"			},
  { "mm_gray_ball.frames",			"1"			},

  { "mm_fuel_full",				"RocksMM.png"		},
  { "mm_fuel_full.xpos",			"10"			},
  { "mm_fuel_full.ypos",			"6"			},
  { "mm_fuel_full.frames",			"1"			},
  { "mm_fuel_empty",				"RocksMM.png"		},
  { "mm_fuel_empty.xpos",			"11"			},
  { "mm_fuel_empty.ypos",			"6"			},
  { "mm_fuel_empty.frames",			"1"			},

  { "mm_steel_wall",				"RocksMM.png"		},
  { "mm_steel_wall.xpos",			"0"			},
  { "mm_steel_wall.ypos",			"7"			},
  { "mm_steel_wall.frames",			"1"			},

  { "mm_wooden_wall",				"RocksMM.png"		},
  { "mm_wooden_wall.xpos",			"1"			},
  { "mm_wooden_wall.ypos",			"7"			},
  { "mm_wooden_wall.frames",			"1"			},

  { "mm_ice_wall",				"RocksMM.png"		},
  { "mm_ice_wall.xpos",				"2"			},
  { "mm_ice_wall.ypos",				"7"			},
  { "mm_ice_wall.frames",			"1"			},
  { "mm_ice_wall.shrinking",			"RocksMM.png"		},
  { "mm_ice_wall.shrinking.xpos",		"2"			},
  { "mm_ice_wall.shrinking.ypos",		"7"			},
  { "mm_ice_wall.shrinking.frames",		"5"			},
  { "mm_ice_wall.shrinking.delay",		"8"			},
  { "mm_ice_wall.shrinking.anim_mode",		"linear"		},

  { "mm_amoeba_wall",				"RocksMM.png"		},
  { "mm_amoeba_wall.xpos",			"8"			},
  { "mm_amoeba_wall.ypos",			"7"			},
  { "mm_amoeba_wall.frames",			"1"			},
  { "mm_amoeba_wall.growing",			"RocksMM.png"		},
  { "mm_amoeba_wall.growing.xpos",		"8"			},
  { "mm_amoeba_wall.growing.ypos",		"7"			},
  { "mm_amoeba_wall.growing.frames",		"5"			},
  { "mm_amoeba_wall.growing.delay",		"8"			},
  { "mm_amoeba_wall.growing.anim_mode",		"linear,reverse"	},

  { "mm_pacman",				"RocksMM.png"		},
  { "mm_pacman.xpos",				"0"			},
  { "mm_pacman.ypos",				"4"			},
  { "mm_pacman.frames",				"1"			},
  { "mm_pacman.right",				"RocksMM.png"		},
  { "mm_pacman.right.xpos",			"0"			},
  { "mm_pacman.right.ypos",			"4"			},
  { "mm_pacman.right.frames",			"1"			},
  { "mm_pacman.up",				"RocksMM.png"		},
  { "mm_pacman.up.xpos",			"1"			},
  { "mm_pacman.up.ypos",			"4"			},
  { "mm_pacman.up.frames",			"1"			},
  { "mm_pacman.left",				"RocksMM.png"		},
  { "mm_pacman.left.xpos",			"2"			},
  { "mm_pacman.left.ypos",			"4"			},
  { "mm_pacman.left.frames",			"1"			},
  { "mm_pacman.down",				"RocksMM.png"		},
  { "mm_pacman.down.xpos",			"3"			},
  { "mm_pacman.down.ypos",			"4"			},
  { "mm_pacman.down.frames",			"1"			},
  { "mm_pacman.eating.right",			"RocksMM.png"		},
  { "mm_pacman.eating.right.xpos",		"4"			},
  { "mm_pacman.eating.right.ypos",		"4"			},
  { "mm_pacman.eating.right.frames",		"1"			},
  { "mm_pacman.eating.up",			"RocksMM.png"		},
  { "mm_pacman.eating.up.xpos",			"5"			},
  { "mm_pacman.eating.up.ypos",			"4"			},
  { "mm_pacman.eating.up.frames",		"1"			},
  { "mm_pacman.eating.left",			"RocksMM.png"		},
  { "mm_pacman.eating.left.xpos",		"6"			},
  { "mm_pacman.eating.left.ypos",		"4"			},
  { "mm_pacman.eating.left.frames",		"1"			},
  { "mm_pacman.eating.down",			"RocksMM.png"		},
  { "mm_pacman.eating.down.xpos",		"7"			},
  { "mm_pacman.eating.down.ypos",		"4"			},
  { "mm_pacman.eating.down.frames",		"1"			},

  { "mm_mask_mcduffin.right",			"RocksMM.png"		},
  { "mm_mask_mcduffin.right.xpos",		"8"			},
  { "mm_mask_mcduffin.right.ypos",		"8"			},
  { "mm_mask_mcduffin.right.frames",		"1"			},
  { "mm_mask_mcduffin.up",			"RocksMM.png"		},
  { "mm_mask_mcduffin.up.xpos",			"9"			},
  { "mm_mask_mcduffin.up.ypos",			"8"			},
  { "mm_mask_mcduffin.up.frames",		"1"			},
  { "mm_mask_mcduffin.left",			"RocksMM.png"		},
  { "mm_mask_mcduffin.left.xpos",		"10"			},
  { "mm_mask_mcduffin.left.ypos",		"8"			},
  { "mm_mask_mcduffin.left.frames",		"1"			},
  { "mm_mask_mcduffin.down",			"RocksMM.png"		},
  { "mm_mask_mcduffin.down.xpos",		"11"			},
  { "mm_mask_mcduffin.down.ypos",		"8"			},
  { "mm_mask_mcduffin.down.frames",		"1"			},

  { "mm_mask_grid_1",				"RocksMM.png"		},
  { "mm_mask_grid_1.xpos",			"4"			},
  { "mm_mask_grid_1.ypos",			"8"			},
  { "mm_mask_grid_1.frames",			"1"			},
  { "mm_mask_grid_2",				"RocksMM.png"		},
  { "mm_mask_grid_2.xpos",			"5"			},
  { "mm_mask_grid_2.ypos",			"8"			},
  { "mm_mask_grid_2.frames",			"1"			},
  { "mm_mask_grid_3",				"RocksMM.png"		},
  { "mm_mask_grid_3.xpos",			"6"			},
  { "mm_mask_grid_3.ypos",			"8"			},
  { "mm_mask_grid_3.frames",			"1"			},
  { "mm_mask_grid_4",				"RocksMM.png"		},
  { "mm_mask_grid_4.xpos",			"7"			},
  { "mm_mask_grid_4.ypos",			"8"			},
  { "mm_mask_grid_4.frames",			"1"			},

  { "mm_mask_rectangle",			"RocksMM.png"		},
  { "mm_mask_rectangle.xpos",			"1"			},
  { "mm_mask_rectangle.ypos",			"8"			},
  { "mm_mask_rectangle.frames",			"1"			},

  { "mm_mask_circle",				"RocksMM.png"		},
  { "mm_mask_circle.xpos",			"0"			},
  { "mm_mask_circle.ypos",			"8"			},
  { "mm_mask_circle.frames",			"1"			},

  { "[mm_default].exploding",			"RocksMM.png"		},
  { "[mm_default].exploding.xpos",		"8"			},
  { "[mm_default].exploding.ypos",		"4"			},
  { "[mm_default].exploding.frames",		"8"			},
  { "[mm_default].exploding.delay",		"2"			},
  { "[mm_default].exploding.anim_mode",		"linear"		},

  { "df_laser",					"RocksDF.png"		},
  { "df_laser.xpos",				"0"			},
  { "df_laser.ypos",				"9"			},
  { "df_laser.frames",				"4"			},
  { "df_laser.delay",				"8"			},
  { "df_laser.right",				"RocksDF.png"		},
  { "df_laser.right.xpos",			"0"			},
  { "df_laser.right.ypos",			"9"			},
  { "df_laser.right.frames",			"1"			},
  { "df_laser.up",				"RocksDF.png"		},
  { "df_laser.up.xpos",				"1"			},
  { "df_laser.up.ypos",				"9"			},
  { "df_laser.up.frames",			"1"			},
  { "df_laser.left",				"RocksDF.png"		},
  { "df_laser.left.xpos",			"2"			},
  { "df_laser.left.ypos",			"9"			},
  { "df_laser.left.frames",			"1"			},
  { "df_laser.down",				"RocksDF.png"		},
  { "df_laser.down.xpos",			"3"			},
  { "df_laser.down.ypos",			"9"			},
  { "df_laser.down.frames",			"1"			},

  { "df_receiver",				"RocksDF.png"		},
  { "df_receiver.xpos",				"4"			},
  { "df_receiver.ypos",				"9"			},
  { "df_receiver.frames",			"4"			},
  { "df_receiver.delay",			"8"			},
  { "df_receiver.right",			"RocksDF.png"		},
  { "df_receiver.right.xpos",			"4"			},
  { "df_receiver.right.ypos",			"9"			},
  { "df_receiver.right.frames",			"1"			},
  { "df_receiver.up",				"RocksDF.png"		},
  { "df_receiver.up.xpos",			"5"			},
  { "df_receiver.up.ypos",			"9"			},
  { "df_receiver.up.frames",			"1"			},
  { "df_receiver.left",				"RocksDF.png"		},
  { "df_receiver.left.xpos",			"6"			},
  { "df_receiver.left.ypos",			"9"			},
  { "df_receiver.left.frames",			"1"			},
  { "df_receiver.down",				"RocksDF.png"		},
  { "df_receiver.down.xpos",			"7"			},
  { "df_receiver.down.ypos",			"9"			},
  { "df_receiver.down.frames",			"1"			},

  { "df_mirror_1",				"RocksDF.png"		},
  { "df_mirror_1.xpos",				"0"			},
  { "df_mirror_1.ypos",				"0"			},
  { "df_mirror_1.frames",			"1"			},
  { "df_mirror_2",				"RocksDF.png"		},
  { "df_mirror_2.xpos",				"1"			},
  { "df_mirror_2.ypos",				"0"			},
  { "df_mirror_2.frames",			"1"			},
  { "df_mirror_3",				"RocksDF.png"		},
  { "df_mirror_3.xpos",				"2"			},
  { "df_mirror_3.ypos",				"0"			},
  { "df_mirror_3.frames",			"1"			},
  { "df_mirror_4",				"RocksDF.png"		},
  { "df_mirror_4.xpos",				"3"			},
  { "df_mirror_4.ypos",				"0"			},
  { "df_mirror_4.frames",			"1"			},
  { "df_mirror_5",				"RocksDF.png"		},
  { "df_mirror_5.xpos",				"4"			},
  { "df_mirror_5.ypos",				"0"			},
  { "df_mirror_5.frames",			"1"			},
  { "df_mirror_6",				"RocksDF.png"		},
  { "df_mirror_6.xpos",				"5"			},
  { "df_mirror_6.ypos",				"0"			},
  { "df_mirror_6.frames",			"1"			},
  { "df_mirror_7",				"RocksDF.png"		},
  { "df_mirror_7.xpos",				"6"			},
  { "df_mirror_7.ypos",				"0"			},
  { "df_mirror_7.frames",			"1"			},
  { "df_mirror_8",				"RocksDF.png"		},
  { "df_mirror_8.xpos",				"7"			},
  { "df_mirror_8.ypos",				"0"			},
  { "df_mirror_8.frames",			"1"			},
  { "df_mirror_9",				"RocksDF.png"		},
  { "df_mirror_9.xpos",				"8"			},
  { "df_mirror_9.ypos",				"0"			},
  { "df_mirror_9.frames",			"1"			},
  { "df_mirror_10",				"RocksDF.png"		},
  { "df_mirror_10.xpos",			"9"			},
  { "df_mirror_10.ypos",			"0"			},
  { "df_mirror_10.frames",			"1"			},
  { "df_mirror_11",				"RocksDF.png"		},
  { "df_mirror_11.xpos",			"10"			},
  { "df_mirror_11.ypos",			"0"			},
  { "df_mirror_11.frames",			"1"			},
  { "df_mirror_12",				"RocksDF.png"		},
  { "df_mirror_12.xpos",			"11"			},
  { "df_mirror_12.ypos",			"0"			},
  { "df_mirror_12.frames",			"1"			},
  { "df_mirror_13",				"RocksDF.png"		},
  { "df_mirror_13.xpos",			"12"			},
  { "df_mirror_13.ypos",			"0"			},
  { "df_mirror_13.frames",			"1"			},
  { "df_mirror_14",				"RocksDF.png"		},
  { "df_mirror_14.xpos",			"13"			},
  { "df_mirror_14.ypos",			"0"			},
  { "df_mirror_14.frames",			"1"			},
  { "df_mirror_15",				"RocksDF.png"		},
  { "df_mirror_15.xpos",			"14"			},
  { "df_mirror_15.ypos",			"0"			},
  { "df_mirror_15.frames",			"1"			},
  { "df_mirror_16",				"RocksDF.png"		},
  { "df_mirror_16.xpos",			"15"			},
  { "df_mirror_16.ypos",			"0"			},
  { "df_mirror_16.frames",			"1"			},

  { "df_mirror_rotating_1",			"RocksDF.png"		},
  { "df_mirror_rotating_1.xpos",		"0"			},
  { "df_mirror_rotating_1.ypos",		"0"			},
  { "df_mirror_rotating_1.frames",		"1"			},
  { "df_mirror_rotating_1.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_1.EDITOR.xpos",		"0"			},
  { "df_mirror_rotating_1.EDITOR.ypos",		"1"			},
  { "df_mirror_rotating_1.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_2",			"RocksDF.png"		},
  { "df_mirror_rotating_2.xpos",		"1"			},
  { "df_mirror_rotating_2.ypos",		"0"			},
  { "df_mirror_rotating_2.frames",		"1"			},
  { "df_mirror_rotating_2.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_2.EDITOR.xpos",		"1"			},
  { "df_mirror_rotating_2.EDITOR.ypos",		"1"			},
  { "df_mirror_rotating_2.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_3",			"RocksDF.png"		},
  { "df_mirror_rotating_3.xpos",		"2"			},
  { "df_mirror_rotating_3.ypos",		"0"			},
  { "df_mirror_rotating_3.frames",		"1"			},
  { "df_mirror_rotating_3.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_3.EDITOR.xpos",		"2"			},
  { "df_mirror_rotating_3.EDITOR.ypos",		"1"			},
  { "df_mirror_rotating_3.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_4",			"RocksDF.png"		},
  { "df_mirror_rotating_4.xpos",		"3"			},
  { "df_mirror_rotating_4.ypos",		"0"			},
  { "df_mirror_rotating_4.frames",		"1"			},
  { "df_mirror_rotating_4.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_4.EDITOR.xpos",		"3"			},
  { "df_mirror_rotating_4.EDITOR.ypos",		"1"			},
  { "df_mirror_rotating_4.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_5",			"RocksDF.png"		},
  { "df_mirror_rotating_5.xpos",		"4"			},
  { "df_mirror_rotating_5.ypos",		"0"			},
  { "df_mirror_rotating_5.frames",		"1"			},
  { "df_mirror_rotating_5.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_5.EDITOR.xpos",		"4"			},
  { "df_mirror_rotating_5.EDITOR.ypos",		"1"			},
  { "df_mirror_rotating_5.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_6",			"RocksDF.png"		},
  { "df_mirror_rotating_6.xpos",		"5"			},
  { "df_mirror_rotating_6.ypos",		"0"			},
  { "df_mirror_rotating_6.frames",		"1"			},
  { "df_mirror_rotating_6.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_6.EDITOR.xpos",		"5"			},
  { "df_mirror_rotating_6.EDITOR.ypos",		"1"			},
  { "df_mirror_rotating_6.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_7",			"RocksDF.png"		},
  { "df_mirror_rotating_7.xpos",		"6"			},
  { "df_mirror_rotating_7.ypos",		"0"			},
  { "df_mirror_rotating_7.frames",		"1"			},
  { "df_mirror_rotating_7.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_7.EDITOR.xpos",		"6"			},
  { "df_mirror_rotating_7.EDITOR.ypos",		"1"			},
  { "df_mirror_rotating_7.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_8",			"RocksDF.png"		},
  { "df_mirror_rotating_8.xpos",		"7"			},
  { "df_mirror_rotating_8.ypos",		"0"			},
  { "df_mirror_rotating_8.frames",		"1"			},
  { "df_mirror_rotating_8.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_8.EDITOR.xpos",		"7"			},
  { "df_mirror_rotating_8.EDITOR.ypos",		"1"			},
  { "df_mirror_rotating_8.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_9",			"RocksDF.png"		},
  { "df_mirror_rotating_9.xpos",		"8"			},
  { "df_mirror_rotating_9.ypos",		"0"			},
  { "df_mirror_rotating_9.frames",		"1"			},
  { "df_mirror_rotating_9.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_9.EDITOR.xpos",		"8"			},
  { "df_mirror_rotating_9.EDITOR.ypos",		"1"			},
  { "df_mirror_rotating_9.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_10",			"RocksDF.png"		},
  { "df_mirror_rotating_10.xpos",		"9"			},
  { "df_mirror_rotating_10.ypos",		"0"			},
  { "df_mirror_rotating_10.frames",		"1"			},
  { "df_mirror_rotating_10.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_10.EDITOR.xpos",	"9"			},
  { "df_mirror_rotating_10.EDITOR.ypos",	"1"			},
  { "df_mirror_rotating_10.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_11",			"RocksDF.png"		},
  { "df_mirror_rotating_11.xpos",		"10"			},
  { "df_mirror_rotating_11.ypos",		"0"			},
  { "df_mirror_rotating_11.frames",		"1"			},
  { "df_mirror_rotating_11.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_11.EDITOR.xpos",	"10"			},
  { "df_mirror_rotating_11.EDITOR.ypos",	"1"			},
  { "df_mirror_rotating_11.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_12",			"RocksDF.png"		},
  { "df_mirror_rotating_12.xpos",		"11"			},
  { "df_mirror_rotating_12.ypos",		"0"			},
  { "df_mirror_rotating_12.frames",		"1"			},
  { "df_mirror_rotating_12.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_12.EDITOR.xpos",	"11"			},
  { "df_mirror_rotating_12.EDITOR.ypos",	"1"			},
  { "df_mirror_rotating_12.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_13",			"RocksDF.png"		},
  { "df_mirror_rotating_13.xpos",		"12"			},
  { "df_mirror_rotating_13.ypos",		"0"			},
  { "df_mirror_rotating_13.frames",		"1"			},
  { "df_mirror_rotating_13.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_13.EDITOR.xpos",	"12"			},
  { "df_mirror_rotating_13.EDITOR.ypos",	"1"			},
  { "df_mirror_rotating_13.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_14",			"RocksDF.png"		},
  { "df_mirror_rotating_14.xpos",		"13"			},
  { "df_mirror_rotating_14.ypos",		"0"			},
  { "df_mirror_rotating_14.frames",		"1"			},
  { "df_mirror_rotating_14.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_14.EDITOR.xpos",	"13"			},
  { "df_mirror_rotating_14.EDITOR.ypos",	"1"			},
  { "df_mirror_rotating_14.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_15",			"RocksDF.png"		},
  { "df_mirror_rotating_15.xpos",		"14"			},
  { "df_mirror_rotating_15.ypos",		"0"			},
  { "df_mirror_rotating_15.frames",		"1"			},
  { "df_mirror_rotating_15.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_15.EDITOR.xpos",	"14"			},
  { "df_mirror_rotating_15.EDITOR.ypos",	"1"			},
  { "df_mirror_rotating_15.EDITOR.frames",	"1"			},
  { "df_mirror_rotating_16",			"RocksDF.png"		},
  { "df_mirror_rotating_16.xpos",		"15"			},
  { "df_mirror_rotating_16.ypos",		"0"			},
  { "df_mirror_rotating_16.frames",		"1"			},
  { "df_mirror_rotating_16.EDITOR",		"RocksDF.png"		},
  { "df_mirror_rotating_16.EDITOR.xpos",	"15"			},
  { "df_mirror_rotating_16.EDITOR.ypos",	"1"			},
  { "df_mirror_rotating_16.EDITOR.frames",	"1"			},

  { "df_steel_grid_fixed_1",			"RocksDF.png"		},
  { "df_steel_grid_fixed_1.xpos",		"0"			},
  { "df_steel_grid_fixed_1.ypos",		"2"			},
  { "df_steel_grid_fixed_1.frames",		"1"			},
  { "df_steel_grid_fixed_2",			"RocksDF.png"		},
  { "df_steel_grid_fixed_2.xpos",		"1"			},
  { "df_steel_grid_fixed_2.ypos",		"2"			},
  { "df_steel_grid_fixed_2.frames",		"1"			},
  { "df_steel_grid_fixed_3",			"RocksDF.png"		},
  { "df_steel_grid_fixed_3.xpos",		"2"			},
  { "df_steel_grid_fixed_3.ypos",		"2"			},
  { "df_steel_grid_fixed_3.frames",		"1"			},
  { "df_steel_grid_fixed_4",			"RocksDF.png"		},
  { "df_steel_grid_fixed_4.xpos",		"3"			},
  { "df_steel_grid_fixed_4.ypos",		"2"			},
  { "df_steel_grid_fixed_4.frames",		"1"			},
  { "df_steel_grid_fixed_5",			"RocksDF.png"		},
  { "df_steel_grid_fixed_5.xpos",		"4"			},
  { "df_steel_grid_fixed_5.ypos",		"2"			},
  { "df_steel_grid_fixed_5.frames",		"1"			},
  { "df_steel_grid_fixed_6",			"RocksDF.png"		},
  { "df_steel_grid_fixed_6.xpos",		"5"			},
  { "df_steel_grid_fixed_6.ypos",		"2"			},
  { "df_steel_grid_fixed_6.frames",		"1"			},
  { "df_steel_grid_fixed_7",			"RocksDF.png"		},
  { "df_steel_grid_fixed_7.xpos",		"6"			},
  { "df_steel_grid_fixed_7.ypos",		"2"			},
  { "df_steel_grid_fixed_7.frames",		"1"			},
  { "df_steel_grid_fixed_8",			"RocksDF.png"		},
  { "df_steel_grid_fixed_8.xpos",		"7"			},
  { "df_steel_grid_fixed_8.ypos",		"2"			},
  { "df_steel_grid_fixed_8.frames",		"1"			},

  { "df_wooden_grid_fixed_1",			"RocksDF.png"		},
  { "df_wooden_grid_fixed_1.xpos",		"8"			},
  { "df_wooden_grid_fixed_1.ypos",		"2"			},
  { "df_wooden_grid_fixed_1.frames",		"1"			},
  { "df_wooden_grid_fixed_2",			"RocksDF.png"		},
  { "df_wooden_grid_fixed_2.xpos",		"9"			},
  { "df_wooden_grid_fixed_2.ypos",		"2"			},
  { "df_wooden_grid_fixed_2.frames",		"1"			},
  { "df_wooden_grid_fixed_3",			"RocksDF.png"		},
  { "df_wooden_grid_fixed_3.xpos",		"10"			},
  { "df_wooden_grid_fixed_3.ypos",		"2"			},
  { "df_wooden_grid_fixed_3.frames",		"1"			},
  { "df_wooden_grid_fixed_4",			"RocksDF.png"		},
  { "df_wooden_grid_fixed_4.xpos",		"11"			},
  { "df_wooden_grid_fixed_4.ypos",		"2"			},
  { "df_wooden_grid_fixed_4.frames",		"1"			},
  { "df_wooden_grid_fixed_5",			"RocksDF.png"		},
  { "df_wooden_grid_fixed_5.xpos",		"12"			},
  { "df_wooden_grid_fixed_5.ypos",		"2"			},
  { "df_wooden_grid_fixed_5.frames",		"1"			},
  { "df_wooden_grid_fixed_6",			"RocksDF.png"		},
  { "df_wooden_grid_fixed_6.xpos",		"13"			},
  { "df_wooden_grid_fixed_6.ypos",		"2"			},
  { "df_wooden_grid_fixed_6.frames",		"1"			},
  { "df_wooden_grid_fixed_7",			"RocksDF.png"		},
  { "df_wooden_grid_fixed_7.xpos",		"14"			},
  { "df_wooden_grid_fixed_7.ypos",		"2"			},
  { "df_wooden_grid_fixed_7.frames",		"1"			},
  { "df_wooden_grid_fixed_8",			"RocksDF.png"		},
  { "df_wooden_grid_fixed_8.xpos",		"15"			},
  { "df_wooden_grid_fixed_8.ypos",		"2"			},
  { "df_wooden_grid_fixed_8.frames",		"1"			},

  { "df_steel_grid_rotating_1",			"RocksDF.png"		},
  { "df_steel_grid_rotating_1.xpos",		"0"			},
  { "df_steel_grid_rotating_1.ypos",		"2"			},
  { "df_steel_grid_rotating_1.frames",		"1"			},
  { "df_steel_grid_rotating_1.EDITOR",		"RocksDF.png"		},
  { "df_steel_grid_rotating_1.EDITOR.xpos",	"0"			},
  { "df_steel_grid_rotating_1.EDITOR.ypos",	"3"			},
  { "df_steel_grid_rotating_1.EDITOR.frames",	"1"			},
  { "df_steel_grid_rotating_2",			"RocksDF.png"		},
  { "df_steel_grid_rotating_2.xpos",		"1"			},
  { "df_steel_grid_rotating_2.ypos",		"2"			},
  { "df_steel_grid_rotating_2.frames",		"1"			},
  { "df_steel_grid_rotating_2.EDITOR",		"RocksDF.png"		},
  { "df_steel_grid_rotating_2.EDITOR.xpos",	"1"			},
  { "df_steel_grid_rotating_2.EDITOR.ypos",	"3"			},
  { "df_steel_grid_rotating_2.EDITOR.frames",	"1"			},
  { "df_steel_grid_rotating_3",			"RocksDF.png"		},
  { "df_steel_grid_rotating_3.xpos",		"2"			},
  { "df_steel_grid_rotating_3.ypos",		"2"			},
  { "df_steel_grid_rotating_3.frames",		"1"			},
  { "df_steel_grid_rotating_3.EDITOR",		"RocksDF.png"		},
  { "df_steel_grid_rotating_3.EDITOR.xpos",	"2"			},
  { "df_steel_grid_rotating_3.EDITOR.ypos",	"3"			},
  { "df_steel_grid_rotating_3.EDITOR.frames",	"1"			},
  { "df_steel_grid_rotating_4",			"RocksDF.png"		},
  { "df_steel_grid_rotating_4.xpos",		"3"			},
  { "df_steel_grid_rotating_4.ypos",		"2"			},
  { "df_steel_grid_rotating_4.frames",		"1"			},
  { "df_steel_grid_rotating_4.EDITOR",		"RocksDF.png"		},
  { "df_steel_grid_rotating_4.EDITOR.xpos",	"3"			},
  { "df_steel_grid_rotating_4.EDITOR.ypos",	"3"			},
  { "df_steel_grid_rotating_4.EDITOR.frames",	"1"			},
  { "df_steel_grid_rotating_5",			"RocksDF.png"		},
  { "df_steel_grid_rotating_5.xpos",		"4"			},
  { "df_steel_grid_rotating_5.ypos",		"2"			},
  { "df_steel_grid_rotating_5.frames",		"1"			},
  { "df_steel_grid_rotating_5.EDITOR",		"RocksDF.png"		},
  { "df_steel_grid_rotating_5.EDITOR.xpos",	"4"			},
  { "df_steel_grid_rotating_5.EDITOR.ypos",	"3"			},
  { "df_steel_grid_rotating_5.EDITOR.frames",	"1"			},
  { "df_steel_grid_rotating_6",			"RocksDF.png"		},
  { "df_steel_grid_rotating_6.xpos",		"5"			},
  { "df_steel_grid_rotating_6.ypos",		"2"			},
  { "df_steel_grid_rotating_6.frames",		"1"			},
  { "df_steel_grid_rotating_6.EDITOR",		"RocksDF.png"		},
  { "df_steel_grid_rotating_6.EDITOR.xpos",	"5"			},
  { "df_steel_grid_rotating_6.EDITOR.ypos",	"3"			},
  { "df_steel_grid_rotating_6.EDITOR.frames",	"1"			},
  { "df_steel_grid_rotating_7",			"RocksDF.png"		},
  { "df_steel_grid_rotating_7.xpos",		"6"			},
  { "df_steel_grid_rotating_7.ypos",		"2"			},
  { "df_steel_grid_rotating_7.frames",		"1"			},
  { "df_steel_grid_rotating_7.EDITOR",		"RocksDF.png"		},
  { "df_steel_grid_rotating_7.EDITOR.xpos",	"6"			},
  { "df_steel_grid_rotating_7.EDITOR.ypos",	"3"			},
  { "df_steel_grid_rotating_7.EDITOR.frames",	"1"			},
  { "df_steel_grid_rotating_8",			"RocksDF.png"		},
  { "df_steel_grid_rotating_8.xpos",		"7"			},
  { "df_steel_grid_rotating_8.ypos",		"2"			},
  { "df_steel_grid_rotating_8.frames",		"1"			},
  { "df_steel_grid_rotating_8.EDITOR",		"RocksDF.png"		},
  { "df_steel_grid_rotating_8.EDITOR.xpos",	"7"			},
  { "df_steel_grid_rotating_8.EDITOR.ypos",	"3"			},
  { "df_steel_grid_rotating_8.EDITOR.frames",	"1"			},

  { "df_wooden_grid_rotating_1",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_1.xpos",		"8"			},
  { "df_wooden_grid_rotating_1.ypos",		"2"			},
  { "df_wooden_grid_rotating_1.frames",		"1"			},
  { "df_wooden_grid_rotating_1.EDITOR",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_1.EDITOR.xpos",	"8"			},
  { "df_wooden_grid_rotating_1.EDITOR.ypos",	"3"			},
  { "df_wooden_grid_rotating_1.EDITOR.frames",	"1"			},
  { "df_wooden_grid_rotating_2",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_2.xpos",		"9"			},
  { "df_wooden_grid_rotating_2.ypos",		"2"			},
  { "df_wooden_grid_rotating_2.frames",		"1"			},
  { "df_wooden_grid_rotating_2.EDITOR",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_2.EDITOR.xpos",	"9"			},
  { "df_wooden_grid_rotating_2.EDITOR.ypos",	"3"			},
  { "df_wooden_grid_rotating_2.EDITOR.frames",	"1"			},
  { "df_wooden_grid_rotating_3",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_3.xpos",		"10"			},
  { "df_wooden_grid_rotating_3.ypos",		"2"			},
  { "df_wooden_grid_rotating_3.frames",		"1"			},
  { "df_wooden_grid_rotating_3.EDITOR",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_3.EDITOR.xpos",	"10"			},
  { "df_wooden_grid_rotating_3.EDITOR.ypos",	"3"			},
  { "df_wooden_grid_rotating_3.EDITOR.frames",	"1"			},
  { "df_wooden_grid_rotating_4",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_4.xpos",		"11"			},
  { "df_wooden_grid_rotating_4.ypos",		"2"			},
  { "df_wooden_grid_rotating_4.frames",		"1"			},
  { "df_wooden_grid_rotating_4.EDITOR",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_4.EDITOR.xpos",	"11"			},
  { "df_wooden_grid_rotating_4.EDITOR.ypos",	"3"			},
  { "df_wooden_grid_rotating_4.EDITOR.frames",	"1"			},
  { "df_wooden_grid_rotating_5",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_5.xpos",		"12"			},
  { "df_wooden_grid_rotating_5.ypos",		"2"			},
  { "df_wooden_grid_rotating_5.frames",		"1"			},
  { "df_wooden_grid_rotating_5.EDITOR",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_5.EDITOR.xpos",	"12"			},
  { "df_wooden_grid_rotating_5.EDITOR.ypos",	"3"			},
  { "df_wooden_grid_rotating_5.EDITOR.frames",	"1"			},
  { "df_wooden_grid_rotating_6",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_6.xpos",		"13"			},
  { "df_wooden_grid_rotating_6.ypos",		"2"			},
  { "df_wooden_grid_rotating_6.frames",		"1"			},
  { "df_wooden_grid_rotating_6.EDITOR",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_6.EDITOR.xpos",	"13"			},
  { "df_wooden_grid_rotating_6.EDITOR.ypos",	"3"			},
  { "df_wooden_grid_rotating_6.EDITOR.frames",	"1"			},
  { "df_wooden_grid_rotating_7",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_7.xpos",		"14"			},
  { "df_wooden_grid_rotating_7.ypos",		"2"			},
  { "df_wooden_grid_rotating_7.frames",		"1"			},
  { "df_wooden_grid_rotating_7.EDITOR",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_7.EDITOR.xpos",	"14"			},
  { "df_wooden_grid_rotating_7.EDITOR.ypos",	"3"			},
  { "df_wooden_grid_rotating_7.EDITOR.frames",	"1"			},
  { "df_wooden_grid_rotating_8",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_8.xpos",		"15"			},
  { "df_wooden_grid_rotating_8.ypos",		"2"			},
  { "df_wooden_grid_rotating_8.frames",		"1"			},
  { "df_wooden_grid_rotating_8.EDITOR",		"RocksDF.png"		},
  { "df_wooden_grid_rotating_8.EDITOR.xpos",	"15"			},
  { "df_wooden_grid_rotating_8.EDITOR.ypos",	"3"			},
  { "df_wooden_grid_rotating_8.EDITOR.frames",	"1"			},

  { "df_fibre_optic_red_1",			"RocksDF.png"		},
  { "df_fibre_optic_red_1.xpos",		"8"			},
  { "df_fibre_optic_red_1.ypos",		"8"			},
  { "df_fibre_optic_red_1.frames",		"1"			},
  { "df_fibre_optic_red_1.EDITOR",		"RocksDF.png"		},
  { "df_fibre_optic_red_1.EDITOR.xpos",		"8"			},
  { "df_fibre_optic_red_1.EDITOR.ypos",		"9"			},
  { "df_fibre_optic_red_1.EDITOR.frames",	"1"			},
  { "df_fibre_optic_red_2",			"RocksDF.png"		},
  { "df_fibre_optic_red_2.xpos",		"9"			},
  { "df_fibre_optic_red_2.ypos",		"8"			},
  { "df_fibre_optic_red_2.frames",		"1"			},
  { "df_fibre_optic_red_2.EDITOR",		"RocksDF.png"		},
  { "df_fibre_optic_red_2.EDITOR.xpos",		"9"			},
  { "df_fibre_optic_red_2.EDITOR.ypos",		"9"			},
  { "df_fibre_optic_red_2.EDITOR.frames",	"1"			},
  { "df_fibre_optic_yellow_1",			"RocksDF.png"		},
  { "df_fibre_optic_yellow_1.xpos",		"10"			},
  { "df_fibre_optic_yellow_1.ypos",		"8"			},
  { "df_fibre_optic_yellow_1.frames",		"1"			},
  { "df_fibre_optic_yellow_1.EDITOR",		"RocksDF.png"		},
  { "df_fibre_optic_yellow_1.EDITOR.xpos",	"10"			},
  { "df_fibre_optic_yellow_1.EDITOR.ypos",	"9"			},
  { "df_fibre_optic_yellow_1.EDITOR.frames",	"1"			},
  { "df_fibre_optic_yellow_2",			"RocksDF.png"		},
  { "df_fibre_optic_yellow_2.xpos",		"11"			},
  { "df_fibre_optic_yellow_2.ypos",		"8"			},
  { "df_fibre_optic_yellow_2.frames",		"1"			},
  { "df_fibre_optic_yellow_2.EDITOR",		"RocksDF.png"		},
  { "df_fibre_optic_yellow_2.EDITOR.xpos",	"11"			},
  { "df_fibre_optic_yellow_2.EDITOR.ypos",	"9"			},
  { "df_fibre_optic_yellow_2.EDITOR.frames",	"1"			},
  { "df_fibre_optic_green_1",			"RocksDF.png"		},
  { "df_fibre_optic_green_1.xpos",		"12"			},
  { "df_fibre_optic_green_1.ypos",		"8"			},
  { "df_fibre_optic_green_1.frames",		"1"			},
  { "df_fibre_optic_green_1.EDITOR",		"RocksDF.png"		},
  { "df_fibre_optic_green_1.EDITOR.xpos",	"12"			},
  { "df_fibre_optic_green_1.EDITOR.ypos",	"9"			},
  { "df_fibre_optic_green_1.EDITOR.frames",	"1"			},
  { "df_fibre_optic_green_2",			"RocksDF.png"		},
  { "df_fibre_optic_green_2.xpos",		"13"			},
  { "df_fibre_optic_green_2.ypos",		"8"			},
  { "df_fibre_optic_green_2.frames",		"1"			},
  { "df_fibre_optic_green_2.EDITOR",		"RocksDF.png"		},
  { "df_fibre_optic_green_2.EDITOR.xpos",	"13"			},
  { "df_fibre_optic_green_2.EDITOR.ypos",	"9"			},
  { "df_fibre_optic_green_2.EDITOR.frames",	"1"			},
  { "df_fibre_optic_blue_1",			"RocksDF.png"		},
  { "df_fibre_optic_blue_1.xpos",		"14"			},
  { "df_fibre_optic_blue_1.ypos",		"8"			},
  { "df_fibre_optic_blue_1.frames",		"1"			},
  { "df_fibre_optic_blue_1.EDITOR",		"RocksDF.png"		},
  { "df_fibre_optic_blue_1.EDITOR.xpos",	"14"			},
  { "df_fibre_optic_blue_1.EDITOR.ypos",	"9"			},
  { "df_fibre_optic_blue_1.EDITOR.frames",	"1"			},
  { "df_fibre_optic_blue_2",			"RocksDF.png"		},
  { "df_fibre_optic_blue_2.xpos",		"15"			},
  { "df_fibre_optic_blue_2.ypos",		"8"			},
  { "df_fibre_optic_blue_2.frames",		"1"			},
  { "df_fibre_optic_blue_2.EDITOR",		"RocksDF.png"		},
  { "df_fibre_optic_blue_2.EDITOR.xpos",	"15"			},
  { "df_fibre_optic_blue_2.EDITOR.ypos",	"9"			},
  { "df_fibre_optic_blue_2.EDITOR.frames",	"1"			},

  { "df_steel_wall",				"RocksDF.png"		},
  { "df_steel_wall.xpos",			"6"			},
  { "df_steel_wall.ypos",			"8"			},
  { "df_steel_wall.frames",			"1"			},

  { "df_wooden_wall",				"RocksDF.png"		},
  { "df_wooden_wall.xpos",			"7"			},
  { "df_wooden_wall.ypos",			"8"			},
  { "df_wooden_wall.frames",			"1"			},

  { "df_refractor",				"RocksDF.png"		},
  { "df_refractor.xpos",			"1"			},
  { "df_refractor.ypos",			"8"			},
  { "df_refractor.frames",			"1"			},

  { "df_cell",					"RocksDF.png"		},
  { "df_cell.xpos",				"2"			},
  { "df_cell.ypos",				"8"			},
  { "df_cell.frames",				"1"			},

  { "df_mine",					"RocksDF.png"		},
  { "df_mine.xpos",				"4"			},
  { "df_mine.ypos",				"8"			},
  { "df_mine.frames",				"1"			},

  // (these are only defined as elements to support ".PANEL" definitions)
  { "graphic_1",				UNDEFINED_FILENAME	},
  { "graphic_2",				UNDEFINED_FILENAME	},
  { "graphic_3",				UNDEFINED_FILENAME	},
  { "graphic_4",				UNDEFINED_FILENAME	},
  { "graphic_5",				UNDEFINED_FILENAME	},
  { "graphic_6",				UNDEFINED_FILENAME	},
  { "graphic_7",				UNDEFINED_FILENAME	},
  { "graphic_8",				UNDEFINED_FILENAME	},

#include "conf_chr.c"	// include auto-generated data structure definitions
#include "conf_cus.c"	// include auto-generated data structure definitions
#include "conf_grp.c"	// include auto-generated data structure definitions


  // ==========================================================================
  // image definitions not associated with game elements (menu screens etc.)
  // ==========================================================================

  // keyword to stop parser: "NO_MORE_ELEMENT_IMAGES" <-- do not change!

  { "sp_frame_horizontal",			"RocksSP.png"		},
  { "sp_frame_horizontal.xpos",			"7"			},
  { "sp_frame_horizontal.ypos",			"14"			},
  { "sp_frame_vertical",			"RocksSP.png"		},
  { "sp_frame_vertical.xpos",			"6"			},
  { "sp_frame_vertical.ypos",			"14"			},
  { "sp_frame_corner",				"RocksSP.png"		},
  { "sp_frame_corner.xpos",			"5"			},
  { "sp_frame_corner.ypos",			"14"			},

  { "toon_1",					"RocksToons.png"	},
  { "toon_1.x",					"2"			},
  { "toon_1.y",					"72"			},
  { "toon_1.width",				"40"			},
  { "toon_1.height",				"48"			},
  { "toon_1.frames",				"8"			},
  { "toon_1.delay",				"1"			},
  { "toon_1.step_offset",			"4"			},
  { "toon_1.step_delay",			"5"			},
  { "toon_1.direction",				"right"			},
  { "toon_1.position",				"bottom"		},

  { "toon_2",					"RocksToons.png"	},
  { "toon_2.x",					"2"			},
  { "toon_2.y",					"186"			},
  { "toon_2.width",				"40"			},
  { "toon_2.height",				"48"			},
  { "toon_2.frames",				"8"			},
  { "toon_2.delay",				"1"			},
  { "toon_2.step_offset",			"4"			},
  { "toon_2.step_delay",			"5"			},
  { "toon_2.direction",				"left"			},
  { "toon_2.position",				"bottom"		},

  { "toon_3",					"RocksToons.png"	},
  { "toon_3.x",					"2"			},
  { "toon_3.y",					"125"			},
  { "toon_3.width",				"48"			},
  { "toon_3.height",				"56"			},
  { "toon_3.frames",				"8"			},
  { "toon_3.delay",				"1"			},
  { "toon_3.step_offset",			"4"			},
  { "toon_3.step_delay",			"5"			},
  { "toon_3.direction",				"right"			},
  { "toon_3.position",				"bottom"		},

  { "toon_4",					"RocksToons.png"	},
  { "toon_4.x",					"327"			},
  { "toon_4.y",					"10"			},
  { "toon_4.width",				"80"			},
  { "toon_4.height",				"110"			},
  { "toon_4.frames",				"1"			},
  { "toon_4.delay",				"1"			},
  { "toon_4.step_offset",			"1"			},
  { "toon_4.step_delay",			"1"			},
  { "toon_4.direction",				"up"			},
  { "toon_4.position",				"any"			},

  { "toon_5",					"RocksToons.png"	},
  { "toon_5.x",					"2"			},
  { "toon_5.y",					"2"			},
  { "toon_5.width",				"32"			},
  { "toon_5.height",				"30"			},
  { "toon_5.frames",				"8"			},
  { "toon_5.delay",				"2"			},
  { "toon_5.anim_mode",				"pingpong2"		},
  { "toon_5.step_offset",			"2"			},
  { "toon_5.step_delay",			"1"			},
  { "toon_5.direction",				"right"			},
  { "toon_5.position",				"upper"			},

  { "toon_6",					"RocksToons.png"	},
  { "toon_6.x",					"2"			},
  { "toon_6.y",					"37"			},
  { "toon_6.width",				"32"			},
  { "toon_6.height",				"30"			},
  { "toon_6.frames",				"8"			},
  { "toon_6.delay",				"2"			},
  { "toon_6.anim_mode",				"pingpong2"		},
  { "toon_6.step_offset",			"2"			},
  { "toon_6.step_delay",			"1"			},
  { "toon_6.direction",				"left"			},
  { "toon_6.position",				"upper"			},

  { "toon_7",					"RocksMore.png"		},
  { "toon_7.xpos",				"0"			},
  { "toon_7.ypos",				"6"			},
  { "toon_7.frames",				"16"			},
  { "toon_7.delay",				"2"			},
  { "toon_7.direction",				"down"			},
  { "toon_7.position",				"any"			},

  { "toon_8",					"RocksHeroes.png"	},
  { "toon_8.xpos",				"4"			},
  { "toon_8.ypos",				"1"			},
  { "toon_8.frames",				"4"			},
  { "toon_8.delay",				"4"			},
  { "toon_8.direction",				"right"			},
  { "toon_8.position",				"bottom"		},

  { "toon_9",					"RocksHeroes.png"	},
  { "toon_9.xpos",				"8"			},
  { "toon_9.ypos",				"7"			},
  { "toon_9.frames",				"4"			},
  { "toon_9.delay",				"2"			},
  { "toon_9.direction",				"left"			},
  { "toon_9.position",				"bottom"		},

  { "toon_10",					"RocksHeroes.png"	},
  { "toon_10.xpos",				"12"			},
  { "toon_10.ypos",				"7"			},
  { "toon_10.frames",				"4"			},
  { "toon_10.delay",				"2"			},
  { "toon_10.direction",			"right"			},
  { "toon_10.position",				"bottom"		},

  { "toon_11",					"RocksHeroes.png"	},
  { "toon_11.xpos",				"8"			},
  { "toon_11.ypos",				"5"			},
  { "toon_11.frames",				"4"			},
  { "toon_11.delay",				"2"			},
  { "toon_11.direction",			"left"			},
  { "toon_11.position",				"bottom"		},

  { "toon_12",					"RocksHeroes.png"	},
  { "toon_12.xpos",				"12"			},
  { "toon_12.ypos",				"5"			},
  { "toon_12.frames",				"4"			},
  { "toon_12.delay",				"2"			},
  { "toon_12.direction",			"right"			},
  { "toon_12.position",				"bottom"		},

  { "toon_13",					"RocksHeroes.png"	},
  { "toon_13.xpos",				"8"			},
  { "toon_13.ypos",				"1"			},
  { "toon_13.frames",				"4"			},
  { "toon_13.delay",				"2"			},
  { "toon_13.direction",			"left"			},
  { "toon_13.position",				"bottom"		},

  { "toon_14",					"RocksHeroes.png"	},
  { "toon_14.xpos",				"12"			},
  { "toon_14.ypos",				"1"			},
  { "toon_14.frames",				"4"			},
  { "toon_14.delay",				"2"			},
  { "toon_14.direction",			"right"			},
  { "toon_14.position",				"bottom"		},

  { "toon_15",					"RocksHeroes.png"	},
  { "toon_15.xpos",				"8"			},
  { "toon_15.ypos",				"3"			},
  { "toon_15.frames",				"4"			},
  { "toon_15.delay",				"2"			},
  { "toon_15.direction",			"left"			},
  { "toon_15.position",				"bottom"		},

  { "toon_16",					"RocksHeroes.png"	},
  { "toon_16.xpos",				"12"			},
  { "toon_16.ypos",				"3"			},
  { "toon_16.frames",				"4"			},
  { "toon_16.delay",				"2"			},
  { "toon_16.direction",			"right"			},
  { "toon_16.position",				"bottom"		},

  { "toon_17",					"RocksHeroes.png"	},
  { "toon_17.xpos",				"8"			},
  { "toon_17.ypos",				"9"			},
  { "toon_17.frames",				"8"			},
  { "toon_17.delay",				"2"			},
  { "toon_17.direction",			"left"			},
  { "toon_17.position",				"any"			},

  { "toon_18",					"RocksHeroes.png"	},
  { "toon_18.xpos",				"8"			},
  { "toon_18.ypos",				"9"			},
  { "toon_18.frames",				"8"			},
  { "toon_18.delay",				"2"			},
  { "toon_18.direction",			"right"			},
  { "toon_18.position",				"any"			},

  { "toon_19",					"RocksElements.png"	},
  { "toon_19.xpos",				"8"			},
  { "toon_19.ypos",				"0"			},
  { "toon_19.frames",				"2"			},
  { "toon_19.delay",				"4"			},
  { "toon_19.direction",			"down"			},
  { "toon_19.position",				"any"			},

  { "toon_20",					"RocksElements.png"	},
  { "toon_20.xpos",				"10"			},
  { "toon_20.ypos",				"0"			},
  { "toon_20.frames",				"2"			},
  { "toon_20.delay",				"4"			},
  { "toon_20.direction",			"down"			},
  { "toon_20.position",				"any"			},

  { "gfx.global.anim_1",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_2",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_3",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_4",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_5",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_6",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_7",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_8",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_9",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_10",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_11",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_12",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_13",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_14",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_15",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_16",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_17",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_18",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_19",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_20",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_21",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_22",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_23",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_24",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_25",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_26",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_27",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_28",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_29",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_30",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_31",			UNDEFINED_FILENAME	},
  { "gfx.global.anim_32",			UNDEFINED_FILENAME	},

  { "global.anim_1",				UNDEFINED_FILENAME	},
  { "global.anim_2",				UNDEFINED_FILENAME	},
  { "global.anim_3",				UNDEFINED_FILENAME	},
  { "global.anim_4",				UNDEFINED_FILENAME	},
  { "global.anim_5",				UNDEFINED_FILENAME	},
  { "global.anim_6",				UNDEFINED_FILENAME	},
  { "global.anim_7",				UNDEFINED_FILENAME	},
  { "global.anim_8",				UNDEFINED_FILENAME	},
  { "global.anim_9",				UNDEFINED_FILENAME	},
  { "global.anim_10",				UNDEFINED_FILENAME	},
  { "global.anim_11",				UNDEFINED_FILENAME	},
  { "global.anim_12",				UNDEFINED_FILENAME	},
  { "global.anim_13",				UNDEFINED_FILENAME	},
  { "global.anim_14",				UNDEFINED_FILENAME	},
  { "global.anim_15",				UNDEFINED_FILENAME	},
  { "global.anim_16",				UNDEFINED_FILENAME	},
  { "global.anim_17",				UNDEFINED_FILENAME	},
  { "global.anim_18",				UNDEFINED_FILENAME	},
  { "global.anim_19",				UNDEFINED_FILENAME	},
  { "global.anim_20",				UNDEFINED_FILENAME	},
  { "global.anim_21",				UNDEFINED_FILENAME	},
  { "global.anim_22",				UNDEFINED_FILENAME	},
  { "global.anim_23",				UNDEFINED_FILENAME	},
  { "global.anim_24",				UNDEFINED_FILENAME	},
  { "global.anim_25",				UNDEFINED_FILENAME	},
  { "global.anim_26",				UNDEFINED_FILENAME	},
  { "global.anim_27",				UNDEFINED_FILENAME	},
  { "global.anim_28",				UNDEFINED_FILENAME	},
  { "global.anim_29",				UNDEFINED_FILENAME	},
  { "global.anim_30",				UNDEFINED_FILENAME	},
  { "global.anim_31",				UNDEFINED_FILENAME	},
  { "global.anim_32",				UNDEFINED_FILENAME	},

  { "internal.global.toon_default",		UNDEFINED_FILENAME	},
  { "internal.global.toon_default.anim_mode",	"random"		},

  { "internal.global.anim_default",		UNDEFINED_FILENAME	},

  { "menu.calibrate_red",			"RocksElements.png"	},
  { "menu.calibrate_red.xpos",			"12"			},
  { "menu.calibrate_red.ypos",			"8"			},
  { "menu.calibrate_red.frames",		"1"			},
  { "menu.calibrate_blue",			"RocksElements.png"	},
  { "menu.calibrate_blue.xpos",			"13"			},
  { "menu.calibrate_blue.ypos",			"8"			},
  { "menu.calibrate_blue.frames",		"1"			},
  { "menu.calibrate_yellow",			"RocksElements.png"	},
  { "menu.calibrate_yellow.xpos",		"14"			},
  { "menu.calibrate_yellow.ypos",		"8"			},
  { "menu.calibrate_yellow.frames",		"1"			},

  { "menu.button",				"RocksElements.png"	},
  { "menu.button.xpos",				"13"			},
  { "menu.button.ypos",				"8"			},
  { "menu.button.frames",			"1"			},
  { "menu.button.active",			"RocksElements.png"	},
  { "menu.button.active.xpos",			"12"			},
  { "menu.button.active.ypos",			"8"			},
  { "menu.button.active.frames",		"1"			},

  { "menu.button_left",				"RocksDC.png"		},
  { "menu.button_left.xpos",			"8"			},
  { "menu.button_left.ypos",			"8"			},
  { "menu.button_left.frames",			"1"			},
  { "menu.button_left.active",			"RocksDC.png"		},
  { "menu.button_left.active.xpos",		"8"			},
  { "menu.button_left.active.ypos",		"9"			},
  { "menu.button_left.active.frames",		"1"			},
  { "menu.button_right",			"RocksDC.png"		},
  { "menu.button_right.xpos",			"9"			},
  { "menu.button_right.ypos",			"8"			},
  { "menu.button_right.frames",			"1"			},
  { "menu.button_right.active",			"RocksDC.png"		},
  { "menu.button_right.active.xpos",		"9"			},
  { "menu.button_right.active.ypos",		"9"			},
  { "menu.button_right.active.frames",		"1"			},
  { "menu.button_up",				"RocksDC.png"		},
  { "menu.button_up.xpos",			"10"			},
  { "menu.button_up.ypos",			"8"			},
  { "menu.button_up.frames",			"1"			},
  { "menu.button_up.active",			"RocksDC.png"		},
  { "menu.button_up.active.xpos",		"10"			},
  { "menu.button_up.active.ypos",		"9"			},
  { "menu.button_up.active.frames",		"1"			},
  { "menu.button_down",				"RocksDC.png"		},
  { "menu.button_down.xpos",			"11"			},
  { "menu.button_down.ypos",			"8"			},
  { "menu.button_down.frames",			"1"			},
  { "menu.button_down.active",			"RocksDC.png"		},
  { "menu.button_down.active.xpos",		"11"			},
  { "menu.button_down.active.ypos",		"9"			},
  { "menu.button_down.active.frames",		"1"			},

  { "menu.button_enter_menu",			UNDEFINED_FILENAME	},
  { "menu.button_enter_menu.clone_from",	"menu.button_right"	},
  { "menu.button_enter_menu.active",		UNDEFINED_FILENAME	},
  { "menu.button_enter_menu.active.clone_from",	"menu.button_right.active" },
  { "menu.button_leave_menu",			UNDEFINED_FILENAME	},
  { "menu.button_leave_menu.clone_from",	"menu.button_left"	},
  { "menu.button_leave_menu.active",		UNDEFINED_FILENAME	},
  { "menu.button_leave_menu.active.clone_from",	"menu.button_left.active" },

  { "menu.button_next_level",			UNDEFINED_FILENAME	},
  { "menu.button_next_level.clone_from",	"menu.button_right"	},
  { "menu.button_next_level.active",		UNDEFINED_FILENAME	},
  { "menu.button_next_level.active.clone_from",	"menu.button_right.active" },
  { "menu.button_prev_level",			UNDEFINED_FILENAME	},
  { "menu.button_prev_level.clone_from",	"menu.button_left"	},
  { "menu.button_prev_level.active",		UNDEFINED_FILENAME	},
  { "menu.button_prev_level.active.clone_from",	"menu.button_left.active" },

  { "menu.button_name",				UNDEFINED_FILENAME	},
  { "menu.button_name.clone_from",		"menu.button"		},
  { "menu.button_name.active",			UNDEFINED_FILENAME	},
  { "menu.button_name.active.clone_from",	"menu.button.active"	},
  { "menu.button_levels",			UNDEFINED_FILENAME	},
  { "menu.button_levels.clone_from",		"menu.button_right"	},
  { "menu.button_levels.active",		UNDEFINED_FILENAME	},
  { "menu.button_levels.active.clone_from",	"menu.button_right.active" },
  { "menu.button_scores",			UNDEFINED_FILENAME	},
  { "menu.button_scores.clone_from",		"menu.button"		},
  { "menu.button_scores.active",		UNDEFINED_FILENAME	},
  { "menu.button_scores.active.clone_from",	"menu.button.active"	},
  { "menu.button_editor",			UNDEFINED_FILENAME	},
  { "menu.button_editor.clone_from",		"menu.button"		},
  { "menu.button_editor.active",		UNDEFINED_FILENAME	},
  { "menu.button_editor.active.clone_from",	"menu.button.active"	},
  { "menu.button_info",				UNDEFINED_FILENAME	},
  { "menu.button_info.clone_from",		"menu.button_right"	},
  { "menu.button_info.active",			UNDEFINED_FILENAME	},
  { "menu.button_info.active.clone_from",	"menu.button_right.active" },
  { "menu.button_game",				UNDEFINED_FILENAME	},
  { "menu.button_game.clone_from",		"menu.button"		},
  { "menu.button_game.active",			UNDEFINED_FILENAME	},
  { "menu.button_game.active.clone_from",	"menu.button.active"	},
  { "menu.button_setup",			UNDEFINED_FILENAME	},
  { "menu.button_setup.clone_from",		"menu.button_right"	},
  { "menu.button_setup.active",			UNDEFINED_FILENAME	},
  { "menu.button_setup.active.clone_from",	"menu.button_right.active" },
  { "menu.button_quit",				UNDEFINED_FILENAME	},
  { "menu.button_quit.clone_from",		"menu.button"		},
  { "menu.button_quit.active",			UNDEFINED_FILENAME	},
  { "menu.button_quit.active.clone_from",	"menu.button.active"	},

  { "menu.button_first_level",			UNDEFINED_FILENAME	},
  { "menu.button_first_level.active",		UNDEFINED_FILENAME	},
  { "menu.button_last_level",			UNDEFINED_FILENAME	},
  { "menu.button_last_level.active",		UNDEFINED_FILENAME	},
  { "menu.button_level_number",			UNDEFINED_FILENAME	},
  { "menu.button_level_number.active",		UNDEFINED_FILENAME	},

  { "menu.button_insert_solution",		UNDEFINED_FILENAME	},
  { "menu.button_insert_solution.active",	UNDEFINED_FILENAME	},
  { "menu.button_play_solution",		UNDEFINED_FILENAME	},
  { "menu.button_play_solution.active",		UNDEFINED_FILENAME	},

  { "menu.button_switch_ecs_aga",		UNDEFINED_FILENAME	},
  { "menu.button_switch_ecs_aga.active",	UNDEFINED_FILENAME	},

  { "menu.button_touch_back",			"RocksTouch.png"	},
  { "menu.button_touch_back.x",			"210"			},
  { "menu.button_touch_back.y",			"180"			},
  { "menu.button_touch_back.width",		"60"			},
  { "menu.button_touch_back.height",		"60"			},
  { "menu.button_touch_back.pressed_xoffset",	"-200"			},
  { "menu.button_touch_next",			"RocksTouch.png"	},
  { "menu.button_touch_next.x",			"330"			},
  { "menu.button_touch_next.y",			"180"			},
  { "menu.button_touch_next.width",		"60"			},
  { "menu.button_touch_next.height",		"60"			},
  { "menu.button_touch_next.pressed_xoffset",	"-200"			},
  { "menu.button_touch_back2",			"RocksTouch.png"	},
  { "menu.button_touch_back2.x",		"210"			},
  { "menu.button_touch_back2.y",		"180"			},
  { "menu.button_touch_back2.width",		"60"			},
  { "menu.button_touch_back2.height",		"60"			},
  { "menu.button_touch_back2.pressed_xoffset",	"-200"			},
  { "menu.button_touch_next2",			"RocksTouch.png"	},
  { "menu.button_touch_next2.x",		"330"			},
  { "menu.button_touch_next2.y",		"180"			},
  { "menu.button_touch_next2.width",		"60"			},
  { "menu.button_touch_next2.height",		"60"			},
  { "menu.button_touch_next2.pressed_xoffset", "-200"			},

  { "menu.scrollbar",				"RocksDC.png"		},
  { "menu.scrollbar.xpos",			"8"			},
  { "menu.scrollbar.ypos",			"10"			},
  { "menu.scrollbar.frames",			"1"			},
  { "menu.scrollbar.active",			"RocksDC.png"		},
  { "menu.scrollbar.active.xpos",		"9"			},
  { "menu.scrollbar.active.ypos",		"10"			},
  { "menu.scrollbar.active.frames",		"1"			},

  { "gfx.game.panel.time_anim",			"RocksDoorMM.png"	},
  { "gfx.game.panel.time_anim.x",		"5"			},
  { "gfx.game.panel.time_anim.y",		"0"			},
  { "gfx.game.panel.time_anim.width",		"90"			},
  { "gfx.game.panel.time_anim.height",		"35"			},
  { "gfx.game.panel.time_anim.frames",		"1"			},
  { "gfx.game.panel.time_anim.active",		"RocksDoorMM.png"	},
  { "gfx.game.panel.time_anim.active.x",	"105"			},
  { "gfx.game.panel.time_anim.active.y",	"0"			},
  { "gfx.game.panel.time_anim.active.width",	"90"			},
  { "gfx.game.panel.time_anim.active.height",	"35"			},
  { "gfx.game.panel.time_anim.active.frames",	"1"			},

  { "gfx.game.panel.health_anim",		"RocksDoorMM.png"	},
  { "gfx.game.panel.health_anim.x",		"5"			},
  { "gfx.game.panel.health_anim.y",		"35"			},
  { "gfx.game.panel.health_anim.width",		"90"			},
  { "gfx.game.panel.health_anim.height",	"35"			},
  { "gfx.game.panel.health_anim.frames",	"1"			},
  { "gfx.game.panel.health_anim.active",	"RocksDoorMM.png"	},
  { "gfx.game.panel.health_anim.active.x",	"105"			},
  { "gfx.game.panel.health_anim.active.y",	"35"			},
  { "gfx.game.panel.health_anim.active.width",	"90"			},
  { "gfx.game.panel.health_anim.active.height",	"35"			},
  { "gfx.game.panel.health_anim.active.frames",	"1"			},

  { "gfx.game.button.stop",			"RocksDoor.png"		},
  { "gfx.game.button.stop.x",			"305"			},
  { "gfx.game.button.stop.y",			"185"			},
  { "gfx.game.button.stop.width",		"30"			},
  { "gfx.game.button.stop.height",		"30"			},
  { "gfx.game.button.stop.pressed_xoffset",	"-100"			},
  { "gfx.game.button.pause",			"RocksDoor.png"		},
  { "gfx.game.button.pause.x",			"335"			},
  { "gfx.game.button.pause.y",			"185"			},
  { "gfx.game.button.pause.width",		"30"			},
  { "gfx.game.button.pause.height",		"30"			},
  { "gfx.game.button.pause.pressed_xoffset",	"-100"			},
  { "gfx.game.button.play",			"RocksDoor.png"		},
  { "gfx.game.button.play.x",			"365"			},
  { "gfx.game.button.play.y",			"185"			},
  { "gfx.game.button.play.width",		"30"			},
  { "gfx.game.button.play.height",		"30"			},
  { "gfx.game.button.play.pressed_xoffset",	"-100"			},

  { "gfx.game.button.undo",			"RocksDoor2.png"	},
  { "gfx.game.button.undo.x",			"105"			},
  { "gfx.game.button.undo.y",			"20"			},
  { "gfx.game.button.undo.width",		"30"			},
  { "gfx.game.button.undo.height",		"30"			},
  { "gfx.game.button.undo.pressed_xoffset",	"-100"			},
  { "gfx.game.button.redo",			"RocksDoor2.png"	},
  { "gfx.game.button.redo.x",			"165"			},
  { "gfx.game.button.redo.y",			"20"			},
  { "gfx.game.button.redo.width",		"30"			},
  { "gfx.game.button.redo.height",		"30"			},
  { "gfx.game.button.redo.pressed_xoffset",	"-100"			},

  { "gfx.game.button.save",			"RocksDoor2.png"	},
  { "gfx.game.button.save.x",			"105"			},
  { "gfx.game.button.save.y",			"50"			},
  { "gfx.game.button.save.width",		"30"			},
  { "gfx.game.button.save.height",		"30"			},
  { "gfx.game.button.save.pressed_xoffset",	"-100"			},
  { "gfx.game.button.pause2",			"RocksDoor2.png"	},
  { "gfx.game.button.pause2.x",			"135"			},
  { "gfx.game.button.pause2.y",			"50"			},
  { "gfx.game.button.pause2.width",		"30"			},
  { "gfx.game.button.pause2.height",		"30"			},
  { "gfx.game.button.pause2.pressed_xoffset",	"-100"			},
  { "gfx.game.button.pause2.active_yoffset",	"-30"			},
  { "gfx.game.button.load",			"RocksDoor2.png"	},
  { "gfx.game.button.load.x",			"165"			},
  { "gfx.game.button.load.y",			"50"			},
  { "gfx.game.button.load.width",		"30"			},
  { "gfx.game.button.load.height",		"30"			},
  { "gfx.game.button.load.pressed_xoffset",	"-100"			},

  { "gfx.game.button.sound_music",		"RocksDoor.png"		},
  { "gfx.game.button.sound_music.x",		"305"			},
  { "gfx.game.button.sound_music.y",		"245"			},
  { "gfx.game.button.sound_music.width",	"30"			},
  { "gfx.game.button.sound_music.height",	"30"			},
  { "gfx.game.button.sound_music.pressed_xoffset", "-100"		},
  { "gfx.game.button.sound_music.active_yoffset", "-30"			},
  { "gfx.game.button.sound_loops",		"RocksDoor.png"		},
  { "gfx.game.button.sound_loops.x",		"335"			},
  { "gfx.game.button.sound_loops.y",		"245"			},
  { "gfx.game.button.sound_loops.width",	"30"			},
  { "gfx.game.button.sound_loops.height",	"30"			},
  { "gfx.game.button.sound_loops.pressed_xoffset", "-100"		},
  { "gfx.game.button.sound_loops.active_yoffset", "-30"			},
  { "gfx.game.button.sound_simple",		"RocksDoor.png"		},
  { "gfx.game.button.sound_simple.x",		"365"			},
  { "gfx.game.button.sound_simple.y",		"245"			},
  { "gfx.game.button.sound_simple.width",	"30"			},
  { "gfx.game.button.sound_simple.height",	"30"			},
  { "gfx.game.button.sound_simple.pressed_xoffset", "-100"		},
  { "gfx.game.button.sound_simple.active_yoffset", "-30"		},

  { "gfx.game.button.panel_stop",		UNDEFINED_FILENAME	},
  { "gfx.game.button.panel_pause",		UNDEFINED_FILENAME	},
  { "gfx.game.button.panel_play",		UNDEFINED_FILENAME	},

  { "gfx.game.button.panel_sound_music",	UNDEFINED_FILENAME	},
  { "gfx.game.button.panel_sound_loops",	UNDEFINED_FILENAME	},
  { "gfx.game.button.panel_sound_simple",	UNDEFINED_FILENAME	},

  { "gfx.game.button.touch_stop",		"RocksTouch.png"	},
  { "gfx.game.button.touch_stop.x",		"210"			},
  { "gfx.game.button.touch_stop.y",		"120"			},
  { "gfx.game.button.touch_stop.width",		"60"			},
  { "gfx.game.button.touch_stop.height",	"60"			},
  { "gfx.game.button.touch_stop.pressed_xoffset", "-200"		},
  { "gfx.game.button.touch_pause",		"RocksTouch.png"	},
  { "gfx.game.button.touch_pause.x",		"270"			},
  { "gfx.game.button.touch_pause.y",		"120"			},
  { "gfx.game.button.touch_pause.width",	"60"			},
  { "gfx.game.button.touch_pause.height",	"60"			},
  { "gfx.game.button.touch_pause.pressed_xoffset", "-200"		},
  { "gfx.game.button.touch_pause.active_yoffset", "60"			},

  { "gfx.tape.button.eject",			"RocksDoor.png"		},
  { "gfx.tape.button.eject.x",			"305"			},
  { "gfx.tape.button.eject.y",			"357"			},
  { "gfx.tape.button.eject.width",		"18"			},
  { "gfx.tape.button.eject.height",		"18"			},
  { "gfx.tape.button.eject.pressed_xoffset",	"-100"			},
  { "gfx.tape.button.extra",			"RocksDoor.png"		},
  { "gfx.tape.button.extra.x",			"505"			},
  { "gfx.tape.button.extra.y",			"357"			},
  { "gfx.tape.button.extra.width",		"18"			},
  { "gfx.tape.button.extra.height",		"18"			},
  { "gfx.tape.button.extra.pressed_xoffset",	"-100"			},
  { "gfx.tape.button.stop",			"RocksDoor.png"		},
  { "gfx.tape.button.stop.x",			"323"			},
  { "gfx.tape.button.stop.y",			"357"			},
  { "gfx.tape.button.stop.width",		"18"			},
  { "gfx.tape.button.stop.height",		"18"			},
  { "gfx.tape.button.stop.pressed_xoffset",	"-100"			},
  { "gfx.tape.button.pause",			"RocksDoor.png"		},
  { "gfx.tape.button.pause.x",			"341"			},
  { "gfx.tape.button.pause.y",			"357"			},
  { "gfx.tape.button.pause.width",		"18"			},
  { "gfx.tape.button.pause.height",		"18"			},
  { "gfx.tape.button.pause.pressed_xoffset",	"-100"			},
  { "gfx.tape.button.record",			"RocksDoor.png"		},
  { "gfx.tape.button.record.x",			"359"			},
  { "gfx.tape.button.record.y",			"357"			},
  { "gfx.tape.button.record.width",		"18"			},
  { "gfx.tape.button.record.height",		"18"			},
  { "gfx.tape.button.record.pressed_xoffset",	"-100"			},
  { "gfx.tape.button.play",			"RocksDoor.png"		},
  { "gfx.tape.button.play.x",			"377"			},
  { "gfx.tape.button.play.y",			"357"			},
  { "gfx.tape.button.play.width",		"18"			},
  { "gfx.tape.button.play.height",		"18"			},
  { "gfx.tape.button.play.pressed_xoffset",	"-100"			},

  { "gfx.tape.button.insert_solution",		UNDEFINED_FILENAME	},
  { "gfx.tape.button.play_solution",		UNDEFINED_FILENAME	},

  { "gfx.tape.symbol.eject",			UNDEFINED_FILENAME	},
  { "gfx.tape.symbol.stop",			UNDEFINED_FILENAME	},
  { "gfx.tape.symbol.pause",			"RocksDoor.png"		},
  { "gfx.tape.symbol.pause.x",			"340"			},
  { "gfx.tape.symbol.pause.y",			"321"			},
  { "gfx.tape.symbol.pause.width",		"17"			},
  { "gfx.tape.symbol.pause.height",		"13"			},
  { "gfx.tape.symbol.record",			"RocksDoor.png"		},
  { "gfx.tape.symbol.record.x",			"325"			},
  { "gfx.tape.symbol.record.y",			"321"			},
  { "gfx.tape.symbol.record.width",		"16"			},
  { "gfx.tape.symbol.record.height",		"16"			},
  { "gfx.tape.symbol.play",			"RocksDoor.png"		},
  { "gfx.tape.symbol.play.x",			"357"			},
  { "gfx.tape.symbol.play.y",			"321"			},
  { "gfx.tape.symbol.play.width",		"11"			},
  { "gfx.tape.symbol.play.height",		"13"			},
  { "gfx.tape.symbol.fast_forward",		"RocksDoor.png"		},
  { "gfx.tape.symbol.fast_forward.x",		"539"			},
  { "gfx.tape.symbol.fast_forward.y",		"193"			},
  { "gfx.tape.symbol.fast_forward.width",	"27"			},
  { "gfx.tape.symbol.fast_forward.height",	"13"			},
  { "gfx.tape.symbol.warp_forward",		"RocksDoor.png"		},
  { "gfx.tape.symbol.warp_forward.x",		"539"			},
  { "gfx.tape.symbol.warp_forward.y",		"152"			},
  { "gfx.tape.symbol.warp_forward.width",	"27"			},
  { "gfx.tape.symbol.warp_forward.height",	"13"			},
  { "gfx.tape.symbol.warp_forward_blind",	"RocksDoor.png"		},
  { "gfx.tape.symbol.warp_forward_blind.x",	"539"			},
  { "gfx.tape.symbol.warp_forward_blind.y",	"165"			},
  { "gfx.tape.symbol.warp_forward_blind.width",	"27"			},
  { "gfx.tape.symbol.warp_forward_blind.height","13"			},
  { "gfx.tape.symbol.pause_before_end",		"RocksDoor.png"		},
  { "gfx.tape.symbol.pause_before_end.x",	"539"			},
  { "gfx.tape.symbol.pause_before_end.y",	"221"			},
  { "gfx.tape.symbol.pause_before_end.width",	"27"			},
  { "gfx.tape.symbol.pause_before_end.height",	"13"			},
  { "gfx.tape.symbol.single_step",		UNDEFINED_FILENAME	},

  { "gfx.tape.label.eject",			UNDEFINED_FILENAME	},
  { "gfx.tape.label.stop",			UNDEFINED_FILENAME	},
  { "gfx.tape.label.pause",			"RocksDoor.png"		},
  { "gfx.tape.label.pause.x",			"305"			},
  { "gfx.tape.label.pause.y",			"341"			},
  { "gfx.tape.label.pause.width",		"35"			},
  { "gfx.tape.label.pause.height",		"8"			},
  { "gfx.tape.label.record",			"RocksDoor.png"		},
  { "gfx.tape.label.record.x",			"305"			},
  { "gfx.tape.label.record.y",			"321"			},
  { "gfx.tape.label.record.width",		"20"			},
  { "gfx.tape.label.record.height",		"12"			},
  { "gfx.tape.label.play",			"RocksDoor.png"		},
  { "gfx.tape.label.play.x",			"370"			},
  { "gfx.tape.label.play.y",			"321"			},
  { "gfx.tape.label.play.width",		"22"			},
  { "gfx.tape.label.play.height",		"12"			},
  { "gfx.tape.label.fast_forward",		"RocksDoor.png"		},
  { "gfx.tape.label.fast_forward.x",		"505"			},
  { "gfx.tape.label.fast_forward.y",		"193"			},
  { "gfx.tape.label.fast_forward.width",	"40"			},
  { "gfx.tape.label.fast_forward.height",	"28"			},
  { "gfx.tape.label.warp_forward",		"RocksDoor.png"		},
  { "gfx.tape.label.warp_forward.x",		"505"			},
  { "gfx.tape.label.warp_forward.y",		"165"			},
  { "gfx.tape.label.warp_forward.width",	"40"			},
  { "gfx.tape.label.warp_forward.height",	"28"			},
  { "gfx.tape.label.warp_forward_blind",	"RocksDoor.png"		},
  { "gfx.tape.label.warp_forward_blind.x",	"505"			},
  { "gfx.tape.label.warp_forward_blind.y",	"165"			},
  { "gfx.tape.label.warp_forward_blind.width",	"40"			},
  { "gfx.tape.label.warp_forward_blind.height",	"28"			},
  { "gfx.tape.label.pause_before_end",		"RocksDoor.png"		},
  { "gfx.tape.label.pause_before_end.x",	"505"			},
  { "gfx.tape.label.pause_before_end.y",	"221"			},
  { "gfx.tape.label.pause_before_end.width",	"40"			},
  { "gfx.tape.label.pause_before_end.height",	"28"			},
  { "gfx.tape.label.single_step",		"RocksDoor.png"		},
  { "gfx.tape.label.single_step.x",		"557"			},
  { "gfx.tape.label.single_step.y",		"139"			},
  { "gfx.tape.label.single_step.width",		"38"			},
  { "gfx.tape.label.single_step.height",	"13"			},

  { "gfx.tape.label.date",			"RocksDoor.png"		},
  { "gfx.tape.label.date.x",			"305"			},
  { "gfx.tape.label.date.y",			"285"			},
  { "gfx.tape.label.date.width",		"90"			},
  { "gfx.tape.label.date.height",		"31"			},
  { "gfx.tape.label.time",			"RocksDoor.png"		},
  { "gfx.tape.label.time.x",			"346"			},
  { "gfx.tape.label.time.y",			"335"			},
  { "gfx.tape.label.time.width",		"45"			},
  { "gfx.tape.label.time.height",		"13"			},

  { "gfx.request.button.yes",			"RocksDoor.png"		},
  { "gfx.request.button.yes.x",			"302"			},
  { "gfx.request.button.yes.y",			"0"			},
  { "gfx.request.button.yes.width",		"46"			},
  { "gfx.request.button.yes.height",		"28"			},
  { "gfx.request.button.yes.pressed_xoffset",	"-100"			},
  { "gfx.request.button.no",			"RocksDoor.png"		},
  { "gfx.request.button.no.x",			"352"			},
  { "gfx.request.button.no.y",			"0"			},
  { "gfx.request.button.no.width",		"46"			},
  { "gfx.request.button.no.height",		"28"			},
  { "gfx.request.button.no.pressed_xoffset",	"-100"			},
  { "gfx.request.button.confirm",		"RocksDoor.png"		},
  { "gfx.request.button.confirm.x",		"302"			},
  { "gfx.request.button.confirm.y",		"30"			},
  { "gfx.request.button.confirm.width",		"96"			},
  { "gfx.request.button.confirm.height",	"28"			},
  { "gfx.request.button.confirm.pressed_xoffset", "-100"		},
  { "gfx.request.button.player_1",		"RocksDoor.png"		},
  { "gfx.request.button.player_1.x",		"305"			},
  { "gfx.request.button.player_1.y",		"185"			},
  { "gfx.request.button.player_1.width",	"30"			},
  { "gfx.request.button.player_1.height",	"30"			},
  { "gfx.request.button.player_1.pressed_xoffset", "-100"		},
  { "gfx.request.button.player_2",		UNDEFINED_FILENAME	},
  { "gfx.request.button.player_2.clone_from",	"gfx.request.button.player_1" },
  { "gfx.request.button.player_3",		UNDEFINED_FILENAME	},
  { "gfx.request.button.player_3.clone_from",	"gfx.request.button.player_1" },
  { "gfx.request.button.player_4",		UNDEFINED_FILENAME	},
  { "gfx.request.button.player_4.clone_from",	"gfx.request.button.player_1" },

  { "gfx.request.button.touch_yes",		"RocksTouch.png"	},
  { "gfx.request.button.touch_yes.x",		"204"			},
  { "gfx.request.button.touch_yes.y",		"0"			},
  { "gfx.request.button.touch_yes.width",	"92"			},
  { "gfx.request.button.touch_yes.height",	"56"			},
  { "gfx.request.button.touch_yes.pressed_xoffset", "-200"		},
  { "gfx.request.button.touch_no",		"RocksTouch.png"	},
  { "gfx.request.button.touch_no.x",		"304"			},
  { "gfx.request.button.touch_no.y",		"0"			},
  { "gfx.request.button.touch_no.width",	"92"			},
  { "gfx.request.button.touch_no.height",	"56"			},
  { "gfx.request.button.touch_no.pressed_xoffset", "-200"		},
  { "gfx.request.button.touch_confirm",		"RocksTouch.png"	},
  { "gfx.request.button.touch_confirm.x",	"204"			},
  { "gfx.request.button.touch_confirm.y",	"60"			},
  { "gfx.request.button.touch_confirm.width",	"192"			},
  { "gfx.request.button.touch_confirm.height",	"56"			},
  { "gfx.request.button.touch_confirm.pressed_xoffset", "-200"		},

  { "font.initial_1",				"RocksFontSmall.png"	},
  { "font.initial_1.x",				"0"			},
  { "font.initial_1.y",				"0"			},
  { "font.initial_1.width",			"14"			},
  { "font.initial_1.height",			"14"			},
  { "font.initial_2",				"RocksFontSmall.png"	},
  { "font.initial_2.x",				"0"			},
  { "font.initial_2.y",				"70"			},
  { "font.initial_2.width",			"14"			},
  { "font.initial_2.height",			"14"			},
  { "font.initial_3",				"RocksFontSmall.png"	},
  { "font.initial_3.x",				"0"			},
  { "font.initial_3.y",				"140"			},
  { "font.initial_3.width",			"14"			},
  { "font.initial_3.height",			"14"			},
  { "font.initial_4",				"RocksFontSmall.png"	},
  { "font.initial_4.x",				"0"			},
  { "font.initial_4.y",				"210"			},
  { "font.initial_4.width",			"14"			},
  { "font.initial_4.height",			"14"			},

  { "font.title_1",				"RocksFontBig.png"	},
  { "font.title_1.x",				"0"			},
  { "font.title_1.y",				"480"			},
  { "font.title_1.width",			"32"			},
  { "font.title_1.height",			"32"			},
  { "font.title_2",				"RocksFontSmall.png"	},
  { "font.title_2.x",				"0"			},
  { "font.title_2.y",				"0"			},
  { "font.title_2.width",			"14"			},
  { "font.title_2.height",			"14"			},
  { "font.title_2.SETUP",			UNDEFINED_FILENAME	},
  { "font.title_2.SETUP.clone_from",		"font.text_2"		},

  { "font.menu_1",				"RocksFontBig.png"	},
  { "font.menu_1.x",				"0"			},
  { "font.menu_1.y",				"320"			},
  { "font.menu_1.width",			"32"			},
  { "font.menu_1.height",			"32"			},
  { "font.menu_1.active",			"RocksFontBig.png"	},
  { "font.menu_1.active.x",			"0"			},
  { "font.menu_1.active.y",			"480"			},
  { "font.menu_1.active.width",			"32"			},
  { "font.menu_1.active.height",		"32"			},
  { "font.menu_2",				"RocksFontMedium.png"	},
  { "font.menu_2.x",				"0"			},
  { "font.menu_2.y",				"320"			},
  { "font.menu_2.width",			"16"			},
  { "font.menu_2.height",			"32"			},
  { "font.menu_2.active",			"RocksFontMedium.png"	},
  { "font.menu_2.active.x",			"0"			},
  { "font.menu_2.active.y",			"480"			},
  { "font.menu_2.active.width",			"16"			},
  { "font.menu_2.active.height",		"32"			},

  { "font.text_1",				"RocksFontSmall.png"	},
  { "font.text_1.x",				"0"			},
  { "font.text_1.y",				"140"			},
  { "font.text_1.width",			"14"			},
  { "font.text_1.height",			"14"			},
  { "font.text_1.MAIN",				UNDEFINED_FILENAME	},
  { "font.text_1.MAIN.clone_from",		"font.text_1.PREVIEW"	},
  { "font.text_1.LEVELS",			"RocksFontMedium.png"	},
  { "font.text_1.LEVELS.x",			"0"			},
  { "font.text_1.LEVELS.y",			"0"			},
  { "font.text_1.LEVELS.width",			"16"			},
  { "font.text_1.LEVELS.height",		"32"			},
  { "font.text_1.LEVELNR",			UNDEFINED_FILENAME	},
  { "font.text_1.LEVELNR.clone_from",		"font.text_1.LEVELS"	},
  { "font.text_1.SETUP",			UNDEFINED_FILENAME	},
  { "font.text_1.SETUP.clone_from",		"font.text_1.LEVELS"	},
  { "font.text_1.NAMES",			UNDEFINED_FILENAME	},
  { "font.text_1.NAMES.clone_from",		"font.input_1.MAIN"	},
  { "font.text_1.PREVIEW",			"RocksFontEM.png"	},
  { "font.text_1.PREVIEW.x",			"0"			},
  { "font.text_1.PREVIEW.y",			"160"			},
  { "font.text_1.PREVIEW.width",		"16"			},
  { "font.text_1.PREVIEW.height",		"16"			},
  { "font.text_1.SCORES",			"RocksFontMedium.png"	},
  { "font.text_1.SCORES.x",			"0"			},
  { "font.text_1.SCORES.y",			"480"			},
  { "font.text_1.SCORES.width",			"16"			},
  { "font.text_1.SCORES.height",		"32"			},
  { "font.text_1.active.SCORES",		"RocksFontMedium.png"	},
  { "font.text_1.active.SCORES.x",		"0"			},
  { "font.text_1.active.SCORES.y",		"0"			},
  { "font.text_1.active.SCORES.width",		"16"			},
  { "font.text_1.active.SCORES.height",		"32"			},
  { "font.text_1.PANEL",			UNDEFINED_FILENAME	},
  { "font.text_1.PANEL.clone_from",		"font.level_number"	},
  { "font.text_1.DOOR",				UNDEFINED_FILENAME	},
  { "font.text_1.DOOR.clone_from",		"font.level_number"	},
  { "font.text_2",				"RocksFontSmall.png"	},
  { "font.text_2.x",				"0"			},
  { "font.text_2.y",				"210"			},
  { "font.text_2.width",			"14"			},
  { "font.text_2.height",			"14"			},
  { "font.text_2.MAIN",				UNDEFINED_FILENAME	},
  { "font.text_2.MAIN.clone_from",		"font.text_2.PREVIEW"	},
  { "font.text_2.LEVELS",			"RocksFontMedium.png"	},
  { "font.text_2.LEVELS.x",			"0"			},
  { "font.text_2.LEVELS.y",			"160"			},
  { "font.text_2.LEVELS.width",			"16"			},
  { "font.text_2.LEVELS.height",		"32"			},
  { "font.text_2.LEVELNR",			UNDEFINED_FILENAME	},
  { "font.text_2.LEVELNR.clone_from",		"font.text_2.LEVELS"	},
  { "font.text_2.SETUP",			UNDEFINED_FILENAME	},
  { "font.text_2.SETUP.clone_from",		"font.text_2.LEVELS"	},
  { "font.text_2.NAMES",			UNDEFINED_FILENAME	},
  { "font.text_2.NAMES.clone_from",		"font.option_off"	},
  { "font.text_2.PREVIEW",			"RocksFontEM.png"	},
  { "font.text_2.PREVIEW.x",			"0"			},
  { "font.text_2.PREVIEW.y",			"160"			},
  { "font.text_2.PREVIEW.width",		"16"			},
  { "font.text_2.PREVIEW.height",		"16"			},
  { "font.text_2.SCORES",			"RocksFontBig.png"	},
  { "font.text_2.SCORES.x",			"0"			},
  { "font.text_2.SCORES.y",			"320"			},
  { "font.text_2.SCORES.width",			"32"			},
  { "font.text_2.SCORES.height",		"32"			},
  { "font.text_2.active.SCORES",		"RocksFontBig.png"	},
  { "font.text_2.active.SCORES.x",		"0"			},
  { "font.text_2.active.SCORES.y",		"0"			},
  { "font.text_2.active.SCORES.width",		"32"			},
  { "font.text_2.active.SCORES.height",		"32"			},
  { "font.text_3",				"RocksFontSmall.png"	},
  { "font.text_3.x",				"0"			},
  { "font.text_3.y",				"0"			},
  { "font.text_3.width",			"14"			},
  { "font.text_3.height",			"14"			},
  { "font.text_3.LEVELS",			"RocksFontMedium.png"	},
  { "font.text_3.LEVELS.x",			"0"			},
  { "font.text_3.LEVELS.y",			"320"			},
  { "font.text_3.LEVELS.width",			"16"			},
  { "font.text_3.LEVELS.height",		"32"			},
  { "font.text_3.LEVELNR",			UNDEFINED_FILENAME	},
  { "font.text_3.LEVELNR.clone_from",		"font.text_3.LEVELS"	},
  { "font.text_3.SETUP",			UNDEFINED_FILENAME	},
  { "font.text_3.SETUP.clone_from",		"font.text_3.LEVELS"	},
  { "font.text_3.NAMES",			UNDEFINED_FILENAME	},
  { "font.text_3.NAMES.clone_from",		"font.menu_1"		},
  { "font.text_3.PREVIEW",			"RocksFontEM.png"	},
  { "font.text_3.PREVIEW.x",			"0"			},
  { "font.text_3.PREVIEW.y",			"160"			},
  { "font.text_3.PREVIEW.width",		"16"			},
  { "font.text_3.PREVIEW.height",		"16"			},
  { "font.text_3.SCORES",			"RocksFontMedium.png"	},
  { "font.text_3.SCORES.x",			"0"			},
  { "font.text_3.SCORES.y",			"480"			},
  { "font.text_3.SCORES.width",			"16"			},
  { "font.text_3.SCORES.height",		"32"			},
  { "font.text_3.active.SCORES",		"RocksFontMedium.png"	},
  { "font.text_3.active.SCORES.x",		"0"			},
  { "font.text_3.active.SCORES.y",		"0"			},
  { "font.text_3.active.SCORES.width",		"16"			},
  { "font.text_3.active.SCORES.height",		"32"			},
  { "font.text_4",				"RocksFontSmall.png"	},
  { "font.text_4.x",				"0"			},
  { "font.text_4.y",				"70"			},
  { "font.text_4.width",			"14"			},
  { "font.text_4.height",			"14"			},
  { "font.text_4.MAIN",				UNDEFINED_FILENAME	},
  { "font.text_4.MAIN.clone_from",		"font.text_3.PREVIEW"	},
  { "font.text_4.LEVELS",			"RocksFontMedium.png"	},
  { "font.text_4.LEVELS.x",			"0"			},
  { "font.text_4.LEVELS.y",			"480"			},
  { "font.text_4.LEVELS.width",			"16"			},
  { "font.text_4.LEVELS.height",		"32"			},
  { "font.text_4.LEVELNR",			UNDEFINED_FILENAME	},
  { "font.text_4.LEVELNR.clone_from",		"font.text_4.LEVELS"	},
  { "font.text_4.SETUP",			UNDEFINED_FILENAME	},
  { "font.text_4.SETUP.clone_from",		"font.text_4.LEVELS"	},
  { "font.text_4.NAMES",			UNDEFINED_FILENAME	},
  { "font.text_4.NAMES.clone_from",		"font.menu_1.active"	},
  { "font.text_4.SCORES",			"RocksFontMedium.png"	},
  { "font.text_4.SCORES.x",			"0"			},
  { "font.text_4.SCORES.y",			"480"			},
  { "font.text_4.SCORES.width",			"16"			},
  { "font.text_4.SCORES.height",		"32"			},
  { "font.text_4.active.SCORES",		"RocksFontMedium.png"	},
  { "font.text_4.active.SCORES.x",		"0"			},
  { "font.text_4.active.SCORES.y",		"0"			},
  { "font.text_4.active.SCORES.width",		"16"			},
  { "font.text_4.active.SCORES.height",		"32"			},

  { "font.envelope_1",				"RocksFontEM.png"	},
  { "font.envelope_1.x",			"0"			},
  { "font.envelope_1.y",			"160"			},
  { "font.envelope_1.width",			"16"			},
  { "font.envelope_1.height",			"16"			},
  { "font.envelope_2",				"RocksFontEM.png"	},
  { "font.envelope_2.x",			"0"			},
  { "font.envelope_2.y",			"160"			},
  { "font.envelope_2.width",			"16"			},
  { "font.envelope_2.height",			"16"			},
  { "font.envelope_3",				"RocksFontEM.png"	},
  { "font.envelope_3.x",			"0"			},
  { "font.envelope_3.y",			"160"			},
  { "font.envelope_3.width",			"16"			},
  { "font.envelope_3.height",			"16"			},
  { "font.envelope_4",				"RocksFontEM.png"	},
  { "font.envelope_4.x",			"0"			},
  { "font.envelope_4.y",			"160"			},
  { "font.envelope_4.width",			"16"			},
  { "font.envelope_4.height",			"16"			},

  { "font.request",				"RocksFontSmall.png"	},
  { "font.request.x",				"0"			},
  { "font.request.y",				"210"			},
  { "font.request.width",			"14"			},
  { "font.request.height",			"14"			},

  { "font.input_1",				"RocksFontSmall.png"	},
  { "font.input_1.x",				"0"			},
  { "font.input_1.y",				"210"			},
  { "font.input_1.width",			"14"			},
  { "font.input_1.height",			"14"			},
  { "font.input_1.MAIN",			"RocksFontBig.png"	},
  { "font.input_1.MAIN.x",			"0"			},
  { "font.input_1.MAIN.y",			"0"			},
  { "font.input_1.MAIN.width",			"32"			},
  { "font.input_1.MAIN.height",			"32"			},
  { "font.input_1.NAMES",			UNDEFINED_FILENAME	},
  { "font.input_1.NAMES.clone_from",		"font.input_1.MAIN"	},
  { "font.input_1.active",			"RocksFontSmall.png"	},
  { "font.input_1.active.x",			"0"			},
  { "font.input_1.active.y",			"210"			},
  { "font.input_1.active.width",		"14"			},
  { "font.input_1.active.height",		"14"			},
  { "font.input_1.active.MAIN",			"RocksFontBig.png"	},
  { "font.input_1.active.MAIN.x",		"0"			},
  { "font.input_1.active.MAIN.y",		"480"			},
  { "font.input_1.active.MAIN.width",		"32"			},
  { "font.input_1.active.MAIN.height",		"32"			},
  { "font.input_1.active.NAMES",		UNDEFINED_FILENAME	},
  { "font.input_1.active.NAMES.clone_from",	"font.input_1.active.MAIN" },
  { "font.input_1.active.SETUP",		"RocksFontBig.png"	},
  { "font.input_1.active.SETUP.x",		"0"			},
  { "font.input_1.active.SETUP.y",		"0"			},
  { "font.input_1.active.SETUP.width",		"32"			},
  { "font.input_1.active.SETUP.height",		"32"			},
  { "font.input_2",				"RocksFontSmall.png"	},
  { "font.input_2.x",				"0"			},
  { "font.input_2.y",				"210"			},
  { "font.input_2.width",			"14"			},
  { "font.input_2.height",			"14"			},
  { "font.input_2.active",			"RocksFontSmall.png"	},
  { "font.input_2.active.x",			"0"			},
  { "font.input_2.active.y",			"210"			},
  { "font.input_2.active.width",		"14"			},
  { "font.input_2.active.height",		"14"			},

  { "font.option_off",				"RocksFontBig.png"	},
  { "font.option_off.x",			"0"			},
  { "font.option_off.y",			"160"			},
  { "font.option_off.width",			"32"			},
  { "font.option_off.height",			"32"			},
  { "font.option_off_narrow",			UNDEFINED_FILENAME	},
  { "font.option_off_narrow.clone_from",	"font.text_2.LEVELS"	},
  { "font.option_on",				"RocksFontBig.png"	},
  { "font.option_on.x",				"0"			},
  { "font.option_on.y",				"480"			},
  { "font.option_on.width",			"32"			},
  { "font.option_on.height",			"32"			},
  { "font.option_on_narrow",			UNDEFINED_FILENAME	},
  { "font.option_on_narrow.clone_from",		"font.text_4.LEVELS"	},

  { "font.value_1",				"RocksFontBig.png"	},
  { "font.value_1.x",				"0"			},
  { "font.value_1.y",				"480"			},
  { "font.value_1.width",			"32"			},
  { "font.value_1.height",			"32"			},
  { "font.value_2",				"RocksFontMedium.png"	},
  { "font.value_2.x",				"0"			},
  { "font.value_2.y",				"480"			},
  { "font.value_2.width",			"16"			},
  { "font.value_2.height",			"32"			},
  { "font.value_old",				"RocksFontBig.png"	},
  { "font.value_old.x",				"0"			},
  { "font.value_old.y",				"160"			},
  { "font.value_old.width",			"32"			},
  { "font.value_old.height",			"32"			},
  { "font.value_old_narrow",			UNDEFINED_FILENAME	},
  { "font.value_old_narrow.clone_from",		"font.text_2.LEVELS"	},
  { "font.value_narrow",			UNDEFINED_FILENAME	},
  { "font.value_narrow.clone_from",		"font.text_4.LEVELS"	},

  { "font.level_number",			"RocksFontSmall.png"	},
  { "font.level_number.x",			"0"			},
  { "font.level_number.y",			"350"			},
  { "font.level_number.width",			"10"			},
  { "font.level_number.height",			"14"			},
  { "font.level_number.active",			UNDEFINED_FILENAME	},
  { "font.level_number.active.clone_from",	"font.level_number"	},

  { "font.tape_recorder",			"RocksFontSmall.png"	},
  { "font.tape_recorder.x",			"0"			},
  { "font.tape_recorder.y",			"280"			},
  { "font.tape_recorder.width",			"11"			},
  { "font.tape_recorder.height",		"14"			},

  { "font.game_info",				"RocksFontEM.png"	},
  { "font.game_info.xpos",			"0"			},
  { "font.game_info.ypos",			"0"			},
  { "font.game_info.delay",			"10"			},

  { "font.info.elements",			UNDEFINED_FILENAME	},
  { "font.info.elements.clone_from",		"font.level_number"	},

  { "font.info.levelset",			UNDEFINED_FILENAME	},
  { "font.info.levelset.clone_from",		"font.level_number"	},

  { "font.main.network_players",		UNDEFINED_FILENAME	},
  { "font.main.network_players.clone_from",	"font.level_number"	},

  { "editor.element_border",			"RocksMore.png"		},
  { "editor.element_border.xpos",		"0"			},
  { "editor.element_border.ypos",		"2"			},
  { "editor.element_border.border_size",	"8"			},

  { "editor.element_border_input",		"RocksMore.png"		},
  { "editor.element_border_input.xpos",		"10"			},
  { "editor.element_border_input.ypos",		"7"			},
  { "editor.element_border_input.border_size",	"4"			},

  { "editor.counter.down",			"RocksDoor.png"		},
  { "editor.counter.down.x",			"302"			},
  { "editor.counter.down.y",			"60"			},
  { "editor.counter.down.width",		"20"			},
  { "editor.counter.down.height",		"20"			},
  { "editor.counter.down.pressed_xoffset",	"-100"			},

  { "editor.counter.up",			"RocksDoor.png"		},
  { "editor.counter.up.x",			"378"			},
  { "editor.counter.up.y",			"60"			},
  { "editor.counter.up.width",			"20"			},
  { "editor.counter.up.height",			"20"			},
  { "editor.counter.up.pressed_xoffset",	"-100"			},

  { "editor.counter.input",			"RocksDoor.png"		},
  { "editor.counter.input.x",			"324"			},
  { "editor.counter.input.y",			"60"			},
  { "editor.counter.input.width",		"52"			},
  { "editor.counter.input.height",		"20"			},
  { "editor.counter.input.active_xoffset",	"-100"			},
  { "editor.counter.input.border_size",		"3"			},

  { "editor.selectbox.input",			"RocksDoor.png"		},
  { "editor.selectbox.input.x",			"324"			},
  { "editor.selectbox.input.y",			"82"			},
  { "editor.selectbox.input.width",		"52"			},
  { "editor.selectbox.input.height",		"20"			},
  { "editor.selectbox.input.active_xoffset",	"-100"			},
  { "editor.selectbox.input.border_size",	"3"			},

  { "editor.selectbox.button",			UNDEFINED_FILENAME	},
  { "editor.selectbox.button.width",		"14"			},

  { "editor.checkbox",				"RocksDoor.png"		},
  { "editor.checkbox.x",			"302"			},
  { "editor.checkbox.y",			"82"			},
  { "editor.checkbox.width",			"20"			},
  { "editor.checkbox.height",			"20"			},
  { "editor.checkbox.pressed_xoffset",		"-100"			},
  { "editor.checkbox.active_xoffset",		"76"			},

  { "editor.radiobutton",			"RocksDoor.png"		},
  { "editor.radiobutton.x",			"302"			},
  { "editor.radiobutton.y",			"104"			},
  { "editor.radiobutton.width",			"20"			},
  { "editor.radiobutton.height",		"20"			},
  { "editor.radiobutton.pressed_xoffset",	"-100"			},
  { "editor.radiobutton.active_xoffset",	"76"			},

  { "editor.stickybutton",			"RocksDoor.png"		},
  { "editor.stickybutton.x",			"302"			},
  { "editor.stickybutton.y",			"126"			},
  { "editor.stickybutton.width",		"20"			},
  { "editor.stickybutton.height",		"20"			},
  { "editor.stickybutton.pressed_xoffset",	"-100"			},
  { "editor.stickybutton.active_xoffset",	"76"			},

  { "editor.tabbutton",				"RocksDoor.png"		},
  { "editor.tabbutton.x",			"324"			},
  { "editor.tabbutton.y",			"104"			},
  { "editor.tabbutton.width",			"52"			},
  { "editor.tabbutton.height",			"20"			},
  { "editor.tabbutton.pressed_xoffset",		"-100"			},
  { "editor.tabbutton.active_yoffset",		"22"			},
  { "editor.tabbutton.border_size",		"3"			},
  { "editor.tabbutton.draw_xoffset",		"2"			},

  { "editor.textbutton",			"RocksDoor.png"		},
  { "editor.textbutton.x",			"324"			},
  { "editor.textbutton.y",			"148"			},
  { "editor.textbutton.width",			"52"			},
  { "editor.textbutton.height",			"20"			},
  { "editor.textbutton.pressed_xoffset",	"-100"			},
  { "editor.textbutton.border_size",		"3"			},
  { "editor.textbutton.draw_xoffset",		"2"			},

  { "editor.input.text",			"RocksDoor.png"		},
  { "editor.input.text.x",			"324"			},
  { "editor.input.text.y",			"60"			},
  { "editor.input.text.width",			"52"			},
  { "editor.input.text.height",			"20"			},
  { "editor.input.text.active_xoffset",		"-100"			},
  { "editor.input.text.border_size",		"3"			},

  { "editor.input.textarea",			"RocksDoor.png"		},
  { "editor.input.textarea.x",			"324"			},
  { "editor.input.textarea.y",			"60"			},
  { "editor.input.textarea.width",		"52"			},
  { "editor.input.textarea.height",		"20"			},
  { "editor.input.textarea.active_xoffset",	"-100"			},
  { "editor.input.textarea.border_size",	"3"			},

  { "editor.cascade_list",			"RocksMore.png"		},
  { "editor.cascade_list.xpos",			"9"			},
  { "editor.cascade_list.ypos",			"8"			},
  { "editor.cascade_list.frames",		"1"			},
  { "editor.cascade_list.active",		"RocksMore.png"		},
  { "editor.cascade_list.active.xpos",		"10"			},
  { "editor.cascade_list.active.ypos",		"8"			},
  { "editor.cascade_list.active.frames",	"1"			},

  { "editor.palette.button",			"RocksDoor.png"		},
  { "editor.palette.button.x",			"525"			},
  { "editor.palette.button.y",			"30"			},
  { "editor.palette.button.width",		"20"			},
  { "editor.palette.button.height",		"20"			},
  { "editor.palette.button.pressed_xoffset",	"-20"			},

  { "editor.palette.scroll_up",			"RocksDoor.png"		},
  { "editor.palette.scroll_up.x",		"750"			},
  { "editor.palette.scroll_up.y",		"0"			},
  { "editor.palette.scroll_up.width",		"10"			},
  { "editor.palette.scroll_up.height",		"10"			},
  { "editor.palette.scroll_up.pressed_xoffset",	"-10"			},

  { "editor.palette.scroll_down",		"RocksDoor.png"		},
  { "editor.palette.scroll_down.x",		"750"			},
  { "editor.palette.scroll_down.y",		"10"			},
  { "editor.palette.scroll_down.width",		"10"			},
  { "editor.palette.scroll_down.height",	"10"			},
  { "editor.palette.scroll_down.pressed_xoffset", "-10"			},

  { "editor.palette.scrollbar",			"RocksDoor.png"		},
  { "editor.palette.scrollbar.x",		"750"			},
  { "editor.palette.scrollbar.y",		"20"			},
  { "editor.palette.scrollbar.width",		"10"			},
  { "editor.palette.scrollbar.height",		"10"			},
  { "editor.palette.scrollbar.pressed_xoffset",	"-10"			},
  { "editor.palette.scrollbar.border_size",	"3"			},

  { "editor.playfield.scroll_up",		"RocksDoor.png"		},
  { "editor.playfield.scroll_up.x",		"724"			},
  { "editor.playfield.scroll_up.y",		"0"			},
  { "editor.playfield.scroll_up.width",		"16"			},
  { "editor.playfield.scroll_up.height",	"16"			},
  { "editor.playfield.scroll_up.pressed_xoffset", "-16"			},

  { "editor.playfield.scroll_down",		"RocksDoor.png"		},
  { "editor.playfield.scroll_down.x",		"724"			},
  { "editor.playfield.scroll_down.y",		"16"			},
  { "editor.playfield.scroll_down.width",	"16"			},
  { "editor.playfield.scroll_down.height",	"16"			},
  { "editor.playfield.scroll_down.pressed_xoffset", "-16"		},

  { "editor.playfield.scroll_left",		"RocksDoor.png"		},
  { "editor.playfield.scroll_left.x",		"724"			},
  { "editor.playfield.scroll_left.y",		"32"			},
  { "editor.playfield.scroll_left.width",	"16"			},
  { "editor.playfield.scroll_left.height",	"16"			},
  { "editor.playfield.scroll_left.pressed_xoffset", "-16"		},

  { "editor.playfield.scroll_right",		"RocksDoor.png"		},
  { "editor.playfield.scroll_right.x",		"724"			},
  { "editor.playfield.scroll_right.y",		"48"			},
  { "editor.playfield.scroll_right.width",	"16"			},
  { "editor.playfield.scroll_right.height",	"16"			},
  { "editor.playfield.scroll_right.pressed_xoffset", "-16"		},

  { "editor.playfield.scrollbar",		"RocksDoor.png"		},
  { "editor.playfield.scrollbar.x",		"724"			},
  { "editor.playfield.scrollbar.y",		"64"			},
  { "editor.playfield.scrollbar.width",		"16"			},
  { "editor.playfield.scrollbar.height",	"16"			},
  { "editor.playfield.scrollbar.pressed_xoffset", "-16"			},
  { "editor.playfield.scrollbar.border_size",	"3"			},

  { "gfx.editor.button.prev_level",		"RocksDoor.png"		},
  { "gfx.editor.button.prev_level.x",		"724"			},
  { "gfx.editor.button.prev_level.y",		"32"			},
  { "gfx.editor.button.prev_level.width",	"16"			},
  { "gfx.editor.button.prev_level.height",	"16"			},
  { "gfx.editor.button.prev_level.pressed_xoffset", "-16"		},

  { "gfx.editor.button.next_level",		"RocksDoor.png"		},
  { "gfx.editor.button.next_level.x",		"724"			},
  { "gfx.editor.button.next_level.y",		"48"			},
  { "gfx.editor.button.next_level.width",	"16"			},
  { "gfx.editor.button.next_level.height",	"16"			},
  { "gfx.editor.button.next_level.pressed_xoffset", "-16"		},

  { "gfx.editor.button.properties",		"RocksDoor2.png"	},
  { "gfx.editor.button.properties.x",		"105"			},
  { "gfx.editor.button.properties.y",		"0"			},
  { "gfx.editor.button.properties.width",	"90"			},
  { "gfx.editor.button.properties.height",	"20"			},
  { "gfx.editor.button.properties.pressed_xoffset", "-100"		},

  { "gfx.editor.button.element_left",		"RocksDoor2.png"	},
  { "gfx.editor.button.element_left.x",		"368"			},
  { "gfx.editor.button.element_left.y",		"48"			},
  { "gfx.editor.button.element_left.width",	"16"			},
  { "gfx.editor.button.element_left.height",	"16"			},
  { "gfx.editor.button.element_left.pressed_xoffset", "0"		},

  { "gfx.editor.button.element_middle",		"RocksDoor2.png"	},
  { "gfx.editor.button.element_middle.x",	"368"			},
  { "gfx.editor.button.element_middle.y",	"48"			},
  { "gfx.editor.button.element_middle.width",	"16"			},
  { "gfx.editor.button.element_middle.height",	"16"			},
  { "gfx.editor.button.element_middle.pressed_xoffset", "0"		},

  { "gfx.editor.button.element_right",		"RocksDoor2.png"	},
  { "gfx.editor.button.element_right.x",	"368"			},
  { "gfx.editor.button.element_right.y",	"48"			},
  { "gfx.editor.button.element_right.width",	"16"			},
  { "gfx.editor.button.element_right.height",	"16"			},
  { "gfx.editor.button.element_right.pressed_xoffset", "0"		},

  { "gfx.editor.button.palette",		UNDEFINED_FILENAME	},

  { "editor.no_toolbox_button",			"RocksDoor.png"		},
  { "editor.no_toolbox_button.x",		"506"			},
  { "editor.no_toolbox_button.y",		"286"			},
  { "editor.no_toolbox_button.width",		"22"			},
  { "editor.no_toolbox_button.height",		"22"			},

  { "gfx.editor.button.draw_single",		"RocksDoor.png"		},
  { "gfx.editor.button.draw_single.x",		"706"			},
  { "gfx.editor.button.draw_single.y",		"242"			},
  { "gfx.editor.button.draw_single.width",	"22"			},
  { "gfx.editor.button.draw_single.height",	"22"			},
  { "gfx.editor.button.draw_single.pressed_xoffset", "-100"		},
  { "gfx.editor.button.draw_single.active_yoffset",  "-94"		},

  { "gfx.editor.button.draw_connected",		"RocksDoor.png"		},
  { "gfx.editor.button.draw_connected.x",	"728"			},
  { "gfx.editor.button.draw_connected.y",	"242"			},
  { "gfx.editor.button.draw_connected.width",	"22"			},
  { "gfx.editor.button.draw_connected.height",	"22"			},
  { "gfx.editor.button.draw_connected.pressed_xoffset", "-100"		},
  { "gfx.editor.button.draw_connected.active_yoffset",  "-94"		},

  { "gfx.editor.button.draw_line",		"RocksDoor.png"		},
  { "gfx.editor.button.draw_line.x",		"750"			},
  { "gfx.editor.button.draw_line.y",		"242"			},
  { "gfx.editor.button.draw_line.width",	"22"			},
  { "gfx.editor.button.draw_line.height",	"22"			},
  { "gfx.editor.button.draw_line.pressed_xoffset", "-100"		},
  { "gfx.editor.button.draw_line.active_yoffset",  "-94"		},

  { "gfx.editor.button.draw_arc",		"RocksDoor.png"		},
  { "gfx.editor.button.draw_arc.x",		"772"			},
  { "gfx.editor.button.draw_arc.y",		"242"			},
  { "gfx.editor.button.draw_arc.width",		"22"			},
  { "gfx.editor.button.draw_arc.height",	"22"			},
  { "gfx.editor.button.draw_arc.pressed_xoffset", "-100"		},
  { "gfx.editor.button.draw_arc.active_yoffset",  "-94"			},

  { "gfx.editor.button.draw_rectangle",		"RocksDoor.png"		},
  { "gfx.editor.button.draw_rectangle.x",	"706"			},
  { "gfx.editor.button.draw_rectangle.y",	"264"			},
  { "gfx.editor.button.draw_rectangle.width",	"22"			},
  { "gfx.editor.button.draw_rectangle.height",	"22"			},
  { "gfx.editor.button.draw_rectangle.pressed_xoffset", "-100"		},
  { "gfx.editor.button.draw_rectangle.active_yoffset",  "-94"		},

  { "gfx.editor.button.draw_filled_box",	"RocksDoor.png"		},
  { "gfx.editor.button.draw_filled_box.x",	"728"			},
  { "gfx.editor.button.draw_filled_box.y",	"264"			},
  { "gfx.editor.button.draw_filled_box.width",	"22"			},
  { "gfx.editor.button.draw_filled_box.height",	"22"			},
  { "gfx.editor.button.draw_filled_box.pressed_xoffset", "-100"		},
  { "gfx.editor.button.draw_filled_box.active_yoffset",  "-94"		},

  { "gfx.editor.button.rotate_up",		"RocksDoor.png"		},
  { "gfx.editor.button.rotate_up.x",		"750"			},
  { "gfx.editor.button.rotate_up.y",		"264"			},
  { "gfx.editor.button.rotate_up.width",	"22"			},
  { "gfx.editor.button.rotate_up.height",	"22"			},
  { "gfx.editor.button.rotate_up.pressed_xoffset", "-100"		},
  { "gfx.editor.button.rotate_up.active_yoffset",  "-94"		},

  { "gfx.editor.button.draw_text",		"RocksDoor.png"		},
  { "gfx.editor.button.draw_text.x",		"772"			},
  { "gfx.editor.button.draw_text.y",		"264"			},
  { "gfx.editor.button.draw_text.width",	"22"			},
  { "gfx.editor.button.draw_text.height",	"22"			},
  { "gfx.editor.button.draw_text.pressed_xoffset", "-100"		},
  { "gfx.editor.button.draw_text.active_yoffset",  "-94"		},

  { "gfx.editor.button.flood_fill",		"RocksDoor.png"		},
  { "gfx.editor.button.flood_fill.x",		"706"			},
  { "gfx.editor.button.flood_fill.y",		"286"			},
  { "gfx.editor.button.flood_fill.width",	"22"			},
  { "gfx.editor.button.flood_fill.height",	"22"			},
  { "gfx.editor.button.flood_fill.pressed_xoffset", "-100"		},
  { "gfx.editor.button.flood_fill.active_yoffset",  "-94"		},

  { "gfx.editor.button.rotate_left",		"RocksDoor.png"		},
  { "gfx.editor.button.rotate_left.x",		"728"			},
  { "gfx.editor.button.rotate_left.y",		"286"			},
  { "gfx.editor.button.rotate_left.width",	"22"			},
  { "gfx.editor.button.rotate_left.height",	"22"			},
  { "gfx.editor.button.rotate_left.pressed_xoffset", "-100"		},
  { "gfx.editor.button.rotate_left.active_yoffset",  "-94"		},

  { "gfx.editor.button.zoom_level",		"RocksDoor2.png"	},
  { "gfx.editor.button.zoom_level.x",		"350"			},
  { "gfx.editor.button.zoom_level.y",		"22"			},
  { "gfx.editor.button.zoom_level.width",	"22"			},
  { "gfx.editor.button.zoom_level.height",	"22"			},
  { "gfx.editor.button.zoom_level.pressed_xoffset", "-100"		},
  { "gfx.editor.button.zoom_level.active_yoffset",  "-22"		},

  { "gfx.editor.button.rotate_right",		"RocksDoor.png"		},
  { "gfx.editor.button.rotate_right.x",		"772"			},
  { "gfx.editor.button.rotate_right.y",		"286"			},
  { "gfx.editor.button.rotate_right.width",	"22"			},
  { "gfx.editor.button.rotate_right.height",	"22"			},
  { "gfx.editor.button.rotate_right.pressed_xoffset", "-100"		},
  { "gfx.editor.button.rotate_right.active_yoffset",  "-94"		},

  { "gfx.editor.button.draw_random",		"RocksDoor.png"		},
  { "gfx.editor.button.draw_random.x",		"706"			},
  { "gfx.editor.button.draw_random.y",		"308"			},
  { "gfx.editor.button.draw_random.width",	"22"			},
  { "gfx.editor.button.draw_random.height",	"22"			},
  { "gfx.editor.button.draw_random.pressed_xoffset", "-100"		},
  { "gfx.editor.button.draw_random.active_yoffset",  "-94"		},

  { "gfx.editor.button.grab_brush",		"RocksDoor.png"		},
  { "gfx.editor.button.grab_brush.x",		"728"			},
  { "gfx.editor.button.grab_brush.y",		"308"			},
  { "gfx.editor.button.grab_brush.width",	"22"			},
  { "gfx.editor.button.grab_brush.height",	"22"			},
  { "gfx.editor.button.grab_brush.pressed_xoffset", "-100"		},
  { "gfx.editor.button.grab_brush.active_yoffset",  "-94"		},

  { "gfx.editor.button.rotate_down",		"RocksDoor.png"		},
  { "gfx.editor.button.rotate_down.x",		"750"			},
  { "gfx.editor.button.rotate_down.y",		"308"			},
  { "gfx.editor.button.rotate_down.width",	"22"			},
  { "gfx.editor.button.rotate_down.height",	"22"			},
  { "gfx.editor.button.rotate_down.pressed_xoffset", "-100"		},
  { "gfx.editor.button.rotate_down.active_yoffset",  "-94"		},

  { "gfx.editor.button.pick_element",		"RocksDoor.png"		},
  { "gfx.editor.button.pick_element.x",		"772"			},
  { "gfx.editor.button.pick_element.y",		"308"			},
  { "gfx.editor.button.pick_element.width",	"22"			},
  { "gfx.editor.button.pick_element.height",	"22"			},
  { "gfx.editor.button.pick_element.pressed_xoffset", "-100"		},
  { "gfx.editor.button.pick_element.active_yoffset",  "-94"		},

  { "gfx.editor.button.ce_copy_from",		"RocksDoor.png"		},
  { "gfx.editor.button.ce_copy_from.x",		"528"			},
  { "gfx.editor.button.ce_copy_from.y",		"330"			},
  { "gfx.editor.button.ce_copy_from.width",	"22"			},
  { "gfx.editor.button.ce_copy_from.height",	"22"			},
  { "gfx.editor.button.ce_copy_from.pressed_xoffset", "-100"		},
  { "gfx.editor.button.ce_copy_from.active_yoffset",  "-22"		},

  { "gfx.editor.button.ce_copy_to",		"RocksDoor.png"		},
  { "gfx.editor.button.ce_copy_to.x",		"550"			},
  { "gfx.editor.button.ce_copy_to.y",		"330"			},
  { "gfx.editor.button.ce_copy_to.width",	"22"			},
  { "gfx.editor.button.ce_copy_to.height",	"22"			},
  { "gfx.editor.button.ce_copy_to.pressed_xoffset", "-100"		},
  { "gfx.editor.button.ce_copy_to.active_yoffset",  "-22"		},

  { "gfx.editor.button.ce_swap",		"RocksDoor.png"		},
  { "gfx.editor.button.ce_swap.x",		"572"			},
  { "gfx.editor.button.ce_swap.y",		"330"			},
  { "gfx.editor.button.ce_swap.width",		"22"			},
  { "gfx.editor.button.ce_swap.height",		"22"			},
  { "gfx.editor.button.ce_swap.pressed_xoffset", "-100"			},
  { "gfx.editor.button.ce_swap.active_yoffset",  "-22"			},

  { "gfx.editor.button.ce_copy",		"RocksDoor.png"		},
  { "gfx.editor.button.ce_copy.x",		"550"			},
  { "gfx.editor.button.ce_copy.y",		"286"			},
  { "gfx.editor.button.ce_copy.width",		"22"			},
  { "gfx.editor.button.ce_copy.height",		"22"			},
  { "gfx.editor.button.ce_copy.pressed_xoffset", "-100"			},

  { "gfx.editor.button.ce_paste",		"RocksDoor.png"		},
  { "gfx.editor.button.ce_paste.x",		"572"			},
  { "gfx.editor.button.ce_paste.y",		"286"			},
  { "gfx.editor.button.ce_paste.width",		"22"			},
  { "gfx.editor.button.ce_paste.height",	"22"			},
  { "gfx.editor.button.ce_paste.pressed_xoffset", "-100"		},

  { "gfx.editor.button.cp_copy",		"RocksDoor.png"		},
  { "gfx.editor.button.cp_copy.x",		"525"			},
  { "gfx.editor.button.cp_copy.y",		"50"			},
  { "gfx.editor.button.cp_copy.width",		"20"			},
  { "gfx.editor.button.cp_copy.height",		"20"			},
  { "gfx.editor.button.cp_copy.pressed_xoffset", "-20"			},

  { "gfx.editor.button.cp_paste",		"RocksDoor.png"		},
  { "gfx.editor.button.cp_paste.x",		"525"			},
  { "gfx.editor.button.cp_paste.y",		"70"			},
  { "gfx.editor.button.cp_paste.width",		"20"			},
  { "gfx.editor.button.cp_paste.height",	"20"			},
  { "gfx.editor.button.cp_paste.pressed_xoffset", "-20"			},

  { "gfx.editor.button.undo",			"RocksDoor.png"		},
  { "gfx.editor.button.undo.x",			"705"			},
  { "gfx.editor.button.undo.y",			"335"			},
  { "gfx.editor.button.undo.width",		"30"			},
  { "gfx.editor.button.undo.height",		"20"			},
  { "gfx.editor.button.undo.pressed_xoffset",	"-100"			},

  { "gfx.editor.button.conf",			"RocksDoor.png"		},
  { "gfx.editor.button.conf.x",			"735"			},
  { "gfx.editor.button.conf.y",			"335"			},
  { "gfx.editor.button.conf.width",		"30"			},
  { "gfx.editor.button.conf.height",		"20"			},
  { "gfx.editor.button.conf.pressed_xoffset",	"-100"			},

  { "gfx.editor.button.save",			"RocksDoor.png"		},
  { "gfx.editor.button.save.x",			"765"			},
  { "gfx.editor.button.save.y",			"335"			},
  { "gfx.editor.button.save.width",		"30"			},
  { "gfx.editor.button.save.height",		"20"			},
  { "gfx.editor.button.save.pressed_xoffset",	"-100"			},

  { "gfx.editor.button.clear",			"RocksDoor.png"		},
  { "gfx.editor.button.clear.x",		"705"			},
  { "gfx.editor.button.clear.y",		"355"			},
  { "gfx.editor.button.clear.width",		"30"			},
  { "gfx.editor.button.clear.height",		"20"			},
  { "gfx.editor.button.clear.pressed_xoffset",	"-100"			},

  { "gfx.editor.button.test",			"RocksDoor.png"		},
  { "gfx.editor.button.test.x",			"735"			},
  { "gfx.editor.button.test.y",			"355"			},
  { "gfx.editor.button.test.width",		"30"			},
  { "gfx.editor.button.test.height",		"20"			},
  { "gfx.editor.button.test.pressed_xoffset",	"-100"			},

  { "gfx.editor.button.exit",			"RocksDoor.png"		},
  { "gfx.editor.button.exit.x",			"765"			},
  { "gfx.editor.button.exit.y",			"355"			},
  { "gfx.editor.button.exit.width",		"30"			},
  { "gfx.editor.button.exit.height",		"20"			},
  { "gfx.editor.button.exit.pressed_xoffset",	"-100"			},

  { "gfx.editor.input.level_number",		"RocksDoor.png"		},
  { "gfx.editor.input.level_number.x",		"529"			},
  { "gfx.editor.input.level_number.y",		"5"			},
  { "gfx.editor.input.level_number.width",	"42"			},
  { "gfx.editor.input.level_number.height",	"16"			},
  { "gfx.editor.input.level_number.border_size","1"			},

  { "setup.input.text",				"RocksSP.png"		},
  { "setup.input.text.x",			"0"			},
  { "setup.input.text.y",			"0"			},
  { "setup.input.text.width",			"32"			},
  { "setup.input.text.height",			"32"			},
  { "setup.input.text.active_xoffset",		"0"			},
  { "setup.input.text.border_size",		"0"			},

  { "global.border",				"RocksScreen.png"	},
  { "global.border.MAIN",			UNDEFINED_FILENAME	},
  { "global.border.SCORES",			UNDEFINED_FILENAME	},
  { "global.border.EDITOR",			UNDEFINED_FILENAME	},
  { "global.border.PLAYING",			UNDEFINED_FILENAME	},

  { "global.door",				"RocksDoor.png"		},

  { "global.busy",				"RocksBusy.png"		},
  { "global.busy.x",				"0"			},
  { "global.busy.y",				"0"			},
  { "global.busy.width",			"32"			},
  { "global.busy.height",			"32"			},
  { "global.busy.frames",			"28"			},
  { "global.busy.frames_per_line",		"7"			},
  { "global.busy.delay",			"2"			},

  { "global.tile_cursor",			"RocksMore.png"		},
  { "global.tile_cursor.xpos",			"10"			},
  { "global.tile_cursor.ypos",			"7"			},
  { "global.tile_cursor.frames",		"1"			},

  { "background",				UNDEFINED_FILENAME	},
  { "background.TITLE_INITIAL",			UNDEFINED_FILENAME	},
  { "background.TITLE",				UNDEFINED_FILENAME	},
  { "background.MAIN",				UNDEFINED_FILENAME	},
  { "background.NAMES",				UNDEFINED_FILENAME	},
  { "background.LEVELS",			UNDEFINED_FILENAME	},
  { "background.LEVELNR",			UNDEFINED_FILENAME	},
  { "background.SCORES",			UNDEFINED_FILENAME	},
  { "background.EDITOR",			UNDEFINED_FILENAME	},
  { "background.INFO",				UNDEFINED_FILENAME	},
  { "background.INFO[ELEMENTS]",		UNDEFINED_FILENAME	},
  { "background.INFO[MUSIC]",			UNDEFINED_FILENAME	},
  { "background.INFO[CREDITS]",			UNDEFINED_FILENAME	},
  { "background.INFO[PROGRAM]",			UNDEFINED_FILENAME	},
  { "background.INFO[VERSION]",			UNDEFINED_FILENAME	},
  { "background.INFO[LEVELSET]",		UNDEFINED_FILENAME	},
  { "background.SETUP",				UNDEFINED_FILENAME	},
  { "background.PLAYING",			UNDEFINED_FILENAME	},
  { "background.DOOR",				UNDEFINED_FILENAME	},
  { "background.TAPE",				"RocksDoor.png"		},
  { "background.TAPE.x",			"200"			},
  { "background.TAPE.y",			"280"			},
  { "background.TAPE.width",			"100"			},
  { "background.TAPE.height",			"100"			},
  { "background.PANEL",				"RocksDoor.png"		},
  { "background.PANEL.x",			"400"			},
  { "background.PANEL.y",			"0"			},
  { "background.PANEL.width",			"100"			},
  { "background.PANEL.height",			"280"			},
  { "background.PALETTE",			"RocksDoor.png"		},
  { "background.PALETTE.x",			"500"			},
  { "background.PALETTE.y",			"0"			},
  { "background.PALETTE.width",			"100"			},
  { "background.PALETTE.height",		"280"			},
  { "background.TOOLBOX",			"RocksDoor.png"		},
  { "background.TOOLBOX.x",			"700"			},
  { "background.TOOLBOX.y",			"236"			},
  { "background.TOOLBOX.width",			"100"			},
  { "background.TOOLBOX.height",		"144"			},

  { "background.titlescreen_initial_1",		UNDEFINED_FILENAME	},
  { "background.titlescreen_initial_2",		UNDEFINED_FILENAME	},
  { "background.titlescreen_initial_3",		UNDEFINED_FILENAME	},
  { "background.titlescreen_initial_4",		UNDEFINED_FILENAME	},
  { "background.titlescreen_initial_5",		UNDEFINED_FILENAME	},
  { "background.titlescreen_1",			UNDEFINED_FILENAME	},
  { "background.titlescreen_2",			UNDEFINED_FILENAME	},
  { "background.titlescreen_3",			UNDEFINED_FILENAME	},
  { "background.titlescreen_4",			UNDEFINED_FILENAME	},
  { "background.titlescreen_5",			UNDEFINED_FILENAME	},
  { "background.titlemessage_initial_1",	UNDEFINED_FILENAME	},
  { "background.titlemessage_initial_2",	UNDEFINED_FILENAME	},
  { "background.titlemessage_initial_3",	UNDEFINED_FILENAME	},
  { "background.titlemessage_initial_4",	UNDEFINED_FILENAME	},
  { "background.titlemessage_initial_5",	UNDEFINED_FILENAME	},
  { "background.titlemessage_1",		UNDEFINED_FILENAME	},
  { "background.titlemessage_2",		UNDEFINED_FILENAME	},
  { "background.titlemessage_3",		UNDEFINED_FILENAME	},
  { "background.titlemessage_4",		UNDEFINED_FILENAME	},
  { "background.titlemessage_5",		UNDEFINED_FILENAME	},

  { "background.envelope_1",			"RocksScreen.png"	},
  { "background.envelope_1.x",			"0"			},
  { "background.envelope_1.y",			"0"			},
  { "background.envelope_1.width",		"560"			},
  { "background.envelope_1.height",		"560"			},
  { "background.envelope_1.anim_mode",		"default"		},
  { "background.envelope_1.draw_masked",	"false"			},
  { "background.envelope_2",			"RocksScreen.png"	},
  { "background.envelope_2.x",			"0"			},
  { "background.envelope_2.y",			"0"			},
  { "background.envelope_2.width",		"560"			},
  { "background.envelope_2.height",		"560"			},
  { "background.envelope_2.anim_mode",		"default"		},
  { "background.envelope_2.draw_masked",	"false"			},
  { "background.envelope_3",			"RocksScreen.png"	},
  { "background.envelope_3.x",			"0"			},
  { "background.envelope_3.y",			"0"			},
  { "background.envelope_3.width",		"560"			},
  { "background.envelope_3.height",		"560"			},
  { "background.envelope_3.anim_mode",		"default"		},
  { "background.envelope_3.draw_masked",	"false"			},
  { "background.envelope_4",			"RocksScreen.png"	},
  { "background.envelope_4.x",			"0"			},
  { "background.envelope_4.y",			"0"			},
  { "background.envelope_4.width",		"560"			},
  { "background.envelope_4.height",		"560"			},
  { "background.envelope_4.anim_mode",		"default"		},
  { "background.envelope_4.draw_masked",	"false"			},

  { "background.request",			"RocksScreen.png"	},
  { "background.request.x",			"562"			},
  { "background.request.y",			"56"			},
  { "background.request.width",			"108"			},
  { "background.request.height",		"288"			},
  { "background.request.anim_mode",		"default"		},
  { "background.request.draw_masked",		"false"			},

  { "titlescreen_initial_1",			UNDEFINED_FILENAME	},
  { "titlescreen_initial_2",			UNDEFINED_FILENAME	},
  { "titlescreen_initial_3",			UNDEFINED_FILENAME	},
  { "titlescreen_initial_4",			UNDEFINED_FILENAME	},
  { "titlescreen_initial_5",			UNDEFINED_FILENAME	},
  { "titlescreen_1",				UNDEFINED_FILENAME	},
  { "titlescreen_2",				UNDEFINED_FILENAME	},
  { "titlescreen_3",				UNDEFINED_FILENAME	},
  { "titlescreen_4",				UNDEFINED_FILENAME	},
  { "titlescreen_5",				UNDEFINED_FILENAME	},

  { "gfx.door_1.part_1",			"RocksDoor.png"		},
  { "gfx.door_1.part_1.x",			"0"			},
  { "gfx.door_1.part_1.y",			"0"			},
  { "gfx.door_1.part_1.width",			"100"			},
  { "gfx.door_1.part_1.height",			"77"			},
  { "gfx.door_1.part_1.frames",			"1"			},
  { "gfx.door_1.part_2",			"RocksDoor.png"		},
  { "gfx.door_1.part_2.x",			"0"			},
  { "gfx.door_1.part_2.y",			"77"			},
  { "gfx.door_1.part_2.width",			"100"			},
  { "gfx.door_1.part_2.height",			"63"			},
  { "gfx.door_1.part_2.frames",			"1"			},
  { "gfx.door_1.part_3",			"RocksDoor.png"		},
  { "gfx.door_1.part_3.x",			"0"			},
  { "gfx.door_1.part_3.y",			"140"			},
  { "gfx.door_1.part_3.width",			"100"			},
  { "gfx.door_1.part_3.height",			"63"			},
  { "gfx.door_1.part_3.frames",			"1"			},
  { "gfx.door_1.part_4",			"RocksDoor.png"		},
  { "gfx.door_1.part_4.x",			"0"			},
  { "gfx.door_1.part_4.y",			"203"			},
  { "gfx.door_1.part_4.width",			"100"			},
  { "gfx.door_1.part_4.height",			"77"			},
  { "gfx.door_1.part_4.frames",			"1"			},
  { "gfx.door_1.part_5",			"RocksDoor.png"		},
  { "gfx.door_1.part_5.x",			"100"			},
  { "gfx.door_1.part_5.y",			"0"			},
  { "gfx.door_1.part_5.width",			"100"			},
  { "gfx.door_1.part_5.height",			"77"			},
  { "gfx.door_1.part_5.frames",			"1"			},
  { "gfx.door_1.part_6",			"RocksDoor.png"		},
  { "gfx.door_1.part_6.x",			"100"			},
  { "gfx.door_1.part_6.y",			"77"			},
  { "gfx.door_1.part_6.width",			"100"			},
  { "gfx.door_1.part_6.height",			"63"			},
  { "gfx.door_1.part_6.frames",			"1"			},
  { "gfx.door_1.part_7",			"RocksDoor.png"		},
  { "gfx.door_1.part_7.x",			"100"			},
  { "gfx.door_1.part_7.y",			"140"			},
  { "gfx.door_1.part_7.width",			"100"			},
  { "gfx.door_1.part_7.height",			"63"			},
  { "gfx.door_1.part_7.frames",			"1"			},
  { "gfx.door_1.part_8",			"RocksDoor.png"		},
  { "gfx.door_1.part_8.x",			"100"			},
  { "gfx.door_1.part_8.y",			"203"			},
  { "gfx.door_1.part_8.width",			"100"			},
  { "gfx.door_1.part_8.height",			"77"			},
  { "gfx.door_1.part_8.frames",			"1"			},

  { "gfx.door_2.part_1",			"RocksDoor.png"		},
  { "gfx.door_2.part_1.x",			"0"			},
  { "gfx.door_2.part_1.y",			"280"			},
  { "gfx.door_2.part_1.width",			"100"			},
  { "gfx.door_2.part_1.height",			"50"			},
  { "gfx.door_2.part_1.frames",			"1"			},
  { "gfx.door_2.part_2",			"RocksDoor.png"		},
  { "gfx.door_2.part_2.x",			"0"			},
  { "gfx.door_2.part_2.y",			"330"			},
  { "gfx.door_2.part_2.width",			"100"			},
  { "gfx.door_2.part_2.height",			"50"			},
  { "gfx.door_2.part_2.frames",			"1"			},
  { "gfx.door_2.part_3",			"RocksDoor.png"		},
  { "gfx.door_2.part_3.x",			"100"			},
  { "gfx.door_2.part_3.y",			"280"			},
  { "gfx.door_2.part_3.width",			"100"			},
  { "gfx.door_2.part_3.height",			"50"			},
  { "gfx.door_2.part_3.frames",			"1"			},
  { "gfx.door_2.part_4",			"RocksDoor.png"		},
  { "gfx.door_2.part_4.x",			"100"			},
  { "gfx.door_2.part_4.y",			"330"			},
  { "gfx.door_2.part_4.width",			"100"			},
  { "gfx.door_2.part_4.height",			"50"			},
  { "gfx.door_2.part_4.frames",			"1"			},
  { "gfx.door_2.part_5",			UNDEFINED_FILENAME	},
  { "gfx.door_2.part_6",			UNDEFINED_FILENAME	},
  { "gfx.door_2.part_7",			UNDEFINED_FILENAME	},
  { "gfx.door_2.part_8",			UNDEFINED_FILENAME	},

  { "door_2.top_border_correction",		"RocksDoor.png"		},
  { "door_2.top_border_correction.x",		"600"			},
  { "door_2.top_border_correction.y",		"0"			},
  { "door_2.top_border_correction.width",	"108"			},
  { "door_2.top_border_correction.height",	"8"			},

  // the last image entry apparently gets overwritten by very last entry
  // of "image_config[]"; so far this bug could not be found and fixed
  { "last_image_entry_bug",			UNDEFINED_FILENAME	},


  // ==========================================================================
  // non-image definitions
  // ==========================================================================

  // the following directives are not associated with an image, but
  // probably make sense to be defined in "graphicsinfo.conf", too

  // keyword to start parser: "CONFIG_VARS_START" <-- do not change!

  { "[title_initial].fade_mode",		"fade"			},
  { "[title_initial].fade_delay",		"500"			},
  { "[title_initial].post_delay",		"250"			},
  { "[title_initial].auto_delay",		"-1"			},
  { "[title_initial].auto_delay_unit",		"ms"			},
  { "[title].fade_mode",			"fade"			},
  { "[title].fade_delay",			"500"			},
  { "[title].post_delay",			"250"			},
  { "[title].auto_delay",			"-1"			},
  { "[title].auto_delay_unit",			"ms"			},

  { "[titlescreen_initial].sort_priority",	"0"			},
  { "[titlescreen_initial].fade_mode",		ARG_DEFAULT		},
  { "[titlescreen_initial].fade_delay",		ARG_DEFAULT		},
  { "[titlescreen_initial].post_delay",		ARG_DEFAULT		},
  { "[titlescreen_initial].auto_delay",		ARG_DEFAULT		},
  { "[titlescreen_initial].auto_delay_unit",	ARG_DEFAULT		},
  { "[titlescreen].sort_priority",		"0"			},
  { "[titlescreen].fade_mode",			ARG_DEFAULT		},
  { "[titlescreen].fade_delay",			ARG_DEFAULT		},
  { "[titlescreen].post_delay",			ARG_DEFAULT		},
  { "[titlescreen].auto_delay",			ARG_DEFAULT		},
  { "[titlescreen].auto_delay_unit",		ARG_DEFAULT		},

  { "titlescreen_initial_1.sort_priority",	ARG_DEFAULT		},
  { "titlescreen_initial_1.fade_mode",		ARG_DEFAULT		},
  { "titlescreen_initial_1.fade_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_1.post_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_1.auto_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_1.auto_delay_unit",	ARG_DEFAULT		},
  { "titlescreen_initial_2.sort_priority",	ARG_DEFAULT		},
  { "titlescreen_initial_2.fade_mode",		ARG_DEFAULT		},
  { "titlescreen_initial_2.fade_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_2.post_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_2.auto_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_2.auto_delay_unit",	ARG_DEFAULT		},
  { "titlescreen_initial_3.sort_priority",	ARG_DEFAULT		},
  { "titlescreen_initial_3.fade_mode",		ARG_DEFAULT		},
  { "titlescreen_initial_3.fade_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_3.post_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_3.auto_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_3.auto_delay_unit",	ARG_DEFAULT		},
  { "titlescreen_initial_4.sort_priority",	ARG_DEFAULT		},
  { "titlescreen_initial_4.fade_mode",		ARG_DEFAULT		},
  { "titlescreen_initial_4.fade_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_4.post_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_4.auto_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_4.auto_delay_unit",	ARG_DEFAULT		},
  { "titlescreen_initial_5.sort_priority",	ARG_DEFAULT		},
  { "titlescreen_initial_5.fade_mode",		ARG_DEFAULT		},
  { "titlescreen_initial_5.fade_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_5.post_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_5.auto_delay",		ARG_DEFAULT		},
  { "titlescreen_initial_5.auto_delay_unit",	ARG_DEFAULT		},
  { "titlescreen_1.sort_priority",		ARG_DEFAULT		},
  { "titlescreen_1.fade_mode",			ARG_DEFAULT		},
  { "titlescreen_1.fade_delay",			ARG_DEFAULT		},
  { "titlescreen_1.post_delay",			ARG_DEFAULT		},
  { "titlescreen_1.auto_delay",			ARG_DEFAULT		},
  { "titlescreen_1.auto_delay_unit",		ARG_DEFAULT		},
  { "titlescreen_2.sort_priority",		ARG_DEFAULT		},
  { "titlescreen_2.fade_mode",			ARG_DEFAULT		},
  { "titlescreen_2.fade_delay",			ARG_DEFAULT		},
  { "titlescreen_2.post_delay",			ARG_DEFAULT		},
  { "titlescreen_2.auto_delay",			ARG_DEFAULT		},
  { "titlescreen_2.auto_delay_unit",		ARG_DEFAULT		},
  { "titlescreen_3.sort_priority",		ARG_DEFAULT		},
  { "titlescreen_3.fade_mode",			ARG_DEFAULT		},
  { "titlescreen_3.fade_delay",			ARG_DEFAULT		},
  { "titlescreen_3.post_delay",			ARG_DEFAULT		},
  { "titlescreen_3.auto_delay",			ARG_DEFAULT		},
  { "titlescreen_3.auto_delay_unit",		ARG_DEFAULT		},
  { "titlescreen_4.sort_priority",		ARG_DEFAULT		},
  { "titlescreen_4.fade_mode",			ARG_DEFAULT		},
  { "titlescreen_4.fade_delay",			ARG_DEFAULT		},
  { "titlescreen_4.post_delay",			ARG_DEFAULT		},
  { "titlescreen_4.auto_delay",			ARG_DEFAULT		},
  { "titlescreen_4.auto_delay_unit",		ARG_DEFAULT		},
  { "titlescreen_5.sort_priority",		ARG_DEFAULT		},
  { "titlescreen_5.fade_mode",			ARG_DEFAULT		},
  { "titlescreen_5.fade_delay",			ARG_DEFAULT		},
  { "titlescreen_5.post_delay",			ARG_DEFAULT		},
  { "titlescreen_5.auto_delay",			ARG_DEFAULT		},
  { "titlescreen_5.auto_delay_unit",		ARG_DEFAULT		},

  { "[titlemessage_initial].x",			"-1"			},
  { "[titlemessage_initial].y",			"-1"			},
  { "[titlemessage_initial].width",		"-1"			},
  { "[titlemessage_initial].height",		"-1"			},
  { "[titlemessage_initial].chars",		"-1"			},
  { "[titlemessage_initial].lines",		"-1"			},
  { "[titlemessage_initial].align",		"center"		},
  { "[titlemessage_initial].valign",		"middle"		},
  { "[titlemessage_initial].font",		"font.text_1"		},
  { "[titlemessage_initial].autowrap",		"false"			},
  { "[titlemessage_initial].centered",		"false"			},
  { "[titlemessage_initial].parse_comments",	"false"			},
  { "[titlemessage_initial].sort_priority",	"0"			},
  { "[titlemessage_initial].fade_mode",		ARG_DEFAULT		},
  { "[titlemessage_initial].fade_delay",	ARG_DEFAULT		},
  { "[titlemessage_initial].post_delay",	ARG_DEFAULT		},
  { "[titlemessage_initial].auto_delay",	ARG_DEFAULT		},
  { "[titlemessage_initial].auto_delay_unit",	ARG_DEFAULT		},
  { "[titlemessage].x",				"-1"			},
  { "[titlemessage].y",				"-1"			},
  { "[titlemessage].width",			"-1"			},
  { "[titlemessage].height",			"-1"			},
  { "[titlemessage].chars",			"-1"			},
  { "[titlemessage].lines",			"-1"			},
  { "[titlemessage].align",			"center"		},
  { "[titlemessage].valign",			"middle"		},
  { "[titlemessage].font",			"font.text_1"		},
  { "[titlemessage].autowrap",			"false"			},
  { "[titlemessage].centered",			"false"			},
  { "[titlemessage].parse_comments",		"false"			},
  { "[titlemessage].sort_priority",		"0"			},
  { "[titlemessage].fade_mode",			ARG_DEFAULT		},
  { "[titlemessage].fade_delay",		ARG_DEFAULT		},
  { "[titlemessage].post_delay",		ARG_DEFAULT		},
  { "[titlemessage].auto_delay",		ARG_DEFAULT		},
  { "[titlemessage].auto_delay_unit",		ARG_DEFAULT		},

  { "titlemessage_initial_1.x",			ARG_DEFAULT		},
  { "titlemessage_initial_1.y",			ARG_DEFAULT		},
  { "titlemessage_initial_1.width",		ARG_DEFAULT		},
  { "titlemessage_initial_1.height",		ARG_DEFAULT		},
  { "titlemessage_initial_1.chars",		ARG_DEFAULT		},
  { "titlemessage_initial_1.lines",		ARG_DEFAULT		},
  { "titlemessage_initial_1.align",		ARG_DEFAULT		},
  { "titlemessage_initial_1.valign",		ARG_DEFAULT		},
  { "titlemessage_initial_1.font",		ARG_DEFAULT		},
  { "titlemessage_initial_1.autowrap",		ARG_DEFAULT		},
  { "titlemessage_initial_1.centered",		ARG_DEFAULT		},
  { "titlemessage_initial_1.parse_comments",	ARG_DEFAULT		},
  { "titlemessage_initial_1.sort_priority",	ARG_DEFAULT		},
  { "titlemessage_initial_1.fade_mode",		ARG_DEFAULT		},
  { "titlemessage_initial_1.fade_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_1.post_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_1.auto_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_1.auto_delay_unit",	ARG_DEFAULT		},
  { "titlemessage_initial_2.x",			ARG_DEFAULT		},
  { "titlemessage_initial_2.y",			ARG_DEFAULT		},
  { "titlemessage_initial_2.width",		ARG_DEFAULT		},
  { "titlemessage_initial_2.height",		ARG_DEFAULT		},
  { "titlemessage_initial_2.chars",		ARG_DEFAULT		},
  { "titlemessage_initial_2.lines",		ARG_DEFAULT		},
  { "titlemessage_initial_2.align",		ARG_DEFAULT		},
  { "titlemessage_initial_2.valign",		ARG_DEFAULT		},
  { "titlemessage_initial_2.font",		ARG_DEFAULT		},
  { "titlemessage_initial_2.autowrap",		ARG_DEFAULT		},
  { "titlemessage_initial_2.centered",		ARG_DEFAULT		},
  { "titlemessage_initial_2.parse_comments",	ARG_DEFAULT		},
  { "titlemessage_initial_2.sort_priority",	ARG_DEFAULT		},
  { "titlemessage_initial_2.fade_mode",		ARG_DEFAULT		},
  { "titlemessage_initial_2.fade_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_2.post_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_2.auto_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_2.auto_delay_unit",	ARG_DEFAULT		},
  { "titlemessage_initial_3.x",			ARG_DEFAULT		},
  { "titlemessage_initial_3.y",			ARG_DEFAULT		},
  { "titlemessage_initial_3.width",		ARG_DEFAULT		},
  { "titlemessage_initial_3.height",		ARG_DEFAULT		},
  { "titlemessage_initial_3.chars",		ARG_DEFAULT		},
  { "titlemessage_initial_3.lines",		ARG_DEFAULT		},
  { "titlemessage_initial_3.align",		ARG_DEFAULT		},
  { "titlemessage_initial_3.valign",		ARG_DEFAULT		},
  { "titlemessage_initial_3.font",		ARG_DEFAULT		},
  { "titlemessage_initial_3.autowrap",		ARG_DEFAULT		},
  { "titlemessage_initial_3.centered",		ARG_DEFAULT		},
  { "titlemessage_initial_3.parse_comments",	ARG_DEFAULT		},
  { "titlemessage_initial_3.sort_priority",	ARG_DEFAULT		},
  { "titlemessage_initial_3.fade_mode",		ARG_DEFAULT		},
  { "titlemessage_initial_3.fade_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_3.post_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_3.auto_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_3.auto_delay_unit",	ARG_DEFAULT		},
  { "titlemessage_initial_4.x",			ARG_DEFAULT		},
  { "titlemessage_initial_4.y",			ARG_DEFAULT		},
  { "titlemessage_initial_4.width",		ARG_DEFAULT		},
  { "titlemessage_initial_4.height",		ARG_DEFAULT		},
  { "titlemessage_initial_4.chars",		ARG_DEFAULT		},
  { "titlemessage_initial_4.lines",		ARG_DEFAULT		},
  { "titlemessage_initial_4.align",		ARG_DEFAULT		},
  { "titlemessage_initial_4.valign",		ARG_DEFAULT		},
  { "titlemessage_initial_4.font",		ARG_DEFAULT		},
  { "titlemessage_initial_4.autowrap",		ARG_DEFAULT		},
  { "titlemessage_initial_4.centered",		ARG_DEFAULT		},
  { "titlemessage_initial_4.parse_comments",	ARG_DEFAULT		},
  { "titlemessage_initial_4.sort_priority",	ARG_DEFAULT		},
  { "titlemessage_initial_4.fade_mode",		ARG_DEFAULT		},
  { "titlemessage_initial_4.fade_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_4.post_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_4.auto_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_4.auto_delay_unit",	ARG_DEFAULT		},
  { "titlemessage_initial_5.x",			ARG_DEFAULT		},
  { "titlemessage_initial_5.y",			ARG_DEFAULT		},
  { "titlemessage_initial_5.width",		ARG_DEFAULT		},
  { "titlemessage_initial_5.height",		ARG_DEFAULT		},
  { "titlemessage_initial_5.chars",		ARG_DEFAULT		},
  { "titlemessage_initial_5.lines",		ARG_DEFAULT		},
  { "titlemessage_initial_5.align",		ARG_DEFAULT		},
  { "titlemessage_initial_5.valign",		ARG_DEFAULT		},
  { "titlemessage_initial_5.font",		ARG_DEFAULT		},
  { "titlemessage_initial_5.autowrap",		ARG_DEFAULT		},
  { "titlemessage_initial_5.centered",		ARG_DEFAULT		},
  { "titlemessage_initial_5.parse_comments",	ARG_DEFAULT		},
  { "titlemessage_initial_5.sort_priority",	ARG_DEFAULT		},
  { "titlemessage_initial_5.fade_mode",		ARG_DEFAULT		},
  { "titlemessage_initial_5.fade_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_5.post_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_5.auto_delay",	ARG_DEFAULT		},
  { "titlemessage_initial_5.auto_delay_unit",	ARG_DEFAULT		},
  { "titlemessage_1.x",				ARG_DEFAULT		},
  { "titlemessage_1.y",				ARG_DEFAULT		},
  { "titlemessage_1.width",			ARG_DEFAULT		},
  { "titlemessage_1.height",			ARG_DEFAULT		},
  { "titlemessage_1.chars",			ARG_DEFAULT		},
  { "titlemessage_1.lines",			ARG_DEFAULT		},
  { "titlemessage_1.align",			ARG_DEFAULT		},
  { "titlemessage_1.valign",			ARG_DEFAULT		},
  { "titlemessage_1.font",			ARG_DEFAULT		},
  { "titlemessage_1.autowrap",			ARG_DEFAULT		},
  { "titlemessage_1.centered",			ARG_DEFAULT		},
  { "titlemessage_1.parse_comments",		ARG_DEFAULT		},
  { "titlemessage_1.sort_priority",		ARG_DEFAULT		},
  { "titlemessage_1.fade_mode",			ARG_DEFAULT		},
  { "titlemessage_1.fade_delay",		ARG_DEFAULT		},
  { "titlemessage_1.post_delay",		ARG_DEFAULT		},
  { "titlemessage_1.auto_delay",		ARG_DEFAULT		},
  { "titlemessage_1.auto_delay_unit",		ARG_DEFAULT		},
  { "titlemessage_2.x",				ARG_DEFAULT		},
  { "titlemessage_2.y",				ARG_DEFAULT		},
  { "titlemessage_2.width",			ARG_DEFAULT		},
  { "titlemessage_2.height",			ARG_DEFAULT		},
  { "titlemessage_2.chars",			ARG_DEFAULT		},
  { "titlemessage_2.lines",			ARG_DEFAULT		},
  { "titlemessage_2.align",			ARG_DEFAULT		},
  { "titlemessage_2.valign",			ARG_DEFAULT		},
  { "titlemessage_2.font",			ARG_DEFAULT		},
  { "titlemessage_2.autowrap",			ARG_DEFAULT		},
  { "titlemessage_2.centered",			ARG_DEFAULT		},
  { "titlemessage_2.parse_comments",		ARG_DEFAULT		},
  { "titlemessage_2.sort_priority",		ARG_DEFAULT		},
  { "titlemessage_2.fade_mode",			ARG_DEFAULT		},
  { "titlemessage_2.fade_delay",		ARG_DEFAULT		},
  { "titlemessage_2.post_delay",		ARG_DEFAULT		},
  { "titlemessage_2.auto_delay",		ARG_DEFAULT		},
  { "titlemessage_2.auto_delay_unit",		ARG_DEFAULT		},
  { "titlemessage_3.x",				ARG_DEFAULT		},
  { "titlemessage_3.y",				ARG_DEFAULT		},
  { "titlemessage_3.width",			ARG_DEFAULT		},
  { "titlemessage_3.height",			ARG_DEFAULT		},
  { "titlemessage_3.chars",			ARG_DEFAULT		},
  { "titlemessage_3.lines",			ARG_DEFAULT		},
  { "titlemessage_3.align",			ARG_DEFAULT		},
  { "titlemessage_3.valign",			ARG_DEFAULT		},
  { "titlemessage_3.font",			ARG_DEFAULT		},
  { "titlemessage_3.autowrap",			ARG_DEFAULT		},
  { "titlemessage_3.centered",			ARG_DEFAULT		},
  { "titlemessage_3.parse_comments",		ARG_DEFAULT		},
  { "titlemessage_3.sort_priority",		ARG_DEFAULT		},
  { "titlemessage_3.fade_mode",			ARG_DEFAULT		},
  { "titlemessage_3.fade_delay",		ARG_DEFAULT		},
  { "titlemessage_3.post_delay",		ARG_DEFAULT		},
  { "titlemessage_3.auto_delay",		ARG_DEFAULT		},
  { "titlemessage_3.auto_delay_unit",		ARG_DEFAULT		},
  { "titlemessage_4.x",				ARG_DEFAULT		},
  { "titlemessage_4.y",				ARG_DEFAULT		},
  { "titlemessage_4.width",			ARG_DEFAULT		},
  { "titlemessage_4.height",			ARG_DEFAULT		},
  { "titlemessage_4.chars",			ARG_DEFAULT		},
  { "titlemessage_4.lines",			ARG_DEFAULT		},
  { "titlemessage_4.align",			ARG_DEFAULT		},
  { "titlemessage_4.valign",			ARG_DEFAULT		},
  { "titlemessage_4.font",			ARG_DEFAULT		},
  { "titlemessage_4.autowrap",			ARG_DEFAULT		},
  { "titlemessage_4.centered",			ARG_DEFAULT		},
  { "titlemessage_4.parse_comments",		ARG_DEFAULT		},
  { "titlemessage_4.sort_priority",		ARG_DEFAULT		},
  { "titlemessage_4.fade_mode",			ARG_DEFAULT		},
  { "titlemessage_4.fade_delay",		ARG_DEFAULT		},
  { "titlemessage_4.post_delay",		ARG_DEFAULT		},
  { "titlemessage_4.auto_delay",		ARG_DEFAULT		},
  { "titlemessage_4.auto_delay_unit",		ARG_DEFAULT		},
  { "titlemessage_5.x",				ARG_DEFAULT		},
  { "titlemessage_5.y",				ARG_DEFAULT		},
  { "titlemessage_5.width",			ARG_DEFAULT		},
  { "titlemessage_5.height",			ARG_DEFAULT		},
  { "titlemessage_5.chars",			ARG_DEFAULT		},
  { "titlemessage_5.lines",			ARG_DEFAULT		},
  { "titlemessage_5.align",			ARG_DEFAULT		},
  { "titlemessage_5.valign",			ARG_DEFAULT		},
  { "titlemessage_5.font",			ARG_DEFAULT		},
  { "titlemessage_5.autowrap",			ARG_DEFAULT		},
  { "titlemessage_5.centered",			ARG_DEFAULT		},
  { "titlemessage_5.parse_comments",		ARG_DEFAULT		},
  { "titlemessage_5.sort_priority",		ARG_DEFAULT		},
  { "titlemessage_5.fade_mode",			ARG_DEFAULT		},
  { "titlemessage_5.fade_delay",		ARG_DEFAULT		},
  { "titlemessage_5.post_delay",		ARG_DEFAULT		},
  { "titlemessage_5.auto_delay",		ARG_DEFAULT		},
  { "titlemessage_5.auto_delay_unit",		ARG_DEFAULT		},

  { "readme.x",					"-1"			},
  { "readme.y",					"-1"			},
  { "readme.width",				"-1"			},
  { "readme.height",				"-1"			},
  { "readme.chars",				"-1"			},
  { "readme.lines",				"-1"			},
  { "readme.align",				"center"		},
  { "readme.valign",				"top"			},
  { "readme.font",				"font.info.levelset"	},
  { "readme.autowrap",				"true"			},
  { "readme.centered",				"false"			},
  { "readme.parse_comments",			"true"			},
  { "readme.sort_priority",			"0"			},

  { "global.num_toons",				"20"			},

  { "border.draw_masked.TITLE",			"false"			},
  { "border.draw_masked.MAIN",			"false"			},
  { "border.draw_masked.NAMES",			"false"			},
  { "border.draw_masked.LEVELS",		"false"			},
  { "border.draw_masked.LEVELNR",		"false"			},
  { "border.draw_masked.SCORES",		"false"			},
  { "border.draw_masked.EDITOR",		"false"			},
  { "border.draw_masked.INFO",			"false"			},
  { "border.draw_masked.SETUP",			"false"			},
  { "border.draw_masked.PLAYING",		"false"			},
  { "border.draw_masked.DOOR",			"false"			},

  { "border.draw_masked_when_fading",		"true"			},

  { "init.busy.x",				"-1"			},
  { "init.busy.y",				"-1"			},
  { "init.busy.align",				"center"		},
  { "init.busy.valign",				"middle"		},

  { "menu.enter_menu.fade_mode",		"none"			},
  { "menu.enter_menu.fade_delay",		"250"			},
  { "menu.enter_menu.post_delay",		"125"			},
  { "menu.leave_menu.fade_mode",		"none"			},
  { "menu.leave_menu.fade_delay",		"250"			},
  { "menu.leave_menu.post_delay",		"125"			},
  { "menu.enter_screen.fade_mode",		"fade"			},
  { "menu.enter_screen.fade_delay",		"250"			},
  { "menu.enter_screen.post_delay",		"125"			},
  { "menu.leave_screen.fade_mode",		"fade"			},
  { "menu.leave_screen.fade_delay",		"250"			},
  { "menu.leave_screen.post_delay",		"125"			},
  { "menu.next_screen.fade_mode",		"crossfade"		},
  { "menu.next_screen.fade_delay",		"250"			},
  { "menu.next_screen.post_delay",		"125"			},
  { "menu.enter_screen.TITLE.fade_mode",	"fade"			},
  { "menu.enter_screen.TITLE.fade_delay",	"500"			},
  { "menu.enter_screen.TITLE.post_delay",	"250"			},
  { "menu.enter_screen.TITLE.auto_delay",	"-1"			},
  { "menu.enter_screen.TITLE.auto_delay_unit",	"-1"			},
  { "menu.enter_screen.SCORES.fade_mode",	ARG_DEFAULT		},
  { "menu.enter_screen.SCORES.fade_delay",	ARG_DEFAULT		},
  { "menu.enter_screen.SCORES.post_delay",	ARG_DEFAULT		},
  { "menu.enter_screen.EDITOR.fade_mode",	ARG_DEFAULT		},
  { "menu.enter_screen.EDITOR.fade_delay",	ARG_DEFAULT		},
  { "menu.enter_screen.EDITOR.post_delay",	ARG_DEFAULT		},
  { "menu.enter_screen.INFO.fade_mode",		ARG_DEFAULT		},
  { "menu.enter_screen.INFO.fade_delay",	ARG_DEFAULT		},
  { "menu.enter_screen.INFO.post_delay",	ARG_DEFAULT		},
  { "menu.enter_screen.PLAYING.fade_mode",	ARG_DEFAULT		},
  { "menu.enter_screen.PLAYING.fade_delay",	ARG_DEFAULT		},
  { "menu.enter_screen.PLAYING.post_delay",	ARG_DEFAULT		},
  { "menu.leave_screen.TITLE.fade_mode",	"fade"			},
  { "menu.leave_screen.TITLE.fade_delay",	"500"			},
  { "menu.leave_screen.TITLE.post_delay",	"250"			},
  { "menu.leave_screen.TITLE.auto_delay",	"-1"			},
  { "menu.leave_screen.TITLE.auto_delay_unit",	"-1"			},
  { "menu.leave_screen.SCORES.fade_mode",	ARG_DEFAULT		},
  { "menu.leave_screen.SCORES.fade_delay",	ARG_DEFAULT		},
  { "menu.leave_screen.SCORES.post_delay",	ARG_DEFAULT		},
  { "menu.leave_screen.EDITOR.fade_mode",	ARG_DEFAULT		},
  { "menu.leave_screen.EDITOR.fade_delay",	ARG_DEFAULT		},
  { "menu.leave_screen.EDITOR.post_delay",	ARG_DEFAULT		},
  { "menu.leave_screen.INFO.fade_mode",		ARG_DEFAULT		},
  { "menu.leave_screen.INFO.fade_delay",	ARG_DEFAULT		},
  { "menu.leave_screen.INFO.post_delay",	ARG_DEFAULT		},
  { "menu.leave_screen.PLAYING.fade_mode",	ARG_DEFAULT		},
  { "menu.leave_screen.PLAYING.fade_delay",	ARG_DEFAULT		},
  { "menu.leave_screen.PLAYING.post_delay",	ARG_DEFAULT		},
  { "menu.next_screen.TITLE.fade_mode",		"fade"			},
  { "menu.next_screen.TITLE.fade_delay",	"500"			},
  { "menu.next_screen.TITLE.post_delay",	"250"			},
  { "menu.next_screen.TITLE.auto_delay",	"-1"			},
  { "menu.next_screen.TITLE.auto_delay_unit",	"-1"			},
  { "menu.next_screen.INFO.fade_mode",		ARG_DEFAULT		},
  { "menu.next_screen.INFO.fade_delay",		ARG_DEFAULT		},
  { "menu.next_screen.INFO.post_delay",		ARG_DEFAULT		},

  { "menu.draw_xoffset",			"0"			},
  { "menu.draw_yoffset",			"0"			},
  { "menu.draw_xoffset.MAIN",			"0"			},
  { "menu.draw_yoffset.MAIN",			"0"			},
  { "menu.draw_xoffset.NAMES",			"0"			},
  { "menu.draw_yoffset.NAMES",			"0"			},
  { "menu.draw_xoffset.LEVELS",			"0"			},
  { "menu.draw_yoffset.LEVELS",			"0"			},
  { "menu.draw_xoffset.LEVELNR",		"0"			},
  { "menu.draw_yoffset.LEVELNR",		"0"			},
  { "menu.draw_xoffset.SCORES",			"0"			},
  { "menu.draw_yoffset.SCORES",			"0"			},
  { "menu.draw_xoffset.EDITOR",			"0"			},
  { "menu.draw_yoffset.EDITOR",			"0"			},
  { "menu.draw_xoffset.INFO",			"0"			},
  { "menu.draw_yoffset.INFO",			"0"			},
  { "menu.draw_xoffset.INFO[TITLE]",		"0"			},
  { "menu.draw_yoffset.INFO[TITLE]",		"0"			},
  { "menu.draw_xoffset.INFO[ELEMENTS]",		"0"			},
  { "menu.draw_yoffset.INFO[ELEMENTS]",		"0"			},
  { "menu.draw_xoffset.INFO[MUSIC]",		"0"			},
  { "menu.draw_yoffset.INFO[MUSIC]",		"0"			},
  { "menu.draw_xoffset.INFO[CREDITS]",		"0"			},
  { "menu.draw_yoffset.INFO[CREDITS]",		"0"			},
  { "menu.draw_xoffset.INFO[PROGRAM]",		"0"			},
  { "menu.draw_yoffset.INFO[PROGRAM]",		"0"			},
  { "menu.draw_xoffset.INFO[VERSION]",		"0"			},
  { "menu.draw_yoffset.INFO[VERSION]",		"0"			},
  { "menu.draw_xoffset.INFO[LEVELSET]",		"0"			},
  { "menu.draw_yoffset.INFO[LEVELSET]",		"0"			},
  { "menu.draw_xoffset.SETUP",			"0"			},
  { "menu.draw_yoffset.SETUP",			"0"			},
  { "menu.draw_xoffset.SETUP[GAME]",		"0"			},
  { "menu.draw_yoffset.SETUP[GAME]",		"0"			},
  { "menu.draw_xoffset.SETUP[ENGINES]",		"0"			},
  { "menu.draw_yoffset.SETUP[ENGINES]",		"0"			},
  { "menu.draw_xoffset.SETUP[EDITOR]",		"0"			},
  { "menu.draw_yoffset.SETUP[EDITOR]",		"0"			},
  { "menu.draw_xoffset.SETUP[GRAPHICS]",	"0"			},
  { "menu.draw_yoffset.SETUP[GRAPHICS]",	"0"			},
  { "menu.draw_xoffset.SETUP[SOUND]",		"0"			},
  { "menu.draw_yoffset.SETUP[SOUND]",		"0"			},
  { "menu.draw_xoffset.SETUP[ARTWORK]",		"0"			},
  { "menu.draw_yoffset.SETUP[ARTWORK]",		"0"			},
  { "menu.draw_xoffset.SETUP[INPUT]",		"0"			},
  { "menu.draw_yoffset.SETUP[INPUT]",		"0"			},
  { "menu.draw_xoffset.SETUP[TOUCH]",		"0"			},
  { "menu.draw_yoffset.SETUP[TOUCH]",		"0"			},
  { "menu.draw_xoffset.SETUP[SHORTCUTS]",	"0"			},
  { "menu.draw_yoffset.SETUP[SHORTCUTS]",	"0"			},
  { "menu.draw_xoffset.SETUP[SHORTCUTS_1]",	"0"			},
  { "menu.draw_yoffset.SETUP[SHORTCUTS_1]",	"0"			},
  { "menu.draw_xoffset.SETUP[SHORTCUTS_2]",	"0"			},
  { "menu.draw_yoffset.SETUP[SHORTCUTS_2]",	"0"			},
  { "menu.draw_xoffset.SETUP[SHORTCUTS_3]",	"0"			},
  { "menu.draw_yoffset.SETUP[SHORTCUTS_3]",	"0"			},
  { "menu.draw_xoffset.SETUP[SHORTCUTS_4]",	"0"			},
  { "menu.draw_yoffset.SETUP[SHORTCUTS_4]",	"0"			},
  { "menu.draw_xoffset.SETUP[SHORTCUTS_5]",	"0"			},
  { "menu.draw_yoffset.SETUP[SHORTCUTS_5]",	"0"			},
  { "menu.draw_xoffset.SETUP[CHOOSE_ARTWORK]",	"0"			},
  { "menu.draw_yoffset.SETUP[CHOOSE_ARTWORK]",	"0"			},
  { "menu.draw_xoffset.SETUP[CHOOSE_OTHER]",	"0"			},
  { "menu.draw_yoffset.SETUP[CHOOSE_OTHER]",	"0"			},

  { "menu.scrollbar_xoffset",			"0"			},

  { "menu.list.SETUP[CHOOSE_OTHER].align",	"left"			},
  { "menu.list.SETUP[CHOOSE_OTHER].valign",	"top"			},

  { "menu.list_size",				"-1"			},
  { "menu.list_size.NAMES",			"-1"			},
  { "menu.list_size.LEVELS",			"-1"			},
  { "menu.list_size.LEVELNR",			"-1"			},
  { "menu.list_size.SCORES",			"-1"			},
  { "menu.list_size.INFO",			"-1"			},
  { "menu.list_size.INFO[ELEMENTS]",		"-1"			},
  { "menu.list_size.SETUP",			"-1"			},

  { "menu.left_spacing.INFO",			"16"			},
  { "menu.left_spacing.INFO[TITLE]",		"16"			},
  { "menu.left_spacing.INFO[ELEMENTS]",		"16"			},
  { "menu.left_spacing.INFO[MUSIC]",		"16"			},
  { "menu.left_spacing.INFO[CREDITS]",		"16"			},
  { "menu.left_spacing.INFO[PROGRAM]",		"16"			},
  { "menu.left_spacing.INFO[VERSION]",		"16"			},
  { "menu.left_spacing.INFO[LEVELSET]",		"16"			},
  { "menu.left_spacing.SETUP[INPUT]",		"16"			},

  { "menu.right_spacing.INFO",			"16"			},
  { "menu.right_spacing.INFO[TITLE]",		"16"			},
  { "menu.right_spacing.INFO[ELEMENTS]",	"16"			},
  { "menu.right_spacing.INFO[MUSIC]",		"16"			},
  { "menu.right_spacing.INFO[CREDITS]",		"16"			},
  { "menu.right_spacing.INFO[PROGRAM]",		"16"			},
  { "menu.right_spacing.INFO[VERSION]",		"16"			},
  { "menu.right_spacing.INFO[LEVELSET]",	"16"			},
  { "menu.right_spacing.SETUP[INPUT]",		"16"			},

  { "menu.top_spacing.INFO",			"100"			},
  { "menu.top_spacing.INFO[TITLE]",		"100"			},
  { "menu.top_spacing.INFO[ELEMENTS]",		"100"			},
  { "menu.top_spacing.INFO[MUSIC]",		"100"			},
  { "menu.top_spacing.INFO[CREDITS]",		"100"			},
  { "menu.top_spacing.INFO[PROGRAM]",		"100"			},
  { "menu.top_spacing.INFO[VERSION]",		"100"			},
  { "menu.top_spacing.INFO[LEVELSET]",		"100"			},
  { "menu.top_spacing.SETUP[INPUT]",		"100"			},

  { "menu.bottom_spacing.INFO",			"20"			},
  { "menu.bottom_spacing.INFO[TITLE]",		"20"			},
  { "menu.bottom_spacing.INFO[ELEMENTS]",	"20"			},
  { "menu.bottom_spacing.INFO[MUSIC]",		"20"			},
  { "menu.bottom_spacing.INFO[CREDITS]",	"20"			},
  { "menu.bottom_spacing.INFO[PROGRAM]",	"20"			},
  { "menu.bottom_spacing.INFO[VERSION]",	"20"			},
  { "menu.bottom_spacing.INFO[LEVELSET]",	"20"			},
  { "menu.bottom_spacing.SETUP[INPUT]",		"20"			},

  { "menu.paragraph_spacing.INFO",		"-3"			},
  { "menu.paragraph_spacing.INFO[TITLE]",	"-3"			},
  { "menu.paragraph_spacing.INFO[ELEMENTS]",	"-3"			},
  { "menu.paragraph_spacing.INFO[MUSIC]",	"-3"			},
  { "menu.paragraph_spacing.INFO[CREDITS]",	"-3"			},
  { "menu.paragraph_spacing.INFO[PROGRAM]",	"-3"			},
  { "menu.paragraph_spacing.INFO[VERSION]",	"-2"			},
  { "menu.paragraph_spacing.INFO[LEVELSET]",	"-3"			},
  { "menu.paragraph_spacing.SETUP[INPUT]",	"-1"			},

  { "menu.headline1_spacing.INFO",		"-2"			},
  { "menu.headline1_spacing.INFO[TITLE]",	"-2"			},
  { "menu.headline1_spacing.INFO[ELEMENTS]",	"-2"			},
  { "menu.headline1_spacing.INFO[MUSIC]",	"-2"			},
  { "menu.headline1_spacing.INFO[CREDITS]",	"-2"			},
  { "menu.headline1_spacing.INFO[PROGRAM]",	"-2"			},
  { "menu.headline1_spacing.INFO[VERSION]",	"-2"			},
  { "menu.headline1_spacing.INFO[LEVELSET]",	"-2"			},
  { "menu.headline1_spacing.SETUP[INPUT]",	"-2"			},

  { "menu.headline2_spacing.INFO",		"-1"			},
  { "menu.headline2_spacing.INFO[TITLE]",	"-1"			},
  { "menu.headline2_spacing.INFO[ELEMENTS]",	"-1"			},
  { "menu.headline2_spacing.INFO[MUSIC]",	"-1"			},
  { "menu.headline2_spacing.INFO[CREDITS]",	"-1"			},
  { "menu.headline2_spacing.INFO[PROGRAM]",	"-1"			},
  { "menu.headline2_spacing.INFO[VERSION]",	"-1"			},
  { "menu.headline2_spacing.INFO[LEVELSET]",	"-1"			},
  { "menu.headline2_spacing.SETUP[INPUT]",	"-1"			},

  { "menu.line_spacing.INFO",			"0"			},
  { "menu.line_spacing.INFO[TITLE]",		"0"			},
  { "menu.line_spacing.INFO[ELEMENTS]",		"0"			},
  { "menu.line_spacing.INFO[MUSIC]",		"0"			},
  { "menu.line_spacing.INFO[CREDITS]",		"0"			},
  { "menu.line_spacing.INFO[PROGRAM]",		"0"			},
  { "menu.line_spacing.INFO[VERSION]",		"0"			},
  { "menu.line_spacing.INFO[LEVELSET]",		"0"			},
  { "menu.line_spacing.SETUP[INPUT]",		"0"			},

  { "menu.extra_spacing.INFO",			"2"			},
  { "menu.extra_spacing.INFO[TITLE]",		"2"			},
  { "menu.extra_spacing.INFO[ELEMENTS]",	"2"			},
  { "menu.extra_spacing.INFO[MUSIC]",		"2"			},
  { "menu.extra_spacing.INFO[CREDITS]",		"2"			},
  { "menu.extra_spacing.INFO[PROGRAM]",		"2"			},
  { "menu.extra_spacing.INFO[VERSION]",		"2"			},
  { "menu.extra_spacing.INFO[LEVELSET]",	"2"			},
  { "menu.extra_spacing.SETUP[INPUT]",		"2"			},

  { "main.button.name.x",			"0"			},
  { "main.button.name.y",			"64"			},
  { "main.button.levels.x",			"0"			},
  { "main.button.levels.y",			"96"			},
  { "main.button.scores.x",			"0"			},
  { "main.button.scores.y",			"128"			},
  { "main.button.editor.x",			"0"			},
  { "main.button.editor.y",			"160"			},
  { "main.button.info.x",			"0"			},
  { "main.button.info.y",			"192"			},
  { "main.button.game.x",			"0"			},
  { "main.button.game.y",			"224"			},
  { "main.button.setup.x",			"0"			},
  { "main.button.setup.y",			"256"			},
  { "main.button.quit.x",			"0"			},
  { "main.button.quit.y",			"288"			},

  { "main.button.first_level.x",		"-1"			},
  { "main.button.first_level.y",		"-1"			},
  { "main.button.last_level.x",			"-1"			},
  { "main.button.last_level.y",			"-1"			},
  { "main.button.level_number.x",		"-1"			},
  { "main.button.level_number.y",		"-1"			},

  { "main.button.prev_level.x",			"320"			},
  { "main.button.prev_level.y",			"96"			},
  { "main.button.next_level.x",			"448"			},
  { "main.button.next_level.y",			"96"			},

  { "main.button.insert_solution.x",		"-1"			},
  { "main.button.insert_solution.y",		"-1"			},
  { "main.button.play_solution.x",		"-1"			},
  { "main.button.play_solution.y",		"-1"			},

  { "main.button.switch_ecs_aga.x",		"-1"			},
  { "main.button.switch_ecs_aga.y",		"-1"			},

  { "main.text.name.x",				"-1"			},
  { "main.text.name.y",				"-1"			},
  { "main.text.name.width",			"-1"			},
  { "main.text.name.height",			"-1"			},
  { "main.text.name.align",			"left"			},
  { "main.text.name.valign",			"top"			},
  { "main.text.name.font",			"font.menu_1"		},
  { "main.text.levels.x",			"-1"			},
  { "main.text.levels.y",			"-1"			},
  { "main.text.levels.width",			"-1"			},
  { "main.text.levels.height",			"-1"			},
  { "main.text.levels.align",			"left"			},
  { "main.text.levels.valign",			"top"			},
  { "main.text.levels.font",			"font.menu_1"		},
  { "main.text.scores.x",			"-1"			},
  { "main.text.scores.y",			"-1"			},
  { "main.text.scores.width",			"-1"			},
  { "main.text.scores.height",			"-1"			},
  { "main.text.scores.align",			"left"			},
  { "main.text.scores.valign",			"top"			},
  { "main.text.scores.font",			"font.menu_1"		},
  { "main.text.editor.x",			"-1"			},
  { "main.text.editor.y",			"-1"			},
  { "main.text.editor.width",			"-1"			},
  { "main.text.editor.height",			"-1"			},
  { "main.text.editor.align",			"left"			},
  { "main.text.editor.valign",			"top"			},
  { "main.text.editor.font",			"font.menu_1"		},
  { "main.text.info.x",				"-1"			},
  { "main.text.info.y",				"-1"			},
  { "main.text.info.width",			"-1"			},
  { "main.text.info.height",			"-1"			},
  { "main.text.info.align",			"left"			},
  { "main.text.info.valign",			"top"			},
  { "main.text.info.font",			"font.menu_1"		},
  { "main.text.game.x",				"-1"			},
  { "main.text.game.y",				"-1"			},
  { "main.text.game.width",			"-1"			},
  { "main.text.game.height",			"-1"			},
  { "main.text.game.align",			"left"			},
  { "main.text.game.valign",			"top"			},
  { "main.text.game.font",			"font.menu_1"		},
  { "main.text.setup.x",			"-1"			},
  { "main.text.setup.y",			"-1"			},
  { "main.text.setup.width",			"-1"			},
  { "main.text.setup.height",			"-1"			},
  { "main.text.setup.align",			"left"			},
  { "main.text.setup.valign",			"top"			},
  { "main.text.setup.font",			"font.menu_1"		},
  { "main.text.quit.x",				"-1"			},
  { "main.text.quit.y",				"-1"			},
  { "main.text.quit.width",			"-1"			},
  { "main.text.quit.height",			"-1"			},
  { "main.text.quit.align",			"left"			},
  { "main.text.quit.valign",			"top"			},
  { "main.text.quit.font",			"font.menu_1"		},

  { "main.text.first_level.x",			"488"			},
  { "main.text.first_level.y",			"98"			},
  { "main.text.first_level.align",		"left"			},
  { "main.text.first_level.valign",		"top"			},
  { "main.text.first_level.digits",		"3"			},
  { "main.text.first_level.font",		"font.text_3"		},
  { "main.text.last_level.x",			"488"			},
  { "main.text.last_level.y",			"112"			},
  { "main.text.last_level.align",		"left"			},
  { "main.text.last_level.valign",		"top"			},
  { "main.text.last_level.digits",		"3"			},
  { "main.text.last_level.font",		"font.text_3"		},
  { "main.text.level_number.x",			"352"			},
  { "main.text.level_number.y",			"96"			},
  { "main.text.level_number.align",		"left"			},
  { "main.text.level_number.valign",		"top"			},
  { "main.text.level_number.digits",		"3"			},
  { "main.text.level_number.font",		"font.value_1"		},
  { "main.text.level_info_1.x",			"272"			},
  { "main.text.level_info_1.y",			"352"			},
  { "main.text.level_info_1.align",		"center"		},
  { "main.text.level_info_1.valign",		"top"			},
  { "main.text.level_info_1.chars",		"-1"			},
  { "main.text.level_info_1.font",		"font.text_1"		},
  { "main.text.level_info_2.x",			"272"			},
  { "main.text.level_info_2.y",			"523"			},
  { "main.text.level_info_2.align",		"center"		},
  { "main.text.level_info_2.valign",		"top"			},
  { "main.text.level_info_2.chars",		"-1"			},
  { "main.text.level_info_2.font",		"font.text_2"		},
  { "main.text.level_info_2.font_header",	"font.text_4"		},
  { "main.text.level_name.x",			"-1"			},
  { "main.text.level_name.y",			"-1"			},
  { "main.text.level_name.align",		"left"			},
  { "main.text.level_name.valign",		"top"			},
  { "main.text.level_name.chars",		"-1"			},
  { "main.text.level_name.font",		"font.text_2"		},
  { "main.text.level_author.x",			"-1"			},
  { "main.text.level_author.y",			"-1"			},
  { "main.text.level_author.align",		"left"			},
  { "main.text.level_author.valign",		"top"			},
  { "main.text.level_author.chars",		"-1"			},
  { "main.text.level_author.font",		"font.text_2"		},
  { "main.text.level_year.x",			"-1"			},
  { "main.text.level_year.y",			"-1"			},
  { "main.text.level_year.align",		"left"			},
  { "main.text.level_year.valign",		"top"			},
  { "main.text.level_year.digits",		"-1"			},
  { "main.text.level_year.font",		"font.text_2"		},
  { "main.text.level_imported_from.x",		"-1"			},
  { "main.text.level_imported_from.y",		"-1"			},
  { "main.text.level_imported_from.align",	"left"			},
  { "main.text.level_imported_from.valign",	"top"			},
  { "main.text.level_imported_from.chars",	"-1"			},
  { "main.text.level_imported_from.font",	"font.text_2"		},
  { "main.text.level_imported_by.x",		"-1"			},
  { "main.text.level_imported_by.y",		"-1"			},
  { "main.text.level_imported_by.align",	"left"			},
  { "main.text.level_imported_by.valign",	"top"			},
  { "main.text.level_imported_by.chars",	"-1"			},
  { "main.text.level_imported_by.font",		"font.text_2"		},
  { "main.text.level_tested_by.x",		"-1"			},
  { "main.text.level_tested_by.y",		"-1"			},
  { "main.text.level_tested_by.align",		"left"			},
  { "main.text.level_tested_by.valign",		"top"			},
  { "main.text.level_tested_by.chars",		"-1"			},
  { "main.text.level_tested_by.font",		"font.text_2"		},
  { "main.text.title_1.x",			"272"			},
  { "main.text.title_1.y",			"8"			},
  { "main.text.title_1.align",			"center"		},
  { "main.text.title_1.valign",			"top"			},
  { "main.text.title_1.font",			"font.title_1"		},
  { "main.text.title_2.x",			"272"			},
  { "main.text.title_2.y",			"46"			},
  { "main.text.title_2.align",			"center"		},
  { "main.text.title_2.valign",			"top"			},
  { "main.text.title_2.font",			"font.title_2"		},
  { "main.text.title_3.x",			"272"			},
  { "main.text.title_3.y",			"326"			},
  { "main.text.title_3.align",			"center"		},
  { "main.text.title_3.valign",			"top"			},
  { "main.text.title_3.font",			"font.title_2"		},

  { "main.input.name.x",			"-1"			},
  { "main.input.name.y",			"-1"			},
  { "main.input.name.align",			"left"			},
  { "main.input.name.valign",			"top"			},
  { "main.input.name.font",			"font.input_1"		},

  { "main.network_players.x",			"68"			},
  { "main.network_players.y",			"448"			},
  { "main.network_players.align",		"center"		},
  { "main.network_players.valign",		"middle"		},
  { "main.network_players.font",		"font.main.network_players" },
  { "main.network_players.tile_size",		"16"			},
  { "main.network_players.border_size",		"2"			},

  { "main.preview_players.x",			"474"			},
  { "main.preview_players.y",			"448"			},
  { "main.preview_players.align",		"center"		},
  { "main.preview_players.valign",		"middle"		},
  { "main.preview_players.tile_size",		"32"			},
  { "main.preview_players.border_size",		"2"			},
  { "main.preview_players.vertical",		"false"			},
  { "main.preview_players.xoffset",		"-1"			},
  { "main.preview_players.yoffset",		"-1"			},

  { "setup.button.prev_player.x",		"320"			},
  { "setup.button.prev_player.y",		"64"			},
  { "setup.button.next_player.x",		"384"			},
  { "setup.button.next_player.y",		"64"			},

  { "setup.button.touch_back.x",		"0"			},
  { "setup.button.touch_back.y",		"0"			},
  { "setup.button.touch_next.x",		"-60"			},
  { "setup.button.touch_next.y",		"0"			},
  { "setup.button.touch_back2.x",		"0"			},
  { "setup.button.touch_back2.y",		"-60"			},
  { "setup.button.touch_next2.x",		"-60"			},
  { "setup.button.touch_next2.y",		"-60"			},

  { "preview.x",				"272"			},
  { "preview.y",				"380"			},
  { "preview.align",				"center"		},
  { "preview.valign",				"top"			},
  { "preview.xsize",				"66"			},
  { "preview.ysize",				"34"			},
  { "preview.xoffset",				"0"			},
  { "preview.yoffset",				"0"			},
  { "preview.tile_size",			"4"			},
  { "preview.step_offset",			"1"			},
  { "preview.step_delay",			"50"			},
  { "preview.anim_mode",			"default"		},

  { "door_1.part_1.x",				"0"			},
  { "door_1.part_1.y",				"0"			},
  { "door_1.part_1.step_xoffset",		"3"			},
  { "door_1.part_1.step_yoffset",		"1"			},
  { "door_1.part_1.step_delay",			"10"			},
  { "door_1.part_1.start_step",			"0"			},
  { "door_1.part_1.start_step_opening",		"0"			},
  { "door_1.part_1.start_step_closing",		"0"			},
  { "door_1.part_1.draw_masked",		"true"			},
  { "door_1.part_1.draw_order",			"3"			},
  { "door_1.part_2.x",				"0"			},
  { "door_1.part_2.y",				"77"			},
  { "door_1.part_2.step_xoffset",		"3"			},
  { "door_1.part_2.step_yoffset",		"1"			},
  { "door_1.part_2.step_delay",			"10"			},
  { "door_1.part_2.start_step",			"0"			},
  { "door_1.part_2.start_step_opening",		"0"			},
  { "door_1.part_2.start_step_closing",		"0"			},
  { "door_1.part_2.draw_masked",		"true"			},
  { "door_1.part_2.draw_order",			"5"			},
  { "door_1.part_3.x",				"0"			},
  { "door_1.part_3.y",				"140"			},
  { "door_1.part_3.step_xoffset",		"3"			},
  { "door_1.part_3.step_yoffset",		"1"			},
  { "door_1.part_3.step_delay",			"10"			},
  { "door_1.part_3.start_step",			"0"			},
  { "door_1.part_3.start_step_opening",		"0"			},
  { "door_1.part_3.start_step_closing",		"0"			},
  { "door_1.part_3.draw_masked",		"true"			},
  { "door_1.part_3.draw_order",			"4"			},
  { "door_1.part_4.x",				"0"			},
  { "door_1.part_4.y",				"203"			},
  { "door_1.part_4.step_xoffset",		"3"			},
  { "door_1.part_4.step_yoffset",		"1"			},
  { "door_1.part_4.step_delay",			"10"			},
  { "door_1.part_4.start_step",			"0"			},
  { "door_1.part_4.start_step_opening",		"0"			},
  { "door_1.part_4.start_step_closing",		"0"			},
  { "door_1.part_4.draw_masked",		"true"			},
  { "door_1.part_4.draw_order",			"6"			},
  { "door_1.part_5.x",				"0"			},
  { "door_1.part_5.y",				"0"			},
  { "door_1.part_5.step_xoffset",		"-3"			},
  { "door_1.part_5.step_yoffset",		"-1"			},
  { "door_1.part_5.step_delay",			"10"			},
  { "door_1.part_5.start_step",			"0"			},
  { "door_1.part_5.start_step_opening",		"0"			},
  { "door_1.part_5.start_step_closing",		"0"			},
  { "door_1.part_5.draw_masked",		"true"			},
  { "door_1.part_5.draw_order",			"1"			},
  { "door_1.part_6.x",				"0"			},
  { "door_1.part_6.y",				"77"			},
  { "door_1.part_6.step_xoffset",		"-3"			},
  { "door_1.part_6.step_yoffset",		"-1"			},
  { "door_1.part_6.step_delay",			"10"			},
  { "door_1.part_6.start_step",			"0"			},
  { "door_1.part_6.start_step_opening",		"0"			},
  { "door_1.part_6.start_step_closing",		"0"			},
  { "door_1.part_6.draw_masked",		"true"			},
  { "door_1.part_6.draw_order",			"7"			},
  { "door_1.part_7.x",				"0"			},
  { "door_1.part_7.y",				"140"			},
  { "door_1.part_7.step_xoffset",		"-3"			},
  { "door_1.part_7.step_yoffset",		"-1"			},
  { "door_1.part_7.step_delay",			"10"			},
  { "door_1.part_7.start_step",			"0"			},
  { "door_1.part_7.start_step_opening",		"0"			},
  { "door_1.part_7.start_step_closing",		"0"			},
  { "door_1.part_7.draw_masked",		"true"			},
  { "door_1.part_7.draw_order",			"2"			},
  { "door_1.part_8.x",				"0"			},
  { "door_1.part_8.y",				"203"			},
  { "door_1.part_8.step_xoffset",		"-3"			},
  { "door_1.part_8.step_yoffset",		"-1"			},
  { "door_1.part_8.step_delay",			"10"			},
  { "door_1.part_8.start_step",			"0"			},
  { "door_1.part_8.start_step_opening",		"0"			},
  { "door_1.part_8.start_step_closing",		"0"			},
  { "door_1.part_8.draw_masked",		"true"			},
  { "door_1.part_8.draw_order",			"8"			},

  { "door_2.part_1.x",				"0"			},
  { "door_2.part_1.y",				"0"			},
  { "door_2.part_1.step_xoffset",		"3"			},
  { "door_2.part_1.step_yoffset",		"1"			},
  { "door_2.part_1.step_delay",			"10"			},
  { "door_2.part_1.start_step",			"0"			},
  { "door_2.part_1.start_step_opening",		"0"			},
  { "door_2.part_1.start_step_closing",		"0"			},
  { "door_2.part_1.draw_masked",		"true"			},
  { "door_2.part_1.draw_order",			"2"			},
  { "door_2.part_2.x",				"0"			},
  { "door_2.part_2.y",				"50"			},
  { "door_2.part_2.step_xoffset",		"3"			},
  { "door_2.part_2.step_yoffset",		"1"			},
  { "door_2.part_2.step_delay",			"10"			},
  { "door_2.part_2.start_step",			"0"			},
  { "door_2.part_2.start_step_opening",		"0"			},
  { "door_2.part_2.start_step_closing",		"0"			},
  { "door_2.part_2.draw_masked",		"true"			},
  { "door_2.part_2.draw_order",			"3"			},
  { "door_2.part_3.x",				"0"			},
  { "door_2.part_3.y",				"0"			},
  { "door_2.part_3.step_xoffset",		"-3"			},
  { "door_2.part_3.step_yoffset",		"-1"			},
  { "door_2.part_3.step_delay",			"10"			},
  { "door_2.part_3.start_step",			"0"			},
  { "door_2.part_3.start_step_opening",		"0"			},
  { "door_2.part_3.start_step_closing",		"0"			},
  { "door_2.part_3.draw_masked",		"true"			},
  { "door_2.part_3.draw_order",			"1"			},
  { "door_2.part_4.x",				"0"			},
  { "door_2.part_4.y",				"50"			},
  { "door_2.part_4.step_xoffset",		"-3"			},
  { "door_2.part_4.step_yoffset",		"-1"			},
  { "door_2.part_4.step_delay",			"10"			},
  { "door_2.part_4.start_step",			"0"			},
  { "door_2.part_4.start_step_opening",		"0"			},
  { "door_2.part_4.start_step_closing",		"0"			},
  { "door_2.part_4.draw_masked",		"true"			},
  { "door_2.part_4.draw_order",			"4"			},
  { "door_2.part_5.x",				"-1"			},
  { "door_2.part_5.y",				"-1"			},
  { "door_2.part_5.step_xoffset",		"0"			},
  { "door_2.part_5.step_yoffset",		"0"			},
  { "door_2.part_5.step_delay",			"0"			},
  { "door_2.part_5.start_step",			"0"			},
  { "door_2.part_5.start_step_opening",		"0"			},
  { "door_2.part_5.start_step_closing",		"0"			},
  { "door_2.part_5.draw_masked",		"true"			},
  { "door_2.part_5.draw_order",			"0"			},
  { "door_2.part_6.x",				"-1"			},
  { "door_2.part_6.y",				"-1"			},
  { "door_2.part_6.step_xoffset",		"0"			},
  { "door_2.part_6.step_yoffset",		"0"			},
  { "door_2.part_6.step_delay",			"0"			},
  { "door_2.part_6.start_step",			"0"			},
  { "door_2.part_6.start_step_opening",		"0"			},
  { "door_2.part_6.start_step_closing",		"0"			},
  { "door_2.part_6.draw_masked",		"true"			},
  { "door_2.part_6.draw_order",			"0"			},
  { "door_2.part_7.x",				"-1"			},
  { "door_2.part_7.y",				"-1"			},
  { "door_2.part_7.step_xoffset",		"0"			},
  { "door_2.part_7.step_yoffset",		"0"			},
  { "door_2.part_7.step_delay",			"0"			},
  { "door_2.part_7.start_step",			"0"			},
  { "door_2.part_7.start_step_opening",		"0"			},
  { "door_2.part_7.start_step_closing",		"0"			},
  { "door_2.part_7.draw_masked",		"true"			},
  { "door_2.part_7.draw_order",			"0"			},
  { "door_2.part_8.x",				"-1"			},
  { "door_2.part_8.y",				"-1"			},
  { "door_2.part_8.step_xoffset",		"0"			},
  { "door_2.part_8.step_yoffset",		"0"			},
  { "door_2.part_8.step_delay",			"0"			},
  { "door_2.part_8.start_step",			"0"			},
  { "door_2.part_8.start_step_opening",		"0"			},
  { "door_2.part_8.start_step_closing",		"0"			},
  { "door_2.part_8.draw_masked",		"true"			},
  { "door_2.part_8.draw_order",			"0"			},

  { "door_1.panel.x",				"0"			},
  { "door_1.panel.y",				"0"			},
  { "door_1.panel.step_xoffset",		"0"			},
  { "door_1.panel.step_yoffset",		"1"			},
  { "door_1.panel.step_delay",			"10"			},
  { "door_1.panel.start_step",			"246"			},
  { "door_1.panel.start_step_opening",		"0"			},
  { "door_1.panel.start_step_closing",		"0"			},
  { "door_1.panel.draw_masked",			"false"			},
  { "door_1.panel.draw_order",			"0"			},

  { "door_2.panel.x",				"0"			},
  { "door_2.panel.y",				"0"			},
  { "door_2.panel.step_xoffset",		"0"			},
  { "door_2.panel.step_yoffset",		"1"			},
  { "door_2.panel.step_delay",			"10"			},
  { "door_2.panel.start_step",			"66"			},
  { "door_2.panel.start_step_opening",		"0"			},
  { "door_2.panel.start_step_closing",		"0"			},
  { "door_2.panel.draw_masked",			"false"			},
  { "door_2.panel.draw_order",			"0"			},

  { "door_1.width",				"-1"			},
  { "door_1.height",				"-1"			},
  { "door_1.step_offset",			"2"			},
  { "door_1.step_delay",			"10"			},
  { "door_1.post_delay",			"100"			},
  { "door_1.anim_mode",				"default"		},

  { "door_2.width",				"-1"			},
  { "door_2.height",				"-1"			},
  { "door_2.step_offset",			"2"			},
  { "door_2.step_delay",			"10"			},
  { "door_2.post_delay",			"100"			},
  { "door_2.anim_mode",				"default"		},

  { "game.panel.level_number.x",		"51"			},
  { "game.panel.level_number.y",		"20"			},
  { "game.panel.level_number.align",		"center"		},
  { "game.panel.level_number.valign",		"top"			},
  { "game.panel.level_number.digits",		"-1"			},
  { "game.panel.level_number.font",		"font.text_2"		},
  { "game.panel.level_number.font_narrow",	"font.text_1"		},
  { "game.panel.level_number.draw_masked",	"true"			},
  { "game.panel.level_number.draw_order",	"0"			},
  { "game.panel.level_number.class",		"none"			},
  { "game.panel.level_number.style",		"none"			},

  { "game.panel.gems.x",			"50"			},
  { "game.panel.gems.y",			"54"			},
  { "game.panel.gems.align",			"center"		},
  { "game.panel.gems.valign",			"top"			},
  { "game.panel.gems.digits",			"3"			},
  { "game.panel.gems.font",			"font.text_2"		},
  { "game.panel.gems.draw_masked",		"true"			},
  { "game.panel.gems.draw_order",		"0"			},
  { "game.panel.gems.class",			"none"			},
  { "game.panel.gems.style",			"none"			},

  { "game.panel.inventory_count.x",		"50"			},
  { "game.panel.inventory_count.y",		"89"			},
  { "game.panel.inventory_count.align",		"center"		},
  { "game.panel.inventory_count.valign",	"top"			},
  { "game.panel.inventory_count.digits",	"3"			},
  { "game.panel.inventory_count.font",		"font.text_2"		},
  { "game.panel.inventory_count.draw_masked",	"true"			},
  { "game.panel.inventory_count.draw_order",	"0"			},
  { "game.panel.inventory_count.class",		"none"			},
  { "game.panel.inventory_count.style",		"none"			},

  { "game.panel.inventory_first_1.x",		"-1"			},
  { "game.panel.inventory_first_1.y",		"-1"			},
  { "game.panel.inventory_first_1.tile_size",	"16"			},
  { "game.panel.inventory_first_1.draw_masked",	"false"			},
  { "game.panel.inventory_first_1.draw_order",	"0"			},
  { "game.panel.inventory_first_1.class",	"none"			},
  { "game.panel.inventory_first_1.style",	"none"			},
  { "game.panel.inventory_first_2.x",		"-1"			},
  { "game.panel.inventory_first_2.y",		"-1"			},
  { "game.panel.inventory_first_2.tile_size",	"16"			},
  { "game.panel.inventory_first_2.draw_masked",	"false"			},
  { "game.panel.inventory_first_2.draw_order",	"0"			},
  { "game.panel.inventory_first_2.class",	"none"			},
  { "game.panel.inventory_first_2.style",	"none"			},
  { "game.panel.inventory_first_3.x",		"-1"			},
  { "game.panel.inventory_first_3.y",		"-1"			},
  { "game.panel.inventory_first_3.tile_size",	"16"			},
  { "game.panel.inventory_first_3.draw_masked",	"false"			},
  { "game.panel.inventory_first_3.draw_order",	"0"			},
  { "game.panel.inventory_first_3.class",	"none"			},
  { "game.panel.inventory_first_3.style",	"none"			},
  { "game.panel.inventory_first_4.x",		"-1"			},
  { "game.panel.inventory_first_4.y",		"-1"			},
  { "game.panel.inventory_first_4.tile_size",	"16"			},
  { "game.panel.inventory_first_4.draw_masked",	"false"			},
  { "game.panel.inventory_first_4.draw_order",	"0"			},
  { "game.panel.inventory_first_4.class",	"none"			},
  { "game.panel.inventory_first_4.style",	"none"			},
  { "game.panel.inventory_first_5.x",		"-1"			},
  { "game.panel.inventory_first_5.y",		"-1"			},
  { "game.panel.inventory_first_5.tile_size",	"16"			},
  { "game.panel.inventory_first_5.draw_masked",	"false"			},
  { "game.panel.inventory_first_5.draw_order",	"0"			},
  { "game.panel.inventory_first_5.class",	"none"			},
  { "game.panel.inventory_first_5.style",	"none"			},
  { "game.panel.inventory_first_6.x",		"-1"			},
  { "game.panel.inventory_first_6.y",		"-1"			},
  { "game.panel.inventory_first_6.tile_size",	"16"			},
  { "game.panel.inventory_first_6.draw_masked",	"false"			},
  { "game.panel.inventory_first_6.draw_order",	"0"			},
  { "game.panel.inventory_first_6.class",	"none"			},
  { "game.panel.inventory_first_6.style",	"none"			},
  { "game.panel.inventory_first_7.x",		"-1"			},
  { "game.panel.inventory_first_7.y",		"-1"			},
  { "game.panel.inventory_first_7.tile_size",	"16"			},
  { "game.panel.inventory_first_7.draw_masked",	"false"			},
  { "game.panel.inventory_first_7.draw_order",	"0"			},
  { "game.panel.inventory_first_7.class",	"none"			},
  { "game.panel.inventory_first_7.style",	"none"			},
  { "game.panel.inventory_first_8.x",		"-1"			},
  { "game.panel.inventory_first_8.y",		"-1"			},
  { "game.panel.inventory_first_8.tile_size",	"16"			},
  { "game.panel.inventory_first_8.draw_masked",	"false"			},
  { "game.panel.inventory_first_8.draw_order",	"0"			},
  { "game.panel.inventory_first_8.class",	"none"			},
  { "game.panel.inventory_first_8.style",	"none"			},

  { "game.panel.inventory_last_1.x",		"-1"			},
  { "game.panel.inventory_last_1.y",		"-1"			},
  { "game.panel.inventory_last_1.tile_size",	"16"			},
  { "game.panel.inventory_last_1.draw_masked",	"false"			},
  { "game.panel.inventory_last_1.draw_order",	"0"			},
  { "game.panel.inventory_last_1.class",	"none"			},
  { "game.panel.inventory_last_1.style",	"none"			},
  { "game.panel.inventory_last_2.x",		"-1"			},
  { "game.panel.inventory_last_2.y",		"-1"			},
  { "game.panel.inventory_last_2.tile_size",	"16"			},
  { "game.panel.inventory_last_2.draw_masked",	"false"			},
  { "game.panel.inventory_last_2.draw_order",	"0"			},
  { "game.panel.inventory_last_2.class",	"none"			},
  { "game.panel.inventory_last_2.style",	"none"			},
  { "game.panel.inventory_last_3.x",		"-1"			},
  { "game.panel.inventory_last_3.y",		"-1"			},
  { "game.panel.inventory_last_3.tile_size",	"16"			},
  { "game.panel.inventory_last_3.draw_masked",	"false"			},
  { "game.panel.inventory_last_3.draw_order",	"0"			},
  { "game.panel.inventory_last_3.class",	"none"			},
  { "game.panel.inventory_last_3.style",	"none"			},
  { "game.panel.inventory_last_4.x",		"-1"			},
  { "game.panel.inventory_last_4.y",		"-1"			},
  { "game.panel.inventory_last_4.tile_size",	"16"			},
  { "game.panel.inventory_last_4.draw_masked",	"false"			},
  { "game.panel.inventory_last_4.draw_order",	"0"			},
  { "game.panel.inventory_last_4.class",	"none"			},
  { "game.panel.inventory_last_4.style",	"none"			},
  { "game.panel.inventory_last_5.x",		"-1"			},
  { "game.panel.inventory_last_5.y",		"-1"			},
  { "game.panel.inventory_last_5.tile_size",	"16"			},
  { "game.panel.inventory_last_5.draw_masked",	"false"			},
  { "game.panel.inventory_last_5.draw_order",	"0"			},
  { "game.panel.inventory_last_5.class",	"none"			},
  { "game.panel.inventory_last_5.style",	"none"			},
  { "game.panel.inventory_last_6.x",		"-1"			},
  { "game.panel.inventory_last_6.y",		"-1"			},
  { "game.panel.inventory_last_6.tile_size",	"16"			},
  { "game.panel.inventory_last_6.draw_masked",	"false"			},
  { "game.panel.inventory_last_6.draw_order",	"0"			},
  { "game.panel.inventory_last_6.class",	"none"			},
  { "game.panel.inventory_last_6.style",	"none"			},
  { "game.panel.inventory_last_7.x",		"-1"			},
  { "game.panel.inventory_last_7.y",		"-1"			},
  { "game.panel.inventory_last_7.tile_size",	"16"			},
  { "game.panel.inventory_last_7.draw_masked",	"false"			},
  { "game.panel.inventory_last_7.draw_order",	"0"			},
  { "game.panel.inventory_last_7.class",	"none"			},
  { "game.panel.inventory_last_7.style",	"none"			},
  { "game.panel.inventory_last_8.x",		"-1"			},
  { "game.panel.inventory_last_8.y",		"-1"			},
  { "game.panel.inventory_last_8.tile_size",	"16"			},
  { "game.panel.inventory_last_8.draw_masked",	"false"			},
  { "game.panel.inventory_last_8.draw_order",	"0"			},
  { "game.panel.inventory_last_8.class",	"none"			},
  { "game.panel.inventory_last_8.style",	"none"			},

  { "game.panel.key_1.x",			"18"			},
  { "game.panel.key_1.y",			"123"			},
  { "game.panel.key_1.tile_size",		"16"			},
  { "game.panel.key_1.draw_masked",		"false"			},
  { "game.panel.key_1.draw_order",		"0"			},
  { "game.panel.key_1.class",			"none"			},
  { "game.panel.key_1.style",			"none"			},
  { "game.panel.key_2.x",			"34"			},
  { "game.panel.key_2.y",			"123"			},
  { "game.panel.key_2.tile_size",		"16"			},
  { "game.panel.key_2.draw_masked",		"false"			},
  { "game.panel.key_2.draw_order",		"0"			},
  { "game.panel.key_2.class",			"none"			},
  { "game.panel.key_2.style",			"none"			},
  { "game.panel.key_3.x",			"50"			},
  { "game.panel.key_3.y",			"123"			},
  { "game.panel.key_3.tile_size",		"16"			},
  { "game.panel.key_3.draw_masked",		"false"			},
  { "game.panel.key_3.draw_order",		"0"			},
  { "game.panel.key_3.class",			"none"			},
  { "game.panel.key_3.style",			"none"			},
  { "game.panel.key_4.x",			"66"			},
  { "game.panel.key_4.y",			"123"			},
  { "game.panel.key_4.tile_size",		"16"			},
  { "game.panel.key_4.draw_masked",		"false"			},
  { "game.panel.key_4.draw_order",		"0"			},
  { "game.panel.key_4.class",			"none"			},
  { "game.panel.key_4.style",			"none"			},
  { "game.panel.key_5.x",			"-1"			},
  { "game.panel.key_5.y",			"-1"			},
  { "game.panel.key_5.tile_size",		"16"			},
  { "game.panel.key_5.draw_masked",		"false"			},
  { "game.panel.key_5.draw_order",		"0"			},
  { "game.panel.key_5.class",			"none"			},
  { "game.panel.key_5.style",			"none"			},
  { "game.panel.key_6.x",			"-1"			},
  { "game.panel.key_6.y",			"-1"			},
  { "game.panel.key_6.tile_size",		"16"			},
  { "game.panel.key_6.draw_masked",		"false"			},
  { "game.panel.key_6.draw_order",		"0"			},
  { "game.panel.key_6.class",			"none"			},
  { "game.panel.key_6.style",			"none"			},
  { "game.panel.key_7.x",			"-1"			},
  { "game.panel.key_7.y",			"-1"			},
  { "game.panel.key_7.tile_size",		"16"			},
  { "game.panel.key_7.draw_masked",		"false"			},
  { "game.panel.key_7.draw_order",		"0"			},
  { "game.panel.key_7.class",			"none"			},
  { "game.panel.key_7.style",			"none"			},
  { "game.panel.key_8.x",			"-1"			},
  { "game.panel.key_8.y",			"-1"			},
  { "game.panel.key_8.tile_size",		"16"			},
  { "game.panel.key_8.draw_masked",		"false"			},
  { "game.panel.key_8.draw_order",		"0"			},
  { "game.panel.key_8.class",			"none"			},
  { "game.panel.key_8.style",			"none"			},
  { "game.panel.key_white.x",			"-1"			},
  { "game.panel.key_white.y",			"-1"			},
  { "game.panel.key_white.tile_size",		"16"			},
  { "game.panel.key_white.draw_masked",		"false"			},
  { "game.panel.key_white.draw_order",		"0"			},
  { "game.panel.key_white.class",		"none"			},
  { "game.panel.key_white.style",		"none"			},
  { "game.panel.key_white_count.x",		"-1"			},
  { "game.panel.key_white_count.y",		"-1"			},
  { "game.panel.key_white_count.align",		"left"			},
  { "game.panel.key_white_count.valign",	"top"			},
  { "game.panel.key_white_count.digits",	"-1"			},
  { "game.panel.key_white_count.font",		"font.text_2"		},
  { "game.panel.key_white_count.draw_masked",	"true"			},
  { "game.panel.key_white_count.draw_order",	"0"			},
  { "game.panel.key_white_count.class",		"none"			},
  { "game.panel.key_white_count.style",		"none"			},

  { "game.panel.score.x",			"50"			},
  { "game.panel.score.y",			"159"			},
  { "game.panel.score.align",			"center"		},
  { "game.panel.score.valign",			"top"			},
  { "game.panel.score.digits",			"5"			},
  { "game.panel.score.font",			"font.text_2"		},
  { "game.panel.score.draw_masked",		"true"			},
  { "game.panel.score.draw_order",		"0"			},
  { "game.panel.score.class",			"none"			},
  { "game.panel.score.style",			"none"			},

  { "game.panel.highscore.x",			"-1"			},
  { "game.panel.highscore.y",			"-1"			},
  { "game.panel.highscore.align",		"left"			},
  { "game.panel.highscore.valign",		"top"			},
  { "game.panel.highscore.digits",		"5"			},
  { "game.panel.highscore.font",		"font.text_2"		},
  { "game.panel.highscore.draw_masked",		"true"			},
  { "game.panel.highscore.draw_order",		"0"			},
  { "game.panel.highscore.class",		"none"			},
  { "game.panel.highscore.style",		"none"			},

  { "game.panel.time.x",			"50"			},
  { "game.panel.time.y",			"194"			},
  { "game.panel.time.align",			"center"		},
  { "game.panel.time.valign",			"top"			},
  { "game.panel.time.digits",			"-1"			},
  { "game.panel.time.font",			"font.text_2"		},
  { "game.panel.time.font_narrow",		"font.text_1"		},
  { "game.panel.time.draw_masked",		"true"			},
  { "game.panel.time.draw_order",		"0"			},
  { "game.panel.time.class",			"none"			},
  { "game.panel.time.style",			"none"			},

  { "game.panel.time_hh.x",			"-1"			},
  { "game.panel.time_hh.y",			"-1"			},
  { "game.panel.time_hh.align",			"left"			},
  { "game.panel.time_hh.valign",		"top"			},
  { "game.panel.time_hh.digits",		"2"			},
  { "game.panel.time_hh.font",			"font.text_2"		},
  { "game.panel.time_hh.draw_masked",		"true"			},
  { "game.panel.time_hh.draw_order",		"0"			},
  { "game.panel.time_hh.class",			"none"			},
  { "game.panel.time_hh.style",			"none"			},
  { "game.panel.time_mm.x",			"-1"			},
  { "game.panel.time_mm.y",			"-1"			},
  { "game.panel.time_mm.align",			"left"			},
  { "game.panel.time_mm.valign",		"top"			},
  { "game.panel.time_mm.digits",		"2"			},
  { "game.panel.time_mm.font",			"font.text_2"		},
  { "game.panel.time_mm.draw_masked",		"true"			},
  { "game.panel.time_mm.draw_order",		"0"			},
  { "game.panel.time_mm.class",			"none"			},
  { "game.panel.time_mm.style",			"none"			},
  { "game.panel.time_ss.x",			"-1"			},
  { "game.panel.time_ss.y",			"-1"			},
  { "game.panel.time_ss.align",			"left"			},
  { "game.panel.time_ss.valign",		"top"			},
  { "game.panel.time_ss.digits",		"2"			},
  { "game.panel.time_ss.font",			"font.text_2"		},
  { "game.panel.time_ss.draw_masked",		"true"			},
  { "game.panel.time_ss.draw_order",		"0"			},
  { "game.panel.time_ss.class",			"none"			},
  { "game.panel.time_ss.style",			"none"			},

  { "game.panel.time_anim.x",			"5"			},
  { "game.panel.time_anim.y",			"72"			},
  { "game.panel.time_anim.direction",		"right"			},
  { "game.panel.time_anim.class",		"mm_engine_only"	},
  { "game.panel.time_anim.style",		"none"			},

  { "game.panel.health.x",			"-1"			},
  { "game.panel.health.y",			"-1"			},
  { "game.panel.health.align",			"center"		},
  { "game.panel.health.valign",			"top"			},
  { "game.panel.health.digits",			"-1"			},
  { "game.panel.health.font",			"font.text_2"		},
  { "game.panel.health.font_narrow",		"font.text_1"		},
  { "game.panel.health.draw_masked",		"true"			},
  { "game.panel.health.draw_order",		"0"			},
  { "game.panel.health.class",			"none"			},
  { "game.panel.health.style",			"none"			},

  { "game.panel.health_anim.x",			"5"			},
  { "game.panel.health_anim.y",			"107"			},
  { "game.panel.health_anim.direction",		"right"			},
  { "game.panel.health_anim.class",		"mm_engine_only"	},
  { "game.panel.health_anim.style",		"reverse"		},

  { "game.panel.frame.x",			"-1"			},
  { "game.panel.frame.y",			"-1"			},
  { "game.panel.frame.align",			"left"			},
  { "game.panel.frame.valign",			"top"			},
  { "game.panel.frame.digits",			"-1"			},
  { "game.panel.frame.font",			"font.text_2"		},
  { "game.panel.frame.draw_masked",		"true"			},
  { "game.panel.frame.draw_order",		"0"			},
  { "game.panel.frame.class",			"none"			},
  { "game.panel.frame.style",			"none"			},

  { "game.panel.shield_normal.x",		"-1"			},
  { "game.panel.shield_normal.y",		"-1"			},
  { "game.panel.shield_normal.tile_size",	"16"			},
  { "game.panel.shield_normal.draw_masked",	"false"			},
  { "game.panel.shield_normal.draw_order",	"0"			},
  { "game.panel.shield_normal_time.x",		"-1"			},
  { "game.panel.shield_normal_time.y",		"-1"			},
  { "game.panel.shield_normal_time.align",	"left"			},
  { "game.panel.shield_normal_time.valign",	"top"			},
  { "game.panel.shield_normal_time.digits",	"-1"			},
  { "game.panel.shield_normal_time.font",	"font.text_2"		},
  { "game.panel.shield_normal_time.draw_masked", "true"			},
  { "game.panel.shield_normal_time.draw_order",	"0"			},
  { "game.panel.shield_normal_time.class",	"none"			},
  { "game.panel.shield_normal_time.style",	"none"			},
  { "game.panel.shield_deadly.x",		"-1"			},
  { "game.panel.shield_deadly.y",		"-1"			},
  { "game.panel.shield_deadly.tile_size",	"16"			},
  { "game.panel.shield_deadly.draw_masked",	"false"			},
  { "game.panel.shield_deadly.draw_order",	"0"			},
  { "game.panel.shield_deadly_time.x",		"-1"			},
  { "game.panel.shield_deadly_time.y",		"-1"			},
  { "game.panel.shield_deadly_time.align",	"left"			},
  { "game.panel.shield_deadly_time.valign",	"top"			},
  { "game.panel.shield_deadly_time.digits",	"-1"			},
  { "game.panel.shield_deadly_time.font",	"font.text_2"		},
  { "game.panel.shield_deadly_time.draw_masked","true"			},
  { "game.panel.shield_deadly_time.draw_order",	"0"			},
  { "game.panel.shield_deadly_time.class",	"none"			},
  { "game.panel.shield_deadly_time.style",	"none"			},

  { "game.panel.exit.x",			"-1"			},
  { "game.panel.exit.y",			"-1"			},
  { "game.panel.exit.tile_size",		"16"			},
  { "game.panel.exit.draw_masked",		"false"			},
  { "game.panel.exit.draw_order",		"0"			},
  { "game.panel.exit.class",			"none"			},
  { "game.panel.exit.style",			"none"			},

  { "game.panel.emc_magic_ball.x",		"-1"			},
  { "game.panel.emc_magic_ball.y",		"-1"			},
  { "game.panel.emc_magic_ball.tile_size",	"16"			},
  { "game.panel.emc_magic_ball.draw_masked",	"false"			},
  { "game.panel.emc_magic_ball.draw_order",	"0"			},
  { "game.panel.emc_magic_ball_switch.x",	"-1"			},
  { "game.panel.emc_magic_ball_switch.y",	"-1"			},
  { "game.panel.emc_magic_ball_switch.tile_size", "16"			},
  { "game.panel.emc_magic_ball_switch.draw_masked", "true"		},
  { "game.panel.emc_magic_ball_switch.draw_order", "0"			},
  { "game.panel.emc_magic_ball_switch.class",	"none"			},
  { "game.panel.emc_magic_ball_switch.style",	"none"			},

  { "game.panel.light_switch.x",		"-1"			},
  { "game.panel.light_switch.y",		"-1"			},
  { "game.panel.light_switch.tile_size",	"16"			},
  { "game.panel.light_switch.draw_masked",	"false"			},
  { "game.panel.light_switch.draw_order",	"0"			},
  { "game.panel.light_switch_time.x",		"-1"			},
  { "game.panel.light_switch_time.y",		"-1"			},
  { "game.panel.light_switch_time.align",	"left"			},
  { "game.panel.light_switch_time.valign",	"top"			},
  { "game.panel.light_switch_time.digits",	"-1"			},
  { "game.panel.light_switch_time.font",	"font.text_2"		},
  { "game.panel.light_switch_time.draw_masked",	"true"			},
  { "game.panel.light_switch_time.draw_order",	"0"			},
  { "game.panel.light_switch_time.class",	"none"			},
  { "game.panel.light_switch_time.style",	"none"			},

  { "game.panel.timegate_switch.x",		"-1"			},
  { "game.panel.timegate_switch.y",		"-1"			},
  { "game.panel.timegate_switch.tile_size",	"16"			},
  { "game.panel.timegate_switch.draw_masked",	"false"			},
  { "game.panel.timegate_switch.draw_order",	"0"			},
  { "game.panel.timegate_switch_time.x",	"-1"			},
  { "game.panel.timegate_switch_time.y",	"-1"			},
  { "game.panel.timegate_switch_time.align",	"left"			},
  { "game.panel.timegate_switch_time.valign",	"top"			},
  { "game.panel.timegate_switch_time.digits",	"-1"			},
  { "game.panel.timegate_switch_time.font",	"font.text_2"		},
  { "game.panel.timegate_switch_time.draw_masked", "true"		},
  { "game.panel.timegate_switch_time.draw_order", "0"			},
  { "game.panel.timegate_switch_time.class",	"none"			},
  { "game.panel.timegate_switch_time.style",	"none"			},

  { "game.panel.switchgate_switch.x",		"-1"			},
  { "game.panel.switchgate_switch.y",		"-1"			},
  { "game.panel.switchgate_switch.tile_size",	"16"			},
  { "game.panel.switchgate_switch.draw_masked",	"false"			},
  { "game.panel.switchgate_switch.draw_order",	"0"			},
  { "game.panel.switchgate_switch.class",	"none"			},
  { "game.panel.switchgate_switch.style",	"none"			},

  { "game.panel.emc_lenses.x",			"-1"			},
  { "game.panel.emc_lenses.y",			"-1"			},
  { "game.panel.emc_lenses.tile_size",		"16"			},
  { "game.panel.emc_lenses.draw_masked",	"false"			},
  { "game.panel.emc_lenses.draw_order",		"0"			},
  { "game.panel.emc_lenses.class",		"none"			},
  { "game.panel.emc_lenses.style",		"none"			},
  { "game.panel.emc_lenses_time.x",		"-1"			},
  { "game.panel.emc_lenses_time.y",		"-1"			},
  { "game.panel.emc_lenses_time.align",		"left"			},
  { "game.panel.emc_lenses_time.valign",	"top"			},
  { "game.panel.emc_lenses_time.digits",	"-1"			},
  { "game.panel.emc_lenses_time.font",		"font.text_2"		},
  { "game.panel.emc_lenses_time.draw_masked",	"true"			},
  { "game.panel.emc_lenses_time.draw_order",	"0"			},
  { "game.panel.emc_lenses_time.class",		"none"			},
  { "game.panel.emc_lenses_time.style",		"none"			},

  { "game.panel.emc_magnifier.x",		"-1"			},
  { "game.panel.emc_magnifier.y",		"-1"			},
  { "game.panel.emc_magnifier.tile_size",	"16"			},
  { "game.panel.emc_magnifier.draw_masked",	"false"			},
  { "game.panel.emc_magnifier.draw_order",	"0"			},
  { "game.panel.emc_magnifier.class",		"none"			},
  { "game.panel.emc_magnifier.style",		"none"			},
  { "game.panel.emc_magnifier_time.x",		"-1"			},
  { "game.panel.emc_magnifier_time.y",		"-1"			},
  { "game.panel.emc_magnifier_time.align",	"left"			},
  { "game.panel.emc_magnifier_time.valign",	"top"			},
  { "game.panel.emc_magnifier_time.digits",	"-1"			},
  { "game.panel.emc_magnifier_time.font",	"font.text_2"		},
  { "game.panel.emc_magnifier_time.draw_masked","true"			},
  { "game.panel.emc_magnifier_time.draw_order",	"0"			},
  { "game.panel.emc_magnifier_time.class",	"none"			},
  { "game.panel.emc_magnifier_time.style",	"none"			},

  { "game.panel.balloon_switch.x",		"-1"			},
  { "game.panel.balloon_switch.y",		"-1"			},
  { "game.panel.balloon_switch.tile_size",	"16"			},
  { "game.panel.balloon_switch.draw_masked",	"false"			},
  { "game.panel.balloon_switch.draw_order",	"0"			},
  { "game.panel.balloon_switch.class",		"none"			},
  { "game.panel.balloon_switch.style",		"none"			},

  { "game.panel.dynabomb_number.x",		"-1"			},
  { "game.panel.dynabomb_number.y",		"-1"			},
  { "game.panel.dynabomb_number.align",		"left"			},
  { "game.panel.dynabomb_number.valign",	"top"			},
  { "game.panel.dynabomb_number.digits",	"-1"			},
  { "game.panel.dynabomb_number.font",		"font.text_2"		},
  { "game.panel.dynabomb_number.draw_masked",	"true"			},
  { "game.panel.dynabomb_number.draw_order",	"0"			},
  { "game.panel.dynabomb_number.class",		"none"			},
  { "game.panel.dynabomb_number.style",		"none"			},
  { "game.panel.dynabomb_size.x",		"-1"			},
  { "game.panel.dynabomb_size.y",		"-1"			},
  { "game.panel.dynabomb_size.align",		"left"			},
  { "game.panel.dynabomb_size.valign",		"top"			},
  { "game.panel.dynabomb_size.digits",		"-1"			},
  { "game.panel.dynabomb_size.font",		"font.text_2"		},
  { "game.panel.dynabomb_size.draw_masked",	"true"			},
  { "game.panel.dynabomb_size.draw_order",	"0"			},
  { "game.panel.dynabomb_size.class",		"none"			},
  { "game.panel.dynabomb_size.style",		"none"			},
  { "game.panel.dynabomb_power.x",		"-1"			},
  { "game.panel.dynabomb_power.y",		"-1"			},
  { "game.panel.dynabomb_power.tile_size",	"16"			},
  { "game.panel.dynabomb_power.draw_masked",	"false"			},
  { "game.panel.dynabomb_power.draw_order",	"0"			},
  { "game.panel.dynabomb_power.class",		"none"			},
  { "game.panel.dynabomb_power.style",		"none"			},

  { "game.panel.penguins.x",			"-1"			},
  { "game.panel.penguins.y",			"-1"			},
  { "game.panel.penguins.align",		"left"			},
  { "game.panel.penguins.valign",		"top"			},
  { "game.panel.penguins.digits",		"-1"			},
  { "game.panel.penguins.font",			"font.text_2"		},
  { "game.panel.penguins.draw_masked",		"true"			},
  { "game.panel.penguins.draw_order",		"0"			},
  { "game.panel.penguins.class",		"none"			},
  { "game.panel.penguins.style",		"none"			},

  { "game.panel.sokoban_objects.x",		"-1"			},
  { "game.panel.sokoban_objects.y",		"-1"			},
  { "game.panel.sokoban_objects.align",		"left"			},
  { "game.panel.sokoban_objects.valign",	"top"			},
  { "game.panel.sokoban_objects.digits",	"-1"			},
  { "game.panel.sokoban_objects.font",		"font.text_2"		},
  { "game.panel.sokoban_objects.draw_masked",	"true"			},
  { "game.panel.sokoban_objects.draw_order",	"0"			},
  { "game.panel.sokoban_objects.class",		"none"			},
  { "game.panel.sokoban_objects.style",		"none"			},
  { "game.panel.sokoban_fields.x",		"-1"			},
  { "game.panel.sokoban_fields.y",		"-1"			},
  { "game.panel.sokoban_fields.align",		"left"			},
  { "game.panel.sokoban_fields.valign",		"top"			},
  { "game.panel.sokoban_fields.digits",		"-1"			},
  { "game.panel.sokoban_fields.font",		"font.text_2"		},
  { "game.panel.sokoban_fields.draw_masked",	"true"			},
  { "game.panel.sokoban_fields.draw_order",	"0"			},
  { "game.panel.sokoban_fields.class",		"none"			},
  { "game.panel.sokoban_fields.style",		"none"			},

  { "game.panel.robot_wheel.x",			"-1"			},
  { "game.panel.robot_wheel.y",			"-1"			},
  { "game.panel.robot_wheel.tile_size",		"16"			},
  { "game.panel.robot_wheel.draw_masked",	"false"			},
  { "game.panel.robot_wheel.draw_order",	"0"			},
  { "game.panel.robot_wheel.class",		"none"			},
  { "game.panel.robot_wheel.style",		"none"			},

  { "game.panel.conveyor_belt_1.x",		"-1"			},
  { "game.panel.conveyor_belt_1.y",		"-1"			},
  { "game.panel.conveyor_belt_1.tile_size",	"16"			},
  { "game.panel.conveyor_belt_1.draw_masked",	"false"			},
  { "game.panel.conveyor_belt_1.draw_order",	"0"			},
  { "game.panel.conveyor_belt_1.class",		"none"			},
  { "game.panel.conveyor_belt_1.style",		"none"			},
  { "game.panel.conveyor_belt_1_switch.x",	"-1"			},
  { "game.panel.conveyor_belt_1_switch.y",	"-1"			},
  { "game.panel.conveyor_belt_1_switch.tile_size", "16"			},
  { "game.panel.conveyor_belt_1_switch.draw_masked", "false"		},
  { "game.panel.conveyor_belt_1_switch.draw_order", "0"			},
  { "game.panel.conveyor_belt_1_switch.class",	"none"			},
  { "game.panel.conveyor_belt_1_switch.style",	"none"			},
  { "game.panel.conveyor_belt_2.x",		"-1"			},
  { "game.panel.conveyor_belt_2.y",		"-1"			},
  { "game.panel.conveyor_belt_2.tile_size",	"16"			},
  { "game.panel.conveyor_belt_2.draw_masked",	"false"			},
  { "game.panel.conveyor_belt_2.draw_order",	"0"			},
  { "game.panel.conveyor_belt_2.class",		"none"			},
  { "game.panel.conveyor_belt_2.style",		"none"			},
  { "game.panel.conveyor_belt_2_switch.x",	"-1"			},
  { "game.panel.conveyor_belt_2_switch.y",	"-1"			},
  { "game.panel.conveyor_belt_2_switch.tile_size", "16"			},
  { "game.panel.conveyor_belt_2_switch.draw_masked", "false"		},
  { "game.panel.conveyor_belt_2_switch.draw_order", "0"			},
  { "game.panel.conveyor_belt_2_switch.class",	"none"			},
  { "game.panel.conveyor_belt_2_switch.style",	"none"			},
  { "game.panel.conveyor_belt_3.x",		"-1"			},
  { "game.panel.conveyor_belt_3.y",		"-1"			},
  { "game.panel.conveyor_belt_3.tile_size",	"16"			},
  { "game.panel.conveyor_belt_3.draw_masked",	"false"			},
  { "game.panel.conveyor_belt_3.draw_order",	"0"			},
  { "game.panel.conveyor_belt_3.class",		"none"			},
  { "game.panel.conveyor_belt_3.style",		"none"			},
  { "game.panel.conveyor_belt_3_switch.x",	"-1"			},
  { "game.panel.conveyor_belt_3_switch.y",	"-1"			},
  { "game.panel.conveyor_belt_3_switch.tile_size", "16"			},
  { "game.panel.conveyor_belt_3_switch.draw_masked", "false"		},
  { "game.panel.conveyor_belt_3_switch.draw_order", "0"			},
  { "game.panel.conveyor_belt_3_switch.class",	"none"			},
  { "game.panel.conveyor_belt_3_switch.style",	"none"			},
  { "game.panel.conveyor_belt_4.x",		"-1"			},
  { "game.panel.conveyor_belt_4.y",		"-1"			},
  { "game.panel.conveyor_belt_4.tile_size",	"16"			},
  { "game.panel.conveyor_belt_4.draw_masked",	"false"			},
  { "game.panel.conveyor_belt_4.draw_order",	"0"			},
  { "game.panel.conveyor_belt_4.class",		"none"			},
  { "game.panel.conveyor_belt_4.style",		"none"			},
  { "game.panel.conveyor_belt_4_switch.x",	"-1"			},
  { "game.panel.conveyor_belt_4_switch.y",	"-1"			},
  { "game.panel.conveyor_belt_4_switch.tile_size", "16"			},
  { "game.panel.conveyor_belt_4_switch.draw_masked", "false"		},
  { "game.panel.conveyor_belt_4_switch.draw_order", "0"			},
  { "game.panel.conveyor_belt_4_switch.class",	"none"			},
  { "game.panel.conveyor_belt_4_switch.style",	"none"			},

  { "game.panel.magic_wall.x",			"-1"			},
  { "game.panel.magic_wall.y",			"-1"			},
  { "game.panel.magic_wall.tile_size",		"16"			},
  { "game.panel.magic_wall.draw_masked",	"false"			},
  { "game.panel.magic_wall.draw_order",		"0"			},
  { "game.panel.magic_wall.class",		"none"			},
  { "game.panel.magic_wall.style",		"none"			},
  { "game.panel.magic_wall_time.x",		"-1"			},
  { "game.panel.magic_wall_time.y",		"-1"			},
  { "game.panel.magic_wall_time.align",		"left"			},
  { "game.panel.magic_wall_time.valign",	"top"			},
  { "game.panel.magic_wall_time.digits",	"-1"			},
  { "game.panel.magic_wall_time.font",		"font.text_2"		},
  { "game.panel.magic_wall_time.draw_masked",	"true"			},
  { "game.panel.magic_wall_time.draw_order",	"0"			},
  { "game.panel.magic_wall_time.class",		"none"			},
  { "game.panel.magic_wall_time.style",		"none"			},

  { "game.panel.gravity_state.x",		"-1"			},
  { "game.panel.gravity_state.y",		"-1"			},
  { "game.panel.gravity_state.align",		"left"			},
  { "game.panel.gravity_state.valign",		"top"			},
  { "game.panel.gravity_state.chars",		"-1"			},
  { "game.panel.gravity_state.font",		"font.text_1"		},
  { "game.panel.gravity_state.font_active",	"font.text_2"		},
  { "game.panel.gravity_state.draw_masked",	"true"			},
  { "game.panel.gravity_state.draw_order",	"0"			},
  { "game.panel.gravity_state.class",		"none"			},
  { "game.panel.gravity_state.style",		"none"			},

  { "game.panel.graphic_1.x",			"-1"			},
  { "game.panel.graphic_1.y",			"-1"			},
  { "game.panel.graphic_1.draw_masked",		"true"			},
  { "game.panel.graphic_1.draw_order",		"0"			},
  { "game.panel.graphic_1.class",		"none"			},
  { "game.panel.graphic_1.style",		"none"			},
  { "game.panel.graphic_2.x",			"-1"			},
  { "game.panel.graphic_2.y",			"-1"			},
  { "game.panel.graphic_2.draw_masked",		"true"			},
  { "game.panel.graphic_2.draw_order",		"0"			},
  { "game.panel.graphic_2.class",		"none"			},
  { "game.panel.graphic_2.style",		"none"			},
  { "game.panel.graphic_3.x",			"-1"			},
  { "game.panel.graphic_3.y",			"-1"			},
  { "game.panel.graphic_3.draw_masked",		"true"			},
  { "game.panel.graphic_3.draw_order",		"0"			},
  { "game.panel.graphic_3.class",		"none"			},
  { "game.panel.graphic_3.style",		"none"			},
  { "game.panel.graphic_4.x",			"-1"			},
  { "game.panel.graphic_4.y",			"-1"			},
  { "game.panel.graphic_4.draw_masked",		"true"			},
  { "game.panel.graphic_4.draw_order",		"0"			},
  { "game.panel.graphic_4.class",		"none"			},
  { "game.panel.graphic_4.style",		"none"			},
  { "game.panel.graphic_5.x",			"-1"			},
  { "game.panel.graphic_5.y",			"-1"			},
  { "game.panel.graphic_5.draw_masked",		"true"			},
  { "game.panel.graphic_5.draw_order",		"0"			},
  { "game.panel.graphic_5.class",		"none"			},
  { "game.panel.graphic_5.style",		"none"			},
  { "game.panel.graphic_6.x",			"-1"			},
  { "game.panel.graphic_6.y",			"-1"			},
  { "game.panel.graphic_6.draw_masked",		"true"			},
  { "game.panel.graphic_6.draw_order",		"0"			},
  { "game.panel.graphic_6.class",		"none"			},
  { "game.panel.graphic_6.style",		"none"			},
  { "game.panel.graphic_7.x",			"-1"			},
  { "game.panel.graphic_7.y",			"-1"			},
  { "game.panel.graphic_7.draw_masked",		"true"			},
  { "game.panel.graphic_7.draw_order",		"0"			},
  { "game.panel.graphic_7.class",		"none"			},
  { "game.panel.graphic_7.style",		"none"			},
  { "game.panel.graphic_8.x",			"-1"			},
  { "game.panel.graphic_8.y",			"-1"			},
  { "game.panel.graphic_8.draw_masked",		"true"			},
  { "game.panel.graphic_8.draw_order",		"0"			},
  { "game.panel.graphic_8.class",		"none"			},
  { "game.panel.graphic_8.style",		"none"			},

  { "game.panel.element_1.x",			"-1"			},
  { "game.panel.element_1.y",			"-1"			},
  { "game.panel.element_1.tile_size",		"16"			},
  { "game.panel.element_1.element",		"empty_space"		},
  { "game.panel.element_1.draw_masked",		"false"			},
  { "game.panel.element_1.draw_order",		"0"			},
  { "game.panel.element_1.class",		"none"			},
  { "game.panel.element_1.style",		"none"			},
  { "game.panel.element_1_count.x",		"-1"			},
  { "game.panel.element_1_count.y",		"-1"			},
  { "game.panel.element_1_count.align",		"left"			},
  { "game.panel.element_1_count.valign",	"top"			},
  { "game.panel.element_1_count.digits",	"-1"			},
  { "game.panel.element_1_count.font",		"font.text_2"		},
  { "game.panel.element_1_count.element",	"empty_space"		},
  { "game.panel.element_1_count.draw_masked",	"true"			},
  { "game.panel.element_1_count.draw_order",	"0"			},
  { "game.panel.element_1_count.class",		"none"			},
  { "game.panel.element_1_count.style",		"none"			},
  { "game.panel.element_2.x",			"-1"			},
  { "game.panel.element_2.y",			"-1"			},
  { "game.panel.element_2.tile_size",		"16"			},
  { "game.panel.element_2.element",		"empty_space"		},
  { "game.panel.element_2.draw_masked",		"false"			},
  { "game.panel.element_2.draw_order",		"0"			},
  { "game.panel.element_2.class",		"none"			},
  { "game.panel.element_2.style",		"none"			},
  { "game.panel.element_2_count.x",		"-1"			},
  { "game.panel.element_2_count.y",		"-1"			},
  { "game.panel.element_2_count.align",		"left"			},
  { "game.panel.element_2_count.valign",	"top"			},
  { "game.panel.element_2_count.digits",	"-1"			},
  { "game.panel.element_2_count.font",		"font.text_2"		},
  { "game.panel.element_2_count.element",	"empty_space"		},
  { "game.panel.element_2_count.draw_masked",	"true"			},
  { "game.panel.element_2_count.draw_order",	"0"			},
  { "game.panel.element_2_count.class",		"none"			},
  { "game.panel.element_2_count.style",		"none"			},
  { "game.panel.element_3.x",			"-1"			},
  { "game.panel.element_3.y",			"-1"			},
  { "game.panel.element_3.tile_size",		"16"			},
  { "game.panel.element_3.element",		"empty_space"		},
  { "game.panel.element_3.draw_masked",		"false"			},
  { "game.panel.element_3.draw_order",		"0"			},
  { "game.panel.element_3.class",		"none"			},
  { "game.panel.element_3.style",		"none"			},
  { "game.panel.element_3_count.x",		"-1"			},
  { "game.panel.element_3_count.y",		"-1"			},
  { "game.panel.element_3_count.align",		"left"			},
  { "game.panel.element_3_count.valign",	"top"			},
  { "game.panel.element_3_count.digits",	"-1"			},
  { "game.panel.element_3_count.font",		"font.text_2"		},
  { "game.panel.element_3_count.element",	"empty_space"		},
  { "game.panel.element_3_count.draw_masked",	"true"			},
  { "game.panel.element_3_count.draw_order",	"0"			},
  { "game.panel.element_3_count.class",		"none"			},
  { "game.panel.element_3_count.style",		"none"			},
  { "game.panel.element_4.x",			"-1"			},
  { "game.panel.element_4.y",			"-1"			},
  { "game.panel.element_4.tile_size",		"16"			},
  { "game.panel.element_4.element",		"empty_space"		},
  { "game.panel.element_4.draw_masked",		"false"			},
  { "game.panel.element_4.draw_order",		"0"			},
  { "game.panel.element_4.class",		"none"			},
  { "game.panel.element_4.style",		"none"			},
  { "game.panel.element_4_count.x",		"-1"			},
  { "game.panel.element_4_count.y",		"-1"			},
  { "game.panel.element_4_count.align",		"left"			},
  { "game.panel.element_4_count.valign",	"top"			},
  { "game.panel.element_4_count.digits",	"-1"			},
  { "game.panel.element_4_count.font",		"font.text_2"		},
  { "game.panel.element_4_count.element",	"empty_space"		},
  { "game.panel.element_4_count.draw_masked",	"true"			},
  { "game.panel.element_4_count.draw_order",	"0"			},
  { "game.panel.element_4_count.class",		"none"			},
  { "game.panel.element_4_count.style",		"none"			},
  { "game.panel.element_5.x",			"-1"			},
  { "game.panel.element_5.y",			"-1"			},
  { "game.panel.element_5.tile_size",		"16"			},
  { "game.panel.element_5.element",		"empty_space"		},
  { "game.panel.element_5.draw_masked",		"false"			},
  { "game.panel.element_5.draw_order",		"0"			},
  { "game.panel.element_5.class",		"none"			},
  { "game.panel.element_5.style",		"none"			},
  { "game.panel.element_5_count.x",		"-1"			},
  { "game.panel.element_5_count.y",		"-1"			},
  { "game.panel.element_5_count.align",		"left"			},
  { "game.panel.element_5_count.valign",	"top"			},
  { "game.panel.element_5_count.digits",	"-1"			},
  { "game.panel.element_5_count.font",		"font.text_2"		},
  { "game.panel.element_5_count.element",	"empty_space"		},
  { "game.panel.element_5_count.draw_masked",	"true"			},
  { "game.panel.element_5_count.draw_order",	"0"			},
  { "game.panel.element_5_count.class",		"none"			},
  { "game.panel.element_5_count.style",		"none"			},
  { "game.panel.element_6.x",			"-1"			},
  { "game.panel.element_6.y",			"-1"			},
  { "game.panel.element_6.tile_size",		"16"			},
  { "game.panel.element_6.element",		"empty_space"		},
  { "game.panel.element_6.draw_masked",		"false"			},
  { "game.panel.element_6.draw_order",		"0"			},
  { "game.panel.element_6.class",		"none"			},
  { "game.panel.element_6.style",		"none"			},
  { "game.panel.element_6_count.x",		"-1"			},
  { "game.panel.element_6_count.y",		"-1"			},
  { "game.panel.element_6_count.align",		"left"			},
  { "game.panel.element_6_count.valign",	"top"			},
  { "game.panel.element_6_count.digits",	"-1"			},
  { "game.panel.element_6_count.font",		"font.text_2"		},
  { "game.panel.element_6_count.element",	"empty_space"		},
  { "game.panel.element_6_count.draw_masked",	"true"			},
  { "game.panel.element_6_count.draw_order",	"0"			},
  { "game.panel.element_6_count.class",		"none"			},
  { "game.panel.element_6_count.style",		"none"			},
  { "game.panel.element_7.x",			"-1"			},
  { "game.panel.element_7.y",			"-1"			},
  { "game.panel.element_7.tile_size",		"16"			},
  { "game.panel.element_7.element",		"empty_space"		},
  { "game.panel.element_7.draw_masked",		"false"			},
  { "game.panel.element_7.draw_order",		"0"			},
  { "game.panel.element_7.class",		"none"			},
  { "game.panel.element_7.style",		"none"			},
  { "game.panel.element_7_count.x",		"-1"			},
  { "game.panel.element_7_count.y",		"-1"			},
  { "game.panel.element_7_count.align",		"left"			},
  { "game.panel.element_7_count.valign",	"top"			},
  { "game.panel.element_7_count.digits",	"-1"			},
  { "game.panel.element_7_count.font",		"font.text_2"		},
  { "game.panel.element_7_count.element",	"empty_space"		},
  { "game.panel.element_7_count.draw_masked",	"true"			},
  { "game.panel.element_7_count.draw_order",	"0"			},
  { "game.panel.element_7_count.class",		"none"			},
  { "game.panel.element_7_count.style",		"none"			},
  { "game.panel.element_8.x",			"-1"			},
  { "game.panel.element_8.y",			"-1"			},
  { "game.panel.element_8.tile_size",		"16"			},
  { "game.panel.element_8.element",		"empty_space"		},
  { "game.panel.element_8.draw_masked",		"false"			},
  { "game.panel.element_8.draw_order",		"0"			},
  { "game.panel.element_8.class",		"none"			},
  { "game.panel.element_8.style",		"none"			},
  { "game.panel.element_8_count.x",		"-1"			},
  { "game.panel.element_8_count.y",		"-1"			},
  { "game.panel.element_8_count.align",		"left"			},
  { "game.panel.element_8_count.valign",	"top"			},
  { "game.panel.element_8_count.digits",	"-1"			},
  { "game.panel.element_8_count.font",		"font.text_2"		},
  { "game.panel.element_8_count.element",	"empty_space"		},
  { "game.panel.element_8_count.draw_masked",	"true"			},
  { "game.panel.element_8_count.draw_order",	"0"			},
  { "game.panel.element_8_count.class",		"none"			},
  { "game.panel.element_8_count.style",		"none"			},

  { "game.panel.ce_score_1.x",			"-1"			},
  { "game.panel.ce_score_1.y",			"-1"			},
  { "game.panel.ce_score_1.align",		"left"			},
  { "game.panel.ce_score_1.valign",		"top"			},
  { "game.panel.ce_score_1.digits",		"-1"			},
  { "game.panel.ce_score_1.font",		"font.text_2"		},
  { "game.panel.ce_score_1.element",		"empty_space"		},
  { "game.panel.ce_score_1.draw_masked",	"true"			},
  { "game.panel.ce_score_1.draw_order",		"0"			},
  { "game.panel.ce_score_1.class",		"none"			},
  { "game.panel.ce_score_1.style",		"none"			},
  { "game.panel.ce_score_1_element.x",		"-1"			},
  { "game.panel.ce_score_1_element.y",		"-1"			},
  { "game.panel.ce_score_1_element.tile_size",	"16"			},
  { "game.panel.ce_score_1_element.element",	"empty_space"		},
  { "game.panel.ce_score_1_element.draw_masked","false"			},
  { "game.panel.ce_score_1_element.draw_order",	"0"			},
  { "game.panel.ce_score_1_element.class",	"none"			},
  { "game.panel.ce_score_1_element.style",	"none"			},
  { "game.panel.ce_score_2.x",			"-1"			},
  { "game.panel.ce_score_2.y",			"-1"			},
  { "game.panel.ce_score_2.align",		"left"			},
  { "game.panel.ce_score_2.valign",		"top"			},
  { "game.panel.ce_score_2.digits",		"-1"			},
  { "game.panel.ce_score_2.font",		"font.text_2"		},
  { "game.panel.ce_score_2.element",		"empty_space"		},
  { "game.panel.ce_score_2.draw_masked",	"true"			},
  { "game.panel.ce_score_2.draw_order",		"0"			},
  { "game.panel.ce_score_2.class",		"none"			},
  { "game.panel.ce_score_2.style",		"none"			},
  { "game.panel.ce_score_2_element.x",		"-1"			},
  { "game.panel.ce_score_2_element.y",		"-1"			},
  { "game.panel.ce_score_2_element.tile_size",	"16"			},
  { "game.panel.ce_score_2_element.element",	"empty_space"		},
  { "game.panel.ce_score_2_element.draw_masked","false"			},
  { "game.panel.ce_score_2_element.draw_order",	"0"			},
  { "game.panel.ce_score_2_element.class",	"none"			},
  { "game.panel.ce_score_2_element.style",	"none"			},
  { "game.panel.ce_score_3.x",			"-1"			},
  { "game.panel.ce_score_3.y",			"-1"			},
  { "game.panel.ce_score_3.align",		"left"			},
  { "game.panel.ce_score_3.valign",		"top"			},
  { "game.panel.ce_score_3.digits",		"-1"			},
  { "game.panel.ce_score_3.font",		"font.text_2"		},
  { "game.panel.ce_score_3.element",		"empty_space"		},
  { "game.panel.ce_score_3.draw_masked",	"true"			},
  { "game.panel.ce_score_3.draw_order",		"0"			},
  { "game.panel.ce_score_3.class",		"none"			},
  { "game.panel.ce_score_3.style",		"none"			},
  { "game.panel.ce_score_3_element.x",		"-1"			},
  { "game.panel.ce_score_3_element.y",		"-1"			},
  { "game.panel.ce_score_3_element.tile_size",	"16"			},
  { "game.panel.ce_score_3_element.element",	"empty_space"		},
  { "game.panel.ce_score_3_element.draw_masked","false"			},
  { "game.panel.ce_score_3_element.draw_order",	"0"			},
  { "game.panel.ce_score_3_element.class",	"none"			},
  { "game.panel.ce_score_3_element.style",	"none"			},
  { "game.panel.ce_score_4.x",			"-1"			},
  { "game.panel.ce_score_4.y",			"-1"			},
  { "game.panel.ce_score_4.align",		"left"			},
  { "game.panel.ce_score_4.valign",		"top"			},
  { "game.panel.ce_score_4.digits",		"-1"			},
  { "game.panel.ce_score_4.font",		"font.text_2"		},
  { "game.panel.ce_score_4.element",		"empty_space"		},
  { "game.panel.ce_score_4.draw_masked",	"true"			},
  { "game.panel.ce_score_4.draw_order",		"0"			},
  { "game.panel.ce_score_4.class",		"none"			},
  { "game.panel.ce_score_4.style",		"none"			},
  { "game.panel.ce_score_4_element.x",		"-1"			},
  { "game.panel.ce_score_4_element.y",		"-1"			},
  { "game.panel.ce_score_4_element.tile_size",	"16"			},
  { "game.panel.ce_score_4_element.element",	"empty_space"		},
  { "game.panel.ce_score_4_element.draw_masked","false"			},
  { "game.panel.ce_score_4_element.draw_order",	"0"			},
  { "game.panel.ce_score_4_element.class",	"none"			},
  { "game.panel.ce_score_4_element.style",	"none"			},
  { "game.panel.ce_score_5.x",			"-1"			},
  { "game.panel.ce_score_5.y",			"-1"			},
  { "game.panel.ce_score_5.align",		"left"			},
  { "game.panel.ce_score_5.valign",		"top"			},
  { "game.panel.ce_score_5.digits",		"-1"			},
  { "game.panel.ce_score_5.font",		"font.text_2"		},
  { "game.panel.ce_score_5.element",		"empty_space"		},
  { "game.panel.ce_score_5.draw_masked",	"true"			},
  { "game.panel.ce_score_5.draw_order",		"0"			},
  { "game.panel.ce_score_5.class",		"none"			},
  { "game.panel.ce_score_5.style",		"none"			},
  { "game.panel.ce_score_5_element.x",		"-1"			},
  { "game.panel.ce_score_5_element.y",		"-1"			},
  { "game.panel.ce_score_5_element.tile_size",	"16"			},
  { "game.panel.ce_score_5_element.element",	"empty_space"		},
  { "game.panel.ce_score_5_element.draw_masked","false"			},
  { "game.panel.ce_score_5_element.draw_order",	"0"			},
  { "game.panel.ce_score_5_element.class",	"none"			},
  { "game.panel.ce_score_5_element.style",	"none"			},
  { "game.panel.ce_score_6.x",			"-1"			},
  { "game.panel.ce_score_6.y",			"-1"			},
  { "game.panel.ce_score_6.align",		"left"			},
  { "game.panel.ce_score_6.valign",		"top"			},
  { "game.panel.ce_score_6.digits",		"-1"			},
  { "game.panel.ce_score_6.font",		"font.text_2"		},
  { "game.panel.ce_score_6.element",		"empty_space"		},
  { "game.panel.ce_score_6.draw_masked",	"true"			},
  { "game.panel.ce_score_6.draw_order",		"0"			},
  { "game.panel.ce_score_6.class",		"none"			},
  { "game.panel.ce_score_6.style",		"none"			},
  { "game.panel.ce_score_6_element.x",		"-1"			},
  { "game.panel.ce_score_6_element.y",		"-1"			},
  { "game.panel.ce_score_6_element.tile_size",	"16"			},
  { "game.panel.ce_score_6_element.element",	"empty_space"		},
  { "game.panel.ce_score_6_element.draw_masked","false"			},
  { "game.panel.ce_score_6_element.draw_order",	"0"			},
  { "game.panel.ce_score_6_element.class",	"none"			},
  { "game.panel.ce_score_6_element.style",	"none"			},
  { "game.panel.ce_score_7.x",			"-1"			},
  { "game.panel.ce_score_7.y",			"-1"			},
  { "game.panel.ce_score_7.align",		"left"			},
  { "game.panel.ce_score_7.valign",		"top"			},
  { "game.panel.ce_score_7.digits",		"-1"			},
  { "game.panel.ce_score_7.font",		"font.text_2"		},
  { "game.panel.ce_score_7.element",		"empty_space"		},
  { "game.panel.ce_score_7.draw_masked",	"true"			},
  { "game.panel.ce_score_7.draw_order",		"0"			},
  { "game.panel.ce_score_7.class",		"none"			},
  { "game.panel.ce_score_7.style",		"none"			},
  { "game.panel.ce_score_7_element.x",		"-1"			},
  { "game.panel.ce_score_7_element.y",		"-1"			},
  { "game.panel.ce_score_7_element.tile_size",	"16"			},
  { "game.panel.ce_score_7_element.element",	"empty_space"		},
  { "game.panel.ce_score_7_element.draw_masked","false"			},
  { "game.panel.ce_score_7_element.draw_order",	"0"			},
  { "game.panel.ce_score_7_element.class",	"none"			},
  { "game.panel.ce_score_7_element.style",	"none"			},
  { "game.panel.ce_score_8.x",			"-1"			},
  { "game.panel.ce_score_8.y",			"-1"			},
  { "game.panel.ce_score_8.align",		"left"			},
  { "game.panel.ce_score_8.valign",		"top"			},
  { "game.panel.ce_score_8.digits",		"-1"			},
  { "game.panel.ce_score_8.font",		"font.text_2"		},
  { "game.panel.ce_score_8.element",		"empty_space"		},
  { "game.panel.ce_score_8.draw_masked",	"true"			},
  { "game.panel.ce_score_8.draw_order",		"0"			},
  { "game.panel.ce_score_8.class",		"none"			},
  { "game.panel.ce_score_8.style",		"none"			},
  { "game.panel.ce_score_8_element.x",		"-1"			},
  { "game.panel.ce_score_8_element.y",		"-1"			},
  { "game.panel.ce_score_8_element.tile_size",	"16"			},
  { "game.panel.ce_score_8_element.element",	"empty_space"		},
  { "game.panel.ce_score_8_element.draw_masked","false"			},
  { "game.panel.ce_score_8_element.draw_order",	"0"			},
  { "game.panel.ce_score_8_element.class",	"none"			},
  { "game.panel.ce_score_8_element.style",	"none"			},

  { "game.panel.player_name.x",			"-1"			},
  { "game.panel.player_name.y",			"-1"			},
  { "game.panel.player_name.align",		"left"			},
  { "game.panel.player_name.valign",		"top"			},
  { "game.panel.player_name.chars",		"-1"			},
  { "game.panel.player_name.font",		"font.text_2"		},
  { "game.panel.player_name.draw_masked",	"true"			},
  { "game.panel.player_name.draw_order",	"0"			},
  { "game.panel.player_name.class",		"none"			},
  { "game.panel.player_name.style",		"none"			},

  { "game.panel.level_name.x",			"-1"			},
  { "game.panel.level_name.y",			"-1"			},
  { "game.panel.level_name.align",		"left"			},
  { "game.panel.level_name.valign",		"top"			},
  { "game.panel.level_name.chars",		"-1"			},
  { "game.panel.level_name.font",		"font.text_2"		},
  { "game.panel.level_name.draw_masked",	"true"			},
  { "game.panel.level_name.draw_order",		"0"			},
  { "game.panel.level_name.class",		"none"			},
  { "game.panel.level_name.style",		"none"			},
  { "game.panel.level_author.x",		"-1"			},
  { "game.panel.level_author.y",		"-1"			},
  { "game.panel.level_author.align",		"left"			},
  { "game.panel.level_author.valign",		"top"			},
  { "game.panel.level_author.chars",		"-1"			},
  { "game.panel.level_author.font",		"font.text_2"		},
  { "game.panel.level_author.draw_masked",	"true"			},
  { "game.panel.level_author.draw_order",	"0"			},
  { "game.panel.level_author.class",		"none"			},
  { "game.panel.level_author.style",		"none"			},

  { "game.button.stop.x",			"5"			},
  { "game.button.stop.y",			"215"			},
  { "game.button.pause.x",			"35"			},
  { "game.button.pause.y",			"215"			},
  { "game.button.play.x",			"65"			},
  { "game.button.play.y",			"215"			},
  { "game.button.undo.x",			"-1"			},
  { "game.button.undo.y",			"-1"			},
  { "game.button.redo.x",			"-1"			},
  { "game.button.redo.y",			"-1"			},
  { "game.button.save.x",			"-1"			},
  { "game.button.save.y",			"-1"			},
  { "game.button.pause2.x",			"-1"			},
  { "game.button.pause2.y",			"-1"			},
  { "game.button.load.x",			"-1"			},
  { "game.button.load.y",			"-1"			},
  { "game.button.sound_music.x",		"5"			},
  { "game.button.sound_music.y",		"245"			},
  { "game.button.sound_loops.x",		"35"			},
  { "game.button.sound_loops.y",		"245"			},
  { "game.button.sound_simple.x",		"65"			},
  { "game.button.sound_simple.y",		"245"			},

  { "game.button.panel_stop.x",			"-1"			},
  { "game.button.panel_stop.y",			"-1"			},
  { "game.button.panel_pause.x",		"-1"			},
  { "game.button.panel_pause.y",		"-1"			},
  { "game.button.panel_play.x",			"-1"			},
  { "game.button.panel_play.y",			"-1"			},
  { "game.button.panel_sound_music.x",		"-1"			},
  { "game.button.panel_sound_music.y",		"-1"			},
  { "game.button.panel_sound_loops.x",		"-1"			},
  { "game.button.panel_sound_loops.y",		"-1"			},
  { "game.button.panel_sound_simple.x",		"-1"			},
  { "game.button.panel_sound_simple.y",		"-1"			},

  { "game.button.touch_stop.x",			"0"			},
  { "game.button.touch_stop.y",			"0"			},
  { "game.button.touch_pause.x",		"-60"			},
  { "game.button.touch_pause.y",		"0"			},

  { "tape.button.eject.x",			"5"			},
  { "tape.button.eject.y",			"77"			},
  { "tape.button.stop.x",			"23"			},
  { "tape.button.stop.y",			"77"			},
  { "tape.button.pause.x",			"41"			},
  { "tape.button.pause.y",			"77"			},
  { "tape.button.record.x",			"59"			},
  { "tape.button.record.y",			"77"			},
  { "tape.button.play.x",			"77"			},
  { "tape.button.play.y",			"77"			},

  { "tape.button.insert_solution.x",		"-1"			},
  { "tape.button.insert_solution.y",		"-1"			},
  { "tape.button.play_solution.x",		"-1"			},
  { "tape.button.play_solution.y",		"-1"			},

  { "tape.symbol.eject.x",			"-1"			},
  { "tape.symbol.eject.y",			"-1"			},
  { "tape.symbol.stop.x",			"-1"			},
  { "tape.symbol.stop.y",			"-1"			},
  { "tape.symbol.pause.x",			"40"			},
  { "tape.symbol.pause.y",			"41"			},
  { "tape.symbol.record.x",			"25"			},
  { "tape.symbol.record.y",			"41"			},
  { "tape.symbol.play.x",			"57"			},
  { "tape.symbol.play.y",			"41"			},
  { "tape.symbol.fast_forward.x",		"39"			},
  { "tape.symbol.fast_forward.y",		"42"			},
  { "tape.symbol.warp_forward.x",		"39"			},
  { "tape.symbol.warp_forward.y",		"42"			},
  { "tape.symbol.warp_forward_blind.x",		"39"			},
  { "tape.symbol.warp_forward_blind.y",		"42"			},
  { "tape.symbol.pause_before_end.x",		"-1"			},
  { "tape.symbol.pause_before_end.y",		"-1"			},
  { "tape.symbol.single_step.x",		"-1"			},
  { "tape.symbol.single_step.y",		"-1"			},

  { "tape.label.eject.x",			"-1"			},
  { "tape.label.eject.y",			"-1"			},
  { "tape.label.stop.x",			"-1"			},
  { "tape.label.stop.y",			"-1"			},
  { "tape.label.pause.x",			"5"			},
  { "tape.label.pause.y",			"61"			},
  { "tape.label.record.x",			"5"			},
  { "tape.label.record.y",			"41"			},
  { "tape.label.play.x",			"70"			},
  { "tape.label.play.y",			"41"			},
  { "tape.label.fast_forward.x",		"5"			},
  { "tape.label.fast_forward.y",		"42"			},
  { "tape.label.warp_forward.x",		"5"			},
  { "tape.label.warp_forward.y",		"42"			},
  { "tape.label.warp_forward_blind.x",		"5"			},
  { "tape.label.warp_forward_blind.y",		"42"			},
  { "tape.label.pause_before_end.x",		"5"			},
  { "tape.label.pause_before_end.y",		"42"			},
  { "tape.label.single_step.x",			"57"			},
  { "tape.label.single_step.y",			"42"			},

  { "tape.label.date.x",			"5"			},
  { "tape.label.date.y",			"5"			},
  { "tape.label.time.x",			"46"			},
  { "tape.label.time.y",			"55"			},

  { "tape.text.date.x",				"7"			},
  { "tape.text.date.y",				"19"			},
  { "tape.text.date.align",			"left"			},
  { "tape.text.date.valign",			"top"			},
  { "tape.text.date.digits",			"-1"			},
  { "tape.text.date.xoffset",			"27"			},
  { "tape.text.date.2nd_xoffset",		"64"			},
  { "tape.text.date.font",			"font.tape_recorder"	},
  { "tape.text.date.draw_masked",		"false"			},

  { "tape.text.date_yyyy.x",			"-1"			},
  { "tape.text.date_yyyy.y",			"-1"			},
  { "tape.text.date_yyyy.align",		"left"			},
  { "tape.text.date_yyyy.valign",		"top"			},
  { "tape.text.date_yyyy.digits",		"4"			},
  { "tape.text.date_yyyy.font",			"font.tape_recorder"	},
  { "tape.text.date_yyyy.draw_masked",		"false"			},
  { "tape.text.date_yy.x",			"-1"			},
  { "tape.text.date_yy.y",			"-1"			},
  { "tape.text.date_yy.align",			"left"			},
  { "tape.text.date_yy.valign",			"top"			},
  { "tape.text.date_yy.digits",			"2"			},
  { "tape.text.date_yy.font",			"font.tape_recorder"	},
  { "tape.text.date_yy.draw_masked",		"false"			},
  { "tape.text.date_mon.x",			"-1"			},
  { "tape.text.date_mon.y",			"-1"			},
  { "tape.text.date_mon.align",			"left"			},
  { "tape.text.date_mon.valign",		"top"			},
  { "tape.text.date_mon.chars",			"3"			},
  { "tape.text.date_mon.font",			"font.tape_recorder"	},
  { "tape.text.date_mon.draw_masked",		"false"			},
  { "tape.text.date_mm.x",			"-1"			},
  { "tape.text.date_mm.y",			"-1"			},
  { "tape.text.date_mm.align",			"left"			},
  { "tape.text.date_mm.valign",			"top"			},
  { "tape.text.date_mm.digits",			"2"			},
  { "tape.text.date_mm.font",			"font.tape_recorder"	},
  { "tape.text.date_mm.draw_masked",		"false"			},
  { "tape.text.date_dd.x",			"-1"			},
  { "tape.text.date_dd.y",			"-1"			},
  { "tape.text.date_dd.align",			"left"			},
  { "tape.text.date_dd.valign",			"top"			},
  { "tape.text.date_dd.digits",			"2"			},
  { "tape.text.date_dd.font",			"font.tape_recorder"	},
  { "tape.text.date_dd.draw_masked",		"false"			},

  { "tape.text.time.x",				"44"			},
  { "tape.text.time.y",				"55"			},
  { "tape.text.time.align",			"left"			},
  { "tape.text.time.valign",			"top"			},
  { "tape.text.time.digits",			"-1"			},
  { "tape.text.time.xoffset",			"27"			},
  { "tape.text.time.font",			"font.tape_recorder"	},
  { "tape.text.time.draw_masked",		"false"			},

  { "tape.text.time_hh.x",			"-1"			},
  { "tape.text.time_hh.y",			"-1"			},
  { "tape.text.time_hh.align",			"left"			},
  { "tape.text.time_hh.valign",			"top"			},
  { "tape.text.time_hh.digits",			"2"			},
  { "tape.text.time_hh.font",			"font.tape_recorder"	},
  { "tape.text.time_hh.draw_masked",		"false"			},
  { "tape.text.time_mm.x",			"-1"			},
  { "tape.text.time_mm.y",			"-1"			},
  { "tape.text.time_mm.align",			"left"			},
  { "tape.text.time_mm.valign",			"top"			},
  { "tape.text.time_mm.digits",			"2"			},
  { "tape.text.time_mm.font",			"font.tape_recorder"	},
  { "tape.text.time_mm.draw_masked",		"false"			},
  { "tape.text.time_ss.x",			"-1"			},
  { "tape.text.time_ss.y",			"-1"			},
  { "tape.text.time_ss.align",			"left"			},
  { "tape.text.time_ss.valign",			"top"			},
  { "tape.text.time_ss.digits",			"2"			},
  { "tape.text.time_ss.font",			"font.tape_recorder"	},
  { "tape.text.time_ss.draw_masked",		"false"			},

  { "tape.text.frame.x",			"-1"			},
  { "tape.text.frame.y",			"-1"			},
  { "tape.text.frame.align",			"left"			},
  { "tape.text.frame.valign",			"top"			},
  { "tape.text.frame.digits",			"-1"			},
  { "tape.text.frame.font",			"font.tape_recorder"	},
  { "tape.text.frame.draw_masked",		"false"			},

  { "tape.show_game_buttons",			"false"			},

  { "editor.button.prev_level.x",		"5"			},
  { "editor.button.prev_level.y",		"5"			},
  { "editor.button.next_level.x",		"79"			},
  { "editor.button.next_level.y",		"5"			},

  { "editor.button.properties.x",		"5"			},
  { "editor.button.properties.y",		"230"			},

  { "editor.button.element_left.x",		"-1"			},
  { "editor.button.element_left.y",		"-1"			},
  { "editor.button.element_left.tile_size",	"-1"			},
  { "editor.button.element_middle.x",		"-1"			},
  { "editor.button.element_middle.y",		"-1"			},
  { "editor.button.element_middle.tile_size",	"-1"			},
  { "editor.button.element_right.x",		"-1"			},
  { "editor.button.element_right.y",		"-1"			},
  { "editor.button.element_right.tile_size",	"-1"			},

  { "editor.button.palette.x",			"-1"			},
  { "editor.button.palette.y",			"-1"			},

  { "editor.button.draw_single.x",		"6"			},
  { "editor.button.draw_single.y",		"6"			},
  { "editor.button.draw_connected.x",		"28"			},
  { "editor.button.draw_connected.y",		"6"			},
  { "editor.button.draw_line.x",		"50"			},
  { "editor.button.draw_line.y",		"6"			},
  { "editor.button.draw_arc.x",			"72"			},
  { "editor.button.draw_arc.y",			"6"			},
  { "editor.button.draw_rectangle.x",		"6"			},
  { "editor.button.draw_rectangle.y",		"28"			},
  { "editor.button.draw_filled_box.x",		"28"			},
  { "editor.button.draw_filled_box.y",		"28"			},
  { "editor.button.rotate_up.x",		"50"			},
  { "editor.button.rotate_up.y",		"28"			},
  { "editor.button.draw_text.x",		"72"			},
  { "editor.button.draw_text.y",		"28"			},
  { "editor.button.flood_fill.x",		"6"			},
  { "editor.button.flood_fill.y",		"50"			},
  { "editor.button.rotate_left.x",		"28"			},
  { "editor.button.rotate_left.y",		"50"			},
  { "editor.button.zoom_level.x",		"50"			},
  { "editor.button.zoom_level.y",		"50"			},
  { "editor.button.rotate_right.x",		"72"			},
  { "editor.button.rotate_right.y",		"50"			},
  { "editor.button.draw_random.x",		"6"			},
  { "editor.button.draw_random.y",		"72"			},
  { "editor.button.grab_brush.x",		"28"			},
  { "editor.button.grab_brush.y",		"72"			},
  { "editor.button.rotate_down.x",		"50"			},
  { "editor.button.rotate_down.y",		"72"			},
  { "editor.button.pick_element.x",		"72"			},
  { "editor.button.pick_element.y",		"72"			},

  { "editor.button.ce_copy_from.x",		"28"			},
  { "editor.button.ce_copy_from.y",		"6"			},
  { "editor.button.ce_copy_to.x",		"50"			},
  { "editor.button.ce_copy_to.y",		"6"			},
  { "editor.button.ce_swap.x",			"72"			},
  { "editor.button.ce_swap.y",			"6"			},
  { "editor.button.ce_copy.x",			"6"			},
  { "editor.button.ce_copy.y",			"72"			},
  { "editor.button.ce_paste.x",			"28"			},
  { "editor.button.ce_paste.y",			"72"			},

  { "editor.button.undo.x",			"5"			},
  { "editor.button.undo.y",			"99"			},
  { "editor.button.conf.x",			"35"			},
  { "editor.button.conf.y",			"99"			},
  { "editor.button.save.x",			"65"			},
  { "editor.button.save.y",			"99"			},
  { "editor.button.clear.x",			"5"			},
  { "editor.button.clear.y",			"119"			},
  { "editor.button.test.x",			"35"			},
  { "editor.button.test.y",			"119"			},
  { "editor.button.exit.x",			"65"			},
  { "editor.button.exit.y",			"119"			},

  { "editor.input.level_number.x",		"29"			},
  { "editor.input.level_number.y",		"5"			},

  { "editor.palette.x",				"5"			},
  { "editor.palette.y",				"30"			},
  { "editor.palette.cols",			"4"			},
  { "editor.palette.rows",			"10"			},
  { "editor.palette.tile_size",			"16"			},
  { "editor.palette.show_as_separate_screen",	"false"			},
  { "editor.palette.show_on_element_buttons",	"false"			},

  { "editor.palette.element_left.x",		"6"			},
  { "editor.palette.element_left.y",		"258"			},
  { "editor.palette.element_left.tile_size",	"16"			},
  { "editor.palette.element_middle.x",		"42"			},
  { "editor.palette.element_middle.y",		"258"			},
  { "editor.palette.element_middle.tile_size",	"16"			},
  { "editor.palette.element_right.x",		"78"			},
  { "editor.palette.element_right.y",		"258"			},
  { "editor.palette.element_right.tile_size",	"16"			},

  { "editor.drawingarea.tile_size",		"16"			},

  { "editor.settings.headline.x",		"272"			},
  { "editor.settings.headline.y",		"16"			},
  { "editor.settings.headline.align",		"center"		},
  { "editor.settings.element_graphic.x",	"24"			},
  { "editor.settings.element_graphic.y",	"64"			},
  { "editor.settings.element_name.x",		"-1"			},
  { "editor.settings.element_name.y",		"-1"			},
  { "editor.settings.tabs.x",			"24"			},
  { "editor.settings.tabs.y",			"64"			},
  { "editor.settings.tabs.2nd_yoffset",		"64"			},
  { "editor.settings.tabs.draw_xoffset",	"0"			},
  { "editor.settings.tabs.draw_yoffset",	"8"			},
  { "editor.settings.tooltip.x",		"-1"			},
  { "editor.settings.tooltip.y",		"-1"			},

  { "editor.gadget.normal_spacing",		"4"			},
  { "editor.gadget.small_spacing",		"2"			},
  { "editor.gadget.tiny_spacing",		"1"			},
  { "editor.gadget.line_spacing",		"4"			},
  { "editor.gadget.text_spacing",		"4"			},
  { "editor.gadget.separator_line.height",	"2"			},

  { "request.button.yes.x",			"2"			},
  { "request.button.yes.y",			"250"			},
  { "request.button.no.x",			"52"			},
  { "request.button.no.y",			"250"			},
  { "request.button.confirm.x",			"2"			},
  { "request.button.confirm.y",			"250"			},
  { "request.button.player_1.x",		"35"			},
  { "request.button.player_1.y",		"185"			},
  { "request.button.player_1.draw_player",	"true"			},
  { "request.button.player_1.tile_size",	"16"			},
  { "request.button.player_2.x",		"65"			},
  { "request.button.player_2.y",		"215"			},
  { "request.button.player_2.draw_player",	"true"			},
  { "request.button.player_2.tile_size",	"16"			},
  { "request.button.player_3.x",		"35"			},
  { "request.button.player_3.y",		"245"			},
  { "request.button.player_3.draw_player",	"true"			},
  { "request.button.player_3.tile_size",	"16"			},
  { "request.button.player_4.x",		"5"			},
  { "request.button.player_4.y",		"215"			},
  { "request.button.player_4.draw_player",	"true"			},
  { "request.button.player_4.tile_size",	"16"			},

  { "request.button.touch_yes.x",		"0"			},
  { "request.button.touch_yes.y",		"-56"			},
  { "request.button.touch_no.x",		"-92"			},
  { "request.button.touch_no.y",		"-56"			},
  { "request.button.touch_confirm.x",		"0"			},
  { "request.button.touch_confirm.y",		"-56"			},

  { "request.x",				"-1"			},
  { "request.y",				"-1"			},
  { "request.width",				"120"			},
  { "request.height",				"300"			},
  { "request.border_size",			"10"			},
  { "request.line_spacing",			"2"			},
  { "request.step_offset",			"10"			},
  { "request.step_delay",			"20"			},
  { "request.anim_mode",			"default"		},
  { "request.align",				"center"		},
  { "request.valign",				"middle"		},
  { "request.draw_order",			"0"			},
  { "request.autowrap",				"false"			},
  { "request.centered",				"true"			},
  { "request.wrap_single_words",		"true"			},

  { "global.use_envelope_request",		"false"			},

  { "game.graphics_engine_version",		"-1"			},
  { "game.forced_scroll_delay_value",		"-1"			},
  { "game.use_native_emc_graphics_engine",	"false"			},
  { "game.use_native_sp_graphics_engine",	"true"			},
  { "game.use_masked_pushing",			"false"			},
  { "game.tile_size",				"32"			},

  { "[player].boring_delay_fixed",		"1000"			},
  { "[player].boring_delay_random",		"1000"			},
  { "[player].sleeping_delay_fixed",		"2000"			},
  { "[player].sleeping_delay_random",		"2000"			},

  { "viewport.window.width",			"672"			},
  { "viewport.window.height",			"560"			},
  { "viewport.window.min_width",		"-1"			},
  { "viewport.window.min_height",		"-1"			},
  { "viewport.window.max_width",		"-1"			},
  { "viewport.window.max_height",		"-1"			},
  { "viewport.window.TITLE.width",		ARG_DEFAULT		},
  { "viewport.window.TITLE.height",		ARG_DEFAULT		},

  { "viewport.playfield.x",			"6"			},
  { "viewport.playfield.y",			"6"			},
  { "viewport.playfield.width",			"548"			},
  { "viewport.playfield.height",		"548"			},
  { "viewport.playfield.min_width",		"-1"			},
  { "viewport.playfield.min_height",		"-1"			},
  { "viewport.playfield.max_width",		"-1"			},
  { "viewport.playfield.max_height",		"-1"			},
  { "viewport.playfield.margin_left",		"0"			},
  { "viewport.playfield.margin_right",		"0"			},
  { "viewport.playfield.margin_top",		"0"			},
  { "viewport.playfield.margin_bottom",		"0"			},
  { "viewport.playfield.border_left",		"-1"			},
  { "viewport.playfield.border_right",		"-1"			},
  { "viewport.playfield.border_top",		"-1"			},
  { "viewport.playfield.border_bottom",		"-1"			},
  { "viewport.playfield.border_size",		"2"			},
  { "viewport.playfield.align_size",		"16"			},
  { "viewport.playfield.align",			"left"			},
  { "viewport.playfield.valign",		"top"			},
  { "viewport.playfield.MAIN.x",		ARG_DEFAULT		},
  { "viewport.playfield.MAIN.y",		ARG_DEFAULT		},
  { "viewport.playfield.MAIN.width",		ARG_DEFAULT		},
  { "viewport.playfield.MAIN.height",		ARG_DEFAULT		},
  { "viewport.playfield.MAIN.min_width",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.min_height",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.max_width",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.max_height",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.margin_left",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.margin_right",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.margin_top",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.margin_bottom",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.border_left",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.border_right",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.border_top",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.border_bottom",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.border_size",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.align_size",	ARG_DEFAULT		},
  { "viewport.playfield.MAIN.align",		ARG_DEFAULT		},
  { "viewport.playfield.MAIN.valign",		ARG_DEFAULT		},
  { "viewport.playfield.SCORES.x",		ARG_DEFAULT		},
  { "viewport.playfield.SCORES.y",		ARG_DEFAULT		},
  { "viewport.playfield.SCORES.width",		ARG_DEFAULT		},
  { "viewport.playfield.SCORES.height",		ARG_DEFAULT		},
  { "viewport.playfield.SCORES.min_width",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.min_height",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.max_width",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.max_height",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.margin_left",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.margin_right",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.margin_top",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.margin_bottom",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.border_left",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.border_right",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.border_top",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.border_bottom",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.border_size",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.align_size",	ARG_DEFAULT		},
  { "viewport.playfield.SCORES.align",		ARG_DEFAULT		},
  { "viewport.playfield.SCORES.valign",		ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.x",		ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.y",		ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.width",		ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.height",		ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.min_width",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.min_height",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.max_width",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.max_height",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.margin_left",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.margin_right",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.margin_top",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.margin_bottom",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.border_left",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.border_right",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.border_top",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.border_bottom",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.border_size",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.align_size",	ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.align",		ARG_DEFAULT		},
  { "viewport.playfield.EDITOR.valign",		ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.x",		ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.y",		ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.width",		ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.height",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.min_width",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.min_height",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.max_width",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.max_height",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.margin_left",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.margin_right",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.margin_top",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.margin_bottom",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.border_left",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.border_right",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.border_top",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.border_bottom",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.border_size",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.align_size",	ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.align",		ARG_DEFAULT		},
  { "viewport.playfield.PLAYING.valign",	ARG_DEFAULT		},

  { "viewport.door_1.x",			"566"			},
  { "viewport.door_1.y",			"60"			},
  { "viewport.door_1.width",			"100"			},
  { "viewport.door_1.height",			"280"			},
  { "viewport.door_1.border_size",		"4"			},
  { "viewport.door_1.align",			"left"			},
  { "viewport.door_1.valign",			"top"			},
  { "viewport.door_1.MAIN.x",			ARG_DEFAULT		},
  { "viewport.door_1.MAIN.y",			ARG_DEFAULT		},
  { "viewport.door_1.MAIN.width",		ARG_DEFAULT		},
  { "viewport.door_1.MAIN.height",		ARG_DEFAULT		},
  { "viewport.door_1.MAIN.border_size",		ARG_DEFAULT		},
  { "viewport.door_1.MAIN.align",		ARG_DEFAULT		},
  { "viewport.door_1.MAIN.valign",		ARG_DEFAULT		},
  { "viewport.door_1.SCORES.x",			ARG_DEFAULT		},
  { "viewport.door_1.SCORES.y",			ARG_DEFAULT		},
  { "viewport.door_1.SCORES.width",		ARG_DEFAULT		},
  { "viewport.door_1.SCORES.height",		ARG_DEFAULT		},
  { "viewport.door_1.SCORES.border_size",	ARG_DEFAULT		},
  { "viewport.door_1.SCORES.align",		ARG_DEFAULT		},
  { "viewport.door_1.SCORES.valign",		ARG_DEFAULT		},
  { "viewport.door_1.EDITOR.x",			ARG_DEFAULT		},
  { "viewport.door_1.EDITOR.y",			ARG_DEFAULT		},
  { "viewport.door_1.EDITOR.width",		ARG_DEFAULT		},
  { "viewport.door_1.EDITOR.height",		ARG_DEFAULT		},
  { "viewport.door_1.EDITOR.border_size",	ARG_DEFAULT		},
  { "viewport.door_1.EDITOR.align",		ARG_DEFAULT		},
  { "viewport.door_1.EDITOR.valign",		ARG_DEFAULT		},
  { "viewport.door_1.PLAYING.x",		ARG_DEFAULT		},
  { "viewport.door_1.PLAYING.y",		ARG_DEFAULT		},
  { "viewport.door_1.PLAYING.width",		ARG_DEFAULT		},
  { "viewport.door_1.PLAYING.height",		ARG_DEFAULT		},
  { "viewport.door_1.PLAYING.border_size",	ARG_DEFAULT		},
  { "viewport.door_1.PLAYING.align",		ARG_DEFAULT		},
  { "viewport.door_1.PLAYING.valign",		ARG_DEFAULT		},

  { "viewport.door_2.x",			"566"			},
  { "viewport.door_2.y",			"400"			},
  { "viewport.door_2.width",			"100"			},
  { "viewport.door_2.height",			"100"			},
  { "viewport.door_2.border_size",		"4"			},
  { "viewport.door_2.align",			"left"			},
  { "viewport.door_2.valign",			"top"			},
  { "viewport.door_2.MAIN.x",			ARG_DEFAULT		},
  { "viewport.door_2.MAIN.y",			ARG_DEFAULT		},
  { "viewport.door_2.MAIN.width",		ARG_DEFAULT		},
  { "viewport.door_2.MAIN.height",		ARG_DEFAULT		},
  { "viewport.door_2.MAIN.border_size",		ARG_DEFAULT		},
  { "viewport.door_2.MAIN.align",		ARG_DEFAULT		},
  { "viewport.door_2.MAIN.valign",		ARG_DEFAULT		},
  { "viewport.door_2.SCORES.x",			ARG_DEFAULT		},
  { "viewport.door_2.SCORES.y",			ARG_DEFAULT		},
  { "viewport.door_2.SCORES.width",		ARG_DEFAULT		},
  { "viewport.door_2.SCORES.height",		ARG_DEFAULT		},
  { "viewport.door_2.SCORES.border_size",	ARG_DEFAULT		},
  { "viewport.door_2.SCORES.align",		ARG_DEFAULT		},
  { "viewport.door_2.SCORES.valign",		ARG_DEFAULT		},
  { "viewport.door_2.EDITOR.x",			"566"			},
  { "viewport.door_2.EDITOR.y",			"356"			},
  { "viewport.door_2.EDITOR.width",		"100"			},
  { "viewport.door_2.EDITOR.height",		"144"			},
  { "viewport.door_2.EDITOR.border_size",	"4"			},
  { "viewport.door_2.EDITOR.align",		"left"			},
  { "viewport.door_2.EDITOR.valign",		"top"			},
  { "viewport.door_2.PLAYING.x",		ARG_DEFAULT		},
  { "viewport.door_2.PLAYING.y",		ARG_DEFAULT		},
  { "viewport.door_2.PLAYING.width",		ARG_DEFAULT		},
  { "viewport.door_2.PLAYING.height",		ARG_DEFAULT		},
  { "viewport.door_2.PLAYING.border_size",	ARG_DEFAULT		},
  { "viewport.door_2.PLAYING.align",		ARG_DEFAULT		},
  { "viewport.door_2.PLAYING.valign",		ARG_DEFAULT		},

  { NULL,					NULL			}
};
