\name{getVariableIndex.ggobi}
\alias{getVariableIndex.ggobi}
\title{Convert variable names into indices.}
\description{
 It is best to refer to variables in ggobi datasets by name,
 but these are converted to indices when passed to internal C code.
 This function performs this mapping by matching the
 specified variable names against those of the dataset in which
 they are to be resolved. 

 In most cases, the user does not have to call this function
 directly. The other functions in the package that operate on
 ggobi variable references call this function implicitly.
}
\usage{
getVariableIndex.ggobi(..., .data = 1, .gobi=getDefaultGGobi()) }
\arguments{
  \item{\dots}{the names (or indices) of variables to resolve
   and compute the internal indices. Non-character values are left unaltered
   and returned as is.}
  \item{.data}{the identifier for the dataset against which to resolve the
    variable names. This should be an object of class \code{ggobiDataset},
    a name (as returned from names.ggobi), or an integer giving the dataset by order.}
  \item{.gobi}{the identified for the ggobi instance in which to find the dataset.}
}

\value{
  An integer vector giving the indices of the variables
referenced in the \code{\dots} arguments.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}


\examples{

 data(mtcars)
 g = ggobi(mtcars)
 g$getVariableIndex("mpg")
 g$getVariableIndex(c("mpg", "cyl"))

  # Now ask about a variable that doesn't exist
  # and get an NA for "tars".
 g$getVariableIndex(c("tars", "cyl"))
  
 
}
\keyword{iplot}
\keyword{dynamic}
