// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/os/linux/signals_ia32.cpp,v 1.11 2001/11/20 11:06:08 xli18 Exp $
//
// We use signal handlers to detect null pointer and divide by zero
// exceptions.
// There must be an easier way of locating the context in the signal
// handler than what we do here.

#include "platform.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <assert.h>

#undef __USE_XOPEN
#include <signal.h>
#include <pthread.h>
#include <sys/time.h>
#include <unistd.h>
#include <asm/sigcontext.h>
#include <asm/ucontext.h>
#include "method_lookup.h"

#include "Class.h"
#include "Package.h"
#include "environment.h"
#include "Class_File_Loader.h"
 
#include "gc_for_orp.h"
 
#include "exceptions.h"
#include "orp_synch.h"
#include "orp_threads.h"
#include "orp_utils.h"
#include "compile.h"
#include "orp_synch.h"
#include "orp_stats.h"
#include "sync_bits.h"

#ifdef OBJECT_LOCK_V2
#include "object_generic_olv2.h"
#include "thread_manager_olv2.h"
#else
#include "object_generic.h"
#include "thread_manager.h"
#endif

#include "platform2.h"

#include "exception_filter.h"
#include "jvmdi_clean.h"

// Variables used to locate the context from the signal handler
static int sc_nest = -1;
static bool use_ucontext = false;
static uint32 exam_point;

#ifdef LINUX_THREAD_SUSPEND

#include <semaphore.h>

static sigset_t sigset;
static sem_t suspend_sem, resume_sem;
//static volatile bool resume_event;

bool suspend_thread(ORP_thread *thread){

#undef SUSPEND_DEBUG
#ifdef SUSPEND_DEBUG
    printf( "to suspend thread %d\n", thread->thread_handle );
    fflush(stdout);
#endif

    int stat = pthread_kill( thread->thread_handle, SIGUSR1 );
    if(!stat){
        sem_wait( &suspend_sem );
        return TRUE;
    }else
        return FALSE;

}

bool resume_thread(ORP_thread *thread){

#ifdef SUSPEND_DEBUG
    printf( "to resume thread %d, resume_event is %d\n", thread->thread_handle,  thread->gc_resume_event_handle );
    fflush(stdout);
#endif

    int stat = 0;
    stat = pthread_kill( thread->thread_handle, SIGUSR2 );
  
//  thread->gc_resume_event_handle = TRUE; 

    if(!stat){
        sem_wait( &resume_sem );
#ifdef SUSPEND_DEBUG
        printf( "successfully resume thread %d\n", thread->thread_handle );
        fflush(stdout);
#endif
        return TRUE;
    }else
        return FALSE;
}

void suspend_handler(int xx){
    sigcontext *sc;
    uint32 *ebp;
    int i;
    ORP_thread *thread = p_TLS_orpthread;    

    asm("movl  %%ebp,%0" : "=g" (ebp));


    for (i = 0; i < sc_nest; i++) {
        ebp = (uint32 *)ebp[0];
    }

    if (!use_ucontext) {
        sc = (sigcontext *)(ebp + 3);
    } else {
        sc = (sigcontext *) &((struct ucontext *)ebp[4])->uc_mcontext;
    }

    thread->regs.eax = sc->eax;
    thread->regs.ebx = sc->ebx;
    thread->regs.ecx = sc->ecx;
    thread->regs.edx = sc->edx;
    thread->regs.edi = sc->edi;
    thread->regs.esi = sc->esi;
    thread->regs.ebp = sc->ebp;
    thread->regs.esp = sc->esp;
    thread->regs.eip = sc->eip;
    
     
#ifdef SUSPEND_DEBUG
    ORP_Code_Type orpct = orp_identify_eip_deadlock_free((void *)sc->eip);
    if(orpct == ORP_TYPE_JAVA) {
         printf("in handler, got a Java frame !\n");
         fflush(stdout);
	}
#endif

//    thread->gc_resume_event_handle = FALSE;

    sem_post( &suspend_sem );

#ifdef SUSPEND_DEBUG
    printf( "in handler, thread %d is suspended, resume_event is %d\n", thread->thread_handle,  thread->gc_resume_event_handle );
    fflush(stdout);
#endif

/*   
    while( !thread->gc_resume_event_handle ){
#ifdef SUSPEND_DEBUG
        printf( "thread %d is in busy looping\n",thread->thread_handle );
        fflush(stdout);
        sleep(1);
#endif
    }
*/
    sigwait( &sigset, &xx );

    sem_post( &resume_sem );

#ifdef SUSPEND_DEBUG
    printf( "in handler, thread %d is resumed\n", thread->thread_handle );
    fflush(stdout);
#endif


}
#else // LINUX_THREAD_SUSPEND
bool suspend_thread(ORP_thread *xx){ return 0; }
bool resume_thread(ORP_thread *xx){ return 1; }
#endif // LINUX_THREAD_SUSPEND

/*
 * We find the true signal stack frame set-up by kernel,which is located
 * by locate_sigcontext() below; then change its content according to 
 * exception handling semantics, so that when the signal handler is 
 * returned, application can continue its execution in Java exception handler.
 */

void null_java_reference_handler(int xx)
{
    sigcontext *sc, *top_sc;
    uint32 *ebp, *top_ebp;
    int i;

    asm("movl  %%ebp,%0" : "=g" (top_ebp));

    ebp = top_ebp;

    for (i = 0; i < sc_nest; i++) {
        ebp = (uint32 *)ebp[0];
    }
    if (!use_ucontext) {
        sc = (sigcontext *)(ebp + 3);
        top_sc = (sigcontext *)(top_ebp + 3);
    } else {
        sc = (sigcontext *) &((struct ucontext *)ebp[4])->uc_mcontext;
    }

/*
    printf("null_java_reference_handler\n");

    printf("gs = 0x%x\n", sc->gs);
    printf("fs = 0x%x\n", sc->fs);
    printf("es = 0x%x\n", sc->es);
    printf("ds = 0x%x\n", sc->ds);
    printf("edi = 0x%x\n", sc->edi);
    printf("esi = 0x%x\n", sc->esi);
    printf("ebp = 0x%x\n", sc->ebp);
    printf("esp = 0x%x\n", sc->esp);
    printf("ebx = 0x%x\n", sc->ebx);
    printf("edx = 0x%x\n", sc->edx);
    printf("ecx = 0x%x\n", sc->ecx);
    printf("eax = 0x%x\n", sc->eax);
    printf("trapno = 0x%x\n", sc->trapno);
    printf("err = 0x%x\n", sc->err);
    printf("eip = 0x%x\n", sc->eip);
    printf("cs = 0x%x\n", sc->cs);
    printf("eflags = 0x%x\n", sc->eflags);
    printf("esp_at_signal = 0x%x\n", sc->esp_at_signal);
    printf("ss = 0x%x\n", sc->ss);
*/
    Global_Env *env = ORP_Global_State::loader_env;

    ORP_Code_Type orpct = orp_identify_eip((void *)sc->eip);
    if(orpct != ORP_TYPE_JAVA)
        assert(0);

    // test if we hit a java application debugger breakpoint
    uint8 *p_instruction = (uint8 *)(sc->eip);
    if(*p_instruction == 0x6f)
       {
           void *address_of_at_a_jit_breakpoint = 
               getaddress__orp_at_a_jit_breakpoint(); 
           p_TLS_orpthread->regs.eip = (uint32)(sc->eip);
	   sc->eip = (long unsigned int)address_of_at_a_jit_breakpoint;
           return;     
       } 

    volatile Java_java_lang_Object *exc = 
        (Java_java_lang_Object *)env->java_lang_NullPointerException_Class;

    Frame_Context fc;
    fc.p_edi = (uint32 *)&(sc->edi);
    fc.p_esi = (uint32 *)&(sc->esi);
    fc.p_ebx = (uint32 *)&(sc->ebx);
    fc.p_ebp = (uint32 *)&(sc->ebp);
    fc.p_eip = (uint32 *)&(sc->eip);
    fc.esp   = sc->esp_at_signal;
    fc.ljf   = (uint32)get_orp_last_java_frame();

    // The exception object will be created by orp_null_ptr_throw.
    orp_null_ptr_throw(&fc, &exc);

    sc->esp_at_signal = fc.esp;
    sc->esp = fc.esp;  // is setting both esp's correct??

    sc->eip = *fc.p_eip;
    sc->ebp = *fc.p_ebp;
    sc->ebx = *fc.p_ebx;
    sc->esi = *fc.p_esi;
    sc->edi = *fc.p_edi;
    sc->eax = (uint32)exc;

    top_sc->esp_at_signal = fc.esp;
    top_sc->esp = fc.esp;  // is setting both esp's correct??

    top_sc->eip = *fc.p_eip;
    top_sc->ebp = *fc.p_ebp;
    top_sc->ebx = *fc.p_ebx;
    top_sc->esi = *fc.p_esi;
    top_sc->edi = *fc.p_edi;
    top_sc->eax = (uint32)exc;

/*
    printf("************ AFTER THE THROW ********\n");
    printf("gs = 0x%x\n", sc->gs);
    printf("fs = 0x%x\n", sc->fs);
    printf("es = 0x%x\n", sc->es);
    printf("ds = 0x%x\n", sc->ds);
    printf("edi = 0x%x\n", sc->edi);
    printf("esi = 0x%x\n", sc->esi);
    printf("ebp = 0x%x\n", sc->ebp);
    printf("esp = 0x%x\n", sc->esp);
    printf("ebx = 0x%x\n", sc->ebx);
    printf("edx = 0x%x\n", sc->edx);
    printf("ecx = 0x%x\n", sc->ecx);
    printf("eax = 0x%x\n", sc->eax);
    printf("trapno = 0x%x\n", sc->trapno);
    printf("err = 0x%x\n", sc->err);
    printf("eip = 0x%x\n", sc->eip);
    printf("cs = 0x%x\n", sc->cs);
    printf("eflags = 0x%x\n", sc->eflags);
    printf("esp_at_signal = 0x%x\n", sc->esp_at_signal);
    printf("ss = 0x%x\n", sc->ss);
*/
}


void null_java_divide_by_zero_handler(int xx)
{
    sigcontext *sc, *top_sc;
    uint32 *ebp, *top_ebp;
    int i;

    asm("movl  %%ebp,%0" : "=g" (top_ebp));

    ebp = top_ebp;

    for (i = 0; i < sc_nest; i++) {
        ebp = (uint32 *)ebp[0];
    }
    if (!use_ucontext) {
        sc = (sigcontext *)(ebp + 3);
        top_sc = (sigcontext *)(top_ebp + 3);
    } else {
        sc = (sigcontext *) &((struct ucontext *)ebp[4])->uc_mcontext;
    }
/*
    printf("null_java_divide_by_zero_handler\n");

    printf("gs = 0x%x\n", sc->gs);
    printf("fs = 0x%x\n", sc->fs);
    printf("es = 0x%x\n", sc->es);
    printf("ds = 0x%x\n", sc->ds);
    printf("edi = 0x%x\n", sc->edi);
    printf("esi = 0x%x\n", sc->esi);
    printf("ebp = 0x%x\n", sc->ebp);
    printf("esp = 0x%x\n", sc->esp);
    printf("ebx = 0x%x\n", sc->ebx);
    printf("edx = 0x%x\n", sc->edx);
    printf("ecx = 0x%x\n", sc->ecx);
    printf("eax = 0x%x\n", sc->eax);
    printf("trapno = 0x%x\n", sc->trapno);
    printf("err = 0x%x\n", sc->err);
    printf("eip = 0x%x\n", sc->eip);
    printf("cs = 0x%x\n", sc->cs);
    printf("eflags = 0x%x\n", sc->eflags);
    printf("esp_at_signal = 0x%x\n", sc->esp_at_signal);
    printf("ss = 0x%x\n", sc->ss);
*/
    Global_Env *env = ORP_Global_State::loader_env;

    ORP_Code_Type orpct = orp_identify_eip((void *)sc->eip);
    if(orpct != ORP_TYPE_JAVA)
        assert(0);

    volatile Java_java_lang_Object *exc = 
        (Java_java_lang_Object *)env->java_lang_ArithmeticException_Class;

    Frame_Context fc;
    fc.p_edi = (uint32 *)&(sc->edi);
    fc.p_esi = (uint32 *)&(sc->esi);
    fc.p_ebx = (uint32 *)&(sc->ebx);
    fc.p_ebp = (uint32 *)&(sc->ebp);
    fc.p_eip = (uint32 *)&(sc->eip);
    fc.esp   = sc->esp_at_signal;
    fc.ljf   = (uint32)get_orp_last_java_frame();

    // The exception object will be created by orp_null_ptr_throw.
    orp_null_ptr_throw(&fc, &exc);

    sc->esp_at_signal = fc.esp;
    sc->esp = fc.esp;  // is setting both esp's correct??

    sc->eip = *fc.p_eip;
    sc->ebp = *fc.p_ebp;
    sc->ebx = *fc.p_ebx;
    sc->esi = *fc.p_esi;
    sc->edi = *fc.p_edi;
    sc->eax = (uint32)exc;

    top_sc->esp_at_signal = fc.esp;
    top_sc->esp = fc.esp;  // is setting both esp's correct??

    top_sc->eip = *fc.p_eip;
    top_sc->ebp = *fc.p_ebp;
    top_sc->ebx = *fc.p_ebx;
    top_sc->esi = *fc.p_esi;
    top_sc->edi = *fc.p_edi;
    top_sc->eax = (uint32)exc;

/*
    printf("************ AFTER THE THROW ********\n");
    printf("gs = 0x%x\n", sc->gs);
    printf("fs = 0x%x\n", sc->fs);
    printf("es = 0x%x\n", sc->es);
    printf("ds = 0x%x\n", sc->ds);
    printf("edi = 0x%x\n", sc->edi);
    printf("esi = 0x%x\n", sc->esi);
    printf("ebp = 0x%x\n", sc->ebp);
    printf("esp = 0x%x\n", sc->esp);
    printf("ebx = 0x%x\n", sc->ebx);
    printf("edx = 0x%x\n", sc->edx);
    printf("ecx = 0x%x\n", sc->ecx);
    printf("eax = 0x%x\n", sc->eax);
    printf("trapno = 0x%x\n", sc->trapno);
    printf("err = 0x%x\n", sc->err);
    printf("eip = 0x%x\n", sc->eip);
    printf("cs = 0x%x\n", sc->cs);
    printf("eflags = 0x%x\n", sc->eflags);
    printf("esp_at_signal = 0x%x\n", sc->esp_at_signal);
    printf("ss = 0x%x\n", sc->ss);
*/
}

/*
See function initialize_signals() below first please.

Two kinds of signal contexts (and stack frames) are tried in
locate_sigcontext(), one is sigcontext, which is the way of
Linux kernel implements( see Linux kernel source
arch/i386/kernel/signal.c for detail); the other is ucontext,
used in some other other platforms.

The sigcontext locating in Linux is not so simple as expected,
because it involves not only the kernel, but also glibc/linuxthreads,
which ORP is linked against. In glibc/linuxthreads, user-provided
signal handler is wrapped by linuxthreads signal handler, i.e.
the signal handler really registered in system is not the one
provided by user. So when Linux kernel finishes setting up signal
stack frame and returns to user mode for singal handler execution,
locate_sigcontext() is not the one being invoked immediately. It's 
called by linuxthreads function. That means the user stack viewed by
locate_sigcontext() is NOT NECESSARILY the signal frame set-up by
kernel, we need find the true one according to glibc/linuxthreads
specific signal implementation in different versions.

Because locate_sigcontext() uses IA32 physical register epb for
call stack frame, compilation option `-fomit-frame-pointer' MUST
not be used when gcc compiles it; and as gcc info, `-O2' will do
`-fomit-frame-pointer' by default, although we haven't seen that
in our experiments.
*/

volatile void locate_sigcontext(int signum)
{
    sigcontext *sc, *found_sc;
    uint32 *ebp;
    int i;

#undef SIGNAL_DEBUG
#ifdef SIGNAL_DEBUG
    printf("locate_sigcontext() called.\n");
    fflush(stdout);
#endif

    asm("movl  %%ebp,%0" : "=r" (ebp));		// ebp = EBP register

#define SC_SEARCH_WIDTH	3
    for (i = 0; i < SC_SEARCH_WIDTH; i++) {
	    sc = (sigcontext *)(ebp + 3 );
#ifdef SIGNAL_DEBUG
	    printf("i: %d, eip: %x\n", i, sc->eip);
	    fflush(stdout);
#endif
	    if (sc->eip == ((uint32)exam_point)) {	// found
	        sc_nest = i;
	        use_ucontext = false;
	        found_sc = sc;
#ifdef SIGNAL_DEBUG
	        printf("sc_nest: %d, do not use ucontext.\n", sc_nest);
	        fflush(stdout);
#endif
        // we will try to find the real sigcontext setup by Linux kernel,
        // because if we want to change the execution path after the signal
        // handling, we must modify the sigcontext used by kernel. 
        // LinuxThreads in glibc 2.1.2 setups a sigcontext for our singal
        // handler, but we should not modify it, because kernel doesn't use 
        // it when resumes the application. Then we must find the sigcontext
        // setup by kernel, and modify it in singal handler. 
		// but, with glibc 2.2.3, it's useless to modify only the sigcontext
        // setup by Linux kernel, because LinuxThreads does a interesting 
        // copy after our signal handler returns, which destroys the 
        // modification we have just done in the handler. So with glibc 2.2.3,
        // what we need do is simply to modify the sigcontext setup by 
        // LinuxThreads, which will be copied to overwrite the one setup by 
        // kernel. Really complicated..., not really. We use a simple trick
        // to overcome the changes in glibc from version to version, that is,
        // we modify both sigcontexts setup by kernel and LinuxThreads. Then
        // it will always work. 

        } else {					// not found
	        struct ucontext *uc;
	        uc = (struct ucontext *)ebp[4];
	        if ((ebp < (uint32 *)uc) && ((uint32 *)uc < ebp + 0x100)) {
		        sc = (sigcontext *)&uc->uc_mcontext;
		        if (sc->eip == ((uint32)exam_point)) {	// found
		            sc_nest = i;
		            use_ucontext = true;
		            found_sc = sc;
#ifdef SIGNAL_DEBUG
		            printf("sc_nest: %d, use ucontext.\n", sc_nest);
		            fflush(stdout);
#endif
		            break; 
                }
            }
        }

        ebp = (uint32 *)ebp[0];
    }

    if (sc_nest < 0) {
        printf("cannot locate sigcontext.\n");
        printf("Please add or remove any irrelevant statementi(e.g. add a null printf) in ORP source code, then rebuild it. If problem remains, please submit a bug report. Thank you very much\n");
        exit(1);
    }

#ifdef SIGNAL_DEBUG
    printf("locate_sigcontext() done.\n");
    fflush(stdout);
#endif
}



void initialize_signals()
{
    // First figure out how to locate the context in the
    // signal handler.  Apparently you have to do it differently
    // on different versions of Linux.

    //attach signal handler locate_sigcontext() with SIGTRAP

    signal(SIGTRAP, (void (*)(int))locate_sigcontext);

    //this asm code sequence is to cause a signal SIGTRAP
    //delivered to itself by operating system

    asm(
        ".byte 0xe8\n\t.long 0\n\t"	// call 0

        //this is "call 0", which does nothing at runtime
        //but pushing the return address, i.e. instruction
        //pointer to next instruction, i.e. "popl %%eax"

        "popl  %%eax\n\t"	// 1 byte

        //pop the return address into eax for arithmetic

        "addb  $9,%%al\n\t"	// 2 byte

        //add the return address with 9, which is the address
        //pointing to instruction after the "int $0x3" below.
        //The instructions length in byte are shown on the
        //rightside of each.

        "movl  %%eax,%0\n\t"	// 5 byte

        //move eax content into static memory variable "exam_point",
        //which is used for sigcontext locating, because when "int 0x3"
        //happens, operating system will save the return address
        //into signal context for process execution resumption;
        //the trick here is that we also save that address in exam_point,
        //so that we can compare the return EIP saved in signal context
        //with exam_point to identify the correct stack frame


        "int   $0x3" : "=m" (exam_point)

        //trigger int3 into operating system kernel, which sends a
        //signal SIGTRAP to current process, setups the signal stack
        //frame on user stack, then returns to user mode execution,
        //i.e. the signal handler locate_sigcontext()

    );

    //when execution goes here, the signal handler locate_sigcontext()
    //has successfully found the signal context setup method on current
    //system; resume SIGTRAP handler back to default

    signal(SIGTRAP, SIG_DFL);
    
    //Now register the real signal handlers. signal() function in Linux
    //kernel has SYSV semantics, i.e. the handler is a kind of ONE SHOT
    //behaviour, which is different from BSD. But glibc2 in Linux
    //implements BSD semantics.

    signal(SIGSEGV, null_java_reference_handler);
    signal(SIGFPE, null_java_divide_by_zero_handler);
    
    extern void interrupt_handler(int);
	signal(SIGINT, (void (*)(int)) interrupt_handler);

#ifdef LINUX_THREAD_SUSPEND

    //some operations for thread suspending
    sigaddset(&sigset, SIGUSR2);
    sigprocmask( SIG_BLOCK, &sigset, NULL);

    signal( SIGUSR1, &suspend_handler);
    sem_init( &suspend_sem, 0, 0);
    sem_init( &resume_sem, 0, 0);

#endif //LINUX_THREAD_SUSPEND

} //initialize_signals
