// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/os/linux/include/platform.h,v 1.8 2001/10/16 03:45:38 xli18 Exp $
//


#ifndef include_platform_h
#define include_platform_h

#include <pthread.h>
#include "Loader_Result.h"

#ifdef __cplusplus
extern "C" {
#endif

#define __fastcall
#define __stdcall
#define   stdcall__  __attribute__ ((__stdcall__))
#define __cdecl
#define _stat stat

#define WORD unsigned short
#define DWORD unsigned int
#define HANDLE unsigned int
#define BOOL unsigned int

typedef unsigned long ULONG;
typedef long LONG;
typedef unsigned long long LONGLONG;

#define IN
#define OUT
#define VOID void
typedef void *PVOID;
typedef void *LPVOID;

typedef unsigned char byte;
typedef unsigned char BYTE;

typedef unsigned char __uint8;
typedef unsigned short __uint16;
typedef unsigned int __uint32;
typedef unsigned long long __uint64;

typedef   signed char  __int8;
typedef   signed short __int16;
typedef   signed int  __int32; 
typedef   signed long long __int64;
typedef   signed long long int64;
typedef    unsigned char boolean;

#define dllexport
#define __declspec(junk)

#define DIR_SEPARATOR '/'
#define PATH_SEPARATOR ':'

void init_linux_thread_system();

#define CRITICAL_SECTION pthread_mutex_t
#define LPCRITICAL_SECTION pthread_mutex_t *

VOID InitializeCriticalSection(LPCRITICAL_SECTION lpCriticalSection);

VOID DeleteCriticalSection(LPCRITICAL_SECTION lpCriticalSection);
VOID LeaveCriticalSection(LPCRITICAL_SECTION lpCriticalSection);
BOOL TryEnterCriticalSection(LPCRITICAL_SECTION lpCriticalSection);
BOOL EnterCriticalSection(LPCRITICAL_SECTION lpCriticalSection);

unsigned long _beginthreadex( void * security, unsigned stack_size, unsigned(__stdcall *start_address)(void *), void *arglist, unsigned initflag, unsigned *thrdaddr);
void _endthreadex(int zz);

void Sleep(DWORD);
void SleepEx(DWORD, bool);

/*
 * There are two ways to implement Thread-Specific_Data(TSD or Thread Local 
 * Storage:TLS) in LinuxThreads.
 * 1) One is using gs register to declare a segment for pthread_descr_struct, 
 * where (p_specific[0..31])[0..31] locates in.
 * 2) The other way that gets rid of gs register and segment addressing is 
 * simply to put pthread_descr_struct at the bottom of thread stack.
 *
 * So for the 1) approach, we use gs:displacement to get the needed TSD;
 * for 2), we need get the stack bottom and TSD offset to the bottom. 
 */

#define THREAD_STACK_SIZE 2*1024*1024 //this is the default thread stack size 

/*
 *the trick utilizing thread stack for approach 2) is:
 *  {
 *    char s, *sp = &s;
 *    return ***(unsigned ***)(((unsigned)sp|(THREAD_STACK_SIZE -1)) + 1 - \
 *        sizeof(struct pthread_descr_struct) + \
 *        (pthread_descr)(0)->p_specific );
 *  }
 *
 */


#if (__GLIBC__ == 2 && __GLIBC_MINOR__ == 2)

#define SIZE_OF_PTHREAD_DESCR 1024
#define OFFSET_OF_SPECIFIC_IN_THREAD_DESCR 300

#else  
#if (__GLIBC__ == 2 && __GLIBC_MINOR__ == 1) 

#define SIZE_OF_PTHREAD_DESCR 448
#define OFFSET_OF_SPECIFIC_IN_THREAD_DESCR 236

#endif //glibc 2.1
#endif //glibc 2.2

#define REVERSE_OFFSET_OF_SPECIFIC_DATA	\
	(SIZE_OF_PTHREAD_DESCR - OFFSET_OF_SPECIFIC_IN_THREAD_DESCR)

#ifdef USE_SEGMENT // approach 1); turn off by default

inline void *get_specific00(void){
	register void *specific;
	asm volatile(
		"movl %%gs:%c1, %0\n\t"
		"movl (%0), %0"
		:"=r"(specific)
		:"i"(OFFSET_OF_SPECIFIC_IN_THREAD_DESCR) 
	);
	return specific;
}

#else //not USE_SEGMENT;  approach 2), turn on by default
inline void *get_specific00(void){
        register void *specific;
        asm volatile(
                "mov %%esp, %0\n\t"
                "or   %1, %0\n\t"
                "mov  %c2(%0), %0\n\t"
                "mov (%0), %0\n\t"
                :"=r"(specific)
				:"i"( THREAD_STACK_SIZE - 1 ), 
				 "i"( 1 - REVERSE_OFFSET_OF_SPECIFIC_DATA )
        );
        return specific;
}

/*
 *  Notes:
 *	Redhat 7.1 uses approach 1) for libpthread.a, and 2) for libpthread.so. 
 *  Because ORP links libpthread.a statically for the executable, we
 *  uses approach 2) by default. 
 */

#endif //USE_SEGMENT
 
#include "stdlib.h"

#include "orp_cout.h"

#include <assert.h>

#include "lock_manager.h"

#include "stdarg.h"

#include <sys/time.h>
typedef union _LARGE_INTEGER {
    //struct {
        DWORD LowPart;
        LONG HighPart;
    //};

    struct {
        DWORD LowPart;
        LONG HighPart;
    } u;

    struct timeval tv;

    LONGLONG QuadPart;
} LARGE_INTEGER;

typedef LARGE_INTEGER *PLARGE_INTEGER;

#define QueryPerformanceCounter(lpFrequency) gettimeofday(&((*lpFrequency).tv), NULL);
#define EndPerformanceCounter(SumCounter, StartCounter, EndCounter) \
    QueryPerformanceCounter(EndCounter); \
    *SumCounter += (unsigned long)((double) \
           ( ((*EndCounter).tv.tv_sec - (*StartCounter).tv.tv_sec)*1000000.0 + \
              (*EndCounter).tv.tv_usec -(*StartCounter).tv.tv_usec \
            )/1000.0  );

//BOOL QueryPerformanceCounter(LARGE_INTEGER *lpFrequency);
    
LPVOID VirtualAlloc(
    LPVOID lpAddress,
    DWORD dwSize,
    DWORD flAllocationType,
    DWORD flProtect
    );
    
#define INFINITE 0XFFffFFff
  
DWORD GetLastError(VOID);

BOOL VirtualFree (LPVOID lpAddress, DWORD dwSize, DWORD dwFreeType);        
  
typedef struct _SYSTEM_INFO {
    union {
        DWORD dwOemId;          // Obsolete field...do not use
        // toss struct {
            WORD wProcessorArchitecture;
            WORD wReserved;
        // toss };
    };
    DWORD dwPageSize;
    LPVOID lpMinimumApplicationAddress;
    LPVOID lpMaximumApplicationAddress;
    DWORD dwActiveProcessorMask;
    DWORD dwNumberOfProcessors;
    DWORD dwProcessorType;
    DWORD dwAllocationGranularity;
    WORD wProcessorLevel;
    WORD wProcessorRevision;
} SYSTEM_INFO, *LPSYSTEM_INFO;


VOID GetSystemInfo( LPSYSTEM_INFO lpSystemInfo);


BOOL QueryPerformanceFrequency(LARGE_INTEGER *lpFreq);

#define HINSTANCE void *

void _fpreset(void);


HANDLE CreateEvent(int *, unsigned int, unsigned int, char *);

typedef struct event_wrapper {
  pthread_mutex_t          mutex;
  pthread_cond_t           cond;
  __uint32                 man_reset_flag;
  __uint32                 state;
} event_wrapper;

BOOL ResetEvent(HANDLE hEvent);
BOOL SetEvent(HANDLE hEvent);

DWORD WaitForSingleObject(HANDLE hHandle, DWORD dwMilliseconds);

#define WAIT_TIMEOUT 0x102
#define WAIT_OBJECT_0 0
#define WAIT_FAILED (DWORD)0xFFFFFFFF


typedef struct _FLOATING_SAVE_AREA {
    DWORD   ControlWord;
    DWORD   StatusWord;
    DWORD   TagWord;
    DWORD   ErrorOffset;
    DWORD   ErrorSelector;
    DWORD   DataOffset;
    DWORD   DataSelector;
    BYTE    RegisterArea[80];
    DWORD   Cr0NpxState;
} FLOATING_SAVE_AREA;

typedef FLOATING_SAVE_AREA *PFLOATING_SAVE_AREA;


typedef struct _CONTEXT {

    //
    // The flags values within this flag control the contents of
    // a CONTEXT record.
    //
    // If the context record is used as an input parameter, then
    // for each portion of the context record controlled by a flag
    // whose value is set, it is assumed that that portion of the
    // context record contains valid context. If the context record
    // is being used to modify a threads context, then only that
    // portion of the threads context will be modified.
    //
    // If the context record is used as an IN OUT parameter to capture
    // the context of a thread, then only those portions of the thread's
    // context corresponding to set flags will be returned.
    //
    // The context record is never used as an OUT only parameter.
    //

    DWORD ContextFlags;

    //
    // This section is specified/returned if CONTEXT_DEBUG_REGISTERS is
    // set in ContextFlags.  Note that CONTEXT_DEBUG_REGISTERS is NOT
    // included in CONTEXT_FULL.
    //

    DWORD   Dr0;
    DWORD   Dr1;
    DWORD   Dr2;
    DWORD   Dr3;
    DWORD   Dr6;
    DWORD   Dr7;

    //
    // This section is specified/returned if the
    // ContextFlags word contians the flag CONTEXT_FLOATING_POINT.
    //

    FLOATING_SAVE_AREA FloatSave;

    //
    // This section is specified/returned if the
    // ContextFlags word contians the flag CONTEXT_SEGMENTS.
    //

    DWORD   SegGs;
    DWORD   SegFs;
    DWORD   SegEs;
    DWORD   SegDs;

    //
    // This section is specified/returned if the
    // ContextFlags word contians the flag CONTEXT_INTEGER.
    //

    DWORD   Edi;
    DWORD   Esi;
    DWORD   Ebx;
    DWORD   Edx;
    DWORD   Ecx;
    DWORD   Eax;

    //
    // This section is specified/returned if the
    // ContextFlags word contians the flag CONTEXT_CONTROL.
    //

    DWORD   Ebp;
    DWORD   Eip;
    DWORD   SegCs;              // MUST BE SANITIZED
    DWORD   EFlags;             // MUST BE SANITIZED
    DWORD   Esp;
    DWORD   SegSs;

} CONTEXT;



typedef CONTEXT *PCONTEXT;

#define CONTEXT_CONTROL 1
#define CONTEXT_FLOATING_POINT 2
#define CONTEXT_INTEGER 3
#define THREAD_PRIORITY_NORMAL 4


BOOL GetThreadContext(HANDLE hthread, const CONTEXT *lpcontext);
BOOL SetThreadContext(HANDLE hh, const CONTEXT *cc);
BOOL SetThreadPriority(HANDLE hh, int pp);


void gc_thread_init();

BOOL CloseHandle(HANDLE hh);

DWORD GetCurrentThreadId(void);
HANDLE GetCurrentProcess(void);
HANDLE GetCurrentThread(void);

#define DUPLICATE_SAME_ACCESS 3

BOOL DuplicateHandle(HANDLE aa, HANDLE bb, HANDLE cc, int *dd, DWORD *ee, BOOL ff, DWORD gg);

#define _MAX_PATH 512

struct _finddata_t {
    unsigned aa;
    long ttc;
    long ta;
    long tw;
    unsigned long size;
    char name[260];
    };
    
long _findfirst(const char *, struct _finddata_t *);
int _findnext(long, struct _finddata_t *);
int _findclose(long);

struct _stati64 {
    unsigned int st_dev;
    unsigned short st_ino;
    unsigned short st_mode;
    short st_nlink;
    short st_uid;
    short st_gid;
    unsigned int st_rdev;
    __int64 st_size;
    long st_atime;
    long st_mtime;
    long st_ctime;
    };

__int64 _telli64(int);

__int64 _fstati64(int, _stati64 *);

#define SEEK_CUR 1
__int64 _lseeki64(int, int64, int);


void * _alloca(int);

__uint64 GetTickCount();

int GetProcAddress(HINSTANCE hh, const char *);
HINSTANCE LoadLibrary(char *);


extern pthread_key_t thread_local_storage_key;
// toss, moved to orp_threads.h  --> #define p_TLS_orpthread ((ORP_thread *)pthread_getspecific(thread_local_storage_key))

#ifdef __cplusplus
}
#endif

#endif // include_platform_h ******************

