// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/compile.h,v 1.5 2001/12/03 20:54:05 ali Exp $
//



#ifndef _COMPILE_H_
#define _COMPILE_H_





class JIT;

extern JIT *jit_compilers[];

void orp_add_jit(JIT *jit);
void orp_swap_jits(unsigned idx1, unsigned idx2);
void orp_delete_all_jits();


#ifdef CLI_TESTING
extern JIT *jit_compilers_cli[];
void orp_add_jit_cli(JIT *jit);

char *create_unboxer(Method *method);
#endif


JIT_Result jit_recompile_method(Method *method,
                                JIT *jit
                                );

void compile_method_trampoline();

void compile_and_run_class(Class *clss, void *java_args);
void run_main_entry_point(Method *entry_point, void *java_args);
Method *find_entry_point(String *classname, Global_Env *p_env);


char *create_compile_me_stub(Method *method);


class Compilation_Handle {
public:
    Global_Env *env;
    Method *method;
    JIT *jit;
    Loader_Exception ld_exc;
};

#endif
