// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/step_generation.h,v 1.8 2001/12/18 15:44:58 rlhudson Exp $
//

#ifndef _step_generation_H_
#define _step_generation_H_

//
// Generations that comprise multiple steps (but no nurseries).
// Step Generations inherit from Generation.
//
//                Generation
//                    |
//                    |
//       ---------------------------
//       |                         |
//       |                         |
//    Step_Generation              |
//       |                         |
//       |                  Train_Generation
//       |
//  Step_Plus_Nursery_Generation
//

#include "generation.h"
#include "step.h"
// #include "mrl_gc_v1.h"
#include "gc_space.h"
#include "gc_consts.h"
#include "object_list.h"
#include "gc_hooks.h"
//#include "car.h"
//#include "train.h"

class Card_Table;
class Nursery;
class Train_Generation;
class Gc_Fast_Hooks;
class Gc_Plan;


// First the queues.

extern java_lang_ref_ReferenceQueue *global_weak_ref_queue ;
extern java_lang_ref_ReferenceQueue *global_soft_ref_queue;
extern java_lang_ref_ReferenceQueue *global_phantom_ref_queue;

    //
    // After reclaiming this space, we update weak references.
    //

	void _update_phantom_references(bool doing_mos_collection);
	void _update_soft_references(bool low_on_memory, bool doing_mos_collection);
    void _update_weak_references(bool doing_mos_collection);

    void enumerate_reference_queues ();
    void enqueue_soft_ref (java_lang_ref_Reference *a_reference);
	void enqueue_weak_ref (java_lang_ref_Reference *a_reference);
	void enqueue_phantom_ref (java_lang_ref_Reference *a_reference);


    //
    // We have finished a minor collection. Beforp we return we need to
    // scan the spent nurseries, from spaces and LOS for unreachable 
    // objects that have just become candidates for finalization.
    //
    void _locate_and_process_finalizable_objects(bool doing_mos_collection);

class Step_Generation : public Generation {

public:

	Step_Generation(unsigned long gen_num,
                    Gc_Fast_Hooks *p_gc_hooks,
                    Gc_Plan       *p_gc_plan,
		            Gc_Interface  *p_container,
					Generation    *p_superior,
                    Card_Table    *p_card_table,
		            Block_Store   *p_block_store);

	virtual ~Step_Generation() {
		for (unsigned int step_index = 0; 
		                  step_index < _number_of_steps; 
						  step_index++) {
			delete _p_step[step_index];
		}
        delete _p_finalizable_object_list;
	}



	//
	// The GC interface gives each generation an opportunity to
	// clean up after a collection of that generation.
	//
	virtual void cleanup();
	
     //
    // A LOS or Nursery is telling us that a new finalizable object
    // has been allocated.
    //
    void record_finalizable_object(Java_java_lang_Object *p_obj) {
        _p_finalizable_object_list->add_entry(p_obj);
    }

    //
    // At shutdown time, may need to run all finalizers.
    //
    virtual void run_all_finalizers();

protected:
    Step_Generation();
    //
    // Add a new step into this generation.
    //    
	void _add_step(unsigned long step_index);

	//
	//
	// This queue holds all the reference object whose referent (as returned by get)
	// are in this step generation. Since all steps in this generation are collected
	// at the same time we only need one set of queues. In MOS the queues are assocated with
	// each car.
	//
    java_lang_ref_Reference *_p_weak_object_list;

    java_lang_ref_Reference *_p_soft_object_list;

    java_lang_ref_Reference *_p_phantom_object_list;

    //
    // This object set maintains a list of objects in young space
    // that are candidates for finalization.
    //
    Object_List *_p_finalizable_object_list;


	//
	// A pointer to the older generation
	//
	Train_Generation *_p_mature_generation;
	
	//			
    //
    // Currently the number of steps is fixed at compile time (at 
    // run time with .plan files.) But that could change with dynamic
    // adaptive tenuring, where we might add or remove steps based
    // on observed object demographics.
    //
    unsigned long _number_of_steps;


    Step *_p_step[MAXIMUM_STEPS];
    //
    // This flag is used when collecting this generation to record if
    // a pointer has been found into the focus train.
    //
	bool _train_is_live;
	//
	// This helper routine is used when reclaiming a generation 
	// or doing a cheney scan to check if a pointer into mature 
	// space is into the focus car or train. If so, it is duely recorded.
	//
	void _update_into_mature_generation_ref(Java_java_lang_Object **pp_obj_ref, bool doing_mos_collection);
    
};

#endif // _step_generation_H_


