// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/gc_component.h,v 1.1 2001/09/14 18:01:59 rlhudson Exp $
//


#ifndef _gc_component_H_
#define _gc_component_H_


// A Gc_Component is the root of the GC inheritence tree. It captures
// functionality that is common to GC Spaces (Steps, Nurseries, Cars,etc)
// Generations (Step_Generation, Train_Generation, etc.) and Gc_Interfaces
// (Mrl_Gc_V1, etc..)

#include "platform.h"

class Block_Store;
class Gc_Fast_Hooks;
class Gc_Plan;

class Gc_Component {

public:
    Gc_Component(Gc_Fast_Hooks *p_gc_hooks,
                 Gc_Plan       *p_gc_plan,
                 Block_Store   *p_block_store);
    
    virtual ~Gc_Component();

	//
	// Lock this space without locking out enumeration.
	//
	void lock();
    //
    // Acquire specified CS without locking out enumeration
    //
    void lock(CRITICAL_SECTION *p_critical_section);
	//
	// Unlock this space.
	//
	void unlock();
    //
    // Release specified critical section.
    //
    void unlock(CRITICAL_SECTION *p_critical_section);

    //
	// routines for introspection:
	//
	virtual bool is_car(){
		return false;
	}
	virtual bool is_nursery(){
		return false;
	}
	virtual bool is_step(){
		return false;
	}
    virtual bool is_train(){
		return false;
	}
	virtual bool is_large_object_space(){
		return false;
	}
	virtual bool is_obsolete(){
		return false;
	}
    virtual bool is_generation() {
        return false;
    }


protected:

    Block_Store   *_p_block_store;

    Gc_Fast_Hooks *_p_gc_hooks;

    Gc_Plan       *_p_gc_plan;

    CRITICAL_SECTION _lock;

private:
    Gc_Component();


};


#endif // _gc_component_H_
