// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/class_loader/Environment.cpp,v 1.6 2001/11/29 14:23:34 ssubram5 Exp $
//


#include "platform.h"
#include "environment.h"
#include "Package.h"
#include "Class.h"

/*
Global_Env::Global_Env(Mem_Manager& mm,Class_Table& ct,Package_Table& pt,char *cp) :
		mem_manager(mm), sig_table(mm), 
		class_table(ct), package_table(pt), classpath(cp) 
*/
Global_Env::Global_Env(Mem_Manager& mm,Class_Table& ct,Package_Table& pt,Properties& prop,char *cp) :
		mem_manager(mm), sig_table(mm), 
		class_table(ct), package_table(pt), properties(prop), classpath(cp)
{
#ifdef CLI_OCL
#ifndef CLI_TESTING
	assert(0);
#endif
	SystemObject_String = string_pool.lookup("System/Object");
	SystemArray_String = string_pool.lookup("System/Array");
	SystemString_String = string_pool.lookup("System/String");
#endif // CLI_OCL

	JavaLangObject_String = string_pool.lookup("java/lang/Object");
	Init_String = string_pool.lookup("<init>");
	CLInit_String = string_pool.lookup("<clinit>");	
	FinalizeName_String = string_pool.lookup("finalize");
	FinalizeDescriptor_String = string_pool.lookup("()V");
	ByteDescriptor_String = string_pool.lookup("B");
	CharDescriptor_String = string_pool.lookup("C");
	DoubleDescriptor_String = string_pool.lookup("D");
	FloatDescriptor_String = string_pool.lookup("F");
	IntDescriptor_String = string_pool.lookup("I");
	LongDescriptor_String = string_pool.lookup("J");
	ShortDescriptor_String = string_pool.lookup("S");
	BooleanDescriptor_String = string_pool.lookup("Z");

	Finalize_Signature = 
		sig_table.lookup(FinalizeName_String,FinalizeDescriptor_String);
	ArrayLength_Signature =
		sig_table.lookup(string_pool.lookup("length"),IntDescriptor_String);
	Main_Signature =
		sig_table.lookup(string_pool.lookup("main"),
						 string_pool.lookup("([Ljava/lang/String;)V"));
	Default_Constructor_Signature =
		sig_table.lookup(string_pool.lookup("<init>"),
						 string_pool.lookup("()V"));

	default_package = new Package(string_pool.lookup(""),NULL);

	//
	// preloaded classes
	//
	Boolean_Class = NULL;
	Char_Class = NULL;
	Float_Class = NULL;
	Double_Class = NULL;
	Byte_Class = NULL;
	Short_Class = NULL;
	Int_Class = NULL;
	Long_Class = NULL;
#ifdef CLI_TESTING
	UByte_Class = NULL;
	UShort_Class = NULL;
	UInt_Class = NULL;
	IntPtr_Class = NULL;
	UIntPtr_Class = NULL;
	ULong_Class = NULL;
	ArrayOfUByte_Class = NULL;
	ArrayOfUShort_Class = NULL;
	ArrayOfUInt_Class = NULL;
	ArrayOfULong_Class = NULL;
#endif
	ArrayOfBoolean_Class = NULL;
	ArrayOfChar_Class = NULL;
	ArrayOfFloat_Class = NULL;
	ArrayOfDouble_Class = NULL;
	ArrayOfByte_Class = NULL;
	ArrayOfShort_Class = NULL;
	ArrayOfInt_Class = NULL;
	ArrayOfLong_Class = NULL;
	JavaLangObject_Class = NULL;
	JavaLangString_Class = NULL;
	JavaLangClass_Class = NULL;
	java_lang_Throwable_Class = NULL;
	java_lang_Error_Class = NULL;
	java_lang_ExceptionInInitializerError_Class = NULL;
	java_lang_NullPointerException_Class = NULL;
	java_lang_ArrayIndexOutOfBoundsException_Class = NULL;
	java_lang_ArrayStoreException_Class = NULL;
	java_lang_ArithmeticException_Class = NULL;
	java_lang_ClassCastException_Class = NULL;
	java_io_Serializable_Class = NULL;
	java_lang_Cloneable_Class = NULL;
    java_lang_Thread_Class = NULL;
} //Global_Env::Global_Env
