// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_VMSecurityManager.cpp,v 1.2 2001/08/07 07:00:37 gwu2 Exp $
//

#include "platform.h"
#include "jni.h"
#include "assert.h"
#include <time.h>
#include "orp_types.h"
#include "environment.h"
#include "jit_runtime_support.h"
#include "object_layout.h"
#include "orp_utils.h"
#include "stack_manipulation.h"
#include "java_lang_VMSecurityManager.h"
#include "Class_Loader.h"

/*
 * Class:     java_lang_VMSecurityManager
 * Method:    currentClassLoader
 * Signature: ()Ljava/lang/ClassLoader;
 */
JNIEXPORT jobject JNICALL Java_java_lang_VMSecurityManager_currentClassLoader
  (JNIEnv *jenv, jclass clazz)
{
	/** Get the current ClassLoader--the one nearest to the
	 ** top of the stack.
	 ** @return the current ClassLoader.
	 **/
	Class **class_info = (Class **) malloc (sizeof(Class *) * 1024);
    assert(class_info);

    unsigned stack_depth = orp_get_stack_depth_from_native_new(class_info, 0, 0xffffFFFF);

    assert(stack_depth >= 0);
    assert(stack_depth <= 1024);

	Class_Loader *class_loader;
    for (unsigned i = 0; i < stack_depth; i++) { 
        Class *clss = class_info[i];
        assert(clss);

		class_loader = clss->class_loader;
		if(class_loader)break;
    }

	Object_Handle handle = NULL;
	if(class_loader){
		orp_disable_gc();
		handle = orp_create_local_object_handle();
        handle->java_reference = class_loader->get_loader();
		orp_enable_gc();
	}

    free(class_info);

    return handle;
} //Java_java_lang_VMSecurityManager_currentClassLoader


/*
 * Class:     java_lang_VMSecurityManager
 * Method:    getClassContext
 * Signature: ()[Ljava/lang/Class;
 */

JNIEXPORT jobjectArray JNICALL Java_java_lang_VMSecurityManager_getClassContext
  (JNIEnv *jenv, jclass clazz)
{
    /** Get a list of all the classes currently executing methods on the Java stack.  
     ** getClassContext()[0] is the currently executing method
     ** 
     ** Note: Spec does not say whether the stack will include the getClassContext() 
     ** call or the one just before it.
     **
     **
     ** @returns array containing all the methods on classes on the Java execution stack.
     **/

    // For now -- return an array of empty objects.

    Class **class_info = (Class **) malloc (sizeof(Class *) * 1024);
    assert(class_info);

    unsigned stack_depth = orp_get_stack_depth_from_native_new(class_info, 0, 0xffffFFFF);

    assert(stack_depth >= 0);
    assert(stack_depth <= 1024);

    jclass class_class = jenv->FindClass("java/lang/Class");
    assert(class_class);

    jobjectArray class_array = jenv->NewObjectArray(stack_depth, class_class, 0);
    assert(class_array);

    for (unsigned i = 0; i < stack_depth; i++) { 

        Class *c = class_info[i];
        assert(c);
        Object_Handle new_handle = orp_create_local_object_handle();
        
        orp_disable_gc();       //---------------------------------v

        new_handle->java_reference = (Java_java_lang_Object *) c;
        
        orp_enable_gc();       //---------------------------------^

        jenv->SetObjectArrayElement(class_array, i, new_handle);
    }

    free(class_info);
    return class_array;
  
} // Java_java_lang_VMSecurityManager_getClassContext
















