// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/include/java_lang_Thread.h,v 1.5 2001/12/11 16:22:53 rlhudson Exp $
//

typedef struct Classpath_Java_java_lang_Runnable Classpath_Java_java_lang_Runnable;
typedef struct Classpath_Java_java_lang_ThreadGroup Classpath_Java_java_lang_ThreadGroup;

/*  Header for class java/lang/Thread  */

#ifndef _JAVA_LANG_THREAD_H_
#define _JAVA_LANG_THREAD_H_

typedef struct Classpath_Java_java_lang_Thread {
    VTable *vt;
    
#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
#ifdef OLD_VERSION_CLASSPATH
    Java_java_lang_Object *data;
#endif
    Classpath_Java_java_lang_ThreadGroup *group;
    Classpath_Java_java_lang_Runnable *toRun;
    Java_java_lang_String *name;
    long daemon;
    long priority;
	// contextClassLoader field is not a formal field temporarily
	Java_java_lang_Object *contextClassLoader;
#ifndef OLD_VERSION_CLASSPATH
    long data; // move "data" field down and change it to "long"
#endif
} Classpath_Java_java_lang_Thread;


#undef java_lang_Thread_MIN_PRIORITY
#define java_lang_Thread_MIN_PRIORITY 1L
#undef java_lang_Thread_NORM_PRIORITY
#define java_lang_Thread_NORM_PRIORITY 5L
#undef java_lang_Thread_MAX_PRIORITY
#define java_lang_Thread_MAX_PRIORITY 10L



#ifdef __cplusplus
extern "C" {
#endif


int32 java_lang_Thread_countStackFrames(Java_java_lang_Thread *);
Java_java_lang_Thread *java_lang_Thread_currentThread(Java_java_lang_Thread *);
void java_lang_Thread_nativeInterrupt(Java_java_lang_Thread *);
void java_lang_Thread_nativeDestroy(Java_java_lang_Thread *);

int32 java_lang_Thread_isInterrupted(Java_java_lang_Thread *);
int32 java_lang_Thread_isAlive(Java_java_lang_Thread *);
void java_lang_Thread_nativeInit(Java_java_lang_Thread *);

void java_lang_Thread_join(Java_java_lang_Thread *, int64, int32);
void java_lang_Thread_nativeResume(Java_java_lang_Thread *);
void java_lang_Thread_nativeSetPriority(Java_java_lang_Thread *, int32);

void java_lang_Thread_sleep(Java_java_lang_Thread *, int64, int32);
void java_lang_Thread_start(Java_java_lang_Thread *);
void java_lang_Thread_nativeStop(Java_java_lang_Thread *, Java_java_lang_Object *);

void java_lang_Thread_nativeSuspend(Java_java_lang_Thread *);
void java_lang_Thread_yield(Java_java_lang_Thread *);


#ifdef __cplusplus
}
#endif

#endif

