#ifndef NativeGenerator_head
#define NativeGenerator_head

#define MAX_NATIVE_OPND_LIST_SIZE 250
#define MAX_NATIVE_ARG_NUM 10

class NativeOpndManager
{
public:
	NativeOpndManager(Mem_Manager& _mem, 
						Expressions& _exprs,
						unsigned in_args, unsigned out_args,
						NativeOpndInfo::NativeOpndNode* _in_arg_list, 
						NativeOpndInfo::NativeOpndNode* _out_arg_list):
	  mem(_mem), exprs(_exprs), opnd_list_size(0), native_in_arg_num(in_args), native_out_arg_num(out_args),
		  in_arg_list(_in_arg_list), out_arg_list(_out_arg_list) {}

	Operand* gen_opnd(NativeOpndInfo* opnd_info);
	Operand* get_opnd_from_list(NativeOpndInfo* opnd_info, NativeOpndInfo::NativeOpndNode* list, unsigned len);

	void gen_imm_opnd(Expressions& exprs, NativeInfo* info, NativeOpndInfo* opnd_info, Operand*& o, Exp*& e);
	void gen_field_opnd(NativeOpndInfo* info, Operand*& o, Exp*& e, O3_Jit_Type ty);	

	Operand* get_hi_opnd(Operand* o) { return o->hi_opnd();};
	Operand* get_lo_opnd(Operand* o) { return o;};

	Operand* get_opnd(NativeOpndInfo* opnd_info);
	Operand* get_opnd_inside(NativeOpndInfo* opnd_info){
		for ( unsigned i = 0; i < get_opnd_list_size(); i++)
		{
			if ( cmp_opnd_info( opnd_info, get_opnd_info( i)))
				return opnd_list[i].opnd;
		}
		return NULL;
	};
	Operand* get_opnd_from_in_arg(NativeOpndInfo* opnd_info);
	Operand* get_opnd_from_out_arg(NativeOpndInfo* opnd_info);

		
	NativeOpndInfo* get_opnd_info(unsigned i){
		assert(i < opnd_list_size);
		return opnd_list[i].info;
	};
	
	void append_opnd_exp(NativeOpndInfo* opnd_info, Operand* opnd, Exp* exp);
	Operand* lookup_opnd(NativeOpndInfo* opnd_info);
	
	bool cmp_opnd_info(NativeOpndInfo* src, NativeOpndInfo* dst){
		return (   src->tag == dst->tag && src->num == dst->num
			&& src->off == dst->off	&& src->val == dst->val); };

	Exp* get_exp( Operand* o, NativeOpndInfo* opnd_info);
	Exp* get_exp_from_list( Operand* o, NativeOpndInfo::NativeOpndNode* list, unsigned len);

	unsigned get_opnd_list_size() {	return opnd_list_size;}
	void set_opnd_list_size(unsigned size) { opnd_list_size = size;}

	void copy(NativeOpndInfo*dst, NativeOpndInfo* src){
		dst->tag = src->tag; dst->val = src->val;
		dst->num = src->num; dst->off = src->off;
		dst->hi_tag = src->hi_tag; };
private:
	Mem_Manager& mem;
	Expressions& exprs;
	NativeOpndInfo::NativeOpndNode opnd_list[MAX_NATIVE_OPND_LIST_SIZE];
	unsigned opnd_list_size;

	NativeOpndInfo::NativeOpndNode* in_arg_list;
	NativeOpndInfo::NativeOpndNode* out_arg_list;
	unsigned native_in_arg_num, native_out_arg_num;
};

class NativeInstGenerator
{
public:
	NativeInstGenerator(Expressions& _exprs, NativeInfo& _info, NativeOpndManager& _nom, Mem_Manager& _mem, Inst* _inst_head, Inst* lastinst):
	  exprs(_exprs), info(_info), nom(_nom), mem(_mem), inst_head(_inst_head), last_inst(lastinst) {}

	void gen_mul();
	void gen_add();
	Inst* gen_inst();

	Inst* last_inst;

private:
	Operand* lookup_opnd(NativeOpndInfo* opnd_info);
	void get_src_opnd(NativeInfo* info, Operand* l, Operand* r);
	void get_opnd_exp(NativeOpndInfo* opnd_info, Operand*& o, Exp*& exp);

	void get_src_opnd_exp( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp);
	void get_dst_opnd_exp( Temp_Reg*& o, Exp*& e);

	void gen_shld_inst( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp);
	void gen_shrd_inst( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp);
	
	void gen_smul_inst( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp);
	void gen_mov_inst( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp);
	void gen_mul_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp);
	
	void gen_bitwise_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Bitwise_Inst::Kind inst_kind);
	void gen_sub_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Sub_Inst::Kind inst_kind);
	void gen_add_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Add_Inst::Kind inst_kind);	
	void gen_checkcast_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Type_Inst::Kind inst_kind);	
	void gen_compare_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Compare_Inst::Kind inst_kind);
	void gen_branch_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Branch_Inst::Kind inst_kind);	
	
	void gen_not_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp);

	void gen_div_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp);	

	Inst* inst_head;
	Expressions& exprs;
	NativeInfo& info;
	NativeOpndManager& nom;
	Mem_Manager& mem;
};
#endif