// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/register_manager.h,v 1.2 2001/08/13 10:00:42 xhshi Exp $
//



#ifndef _REGISTER_MANAGER_H_
#define _REGISTER_MANAGER_H_
#include <assert.h>

class Stack;
class Reg_Operand;
class Mem_Manager;
class Operand;

class Register_Manager {
public:
	Register_Manager(Mem_Manager& m);
	void reset();
	Reg_Operand *get_reg(unsigned mask);
	Reg_Operand *get_reg() {return get_reg(ALL_X86_CALLER_REGS | ALL_X86_CALLEE_REGS);}
	// KEN testing
	// free up one register that is byte addressable
	Reg_Operand *get_byte_reg()   {return get_reg(ALL_X86_BYTE_REGS);}
	Reg_Operand *get_callee_reg() {return get_reg(ALL_X86_CALLEE_REGS);}
	Reg_Operand *get_caller_reg() {return get_reg(ALL_X86_CALLER_REGS);}
	Reg_Operand *get_reg(X86_Reg_No r);
	void update_reg_info(X86_Reg_No no);
	void reset_after_call() {
		_free_bv |= 0x07; // call destroys only caller-save regs
		reset_reg_info();
	}
	void add_free_callee_regs(unsigned free_callee) {
		_free_bv |= free_callee; 
		_available_local_regs |= free_callee;
	}
	unsigned local_regs() {return _available_local_regs;}
	void reset_reg_info() {
		reset_reg_value(); // for LOAD_STORE
#ifndef NO_BOUNDS_CHECKING
		int *begin = (int*)_reg_newarray;
		begin[0] = begin[1] = 0; // init _reg_newarray[0..7] = 0
#endif // NO_BOUNDS_CHECKING
	}
	void free_reg(X86_Reg_No);
	void push_reg(X86_Reg_No);
	void init_stack(Stack *s)	{_stack = s;}
	int  has_available_reg()	{return _free_bv;}
	int  has_available_callee_reg() {return _free_bv & ALL_X86_CALLEE_REGS;}
	int  has_available_caller_reg() {return _free_bv & ALL_X86_CALLER_REGS;}
	int  is_free(X86_Reg_No r)	{return _free_bv & (1 << r);}
	X86_Reg_No find_one_available_callee(unsigned reg_use_bv);
	void assert_all_available(); // for debugging purpose
// the following fields are for LOAD_STORE
	void reg_value(Operand *src, int index);
	void reset_reg_value() {
		for (int i = 0; i < n_reg; i++)
			_reg_value[i] = -1;
	}
	void reset_reg_value(X86_Reg_No no) {
		_reg_value[no] = -1;
		assert(no < n_reg);
	}
	X86_Reg_No find_reg_value(int index);
	void reset_store(int index);
// the previous fields are for LOAD_STORE
#ifndef NO_BOUNDS_CHECKING
	void set_newarray_in_reg(X86_Reg_No no) {_reg_newarray[no] = 1;}
	void clr_newarray_in_reg(X86_Reg_No no) {_reg_newarray[no] = 0;}
	int  is_newarray_in_reg(X86_Reg_No no) {return _reg_newarray[no];}
#endif // NO_BOUNDS_CHECKING
#ifdef _CSE
	Reg_Operand *hold_cse_reg(X86_Reg_No r);
#endif // _CSE
private:	
	Reg_Operand *_x86_regs[n_reg];
	unsigned _free_bv;
	unsigned _available_local_regs;

	unsigned _next_free;
	Stack *_stack;
	int _reg_value[n_reg]; // for LOAD_STORE
#ifndef NO_BOUNDS_CHECKING
	//
	// flag that indicates if a reg holds newarray info
	//
	char _reg_newarray[n_reg];
#endif // NO_BOUNDS_CHECKING
};

#endif // _REGISTER_MANAGER_H_
