// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/debugger/debugger_ia32_utils.cpp,v 1.2 2001/12/07 00:16:00 xli18 Exp $
//



#include "platform.h"
#include <stdio.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <iostream.h>
#include "environment.h"
#include "orp_types.h"
#include "object_layout.h"
#include "jit_intf_cpp.h"
#include "method_lookup.h"
#include "stack_manipulation.h"
#include "Class.h"
#include "sync_bits.h"

#include "compile.h"
#include "ini.h"

#ifdef ORP_POSIX
#include <unistd.h>

#else
#include <io.h>
//#include <orp_io.h>
#endif

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "jvmdi_clean.h"
#include "orp_utils.h"

#include "jit_intf.h"

#include "level_1a_jit_intf.h"


#include "debugger_jvmdi_ia32.h"
#include "debugger_ia32_utils.h"

#ifdef ORP_POSIX
#include "platform2.h"
#endif

uint32 which_line_is_it(uint32 eip, bool is_first)
{
    JIT_Specific_Info *jit_info = methods.find((void *)eip);
    Method *p_meth = jit_info->get_method();

    int n_entry = method_get_line_number_table_size(p_meth);

    JVMDI_line_number_entry line_table[1];

    uint32 old_cursor = 0;
    uint32 cursor = 0;
    uint32 old_line_number;

    for (int xx = 0; xx < n_entry; xx++) 
    {
        memset(line_table, 0, sizeof(JVMDI_line_number_entry));

        method_get_line_number( p_meth,
                                xx,
                                (unsigned *)&(line_table[0].start_location),
                                (unsigned *)&(line_table[0].line_number) );

        JIT_Flags jf;
        
		jf.insert_write_barriers = 1;

        jf.generate_debug_info = 0;
        jf.poll_gc = 0;
        jf.tracing_write_barriers = 0;

        uint32 code_offset =  o1_jit->get_break_point_offset(
                               o1_jit->global_compile_handle,
                               p_meth,
                               jf,
                               (unsigned)line_table[0].start_location);

        cursor = code_offset + (uint32)p_meth->get_code_addr();

        if (is_first) {
            if (eip == cursor)
                return line_table[0].line_number;
        } else {
            if (eip == cursor)
                return old_line_number;
        }

        if ( (old_cursor <= eip) && ( eip < cursor) ) 
            return old_line_number;

        old_cursor = cursor;
        old_line_number = line_table[0].line_number;
    }
    if (n_entry == 0) {
        //orp_cout << "**no debug info**";
    }
    return UNKNOWN_LINE_NUM ;
}

uint32 which_bytecode_is_it(uint32 eip, bool is_first){
    JIT_Specific_Info *jit_info = methods.find((void *)eip);
    Method *p_meth = jit_info->get_method();
    
    uint32 cursor,old_cursor=0;
    uint32 bc_ip,old_bc_ip = 0;
    uint32 bc_size = p_meth->get_byte_code_size();
    //char bytecode_breakpoints[100];

    bc_ip =0;
    char *dis_bc(const Byte *bc_start, unsigned *bc_ip, char *buf, Method_Handle m);
    JIT_Flags jf;
	jf.insert_write_barriers = 1;
    jf.generate_debug_info = 0;
    jf.poll_gc = 0;
    jf.tracing_write_barriers = 0;
            
    while (bc_ip<bc_size){
        uint32 code_offset =  o1_jit->get_break_point_offset(
                               o1_jit->global_compile_handle,
                               p_meth,
                               jf,
                               (unsigned)bc_ip);
        cursor = code_offset + (uint32)p_meth->get_code_addr();

        if (is_first){
            if (cursor > eip)
                return old_bc_ip;
        } else {
            if (cursor == eip)
                return old_bc_ip;
        }
        old_cursor = cursor;
        old_bc_ip = bc_ip;
        dis_bc(p_meth->get_byte_code_addr(),(unsigned int *)&bc_ip,disasm_buffer,p_meth);
        if (bc_ip == bc_size)
            return old_bc_ip;
    }
    return  UNKNOWN_BYTECODE_NUM;
    
}



void unwind_it(Frame_Context *p_frame, int count)
{
    if(p_frame->p_eip == 0)
        return;

    bool is_first = TRUE;

    for(int frame_number = 0; frame_number < count; frame_number++) {
        
        JIT_Specific_Info *jit_info = methods.find((void *)*(p_frame->p_eip));
        ORP_Code_Type orpct = orp_identify_eip((void *)*(p_frame->p_eip));

        if(orpct == ORP_TYPE_JAVA) {
            Method *p_meth = jit_info->get_method();
            jit_info->get_jit()->unwind_stack_frame(p_meth,
                                                    p_frame,
                                                    is_first);
            p_frame->is_first = FALSE;
			is_first = FALSE;
        } 
        else {
            Boolean ok = ro_unwind_native_stack_frame(p_frame);
            if(!ok) {
                break;
            }
        }

    } // end of while
}



void stack_trace(Frame_Context *p_frame) 
{
    int frame_number = 0;

    uint32 which_line_is_it(uint32 eip, bool is_first);

    if(p_frame->p_eip == 0)
        return;
    if(orp_identify_eip((void *)*(p_frame->p_eip)) == ORP_TYPE_JAVA) {
        Method *method = methods.find((void *)*(p_frame->p_eip))->get_method();
        orp_cout << frame_number << ") " << method->get_class()->name->bytes << ".";
        orp_cout << method->get_name()->bytes;
        orp_cout << method->get_descriptor();
    }
    orp_cout << " #" << (int32)which_line_is_it(*p_frame->p_eip, true);
    if (jvmdi_verbose) {

        orp_cout << endl;
        orp_cout <<  "   [eip=" << (void *)*p_frame->p_eip;
        orp_cout << " esp=" << (void *)p_frame->esp;
        orp_cout << " ebp=" << (void *)*p_frame->p_ebp;

        orp_cout << " edi=" << (void *)*p_frame->p_edi;
        orp_cout << " esi=" << (void *)*p_frame->p_esi;
        orp_cout << " ebx=" << (void *)*p_frame->p_ebx;

        if (p_frame->p_eax) {
            orp_cout << " eax=" << (void *)*p_frame->p_eax;
            orp_cout << " ecx=" << (void *)*p_frame->p_ecx;
            orp_cout << " edx=" << (void *)*p_frame->p_edx;
        }
        orp_cout << "]" << endl;
    }
    orp_cout << endl;

    frame_number++;

    uint32 is_first = TRUE;

    while(true) {
        
        JIT_Specific_Info *jit_info = methods.find((void *)*(p_frame->p_eip));
        ORP_Code_Type orpct = orp_identify_eip((void *)*(p_frame->p_eip));

        if(orpct == ORP_TYPE_JAVA) {
            Method *p_meth = jit_info->get_method();
            jit_info->get_jit()->unwind_stack_frame(p_meth,
                                                    p_frame,
                                                    is_first);
            is_first = FALSE;
        } 
        else {
            orp_cout << frame_number++ << ") --native frame(s)--" << endl;
            Boolean ok = ro_unwind_native_stack_frame(p_frame);
            if(!ok) {
                break;
            }
        }

        if(orp_identify_eip((void *)*(p_frame->p_eip)) == ORP_TYPE_JAVA) {
            Method *method = methods.find((void *)*(p_frame->p_eip))->get_method();
            orp_cout << frame_number++ << ") " << method->get_class()->name->bytes << ".";
            orp_cout << method->get_name()->bytes;
            orp_cout << method->get_descriptor();

            orp_cout << " #" << (int32)which_line_is_it(*p_frame->p_eip, false);
            if (jvmdi_verbose) {

                orp_cout << endl;
                orp_cout <<  "   [eip=" << (void *)*p_frame->p_eip;
                orp_cout << " esp=" << (void *)p_frame->esp;
                orp_cout << " ebp=" << (void *)*p_frame->p_ebp;

                orp_cout << " edi=" << (void *)*p_frame->p_edi;
                orp_cout << " esi=" << (void *)*p_frame->p_esi;
                orp_cout << " ebx=" << (void *)*p_frame->p_ebx;

                orp_cout << "]" << endl;
            }
            orp_cout << endl;
        }

    } // end of while
}


void do_disasm(Method *method, Frame_Context *p_frame, bool from_eip)
{
    // call this with either *method or *p_frame but not both
    if( (p_frame == 0) && (method == 0) )
        return;

    bool print_to_screen = true;
    //if (from_eip == true) print_to_screen = false;

    if (p_frame) {
        assert(method == 0);
        if (p_frame->p_eip == 0) 
            return;
        if(orp_identify_eip((void *)*(p_frame->p_eip)) == ORP_TYPE_JAVA) {
            method = methods.find((void *)*(p_frame->p_eip))->get_method();
        }
        else return;
    }

    orp_cout << endl << "||||||||||||||||||||||| " << method->get_class()->name->bytes << ".";
    orp_cout << method->get_name()->bytes;
    orp_cout << method->get_descriptor();
    orp_cout << " |||||||||||||||||||||||" << endl;

    jint entryCount = 0;
    JVMDI_line_number_entry *tablePtr = 0;

    jvmdiError stat = GetLineNumberTable( (jclass)(method->get_class()), 
                                          (jmethodID)method,
                                          &entryCount, 
                                          &tablePtr);
    if (tablePtr == 0) {
        orp_cout << "no line number debugging information" << endl;
        return;
    }

    int32 highest_line_number = 0;
    int32 highest_line_number_index = 0;

    for (int32 xx = 0; xx < entryCount; xx++) {
        //orp_cout << "start_location " << (uint32)tablePtr[xx].start_location;
        //orp_cout << " line_number " << tablePtr[xx].line_number << endl;
        if (tablePtr[xx].line_number > highest_line_number) {
            highest_line_number = tablePtr[xx].line_number;
            highest_line_number_index = xx;
        }
    }
    JIT_Flags jf; jf.insert_write_barriers = 1; jf.generate_debug_info = 0;
    jf.poll_gc = 0; jf.tracing_write_barriers = 0;

    uint32  start_code  = 0;

    if (method->get_state() == Method::ST_Compiled) {
        start_code = (uint32)method->get_code_addr();
        if (p_frame) {
            start_code  +=  o1_jit->get_break_point_offset(
                                      o1_jit->global_compile_handle,
                                      method,
                                      jf,
                                      (uint32)tablePtr[0].start_location);
        }
    }
    uint32  end_code = 0;

    if (method->get_state() == Method::ST_Compiled) {
        end_code = (uint32)method->get_code_addr();
        end_code  +=  o1_jit->get_break_point_offset(
                                  o1_jit->global_compile_handle,
                                  method,
                                  jf,
                                  (uint32)tablePtr[highest_line_number_index].start_location);
    }

    char *p_cursor = (char *)start_code;

    char *x86_disasm(char *x86_code, char *ascii_buf, bool addr_and_bytes, bool instructions);
    char *dis_bc(const Byte *bc_start, unsigned *bc_ip, char *buf, Method_Handle m);
    uint32 bc_ip = 0;

    uint32 a_screen_full = 0;

    while (start_code) {

        for (int32 zz = 0; zz < entryCount; zz++) {

            uint32 sc = (uint32)method->get_code_addr();

            if (print_to_screen) { // this is a very time expensive operation
                sc  +=  o1_jit->get_break_point_offset(o1_jit->global_compile_handle,
                                                        method,
                                                        jf,
                                                        (uint32)tablePtr[zz].start_location);
            }

            if (sc == (uint32)p_cursor) {
                if (print_to_screen) {
                    orp_cout << endl;
				    orp_cout << "---------  source line " << (int32)tablePtr[zz].line_number;
                    orp_cout << "  ---------------------" << endl;
                }

                while (bc_ip < (uint32)tablePtr[zz +1].start_location) {

                    if (bc_ip >= method->get_byte_code_size() )
                        break;

                    if (bc_ip == (unsigned)200)
                        int kk =1;
                    dis_bc(method->get_byte_code_addr(), (unsigned int *)&bc_ip, disasm_buffer, method);

                    if (print_to_screen) {

                        if (bc_ip >= (uint32)tablePtr[zz].start_location) {
                            // start printing bytecodes when we get close to the current source line
                            orp_cout << &(disasm_buffer[0]) << endl;
                        }
                    }
                }
                if (print_to_screen) {
                    orp_cout << endl;
                }
            }
        }

        if ( (p_frame) && (p_cursor == (char *)*p_frame->p_eip) ) {
            print_to_screen = true;
            orp_cout << "<<<<<<<<<<<<<<<<<----------------->>>>>>>>>>>>>>>>>>>>>"   << endl;
            orp_cout << "         <<<<<<<<-- current eip -->>>>>>>>" << endl;
            orp_cout << "<<<<<<<<<<<<<<<<<----------------->>>>>>>>>>>>>>>>>>>>>"   << endl;
        }
        p_cursor = x86_disasm(p_cursor, disasm_buffer, jvmdi_verbose, TRUE);
        if (print_to_screen) {
            orp_cout << "      " << disasm_buffer << endl;
        }
        if (p_cursor > (char *)end_code + 25)  // add 25 to display a little extra
            break;

        if (print_to_screen) {
            a_screen_full++;
        }
        if ( (a_screen_full % 20) == 1) {
                memset(buff, 0, BUFF_SIZE);
                orp_cout << "enter return to continue or 'q' to quit>";
                my_gets(buff);
                if (buff[0] == 'q') return;
        }
    }

    if (start_code == 0) {
        bc_ip = 0;
        a_screen_full = 0;

        while (bc_ip < method->get_byte_code_size()) {

            for (int32 qq = 0; qq < entryCount; qq++) {
                if (tablePtr[qq].start_location == bc_ip) {
                    if (print_to_screen) {
                        orp_cout << endl << "---------  source line " << 
                            (int32)tablePtr[qq].line_number << "  ---------------------" << endl;
                    }
                }
            }
            dis_bc(method->get_byte_code_addr(), (unsigned int *)&bc_ip, disasm_buffer, method);
            if (print_to_screen) {
                orp_cout << &(disasm_buffer[0]) << endl;
            }

            if (print_to_screen) {
                a_screen_full++;
            }
            if ((a_screen_full!=1)&&( (a_screen_full % 20) == 1)) {
                    memset(buff, 0, BUFF_SIZE);
                    orp_cout << "enter return to continue or 'q' to quit>";
                    my_gets(buff);
                    if (buff[0] == 'q') return;
            }
        }
    }
}

void print_help_info(){
    printf("       type the following  commands:\n");
    printf("\n-----------------   source level    -------------------------------------\n");
    printf("       b[reak] <class>.<method> \n");
	printf("			-- set a breakpoint at the begin of the method\n");
    printf("       b[reak] :<line> \n");
	printf("			-- set a breakpoint at the at the specific line of current method\n");
    printf("       b[reak] <class>.<method>[:<line>] \n");
	printf("			-- set a breakpoint at the specific line of the method\n");
	printf("       c[lear]  \n");
	printf("			---- shows the breakpoints\n");
	printf("       c[lear] <n>|<all>\n");
	printf("			---- clear the nth breakpoint or all breakpoints\n");
	printf("       l[ist] [all]	-- show source file\n");
    printf("       n[ext]		-- single step,pass over call\n");
    printf("       s[tep]		-- single step\n");
    
    printf("\n-----------------   bytecode level    -------------------------------------\n");
	printf("       b[reak]b <class>.<method> \n");
	printf("			-- set a breakpoint at the begin of the method\n");
    printf("       b[reak]b :<line> \n");
	printf("			-- set a breakpoint at the at the specific bytecode of current method\n");
    printf("       b[reak]b <class>.<method>[:<line>] \n");
	printf("			-- set a breakpoint at the specific bytecode inst of the method\n");
	printf("       c[lear]b  \n");
	printf("			---- shows the bytecode breakpoints\n");
	printf("       c[lear]b <n>|<all>\n");
	printf("			---- clear the nth breakpoint or all breakpoints\n");
	printf("       l[ist]b		-- show bytecodes \n");
    printf("       n[ext]b		-- bytecode single step,pass over call\n");
    printf("       s[tep]b		-- bytecode single step\n");
    printf("\n\n");

    printf("       s[tep]o[ut]	-- step out of current function\n");
    printf("       g[o] 		-- go until next breakpoit \n");
    printf("       run 		    -- run untile programe finish\n");
	printf("       f[rames]		-- shows the current thread's frames\n");
	//printf("       F[rames]		-- shows a thread's frames\n");
    printf("       up [<n>]		-- set 1 or n frame(s) up as current frame\n");
	printf("       down [<n>]		-- set 1 or n frame(s) down as current frames\n");
	printf("       lo[cals]  	-- shows the current thread's current method's locals\n");
	//printf("       L[ocals]		-- shows a thread's method's locals\n");
    printf("       d[isplay] <var>	-- show one variable\n");
    printf("       d[isp]class	<class>\n");    
    printf("                    -- show the content of class,include fields and methods\n");
	printf("       ref <address>  \n");
	printf("			-- show the content of a reference,IT IS DANGEROUS!\n");
    printf("       disasm		-- disassemble 10 lines\n");
	printf("       disasm		-- disassemble the whole method\n");
    printf("       where		-- show current position\n");
	printf("       t[hread]		-- shows which threads are running\n");
	//printf("       i			-- break on next method entry not implemented\n");
	//printf("	   o			-- break on method return not implemented\n");
	printf("       e[xception]  -- exception reporting (on/off)\n");
    printf("       exit         -- exit the debugger\n");    
    printf("       clkblk		-- dumps the Lock_Block's of thread N\n");
	printf("       v[erbose]	-- verbose mode (on/off)\n");
    printf("       x			-- matches a method to an entered EIP\n");
}
