/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model;


/**
 * <pre>
 * &lt;xs:element name="for-each-group" substitutionGroup="xsl:instruction">
 *      &lt;xs:complexType>
 *          &lt;xs:complexContent mixed="true">
 *              &lt;xs:extension base="xsl:versioned-element-type">
 *                  &lt;xs:sequence>
 *                      &lt;xs:element ref="xsl:sort" minOccurs="0" maxOccurs="unbounded"/>
 *                      &lt;xs:group ref="xsl:sequence-constructor-group" minOccurs="0" maxOccurs="unbounded"/>
 *                  &lt;/xs:sequence>
 *                  &lt;xs:attribute name="select" type="xsl:expression" use="required"/>
 *                  &lt;xs:attribute name="group-by" type="xsl:expression"/>
 *                  &lt;xs:attribute name="group-adjacent" type="xsl:expression"/>            
 *                  &lt;xs:attribute name="group-starting-with" type="xsl:pattern"/>            
 *                  &lt;xs:attribute name="group-ending-with" type="xsl:pattern"/>            
 *                  &lt;xs:attribute name="collation" type="xs:anyURI"/>            
 *              &lt;/xs:extension>
 *          &lt;/xs:complexContent>
 *      &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 * @author ads
 *
 */
public interface ForEachGroup extends SequenceConstructor, SequenceElement, 
    Instruction, SelectSpec, SortContainer, CollationSpec 
{
    String GROUP_BY = "group-by";                               // NOI18N
    
    String GROUP_ADJACENT = "group-adjacent";                   // NOI18N
    
    String GROUP_STARTING_WITH = "group-starting-with";         // NOI18N
    
    String GROUP_ENDING_WITH = "group-ending-with";             // NOI18N
    
    /**
     * @return "group-by" attribute value
     */
    String getGroupBy();
    
    /**
     * Set "group-by" attribute value.
     * @param value new value
     */
    void setGroupBy( String value );
    
    /**
     * @return "group-adjacent" attribute value
     */
    String getGroupAdjacent();
    
    /**
     * Set "group-adjacent" attribute value.
     * @param value new value
     */
    void setGroupAdjacent( String value );
       
    /**
     * @return "group-starting-with" attribute value
     */
    String getGroupStartingWith();
    
    /**
     * Set "group-starting-with" attribute value.
     * @param value new value
     */
    void setGroupStartingWith( String value );
    
    /**
     * @return "group-ending-with" attribute value
     */
    String getGroupEndingWith();
    
    /**
     * Set "group-ending-with" attribute value.
     * @param value new value
     */
    void setGroupEndingWith( String value );
}
