/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.websvc.manager.ui;

import com.sun.tools.ws.processor.model.java.JavaMethod;
import com.sun.tools.ws.processor.model.java.JavaParameter;
import com.sun.tools.ws.processor.model.java.JavaType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.*;
import java.util.*;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.table.TableModel;
import javax.swing.event.TableModelEvent;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.util.ManagerUtil;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;

import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;


/**
 * Dialog that tests JAX-WS client methods
 * 
 * @author  David Botterill
 */
public class TestWebServiceMethodDlg extends JPanel implements ActionListener, MethodTaskListener {
    private Dialog dialog;
    private DialogDescriptor dlg = null;
    private String okString = NbBundle.getMessage(this.getClass(), "CLOSE");
    private final JavaMethod method;
    /**
     * The runtimeClassLoader should be used when running the web service client.  This classloader
     * only includes the necessary runtime jars for JAX-RPC to run.  The classloader does NOT have a
     * parent to delegate to.  I did this because of Xerces classloader clashes with other netbeans
     * modules.
     * -David Botterill 4/21/2004
     */
    private URLClassLoader runtimeClassLoader;
    
    private String packageName;
    private DefaultMutableTreeNode parameterRootNode = new DefaultMutableTreeNode();
    private DefaultMutableTreeNode resultRootNode = new DefaultMutableTreeNode();
    private WebServiceData wsData;
    public String portName;
    private WsdlPort port;
    private MethodTask methodTask;
    
    /** Creates new form TestWebServiceMethodDlg */
    public TestWebServiceMethodDlg(WebServiceData inWSData,  JavaMethod inMethod, WsdlPort inPort) {
        this.method = inMethod;
        wsData = inWSData;
        port = inPort;
        packageName = inWSData.getPackageName();
        portName = inPort.getName();
        
        assert wsData.getJaxWsDescriptor() != null;
        
        initComponents();
        myInitComponents();
        
        this.lblTitle.setText(NbBundle.getMessage(this.getClass(), "TEST_WEBSVC_LABEL") + " " + method.getName());
    }
    
    
    /**
     * This method returns the classloader of the Jar file containing the web service for which we are testing the methods.
     * This class loader should be used for the runtime environment when invoking a web service.
     * TODO: determine if the tree components should get the class loader here, store the classloader in the tree nodes, or pass
     * to the tree component constructors.
     *@returns URLClassLoader - the class loader of the Jar file for the web service with the methods to test.
     */
    private URLClassLoader getRuntimeClassLoader() {
        if(null == runtimeClassLoader) {
            
            /**
             * First add the URL to the jar file for this web service.
             */
            try {
                List<URL> urlList = null;
                
                urlList = ManagerUtil.buildClasspath(null, true); // NOI18N
                
                WebServiceDescriptor descriptor = wsData.getJaxWsDescriptor();
                for (WebServiceDescriptor.JarEntry entry : descriptor.getJars()) {
                    if (entry.getType().equals(WebServiceDescriptor.JarEntry.PROXY_JAR_TYPE)) {
                        File jarFile = new File(descriptor.getXmlDescriptorFile().getParent(), entry.getName());
                        File tmpJarFile = createTempCopy(jarFile);
                        
                        urlList.add(tmpJarFile.toURI().toURL());
                    }
                }
                
                URL [] urls = (URL [])urlList.toArray(new URL[0]);
                /**
                 * Delegate to the module's classloader since core/startup/NbInstaller
                 * overrides the JAX-WS 2.0 jars present in JDK 6
                 */
                
                runtimeClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
            } catch(IOException mfu) {
                ErrorManager.getDefault().notify(mfu);
                ErrorManager.getDefault().log(this.getClass().getName() + ":IOException=" + mfu);
                return null;
            }            
        }
        
        return runtimeClassLoader;
    }
    
    private File createTempCopy(File src) {
        try {
            java.io.File tempFile = java.io.File.createTempFile("proxyjar", "jar");
            java.nio.channels.FileChannel inChannel = new java.io.FileInputStream(src).getChannel();
            java.nio.channels.FileChannel outChannel = new java.io.FileOutputStream(tempFile).getChannel();
            inChannel.transferTo(0, inChannel.size(), outChannel);
            
            inChannel.close();
            outChannel.close();
            return tempFile;
        } catch (IOException ex) {
            ErrorManager.getDefault().notify(ErrorManager.WARNING, ex);
            return null;
        }
    }
    
    /**
     * This method returns the package name of the  web service for which we are testing the methods.
     * TODO: determine if the tree components should get the class loader here, store the classloader in the tree nodes, or pass
     * to the tree component constructors.
     *@returns URLClassLoader - the class loader of the Jar file for the web service with the methods to test.
     */
    public String getPackageName() {
        return packageName;
    }
    
    public WebServiceData getWebServiceData() {
        return this.wsData;
    }
    
    public void displayDialog(){
        
        dlg = new DialogDescriptor(this, NbBundle.getMessage(this.getClass(), "TEST_WEB_SERVICE_METHOD"),
                false, NotifyDescriptor.OK_CANCEL_OPTION, DialogDescriptor.OK_OPTION,
                DialogDescriptor.DEFAULT_ALIGN, this.getHelpCtx(), this);
        dlg.setOptions(new Object[] { okButton });
        dialog = DialogDisplayer.getDefault().createDialog(dlg);
        /**
         * After the window is opened, set the focus to the Get information button.
         */
        
        final JPanel thisPanel = this;
        dialog.addWindowListener( new WindowAdapter(){
            public void windowOpened( WindowEvent e ){
                SwingUtilities.invokeLater(
                        new Runnable() {
                    public void run() {
                        btnSubmit.requestFocus();
                        thisPanel.getRootPane().setDefaultButton(btnSubmit);
                    }
                });
            }
        });
        
        /**
         * Fix for Bug: 6217545
         * Need to know what the normal cursor is so we can reset it when
         * the dialog is closed.
         * - David Botterill 1/14/2005
         *
         */
        normalCursor=dialog.getCursor();
        /**
         * Fix for Bug: 6217545
         * Set the MouseListener for the OK button to a special adapter that will
         * make the cursor look normal ALWAYS when over the OK button.
         * - David Botterill 1/14/2005
         */
        BusyMouseAdapter mouseAdapter = new BusyMouseAdapter(normalCursor);
        okButton.addMouseListener(mouseAdapter);
        
        
        dialog.show();
    }
    public HelpCtx getHelpCtx() {
        return new HelpCtx("projrave_ui_elements_server_nav_test_websvcdb");
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jSplitPane1 = new javax.swing.JSplitPane();
        pnlParameter = new javax.swing.JPanel();
        pnlLabel = new javax.swing.JPanel();
        lblTitle = new javax.swing.JLabel();
        lblParameters = new javax.swing.JLabel();
        scrollPaneParameter = new javax.swing.JScrollPane();
        btnPanel = new javax.swing.JPanel();
        btnSubmit = new javax.swing.JButton();
        pnlResults = new javax.swing.JPanel();
        lblResults = new javax.swing.JLabel();
        scrollPaneResults = new javax.swing.JScrollPane();

        setToolTipText("");
        setPreferredSize(new java.awt.Dimension(600, 450));
        setLayout(new java.awt.BorderLayout());

        jSplitPane1.setDividerLocation(250);
        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        pnlParameter.setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 5, 12));
        pnlParameter.setLayout(new java.awt.BorderLayout());

        pnlLabel.setLayout(new java.awt.GridLayout(2, 0));

        lblTitle.setFont(lblTitle.getFont().deriveFont(lblTitle.getFont().getStyle() | java.awt.Font.BOLD, lblTitle.getFont().getSize()-2));
        lblTitle.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblTitle.setText(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TEST_WEB_SERVICE_METHOD")); // NOI18N
        pnlLabel.add(lblTitle);
        lblTitle.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.lblTitle.ACC_name")); // NOI18N
        lblTitle.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.lblTitle.ACC_desc")); // NOI18N

        lblParameters.setFont(lblParameters.getFont().deriveFont(lblParameters.getFont().getSize()-4f));
        lblParameters.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblParameters.setText(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TEST_WEBSVC_INSTRUCTIONS")); // NOI18N
        lblParameters.setToolTipText(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.jLabel1.tooltip")); // NOI18N
        pnlLabel.add(lblParameters);
        lblParameters.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.jLabel1.ACC_name")); // NOI18N
        lblParameters.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.jLabel1.ACC_desc")); // NOI18N

        pnlParameter.add(pnlLabel, java.awt.BorderLayout.NORTH);
        pnlLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.pnlLabel.ACC_name")); // NOI18N
        pnlLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.pnlLabel.ACC_desc")); // NOI18N

        scrollPaneParameter.setToolTipText("");
        pnlParameter.add(scrollPaneParameter, java.awt.BorderLayout.CENTER);
        scrollPaneParameter.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.scrollPaneParameter.ACC_name")); // NOI18N
        scrollPaneParameter.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.scrollPaneParameter.ACC_desc")); // NOI18N

        btnSubmit.setMnemonic(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.btnSubmit.ACC_mnemonic").charAt(0));
        btnSubmit.setText(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "BUTTON_SUBMIT")); // NOI18N
        btnSubmit.setToolTipText("");
        btnSubmit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSubmitActionPerformed(evt);
            }
        });
        btnPanel.add(btnSubmit);
        btnSubmit.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.btnSubmit.ACC_name")); // NOI18N
        btnSubmit.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.btnSubmit.ACC_desc")); // NOI18N

        pnlParameter.add(btnPanel, java.awt.BorderLayout.SOUTH);
        btnPanel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.btnPanel.ACC_name")); // NOI18N
        btnPanel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.btnPanel.ACC_desc")); // NOI18N

        jSplitPane1.setLeftComponent(pnlParameter);
        pnlParameter.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.pnlParameter.ACC_name")); // NOI18N
        pnlParameter.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.pnlParameter.ACC_desc")); // NOI18N

        pnlResults.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 12, 5, 12));
        pnlResults.setLayout(new java.awt.BorderLayout(0, 5));

        lblResults.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        lblResults.setText(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "RESULTS")); // NOI18N
        lblResults.setToolTipText("");
        pnlResults.add(lblResults, java.awt.BorderLayout.NORTH);
        lblResults.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.lblResults.ACC_name")); // NOI18N
        lblResults.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.lblResults.ACC_desc")); // NOI18N

        scrollPaneResults.setToolTipText("");
        pnlResults.add(scrollPaneResults, java.awt.BorderLayout.CENTER);
        scrollPaneResults.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.scrollPaneResults.ACC_name")); // NOI18N
        scrollPaneResults.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.scrollPaneResults.ACC_desc")); // NOI18N

        jSplitPane1.setRightComponent(pnlResults);
        pnlResults.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.pnResults.ACC_name")); // NOI18N
        pnlResults.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.pnResults.ACC_desc")); // NOI18N

        add(jSplitPane1, java.awt.BorderLayout.CENTER);
        jSplitPane1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.jsplintPane1.ACC_name")); // NOI18N
        jSplitPane1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.jsplintPane1.ACC_desc")); // NOI18N

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.main.ACC_name")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.main.ACC_desc")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    private void btnSubmitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSubmitActionPerformed
        dialog.setCursor(new Cursor(Cursor.WAIT_CURSOR));
        invokeMethod();
    }//GEN-LAST:event_btnSubmitActionPerformed
    private void invokeMethod() {
        /**
         *  Steps to call the method.
         *  1. Get the parameter values from the tree
         *  2. Get the client wrapper class
         *  3. Get the method.
         *  4. call the Method with the parameter values
         *  5. Display the return value.
         */
        
        /**
         * Get the parameter values from the tree.  The parameters will be the children of the root node only. Any children
         * of the parameter nodes are values used to derive the parameter values.  This means only the first children of the root
         * node will be used a parameters.  The logic to "roll-up" a parameter value is left to the TypeCellEditor class.
         */
        
        /**
         * Use a LinkedList because we care about the order of the parameters.
         */
        LinkedList<Object> paramList = new LinkedList<Object>();
        for(int ii=0; null != this.getParamterRootNode() && ii < this.getParamterRootNode().getChildCount(); ii++) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode) this.getParamterRootNode().getChildAt(ii);
            TypeNodeData nodeData = (TypeNodeData)childNode.getUserObject();
            Object parameterValue = nodeData.getTypeValue();

            paramList.add(parameterValue);
        }
        
        /**
         * specify the wrapper client class name for this method.
         */
        String className = wsData.getJaxWsDescriptor().getName(); //NOI18N
        String clientClassName = packageName + "." + className;
        
        /**
         * Fix for Bug: 6217545
         * We need to run the method in a separate thread so the user can cancel if the method call
         * locks up.
         * First we need to create the thread, then register for a listener so we can get notified when the method's
         * finished.
         * -David Botterill 1/14/2005
         */
        methodTask = new MethodTask(clientClassName,paramList,this.method,this.getRuntimeClassLoader());
        
        methodTask.registerListener(this);
        
        Thread methodThread = new Thread(methodTask);
        
        methodThread.start();
    }
    
    public void methodFinished(Object inReturnedObject,LinkedList inParamList) {
        dialog.setCursor(normalCursor);
        
        showResults(inReturnedObject);
        
        /**
         * Fix for Bug#: 5059732
         * Now we need to also set the parameter values in the tree nodes since they may have changed due
         * to the support for pass by reference ("Holders").
         * - David Botterill 8/12/2004
         */
        
        for(int ii=0; null != this.getParamterRootNode() && ii < this.getParamterRootNode().getChildCount(); ii++) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode) this.getParamterRootNode().getChildAt(ii);
            TypeNodeData nodeData = (TypeNodeData)childNode.getUserObject();
            nodeData.setTypeValue(inParamList.get(ii));
            /**
             * We really only care about Holder types from here since they are the only type of parameter that
             * can have the value changed by the endpoint service.
             */
            String topNodeType = nodeData.getTypeClass();
            if(ReflectionHelper.isHolder(topNodeType)) {
                ((ParameterTreeNode)childNode).updateChildren();
            }
        }
        /**
         * Update the table since we may have changed some tree node values.
         */
        parameterOutline.tableChanged(new TableModelEvent((TableModel)parameterOutline.getOutlineModel().getRowNodeModel()));
        
    }
    
    private void showResults(Object inResultObject) {
        /**
         * Create a tree of the result object types.
         */
        try {
            resultOutline = loadResultTreeTable(this.method, inResultObject);
            resultOutline.getTableHeader().setReorderingAllowed(false);
            resultOutline.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.resultOutline.ACC_name"));
            resultOutline.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.resultOutline.ACC_desc"));
            addFocusListener(resultOutline);

            lblResults.setLabelFor(resultOutline);

            scrollPaneResults.setViewportView(resultOutline);
        }catch (WebServiceReflectionException ex) {
                        Throwable cause = ex.getCause();
            ErrorManager.getDefault().notify(cause);
            ErrorManager.getDefault().log(this.getClass().getName() + ": WebServiceReflectionException=" + cause);
        }
    }
    
    
    private void myInitComponents() {
        okButton.setText(okString);
        
        /**
         * Now set up the Nodes for the TreeTableView
         */
        if(null == this.method) {
            return;
        }
        
        try {
            NodeHelper.createInstance(getRuntimeClassLoader(), packageName);
            
            parameterOutline = loadParameterTreeTable(this.method);

            // Turn off the reordering
            /**
             * Add it to the correct Panel.
             */

            scrollPaneParameter.setViewportView(parameterOutline);

            /**
             * Set up Accessibility stuff for not UI-Editor stuff.
             *
             */

            okButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.okButton.ACC_name"));
            okButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.okButton.ACC_desc"));
            okButton.setMnemonic(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.okButton.ACC_mnemonic").charAt(0));

            parameterOutline.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.parameterOutline.ACC_name"));
            parameterOutline.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TestWebServiceMethodDlg.class, "TestWebServiceMethodDlg.parameterOutline.ACC_desc"));
            lblParameters.setLabelFor(parameterOutline);
            addFocusListener(parameterOutline);
        }catch (WebServiceReflectionException ex) {
                        Throwable cause = ex.getCause();
            ErrorManager.getDefault().notify(cause);
            ErrorManager.getDefault().log(this.getClass().getName() + ": WebServiceReflectionException=" + cause);
        }
    }
    
    private void addFocusListener(final JTable table) {
        // fixes tab cycle when the table is empty
        table.addFocusListener(new FocusListener() {
            public void focusGained(FocusEvent evt) {
                Container cycleRoot = table.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = table.getFocusTraversalPolicy();
                if (policy == null && cycleRoot != null) {
                    policy = cycleRoot.getFocusTraversalPolicy();
                }

                if (table.getRowCount() == 0 && policy != null) {
                    Component target = policy.getComponentAfter(cycleRoot, table);
                    if (target != null && target == evt.getOppositeComponent()) {
                        target = policy.getComponentBefore(cycleRoot, table);
                    }

                    if (target != null) {
                        target.requestFocusInWindow();
                    }
                }
            }

            public void focusLost(FocusEvent evt) {
            }
        });
    }
    
    private DefaultMutableTreeNode getParamterRootNode() {
        return parameterRootNode;
    }
    
    private void setParameterRootNode(DefaultMutableTreeNode inNode) {
        parameterRootNode = inNode;
    }
    private DefaultMutableTreeNode getResultRootNode() {
        return resultRootNode;
    }
    
    private void setResultRootNode(DefaultMutableTreeNode inNode) {
        resultRootNode = inNode;
    }
    
    private Outline loadResultTreeTable(JavaMethod inMethod, Object inResultObject) throws WebServiceReflectionException {
        if(null == inMethod) {
            return null;
        }
        JavaType currentType = inMethod.getReturnType();
        String typeName = currentType.getRealName();
        TypeNodeData data = ReflectionHelper.createTypeData(typeName, inResultObject);
        
        DefaultMutableTreeNode node = NodeHelper.getInstance().createResultNodeFromData(data);
        
        /**
         * Make sure to create a new result root each time since the user can change the parameters and submit many
         * times.
         */
        this.setResultRootNode(new DefaultMutableTreeNode());
        /**
         *  Add it to the root.
         */
        this.getResultRootNode().add(node);
        
        DefaultTreeModel treeModel = new DefaultTreeModel(this.getResultRootNode());
        ResultRowModel rowModel = new ResultRowModel();
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel(treeModel,rowModel, false);
        outlineModel.setNodeColumnName(NbBundle.getMessage(this.getClass(), "TYPE_COLUMN_NAME")); // NOI18N
        Outline returnOutline = new Outline(outlineModel);
        ResultCellEditor cellEditor = new ResultCellEditor(runtimeClassLoader);
        returnOutline.setDefaultEditor(Object.class,cellEditor);
        returnOutline.setRootVisible(false);
        
        returnOutline.setRenderDataProvider(new TypeDataProvider());
        
        return returnOutline;
    }
    
    private Outline loadParameterTreeTable(JavaMethod inMethod) throws WebServiceReflectionException {
        if(null == inMethod) {
            return null;
        }
        
        List<JavaParameter> parameters = inMethod.getParametersList();
        for (JavaParameter currentParameter : parameters) {
            /**
             * Add all Parameter's to the root tree node.
             */
            JavaType currentType = currentParameter.getType();
            
            String typeName = currentType.getRealName();
            String typeParamName = currentParameter.getName();
            
            if (currentParameter.isHolder()) {
                typeName = "javax.xml.ws.Holder<" + typeName + ">"; // NOI18N
            }
            
            TypeNodeData data = ReflectionHelper.createTypeData(typeName, typeParamName);
            data.setTypeValue(NodeHelper.getInstance().getParameterDefaultValue(data));
            if (currentParameter.isHolder()) {
                if (currentParameter.getParameter().isIN()) data.setHolderType(TypeNodeData.IN);
                if (currentParameter.getParameter().isOUT()) data.setHolderType(TypeNodeData.OUT);
                if (currentParameter.getParameter().isINOUT()) data.setHolderType(TypeNodeData.IN_OUT);
            }
            
            DefaultMutableTreeNode node = NodeHelper.getInstance().createNodeFromData(data);
            
            /**
             *  Add it to the root.
             */
            this.getParamterRootNode().add(node);            
        }
        
        DefaultTreeModel treeModel = new DefaultTreeModel(this.getParamterRootNode());
        rowModel = new TypeRowModel(this.getRuntimeClassLoader());
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel(treeModel,rowModel, false);
        outlineModel.setNodeColumnName(NbBundle.getMessage(this.getClass(), "TYPE_COLUMN_NAME"));
        Outline returnOutline = new Outline(outlineModel);
        TypeCellEditor cellEditor = new TypeCellEditor(getRuntimeClassLoader());
        returnOutline.setDefaultEditor(Object.class,cellEditor);
        returnOutline.setRootVisible(false);
        returnOutline.setRenderDataProvider(new TypeDataProvider());
        /**
         * Fix Bug 5052705.  This setting will cause the cells values to take affect when
         * the focus is lost.  This will remove the requirement of hitting "ENTER" after
         * entering a value in a cell to get the value to take affect.
         */
        returnOutline.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE); // NOI18N
        
        return returnOutline;
    }
    
    
    public void actionPerformed(ActionEvent evt) {
        String actionCommand = evt.getActionCommand();
        if(actionCommand.equalsIgnoreCase(okString)) {
            okButtonAction(evt);
        }
    }
    
    private void okButtonAction(ActionEvent evt) {
        /**
         * If the MethodTask is not null, the MethodTask
         * thread may still be running so we need to tell
         * it we've cancelled.
         */
        if(null != methodTask) {
            methodTask.cancel();
        }
        dialog.setCursor(normalCursor);
        dialog.dispose();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel btnPanel;
    private javax.swing.JButton btnSubmit;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JLabel lblParameters;
    private javax.swing.JLabel lblResults;
    private javax.swing.JLabel lblTitle;
    private javax.swing.JPanel pnlLabel;
    private javax.swing.JPanel pnlParameter;
    private javax.swing.JPanel pnlResults;
    private javax.swing.JScrollPane scrollPaneParameter;
    private javax.swing.JScrollPane scrollPaneResults;
    // End of variables declaration//GEN-END:variables
    
    private JButton okButton = new JButton();
    private Outline parameterOutline;
    private Outline resultOutline;
    private TypeRowModel rowModel;
    private Cursor normalCursor;
    
    class MethodTask implements Runnable {
        
        private String clientClassName;
        private LinkedList paramList;
        private JavaMethod javaMethod;
        private URLClassLoader urlClassLoader;
        private ArrayList listeners = new ArrayList();
        private boolean cancelled=false;
        
        MethodTask(String inClientClassName, LinkedList inParamList, JavaMethod inJavaMethod,
                URLClassLoader inURLClassLoader) {
            clientClassName = inClientClassName;
            paramList = inParamList;
            javaMethod = inJavaMethod;
            urlClassLoader = inURLClassLoader;
        }
        
        public void registerListener(MethodTaskListener inListener) {
            if(!listeners.contains(inListener)) {
                listeners.add(inListener);
            }
        }
        
        private void notifyListeners(Object returnedObject) {
            Iterator listenerIterator = listeners.iterator();
            MethodTaskListener currentListener = null;
            while(listenerIterator.hasNext()) {
                currentListener = (MethodTaskListener)listenerIterator.next();
                currentListener.methodFinished(returnedObject, paramList);
            }
        }
        
        public void run() {
            /**
             * Now invoke the method using the ReflectionHelper.
             */
            Object returnObject=null;
            try {
                returnObject = ReflectionHelper.callMethodWithParams(clientClassName, paramList, javaMethod,urlClassLoader, wsData, port);
            } catch(WebServiceReflectionException wsre) {
                if(!cancelled) {
                    Throwable exception = wsre;
                    if (wsre.getCause() instanceof java.lang.reflect.InvocationTargetException) {
                        exception = wsre.getCause();
                    }
                    MethodExceptionDialog errorDialog = new MethodExceptionDialog(exception);
                    /**
                     * Notify the listeners so the cursor will be reset;
                     */
                    notifyListeners(null);
                    errorDialog.show();
                }
                return;
            }
            
            notifyListeners(returnObject);
        }
        
        public void cancel() {
            cancelled=true;
        }
    }
    
    private static class BusyMouseAdapter extends MouseAdapter {
        private Cursor normalCursor;
        
        public BusyMouseAdapter(Cursor inNormalCursor) {
            normalCursor = inNormalCursor;
        }
        
        public void mouseEntered(MouseEvent e) {
            e.getComponent().setCursor(normalCursor);
        }
        
        public void mouseExited(MouseEvent e) {
        }
    }
}
