/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import com.sun.rave.propertyeditors.domains.EditableDomain;
import com.sun.rave.propertyeditors.domains.Element;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/**
 * A panel for gathering the display label and value of a new domain element.
 *
 * @author gjmurphy
 */

// TODO Allow value types other than String to be edited
// TODO Check whether new element is already in domain

class EditElementDialog extends JPanel {

    static ResourceBundle bundle =
            ResourceBundle.getBundle(EditElementDialog.class.getPackage().getName() + ".Bundle"); //NOI18N

    private Element element;
    private EditableDomain domain;

    EditElementDialog(EditableDomain domain) {
        this(null, domain);
    }

    EditElementDialog(Element element, EditableDomain domain) {
        this.element = element;
        this.domain = domain;
        initComponents();
    }

    /** This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        labelLabel = new javax.swing.JLabel();
        valueLabel = new javax.swing.JLabel();
        labelTextField = new javax.swing.JTextField();
        if (this.element != null)
        this.labelTextField.setText(this.element.getLabel());
        this.labelTextField.getDocument().addDocumentListener(new DocumentListener() {
            public void removeUpdate(DocumentEvent e) {
                labelTextFieldUpdated();
            }
            public void insertUpdate(DocumentEvent e) {
                labelTextFieldUpdated();
            }
            public void changedUpdate(DocumentEvent e) {
                labelTextFieldUpdated();
            }
        });
        valueTextField = new javax.swing.JTextField();
        if (this.element != null)
        this.valueTextField.setText(this.element.getValue().toString());
        valueCheckBox = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        labelLabel.setText(java.util.ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("EditElementDialog.value"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        add(labelLabel, gridBagConstraints);

        valueLabel.setText(java.util.ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("EditElementDialog.label"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 0);
        add(valueLabel, gridBagConstraints);

        labelTextField.setColumns(24);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 0);
        add(labelTextField, gridBagConstraints);

        valueTextField.setColumns(24);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        add(valueTextField, gridBagConstraints);

        valueCheckBox.setText(java.util.ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("EditElementDialog.same"));
        valueCheckBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        valueCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        valueCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                valueCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 6);
        add(valueCheckBox, gridBagConstraints);

        jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT, 6, 6));

        okButton.setText(java.util.ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("EditElementDialog.ok"));
        okButton.setActionCommand("ok");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        jPanel1.add(okButton);

        cancelButton.setText(java.util.ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("EditElementDialog.cancel"));
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jPanel1.add(cancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        add(jPanel1, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    private void valueCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_valueCheckBoxActionPerformed
        if (evt.getSource() == this.valueCheckBox) {
            if (this.valueCheckBox.getModel().isSelected()) {
                this.valueTextField.setEnabled(false);
                this.valueTextField.setText(this.labelTextField.getText());
            } else {
                this.valueTextField.setEnabled(true);
            }
        }
    }//GEN-LAST:event_valueCheckBoxActionPerformed
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        this.element = null;
        dialog.setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        String label = this.labelTextField.getText().trim();
        String value = this.valueTextField.getText().trim();
        if (value.length() == 0) {
            this.element = null;
            String message = bundle.getString("EditElementDialog.emptyValueError");
            JOptionPane.showMessageDialog(dialog, message);
        } else {
            this.element = new Element(value, label);
            dialog.setVisible(false);
        }
    }//GEN-LAST:event_okButtonActionPerformed
    
    private void labelTextFieldUpdated() {
        if (this.valueCheckBox.getModel().isSelected())
            this.valueTextField.setText(this.labelTextField.getText());
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel labelLabel;
    private javax.swing.JTextField labelTextField;
    private javax.swing.JButton okButton;
    private javax.swing.JCheckBox valueCheckBox;
    private javax.swing.JLabel valueLabel;
    private javax.swing.JTextField valueTextField;
    // End of variables declaration//GEN-END:variables
    
    private JDialog dialog;
    
    public Element showDialog(JPanel parent) {
        String domainDisplayName = this.domain.getDisplayName();
        String dialogTitle;
        if (domainDisplayName == null)
            dialogTitle = bundle.getString("EditElementDialog.title.default");
        else
            dialogTitle = MessageFormat.format(bundle.getString("EditElementDialog.title"),
                    new String[]{domainDisplayName});
        this.dialog =
                new JDialog((Dialog) parent.getRootPane().getParent(), dialogTitle, true);
        this.valueCheckBox.getModel().setSelected(true);
        this.valueTextField.setEnabled(false);
        if (element != null) {
            String label = element.getLabel();
            String value = element.getValue().toString();
            this.labelTextField.setText(label);
            this.valueTextField.setText(value);
            if (!label.equals(value)) {
                this.valueCheckBox.getModel().setSelected(false);
                this.valueTextField.setEnabled(true);
            }
        }
        this.dialog.setContentPane(this);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(dialog);
        this.labelTextField.requestFocusInWindow();
        this.dialog.show();
        this.dialog.dispose();
        this.dialog = null;
        return this.element;
    }
}
