/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * ModuleRefCustomizer.java
 *
 * Created on September 4, 2003, 5:28 PM
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.other;

import java.beans.Customizer;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JPanel;

import org.netbeans.modules.j2ee.sun.share.configbean.BaseModuleRef;
import org.netbeans.modules.j2ee.sun.share.configbean.ErrorMessageDB;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.CustomizerErrorPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.CustomizerTitlePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BaseCustomizer;


/**
 *
 * @author Peter Williams
 */
public class ModuleRefCustomizer extends BaseCustomizer {
	
	/** Resource bundle */
	private final ResourceBundle bundle = ResourceBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.other.Bundle"); // NOI18N

	private BaseModuleRef theBean;

	/** Creates new form ModuleRefCustomizer */
	public ModuleRefCustomizer() {
		initComponents();
		initUserComponents();
	}

	public BaseModuleRef getBean() {
		return theBean;
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPnlGeneral = new javax.swing.JPanel();
        jLblModuleUri = new javax.swing.JLabel();
        jTxtModuleUri = new javax.swing.JTextField();
        jPnlPlaceHolder = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        jPnlGeneral.setLayout(new java.awt.GridBagLayout());

        jLblModuleUri.setDisplayedMnemonic(bundle.getString("MNC_ModuleUri").charAt(0));
        jLblModuleUri.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLblModuleUri.setLabelFor(jTxtModuleUri);
        jLblModuleUri.setText(bundle.getString("LBL_ModuleURI_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPnlGeneral.add(jLblModuleUri, gridBagConstraints);
        jLblModuleUri.getAccessibleContext().setAccessibleName(bundle.getString("ModuleURI_Acsbl_Name"));
        jLblModuleUri.getAccessibleContext().setAccessibleDescription(bundle.getString("ModuleURI_Acsbl_Desc"));

        jTxtModuleUri.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPnlGeneral.add(jTxtModuleUri, gridBagConstraints);
        jTxtModuleUri.getAccessibleContext().setAccessibleName(bundle.getString("ModuleURI_Acsbl_Name"));
        jTxtModuleUri.getAccessibleContext().setAccessibleDescription(bundle.getString("ModuleURI_Acsbl_Desc"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 5);
        add(jPnlGeneral, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(jPnlPlaceHolder, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
		
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLblModuleUri;
    private javax.swing.JPanel jPnlGeneral;
    private javax.swing.JPanel jPnlPlaceHolder;
    private javax.swing.JTextField jTxtModuleUri;
    // End of variables declaration//GEN-END:variables
	
	private void initUserComponents() {
		// Add title panel
		addTitlePanel(bundle.getString("LBL_SunJ2eeModuleRef"));  //NOI18N
		
		
		// Add error panel
		addErrorPanel();		
	}
	
	/** Initialization of all the fields in the customizer from the bean that
	 *  was passed in.
	 */
	protected void initFields() {
        // Set nice title based on the type of module this represents.
        getTitlePanel().setCustomizerTitle(MessageFormat.format(
                bundle.getString("LBL_SunTFModuleRef"), new Object [] { theBean.getTitleFragment() }));
        
		jTxtModuleUri.setText(theBean.getModuleUri());

		//jTxtIdentity.setText(theBean.getIdentity());
		//jTxtRefIdentity.setText(theBean.getRefIdentity());
	}

	protected boolean setBean(Object bean) {
		boolean result = super.setBean(bean);
		
		if(bean instanceof BaseModuleRef) {
			theBean = (BaseModuleRef) bean;
			result = true;
		} else {
			// if bean is not a BaseModuleRef, then it shouldn't have passed Base either.
			assert (result == false) : 
				"BaseModuleRefCustomizer was passed wrong bean type in setBean(Object bean)";	// NOI18N
				
			theBean = null;
			result = false;
		}
		
		return result;
	}	
	
	public String getHelpId() {
		return "AS_CFG_ModuleRef";
	}
}
