/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * ChangeDocTypePanel.java
 *
 * Created on April 4, 2006, 3:45 PM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Dimension;
import java.awt.GridBagConstraints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;

import javax.swing.JPanel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;

import org.netbeans.modules.j2ee.sun.share.Constants;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.cookies.OpenCookie;
import org.openide.util.NbBundle;

/**
 *
 * @author Peter Williams
 */
public class ChangeDocTypePanel extends javax.swing.JPanel {
    
	/** Reference to the resource bundle in customizers/common
	 */
	protected final ResourceBundle commonBundle = ResourceBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");	// NOI18N

    private final JPanel customizerPanel;
    private final Base theBean;
    private final SunONEDeploymentConfiguration config;
    
    private ASDDVersion currentVersion;
    private DefaultComboBoxModel versionModel;
    
    /** Creates new form ChangeDocTypePanel */
    public ChangeDocTypePanel(JPanel cp, Base bean) {
        customizerPanel = cp;
        theBean = bean;
        config = theBean.getConfig();
        currentVersion = config.getAppServerVersion();

        initComponents();
        initFields();
    }

    public ASDDVersion getOriginalVersion() {
        return config.getAppServerVersion();
    }

    public ASDDVersion getCurrentVersion() {
        return currentVersion;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLblAppServerVersion = new javax.swing.JLabel();
        jCbxAppServerVersion = new javax.swing.JComboBox();
        jLblDocType = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTxtDocType = new javax.swing.JTextArea();

        setLayout(new java.awt.GridBagLayout());

        jLblAppServerVersion.setLabelFor(jCbxAppServerVersion);
        jLblAppServerVersion.setText(commonBundle.getString("LBL_ServerVersion_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 11, 11);
        add(jLblAppServerVersion, gridBagConstraints);

        jCbxAppServerVersion.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCbxAppServerVersionItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 11, 11);
        add(jCbxAppServerVersion, gridBagConstraints);
        jCbxAppServerVersion.getAccessibleContext().setAccessibleName(commonBundle.getString("ACSN_ServerVersion"));
        jCbxAppServerVersion.getAccessibleContext().setAccessibleDescription(commonBundle.getString("ACSD_ServerVersion"));

        jLblDocType.setLabelFor(jTxtDocType);
        jLblDocType.setText(commonBundle.getString("LBL_DocTypeTag_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 1, 5);
        add(jLblDocType, gridBagConstraints);
        jLblDocType.getAccessibleContext().setAccessibleName(commonBundle.getString("ACSN_DocTypeTag"));

        jTxtDocType.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        jTxtDocType.setColumns(20);
        jTxtDocType.setEditable(false);
        jTxtDocType.setRows(3);
        jTxtDocType.setTabSize(4);
        jScrollPane1.setViewportView(jTxtDocType);
        jTxtDocType.getAccessibleContext().setAccessibleName(commonBundle.getString("ACSN_DocTypeTag"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 11, 11);
        add(jScrollPane1, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void jCbxAppServerVersionItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCbxAppServerVersionItemStateChanged
		currentVersion = (ASDDVersion) versionModel.getSelectedItem();
        setDocTypeText(getDocType());
		firePropertyChange(Constants.USER_DATA_CHANGED, null, null);
    }//GEN-LAST:event_jCbxAppServerVersionItemStateChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jCbxAppServerVersion;
    private javax.swing.JLabel jLblAppServerVersion;
    private javax.swing.JLabel jLblDocType;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTxtDocType;
    // End of variables declaration//GEN-END:variables
    
	private void initFields() {
        versionModel = new DefaultComboBoxModel();
        ASDDVersion minVersion = config.getMinASVersion();
        ASDDVersion maxVersion = config.getMaxASVersion();
        
        for(int i = 0; i < ASDDVersion.asDDVersions.length; i++) {
            if(ASDDVersion.asDDVersions[i].compareTo(minVersion) < 0) {
                continue;
            } else if(ASDDVersion.asDDVersions[i].compareTo(maxVersion) > 0) {
                break;
            } else {
                versionModel.addElement(ASDDVersion.asDDVersions[i]);
            }
        }
        
        jCbxAppServerVersion.setModel(versionModel);
        jCbxAppServerVersion.setSelectedItem(currentVersion);
        
        setDocTypeText(getDocType());
	}
    
    private void setDocTypeText(String doctype) {
        jTxtDocType.setText(doctype);
        jTxtDocType.getAccessibleContext().setAccessibleDescription(doctype);
        
        // set the line count of the text area to reflect how large the doctype
        // statement is.  This is to look nice if the doctype also includes the 
        // sun-cmp-mappings doctype.
        jTxtDocType.setRows(Math.min(10, Math.max(3, countLines(doctype))));
    }
    
    private int countLines(String text) {
        // start count at one, so we always return one greater than actual number of lines.
        int result = 1, max = text.length();
        for(int i = 0; i < max; i++) {
            if(text.charAt(i) == '\n') {
                result++;
            }
        }
        return result;
    }
    
    private String getDocType() {
        Base bean = theBean;
        
        while(bean.getParent() != null) {
            bean = bean.getParent();
        }
        
        BaseRoot rootBean = (BaseRoot) bean;
        return rootBean.generateDocType(currentVersion);
    }
    
	private Collection getErrors() {
        return Collections.EMPTY_SET;
    }
    
	private Collection getWarnings() {
		// Validate what the user typed in as a valid principal/group name
		ArrayList warnings = new ArrayList();
		
		ASDDVersion newVersion = getCurrentVersion();
		ASDDVersion oldVersion = getOriginalVersion();

        /** Print warning if there are unsaved changes in configuration.
         */
        if(hasUnsavedChanges()) {
            warnings.add(commonBundle.getString("WARN_WillSaveChanges"));	// NOI18N
        }

        /** If new verion is < old version, warn about possible data loss of any
         *  new fields.  Note we don't confirm if any of the newer fields are actually
         *  used, but we could implement such a check if we had the devtime.
         */
        if(newVersion.compareTo(oldVersion) < 0) {
            warnings.add(commonBundle.getString("WARN_PossibleDataLoss")); // NOI18N
        }
		
		return warnings;
	}
    
    private boolean hasUnsavedChanges() {
        boolean result = false;
        ConfigurationStorage storage = config.getStorage();
        if(storage != null) {
            ConfigDataObject primaryDO = storage.getPrimaryDataObject();
            result = (primaryDO != null && primaryDO.areModified());
        }
        return result;
    }

    private boolean changeVersion(ASDDVersion newVersion) {
        // first get primary dataobject
        ConfigDataObject primaryDO = null;
        ConfigurationStorage storage = config.getStorage();
        if(storage != null) {
            primaryDO = storage.getPrimaryDataObject();
        }
        
        if(primaryDO == null) {
//            System.out.println("Can't find primary dataobject for this configuration.");
            return false;
        }
        
        if(!primaryDO.closeConfigEditors()) {
//            System.out.println("Failed to close editor(s).");
            return false;
        }
        
        // change version via config api
        config.setAppServerVersion(newVersion);
        try {
            // hack - wait for autosave() to post it's event.
            Thread.currentThread().sleep(200);
        } catch (InterruptedException ex) {
            // shouldn't happen, but just ignore it if it does.
        }

        final ConfigDataObject theDataObject = primaryDO;
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                // reopen editor
                OpenCookie opener = (OpenCookie) theDataObject.getCookie(OpenCookie.class);
                if(opener != null) {
                    opener.open();
                } 
            }
        });
        
        return true;
    }

	/** Puts up an 'Edit...' dialog, doing validation against the supplied model,
	 *  and ultimately updating the data model if the user hits <OK> and clears
	 *  any errors.
	 *
	 * @param parent JPanel that is the parent of this popup - used for centering and sizing.
	 * @param entryValue The existing entry.  This will be prefilled into the edit field.
	 * @param resourceBase The base name for the resources required for this instantiation
	 *        of the panel.
	 * @param helpId The help ID for the dialog.
	 * @param theModel The particular Security model instance we're updating.
	 */
	public static void editASVersion(JPanel parent, Base theBean) {
		ChangeDocTypePanel docTypePanel = new ChangeDocTypePanel(parent, theBean);
		docTypePanel.displayDialog(parent, NbBundle.getBundle(
                        "org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle").getString("TITLE_ChangeDocType"),	// NOI18N
			"AS_CFG_ChangeDocTypePanelHelp"); // NOI18N
	}	
	
	private void displayDialog(JPanel parent, String title, String helpId) {
		BetterInputDialog dialog = new BetterInputDialog(parent, title, helpId, this);

        int dialogChoice = dialog.display();
        if(dialogChoice == dialog.OK_OPTION) {
            ASDDVersion newVersion = getCurrentVersion();
            ASDDVersion oldVersion = getOriginalVersion();

            if(newVersion.compareTo(oldVersion) != 0) {
                changeVersion(newVersion);
            }
        }
	}
    
    // !PW Should refactor this to handle any JPanel + error interface combo
	private static class BetterInputDialog extends InputDialog {
		private final ChangeDocTypePanel dialogPanel;
		private final String panelHelpId;
		
		public BetterInputDialog(JPanel parent, String title, String helpId, ChangeDocTypePanel childPanel) {
			super(parent, title, false, true);
			
			dialogPanel = childPanel;
			panelHelpId = helpId;
			
			dialogPanel.setPreferredSize(new Dimension(parent.getWidth()*3/4, 
				dialogPanel.getPreferredSize().height));
			
			this.getAccessibleContext().setAccessibleName(dialogPanel.getAccessibleContext().getAccessibleName());
			this.getAccessibleContext().setAccessibleDescription(dialogPanel.getAccessibleContext().getAccessibleDescription());

            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridwidth = GridBagConstraints.REMAINDER;
            constraints.fill = GridBagConstraints.BOTH;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
			getContentPane().add(childPanel, constraints, 0);

            addListeners();
			pack();
			setLocationInside(parent);
			handleErrorDisplay();
		}
		
		private void addListeners() {
			dialogPanel.addPropertyChangeListener(Constants.USER_DATA_CHANGED, new PropertyChangeListener() {
				public void propertyChange(PropertyChangeEvent evt) {
					handleErrorDisplay();
				}
			});
		}

		private void handleErrorDisplay() {
            setErrors(dialogPanel.getErrors(), dialogPanel.getWarnings());
		}
		
		protected String getHelpId() {
			return panelHelpId;
		}
	}
}
