/**
 * 
 */
package org.netbeans.modules.php.rt.providers.impl;

import org.netbeans.modules.php.rt.spi.providers.Host;


/**
 * @author ads
 *
 */
public abstract class HostImpl implements Host {
    
    public static final String DEFAULT_PORT    = "80";         // NOI18N
    
    public static final String DOMAIN          = "domain";     // NOI18N
    
    public static final String PORT            = "port";     // NOI18N
    
    public static final String DOCUMENT_PATH   = "document-path";      // NOI18N
    
    public HostImpl( String domain , String port,  AbstractProvider provider ){
        assert domain!= null;
        myDomain = domain ;
        myPort = port;
        myProvider = provider;
    }
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.spi.providers.Host#getProvider()
     */
    public AbstractProvider getProvider() {
        return myProvider;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals( Object obj )
    {
        if ( !( obj instanceof HostImpl ) ){
            return false;
        }
        HostImpl impl = (HostImpl) obj;
        boolean domainEq = getDomain().equals( impl.getDomain() );
        if ( !domainEq ){
            return false;
        }
        return getPort().equals( impl.getPort() );
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode()
    {
        return getDomain().hashCode()*37 + getPort().hashCode();
    }
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.spi.providers.Host#getProperty(java.lang.String)
     */
    public Object getProperty( String key ) {
        if ( PORT.equals(key) ) {
            return myPort;
        }
        else if ( DOMAIN.equals(key) ) {
            return myDomain;
        }
        else {
            return null;
        }
    }
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.php.rt.spi.providers.Host#putProperty(java.lang.String, java.lang.Object)
     */
    public void setProperty( String key, Object value ) {
        /*
         * Prevent resetting main properties of this class.
         * One need to reisntatiate class instead of changing these props.
         */
        assert !PORT.equals( key ) && !DOMAIN.equals(key ) : "Property with key " // NOI18N 
            +key+ " is not mutable. You need to reinstatiate this class";        // NOI18N
    }
    
    public void remove() {
        AbstractProvider provider = getProvider();
        provider.remove( this );
    } 

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        if ( getPort().equals( DEFAULT_PORT )) {
            return getDomain();
        }
        else {
            return getDomain() +":" +getPort();     // NOI18N
        }
    }
    
    public String getName() {
        return toString();
    }
    
    protected String getDomain(){
        return myDomain;
    }
    
    protected String getPort(){
        if ( myPort == null ){
            return DEFAULT_PORT;
        }
        return myPort;
    }
    
    private String myDomain;
    
    private String myPort;
    
    private  AbstractProvider myProvider;

}
