/*
 * FtpServerCustomizer.java
 *
 * Created on 1 Август 2007 г., 20:02
 */

package org.netbeans.modules.php.rt.providers.impl;

import org.netbeans.modules.php.rt.providers.impl.ftp.*;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.netbeans.modules.php.rt.WebServerRegistry;
import org.netbeans.modules.php.rt.providers.impl.AbstractProvider;
import org.netbeans.modules.php.rt.providers.impl.HostImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

/**
 *
 * @author  avk
 */
public class DefaultServerCustomizer extends javax.swing.JPanel {

    /** Creates new form ServerCustomizer */
    public DefaultServerCustomizer(HostImpl host) {
        initComponents();
        this.myHost = host;


    }

    public Window createCustomizerDialog(ServerCustomizerComponent innerPanel, String title) {
        init(innerPanel);
        OptionListener listener = new OptionListener();

        DialogDescriptor dialogDescriptor = new DialogDescriptor(this, title, true, DialogDescriptor.OK_CANCEL_OPTION, DialogDescriptor.CANCEL_OPTION, listener);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dialogDescriptor);

        myDialog = dlg;
        myDialogDescriptor = dialogDescriptor;

        return dlg;
    }


    private void init(ServerCustomizerComponent innerPanel) {

        if (myCustomizerPanel != null) {
            myCustomizerContainer.remove(myCustomizerPanel);
        }

        
        myCustomizerContainer.add(BorderLayout.NORTH, innerPanel);
        myCustomizerPanel = innerPanel;

        myCustomizerContainer.validate();
        validate();

        read(getHost());
    }

    void read(HostImpl impl) {
        if (myCustomizerPanel != null) {
            if (myCustomizerPanel instanceof ServerCustomizerComponent) {
                ServerCustomizerComponent panel = (ServerCustomizerComponent) myCustomizerPanel;
                panel.readValues(impl);
            }
        }
    }

    HostImpl store() {
        if (myCustomizerPanel != null) {
            if (myCustomizerPanel instanceof ServerCustomizerComponent) {
                ServerCustomizerComponent panel = (ServerCustomizerComponent) myCustomizerPanel;
                return panel.storeValues();
            }
        }
        return null;
    }

    public void stateChanged() {
        if (myCustomizerPanel != null) {
            if (myCustomizerPanel instanceof ServerCustomizerComponent) {
                ServerCustomizerComponent panel = (ServerCustomizerComponent) myCustomizerPanel;
                boolean validateUnique = false;
                setErrorMessage("");
                boolean isContentValid = panel.doContentValidation(validateUnique);
                if (myDialogDescriptor != null) {
                    if (isContentValid) {
                        myDialogDescriptor.setValid(true);
                    } else {
                        myDialogDescriptor.setValid(false);
                    }
                }
            }
        }
    }

    public void setMessage(String msg) {
        myMessagePanel.setText(msg);
        myMessagePanel.setForeground(Color.BLACK);
    }

    public void setErrorMessage(String msg) {
        myMessagePanel.setText(msg);
        myMessagePanel.setForeground(Color.RED);
    }

/** Listens to the actions on the Customizer's option buttons */
    private class OptionListener extends WindowAdapter implements ActionListener {

        OptionListener() {
        }

        // Listening to OK button ----------------------------------------------
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DialogDescriptor.OK_OPTION) {
                // Store the properties into project
                HostImpl host = store();
                instantiate(myHost, host);
            }
            // Close & dispose the the dialog
            if (myDialog != null) {
                myDialog.setVisible(false);
                myDialog.dispose();
            }
        }


        private void instantiate(HostImpl oldHost, HostImpl newHost) {
            AbstractProvider provider = (AbstractProvider) oldHost.getProvider();

            provider.updateHost(oldHost, newHost);
            // send notification 
            WebServerRegistry.getInstance().upadateHost(newHost);
        }


        // Listening to window events ------------------------------------------
        public void windowClosed(WindowEvent e) {
            myDialog = null;
        }

        public void windowClosing(WindowEvent e) {
            //Dispose the dialog otherwsie the {@link WindowAdapter#windowClosed}
            //may not be called
            if (myDialog != null) {
                myDialog.setVisible(false);
                myDialog.dispose();
            }
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        myCustomizerContainer = new javax.swing.JPanel();
        myCustomizerPanel = new javax.swing.JPanel();
        myMessageContainer = new javax.swing.JPanel();
        myMessagePanel = new javax.swing.JTextPane();

        setLayout(new java.awt.GridBagLayout());

        myCustomizerContainer.setLayout(new java.awt.BorderLayout());

        org.jdesktop.layout.GroupLayout myCustomizerPanelLayout = new org.jdesktop.layout.GroupLayout(myCustomizerPanel);
        myCustomizerPanel.setLayout(myCustomizerPanelLayout);
        myCustomizerPanelLayout.setHorizontalGroup(
            myCustomizerPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 0, Short.MAX_VALUE)
        );
        myCustomizerPanelLayout.setVerticalGroup(
            myCustomizerPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 0, Short.MAX_VALUE)
        );

        myCustomizerContainer.add(myCustomizerPanel, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(myCustomizerContainer, gridBagConstraints);

        myMessagePanel.setEditable(false);
        myMessagePanel.setFocusable(false);
        myMessagePanel.setMinimumSize(new java.awt.Dimension(6, 10));
        myMessagePanel.setOpaque(false);
        myMessagePanel.setPreferredSize(new java.awt.Dimension(0, 0));

        org.jdesktop.layout.GroupLayout myMessageContainerLayout = new org.jdesktop.layout.GroupLayout(myMessageContainer);
        myMessageContainer.setLayout(myMessageContainerLayout);
        myMessageContainerLayout.setHorizontalGroup(
            myMessageContainerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(myMessageContainerLayout.createSequentialGroup()
                .add(myMessagePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 378, Short.MAX_VALUE)
                .addContainerGap())
        );
        myMessageContainerLayout.setVerticalGroup(
            myMessageContainerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(myMessageContainerLayout.createSequentialGroup()
                .add(myMessagePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 22, Short.MAX_VALUE)
                .addContainerGap())
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(myMessageContainer, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel myCustomizerContainer;
    private javax.swing.JPanel myCustomizerPanel;
    private javax.swing.JPanel myMessageContainer;
    private javax.swing.JTextPane myMessagePanel;
    // End of variables declaration//GEN-END:variables
    // End of variables declaration
    // End of variables declaration
    // End of variables declaration
    protected HostImpl getHost() {
        return myHost;
    }

    private HostImpl myHost;
    private Dialog myDialog;
    private DialogDescriptor myDialogDescriptor;
}
