/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface.models;

import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.scripting.php.dbginterface.DbgDebuggerImpl;
import org.netbeans.modules.scripting.php.dbginterface.ModelSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.netbeans.spi.debugger.ui.Constants;
import org.openide.text.Line;
import org.openide.util.Mutex;

/**
 *
 * @author   Jan Jancura
 */
public class CallStackModel extends ModelSupport
        implements TreeModel, NodeModel, NodeActionsProvider, TableModel {

    private static final boolean DEBUG = false;

    public static final String CALL_STACK =
        "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK =
        "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";

    public CallStackModel(final ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    private final ContextProvider contextProvider;

    private ContextProvider getContextProvider() {
        return contextProvider;
    }

    private DbgDebuggerImpl getDebugger() {
        return (DbgDebuggerImpl)contextProvider.lookupFirst(
                null, DbgDebuggerImpl.class);
    }

    // ------------------------------------------------------------------------
    // TreeModel implementation
    // ------------------------------------------------------------------------
    public Object getRoot() {
        return ROOT;
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == ROOT) {
            DbgDebuggerImpl.Context context = getDebugger().getCurrentScriptContext();
            
            if (context != null) {
                List<DebugFrame> callstack = context.getCallStack();
                
                if (callstack != null) {
                    return callstack.toArray(new DebugFrame[callstack.size()]);
                }
            }

            return new DebugFrame[0];
        }
        
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == ROOT) {
            return false;
        }
        else if (node instanceof DebugFrame) {
            return true;
        }
        
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == ROOT) {
            DbgDebuggerImpl.Context context = getDebugger().getCurrentScriptContext();
            
            if (context != null && context.getCallStack() != null) {
                return context.getCallStack().size();
            }
            else {
                return 0;
            }
        }
        
        throw new UnknownTypeException(node);
    }

    // ------------------------------------------------------------------------
    // NodeModel implementation
    // ------------------------------------------------------------------------
    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof DebugFrame) {
            DebugFrame frame = (DebugFrame)node;
            
            System.err.println("mw CallStackModel.getDisplayName(" + frame + ")");
            
            return frame.getDisplayName();
        }
        else if (node == ROOT) {
            return ROOT.toString();
        }
        
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof DebugFrame) {
            DbgDebuggerImpl.Context context = getDebugger().getCurrentScriptContext();
            
            if(context != null && context.getCallStack().get(0) == node) {
                return CURRENT_CALL_STACK;
            }
            else {
                return CALL_STACK;
            }
        }
        else if (node == ROOT) {
            return null;
        }
        
        throw new UnknownTypeException (node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if(node == ROOT) {
            return null;
        }
        else if (node instanceof DebugFrame) {
            return null;
        }
        
        throw new UnknownTypeException (node);
    }

    // ------------------------------------------------------------------------
    // NodeActionsProvider implementation
    // ------------------------------------------------------------------------
    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof DebugFrame) {
            DebugFrame frame = (DebugFrame)node;

            // Update frame dependent models to current frame.
            DbgDebuggerImpl debugger = getDebugger();
            debugger.getWatchesModel().setStackFrame(frame);
            debugger.getVariablesModel().setStackFrame(frame);

            // Focus current file/line of selected stack frame.
            final Line line = frame.getLine();
            
            if (line != null) {
                Mutex.EVENT.readAccess(new Runnable () {
                    public void run () {
                        line.show(Line.SHOW_GOTO);
                    }
                });
            }
        }
        throw new UnknownTypeException (node);
    }

    public Action[] getActions (Object node) throws UnknownTypeException {
        return new Action[] {};
    }

    // ------------------------------------------------------------------------
    // TableModel implementation
    // ------------------------------------------------------------------------
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if(node == ROOT) {
            return null;
        }
        else if (node instanceof DebugFrame) {
            if (columnID == Constants.CALL_STACK_FRAME_LOCATION_COLUMN_ID) {
                DebugFrame frame = (DebugFrame)node;
                
                return frame.getSourceFile() + ":" + frame.getLineNumber();
            }
            else {
                return "?! unknown column";
            }
        }
        
        throw new UnknownTypeException (node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if(node == ROOT) {
            return true;
        }
        else if (node instanceof DebugFrame) {
            return true;
        }
        
        throw new UnknownTypeException (node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }
}
