/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface.api;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/**
 *
 * @author marcow
 */
public class DbgSourceMap {
    private String serverBaseDir;
    private URL serverBaseUrl;
    private FileObject sourceRoot;
    private boolean serverIsOnWindows;
    private Map<String,DataObject> sourceFileMap =
            Collections.synchronizedMap(new WeakHashMap<String,DataObject>());
    
    /** Creates a new instance of DbgSourceMap */
    public DbgSourceMap(URL serverBaseUrl, String serverBaseDir, FileObject sourceRoot) {
        this.serverBaseUrl = serverBaseUrl;
        this.serverBaseDir = serverBaseDir;
        this.sourceRoot= sourceRoot;
        this.serverIsOnWindows = serverBaseDir.contains("\\");
    }
    
    public FileObject getSourceRoot() {
        return sourceRoot;
    }
    
    public String getServerBaseDir() {
        return serverBaseDir;
    }
    
    public DataObject mapToSourceFileDataObject(String sourceFile) {
        DataObject ret = null;
        
        if(null == sourceFile || sourceFile.trim().length() == 0) {
            throw new IllegalArgumentException("sourceFile parameter cannot be null or blank");
        }

        if (!sourceFile.startsWith(serverBaseDir)) {
            throw new IllegalArgumentException("sourceFile: " + sourceFile + " outside serverBaseDir: " + serverBaseDir);
        }

        ret = sourceFileMap.get(sourceFile);
        
        if (ret != null) {
            return ret;
        }
        
        String s = sourceFile.substring(serverBaseDir.length());
        
        if (s.startsWith("/") || s.startsWith("\\")) {
            s = s.substring(1);
        }
        
        
        FileObject fo = sourceRoot.getFileObject(s);
        
        try {
            ret = DataObject.find(fo);
            sourceFileMap.put(sourceFile, ret);
        }
        catch (DataObjectNotFoundException donfe) {
            ErrorManager.getDefault().notify(ErrorManager.WARNING, donfe);
        }
        
        return ret;
    }

    public String mapToServerPath(FileObject fo) {
        if (fo == null) {
            return null;
        }
        
        if (fo.equals(sourceRoot)) {
            return serverBaseDir;
        }
        
        FileObject parent = fo.getParent();
        
        while (parent != null && !parent.equals(sourceRoot)) {
            parent = parent.getParent();
        }
        
        if (parent == null) {
                // This fileObject does not live within our sourceRoot. 
            return null;
        }
        
        String relSourceFile = fo.getPath().substring(sourceRoot.getPath().length());
        String targetFile = serverBaseDir + relSourceFile;

        if (serverIsOnWindows) {
            targetFile = targetFile.replace('/', '\\');
        }
        
        return targetFile;
   }
}
