/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.scripting.php.dbginterface.api.VariableNode;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

/**
 *
 * @author Peter Williams
 */
public class VariablesModelFilter extends ModelSupport
        implements TreeModelFilter, TableModelFilter, NodeModelFilter {
    
    // Temporary to default functions to off and test filtering code.
    private static boolean [] filterMap = {
        true, // LOCAL_VARIABLE
        true, // SCRIPT_FIELD
        true, // JAVA_FIELD
        true, // UNDEFINED_FIELD
        true, // SUPER
        true, // SCRIPT_ADAPTER
        false // FUNCTION
    };
    
    public static boolean [] getFilterSettings() {
//        return Arrays.copyOf(filterMap, filterMap.length);
        boolean [] copy = new boolean [filterMap.length];
        System.arraycopy(filterMap, 0, copy, 0, filterMap.length);
        return copy;
    }
    
    public static void setFilters(final boolean [] newFilterMap) {
//        filterMap = Arrays.copyOf(newFilterMap, filterMap.length);
        filterMap = new boolean [filterMap.length];
        System.arraycopy(newFilterMap, 0, filterMap, 0, Math.min(filterMap.length, newFilterMap.length));
    }
    
    // ------------------------------------------------------------------------
    // TreeModel implementation
    // ------------------------------------------------------------------------
    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }
    
    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        Object [] originalChildren = original.getChildren(parent, from, to);
        List<Object> filteredChildren = new ArrayList<Object>(originalChildren.length);
        for(int i = 0; i < originalChildren.length; i++) {
            if(originalChildren[i] != null) {
                if(originalChildren[i] instanceof VariableNode) {
                    if(filterMap[((VariableNode) originalChildren[i]).getType()]) {
                        filteredChildren.add(originalChildren[i]);
                    }
                } else {
                    filteredChildren.add(originalChildren[i]);
                }
            }
        }
        return filteredChildren.toArray(new Object[filteredChildren.size()]);
    }
    
    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        return original.isLeaf(node);
    }
    
    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        return original.getChildrenCount(node);
    }

    // ------------------------------------------------------------------------
    // TableModel implementation
    // ------------------------------------------------------------------------
    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        return original.getValueAt(node, columnID);
    }
    
    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        return original.isReadOnly(node, columnID);
    }
    
    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(node, columnID, value);
    }
    
    // ------------------------------------------------------------------------
    // NodeModel implementation
    // ------------------------------------------------------------------------
    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        return original.getDisplayName(node);
    }
    
    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        return original.getIconBase(node);
    }
    
    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        return original.getShortDescription(node);
    }
}
