/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 * 
 * Contributor(s):
 * 
 * Portions Copyrighted 2007 Sun Microsystems, Inc.
 */

package org.netbeans.modules.ruby.extrahints.introduce;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.jruby.ast.Node;
import org.netbeans.api.gsf.CompilationInfo;
import org.netbeans.api.gsf.NameKind;
import org.netbeans.api.gsf.OffsetRange;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.openide.util.Exceptions;

/**
 * A lot of this code logically belongs in ruby/editing, but I'm trying to stay
 * 6.0 compatible {@see CopiedCode} so I'm keeping it here for a while until moving it
 * into LexUtilities, AstUtilities etc.
 * @author Tor Norbye
 */
public class HintUtilities {
    public static String guessName(CompilationInfo info, OffsetRange lexRange, OffsetRange astRange) {
        String guessedName = "";
        
        // Try to guess the name - see if it's in a method and if so name it after the parameter
        IndexedMethod[] methodHolder = new IndexedMethod[1];
        @SuppressWarnings("unchecked")
        Set<IndexedMethod>[] alternatesHolder = new Set[1];
        int[] paramIndexHolder = new int[1];
        int[] anchorOffsetHolder = new int[1];
        if (!CopiedCode.computeMethodCall(info, lexRange.getStart(), astRange.getStart(),
                methodHolder, paramIndexHolder, anchorOffsetHolder, alternatesHolder)) {

            return guessedName;
        }

        IndexedMethod targetMethod = methodHolder[0];
        int index = paramIndexHolder[0];

        List<String> params = targetMethod.getParameters();
        if (params == null || params.size() <= index) {
            return guessedName;
        }
        
        return params.get(index);
    }
    
    public static Set<String> getUsedFields(RubyIndex index, AstPath path) {
        String fqn = AstUtilities.getFqnName(path);
        if (fqn == null || fqn.length() == 0) {
            return Collections.emptySet();
        }
        Set<IndexedField> fields = index.getInheritedFields(fqn, "", NameKind.PREFIX, false);
        Set<String> fieldNames = new HashSet<String>();
        for (IndexedField f : fields) {
            fieldNames.add(f.getName());
        }
        
        return fieldNames;
    }
    
    public static Set<String> getUsedMethods(RubyIndex index, AstPath path) {
        String fqn = AstUtilities.getFqnName(path);
        if (fqn == null || fqn.length() == 0) {
            return Collections.emptySet();
        }
        Set<IndexedMethod> methods = index.getInheritedMethods(fqn, "", NameKind.PREFIX);
        Set<String> methodNames = new HashSet<String>();
        for (IndexedMethod m : methods) {
            methodNames.add(m.getName());
        }
        
        return methodNames;
    }
    
    /** @todo Implement properly */
    public static Set<String> getUsedConstants(RubyIndex index, AstPath path) {
        //String fqn = AstUtilities.getFqnName(path);
        //if (fqn == null || fqn.length() == 0) {
            return Collections.emptySet();
        //}
        //Set<IndexedConstant> constants = index.getInheritedConstants(fqn, "", NameKind.PREFIX);
        //Set<String> constantNames = new HashSet<String>();
        //for (IndexedConstant m : constants) {
        //    constantNames.add(m.getName());
        //}
        //
        //return constantNames;
    }
    
    public static Set<String> getUsedLocalNames(AstPath path, Node closest) {
        Node method = AstUtilities.findLocalScope(closest, path);
        Map<String, Node> variables = new HashMap<String, Node>();
        // Add locals
        CopiedCode.addLocals(method, variables);

        List<Node> applicableBlocks = AstUtilities.getApplicableBlocks(path, false);
        for (Node block : applicableBlocks) {
            CopiedCode.addDynamic(block, variables);
        }
        
        return variables.keySet();
    }
    
    // Ths method logically belongs in LexUtilities - add it there when I cut 6.0 compatibility
    /**
     * Get the rdoc documentation associated with the given node in the given document.
     * The node must have position information that matches the source in the document.
     */
    public static OffsetRange findRDocRange(BaseDocument baseDoc, int methodBegin) {
        int begin = methodBegin;
        try {
            if (methodBegin >= baseDoc.getLength()) {
                return OffsetRange.NONE;
            }

            // Search to previous lines, locate comments. Once we have a non-whitespace line that isn't
            // a comment, we're done

            int offset = Utilities.getRowStart(baseDoc, methodBegin);
            offset--;

            // Skip empty and whitespace lines
            while (offset >= 0) {
                // Find beginning of line
                offset = Utilities.getRowStart(baseDoc, offset);

                if (!Utilities.isRowEmpty(baseDoc, offset) &&
                        !Utilities.isRowWhite(baseDoc, offset)) {
                    break;
                }

                offset--;
            }

            if (offset < 0) {
                return OffsetRange.NONE;
            }

            while (offset >= 0) {
                // Find beginning of line
                offset = Utilities.getRowStart(baseDoc, offset);

                if (Utilities.isRowEmpty(baseDoc, offset) || Utilities.isRowWhite(baseDoc, offset)) {
                    // Empty lines not allowed within an rdoc
                    break;
                }

                // This is a comment line we should include
                int lineBegin = Utilities.getRowFirstNonWhite(baseDoc, offset);
                int lineEnd = Utilities.getRowLastNonWhite(baseDoc, offset) + 1;
                String line = baseDoc.getText(lineBegin, lineEnd - lineBegin);

                // Tolerate "public", "private" and "protected" here --
                // Test::Unit::Assertions likes to put these in front of each
                // method.
                if (line.startsWith("#")) {
                    begin = lineBegin;
                } else if (line.startsWith("=end") &&
                        (lineBegin == Utilities.getRowStart(baseDoc, offset))) {
                    // It could be a =begin,=end document - see scanf.rb in Ruby lib for example. Treat this differently.
                    int docBegin = findInlineDocStart(baseDoc, offset);
                    if (docBegin != -1) {
                        begin = docBegin;
                    } else {
                        return OffsetRange.NONE;
                    }
                } else if (line.equals("public") || line.equals("private") ||
                        line.equals("protected")) { // NOI18N
                                                    // Skip newlines back up to the comment
                    offset--;

                    while (offset >= 0) {
                        // Find beginning of line
                        offset = Utilities.getRowStart(baseDoc, offset);

                        if (!Utilities.isRowEmpty(baseDoc, offset) &&
                                !Utilities.isRowWhite(baseDoc, offset)) {
                            break;
                        }

                        offset--;
                    }

                    continue;
                } else {
                    // No longer in a comment
                    break;
                }

                // Previous line
                offset--;
            }
        } catch (BadLocationException ble) {
            Exceptions.printStackTrace(ble);
        }

        if (methodBegin > begin) {
            return new OffsetRange(begin, methodBegin);
        } else {
            return OffsetRange.NONE;
        }
    }
    
    private static int findInlineDocStart(BaseDocument baseDoc, int offset) throws BadLocationException {
        // offset points to a line containing =end
        // Skip the =end list
        offset = Utilities.getRowStart(baseDoc, offset);
        offset--;

        // Search backwards in the document for the =begin (if any) and add all lines in reverse
        // order in between.
        while (offset >= 0) {
            // Find beginning of line
            offset = Utilities.getRowStart(baseDoc, offset);

            // This is a comment line we should include
            int lineBegin = offset;
            int lineEnd = Utilities.getRowEnd(baseDoc, offset);
            String line = baseDoc.getText(lineBegin, lineEnd - lineBegin);

            if (line.startsWith("=begin")) {
                // We're done!
                return lineBegin;
            }

            // Previous line
            offset--;
        }
        
        return -1;
    }
}
